/* puzzle-view.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE
};
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self, gchar value);
static gchar* _vala_array_dup7 (gchar* self, int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
static gchar* _vala_array_dup8 (gchar* self, int length);
static gchar* _vala_array_dup9 (gchar* self, int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject* obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) g_object_new (object_type, NULL);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 250);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_load_image (self);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return self;
#line 158 "puzzle-view.c"
}


PuzzleView* puzzle_view_new (void) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
#line 165 "puzzle-view.c"
}


static void puzzle_view_load_image (PuzzleView* self) {
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 180 "puzzle-view.c"
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		RsvgHandle* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = self->priv->image_filepath;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = _tmp3_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "puzzle-view.c"
			goto __catch7_g_error;
		}
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp1_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (self->priv->tiles_handle);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->tiles_handle = _tmp4_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (_tmp1_);
#line 207 "puzzle-view.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		e = _inner_error_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_inner_error_ = NULL;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = stderr;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = e;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = _tmp6_->message;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp5_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp7_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = stderr;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->image_filepath;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp8_, "%s %s\n", "image path:", _tmp9_);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		exit (EXIT_FAILURE);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_g_error_free0 (e);
#line 240 "puzzle-view.c"
	}
	__finally7:
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		return;
#line 251 "puzzle-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 259 "puzzle-view.c"
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp26_ = NULL;
	GdkRGBA _tmp27_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp28_ = NULL;
	GdkRGBA _tmp29_ = {0};
	cairo_t* _tmp30_ = NULL;
	GdkRGBA _tmp31_ = {0};
	cairo_t* _tmp32_ = NULL;
	gint width = 0;
	gint _tmp33_ = 0;
	gint height = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	GdkRGBA _tmp36_ = {0};
	cairo_t* _tmp37_ = NULL;
	gdouble kwidth = 0.0;
	Puzzle* _tmp38_ = NULL;
	Puzzle* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gdouble kheight = 0.0;
	Puzzle* _tmp43_ = NULL;
	Puzzle* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gdouble _tmp49_ = 0.0;
	gint _tmp50_ = 0;
	gdouble _tmp51_ = 0.0;
	cairo_t* _tmp52_ = NULL;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	cairo_t* _tmp57_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_tile_size (self);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = self->priv->render_size;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != _tmp2_) {
#line 322 "puzzle-view.c"
		RsvgHandle* _tmp3_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = self->priv->tiles_handle;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp3_ != NULL) {
#line 330 "puzzle-view.c"
			gint height = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint width = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			cairo_t* _tmp8_ = NULL;
			cairo_surface_t* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			cairo_surface_t* _tmp12_ = NULL;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp13_ = NULL;
			cairo_t* _tmp14_ = NULL;
			gdouble sfw = 0.0;
			gint _tmp15_ = 0;
			gdouble sfh = 0.0;
			gint _tmp16_ = 0;
			cairo_t* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			RsvgHandle* _tmp20_ = NULL;
			cairo_t* _tmp21_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp4_ = puzzle_view_get_tile_size (self);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp5_ = _tmp4_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			height = _tmp5_ * 2;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = puzzle_view_get_tile_size (self);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp7_ = _tmp6_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp8_ = cr;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp9_ = cairo_get_target (_tmp8_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp10_ = width;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp11_ = height;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp11_);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_cairo_surface_destroy0 (self->priv->surface);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->surface = _tmp12_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = self->priv->surface;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = cairo_create (_tmp13_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			c = _tmp14_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = width;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			sfw = ((gdouble) _tmp15_) / 918;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = height;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			sfh = ((gdouble) _tmp16_) / 68;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = c;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = sfw;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = sfh;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			cairo_scale (_tmp17_, _tmp18_, _tmp19_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = self->priv->tiles_handle;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = c;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_cairo_destroy0 (c);
#line 410 "puzzle-view.c"
		}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_view_get_tile_size (self);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp23_ = _tmp22_;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->render_size = _tmp23_;
#line 418 "puzzle-view.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	style = _tmp25_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = style;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_color (_tmp26_, GTK_STATE_FLAG_NORMAL, &_tmp27_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	fg = _tmp27_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = style;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp28_, GTK_STATE_FLAG_NORMAL, &_tmp29_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp29_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp30_ = cr;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp31_ = bg;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp30_, &_tmp31_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp32_ = cr;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_paint (_tmp32_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp33_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	width = _tmp33_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp34_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	height = _tmp34_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp35_ = cr;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp36_ = fg;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp35_, &_tmp36_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp37_ = cr;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_set_line_width (_tmp37_, 1.0);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp38_ = puzzle_view_get_puzzle (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp39_ = _tmp38_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp40_ = _tmp39_->width;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp41_ = puzzle_view_get_tile_size (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp42_ = _tmp41_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	kwidth = ((_tmp40_ * _tmp42_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp43_ = puzzle_view_get_puzzle (self);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp44_ = _tmp43_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp45_ = _tmp44_->height;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp46_ = puzzle_view_get_tile_size (self);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp47_ = _tmp46_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	kheight = ((_tmp45_ * _tmp47_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp48_ = width;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp49_ = kwidth;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (_tmp48_ - _tmp49_) / 2.0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = height;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = kheight;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (_tmp50_ - _tmp51_) / 2.0;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = cr;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = self->priv->kx;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = self->priv->ky;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp55_ = kwidth;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp56_ = kheight;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_rectangle (_tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp57_ = cr;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_stroke (_tmp57_);
#line 518 "puzzle-view.c"
	{
		gint y = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		y = 0;
#line 523 "puzzle-view.c"
		{
			gboolean _tmp58_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp58_ = TRUE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			while (TRUE) {
#line 530 "puzzle-view.c"
				gint _tmp60_ = 0;
				Puzzle* _tmp61_ = NULL;
				Puzzle* _tmp62_ = NULL;
				gint _tmp63_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (!_tmp58_) {
#line 537 "puzzle-view.c"
					gint _tmp59_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp59_ = y;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					y = _tmp59_ + 1;
#line 543 "puzzle-view.c"
				}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp58_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp60_ = y;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp61_ = puzzle_view_get_puzzle (self);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp62_ = _tmp61_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp63_ = _tmp62_->height;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (!(_tmp60_ < _tmp63_)) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					break;
#line 559 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					x = 0;
#line 565 "puzzle-view.c"
					{
						gboolean _tmp64_ = FALSE;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
						_tmp64_ = TRUE;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
						while (TRUE) {
#line 572 "puzzle-view.c"
							gint _tmp66_ = 0;
							Puzzle* _tmp67_ = NULL;
							Puzzle* _tmp68_ = NULL;
							gint _tmp69_ = 0;
							cairo_t* _tmp70_ = NULL;
							gint _tmp71_ = 0;
							gint _tmp72_ = 0;
							gdouble _tmp73_ = 0.0;
							gdouble _tmp74_ = 0.0;
							gchar _tmp75_ = '\0';
							gchar _tmp76_ = '\0';
							Puzzle* _tmp77_ = NULL;
							Puzzle* _tmp78_ = NULL;
							Puzzle* _tmp79_ = NULL;
							Puzzle* _tmp80_ = NULL;
							gchar* _tmp81_ = NULL;
							gint _tmp81__length1 = 0;
							gint _tmp82_ = 0;
							gint _tmp83_ = 0;
							gchar _tmp84_ = '\0';
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (!_tmp64_) {
#line 595 "puzzle-view.c"
								gint _tmp65_ = 0;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp65_ = x;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								x = _tmp65_ + 1;
#line 601 "puzzle-view.c"
							}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp64_ = FALSE;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp66_ = x;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp67_ = puzzle_view_get_puzzle (self);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp68_ = _tmp67_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp69_ = _tmp68_->width;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (!(_tmp66_ < _tmp69_)) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								break;
#line 617 "puzzle-view.c"
							}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp70_ = cr;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp71_ = x;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp72_ = y;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp73_ = self->priv->kx;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp74_ = self->priv->ky;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							puzzle_view_draw_square (self, _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp74_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp75_ = puzzle_view_get_piece_id (self);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp76_ = _tmp75_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp77_ = puzzle_view_get_puzzle (self);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp78_ = _tmp77_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp79_ = puzzle_view_get_puzzle (self);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp80_ = _tmp79_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp81_ = _tmp80_->map;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp81__length1 = _tmp80_->map_length1;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp82_ = x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp83_ = y;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							_tmp84_ = puzzle_get_piece_id (_tmp78_, _tmp81_, _tmp81__length1, _tmp82_, _tmp83_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
							if (_tmp76_ == _tmp84_) {
#line 655 "puzzle-view.c"
								cairo_t* _tmp85_ = NULL;
								GdkRGBA _tmp86_ = {0};
								cairo_t* _tmp87_ = NULL;
								gint _tmp88_ = 0;
								gint _tmp89_ = 0;
								gint _tmp90_ = 0;
								gdouble _tmp91_ = 0.0;
								gint _tmp92_ = 0;
								gint _tmp93_ = 0;
								gint _tmp94_ = 0;
								gdouble _tmp95_ = 0.0;
								gint _tmp96_ = 0;
								gint _tmp97_ = 0;
								gint _tmp98_ = 0;
								gint _tmp99_ = 0;
								cairo_t* _tmp100_ = NULL;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp85_ = cr;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.red = 1.0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.green = 1.0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.blue = 1.0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp86_.alpha = 0.2;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								gdk_cairo_set_source_rgba (_tmp85_, &_tmp86_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp87_ = cr;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp88_ = x;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp89_ = puzzle_view_get_tile_size (self);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp90_ = _tmp89_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp91_ = self->priv->kx;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp92_ = y;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp93_ = puzzle_view_get_tile_size (self);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp94_ = _tmp93_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp95_ = self->priv->ky;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp96_ = puzzle_view_get_tile_size (self);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp97_ = _tmp96_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp98_ = puzzle_view_get_tile_size (self);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp99_ = _tmp98_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								cairo_rectangle (_tmp87_, (_tmp88_ * _tmp90_) + _tmp91_, (_tmp92_ * _tmp94_) + _tmp95_, (gdouble) _tmp97_, (gdouble) _tmp99_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								_tmp100_ = cr;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
								cairo_fill (_tmp100_);
#line 716 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 730 "puzzle-view.c"
}


static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky) {
	GdkRectangle rect = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp14_ = NULL;
	GdkRGBA _tmp15_ = {0};
	cairo_t* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	cairo_t* _tmp18_ = NULL;
	GdkRGBA _tmp19_ = {0};
	cairo_t* _tmp20_ = NULL;
	Puzzle* _tmp21_ = NULL;
	Puzzle* _tmp22_ = NULL;
	Puzzle* _tmp23_ = NULL;
	Puzzle* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gchar _tmp28_ = '\0';
	Puzzle* _tmp47_ = NULL;
	Puzzle* _tmp48_ = NULL;
	Puzzle* _tmp49_ = NULL;
	Puzzle* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gchar _tmp54_ = '\0';
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (cr != NULL);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = x;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_tile_size (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = kx;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.x = (((_tmp0_ * _tmp2_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp3_)) - 1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = y;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_tile_size (self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = ky;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.y = (((_tmp4_ * _tmp6_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp7_)) - 1;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = puzzle_view_get_tile_size (self);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = _tmp8_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.width = _tmp9_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp10_ = puzzle_view_get_tile_size (self);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = _tmp10_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	rect.height = _tmp11_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	style = _tmp13_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp14_ = style;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp15_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp16_ = cr;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp17_ = rect;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_rectangle (_tmp16_, &_tmp17_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp18_ = cr;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp19_ = bg;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp20_ = cr;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	cairo_fill (_tmp20_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp21_ = puzzle_view_get_puzzle (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp22_ = _tmp21_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp23_ = puzzle_view_get_puzzle (self);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = _tmp23_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _tmp24_->map;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp25__length1 = _tmp24_->map_length1;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = x;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp27_ = y;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = puzzle_get_piece_id (_tmp22_, _tmp25_, _tmp25__length1, _tmp26_, _tmp27_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp28_ != ' ') {
#line 863 "puzzle-view.c"
		cairo_t* _tmp29_ = NULL;
		GdkRectangle _tmp30_ = {0};
		cairo_t* _tmp31_ = NULL;
		cairo_surface_t* _tmp32_ = NULL;
		GdkRectangle _tmp33_ = {0};
		gint _tmp34_ = 0;
		Puzzle* _tmp35_ = NULL;
		Puzzle* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		cairo_t* _tmp46_ = NULL;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp29_ = cr;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp30_ = rect;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		gdk_cairo_rectangle (_tmp29_, &_tmp30_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = cr;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = self->priv->surface;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = rect;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = _tmp33_.x;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = puzzle_view_get_puzzle (self);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp36_ = _tmp35_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp37_ = x;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = y;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = puzzle_get_piece_nr (_tmp36_, _tmp37_, _tmp38_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = puzzle_view_get_tile_size (self);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = _tmp40_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = rect;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = _tmp42_.y;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = puzzle_view_get_tile_size (self);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp45_ = _tmp44_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp31_, _tmp32_, (gdouble) (_tmp34_ - (_tmp39_ * _tmp41_)), (gdouble) (_tmp43_ - (_tmp45_ / 2)));
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp46_ = cr;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp46_);
#line 924 "puzzle-view.c"
	}
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp47_ = puzzle_view_get_puzzle (self);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp48_ = _tmp47_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp49_ = puzzle_view_get_puzzle (self);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = _tmp49_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = _tmp50_->map;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp51__length1 = _tmp50_->map_length1;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = x;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = y;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = puzzle_get_piece_id (_tmp48_, _tmp51_, _tmp51__length1, _tmp52_, _tmp53_);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp54_ == '*') {
#line 946 "puzzle-view.c"
		gint value = 0;
		Puzzle* _tmp55_ = NULL;
		Puzzle* _tmp56_ = NULL;
		Puzzle* _tmp57_ = NULL;
		Puzzle* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gchar _tmp62_ = '\0';
		gint overlay_size = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint overlay_offset = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		cairo_t* _tmp68_ = NULL;
		GdkRectangle _tmp69_ = {0};
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		GdkRectangle _tmp72_ = {0};
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		cairo_t* _tmp77_ = NULL;
		cairo_surface_t* _tmp78_ = NULL;
		GdkRectangle _tmp79_ = {0};
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		GdkRectangle _tmp84_ = {0};
		gint _tmp85_ = 0;
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		cairo_t* _tmp88_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		value = 22;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp55_ = puzzle_view_get_puzzle (self);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp56_ = _tmp55_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp57_ = puzzle_view_get_puzzle (self);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp58_ = _tmp57_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp59_ = _tmp58_->orig_map;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp59__length1 = _tmp58_->orig_map_length1;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp60_ = x;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp61_ = y;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp62_ = puzzle_get_piece_id (_tmp56_, _tmp59_, _tmp59__length1, _tmp60_, _tmp61_);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp62_ == '.') {
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			value = 20;
#line 1009 "puzzle-view.c"
		}
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp63_ = puzzle_view_get_tile_size (self);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp64_ = _tmp63_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp64_) / PUZZLE_VIEW_THEME_TILE_SIZE;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp65_ = puzzle_view_get_tile_size (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp66_ = _tmp65_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp67_ = overlay_size;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp66_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp67_ / 2);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp68_ = cr;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp69_ = rect;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp70_ = _tmp69_.x;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp71_ = overlay_offset;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp72_ = rect;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp73_ = _tmp72_.y;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp74_ = overlay_offset;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp75_ = overlay_size;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp76_ = overlay_size;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp71_), (gdouble) (_tmp73_ + _tmp74_), (gdouble) _tmp75_, (gdouble) _tmp76_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp77_ = cr;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp78_ = self->priv->surface;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp79_ = rect;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp80_ = _tmp79_.x;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp81_ = value;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp82_ = puzzle_view_get_tile_size (self);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp83_ = _tmp82_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp84_ = rect;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp85_ = _tmp84_.y;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp86_ = puzzle_view_get_tile_size (self);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp87_ = _tmp86_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp77_, _tmp78_, (gdouble) (_tmp80_ - (_tmp81_ * _tmp83_)), (gdouble) (_tmp85_ - (_tmp87_ / 2)));
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp88_ = cr;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp88_);
#line 1073 "puzzle-view.c"
	}
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 1077 "puzzle-view.c"
}


static gchar* _vala_array_dup7 (gchar* self, int length) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1084 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = event;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_->button;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1103 "puzzle-view.c"
		Puzzle* _tmp2_ = NULL;
		Puzzle* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar new_piece_id = '\0';
		Puzzle* _tmp15_ = NULL;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		Puzzle* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gchar _tmp22_ = '\0';
		gboolean _tmp23_ = FALSE;
		gchar _tmp24_ = '\0';
		gchar _tmp25_ = '\0';
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gchar _tmp31_ = '\0';
		gchar _tmp38_ = '\0';
		Puzzle* _tmp39_ = NULL;
		Puzzle* _tmp40_ = NULL;
		Puzzle* _tmp41_ = NULL;
		Puzzle* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gchar* _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = puzzle_view_get_puzzle (self);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = puzzle_game_over (_tmp3_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp4_) {
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1156 "puzzle-view.c"
		}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = event;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_->x;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = self->priv->kx;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = puzzle_view_get_tile_size (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = _tmp8_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_x = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = event;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_->y;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp12_ = self->priv->ky;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp13_ = puzzle_view_get_tile_size (self);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp14_ = _tmp13_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_y = ((gint) (_tmp11_ - _tmp12_)) / _tmp14_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = puzzle_view_get_puzzle (self);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = _tmp15_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = puzzle_view_get_puzzle (self);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp19_ = _tmp18_->map;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp19__length1 = _tmp18_->map_length1;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp20_ = self->priv->piece_x;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp21_ = self->priv->piece_y;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_get_piece_id (_tmp16_, _tmp19_, _tmp19__length1, _tmp20_, _tmp21_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_id = _tmp22_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp24_ = puzzle_view_get_piece_id (self);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp25_ = _tmp24_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp25_ != '\0') {
#line 1208 "puzzle-view.c"
			gboolean _tmp26_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = self->priv->piece_unmoved;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp26_;
#line 1214 "puzzle-view.c"
		} else {
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = FALSE;
#line 1218 "puzzle-view.c"
		}
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp23_) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			puzzle_view_set_piece_id (self, '\0');
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1228 "puzzle-view.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = new_piece_id;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp31_ == ' ') {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = TRUE;
#line 1236 "puzzle-view.c"
		} else {
			gchar _tmp32_ = '\0';
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp32_ = new_piece_id;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = _tmp32_ == '.';
#line 1243 "puzzle-view.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp30_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = TRUE;
#line 1249 "puzzle-view.c"
		} else {
			gchar _tmp33_ = '\0';
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp33_ = new_piece_id;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = _tmp33_ == '-';
#line 1256 "puzzle-view.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp29_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = TRUE;
#line 1262 "puzzle-view.c"
		} else {
			gchar _tmp34_ = '\0';
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp34_ = new_piece_id;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = _tmp34_ == '#';
#line 1269 "puzzle-view.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp28_) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = TRUE;
#line 1275 "puzzle-view.c"
		} else {
			gchar _tmp35_ = '\0';
			gchar _tmp36_ = '\0';
			gchar _tmp37_ = '\0';
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp35_ = new_piece_id;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = puzzle_view_get_piece_id (self);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = _tmp36_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = _tmp35_ == _tmp37_;
#line 1288 "puzzle-view.c"
		}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp27_) {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1296 "puzzle-view.c"
		}
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_unmoved = TRUE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = new_piece_id;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, _tmp38_);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = puzzle_view_get_puzzle (self);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = _tmp39_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = puzzle_view_get_puzzle (self);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = _tmp41_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = _tmp42_->map;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp43__length1 = _tmp42_->map_length1;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup7 (_tmp43_, _tmp43__length1) : ((gpointer) _tmp43_);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp44__length1 = _tmp43__length1;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = (g_free (_tmp40_->move_map), NULL);
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = _tmp44_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map_length1 = _tmp44__length1;
#line 1326 "puzzle-view.c"
	}
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1332 "puzzle-view.c"
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1339 "puzzle-view.c"
}


static gchar* _vala_array_dup9 (gchar* self, int length) {
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1346 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = event;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_->button;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp2_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1366 "puzzle-view.c"
		gchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = puzzle_view_get_piece_id (self);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp3_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = _tmp4_ != '\0';
#line 1375 "puzzle-view.c"
	} else {
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = FALSE;
#line 1379 "puzzle-view.c"
	}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_) {
#line 1383 "puzzle-view.c"
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		Puzzle* _tmp7_ = NULL;
		Puzzle* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		gchar _tmp10_ = '\0';
		gboolean _tmp11_ = FALSE;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = self->priv->piece_unmoved;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp5_) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1399 "puzzle-view.c"
		}
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = puzzle_view_get_puzzle (self);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = puzzle_view_get_piece_id (self);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = _tmp9_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = puzzle_movable (_tmp8_, (gint) _tmp10_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp11_) {
#line 1413 "puzzle-view.c"
			Puzzle* _tmp12_ = NULL;
			Puzzle* _tmp13_ = NULL;
			Puzzle* _tmp14_ = NULL;
			Puzzle* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			Puzzle* _tmp17_ = NULL;
			Puzzle* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			gboolean _tmp20_ = FALSE;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = puzzle_view_get_puzzle (self);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp12_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = puzzle_view_get_puzzle (self);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = _tmp14_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = _tmp15_->move_map;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp16__length1 = _tmp15_->move_map_length1;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = puzzle_view_get_puzzle (self);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = _tmp17_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = _tmp18_->map;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19__length1 = _tmp18_->map_length1;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = puzzle_mapcmp (_tmp13_, _tmp16_, _tmp16__length1, _tmp19_, _tmp19__length1);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = _tmp20_;
#line 1449 "puzzle-view.c"
		} else {
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = FALSE;
#line 1453 "puzzle-view.c"
		}
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp6_) {
#line 1457 "puzzle-view.c"
			gboolean _tmp21_ = FALSE;
			gchar _tmp22_ = '\0';
			gboolean _tmp38_ = FALSE;
			Puzzle* _tmp39_ = NULL;
			Puzzle* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			Puzzle* _tmp56_ = NULL;
			Puzzle* _tmp57_ = NULL;
			Puzzle* _tmp58_ = NULL;
			Puzzle* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			gchar* _tmp61_ = NULL;
			gint _tmp61__length1 = 0;
			Puzzle* _tmp62_ = NULL;
			Puzzle* _tmp63_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = self->priv->last_piece_id;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp22_ == '\0') {
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = TRUE;
#line 1480 "puzzle-view.c"
			} else {
				gchar _tmp23_ = '\0';
				gchar _tmp24_ = '\0';
				gchar _tmp25_ = '\0';
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp23_ = self->priv->last_piece_id;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp24_ = puzzle_view_get_piece_id (self);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp25_ = _tmp24_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = _tmp23_ != _tmp25_;
#line 1493 "puzzle-view.c"
			}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp21_) {
#line 1497 "puzzle-view.c"
				Puzzle* _tmp26_ = NULL;
				Puzzle* _tmp27_ = NULL;
				Puzzle* _tmp28_ = NULL;
				Puzzle* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				gchar* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				Puzzle* _tmp32_ = NULL;
				Puzzle* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp26_ = puzzle_view_get_puzzle (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_ = _tmp26_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp28_ = puzzle_view_get_puzzle (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp29_ = _tmp28_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp30_ = _tmp29_->lastmove_map;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp30__length1 = _tmp29_->lastmove_map_length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup8 (_tmp30_, _tmp30__length1) : ((gpointer) _tmp30_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp31__length1 = _tmp30__length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = (g_free (_tmp27_->undomove_map), NULL);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = _tmp31_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map_length1 = _tmp31__length1;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp32_ = puzzle_view_get_puzzle (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp33_ = _tmp32_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp34_ = _tmp33_->moves;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				if (_tmp34_ < 999) {
#line 1539 "puzzle-view.c"
					Puzzle* _tmp35_ = NULL;
					Puzzle* _tmp36_ = NULL;
					gint _tmp37_ = 0;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp35_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp36_ = _tmp35_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp37_ = _tmp36_->moves;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
					_tmp36_->moves = _tmp37_ + 1;
#line 1551 "puzzle-view.c"
				}
			}
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp39_ = puzzle_view_get_puzzle (self);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp40_ = _tmp39_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp41_ = _tmp40_->moves;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp41_ > 0) {
#line 1562 "puzzle-view.c"
				Puzzle* _tmp42_ = NULL;
				Puzzle* _tmp43_ = NULL;
				Puzzle* _tmp44_ = NULL;
				Puzzle* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				Puzzle* _tmp47_ = NULL;
				Puzzle* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gboolean _tmp50_ = FALSE;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp42_ = puzzle_view_get_puzzle (self);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp43_ = _tmp42_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp44_ = puzzle_view_get_puzzle (self);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp45_ = _tmp44_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp46_ = _tmp45_->undomove_map;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp46__length1 = _tmp45_->undomove_map_length1;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp47_ = puzzle_view_get_puzzle (self);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp48_ = _tmp47_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp49_ = _tmp48_->map;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp49__length1 = _tmp48_->map_length1;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp50_ = puzzle_mapcmp (_tmp43_, _tmp46_, _tmp46__length1, _tmp49_, _tmp49__length1);
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = !_tmp50_;
#line 1598 "puzzle-view.c"
			} else {
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = FALSE;
#line 1602 "puzzle-view.c"
			}
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			if (_tmp38_) {
#line 1606 "puzzle-view.c"
				Puzzle* _tmp51_ = NULL;
				Puzzle* _tmp52_ = NULL;
				gint _tmp53_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp51_ = puzzle_view_get_puzzle (self);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp52_ = _tmp51_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp53_ = _tmp52_->moves;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp52_->moves = _tmp53_ - 1;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = '\0';
#line 1620 "puzzle-view.c"
			} else {
				gchar _tmp54_ = '\0';
				gchar _tmp55_ = '\0';
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp54_ = puzzle_view_get_piece_id (self);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				_tmp55_ = _tmp54_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = _tmp55_;
#line 1630 "puzzle-view.c"
			}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp56_ = puzzle_view_get_puzzle (self);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_ = _tmp56_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp58_ = puzzle_view_get_puzzle (self);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp59_ = _tmp58_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp60_ = _tmp59_->map;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp60__length1 = _tmp59_->map_length1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp61_ = (_tmp60_ != NULL) ? _vala_array_dup9 (_tmp60_, _tmp60__length1) : ((gpointer) _tmp60_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp61__length1 = _tmp60__length1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = (g_free (_tmp57_->lastmove_map), NULL);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = _tmp61_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map_length1 = _tmp61__length1;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp62_ = puzzle_view_get_puzzle (self);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp63_ = _tmp62_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			g_signal_emit_by_name (_tmp63_, "moved");
#line 1660 "puzzle-view.c"
		}
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, '\0');
#line 1664 "puzzle-view.c"
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1670 "puzzle-view.c"
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_ = '\0';
	gchar _tmp1_ = '\0';
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_piece_id (self);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != '\0') {
#line 1691 "puzzle-view.c"
		GdkEventMotion* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkEventMotion* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		Puzzle* _tmp16_ = NULL;
		Puzzle* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		Puzzle* _tmp27_ = NULL;
		Puzzle* _tmp28_ = NULL;
		gchar _tmp29_ = '\0';
		gchar _tmp30_ = '\0';
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gboolean _tmp35_ = FALSE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = event;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_->x;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = self->priv->kx;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = puzzle_view_get_tile_size (self);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = event;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_->y;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->ky;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = puzzle_view_get_tile_size (self);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		new_piece_y = ((gint) (_tmp8_ - _tmp9_)) / _tmp11_;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = new_piece_x;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = puzzle_view_get_puzzle (self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = _tmp16_;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_->width;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp15_ >= _tmp18_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = TRUE;
#line 1754 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = event;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = _tmp19_->x;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = _tmp20_ < ((gdouble) 0);
#line 1764 "puzzle-view.c"
		}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp14_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = TRUE;
#line 1770 "puzzle-view.c"
		} else {
			gint _tmp21_ = 0;
			Puzzle* _tmp22_ = NULL;
			Puzzle* _tmp23_ = NULL;
			gint _tmp24_ = 0;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = new_piece_y;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = puzzle_view_get_puzzle (self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp22_;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp24_ = _tmp23_->height;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp21_ >= _tmp24_;
#line 1786 "puzzle-view.c"
		}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp13_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = TRUE;
#line 1792 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp25_ = NULL;
			gdouble _tmp26_ = 0.0;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp25_ = event;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = _tmp25_->y;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = _tmp26_ < ((gdouble) 0);
#line 1802 "puzzle-view.c"
		}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp12_) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1810 "puzzle-view.c"
		}
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp27_ = puzzle_view_get_puzzle (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp28_ = _tmp27_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp29_ = puzzle_view_get_piece_id (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp30_ = _tmp29_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = self->priv->piece_x;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = self->priv->piece_y;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = new_piece_x;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = new_piece_y;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = puzzle_move_piece (_tmp28_, _tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		if (_tmp35_) {
#line 1832 "puzzle-view.c"
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_unmoved = FALSE;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = new_piece_x;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_x = _tmp36_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = new_piece_y;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_y = _tmp37_;
#line 1845 "puzzle-view.c"
		}
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		result = TRUE;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		return result;
#line 1851 "puzzle-view.c"
	}
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1857 "puzzle-view.c"
}


static void puzzle_view_puzzle_changed_cb (PuzzleView* self) {
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1866 "puzzle-view.c"
}


static gchar puzzle_view_get_piece_id (PuzzleView* self) {
	gchar result;
	gchar _tmp0_ = '\0';
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_piece_id;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1881 "puzzle-view.c"
}


static void puzzle_view_set_piece_id (PuzzleView* self, gchar value) {
	gchar _tmp0_ = '\0';
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = value;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = _tmp0_;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1895 "puzzle-view.c"
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_ = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1910 "puzzle-view.c"
}


static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_puzzle_changed_cb ((PuzzleView*) self);
#line 1917 "puzzle-view.c"
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_ = NULL;
	Puzzle* _tmp2_ = NULL;
	Puzzle* _tmp3_ = NULL;
	Puzzle* _tmp4_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 1932 "puzzle-view.c"
		Puzzle* _tmp1_ = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = self->priv->_puzzle;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1938 "puzzle-view.c"
	}
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = value;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = _tmp3_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = self->priv->_puzzle;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_set_piece_id (self, '\0');
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_object_notify ((GObject *) self, "puzzle");
#line 1962 "puzzle-view.c"
}


static gint puzzle_view_get_tile_size (PuzzleView* self) {
	gint result;
	gint s = 0;
	gint _tmp0_ = 0;
	Puzzle* _tmp1_ = NULL;
	Puzzle* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Puzzle* _tmp5_ = NULL;
	Puzzle* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp11_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _tmp2_->width;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = _tmp6_->height;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = MIN ((_tmp0_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp3_, (_tmp4_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp7_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	s = _tmp8_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = s;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	if ((_tmp9_ % 2) != 0) {
#line 2006 "puzzle-view.c"
		gint _tmp10_ = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = s;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		s = _tmp10_ - 1;
#line 2012 "puzzle-view.c"
	}
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = s;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	result = _tmp11_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 2020 "puzzle-view.c"
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->draw = puzzle_view_real_draw;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = puzzle_view_real_button_press_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_release_event = puzzle_view_real_button_release_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = puzzle_view_real_motion_notify_event;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2045 "puzzle-view.c"
}


static void puzzle_view_instance_init (PuzzleView * self) {
	gchar* _tmp0_ = NULL;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->render_size = 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_unmoved = FALSE;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = '\0';
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->last_piece_id = '\0';
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (gdouble) 0;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (gdouble) 0;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->tiles_handle = NULL;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_strdup ("");
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->surface = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = NULL;
#line 2079 "puzzle-view.c"
}


static void puzzle_view_finalize (GObject* obj) {
	PuzzleView * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->tiles_handle);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_cairo_surface_destroy0 (self->priv->surface);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
#line 2097 "puzzle-view.c"
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		g_value_set_object (value, puzzle_view_get_puzzle (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2124 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2130 "puzzle-view.c"
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_puzzle (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2146 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2152 "puzzle-view.c"
	}
}



