/* rygel-media-file-item.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-file-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_FILE_ITEM_ERROR_BAD_URI
} RygelMediaFileItemError;
#define RYGEL_MEDIA_FILE_ITEM_ERROR rygel_media_file_item_error_quark ()
struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelMediaFileItemPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	gint64 _size;
	gboolean _place_holder;
};

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_media_file_item_parent_class = NULL;
extern GRegex* rygel_media_file_item_address_regex;
GRegex* rygel_media_file_item_address_regex = NULL;
extern GeeHashMap* rygel_media_file_item_mime_to_ext;
GeeHashMap* rygel_media_file_item_mime_to_ext = NULL;

GQuark rygel_media_file_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_FILE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemPrivate))
enum  {
	RYGEL_MEDIA_FILE_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_MIME_TYPE,
	RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE,
	RYGEL_MEDIA_FILE_ITEM_SIZE,
	RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS
};
RygelMediaFileItem* rygel_media_file_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
static RygelDataSource* rygel_media_file_item_real_create_stream_source_for_resource (RygelMediaObject* base, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source_for_resource (RygelMediaEngine* self, RygelMediaObject* item, RygelMediaResource* resource, GError** error);
static GUPnPDIDLLiteObject* rygel_media_file_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self, RygelHTTPServer* server);
void rygel_media_object_serialize_resource_list (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPServer* http_server, GError** error);
RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self);
static RygelMediaResource* rygel_media_file_item_real_get_primary_resource (RygelMediaFileItem* self);
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_file_item_get_dlna_profile (RygelMediaFileItem* self);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value);
gchar* rygel_media_file_item_get_extension (RygelMediaFileItem* self);
void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value);
gint64 rygel_media_file_item_get_size (RygelMediaFileItem* self);
void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value);
static gchar* rygel_media_file_item_real_get_extension (RygelMediaFileItem* self);
gchar* rygel_media_file_item_ext_from_mime_type (RygelMediaFileItem* self, const gchar* mime_type);
static void rygel_media_file_item_real_add_additional_resources (RygelMediaFileItem* self, RygelHTTPServer* server);
void rygel_media_file_item_set_mime_type (RygelMediaFileItem* self, const gchar* value);
void rygel_media_file_item_set_dlna_profile (RygelMediaFileItem* self, const gchar* value);
void rygel_media_file_item_set_size (RygelMediaFileItem* self, gint64 value);
void rygel_media_file_item_set_place_holder (RygelMediaFileItem* self, gboolean value);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
static void rygel_media_file_item_finalize (GObject* obj);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
static void _vala_rygel_media_file_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_file_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_media_file_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_file_item_error-quark");
}


RygelMediaFileItem* rygel_media_file_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaFileItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = upnp_class;
	self = (RygelMediaFileItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
	return self;
}


static RygelDataSource* rygel_media_file_item_real_create_stream_source_for_resource (RygelMediaObject* base, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error) {
	RygelMediaFileItem * self;
	RygelDataSource* result = NULL;
	RygelDataSource* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	RygelMediaEngine* _tmp2_ = NULL;
	RygelMediaResource* _tmp3_ = NULL;
	RygelDataSource* _tmp4_ = NULL;
	RygelDataSource* _tmp5_ = NULL;
	RygelDataSource* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaFileItem*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp1_ = rygel_media_engine_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = resource;
	_tmp4_ = rygel_media_engine_create_data_source_for_resource (_tmp2_, (RygelMediaObject*) self, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_object_unref0 (_tmp0_);
	return result;
}


static GUPnPDIDLLiteObject* rygel_media_file_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaFileItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	RygelSerializer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* _tmp3_ = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp4_ = NULL;
	GUPnPDIDLLiteItem* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GUPnPDIDLLiteItem* _tmp8_ = NULL;
	RygelHTTPServer* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaFileItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp1_ = serializer;
	_tmp2_ = http_server;
	_tmp3_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_file_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem), _tmp1_, _tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp4_) : NULL;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (_tmp4_);
	}
	didl_item = _tmp5_;
	_tmp6_ = self->priv->_place_holder;
	if (!_tmp6_) {
		RygelHTTPServer* _tmp7_ = NULL;
		_tmp7_ = http_server;
		rygel_media_file_item_add_additional_resources (self, _tmp7_);
	}
	_tmp8_ = didl_item;
	_tmp9_ = http_server;
	rygel_media_object_serialize_resource_list ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp8_, _tmp9_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_item);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	_g_object_unref0 (_tmp0_);
	return result;
}


/**
     * Subclasses override this method to create the type-specific primary MediaResource.
     *
     * The resource returned is presumed to represent the "internal" file resource and
     * a uri referring to the source file. Transport-specific variants can be created
     * by the caller.
     */
static RygelMediaResource* rygel_media_file_item_real_get_primary_resource (RygelMediaFileItem* self) {
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	gint64 _tmp16_ = 0LL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_resource_new ("primary");
	res = _tmp0_;
	_tmp1_ = self->priv->_mime_type;
	rygel_media_resource_set_mime_type (res, _tmp1_);
	_tmp2_ = self->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (res, _tmp2_);
	rygel_media_resource_set_dlna_flags (res, GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	_tmp3_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
	_tmp4_ = _tmp3_;
	rygel_media_resource_set_uri (res, _tmp4_);
	_g_free0 (_tmp4_);
	{
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = rygel_media_resource_get_uri (res);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp7_, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		rygel_media_resource_set_protocol (res, _tmp5_);
		_g_free0 (_tmp5_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = rygel_media_resource_get_uri (res);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Could not determine protocol for ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		g_warning ("rygel-media-file-item.vala:170: %s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (res);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = rygel_media_file_item_get_extension (self);
	_tmp14_ = _tmp13_;
	rygel_media_resource_set_extension (res, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = rygel_media_file_item_get_size (self);
	_tmp16_ = _tmp15_;
	rygel_media_resource_set_size (res, _tmp16_);
	result = res;
	return result;
}


RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self)->get_primary_resource (self);
}


/**
     * Return the file/uri extension that best represents the item's primary resource.
     */
static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* rygel_media_file_item_real_get_extension (RygelMediaFileItem* self) {
	gchar* result = NULL;
	gchar* uri_extension = NULL;
	gchar* basename = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint dot_index = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp11_ = NULL;
	uri_extension = NULL;
	_tmp0_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	basename = _tmp3_;
	dot_index = -1;
	_tmp4_ = basename;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp5_ = basename;
		_tmp6_ = string_last_index_of (_tmp5_, ".", 0);
		dot_index = _tmp6_;
		_tmp7_ = dot_index;
		if (_tmp7_ > (-1)) {
			const gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gchar* _tmp10_ = NULL;
			_tmp8_ = basename;
			_tmp9_ = dot_index;
			_tmp10_ = string_substring (_tmp8_, (glong) (_tmp9_ + 1), (glong) (-1));
			_g_free0 (uri_extension);
			uri_extension = _tmp10_;
		}
	}
	_tmp11_ = uri_extension;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = self->priv->_mime_type;
		_tmp13_ = rygel_media_file_item_ext_from_mime_type (self, _tmp12_);
		_g_free0 (uri_extension);
		uri_extension = _tmp13_;
	}
	result = uri_extension;
	_g_free0 (basename);
	return result;
}


gchar* rygel_media_file_item_get_extension (RygelMediaFileItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self)->get_extension (self);
}


gchar* rygel_media_file_item_ext_from_mime_type (RygelMediaFileItem* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gchar* _tmp40_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = rygel_media_file_item_mime_to_ext;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_ = NULL;
		gchar** videos = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint videos_length1 = 0;
		gint _videos_size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		GeeHashMap* _tmp16_ = NULL;
		GeeHashMap* _tmp17_ = NULL;
		GeeHashMap* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		GeeHashMap* _tmp20_ = NULL;
		gchar** images = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gint images_length1 = 0;
		gint _images_size_ = 0;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		GeeHashMap* _tmp31_ = NULL;
		GeeHashMap* _tmp32_ = NULL;
		GeeHashMap* _tmp33_ = NULL;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_media_file_item_mime_to_ext);
		rygel_media_file_item_mime_to_ext = _tmp1_;
		_tmp2_ = g_strdup ("mpeg");
		_tmp3_ = g_strdup ("webm");
		_tmp4_ = g_strdup ("ogg");
		_tmp5_ = g_strdup ("mp4");
		_tmp6_ = g_new0 (gchar*, 4 + 1);
		_tmp6_[0] = _tmp2_;
		_tmp6_[1] = _tmp3_;
		_tmp6_[2] = _tmp4_;
		_tmp6_[3] = _tmp5_;
		videos = _tmp6_;
		videos_length1 = 4;
		_videos_size_ = videos_length1;
		_tmp7_ = videos;
		_tmp7__length1 = videos_length1;
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
			video_collection = _tmp7_;
			video_collection_length1 = _tmp7__length1;
			for (video_it = 0; video_it < _tmp7__length1; video_it = video_it + 1) {
				gchar* _tmp8_ = NULL;
				gchar* video = NULL;
				_tmp8_ = g_strdup (video_collection[video_it]);
				video = _tmp8_;
				{
					GeeHashMap* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp9_ = rygel_media_file_item_mime_to_ext;
					_tmp10_ = video;
					_tmp11_ = g_strconcat ("video/", _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = video;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp12_, _tmp13_);
					_g_free0 (_tmp12_);
					_g_free0 (video);
				}
			}
		}
		_tmp14_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "video/x-matroska", "mkv");
		_tmp15_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-wav", "wav");
		_tmp16_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "audio/x-matroska", "mka");
		_tmp17_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "audio/L16", "pcm");
		_tmp18_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "audio/vnd.dlna.adts", "adts");
		_tmp19_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "audio/mpeg", "mp3");
		_tmp20_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, "audio/3gpp", "3gp");
		_tmp21_ = g_strdup ("jpeg");
		_tmp22_ = g_strdup ("png");
		_tmp23_ = g_new0 (gchar*, 2 + 1);
		_tmp23_[0] = _tmp21_;
		_tmp23_[1] = _tmp22_;
		images = _tmp23_;
		images_length1 = 2;
		_images_size_ = images_length1;
		_tmp24_ = images;
		_tmp24__length1 = images_length1;
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
			image_collection = _tmp24_;
			image_collection_length1 = _tmp24__length1;
			for (image_it = 0; image_it < _tmp24__length1; image_it = image_it + 1) {
				gchar* _tmp25_ = NULL;
				gchar* image = NULL;
				_tmp25_ = g_strdup (image_collection[image_it]);
				image = _tmp25_;
				{
					GeeHashMap* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					_tmp26_ = rygel_media_file_item_mime_to_ext;
					_tmp27_ = image;
					_tmp28_ = g_strconcat ("image/", _tmp27_, NULL);
					_tmp29_ = _tmp28_;
					_tmp30_ = image;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp29_, _tmp30_);
					_g_free0 (_tmp29_);
					_g_free0 (image);
				}
			}
		}
		_tmp31_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, "text/srt", "srt");
		_tmp32_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, "text/xml", "xml");
		_tmp33_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, "application/ogg", "ogg");
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp34_ = rygel_media_file_item_mime_to_ext;
	_tmp35_ = mime_type;
	_tmp36_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp34_, _tmp35_);
	if (_tmp36_) {
		GeeHashMap* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gpointer _tmp39_ = NULL;
		_tmp37_ = rygel_media_file_item_mime_to_ext;
		_tmp38_ = mime_type;
		_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, _tmp38_);
		result = (gchar*) _tmp39_;
		return result;
	}
	_tmp40_ = g_strdup ("");
	result = _tmp40_;
	return result;
}


/**
     * Subclasses can override this method to augment the MediaObject MediaResource
     * list with secondary MediaResource objects representing derivative resources.
     *
     * Note: Implementations should add both internal/file-based resources and HTTP-accessible
     *       resources to the MediaResource list.
     * FIXME: Will be renamed once we can safely remove old add_resources
     */
static void rygel_media_file_item_real_add_additional_resources (RygelMediaFileItem* self, RygelHTTPServer* server) {
	g_return_if_fail (server != NULL);
}


void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self, RygelHTTPServer* server) {
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self)->add_additional_resources (self, server);
}


const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}


void rygel_media_file_item_set_mime_type (RygelMediaFileItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


const gchar* rygel_media_file_item_get_dlna_profile (RygelMediaFileItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}


void rygel_media_file_item_set_dlna_profile (RygelMediaFileItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dlna_profile);
	self->priv->_dlna_profile = _tmp1_;
	g_object_notify ((GObject *) self, "dlna-profile");
}


gint64 rygel_media_file_item_get_size (RygelMediaFileItem* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


void rygel_media_file_item_set_size (RygelMediaFileItem* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == ((gint64) 0)) {
		rygel_media_file_item_set_place_holder (self, TRUE);
	}
	_tmp1_ = value;
	self->priv->_size = _tmp1_;
	g_object_notify ((GObject *) self, "size");
}


gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_place_holder;
	result = _tmp0_;
	return result;
}


void rygel_media_file_item_set_place_holder (RygelMediaFileItem* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_place_holder = _tmp0_;
	g_object_notify ((GObject *) self, "place-holder");
}


static GUPnPOCMFlags rygel_media_file_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaFileItem* self;
	GUPnPOCMFlags flags = 0;
	gboolean _tmp0_ = FALSE;
	GUPnPOCMFlags _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	self = (RygelMediaFileItem*) base;
	flags = GUPNP_OCM_FLAGS_NONE;
	_tmp0_ = self->priv->_place_holder;
	if (_tmp0_) {
		GUPnPOCMFlags _tmp1_ = 0;
		_tmp1_ = flags;
		flags = _tmp1_ | GUPNP_OCM_FLAGS_DESTROYABLE;
	} else {
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		gboolean allow_deletion = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		allow_deletion = TRUE;
		{
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = config;
			_tmp5_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp4_, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch12_g_error;
			}
			allow_deletion = _tmp3_;
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally12:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp6_ = allow_deletion;
		if (_tmp6_) {
			GUPnPOCMFlags _tmp7_ = 0;
			_tmp7_ = flags;
			flags = _tmp7_ | GUPNP_OCM_FLAGS_DESTROYABLE;
		}
		_g_object_unref0 (config);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
		GUPnPOCMFlags _tmp8_ = 0;
		_tmp8_ = flags;
		flags = _tmp8_ | GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	_tmp9_ = flags;
	result = _tmp9_;
	return result;
}


static void rygel_media_file_item_class_init (RygelMediaFileItemClass * klass) {
	GError * _inner_error_ = NULL;
	rygel_media_file_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaFileItemPrivate));
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = rygel_media_file_item_real_create_stream_source_for_resource;
	((RygelMediaObjectClass *) klass)->serialize = rygel_media_file_item_real_serialize;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = rygel_media_file_item_real_get_primary_resource;
	((RygelMediaFileItemClass *) klass)->get_extension = rygel_media_file_item_real_get_extension;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = rygel_media_file_item_real_add_additional_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_file_item_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_file_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_file_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_file_item_finalize;
	/**
	     * The mime type of the source content (this.uri).
	     * A null/empty value means that the mime-type is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The DLNA profile of the source content (this.uri).
	     * A null/empty value means that the DLNA profile is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		_tmp1_ = g_regex_escape_string ("@ADDRESS@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_file_item_address_regex);
		rygel_media_file_item_address_regex = _tmp5_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_file_item_instance_init (RygelMediaFileItem * self) {
	self->priv = RYGEL_MEDIA_FILE_ITEM_GET_PRIVATE (self);
	self->priv->_size = (gint64) (-1);
	self->priv->_place_holder = FALSE;
}


static void rygel_media_file_item_finalize (GObject* obj) {
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	G_OBJECT_CLASS (rygel_media_file_item_parent_class)->finalize (obj);
}


/**
 * Represents a file-accessible or http-accessible media item (music file, image file,
 * video file, etc) with some pre-established metadata or a content placeholder for
 * uploaded content.
 *
 * Items representing non-file-accessible content should create their own MediaItem subclass.
 */
GType rygel_media_file_item_get_type (void) {
	static volatile gsize rygel_media_file_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_file_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaFileItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_file_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaFileItem), 0, (GInstanceInitFunc) rygel_media_file_item_instance_init, NULL };
		GType rygel_media_file_item_type_id;
		rygel_media_file_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMediaFileItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_file_item_type_id__volatile, rygel_media_file_item_type_id);
	}
	return rygel_media_file_item_type_id__volatile;
}


static void _vala_rygel_media_file_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	switch (property_id) {
		case RYGEL_MEDIA_FILE_ITEM_MIME_TYPE:
		g_value_set_string (value, rygel_media_file_item_get_mime_type (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE:
		g_value_set_string (value, rygel_media_file_item_get_dlna_profile (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_SIZE:
		g_value_set_int64 (value, rygel_media_file_item_get_size (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER:
		g_value_set_boolean (value, rygel_media_file_item_get_place_holder (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_file_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	switch (property_id) {
		case RYGEL_MEDIA_FILE_ITEM_MIME_TYPE:
		rygel_media_file_item_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE:
		rygel_media_file_item_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_SIZE:
		rygel_media_file_item_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER:
		rygel_media_file_item_set_place_holder (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



