/* rygel-simple-container.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SIMPLE_CONTAINER (rygel_simple_container_get_type ())
#define RYGEL_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer))
#define RYGEL_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))
#define RYGEL_IS_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_IS_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_SIMPLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))

typedef struct _RygelSimpleContainer RygelSimpleContainer;
typedef struct _RygelSimpleContainerClass RygelSimpleContainerClass;
typedef struct _RygelSimpleContainerPrivate RygelSimpleContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelSimpleContainerSearchData RygelSimpleContainerSearchData;

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSimpleContainer {
	RygelMediaContainer parent_instance;
	RygelSimpleContainerPrivate * priv;
	RygelMediaObjects* children;
};

struct _RygelSimpleContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelSimpleContainerPrivate {
	RygelMediaObjects* empty_children;
	GeeArrayList* _search_classes;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint stop;
	guint _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* unsorted_children;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	guint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	guint _tmp12_;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeList* _tmp16_;
	RygelMediaObjects* _tmp17_;
	RygelMediaObjects* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObjects* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GeeList* _tmp23_;
	RygelMediaObjects* _tmp24_;
};

struct _Block2Data {
	int _ref_count_;
	RygelSimpleContainer* self;
	gint restart_count;
	gboolean restart;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gulong updated_id;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelMediaObject* media_object;
	gint max_count;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObjects* children_to_search;
	gint _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObjects* _tmp8_;
	gboolean _tmp9_;
	Block3Data* _data3_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp13_;
	RygelMediaObjects* _tmp14_;
	gint _child_size;
	RygelMediaObjects* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _child_index;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp21_;
	gint _tmp22_;
	gpointer _tmp23_;
	RygelMediaObject* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	RygelMediaObject* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	gulong _tmp31_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp32_;
	RygelMediaContainer* _tmp33_;
	RygelMediaObject* _tmp34_;
	RygelMediaContainer* _tmp35_;
	const gchar* _tmp36_;
	GCancellable* _tmp37_;
	RygelMediaObject* _tmp38_;
	RygelMediaObject* _tmp39_;
	gulong _tmp40_;
	gulong _tmp41_;
	RygelMediaObject* _tmp42_;
	gboolean _tmp43_;
	GError * _inner_error_;
};

struct _RygelSimpleContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	GError * _inner_error_;
};


static gpointer rygel_simple_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_simple_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_simple_container_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerPrivate))
enum  {
	RYGEL_SIMPLE_CONTAINER_DUMMY_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES
};
RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
static void rygel_simple_container_real_constructed (GObject* base);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child);
static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child);
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self);
void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self);
void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child);
void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value);
void rygel_simple_container_clear (RygelSimpleContainer* self);
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ________lambda21_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaObject* updated);
static void _________lambda21__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_real_search_data_free (gpointer _data);
static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_simple_container_finalize (GObject* obj);
static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Creates a child RygelSimpleContainer.
     *
     * @param id The ID of the item. This should be unique in the server.
     * @param parent The parent of the container.
     * @param title The title of the container.
     */
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", 0, NULL);
	return self;
}


RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
}


static void rygel_simple_container_real_constructed (GObject* base) {
	RygelSimpleContainer * self;
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObjects* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	self = (RygelSimpleContainer*) base;
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer));
	_tmp0_ = rygel_media_objects_new ();
	_g_object_unref0 (self->children);
	self->children = _tmp0_;
	_tmp1_ = rygel_media_objects_new ();
	_g_object_unref0 (self->priv->empty_children);
	self->priv->empty_children = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


/**
     * Creates a RygelSimpleContainer as a root container.
     *
     * @param title The title of the container.
     */
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", _tmp0_, "child-count", 0, NULL);
	return self;
}


RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title) {
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
}


/**
     * Adds an item to the container.
     *
     * @param child The child item to add to the container.
     */
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child) {
	RygelMediaItem* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp0_);
}


/**
     * Get all children, including the empty children.
     *
     * This is useful when all children are empty,
     * so get_children() would return no objects,
     * but when you need to add items to the empty
     * items.
     *
     * This is useful only when implementing derived classes.
     */
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* all = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObjects* _tmp1_ = NULL;
	RygelMediaObjects* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	all = _tmp0_;
	_tmp1_ = self->children;
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp1_);
	_tmp2_ = self->priv->empty_children;
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp2_);
	result = all;
	return result;
}


/**
     * Adds a child container to this container.
     *
     * The child container will only be added to the hierarchy if, or when,
     * it contains some children.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_simple_container_on_container_updated ((RygelSimpleContainer*) self, _sender, container, object, event_type, sub_tree_update);
}


void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
		GeeArrayList* search_classes = NULL;
		RygelMediaContainer* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
		_tmp1_ = child;
		_tmp2_ = rygel_searchable_container_get_search_classes (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _tmp1_) : NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		search_classes = _tmp4_;
		_tmp5_ = rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = search_classes;
		gee_array_list_add_all (_tmp6_, (GeeCollection*) _tmp7_);
		_g_object_unref0 (search_classes);
	}
	_tmp8_ = child;
	_tmp9_ = rygel_media_container_get_child_count (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		RygelMediaContainer* _tmp11_ = NULL;
		_tmp11_ = child;
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp11_);
	} else {
		RygelMediaContainer* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		RygelMediaObjects* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		RygelMediaContainer* _tmp19_ = NULL;
		_tmp12_ = child;
		_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		g_debug ("Container '%s' empty, refusing to add to hierarchy " "until it has any children to offer.", _tmp14_);
		_tmp15_ = self->priv->empty_children;
		_tmp16_ = child;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (RygelMediaObject*) _tmp16_);
		_tmp17_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp18_ = _tmp17_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp18_ + 1);
		_tmp19_ = child;
		g_signal_connect_object (_tmp19_, "container-updated", (GCallback) _rygel_simple_container_on_container_updated_rygel_media_container_container_updated, self, 0);
	}
}


/**
     * Removes the item from the container.
     */
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->children;
	_tmp1_ = child;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
	_tmp3_ = _tmp2_;
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp3_ - 1);
}


/**
     * Removes all child items and child containers
     * from the container.
     */
void rygel_simple_container_clear (RygelSimpleContainer* self) {
	RygelMediaObjects* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->children;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, 0);
}


/**
     * Check that the ID is unique within this container.
     *
     * This is useful only when implementing derived classes.
     *
     * @param child_id The ID to check for uniqueness.
     * @return true if the child ID is unique within this container.
     */
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id) {
	gboolean result = FALSE;
	gboolean unique = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child_id != NULL, FALSE);
	unique = TRUE;
	{
		RygelMediaObjects* _child_list = NULL;
		RygelMediaObjects* _tmp0_ = NULL;
		RygelMediaObjects* _tmp1_ = NULL;
		gint _child_size = 0;
		RygelMediaObjects* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _child_index = 0;
		_tmp0_ = self->children;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelMediaObject* child = NULL;
			RygelMediaObjects* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp5_ = _child_index;
			_child_index = _tmp5_ + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = _child_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			child = (RygelMediaObject*) _tmp10_;
			_tmp11_ = child;
			_tmp12_ = rygel_media_object_get_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = child_id;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				unique = FALSE;
				_g_object_unref0 (child);
				break;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	_tmp15_ = unique;
	if (_tmp15_) {
		{
			RygelMediaObjects* _child_list = NULL;
			RygelMediaObjects* _tmp16_ = NULL;
			RygelMediaObjects* _tmp17_ = NULL;
			gint _child_size = 0;
			RygelMediaObjects* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _child_index = 0;
			_tmp16_ = self->priv->empty_children;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			_child_list = _tmp17_;
			_tmp18_ = _child_list;
			_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_child_size = _tmp20_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				RygelMediaObject* child = NULL;
				RygelMediaObjects* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gpointer _tmp26_ = NULL;
				RygelMediaObject* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				_tmp21_ = _child_index;
				_child_index = _tmp21_ + 1;
				_tmp22_ = _child_index;
				_tmp23_ = _child_size;
				if (!(_tmp22_ < _tmp23_)) {
					break;
				}
				_tmp24_ = _child_list;
				_tmp25_ = _child_index;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp25_);
				child = (RygelMediaObject*) _tmp26_;
				_tmp27_ = child;
				_tmp28_ = rygel_media_object_get_id (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = child_id;
				if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
					unique = FALSE;
					_g_object_unref0 (child);
					break;
				}
				_g_object_unref0 (child);
			}
			_g_object_unref0 (_child_list);
		}
	}
	result = unique;
	return result;
}


static void rygel_simple_container_real_get_children_data_free (gpointer _data) {
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerGetChildrenData, _data_);
}


static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_simple_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_simple_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0U;
	_data_->_tmp0_ = _data_->offset;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->max_count;
	_data_->stop = _data_->_tmp0_ + _data_->_tmp1_;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = 0U;
		_data_->_tmp4_ = _data_->stop;
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp6_ = 0;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = 0U;
		_data_->_tmp7_ = CLAMP (_data_->_tmp4_, (guint) 0, (guint) _data_->_tmp6_);
		_data_->stop = _data_->_tmp7_;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = rygel_simple_container_get_all_children (_data_->self);
		_g_object_unref0 (_data_->unsorted_children);
		_data_->unsorted_children = _data_->_tmp8_;
	} else {
		_data_->_tmp9_ = 0U;
		_data_->_tmp9_ = _data_->stop;
		_data_->_tmp10_ = 0;
		_data_->_tmp10_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = 0U;
		_data_->_tmp12_ = CLAMP (_data_->_tmp9_, (guint) 0, (guint) _data_->_tmp11_);
		_data_->stop = _data_->_tmp12_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->children;
		_data_->_tmp14_ = 0;
		_data_->_tmp14_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp15_ = 0;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp13_, 0, _data_->_tmp15_);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp16_) : NULL;
		if (_data_->_tmp17_ == NULL) {
			_g_object_unref0 (_data_->_tmp16_);
		}
		_g_object_unref0 (_data_->unsorted_children);
		_data_->unsorted_children = _data_->_tmp17_;
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->unsorted_children;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->sort_criteria;
	rygel_media_objects_sort_by_criteria (_data_->_tmp18_, _data_->_tmp19_);
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->unsorted_children;
	_data_->_tmp21_ = 0U;
	_data_->_tmp21_ = _data_->offset;
	_data_->_tmp22_ = 0U;
	_data_->_tmp22_ = _data_->stop;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp20_, (gint) _data_->_tmp21_, (gint) _data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp23_) : NULL;
	if (_data_->_tmp24_ == NULL) {
		_g_object_unref0 (_data_->_tmp23_);
	}
	_data_->result = _data_->_tmp24_;
	_g_object_unref0 (_data_->unsorted_children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->unsorted_children);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_simple_container_real_find_object_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerFindObjectData, _data_);
}


static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_simple_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_simple_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelSimpleContainer* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_simple_container_real_find_object_co (_data_);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelSimpleContainer* self;
		self = _data3_->_data2_->self;
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void ________lambda21_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaObject* updated) {
	Block2Data* _data2_;
	RygelSimpleContainer* self;
	RygelMediaObject* _tmp0_ = NULL;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (_ != NULL);
	g_return_if_fail (updated != NULL);
	_tmp0_ = updated;
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
		gint _tmp1_ = 0;
		gulong _tmp2_ = 0UL;
		_data2_->restart = TRUE;
		_tmp1_ = _data2_->restart_count;
		_data2_->restart_count = _tmp1_ + 1;
		_tmp2_ = _data3_->updated_id;
		g_signal_handler_disconnect ((GObject*) self, _tmp2_);
		_data3_->updated_id = (gulong) 0;
	}
}


static void _________lambda21__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	________lambda21_ (self, container, object);
}


static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->media_object = NULL;
	_data_->max_count = 0;
	_data_->_data2_->restart_count = 0;
	_data_->_data2_->restart = FALSE;
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = 0;
		_data_->_tmp2_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp3_ = 0;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->max_count = _data_->_tmp3_;
	} else {
		_data_->_tmp4_ = 0;
		_data_->_tmp4_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->max_count = _data_->_tmp5_;
	}
	_data_->_tmp6_ = 0;
	_data_->_tmp6_ = _data_->max_count;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->cancellable;
	_data_->_state_ = 1;
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp6_, "", _data_->_tmp7_, rygel_simple_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->children_to_search = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp9_ = TRUE;
		while (TRUE) {
			_data_->_data3_ = g_slice_new0 (Block3Data);
			_data_->_data3_->_ref_count_ = 1;
			_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
			if (!_data_->_tmp9_) {
				_data_->_tmp11_ = FALSE;
				_data_->_tmp11_ = _data_->_data2_->restart;
				if (_data_->_tmp11_) {
					_data_->_tmp12_ = 0;
					_data_->_tmp12_ = _data_->_data2_->restart_count;
					_data_->_tmp10_ = _data_->_tmp12_ < 10;
				} else {
					_data_->_tmp10_ = FALSE;
				}
				if (!_data_->_tmp10_) {
					block3_data_unref (_data_->_data3_);
					_data_->_data3_ = NULL;
					break;
				}
			}
			_data_->_tmp9_ = FALSE;
			_data_->_data2_->restart = FALSE;
			_data_->_data3_->updated_id = (gulong) 0;
			{
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->children_to_search;
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
				_data_->_child_list = _data_->_tmp14_;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->_child_list;
				_data_->_tmp16_ = 0;
				_data_->_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp15_);
				_data_->_tmp17_ = 0;
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_child_size = _data_->_tmp17_;
				_data_->_child_index = -1;
				while (TRUE) {
					_data_->_tmp18_ = 0;
					_data_->_tmp18_ = _data_->_child_index;
					_data_->_child_index = _data_->_tmp18_ + 1;
					_data_->_tmp19_ = 0;
					_data_->_tmp19_ = _data_->_child_index;
					_data_->_tmp20_ = 0;
					_data_->_tmp20_ = _data_->_child_size;
					if (!(_data_->_tmp19_ < _data_->_tmp20_)) {
						break;
					}
					_data_->_tmp21_ = NULL;
					_data_->_tmp21_ = _data_->_child_list;
					_data_->_tmp22_ = 0;
					_data_->_tmp22_ = _data_->_child_index;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp21_, _data_->_tmp22_);
					_data_->child = (RygelMediaObject*) _data_->_tmp23_;
					_data_->_tmp24_ = NULL;
					_data_->_tmp24_ = _data_->child;
					_data_->_tmp25_ = NULL;
					_data_->_tmp25_ = rygel_media_object_get_id (_data_->_tmp24_);
					_data_->_tmp26_ = NULL;
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = _data_->id;
					if (g_strcmp0 (_data_->_tmp26_, _data_->_tmp27_) == 0) {
						_data_->_tmp28_ = NULL;
						_data_->_tmp28_ = _data_->child;
						_data_->_tmp29_ = NULL;
						_data_->_tmp29_ = _g_object_ref0 (_data_->_tmp28_);
						_g_object_unref0 (_data_->media_object);
						_data_->media_object = _data_->_tmp29_;
						_g_object_unref0 (_data_->child);
						break;
					} else {
						_data_->_tmp30_ = NULL;
						_data_->_tmp30_ = _data_->child;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, RYGEL_TYPE_MEDIA_CONTAINER)) {
							_data_->_tmp31_ = 0UL;
							_data_->_tmp31_ = g_signal_connect_data ((RygelMediaContainer*) _data_->self, "container-updated", (GCallback) _________lambda21__rygel_media_container_container_updated, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
							_data_->_data3_->updated_id = _data_->_tmp31_;
							_data_->_tmp32_ = NULL;
							_data_->_tmp32_ = _data_->child;
							_data_->_tmp33_ = NULL;
							_data_->_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp32_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp32_) : NULL);
							_data_->container = _data_->_tmp33_;
							_data_->_tmp35_ = NULL;
							_data_->_tmp35_ = _data_->container;
							_data_->_tmp36_ = NULL;
							_data_->_tmp36_ = _data_->id;
							_data_->_tmp37_ = NULL;
							_data_->_tmp37_ = _data_->cancellable;
							_data_->_state_ = 2;
							rygel_media_container_find_object (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_, rygel_simple_container_find_object_ready, _data_);
							return FALSE;
							_state_2:
							_data_->_tmp38_ = NULL;
							_data_->_tmp38_ = rygel_media_container_find_object_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error_);
							_data_->_tmp34_ = _data_->_tmp38_;
							if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
								g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
								g_error_free (_data_->_inner_error_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								_g_object_unref0 (_data_->_child_list);
								block3_data_unref (_data_->_data3_);
								_data_->_data3_ = NULL;
								_g_object_unref0 (_data_->children_to_search);
								_g_object_unref0 (_data_->media_object);
								block2_data_unref (_data_->_data2_);
								_data_->_data2_ = NULL;
								if (_data_->_state_ == 0) {
									g_simple_async_result_complete_in_idle (_data_->_async_result);
								} else {
									g_simple_async_result_complete (_data_->_async_result);
								}
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_data_->_tmp39_ = NULL;
							_data_->_tmp39_ = _data_->_tmp34_;
							_data_->_tmp34_ = NULL;
							_g_object_unref0 (_data_->media_object);
							_data_->media_object = _data_->_tmp39_;
							_data_->_tmp40_ = 0UL;
							_data_->_tmp40_ = _data_->_data3_->updated_id;
							if (_data_->_tmp40_ != ((gulong) 0)) {
								_data_->_tmp41_ = 0UL;
								_data_->_tmp41_ = _data_->_data3_->updated_id;
								g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp41_);
							}
							_data_->_tmp42_ = NULL;
							_data_->_tmp42_ = _data_->media_object;
							if (_data_->_tmp42_ != NULL) {
								_data_->_data2_->restart = FALSE;
								_g_object_unref0 (_data_->_tmp34_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								break;
							}
							_data_->_tmp43_ = FALSE;
							_data_->_tmp43_ = _data_->_data2_->restart;
							if (_data_->_tmp43_) {
								_g_object_unref0 (_data_->_tmp34_);
								_g_object_unref0 (_data_->container);
								_g_object_unref0 (_data_->child);
								break;
							}
							_g_object_unref0 (_data_->_tmp34_);
							_g_object_unref0 (_data_->container);
						}
					}
					_g_object_unref0 (_data_->child);
				}
				_g_object_unref0 (_data_->_child_list);
			}
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
		}
	}
	_data_->result = _data_->media_object;
	_g_object_unref0 (_data_->children_to_search);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->children_to_search);
	_g_object_unref0 (_data_->media_object);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_simple_container_real_search_data_free (gpointer _data) {
	RygelSimpleContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelSimpleContainerSearchData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerSearchData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	self = (RygelSimpleContainer*) base;
	_data_ = g_slice_new0 (RygelSimpleContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_simple_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_simple_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_simple_container_real_search_co (_data_);
}


static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->expression;
	_data_->_tmp2_ = 0U;
	_data_->_tmp2_ = _data_->offset;
	_data_->_tmp3_ = 0U;
	_data_->_tmp3_ = _data_->max_count;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->sort_criteria;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->cancellable;
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, rygel_simple_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp6_;
	_data_->_tmp0_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp8_;
	_g_object_unref0 (_data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->children;
	_tmp1_ = child;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
	_tmp3_ = _tmp2_;
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp3_ + 1);
}


static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (updated != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = updated;
	_tmp1_ = rygel_media_container_get_child_count (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		RygelMediaObjects* _tmp3_ = NULL;
		RygelMediaContainer* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		RygelMediaObjects* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		RygelMediaContainer* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp3_ = self->priv->empty_children;
		_tmp4_ = updated;
		_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, (RygelMediaObject*) _tmp4_);
		if (!_tmp5_) {
			return;
		}
		_tmp6_ = self->priv->empty_children;
		_tmp7_ = updated;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, (RygelMediaObject*) _tmp7_);
		_tmp8_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp9_ = _tmp8_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp9_ - 1);
		_tmp10_ = updated;
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp10_);
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		_tmp11_ = updated;
		_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp11_);
		_tmp13_ = _tmp12_;
		g_debug ("rygel-simple-container.vala:304: Container '%s' now non-empty, added i" \
"t to hierarchy now.", _tmp13_);
	} else {
		RygelMediaObjects* _tmp14_ = NULL;
		RygelMediaContainer* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		RygelMediaContainer* _tmp17_ = NULL;
		RygelMediaObjects* _tmp18_ = NULL;
		RygelMediaContainer* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		RygelMediaContainer* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp14_ = self->children;
		_tmp15_ = updated;
		_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp14_, (RygelMediaObject*) _tmp15_);
		if (!_tmp16_) {
			return;
		}
		_tmp17_ = updated;
		rygel_simple_container_remove_child (self, (RygelMediaObject*) _tmp17_);
		_tmp18_ = self->priv->empty_children;
		_tmp19_ = updated;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (RygelMediaObject*) _tmp19_);
		_tmp20_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
		_tmp21_ = _tmp20_;
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp21_ + 1);
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
		_tmp22_ = updated;
		_tmp23_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp22_);
		_tmp24_ = _tmp23_;
		g_debug ("rygel-simple-container.vala:317: Container '%s' now empty, removing it" \
" from hierarchy now.", _tmp24_);
	}
}


static GeeArrayList* rygel_simple_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	self = (RygelSimpleContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}


static void rygel_simple_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self = (RygelSimpleContainer*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_search_classes);
	self->priv->_search_classes = _tmp1_;
	g_object_notify ((GObject *) self, "search-classes");
}


static void rygel_simple_container_class_init (RygelSimpleContainerClass * klass) {
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSimpleContainerPrivate));
	((GObjectClass *) klass)->constructed = rygel_simple_container_real_constructed;
	((RygelMediaContainerClass *) klass)->get_children = rygel_simple_container_real_get_children;
	((RygelMediaContainerClass *) klass)->get_children_finish = rygel_simple_container_real_get_children_finish;
	((RygelMediaContainerClass *) klass)->find_object = rygel_simple_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = rygel_simple_container_real_find_object_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_simple_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_simple_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_simple_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
	rygel_simple_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) rygel_simple_container_real_search;
	iface->search_finish = rygel_simple_container_real_search_finish;
	iface->get_search_classes = rygel_simple_container_real_get_search_classes;
	iface->set_search_classes = rygel_simple_container_real_set_search_classes;
}


static void rygel_simple_container_instance_init (RygelSimpleContainer * self) {
	self->priv = RYGEL_SIMPLE_CONTAINER_GET_PRIVATE (self);
}


static void rygel_simple_container_finalize (GObject* obj) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	_g_object_unref0 (self->children);
	_g_object_unref0 (self->priv->empty_children);
	_g_object_unref0 (self->priv->_search_classes);
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
}


/**
 * A simple implementation of RygelMediaContainer that keeps all RygelMediaObjects
 * in memory. You should add children via rygel_simple_container_add_child_item().
 */
GType rygel_simple_container_get_type (void) {
	static volatile gsize rygel_simple_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_simple_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_container_type_id;
		rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_simple_container_type_id__volatile, rygel_simple_container_type_id);
	}
	return rygel_simple_container_type_id__volatile;
}


static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	switch (property_id) {
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
	switch (property_id) {
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



