/* rygel-content-directory.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-content-directory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <uuid/uuid.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;

#define RYGEL_TYPE_LAST_CHANGE (rygel_last_change_get_type ())
#define RYGEL_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChange))
#define RYGEL_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))
#define RYGEL_IS_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_IS_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_LAST_CHANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))

typedef struct _RygelLastChange RygelLastChange;
typedef struct _RygelLastChangeClass RygelLastChangeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;

#define RYGEL_TYPE_REFERENCE_CREATOR (rygel_reference_creator_get_type ())
#define RYGEL_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator))
#define RYGEL_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))
#define RYGEL_IS_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_IS_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_REFERENCE_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))

typedef struct _RygelReferenceCreator RygelReferenceCreator;
typedef struct _RygelReferenceCreatorClass RygelReferenceCreatorClass;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;

#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_LAST_CHANGE_ENTRY (rygel_last_change_entry_get_type ())
#define RYGEL_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntry))
#define RYGEL_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))
#define RYGEL_IS_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_IS_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_LAST_CHANGE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))

typedef struct _RygelLastChangeEntry RygelLastChangeEntry;
typedef struct _RygelLastChangeEntryClass RygelLastChangeEntryClass;

#define RYGEL_TYPE_LAST_CHANGE_ST_DONE (rygel_last_change_st_done_get_type ())
#define RYGEL_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDone))
#define RYGEL_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))
#define RYGEL_IS_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_IS_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_LAST_CHANGE_ST_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))

typedef struct _RygelLastChangeStDone RygelLastChangeStDone;
typedef struct _RygelLastChangeStDoneClass RygelLastChangeStDoneClass;
typedef struct _Block4Data Block4Data;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_ADD (rygel_last_change_obj_add_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAdd))
#define RYGEL_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_LAST_CHANGE_OBJ_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))

typedef struct _RygelLastChangeObjAdd RygelLastChangeObjAdd;
typedef struct _RygelLastChangeObjAddClass RygelLastChangeObjAddClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_MOD (rygel_last_change_obj_mod_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjMod))
#define RYGEL_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_LAST_CHANGE_OBJ_MOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))

typedef struct _RygelLastChangeObjMod RygelLastChangeObjMod;
typedef struct _RygelLastChangeObjModClass RygelLastChangeObjModClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_DEL (rygel_last_change_obj_del_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDel))
#define RYGEL_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_LAST_CHANGE_OBJ_DEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))

typedef struct _RygelLastChangeObjDel RygelLastChangeObjDel;
typedef struct _RygelLastChangeObjDelClass RygelLastChangeObjDelClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelContentDirectoryServiceResetData RygelContentDirectoryServiceResetData;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelContentDirectoryPrivate {
	GeeArrayList* updated_containers;
	GeeArrayList* active_imports;
	GeeArrayList* finished_imports;
	gboolean clear_updated_containers;
	guint update_notify_id;
	RygelLastChange* last_change;
	gchar* service_reset_token;
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _Block4Data {
	int _ref_count_;
	RygelContentDirectory* self;
	RygelImportResource* import;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelContentDirectoryServiceResetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelContentDirectory* self;
	RygelMediaServerPlugin* plugin;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaServerPlugin* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelTrackableContainer* trackable;
	RygelMediaContainer* _tmp10_;
	RygelTrackableContainer* _tmp11_;
	RygelTrackableContainer* _tmp12_;
	const gchar* _tmp13_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gchar* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gchar* _tmp18_;
	RygelRelationalExpression* _tmp19_;
	RygelSearchableContainer* root;
	RygelMediaContainer* _tmp20_;
	RygelSearchableContainer* _tmp21_;
	RygelSearchableContainer* _tmp22_;
	guint32 matches;
	RygelMediaObjects* objects;
	RygelSearchableContainer* _tmp23_;
	RygelRelationalExpression* _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	guint32 count;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _object_size;
	RygelMediaObjects* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _object_index;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	RygelMediaObject* object;
	RygelMediaObjects* _tmp38_;
	gint _tmp39_;
	gpointer _tmp40_;
	RygelMediaObject* _tmp41_;
	guint32 _tmp42_;
	RygelMediaObject* _tmp43_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp44_;
	RygelMediaContainer* _tmp45_;
	RygelMediaContainer* _tmp46_;
	RygelMediaContainer* _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	RygelMediaContainer* _tmp50_;
	guint32 _tmp51_;
	guint32 _tmp52_;
	RygelMediaServerPlugin* _tmp53_;
	const gchar* _tmp54_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer rygel_content_directory_parent_class = NULL;

GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_last_change_get_type (void) G_GNUC_CONST;
#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
static void rygel_content_directory_real_constructed (GObject* base);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
static gboolean __lambda5_ (RygelContentDirectory* self, RygelMediaContainer* a, RygelMediaContainer* b);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean ___lambda5__gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self);
guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root);
static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
RygelLastChange* rygel_last_change_new (void);
RygelLastChange* rygel_last_change_construct (GType object_type);
static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_search_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_reference_creator_get_type (void) G_GNUC_CONST;
RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelReferenceCreator* rygel_reference_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_updater_get_type (void) G_GNUC_CONST;
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine);
static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self);
static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self);
const gchar* rygel_media_server_plugin_get_search_caps (RygelMediaServerPlugin* self);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self);
static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_);
static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object);
static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self);
GType rygel_last_change_entry_get_type (void) G_GNUC_CONST;
GType rygel_last_change_st_done_get_type (void) G_GNUC_CONST;
RygelLastChangeStDone* rygel_last_change_st_done_new (const gchar* id, guint update_id);
RygelLastChangeStDone* rygel_last_change_st_done_construct (GType object_type, const gchar* id, guint update_id);
void rygel_last_change_add_event (RygelLastChange* self, RygelLastChangeEntry* entry);
static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self);
gchar* rygel_last_change_get_log (RygelLastChange* self);
void rygel_last_change_clear_on_new_event (RygelLastChange* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block4Data* _data4_);
static gboolean ___lambda11__gsource_func (gpointer self);
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
RygelLastChangeObjAdd* rygel_last_change_obj_add_new (const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
RygelLastChangeObjAdd* rygel_last_change_obj_add_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
GType rygel_last_change_obj_add_get_type (void) G_GNUC_CONST;
RygelLastChangeObjMod* rygel_last_change_obj_mod_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjMod* rygel_last_change_obj_mod_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_mod_get_type (void) G_GNUC_CONST;
RygelLastChangeObjDel* rygel_last_change_obj_del_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjDel* rygel_last_change_obj_del_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_del_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_service_reset_data_free (gpointer _data);
static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_);
void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self, const gchar* token);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda5_ (RygelContentDirectory* self, RygelMediaContainer* a, RygelMediaContainer* b) {
	gboolean result = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	result = g_strcmp0 (_tmp2_, _tmp5_) == 0;
	return result;
}


static gboolean ___lambda5__gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelContentDirectory*) self, (RygelMediaContainer*) a, (RygelMediaContainer*) b);
	return result;
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	rygel_content_directory_on_container_updated ((RygelContentDirectory*) self, _sender, container, object, event_type, sub_tree_update);
}


static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
	rygel_content_directory_on_sub_tree_updates_finished ((RygelContentDirectory*) self, _sender, sub_tree_root);
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_browse_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_search_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_create_object_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_create_reference_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_destroy_object_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_update_object_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_import_resource_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_transfer_progress_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_stop_transfer_resource_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_dlna_upload_profiles_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_transfer_ids ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_system_update_id_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_system_update_id ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_container_update_ids ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_search_capabilities_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_search_capabilities ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_sort_capabilities_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_sort_capabilities ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_feature_list_cb ((RygelContentDirectory*) self, _sender, action);
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_feature_list ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_last_change ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_content_directory_query_service_reset_token ((RygelContentDirectory*) self, _sender, variable, value);
}


static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_content_directory_get_service_reset_token_cb ((RygelContentDirectory*) self, _sender, action);
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPRootDevice* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	GUPnPResourceFactory* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	RygelMediaServerPlugin* _tmp7_ = NULL;
	RygelMediaServerPlugin* _tmp8_ = NULL;
	RygelMediaContainer* _tmp9_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	RygelMediaServerPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelHTTPServer* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	RygelMediaContainer* _tmp19_ = NULL;
	RygelMediaContainer* _tmp27_ = NULL;
	RygelMediaContainer* _tmp28_ = NULL;
	RygelLastChange* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	RygelHTTPServer* _tmp31_ = NULL;
	self = (RygelContentDirectory*) base;
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp0_;
	g_object_get ((GUPnPService*) self, "root-device", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	plugin = _tmp7_;
	_tmp8_ = plugin;
	_tmp9_ = rygel_media_server_plugin_get_root_container (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp11_;
	_tmp12_ = plugin;
	_tmp13_ = rygel_plugin_get_name ((RygelPlugin*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = rygel_http_server_new (self, _tmp14_);
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp15_;
	_tmp16_ = gee_array_list_new (RYGEL_TYPE_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, ___lambda5__gee_equal_data_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->updated_containers);
	self->priv->updated_containers = _tmp16_;
	_tmp17_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_imports);
	self->priv->active_imports = _tmp17_;
	_tmp18_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->finished_imports);
	self->priv->finished_imports = _tmp18_;
	_tmp19_ = self->root_container;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		RygelTrackableContainer* trackable = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelTrackableContainer* _tmp21_ = NULL;
		RygelTrackableContainer* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		RygelTrackableContainer* _tmp24_ = NULL;
		guint32 _tmp25_ = 0U;
		_tmp20_ = self->root_container;
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp20_) : NULL);
		trackable = _tmp21_;
		_tmp22_ = trackable;
		_tmp23_ = rygel_trackable_container_get_service_reset_token (_tmp22_);
		_g_free0 (self->priv->service_reset_token);
		self->priv->service_reset_token = _tmp23_;
		_tmp24_ = trackable;
		_tmp25_ = rygel_trackable_container_get_system_update_id (_tmp24_);
		self->system_update_id = _tmp25_;
		_g_object_unref0 (trackable);
	} else {
		gchar* _tmp26_ = NULL;
		_tmp26_ = uuid_get ();
		_g_free0 (self->priv->service_reset_token);
		self->priv->service_reset_token = _tmp26_;
		self->system_update_id = (guint32) 0;
	}
	_tmp27_ = self->root_container;
	g_signal_connect_object (_tmp27_, "container-updated", (GCallback) _rygel_content_directory_on_container_updated_rygel_media_container_container_updated, self, 0);
	_tmp28_ = self->root_container;
	g_signal_connect_object (_tmp28_, "sub-tree-updates-finished", (GCallback) _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
	_tmp29_ = rygel_last_change_new ();
	_g_object_unref0 (self->priv->last_change);
	self->priv->last_change = _tmp29_;
	_tmp30_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>");
	_g_free0 (self->feature_list);
	self->feature_list = _tmp30_;
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Search", (GCallback) _rygel_content_directory_search_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateObject", (GCallback) _rygel_content_directory_create_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateReference", (GCallback) _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::DestroyObject", (GCallback) _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::UpdateObject", (GCallback) _rygel_content_directory_update_object_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ImportResource", (GCallback) _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransferProgress", (GCallback) _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::StopTransferResource", (GCallback) _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_GetDLNAUploadProfiles", (GCallback) _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TransferIDs", (GCallback) _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ContainerUpdateIDs", (GCallback) _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_content_directory_query_last_change_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ServiceResetToken", (GCallback) _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetServiceResetToken", (GCallback) _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked, self, 0);
	_tmp31_ = self->http_server;
	rygel_state_machine_run ((RygelStateMachine*) _tmp31_, NULL, NULL);
	_g_object_unref0 (plugin);
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}


static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelBrowse* browse = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelBrowse* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_browse_new (self, _tmp1_);
	browse = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) browse, NULL, NULL);
	_g_object_unref0 (browse);
}


static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelSearch* search = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelSearch* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_search_new (self, _tmp1_);
	search = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) search, NULL, NULL);
	_g_object_unref0 (search);
}


static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelObjectCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelObjectCreator* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_object_creator_new (self, _tmp1_);
	creator = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
	_g_object_unref0 (creator);
}


static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelReferenceCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelReferenceCreator* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_reference_creator_new (self, _tmp1_);
	creator = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
	_g_object_unref0 (creator);
}


static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemDestroyer* destroyer = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemDestroyer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_item_destroyer_new (self, _tmp1_);
	destroyer = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) destroyer, NULL, NULL);
	_g_object_unref0 (destroyer);
}


static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater* updater = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemUpdater* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_item_updater_new (self, _tmp1_);
	updater = _tmp2_;
	rygel_state_machine_run ((RygelStateMachine*) updater, NULL, NULL);
	_g_object_unref0 (updater);
}


static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_content_directory_on_import_completed ((RygelContentDirectory*) self, _sender);
}


static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelImportResource* import = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelImportResource* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	_tmp2_ = rygel_import_resource_new (self, _tmp1_);
	import = _tmp2_;
	g_signal_connect_object ((RygelStateMachine*) import, "completed", (GCallback) _rygel_content_directory_on_import_completed_rygel_state_machine_completed, self, 0);
	_tmp3_ = self->priv->active_imports;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, import);
	rygel_state_machine_run ((RygelStateMachine*) import, NULL, NULL);
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
	_tmp5_ = _tmp4_;
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_object_unref0 (import);
}


static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = rygel_content_directory_create_transfer_ids (self);
	_tmp1_ = _tmp0_;
	g_value_set_string (value, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		GUPnPServiceAction* _tmp6_ = NULL;
		RygelImportResource* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelImportResource* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		RygelImportResource* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		GUPnPServiceAction* _tmp14_ = NULL;
		_tmp4_ = action;
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
		import = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch24_g_error;
		}
		_tmp6_ = action;
		_tmp7_ = import;
		_tmp8_ = rygel_import_resource_get_status_as_string (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = import;
		_tmp11_ = _tmp10_->bytes_copied;
		_tmp12_ = import;
		_tmp13_ = _tmp12_->bytes_total;
		gupnp_service_action_set (_tmp6_, "TransferStatus", G_TYPE_STRING, _tmp9_, "TransferLength", G_TYPE_INT64, _tmp11_, "TransferTotal", G_TYPE_INT64, _tmp13_, NULL);
		_tmp14_ = action;
		gupnp_service_action_return (_tmp14_);
		_g_object_unref0 (import);
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = action;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->code;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		gupnp_service_action_return_error (_tmp15_, (guint) _tmp17_, _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		RygelImportResource* _tmp6_ = NULL;
		GCancellable* _tmp7_ = NULL;
		GCancellable* _tmp8_ = NULL;
		GUPnPServiceAction* _tmp9_ = NULL;
		_tmp4_ = action;
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
		import = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
		_tmp6_ = import;
		_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp6_);
		_tmp8_ = _tmp7_;
		g_cancellable_cancel (_tmp8_);
		_tmp9_ = action;
		gupnp_service_action_return (_tmp9_);
		_g_object_unref0 (import);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = action;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->code;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		gupnp_service_action_return_error (_tmp10_, (guint) _tmp12_, _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	GUPnPServiceAction* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = self->system_update_id;
	gupnp_service_action_set (_tmp4_, "Id", G_TYPE_UINT, _tmp5_, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	guint32 _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_UINT);
	_tmp0_ = self->system_update_id;
	g_value_set_uint (value, (guint) _tmp0_);
}


static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
	update_ids = _tmp0_;
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, update_ids);
	_g_free0 (update_ids);
}


static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_ = NULL;
	GUPnPRootDevice* _tmp6_ = NULL;
	GUPnPResourceFactory* _tmp7_ = NULL;
	GUPnPResourceFactory* _tmp8_ = NULL;
	RygelMediaServerPlugin* _tmp9_ = NULL;
	RygelMediaServerPlugin* _tmp10_ = NULL;
	GUPnPServiceAction* _tmp11_ = NULL;
	RygelMediaServerPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPServiceAction* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp6_);
	plugin = _tmp10_;
	_tmp11_ = action;
	_tmp12_ = plugin;
	_tmp13_ = rygel_media_server_plugin_get_search_caps (_tmp12_);
	_tmp14_ = _tmp13_;
	gupnp_service_action_set (_tmp11_, "SearchCaps", G_TYPE_STRING, _tmp14_, NULL);
	_tmp15_ = action;
	gupnp_service_action_return (_tmp15_);
	_g_object_unref0 (plugin);
}


static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaServerPlugin* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	g_value_init (value, G_TYPE_STRING);
	_tmp7_ = rygel_media_server_plugin_get_search_caps (plugin);
	_tmp8_ = _tmp7_;
	g_value_set_string (value, _tmp8_);
	_g_object_unref0 (plugin);
}


static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_set (_tmp4_, "SortCaps", G_TYPE_STRING, RYGEL_MEDIA_OBJECTS_SORT_CAPS, NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	g_value_set_string (value, RYGEL_MEDIA_OBJECTS_SORT_CAPS);
}


static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = self->feature_list;
	gupnp_service_action_set (_tmp4_, "FeatureList", G_TYPE_STRING, _tmp5_, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->feature_list;
	g_value_set_string (value, _tmp0_);
}


static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	update_ids = _tmp0_;
	{
		GeeArrayList* _container_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _container_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _container_index = 0;
		_tmp1_ = self->priv->updated_containers;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_container_list = _tmp2_;
		_tmp3_ = _container_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_container_size = _tmp5_;
		_container_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelMediaContainer* container = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			RygelMediaContainer* _tmp21_ = NULL;
			guint32 _tmp22_ = 0U;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp6_ = _container_index;
			_container_index = _tmp6_ + 1;
			_tmp7_ = _container_index;
			_tmp8_ = _container_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _container_list;
			_tmp10_ = _container_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			container = (RygelMediaContainer*) _tmp11_;
			_tmp12_ = update_ids;
			if (g_strcmp0 (_tmp12_, "") != 0) {
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp13_ = update_ids;
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
				_g_free0 (update_ids);
				update_ids = _tmp14_;
			}
			_tmp15_ = update_ids;
			_tmp16_ = container;
			_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = container;
			_tmp22_ = _tmp21_->update_id;
			_tmp23_ = g_strdup_printf ("%u", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp15_, _tmp26_, NULL);
			_g_free0 (update_ids);
			update_ids = _tmp27_;
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_list);
	}
	result = update_ids;
	return result;
}


static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self) {
	gboolean result = FALSE;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaServerPlugin* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	guint32 _tmp9_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = self->system_update_id;
	self->system_update_id = _tmp7_ + 1;
	_tmp9_ = self->system_update_id;
	if (_tmp9_ == ((guint32) 0)) {
		RygelMediaServerPlugin* _tmp10_ = NULL;
		RygelPluginCapabilities _tmp11_ = 0;
		RygelPluginCapabilities _tmp12_ = 0;
		_tmp10_ = plugin;
		_tmp11_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = (_tmp12_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		rygel_content_directory_service_reset (self, NULL, NULL);
		result = TRUE;
		_g_object_unref0 (plugin);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (plugin);
	return result;
}


static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = updated_container;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		RygelMediaObject* _tmp1_ = NULL;
		RygelObjectEventType _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = object;
		_tmp2_ = event_type;
		_tmp3_ = sub_tree_update;
		rygel_content_directory_add_last_change_entry (self, _tmp1_, _tmp2_, _tmp3_);
	}
}


static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type) {
	gboolean result = FALSE;
	gboolean container_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelObjectEventType _tmp2_ = 0;
	RygelMediaObject* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	RygelMediaObject* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (updated_container != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	container_changed = FALSE;
	_tmp2_ = event_type;
	if (_tmp2_ == RYGEL_OBJECT_EVENT_TYPE_ADDED) {
		_tmp1_ = TRUE;
	} else {
		RygelObjectEventType _tmp3_ = 0;
		_tmp3_ = event_type;
		_tmp1_ = _tmp3_ == RYGEL_OBJECT_EVENT_TYPE_DELETED;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		RygelObjectEventType _tmp5_ = 0;
		_tmp5_ = event_type;
		if (_tmp5_ == RYGEL_OBJECT_EVENT_TYPE_MODIFIED) {
			RygelMediaObject* _tmp6_ = NULL;
			_tmp6_ = object;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_MEDIA_ITEM);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		RygelMediaContainer* _tmp7_ = NULL;
		guint32 _tmp8_ = 0U;
		_tmp7_ = updated_container;
		_tmp8_ = self->system_update_id;
		_tmp7_->update_id = _tmp8_;
		container_changed = TRUE;
	}
	_tmp9_ = object;
	_tmp10_ = self->system_update_id;
	rygel_media_object_set_object_update_id (_tmp9_, (guint) _tmp10_);
	_tmp11_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaObject* _tmp12_ = NULL;
		guint32 _tmp13_ = 0U;
		_tmp12_ = object;
		_tmp13_ = self->system_update_id;
		(G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL)->update_id = _tmp13_;
	}
	result = container_changed;
	return result;
}


static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object) {
	gboolean updated = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	gboolean is_container = FALSE;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = updated_container;
	updated = _tmp0_ != NULL;
	_tmp1_ = object;
	is_container = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_CONTAINER);
	_tmp3_ = updated;
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = is_container;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	_tmp5_ = self->priv->clear_updated_containers;
	if (_tmp5_) {
		GeeArrayList* _tmp6_ = NULL;
		_tmp6_ = self->priv->updated_containers;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
		self->priv->clear_updated_containers = FALSE;
	}
	_tmp7_ = updated;
	if (_tmp7_) {
		GeeArrayList* _tmp8_ = NULL;
		RygelMediaContainer* _tmp9_ = NULL;
		GeeArrayList* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		_tmp8_ = self->priv->updated_containers;
		_tmp9_ = updated_container;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
		_tmp10_ = self->priv->updated_containers;
		_tmp11_ = updated_container;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	}
	_tmp12_ = is_container;
	if (_tmp12_) {
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaContainer* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		RygelMediaContainer* _tmp18_ = NULL;
		_tmp13_ = object;
		_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
		container = _tmp14_;
		_tmp15_ = self->priv->updated_containers;
		_tmp16_ = container;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp15_, _tmp16_);
		_tmp17_ = self->priv->updated_containers;
		_tmp18_ = container;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		_g_object_unref0 (container);
	}
}


/**
     * handler for container_updated signal on root_container. We don't
     * immediately send the notification for changes but schedule the
     * notification after 0.2 seconds. Also we don't clear the updated
     * container list immediately after notification but rather in this
     * function. Please refer to ContentDirectory version 2 specs for details
     * on why we do all this the way we do.
     *
     * @param root_container the root_container
     * @param updated_container the container that just got updated
     */
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	RygelObjectEventType _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean changed = FALSE;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaObject* _tmp6_ = NULL;
	RygelObjectEventType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	RygelMediaContainer* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	RygelMediaObject* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (updated_container != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = rygel_content_directory_handle_system_update (self);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = updated_container;
	_tmp2_ = object;
	_tmp3_ = event_type;
	_tmp4_ = sub_tree_update;
	rygel_content_directory_handle_last_change (self, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = updated_container;
	_tmp6_ = object;
	_tmp7_ = event_type;
	_tmp8_ = rygel_content_directory_set_update_ids (self, _tmp5_, _tmp6_, _tmp7_);
	changed = _tmp8_;
	_tmp10_ = changed;
	if (_tmp10_) {
		RygelMediaContainer* _tmp11_ = NULL;
		_tmp11_ = updated_container;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = NULL;
	}
	_tmp12_ = object;
	rygel_content_directory_handle_container_update_ids (self, _tmp9_, _tmp12_);
	rygel_content_directory_ensure_timeout (self);
}


static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root) {
	RygelLastChangeStDone* entry = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
	RygelLastChangeStDone* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_container != NULL);
	g_return_if_fail (sub_tree_root != NULL);
	_tmp0_ = sub_tree_root;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->system_update_id;
	_tmp4_ = rygel_last_change_st_done_new (_tmp2_, (guint) _tmp3_);
	entry = _tmp4_;
	_tmp5_ = self->priv->last_change;
	rygel_last_change_add_event (_tmp5_, (RygelLastChangeEntry*) entry);
	rygel_content_directory_ensure_timeout (self);
	_g_object_unref0 (entry);
}


static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self) {
	gboolean result = FALSE;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	RygelLastChange* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
	update_ids = _tmp0_;
	gupnp_service_notify ((GUPnPService*) self, "ContainerUpdateIDs", G_TYPE_STRING, update_ids, NULL);
	_tmp1_ = self->system_update_id;
	gupnp_service_notify ((GUPnPService*) self, "SystemUpdateID", G_TYPE_UINT, _tmp1_, NULL);
	_tmp2_ = self->priv->last_change;
	_tmp3_ = rygel_last_change_get_log (_tmp2_);
	_tmp4_ = _tmp3_;
	gupnp_service_notify ((GUPnPService*) self, "LastChange", G_TYPE_STRING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	self->priv->clear_updated_containers = TRUE;
	self->priv->update_notify_id = (guint) 0;
	_tmp5_ = self->priv->last_change;
	rygel_last_change_clear_on_new_event (_tmp5_);
	result = FALSE;
	_g_free0 (update_ids);
	return result;
}


static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* ids = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	ids = _tmp0_;
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _import_index = 0;
		_tmp1_ = self->priv->active_imports;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_import_list = _tmp2_;
		_tmp3_ = _import_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_import_size = _tmp5_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelImportResource* _tmp16_ = NULL;
			guint32 _tmp17_ = 0U;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp6_ = _import_index;
			_import_index = _tmp6_ + 1;
			_tmp7_ = _import_index;
			_tmp8_ = _import_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _import_list;
			_tmp10_ = _import_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			import = (RygelImportResource*) _tmp11_;
			_tmp12_ = ids;
			if (g_strcmp0 (_tmp12_, "") != 0) {
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp13_ = ids;
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
				_g_free0 (ids);
				ids = _tmp14_;
			}
			_tmp15_ = ids;
			_tmp16_ = import;
			_tmp17_ = _tmp16_->transfer_id;
			_tmp18_ = g_strdup_printf ("%u", _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
			_g_free0 (ids);
			ids = _tmp20_;
			_g_free0 (_tmp19_);
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	result = ids;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelContentDirectory* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->import);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda11_ (Block4Data* _data4_) {
	RygelContentDirectory* self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	self = _data4_->self;
	_tmp0_ = self->priv->finished_imports;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data4_->import);
	result = FALSE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ (self);
	return result;
}


static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine) {
	Block4Data* _data4_;
	RygelStateMachine* _tmp0_ = NULL;
	RygelImportResource* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = machine;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_IMPORT_RESOURCE) ? ((RygelImportResource*) _tmp0_) : NULL);
	_data4_->import = _tmp1_;
	_tmp2_ = self->priv->finished_imports;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data4_->import);
	_tmp3_ = self->priv->active_imports;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _data4_->import);
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
	_tmp5_ = _tmp4_;
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
	_g_free0 (_tmp5_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda11__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error) {
	RygelImportResource* result = NULL;
	RygelImportResource* ret = NULL;
	guint32 transfer_id = 0U;
	gchar* transfer_id_string = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint32 _tmp2_ = 0U;
	RygelImportResource* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	ret = NULL;
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "TransferID", G_TYPE_UINT, &transfer_id, "TransferID", G_TYPE_STRING, &transfer_id_string, NULL);
	_tmp2_ = transfer_id;
	if (_tmp2_ == ((guint32) 0)) {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		_tmp4_ = transfer_id_string;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = transfer_id_string;
			_tmp3_ = g_strcmp0 (_tmp5_, "0") != 0;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("Invalid argument");
		_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (transfer_id_string);
			_g_object_unref0 (ret);
			return NULL;
		} else {
			_g_free0 (transfer_id_string);
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _import_index = 0;
		_tmp8_ = self->priv->active_imports;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_import_list = _tmp9_;
		_tmp10_ = _import_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_import_size = _tmp12_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			RygelImportResource* _tmp19_ = NULL;
			guint32 _tmp20_ = 0U;
			guint32 _tmp21_ = 0U;
			_tmp13_ = _import_index;
			_import_index = _tmp13_ + 1;
			_tmp14_ = _import_index;
			_tmp15_ = _import_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _import_list;
			_tmp17_ = _import_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			import = (RygelImportResource*) _tmp18_;
			_tmp19_ = import;
			_tmp20_ = _tmp19_->transfer_id;
			_tmp21_ = transfer_id;
			if (_tmp20_ == _tmp21_) {
				RygelImportResource* _tmp22_ = NULL;
				RygelImportResource* _tmp23_ = NULL;
				_tmp22_ = import;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (ret);
				ret = _tmp23_;
				_g_object_unref0 (import);
				break;
			}
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp24_ = NULL;
		GeeArrayList* _tmp25_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _import_index = 0;
		_tmp24_ = self->priv->finished_imports;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_import_list = _tmp25_;
		_tmp26_ = _import_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_import_size = _tmp28_;
		_import_index = -1;
		while (TRUE) {
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gpointer _tmp34_ = NULL;
			RygelImportResource* _tmp35_ = NULL;
			guint32 _tmp36_ = 0U;
			guint32 _tmp37_ = 0U;
			_tmp29_ = _import_index;
			_import_index = _tmp29_ + 1;
			_tmp30_ = _import_index;
			_tmp31_ = _import_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _import_list;
			_tmp33_ = _import_index;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
			import = (RygelImportResource*) _tmp34_;
			_tmp35_ = import;
			_tmp36_ = _tmp35_->transfer_id;
			_tmp37_ = transfer_id;
			if (_tmp36_ == _tmp37_) {
				RygelImportResource* _tmp38_ = NULL;
				RygelImportResource* _tmp39_ = NULL;
				_tmp38_ = import;
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_g_object_unref0 (ret);
				ret = _tmp39_;
				_g_object_unref0 (import);
				break;
			}
			_g_object_unref0 (import);
		}
		_g_object_unref0 (_import_list);
	}
	_tmp40_ = ret;
	if (_tmp40_ == NULL) {
		const gchar* _tmp41_ = NULL;
		GError* _tmp42_ = NULL;
		_tmp41_ = _ ("No such file transfer");
		_tmp42_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER, _tmp41_);
		_inner_error_ = _tmp42_;
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (transfer_id_string);
			_g_object_unref0 (ret);
			return NULL;
		} else {
			_g_free0 (transfer_id_string);
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ret;
	_g_free0 (transfer_id_string);
	return result;
}


static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelLastChange* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->priv->last_change;
	_tmp1_ = rygel_last_change_get_log (_tmp0_);
	_tmp2_ = _tmp1_;
	g_value_set_string (value, _tmp2_);
	_g_free0 (_tmp2_);
}


static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_content_directory_update_notify ((RygelContentDirectory*) self);
	return result;
}


static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->update_notify_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_content_directory_update_notify_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->update_notify_id = _tmp1_;
	}
}


static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelLastChangeEntry* entry = NULL;
	RygelObjectEventType _tmp0_ = 0;
	RygelLastChange* _tmp27_ = NULL;
	RygelLastChangeEntry* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = event_type;
	switch (_tmp0_) {
		case RYGEL_OBJECT_EVENT_TYPE_ADDED:
		{
			RygelMediaObject* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			guint32 _tmp4_ = 0U;
			gboolean _tmp5_ = FALSE;
			RygelMediaObject* _tmp6_ = NULL;
			RygelMediaContainer* _tmp7_ = NULL;
			RygelMediaContainer* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			RygelLastChangeObjAdd* _tmp14_ = NULL;
			_tmp1_ = object;
			_tmp2_ = rygel_media_object_get_id (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = self->system_update_id;
			_tmp5_ = sub_tree_update;
			_tmp6_ = object;
			_tmp7_ = rygel_media_object_get_parent (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = object;
			_tmp12_ = rygel_media_object_get_upnp_class (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = rygel_last_change_obj_add_new (_tmp3_, (guint) _tmp4_, _tmp5_, _tmp10_, _tmp13_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp14_;
			break;
		}
		case RYGEL_OBJECT_EVENT_TYPE_MODIFIED:
		{
			RygelMediaObject* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			guint32 _tmp18_ = 0U;
			gboolean _tmp19_ = FALSE;
			RygelLastChangeObjMod* _tmp20_ = NULL;
			_tmp15_ = object;
			_tmp16_ = rygel_media_object_get_id (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->system_update_id;
			_tmp19_ = sub_tree_update;
			_tmp20_ = rygel_last_change_obj_mod_new (_tmp17_, (guint) _tmp18_, _tmp19_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp20_;
			break;
		}
		case RYGEL_OBJECT_EVENT_TYPE_DELETED:
		{
			RygelMediaObject* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			guint32 _tmp24_ = 0U;
			gboolean _tmp25_ = FALSE;
			RygelLastChangeObjDel* _tmp26_ = NULL;
			_tmp21_ = object;
			_tmp22_ = rygel_media_object_get_id (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->system_update_id;
			_tmp25_ = sub_tree_update;
			_tmp26_ = rygel_last_change_obj_del_new (_tmp23_, (guint) _tmp24_, _tmp25_);
			_g_object_unref0 (entry);
			entry = (RygelLastChangeEntry*) _tmp26_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp27_ = self->priv->last_change;
	_tmp28_ = entry;
	rygel_last_change_add_event (_tmp27_, _tmp28_);
	_g_object_unref0 (entry);
}


static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = self->priv->service_reset_token;
	gupnp_service_action_set (_tmp0_, "ResetToken", G_TYPE_STRING, _tmp1_, NULL);
	_tmp2_ = action;
	gupnp_service_action_return (_tmp2_);
}


static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_value_init (value, G_TYPE_STRING);
	_tmp0_ = self->priv->service_reset_token;
	g_value_set_string (value, _tmp0_);
}


static void rygel_content_directory_service_reset_data_free (gpointer _data) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelContentDirectoryServiceResetData, _data_);
}


static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	RygelContentDirectory* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelContentDirectoryServiceResetData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_content_directory_service_reset);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_content_directory_service_reset_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_content_directory_service_reset_co (_data_);
}


static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_content_directory_service_reset_co (_data_);
}


static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("rygel-content-directory.vala:708: SystemUpdateID overflow, initiating " \
"service reset procedure");
	_data_->_tmp0_ = NULL;
	g_object_get ((GUPnPService*) _data_->self, "root-device", &_data_->_tmp0_, NULL);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _data_->_tmp4_) : NULL);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp2_);
	_data_->plugin = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->plugin;
	rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp7_, FALSE);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = uuid_get ();
	_g_free0 (_data_->self->priv->service_reset_token);
	_data_->self->priv->service_reset_token = _data_->_tmp8_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->self->root_container;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->root_container;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->_tmp10_) : NULL);
		_data_->trackable = _data_->_tmp11_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->trackable;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->service_reset_token;
		rygel_trackable_container_set_service_reset_token (_data_->_tmp12_, _data_->_tmp13_);
		_g_object_unref0 (_data_->trackable);
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp14_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->expression;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup ("upnp:objectUpdateID");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand1);
	((RygelSearchExpression*) _data_->_tmp15_)->operand1 = _data_->_tmp16_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->expression;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_strdup ("true");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp17_)->operand2);
	((RygelSearchExpression*) _data_->_tmp17_)->operand2 = _data_->_tmp18_;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp19_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
	{
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->self->root_container;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp20_) : NULL);
		_data_->root = _data_->_tmp21_;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->root;
		if (_data_->_tmp22_ == NULL) {
			_g_object_unref0 (_data_->root);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_object_unref0 (_data_->plugin);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->matches = (guint32) 0;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->root;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->expression;
		_data_->_tmp25_ = 0U;
		_data_->_state_ = 1;
		rygel_searchable_container_search (_data_->_tmp23_, (RygelSearchExpression*) _data_->_tmp24_, (guint) 0, (guint) 0, "", NULL, rygel_content_directory_service_reset_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = rygel_searchable_container_search_finish (_data_->_tmp23_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error_);
		_data_->matches = (guint32) _data_->_tmp25_;
		_data_->objects = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->root);
			goto __catch26_g_error;
		}
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->objects;
		_data_->_tmp28_ = 0;
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
		_data_->_tmp29_ = 0;
		_data_->_tmp29_ = _data_->_tmp28_;
		if (_data_->_tmp29_ > 0) {
			_data_->count = (guint32) 1;
			{
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->objects;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
				_data_->_object_list = _data_->_tmp31_;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->_object_list;
				_data_->_tmp33_ = 0;
				_data_->_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp32_);
				_data_->_tmp34_ = 0;
				_data_->_tmp34_ = _data_->_tmp33_;
				_data_->_object_size = _data_->_tmp34_;
				_data_->_object_index = -1;
				while (TRUE) {
					_data_->_tmp35_ = 0;
					_data_->_tmp35_ = _data_->_object_index;
					_data_->_object_index = _data_->_tmp35_ + 1;
					_data_->_tmp36_ = 0;
					_data_->_tmp36_ = _data_->_object_index;
					_data_->_tmp37_ = 0;
					_data_->_tmp37_ = _data_->_object_size;
					if (!(_data_->_tmp36_ < _data_->_tmp37_)) {
						break;
					}
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = _data_->_object_list;
					_data_->_tmp39_ = 0;
					_data_->_tmp39_ = _data_->_object_index;
					_data_->_tmp40_ = NULL;
					_data_->_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp38_, _data_->_tmp39_);
					_data_->object = (RygelMediaObject*) _data_->_tmp40_;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = _data_->object;
					_data_->_tmp42_ = 0U;
					_data_->_tmp42_ = _data_->count;
					_data_->count = _data_->_tmp42_ + 1;
					rygel_media_object_set_object_update_id (_data_->_tmp41_, (guint) _data_->_tmp42_);
					_data_->_tmp43_ = NULL;
					_data_->_tmp43_ = _data_->object;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp43_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
						_data_->_tmp44_ = NULL;
						_data_->_tmp44_ = _data_->object;
						_data_->_tmp45_ = NULL;
						_data_->_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp44_) : NULL);
						_data_->container = _data_->_tmp45_;
						_data_->_tmp46_ = NULL;
						_data_->_tmp46_ = _data_->container;
						_data_->_tmp47_ = NULL;
						_data_->_tmp47_ = _data_->container;
						_data_->_tmp48_ = 0U;
						_data_->_tmp48_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) _data_->_tmp47_);
						_data_->_tmp49_ = 0U;
						_data_->_tmp49_ = _data_->_tmp48_;
						_data_->_tmp46_->update_id = (guint32) _data_->_tmp49_;
						_data_->_tmp50_ = NULL;
						_data_->_tmp50_ = _data_->container;
						_data_->_tmp50_->total_deleted_child_count = (gint64) 0;
						_g_object_unref0 (_data_->container);
					}
					_g_object_unref0 (_data_->object);
				}
				_g_object_unref0 (_data_->_object_list);
			}
			_data_->_tmp51_ = 0U;
			_data_->_tmp51_ = _data_->count;
			_data_->self->system_update_id = _data_->_tmp51_ - 1;
			_data_->_tmp52_ = 0U;
			_data_->_tmp52_ = _data_->self->system_update_id;
			g_debug ("rygel-content-directory.vala:751: New SystemUpdateID is %u", (guint) _data_->_tmp52_);
		}
		g_debug ("rygel-content-directory.vala:754: Service reset procedure done, device" \
" coming up again");
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = _data_->plugin;
		rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp53_, TRUE);
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->self->priv->service_reset_token;
		g_debug ("rygel-content-directory.vala:756: New service reset token is %s", _data_->_tmp54_);
		_g_object_unref0 (_data_->objects);
		_g_object_unref0 (_data_->root);
	}
	goto __finally26;
	__catch26_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		g_warning ("rygel-content-directory.vala:757: Failed to search for objects...");
		_g_error_free0 (_data_->_error_);
	}
	__finally26:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_rygel_search_expression_unref0 (_data_->expression);
		_g_object_unref0 (_data_->plugin);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_rygel_search_expression_unref0 (_data_->expression);
	_g_object_unref0 (_data_->plugin);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
	return self ? rygel_dlna_profile_ref (self) : NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	gchar* upload_profiles = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_ = NULL;
	GUPnPRootDevice* _tmp6_ = NULL;
	GUPnPResourceFactory* _tmp7_ = NULL;
	GUPnPResourceFactory* _tmp8_ = NULL;
	RygelMediaServerPlugin* _tmp9_ = NULL;
	RygelMediaServerPlugin* _tmp10_ = NULL;
	GList* profiles = NULL;
	RygelMediaServerPlugin* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gchar** requested_profiles = NULL;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint requested_profiles_length1 = 0;
	gint _requested_profiles_size_ = 0;
	GString* builder = NULL;
	GString* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	GString* _tmp39_ = NULL;
	gssize _tmp40_ = 0L;
	GUPnPServiceAction* _tmp44_ = NULL;
	GString* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	GUPnPServiceAction* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_dir != NULL);
	g_return_if_fail (action != NULL);
	upload_profiles = NULL;
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "UploadProfiles", G_TYPE_STRING, &upload_profiles, NULL);
	_tmp1_ = upload_profiles;
	if (_tmp1_ == NULL) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		_g_free0 (upload_profiles);
		return;
	}
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp6_);
	plugin = _tmp10_;
	_tmp11_ = plugin;
	_tmp12_ = rygel_media_server_plugin_get_upload_profiles (_tmp11_);
	_tmp13_ = _tmp12_;
	profiles = _tmp13_;
	_tmp14_ = upload_profiles;
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, ",", 0);
	requested_profiles = _tmp16_;
	requested_profiles_length1 = _vala_array_length (_tmp15_);
	_requested_profiles_size_ = requested_profiles_length1;
	_tmp17_ = g_string_new ("");
	builder = _tmp17_;
	_tmp18_ = profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp18_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			RygelDLNAProfile* _tmp19_ = NULL;
			RygelDLNAProfile* profile = NULL;
			_tmp19_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
			profile = _tmp19_;
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				RygelDLNAProfile* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp30_ = FALSE;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				_tmp22_ = profile;
				_tmp23_ = _tmp22_->name;
				_tmp24_ = g_str_has_suffix (_tmp23_, "_ICO");
				if (_tmp24_) {
					_tmp21_ = TRUE;
				} else {
					RygelDLNAProfile* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					_tmp25_ = profile;
					_tmp26_ = _tmp25_->name;
					_tmp27_ = g_str_has_suffix (_tmp26_, "_TN");
					_tmp21_ = _tmp27_;
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					RygelDLNAProfile* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp28_ = profile;
					_tmp29_ = _tmp28_->name;
					_tmp20_ = g_strcmp0 (_tmp29_, "DIDL_S") == 0;
				}
				if (_tmp20_) {
					_rygel_dlna_profile_unref0 (profile);
					continue;
				}
				_tmp31_ = requested_profiles;
				_tmp31__length1 = requested_profiles_length1;
				if (_tmp31__length1 == 0) {
					_tmp30_ = TRUE;
				} else {
					RygelDLNAProfile* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					_tmp32_ = profile;
					_tmp33_ = _tmp32_->name;
					_tmp34_ = requested_profiles;
					_tmp34__length1 = requested_profiles_length1;
					_tmp30_ = _vala_string_array_contains (_tmp34_, _tmp34__length1, _tmp33_);
				}
				if (_tmp30_) {
					GString* _tmp35_ = NULL;
					RygelDLNAProfile* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					GString* _tmp38_ = NULL;
					_tmp35_ = builder;
					_tmp36_ = profile;
					_tmp37_ = _tmp36_->name;
					g_string_append (_tmp35_, _tmp37_);
					_tmp38_ = builder;
					g_string_append (_tmp38_, ",");
				}
				_rygel_dlna_profile_unref0 (profile);
			}
		}
	}
	_tmp39_ = builder;
	_tmp40_ = _tmp39_->len;
	if (_tmp40_ > ((gssize) 0)) {
		GString* _tmp41_ = NULL;
		GString* _tmp42_ = NULL;
		gssize _tmp43_ = 0L;
		_tmp41_ = builder;
		_tmp42_ = builder;
		_tmp43_ = _tmp42_->len;
		g_string_truncate (_tmp41_, (gsize) (_tmp43_ - 1));
	}
	_tmp44_ = action;
	_tmp45_ = builder;
	_tmp46_ = _tmp45_->str;
	gupnp_service_action_set (_tmp44_, "SupportedUploadProfiles", G_TYPE_STRING, _tmp46_, NULL);
	_tmp47_ = action;
	gupnp_service_action_return (_tmp47_);
	_g_string_free0 (builder);
	requested_profiles = (_vala_array_free (requested_profiles, requested_profiles_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (plugin);
	_g_free0 (upload_profiles);
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
	return self;
}


RygelContentDirectory* rygel_content_directory_new (void) {
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
	((GObjectClass *) klass)->constructed = rygel_content_directory_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_free0 (self->feature_list);
	_g_object_unref0 (self->http_server);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->priv->updated_containers);
	_g_object_unref0 (self->priv->active_imports);
	_g_object_unref0 (self->priv->finished_imports);
	_g_object_unref0 (self->cancellable);
	_g_object_unref0 (self->priv->last_change);
	_g_free0 (self->priv->service_reset_token);
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override create_root_container method.
 */
GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (gupnp_service_get_type (), "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



