/* rygel-basic-management.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-basic-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_BASIC_MANAGEMENT (rygel_basic_management_get_type ())
#define RYGEL_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement))
#define RYGEL_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))
#define RYGEL_IS_BASIC_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_IS_BASIC_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT))
#define RYGEL_BASIC_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementClass))

typedef struct _RygelBasicManagement RygelBasicManagement;
typedef struct _RygelBasicManagementClass RygelBasicManagementClass;
typedef struct _RygelBasicManagementPrivate RygelBasicManagementPrivate;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())
typedef struct _Block1Data Block1Data;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE (rygel_basic_management_test_traceroute_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTraceroute))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_TRACEROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE))
#define RYGEL_BASIC_MANAGEMENT_TEST_TRACEROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE, RygelBasicManagementTestTracerouteClass))

typedef struct _RygelBasicManagementTestTraceroute RygelBasicManagementTestTraceroute;
typedef struct _RygelBasicManagementTestTracerouteClass RygelBasicManagementTestTracerouteClass;

struct _RygelBasicManagement {
	GUPnPService parent_instance;
	RygelBasicManagementPrivate * priv;
	gchar* device_status;
};

struct _RygelBasicManagementClass {
	GUPnPServiceClass parent_class;
};

struct _RygelBasicManagementPrivate {
	guint _max_history_size;
	GeeHashMap* tests_map;
	GeeHashMap* test_ids_by_type;
	guint current_id;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _Block1Data {
	int _ref_count_;
	RygelBasicManagement* self;
	RygelBasicManagementTest* bm_test;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;


static gpointer rygel_basic_management_parent_class = NULL;

GType rygel_basic_management_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
#define RYGEL_BASIC_MANAGEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagementPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE
};
#define RYGEL_BASIC_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:BasicManagement"
#define RYGEL_BASIC_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:BasicManagement:2"
#define RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH "xml/BasicManagement2.xml"
static void rygel_basic_management_real_constructed (GObject* base);
static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val);
static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action);
static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only);
gboolean rygel_basic_management_test_is_active (RygelBasicManagementTest* self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_basic_management_test_run (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_basic_management_test_run_finish (RygelBasicManagementTest* self, GAsyncResult* _res_);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest** bm_test);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestExecutionState rygel_basic_management_test_get_execution_state (RygelBasicManagementTest* self);
gchar* rygel_basic_management_test_execution_state_to_string (RygelBasicManagementTestExecutionState self);
GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time);
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string);
GType rygel_basic_management_test_traceroute_get_type (void) G_GNUC_CONST;
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_new (const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
RygelBasicManagementTestTraceroute* rygel_basic_management_test_traceroute_construct (GType object_type, const gchar* host, guint32 wait_time_out, guint data_block_size, guint max_hop_count, guint dscp);
void rygel_basic_management_test_traceroute_get_results (RygelBasicManagementTestTraceroute* self, gchar** status, gchar** additional_info, guint32* response_time, gchar** hop_ips);
RygelBasicManagement* rygel_basic_management_new (void);
RygelBasicManagement* rygel_basic_management_construct (GType object_type);
void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value);
static void rygel_basic_management_finalize (GObject* obj);
static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_device_status_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_basic_management_query_active_test_ids_cb ((RygelBasicManagement*) self, _sender, variable, value);
}


static void _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_device_status_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_ping_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_ping_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_ping_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_nslookup_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_nslookup_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_traceroute_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_traceroute_result_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_active_test_ids_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_get_test_info_cb ((RygelBasicManagement*) self, _sender, action);
}


static void _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_basic_management_cancel_test_cb ((RygelBasicManagement*) self, _sender, action);
}


static void rygel_basic_management_real_constructed (GObject* base) {
	RygelBasicManagement * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GTimeVal now = {0};
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = (RygelBasicManagement*) base;
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tests_map);
	self->priv->tests_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->test_ids_by_type);
	self->priv->test_ids_by_type = _tmp1_;
	g_get_current_time (&now);
	now.tv_usec = (glong) 0;
	_tmp2_ = g_time_val_to_iso8601 (&now);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("OK,", _tmp3_, NULL);
	_g_free0 (self->device_status);
	self->device_status = _tmp4_;
	_g_free0 (_tmp3_);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::DeviceStatus", (GCallback) _rygel_basic_management_query_device_status_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TestIDs", (GCallback) _rygel_basic_management_query_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ActiveTestIDs", (GCallback) _rygel_basic_management_query_active_test_ids_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceStatus", (GCallback) _rygel_basic_management_get_device_status_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Ping", (GCallback) _rygel_basic_management_ping_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPingResult", (GCallback) _rygel_basic_management_ping_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::NSLookup", (GCallback) _rygel_basic_management_nslookup_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetNSLookupResult", (GCallback) _rygel_basic_management_nslookup_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Traceroute", (GCallback) _rygel_basic_management_traceroute_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTracerouteResult", (GCallback) _rygel_basic_management_traceroute_result_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestIDs", (GCallback) _rygel_basic_management_get_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetActiveTestIDs", (GCallback) _rygel_basic_management_get_active_test_ids_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTestInfo", (GCallback) _rygel_basic_management_get_test_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CancelTest", (GCallback) _rygel_basic_management_cancel_test_cb_gupnp_service_action_invoked, self, 0);
}


static gchar* rygel_basic_management_create_test_ids_list (RygelBasicManagement* self, gboolean active_only) {
	gchar* result = NULL;
	gchar* test_ids_list = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	test_ids_list = _tmp0_;
	{
		GeeIterator* _test_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = self->priv->tests_map;
		_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_test_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			RygelBasicManagementTest* test = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			const gchar* _tmp20_ = NULL;
			RygelBasicManagementTest* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp7_ = _test_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _test_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			test = (RygelBasicManagementTest*) _tmp10_;
			_tmp12_ = active_only;
			if (_tmp12_) {
				RygelBasicManagementTest* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = test;
				_tmp14_ = rygel_basic_management_test_is_active (_tmp13_);
				_tmp11_ = !_tmp14_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_g_object_unref0 (test);
				continue;
			}
			_tmp15_ = test_ids_list;
			_tmp16_ = strlen (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > 0) {
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp18_ = test_ids_list;
				_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
				_g_free0 (test_ids_list);
				test_ids_list = _tmp19_;
			}
			_tmp20_ = test_ids_list;
			_tmp21_ = test;
			_tmp22_ = _tmp21_->id;
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
			_g_free0 (test_ids_list);
			test_ids_list = _tmp23_;
			_g_object_unref0 (test);
		}
		_g_object_unref0 (_test_it);
	}
	result = test_ids_list;
	return result;
}


static gchar* rygel_basic_management_add_test (RygelBasicManagement* self, RygelBasicManagementTest* test) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	RygelBasicManagementTest* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelBasicManagementTest* _tmp7_ = NULL;
	GeeLinkedList* type_test_ids = NULL;
	GeeHashMap* _tmp8_ = NULL;
	RygelBasicManagementTest* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp20_ = NULL;
	RygelBasicManagementTest* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GeeLinkedList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	guint _tmp26_ = 0U;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	RygelBasicManagementTest* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = self->priv->current_id;
	self->priv->current_id = _tmp0_ + 1;
	_tmp1_ = test;
	_tmp2_ = self->priv->current_id;
	_tmp3_ = g_strdup_printf ("%u", _tmp2_);
	_g_free0 (_tmp1_->id);
	_tmp1_->id = _tmp3_;
	_tmp4_ = self->priv->tests_map;
	_tmp5_ = test;
	_tmp6_ = _tmp5_->id;
	_tmp7_ = test;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp6_, _tmp7_);
	_tmp8_ = self->priv->test_ids_by_type;
	_tmp9_ = test;
	_tmp10_ = rygel_basic_management_test_get_method_type (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp11_);
	_g_object_unref0 (type_test_ids);
	type_test_ids = (GeeLinkedList*) _tmp12_;
	_tmp13_ = type_test_ids;
	if (_tmp13_ == NULL) {
		GeeLinkedList* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		RygelBasicManagementTest* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GeeLinkedList* _tmp19_ = NULL;
		_tmp14_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (type_test_ids);
		type_test_ids = _tmp14_;
		_tmp15_ = self->priv->test_ids_by_type;
		_tmp16_ = test;
		_tmp17_ = rygel_basic_management_test_get_method_type (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = type_test_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
	}
	_tmp20_ = type_test_ids;
	_tmp21_ = test;
	_tmp22_ = _tmp21_->id;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp22_);
	_tmp23_ = type_test_ids;
	_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_max_history_size;
	if (((guint) _tmp25_) > _tmp26_) {
		gchar* old_id = NULL;
		GeeLinkedList* _tmp27_ = NULL;
		gpointer _tmp28_ = NULL;
		GeeHashMap* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gpointer _tmp31_ = NULL;
		RygelBasicManagementTest* _tmp32_ = NULL;
		GCancellable* _tmp33_ = NULL;
		GCancellable* _tmp34_ = NULL;
		GeeHashMap* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		_tmp27_ = type_test_ids;
		_tmp28_ = gee_deque_poll_head ((GeeDeque*) _tmp27_);
		old_id = (gchar*) _tmp28_;
		_tmp29_ = self->priv->tests_map;
		_tmp30_ = old_id;
		_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
		_tmp32_ = (RygelBasicManagementTest*) _tmp31_;
		_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp32_);
		_tmp34_ = _tmp33_;
		g_cancellable_cancel (_tmp34_);
		_g_object_unref0 (_tmp32_);
		_tmp35_ = self->priv->tests_map;
		_tmp36_ = old_id;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp35_, _tmp36_, NULL);
		_g_free0 (old_id);
	}
	_tmp37_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp38_ = _tmp37_;
	gupnp_service_notify ((GUPnPService*) self, "TestIDs", G_TYPE_STRING, _tmp38_, NULL);
	_g_free0 (_tmp38_);
	_tmp39_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp40_ = _tmp39_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp40_, NULL);
	_g_free0 (_tmp40_);
	_tmp41_ = test;
	_tmp42_ = _tmp41_->id;
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_object_unref0 (type_test_ids);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelBasicManagement* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->bm_test);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	RygelBasicManagement* self;
	RygelBasicManagementTest* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data1_->bm_test;
	_tmp1_ = res;
	rygel_basic_management_test_run_finish (_tmp0_, _tmp1_);
	_tmp2_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp3_ = _tmp2_;
	gupnp_service_notify ((GUPnPService*) self, "ActiveTestIDs", G_TYPE_STRING, _tmp3_, NULL);
	_g_free0 (_tmp3_);
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ (self, source_object, res);
	block1_data_unref (self);
}


static void rygel_basic_management_add_test_and_return_action (RygelBasicManagement* self, RygelBasicManagementTest* bm_test, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	RygelBasicManagementTest* _tmp0_ = NULL;
	RygelBasicManagementTest* _tmp1_ = NULL;
	gchar* id = NULL;
	RygelBasicManagementTest* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelBasicManagementTest* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm_test != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = bm_test;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->bm_test);
	_data1_->bm_test = _tmp1_;
	_tmp2_ = _data1_->bm_test;
	_tmp3_ = rygel_basic_management_add_test (self, _tmp2_);
	id = _tmp3_;
	_tmp4_ = _data1_->bm_test;
	rygel_basic_management_test_run (_tmp4_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp5_ = action;
	gupnp_service_action_set (_tmp5_, "TestID", G_TYPE_STRING, id, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
	_g_free0 (id);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gboolean rygel_basic_management_ensure_test_exists (RygelBasicManagement* self, GUPnPServiceAction* action, RygelBasicManagementTest** bm_test) {
	RygelBasicManagementTest* _vala_bm_test = NULL;
	gboolean result = FALSE;
	gchar* test_id = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gchar* action_name = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	RygelBasicManagementTest* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "TestID", G_TYPE_STRING, &test_id, NULL);
	_tmp1_ = self->priv->tests_map;
	_tmp2_ = test_id;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_g_object_unref0 (_vala_bm_test);
	_vala_bm_test = (RygelBasicManagementTest*) _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gupnp_service_action_get_name (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	action_name = _tmp6_;
	_tmp7_ = _vala_bm_test;
	if (_tmp7_ == NULL) {
		GUPnPServiceAction* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = action;
		_tmp9_ = _ ("No Such Test");
		gupnp_service_action_return_error (_tmp8_, (guint) 706, _tmp9_);
		result = FALSE;
		_g_free0 (action_name);
		_g_free0 (test_id);
		if (bm_test) {
			*bm_test = _vala_bm_test;
		} else {
			_g_object_unref0 (_vala_bm_test);
		}
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		RygelBasicManagementTest* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp11_ = _vala_bm_test;
		_tmp12_ = rygel_basic_management_test_get_results_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = action_name;
		if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_ = NULL;
			_tmp17_ = action_name;
			if (g_strcmp0 (_tmp17_, "GetPingResult") == 0) {
				_tmp16_ = TRUE;
			} else {
				const gchar* _tmp18_ = NULL;
				_tmp18_ = action_name;
				_tmp16_ = g_strcmp0 (_tmp18_, "GetNSLookupResult") == 0;
			}
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				const gchar* _tmp19_ = NULL;
				_tmp19_ = action_name;
				_tmp15_ = g_strcmp0 (_tmp19_, "GetTracerouteResult") == 0;
			}
			_tmp10_ = _tmp15_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GUPnPServiceAction* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			_tmp20_ = action;
			_tmp21_ = _ ("Wrong Test Type");
			gupnp_service_action_return_error (_tmp20_, (guint) 707, _tmp21_);
			result = FALSE;
			_g_free0 (action_name);
			_g_free0 (test_id);
			if (bm_test) {
				*bm_test = _vala_bm_test;
			} else {
				_g_object_unref0 (_vala_bm_test);
			}
			return result;
		} else {
			gboolean _tmp22_ = FALSE;
			RygelBasicManagementTest* _tmp23_ = NULL;
			RygelBasicManagementTestExecutionState _tmp24_ = 0;
			RygelBasicManagementTestExecutionState _tmp25_ = 0;
			_tmp23_ = _vala_bm_test;
			_tmp24_ = rygel_basic_management_test_get_execution_state (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_ != RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED) {
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				const gchar* _tmp28_ = NULL;
				_tmp28_ = action_name;
				if (g_strcmp0 (_tmp28_, "GetPingResult") == 0) {
					_tmp27_ = TRUE;
				} else {
					const gchar* _tmp29_ = NULL;
					_tmp29_ = action_name;
					_tmp27_ = g_strcmp0 (_tmp29_, "GetNSLookupResult") == 0;
				}
				if (_tmp27_) {
					_tmp26_ = TRUE;
				} else {
					const gchar* _tmp30_ = NULL;
					_tmp30_ = action_name;
					_tmp26_ = g_strcmp0 (_tmp30_, "GetTracerouteResult") == 0;
				}
				_tmp22_ = _tmp26_;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				GUPnPServiceAction* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				RygelBasicManagementTest* _tmp33_ = NULL;
				RygelBasicManagementTestExecutionState _tmp34_ = 0;
				RygelBasicManagementTestExecutionState _tmp35_ = 0;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				_tmp31_ = action;
				_tmp32_ = _ ("Invalid Test State '%s'");
				_tmp33_ = _vala_bm_test;
				_tmp34_ = rygel_basic_management_test_get_execution_state (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = rygel_basic_management_test_execution_state_to_string (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strdup_printf (_tmp32_, _tmp37_);
				_tmp39_ = _tmp38_;
				gupnp_service_action_return_error (_tmp31_, (guint) 708, _tmp39_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_g_free0 (action_name);
				_g_free0 (test_id);
				if (bm_test) {
					*bm_test = _vala_bm_test;
				} else {
					_g_object_unref0 (_vala_bm_test);
				}
				return result;
			} else {
				gboolean _tmp40_ = FALSE;
				const gchar* _tmp41_ = NULL;
				_tmp41_ = action_name;
				if (g_strcmp0 (_tmp41_, "CancelTest") == 0) {
					RygelBasicManagementTest* _tmp42_ = NULL;
					gboolean _tmp43_ = FALSE;
					_tmp42_ = _vala_bm_test;
					_tmp43_ = rygel_basic_management_test_is_active (_tmp42_);
					_tmp40_ = !_tmp43_;
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					GUPnPServiceAction* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					RygelBasicManagementTest* _tmp46_ = NULL;
					RygelBasicManagementTestExecutionState _tmp47_ = 0;
					RygelBasicManagementTestExecutionState _tmp48_ = 0;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					_tmp44_ = action;
					_tmp45_ = _ ("State '%s' Precludes Cancel");
					_tmp46_ = _vala_bm_test;
					_tmp47_ = rygel_basic_management_test_get_execution_state (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = rygel_basic_management_test_execution_state_to_string (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup_printf (_tmp45_, _tmp50_);
					_tmp52_ = _tmp51_;
					gupnp_service_action_return_error (_tmp44_, (guint) 709, _tmp52_);
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					result = FALSE;
					_g_free0 (action_name);
					_g_free0 (test_id);
					if (bm_test) {
						*bm_test = _vala_bm_test;
					} else {
						_g_object_unref0 (_vala_bm_test);
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (action_name);
	_g_free0 (test_id);
	if (bm_test) {
		*bm_test = _vala_bm_test;
	} else {
		_g_object_unref0 (_vala_bm_test);
	}
	return result;
}


static void rygel_basic_management_query_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = self->device_status;
	g_value_set_string (val, _tmp0_);
}


static void rygel_basic_management_query_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_basic_management_query_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (var != NULL);
	g_return_if_fail (val != NULL);
	g_value_init (val, G_TYPE_STRING);
	_tmp0_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp1_ = _tmp0_;
	g_value_set_string (val, _tmp1_);
	_g_free0 (_tmp1_);
}


static void rygel_basic_management_get_device_status_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = self->device_status;
	gupnp_service_action_set (_tmp4_, "DeviceStatus", G_TYPE_STRING, _tmp5_, NULL);
	_tmp6_ = action;
	gupnp_service_action_return (_tmp6_);
}


static void rygel_basic_management_ping_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* host = NULL;
	guint repeat_count = 0U;
	guint data_block_size = 0U;
	guint dscp = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestPing* ping = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint32 _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	RygelBasicManagementTestPing* _tmp14_ = NULL;
	RygelBasicManagementTestPing* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 5)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_get (_tmp4_, "Host", G_TYPE_STRING, &host, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "DSCP", G_TYPE_UINT, &dscp, NULL);
	_tmp5_ = host;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("Cannot run 'Ping' action: Host is empty");
		g_warning ("rygel-basic-management.vala:255: %s", _tmp6_);
		_tmp7_ = action;
		_tmp8_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
		_g_free0 (host);
		return;
	}
	_tmp9_ = host;
	_tmp10_ = repeat_count;
	_tmp11_ = interval_time_out;
	_tmp12_ = data_block_size;
	_tmp13_ = dscp;
	_tmp14_ = rygel_basic_management_test_ping_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_);
	ping = _tmp14_;
	_tmp15_ = ping;
	_tmp16_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp15_) : NULL, _tmp16_);
	_g_object_unref0 (ping);
	_g_free0 (host);
}


static void rygel_basic_management_ping_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	guint success_count = 0U;
	guint failure_count = 0U;
	guint32 avg_response_time = 0U;
	guint32 min_response_time = 0U;
	guint32 max_response_time = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	guint32 _tmp13_ = 0U;
	guint32 _tmp14_ = 0U;
	GUPnPServiceAction* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	guint32 _tmp20_ = 0U;
	guint32 _tmp21_ = 0U;
	guint32 _tmp22_ = 0U;
	GUPnPServiceAction* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp7_ = bm_test;
	rygel_basic_management_test_ping_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING) ? ((RygelBasicManagementTestPing*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	_g_free0 (status);
	status = _tmp8_;
	_g_free0 (additional_info);
	additional_info = _tmp9_;
	success_count = _tmp10_;
	failure_count = _tmp11_;
	avg_response_time = _tmp12_;
	min_response_time = _tmp13_;
	max_response_time = _tmp14_;
	_tmp15_ = action;
	_tmp16_ = status;
	_tmp17_ = additional_info;
	_tmp18_ = success_count;
	_tmp19_ = failure_count;
	_tmp20_ = avg_response_time;
	_tmp21_ = min_response_time;
	_tmp22_ = max_response_time;
	gupnp_service_action_set (_tmp15_, "Status", G_TYPE_STRING, _tmp16_, "AdditionalInfo", G_TYPE_STRING, _tmp17_, "SuccessCount", G_TYPE_UINT, _tmp18_, "FailureCount", G_TYPE_UINT, _tmp19_, "AverageResponseTime", G_TYPE_UINT, _tmp20_, "MinimumResponseTime", G_TYPE_UINT, _tmp21_, "MaximumResponseTime", G_TYPE_UINT, _tmp22_, NULL);
	_tmp23_ = action;
	gupnp_service_action_return (_tmp23_);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_nslookup_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* hostname = NULL;
	gchar* dns_server = NULL;
	guint repeat_count = 0U;
	guint32 interval_time_out = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestNSLookup* nslookup = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint32 _tmp12_ = 0U;
	RygelBasicManagementTestNSLookup* _tmp13_ = NULL;
	RygelBasicManagementTestNSLookup* _tmp14_ = NULL;
	GUPnPServiceAction* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 4)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_get (_tmp4_, "HostName", G_TYPE_STRING, &hostname, "DNSServer", G_TYPE_STRING, &dns_server, "NumberOfRepetitions", G_TYPE_UINT, &repeat_count, "Timeout", G_TYPE_UINT, &interval_time_out, NULL);
	_tmp5_ = hostname;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("Cannot run 'NSLookup' action: HostName is empty");
		g_warning ("rygel-basic-management.vala:348: %s", _tmp6_);
		_tmp7_ = action;
		_tmp8_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
		_g_free0 (dns_server);
		_g_free0 (hostname);
		return;
	}
	_tmp9_ = hostname;
	_tmp10_ = dns_server;
	_tmp11_ = repeat_count;
	_tmp12_ = interval_time_out;
	_tmp13_ = rygel_basic_management_test_ns_lookup_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
	nslookup = _tmp13_;
	_tmp14_ = nslookup;
	_tmp15_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp14_) : NULL, _tmp15_);
	_g_object_unref0 (nslookup);
	_g_free0 (dns_server);
	_g_free0 (hostname);
}


static void rygel_basic_management_nslookup_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* _result_ = NULL;
	guint success_count = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	const gchar* _tmp16_ = NULL;
	GUPnPServiceAction* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp7_ = bm_test;
	rygel_basic_management_test_ns_lookup_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP) ? ((RygelBasicManagementTestNSLookup*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	_g_free0 (status);
	status = _tmp8_;
	_g_free0 (additional_info);
	additional_info = _tmp9_;
	success_count = _tmp10_;
	_g_free0 (_result_);
	_result_ = _tmp11_;
	_tmp12_ = action;
	_tmp13_ = status;
	_tmp14_ = additional_info;
	_tmp15_ = success_count;
	_tmp16_ = _result_;
	gupnp_service_action_set (_tmp12_, "Status", G_TYPE_STRING, _tmp13_, "AdditionalInfo", G_TYPE_STRING, _tmp14_, "SuccessCount", G_TYPE_UINT, _tmp15_, "Result", G_TYPE_STRING, _tmp16_, NULL);
	_tmp17_ = action;
	gupnp_service_action_return (_tmp17_);
	_g_free0 (_result_);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_traceroute_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gchar* host = NULL;
	guint32 wait_time_out = 0U;
	guint data_block_size = 0U;
	guint max_hop_count = 0U;
	guint dscp = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelBasicManagementTestTraceroute* traceroute = NULL;
	const gchar* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	RygelBasicManagementTestTraceroute* _tmp14_ = NULL;
	RygelBasicManagementTestTraceroute* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 5)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	gupnp_service_action_get (_tmp4_, "Host", G_TYPE_STRING, &host, "Timeout", G_TYPE_UINT, &wait_time_out, "DataBlockSize", G_TYPE_UINT, &data_block_size, "MaxHopCount", G_TYPE_UINT, &max_hop_count, "DSCP", G_TYPE_UINT, &dscp, NULL);
	_tmp5_ = host;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		const gchar* _tmp6_ = NULL;
		GUPnPServiceAction* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("Cannot run 'Traceroute' action: Host is empty");
		g_warning ("rygel-basic-management.vala:430: %s", _tmp6_);
		_tmp7_ = action;
		_tmp8_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
		_g_free0 (host);
		return;
	}
	_tmp9_ = host;
	_tmp10_ = wait_time_out;
	_tmp11_ = data_block_size;
	_tmp12_ = max_hop_count;
	_tmp13_ = dscp;
	_tmp14_ = rygel_basic_management_test_traceroute_new (_tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_);
	traceroute = _tmp14_;
	_tmp15_ = traceroute;
	_tmp16_ = action;
	rygel_basic_management_add_test_and_return_action (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST) ? ((RygelBasicManagementTest*) _tmp15_) : NULL, _tmp16_);
	_g_object_unref0 (traceroute);
	_g_free0 (host);
}


static void rygel_basic_management_traceroute_result_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* status = NULL;
	gchar* additional_info = NULL;
	gchar* hop_hosts = NULL;
	guint32 response_time = 0U;
	RygelBasicManagementTest* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	guint32 _tmp15_ = 0U;
	const gchar* _tmp16_ = NULL;
	GUPnPServiceAction* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp7_ = bm_test;
	rygel_basic_management_test_traceroute_get_results (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_TRACEROUTE) ? ((RygelBasicManagementTestTraceroute*) _tmp7_) : NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	_g_free0 (status);
	status = _tmp8_;
	_g_free0 (additional_info);
	additional_info = _tmp9_;
	response_time = _tmp10_;
	_g_free0 (hop_hosts);
	hop_hosts = _tmp11_;
	_tmp12_ = action;
	_tmp13_ = status;
	_tmp14_ = additional_info;
	_tmp15_ = response_time;
	_tmp16_ = hop_hosts;
	gupnp_service_action_set (_tmp12_, "Status", G_TYPE_STRING, _tmp13_, "AdditionalInfo", G_TYPE_STRING, _tmp14_, "ResponseTime", G_TYPE_UINT, _tmp15_, "HopHosts", G_TYPE_STRING, _tmp16_, NULL);
	_tmp17_ = action;
	gupnp_service_action_return (_tmp17_);
	_g_free0 (hop_hosts);
	_g_free0 (additional_info);
	_g_free0 (status);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_get_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = rygel_basic_management_create_test_ids_list (self, FALSE);
	_tmp6_ = _tmp5_;
	gupnp_service_action_set (_tmp4_, "TestIDs", G_TYPE_STRING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = action;
	gupnp_service_action_return (_tmp7_);
}


static void rygel_basic_management_get_active_test_ids_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 0)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp5_ = rygel_basic_management_create_test_ids_list (self, TRUE);
	_tmp6_ = _tmp5_;
	gupnp_service_action_set (_tmp4_, "TestIDs", G_TYPE_STRING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = action;
	gupnp_service_action_return (_tmp7_);
}


static void rygel_basic_management_get_test_info_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GUPnPServiceAction* _tmp7_ = NULL;
	RygelBasicManagementTest* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelBasicManagementTest* _tmp11_ = NULL;
	RygelBasicManagementTestExecutionState _tmp12_ = 0;
	RygelBasicManagementTestExecutionState _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GUPnPServiceAction* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp7_ = action;
	_tmp8_ = bm_test;
	_tmp9_ = rygel_basic_management_test_get_method_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = bm_test;
	_tmp12_ = rygel_basic_management_test_get_execution_state (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = rygel_basic_management_test_execution_state_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	gupnp_service_action_set (_tmp7_, "Type", G_TYPE_STRING, _tmp10_, "State", G_TYPE_STRING, _tmp15_, NULL);
	_g_free0 (_tmp15_);
	_tmp16_ = action;
	gupnp_service_action_return (_tmp16_);
	_g_object_unref0 (bm_test);
}


static void rygel_basic_management_cancel_test_cb (RygelBasicManagement* self, GUPnPService* bm, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	RygelBasicManagementTest* bm_test = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelBasicManagementTest* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	RygelBasicManagementTest* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	GUPnPServiceAction* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bm != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
	if (_tmp1_ != ((guint) 1)) {
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = action;
		_tmp3_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
		return;
	}
	_tmp4_ = action;
	_tmp6_ = rygel_basic_management_ensure_test_exists (self, _tmp4_, &_tmp5_);
	_g_object_unref0 (bm_test);
	bm_test = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (bm_test);
		return;
	}
	_tmp7_ = bm_test;
	_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp7_);
	_tmp9_ = _tmp8_;
	g_cancellable_cancel (_tmp9_);
	_tmp10_ = action;
	gupnp_service_action_return (_tmp10_);
	_g_object_unref0 (bm_test);
}


RygelBasicManagement* rygel_basic_management_construct (GType object_type) {
	RygelBasicManagement * self = NULL;
	self = (RygelBasicManagement*) g_object_new (object_type, NULL);
	return self;
}


RygelBasicManagement* rygel_basic_management_new (void) {
	return rygel_basic_management_construct (RYGEL_TYPE_BASIC_MANAGEMENT);
}


guint rygel_basic_management_get_max_history_size (RygelBasicManagement* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_max_history_size;
	result = _tmp0_;
	return result;
}


void rygel_basic_management_set_max_history_size (RygelBasicManagement* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_history_size = _tmp0_;
	g_object_notify ((GObject *) self, "max-history-size");
}


static void rygel_basic_management_class_init (RygelBasicManagementClass * klass) {
	rygel_basic_management_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBasicManagementPrivate));
	((GObjectClass *) klass)->constructed = rygel_basic_management_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE, g_param_spec_uint ("max-history-size", "max-history-size", "max-history-size", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_basic_management_instance_init (RygelBasicManagement * self) {
	self->priv = RYGEL_BASIC_MANAGEMENT_GET_PRIVATE (self);
	self->priv->_max_history_size = (guint) 10;
}


static void rygel_basic_management_finalize (GObject* obj) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	_g_object_unref0 (self->priv->tests_map);
	_g_object_unref0 (self->priv->test_ids_by_type);
	_g_free0 (self->device_status);
	G_OBJECT_CLASS (rygel_basic_management_parent_class)->finalize (obj);
}


/**
 * Basic implementation of UPnP BasicManagement service version 2.
 */
GType rygel_basic_management_get_type (void) {
	static volatile gsize rygel_basic_management_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagement), 0, (GInstanceInitFunc) rygel_basic_management_instance_init, NULL };
		GType rygel_basic_management_type_id;
		rygel_basic_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelBasicManagement", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_type_id__volatile, rygel_basic_management_type_id);
	}
	return rygel_basic_management_type_id__volatile;
}


static void _vala_rygel_basic_management_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE:
		g_value_set_uint (value, rygel_basic_management_get_max_history_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_basic_management_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT, RygelBasicManagement);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_MAX_HISTORY_SIZE:
		rygel_basic_management_set_max_history_size (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



