/* chess-state.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from chess-state.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;


static gpointer chess_state_parent_class = NULL;

GType check_state_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
enum  {
	CHESS_STATE_DUMMY_PROPERTY,
	CHESS_STATE_OPPONENT
};
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType color_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
ChessMove* chess_move_copy (ChessMove* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
Color chess_piece_get_color (ChessPiece* self);
gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static void chess_state_finalize (GObject* obj);
static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState * self = NULL;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self = (ChessState*) g_object_new (object_type, NULL);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return self;
#line 261 "chess-state.c"
}


static ChessState* chess_state_new_empty (void) {
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return chess_state_construct_empty (TYPE_CHESS_STATE);
#line 268 "chess-state.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 286 "chess-state.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return self ? g_object_ref (self) : NULL;
#line 293 "chess-state.c"
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState * self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** ranks = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint ranks_length1 = 0;
	gint _ranks_size_ = 0;
	gchar** _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	const gchar* _tmp64_ = NULL;
	gchar** _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	const gchar* _tmp72_ = NULL;
	gchar** _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	const gchar* _tmp93_ = NULL;
	gchar** _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	const gchar* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	gchar** _tmp104_ = NULL;
	gint _tmp104__length1 = 0;
	const gchar* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	ChessPlayer* _tmp107_ = NULL;
	Color _tmp108_ = 0;
	ChessPlayer* _tmp110_ = NULL;
	CheckState _tmp111_ = 0;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self = (ChessState*) g_object_new (object_type, NULL);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = chess_player_new (COLOR_WHITE);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->players[COLOR_WHITE]);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->players[COLOR_WHITE] = _tmp0_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = self->players[COLOR_WHITE];
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp2_ = chess_player_new (COLOR_BLACK);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->players[COLOR_BLACK]);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->players[COLOR_BLACK] = _tmp2_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp3_ = self->players[COLOR_BLACK];
#line 358 "chess-state.c"
	{
		gint i = 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 363 "chess-state.c"
		{
			gboolean _tmp4_ = FALSE;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp4_ = TRUE;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 370 "chess-state.c"
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				ChessPiece* _tmp8_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp4_) {
#line 376 "chess-state.c"
					gint _tmp5_ = 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp5_ = i;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					i = _tmp5_ + 1;
#line 382 "chess-state.c"
				}
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp4_ = FALSE;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp6_ = i;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp6_ < 64)) {
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 392 "chess-state.c"
				}
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp7_ = i;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (self->board[_tmp7_]);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				self->board[_tmp7_] = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp8_ = self->board[_tmp7_];
#line 402 "chess-state.c"
			}
		}
	}
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp9_ = fen;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	fields = _tmp11_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	fields_length1 = _vala_array_length (_tmp10_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_fields_size_ = fields_length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp12_ = fields;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp12__length1 = fields_length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp13_ = _tmp12_[0];
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	ranks = _tmp15_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	ranks_length1 = _vala_array_length (_tmp14_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_ranks_size_ = ranks_length1;
#line 430 "chess-state.c"
	{
		gint rank = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		rank = 0;
#line 435 "chess-state.c"
		{
			gboolean _tmp16_ = FALSE;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp16_ = TRUE;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 442 "chess-state.c"
				gint _tmp18_ = 0;
				gchar* rank_string = NULL;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp16_) {
#line 452 "chess-state.c"
					gint _tmp17_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp17_ = rank;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					rank = _tmp17_ + 1;
#line 458 "chess-state.c"
				}
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp16_ = FALSE;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp18_ = rank;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp18_ < 8)) {
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 468 "chess-state.c"
				}
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp19_ = ranks;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp19__length1 = ranks_length1;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp20_ = rank;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp21_ = _tmp19_[7 - _tmp20_];
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				rank_string = _tmp22_;
#line 482 "chess-state.c"
				{
					gint file = 0;
					gint offset = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					offset = 0;
#line 490 "chess-state.c"
					{
						gboolean _tmp23_ = FALSE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp23_ = TRUE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 497 "chess-state.c"
							gboolean _tmp25_ = FALSE;
							gint _tmp26_ = 0;
							gchar c = '\0';
							const gchar* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gchar _tmp33_ = '\0';
							gboolean _tmp34_ = FALSE;
							gchar _tmp35_ = '\0';
							PieceType type = 0;
							Color _tmp39_ = 0;
							gchar _tmp40_ = '\0';
							gboolean _tmp41_ = FALSE;
							Color color = 0;
							gchar _tmp42_ = '\0';
							gchar _tmp43_ = '\0';
							PieceType _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gint index = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							ChessPiece* piece = NULL;
							Color _tmp49_ = 0;
							ChessPlayer* _tmp50_ = NULL;
							PieceType _tmp51_ = 0;
							ChessPiece* _tmp52_ = NULL;
							gint _tmp53_ = 0;
							ChessPiece* _tmp54_ = NULL;
							ChessPiece* _tmp55_ = NULL;
							ChessPiece* _tmp56_ = NULL;
							gint64 mask = 0LL;
							gint _tmp57_ = 0;
							gint64 _tmp58_ = 0LL;
							Color _tmp59_ = 0;
							gint64 _tmp60_ = 0LL;
							gint64 _tmp61_ = 0LL;
							gint _tmp62_ = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!_tmp23_) {
#line 537 "chess-state.c"
								gint _tmp24_ = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp24_ = offset;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								offset = _tmp24_ + 1;
#line 543 "chess-state.c"
							}
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp23_ = FALSE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp26_ = file;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp26_ < 8) {
#line 551 "chess-state.c"
								gint _tmp27_ = 0;
								const gchar* _tmp28_ = NULL;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp27_ = offset;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp28_ = rank_string;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp29_ = strlen (_tmp28_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp30_ = _tmp29_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp25_ = _tmp27_ < _tmp30_;
#line 566 "chess-state.c"
							} else {
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp25_ = FALSE;
#line 570 "chess-state.c"
							}
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!_tmp25_) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								break;
#line 576 "chess-state.c"
							}
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp31_ = rank_string;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp32_ = offset;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							c = _tmp33_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp35_ = c;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp35_ >= '1') {
#line 590 "chess-state.c"
								gchar _tmp36_ = '\0';
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp36_ = c;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp34_ = _tmp36_ <= '8';
#line 596 "chess-state.c"
							} else {
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp34_ = FALSE;
#line 600 "chess-state.c"
							}
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp34_) {
#line 604 "chess-state.c"
								gint _tmp37_ = 0;
								gchar _tmp38_ = '\0';
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp37_ = file;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp38_ = c;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								file = _tmp37_ + (_tmp38_ - '0');
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								continue;
#line 615 "chess-state.c"
							}
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp40_ = c;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp41_ = g_ascii_isupper (_tmp40_);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp41_) {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp39_ = COLOR_WHITE;
#line 625 "chess-state.c"
							} else {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp39_ = COLOR_BLACK;
#line 629 "chess-state.c"
							}
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							color = _tmp39_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp42_ = c;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp43_ = g_ascii_toupper (_tmp42_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp45_ = chess_state_decode_piece_type (self, (gunichar) _tmp43_, &_tmp44_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							type = _tmp44_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!_tmp45_) {
#line 643 "chess-state.c"
							}
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp46_ = rank;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp47_ = file;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp48_ = chess_state_get_index (self, _tmp46_, _tmp47_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							index = _tmp48_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp49_ = color;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp50_ = self->players[_tmp49_];
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp51_ = type;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp52_ = chess_piece_new (_tmp50_, _tmp51_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							piece = _tmp52_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp53_ = index;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp54_ = piece;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (self->board[_tmp53_]);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							self->board[_tmp53_] = _tmp55_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp56_ = self->board[_tmp53_];
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp57_ = index;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp58_ = BIT_BOARD_set_location_masks[_tmp57_];
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							mask = _tmp58_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp59_ = color;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp60_ = mask;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							self->priv->piece_masks[_tmp59_] |= _tmp60_;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp61_ = self->priv->piece_masks[_tmp59_];
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp62_ = file;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							file = _tmp62_ + 1;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (piece);
#line 695 "chess-state.c"
						}
					}
				}
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_free0 (rank_string);
#line 701 "chess-state.c"
			}
		}
	}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp63_ = fields;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp63__length1 = fields_length1;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp64_ = _tmp63_[1];
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp64_, "w") == 0) {
#line 713 "chess-state.c"
		ChessPlayer* _tmp65_ = NULL;
		ChessPlayer* _tmp66_ = NULL;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp65_ = self->players[COLOR_WHITE];
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp66_ = _g_object_ref0 (_tmp65_);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->current_player);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->current_player = _tmp66_;
#line 724 "chess-state.c"
	} else {
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		const gchar* _tmp68_ = NULL;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp67_ = fields;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp67__length1 = fields_length1;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp68_ = _tmp67_[1];
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (g_strcmp0 (_tmp68_, "b") == 0) {
#line 737 "chess-state.c"
			ChessPlayer* _tmp69_ = NULL;
			ChessPlayer* _tmp70_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp69_ = self->players[COLOR_BLACK];
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp70_ = _g_object_ref0 (_tmp69_);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->current_player);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			self->current_player = _tmp70_;
#line 748 "chess-state.c"
		}
	}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp71_ = fields;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp71__length1 = fields_length1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp72_ = _tmp71_[2];
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp72_, "-") != 0) {
#line 759 "chess-state.c"
		{
			gint i = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			i = 0;
#line 764 "chess-state.c"
			{
				gboolean _tmp73_ = FALSE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp73_ = TRUE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				while (TRUE) {
#line 771 "chess-state.c"
					gint _tmp75_ = 0;
					gchar** _tmp76_ = NULL;
					gint _tmp76__length1 = 0;
					const gchar* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					gchar c = '\0';
					gchar** _tmp80_ = NULL;
					gint _tmp80__length1 = 0;
					const gchar* _tmp81_ = NULL;
					gint _tmp82_ = 0;
					gchar _tmp83_ = '\0';
					gchar _tmp84_ = '\0';
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!_tmp73_) {
#line 787 "chess-state.c"
						gint _tmp74_ = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp74_ = i;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						i = _tmp74_ + 1;
#line 793 "chess-state.c"
					}
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp73_ = FALSE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp75_ = i;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp76_ = fields;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp76__length1 = fields_length1;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp77_ = _tmp76_[2];
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp78_ = strlen (_tmp77_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp79_ = _tmp78_;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!(_tmp75_ < _tmp79_)) {
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						break;
#line 813 "chess-state.c"
					}
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp80_ = fields;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp80__length1 = fields_length1;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp81_ = _tmp80_[2];
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp82_ = i;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					c = _tmp83_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp84_ = c;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp84_ == 'K') {
#line 831 "chess-state.c"
						gboolean _tmp85_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp85_ = self->can_castle_kingside[COLOR_WHITE];
#line 837 "chess-state.c"
					} else {
						gchar _tmp86_ = '\0';
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp86_ = c;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp86_ == 'Q') {
#line 844 "chess-state.c"
							gboolean _tmp87_ = FALSE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp87_ = self->can_castle_queenside[COLOR_WHITE];
#line 850 "chess-state.c"
						} else {
							gchar _tmp88_ = '\0';
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp88_ = c;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp88_ == 'k') {
#line 857 "chess-state.c"
								gboolean _tmp89_ = FALSE;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp89_ = self->can_castle_kingside[COLOR_BLACK];
#line 863 "chess-state.c"
							} else {
								gchar _tmp90_ = '\0';
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp90_ = c;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (_tmp90_ == 'q') {
#line 870 "chess-state.c"
									gboolean _tmp91_ = FALSE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp91_ = self->can_castle_queenside[COLOR_BLACK];
#line 876 "chess-state.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp92_ = fields;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp92__length1 = fields_length1;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp93_ = _tmp92_[3];
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp93_, "-") != 0) {
#line 893 "chess-state.c"
		gchar** _tmp94_ = NULL;
		gint _tmp94__length1 = 0;
		const gchar* _tmp95_ = NULL;
		gchar _tmp96_ = '\0';
		gchar** _tmp97_ = NULL;
		gint _tmp97__length1 = 0;
		const gchar* _tmp98_ = NULL;
		gchar _tmp99_ = '\0';
		gint _tmp100_ = 0;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp94_ = fields;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp94__length1 = fields_length1;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp95_ = _tmp94_[3];
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp96_ = string_get (_tmp95_, (glong) 1);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp97_ = fields;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp97__length1 = fields_length1;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp98_ = _tmp97_[3];
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp99_ = string_get (_tmp98_, (glong) 0);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp100_ = chess_state_get_index (self, (gint) (_tmp96_ - '1'), (gint) (_tmp99_ - 'a'));
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp100_;
#line 923 "chess-state.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp101_ = fields;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp101__length1 = fields_length1;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp102_ = _tmp101_[4];
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp103_ = atoi (_tmp102_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->halfmove_clock = _tmp103_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp104_ = fields;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp104__length1 = fields_length1;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp105_ = _tmp104_[5];
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp106_ = atoi (_tmp105_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->number = (_tmp106_ - 1) * 2;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp107_ = self->current_player;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp108_ = _tmp107_->color;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp108_ == COLOR_BLACK) {
#line 951 "chess-state.c"
		gint _tmp109_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp109_ = self->number;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->number = _tmp109_ + 1;
#line 957 "chess-state.c"
	}
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp110_ = self->current_player;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp111_ = chess_state_get_check_state (self, _tmp110_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->check_state = _tmp111_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return self;
#line 971 "chess-state.c"
}


ChessState* chess_state_new (const gchar* fen) {
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return chess_state_construct (TYPE_CHESS_STATE, fen);
#line 978 "chess-state.c"
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* state = NULL;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	ChessPlayer* _tmp4_ = NULL;
	ChessPlayer* _tmp5_ = NULL;
	ChessPlayer* _tmp6_ = NULL;
	ChessState* _tmp7_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessState* _tmp11_ = NULL;
	ChessPlayer* _tmp12_ = NULL;
	ChessPlayer* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ChessState* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	ChessState* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	ChessState* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	ChessState* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	ChessState* _tmp28_ = NULL;
	CheckState _tmp29_ = 0;
	ChessMove* _tmp30_ = NULL;
	ChessState* _tmp43_ = NULL;
	gint64 _tmp44_ = 0LL;
	gint64 _tmp45_ = 0LL;
	ChessState* _tmp46_ = NULL;
	gint64 _tmp47_ = 0LL;
	gint64 _tmp48_ = 0LL;
	ChessState* _tmp49_ = NULL;
	gint _tmp50_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = chess_state_new_empty ();
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	state = _tmp0_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = state;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp2_ = self->number;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_->number = _tmp2_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp3_ = state;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp4_ = self->players[COLOR_WHITE];
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_ = state;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp8_ = self->players[COLOR_BLACK];
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp11_ = state;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp12_ = self->current_player;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp11_->current_player);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp11_->current_player = _tmp13_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp14_ = state;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp17_ = state;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp20_ = state;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp23_ = state;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp26_ = state;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp27_ = self->en_passant_index;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp26_->en_passant_index = _tmp27_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp28_ = state;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp29_ = self->check_state;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp28_->check_state = _tmp29_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp30_ = self->last_move;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp30_ != NULL) {
#line 1118 "chess-state.c"
		ChessState* _tmp31_ = NULL;
		ChessMove* _tmp32_ = NULL;
		ChessMove* _tmp33_ = NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp31_ = state;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp32_ = self->last_move;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp33_ = chess_move_copy (_tmp32_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp31_->last_move);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp31_->last_move = _tmp33_;
#line 1132 "chess-state.c"
	}
	{
		gint i = 0;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 1138 "chess-state.c"
		{
			gboolean _tmp34_ = FALSE;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp34_ = TRUE;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1145 "chess-state.c"
				gint _tmp36_ = 0;
				ChessState* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				ChessPiece* _tmp40_ = NULL;
				ChessPiece* _tmp41_ = NULL;
				ChessPiece* _tmp42_ = NULL;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp34_) {
#line 1155 "chess-state.c"
					gint _tmp35_ = 0;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp35_ = i;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					i = _tmp35_ + 1;
#line 1161 "chess-state.c"
				}
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp34_ = FALSE;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp36_ = i;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp36_ < 64)) {
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 1171 "chess-state.c"
				}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp37_ = state;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp38_ = i;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp39_ = i;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp40_ = self->board[_tmp39_];
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp41_ = _g_object_ref0 (_tmp40_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (_tmp37_->board[_tmp38_]);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp37_->board[_tmp38_] = _tmp41_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp42_ = _tmp37_->board[_tmp38_];
#line 1189 "chess-state.c"
			}
		}
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp43_ = state;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp44_ = self->priv->piece_masks[COLOR_WHITE];
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp43_->priv->piece_masks[COLOR_WHITE] = _tmp44_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp45_ = _tmp43_->priv->piece_masks[COLOR_WHITE];
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp46_ = state;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp47_ = self->priv->piece_masks[COLOR_BLACK];
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp46_->priv->piece_masks[COLOR_BLACK] = _tmp47_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp48_ = _tmp46_->priv->piece_masks[COLOR_BLACK];
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp49_ = state;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp50_ = self->halfmove_clock;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp49_->halfmove_clock = _tmp50_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = state;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1219 "chess-state.c"
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp7_ = 0LL;
	ChessState* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (state != NULL, FALSE);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_ = self->priv->piece_masks[COLOR_WHITE];
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp8_ = state;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp9_ = _tmp8_->priv->piece_masks[COLOR_WHITE];
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp7_ != _tmp9_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp6_ = TRUE;
#line 1249 "chess-state.c"
	} else {
		gint64 _tmp10_ = 0LL;
		ChessState* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp10_ = self->priv->piece_masks[COLOR_BLACK];
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp11_ = state;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp12_ = _tmp11_->priv->piece_masks[COLOR_BLACK];
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp6_ = _tmp10_ != _tmp12_;
#line 1262 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp6_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp5_ = TRUE;
#line 1268 "chess-state.c"
	} else {
		ChessPlayer* _tmp13_ = NULL;
		Color _tmp14_ = 0;
		ChessState* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		Color _tmp17_ = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp13_ = self->current_player;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp14_ = _tmp13_->color;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp15_ = state;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp16_ = _tmp15_->current_player;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp17_ = _tmp16_->color;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp5_ = _tmp14_ != _tmp17_;
#line 1287 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp5_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp4_ = TRUE;
#line 1293 "chess-state.c"
	} else {
		gboolean _tmp18_ = FALSE;
		ChessState* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp18_ = self->can_castle_kingside[COLOR_WHITE];
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp19_ = state;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp20_ = _tmp19_->can_castle_kingside[COLOR_WHITE];
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp4_ = _tmp18_ != _tmp20_;
#line 1306 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp4_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = TRUE;
#line 1312 "chess-state.c"
	} else {
		gboolean _tmp21_ = FALSE;
		ChessState* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp21_ = self->can_castle_queenside[COLOR_WHITE];
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp22_ = state;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp23_ = _tmp22_->can_castle_queenside[COLOR_WHITE];
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = _tmp21_ != _tmp23_;
#line 1325 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp3_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp2_ = TRUE;
#line 1331 "chess-state.c"
	} else {
		gboolean _tmp24_ = FALSE;
		ChessState* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp24_ = self->can_castle_kingside[COLOR_BLACK];
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp25_ = state;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp26_ = _tmp25_->can_castle_kingside[COLOR_BLACK];
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp2_ = _tmp24_ != _tmp26_;
#line 1344 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp2_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp1_ = TRUE;
#line 1350 "chess-state.c"
	} else {
		gboolean _tmp27_ = FALSE;
		ChessState* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp27_ = self->can_castle_queenside[COLOR_BLACK];
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp28_ = state;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp29_ = _tmp28_->can_castle_queenside[COLOR_BLACK];
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp1_ = _tmp27_ != _tmp29_;
#line 1363 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = TRUE;
#line 1369 "chess-state.c"
	} else {
		gint _tmp30_ = 0;
		ChessState* _tmp31_ = NULL;
		gint _tmp32_ = 0;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp30_ = self->en_passant_index;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp31_ = state;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp32_ = _tmp31_->en_passant_index;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp30_ != _tmp32_;
#line 1382 "chess-state.c"
	}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp0_) {
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 1390 "chess-state.c"
	}
	{
		gint i = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 1396 "chess-state.c"
		{
			gboolean _tmp33_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp33_ = TRUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1403 "chess-state.c"
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				ChessPiece* _tmp38_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp33_) {
#line 1410 "chess-state.c"
					gint _tmp34_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp34_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					i = _tmp34_ + 1;
#line 1416 "chess-state.c"
				}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp33_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp35_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp35_ < 64)) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 1426 "chess-state.c"
				}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp37_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp38_ = self->board[_tmp37_];
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp38_ != NULL) {
#line 1434 "chess-state.c"
					gint _tmp39_ = 0;
					ChessPiece* _tmp40_ = NULL;
					PieceType _tmp41_ = 0;
					ChessState* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					ChessPiece* _tmp44_ = NULL;
					PieceType _tmp45_ = 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp39_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp40_ = self->board[_tmp39_];
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp41_ = _tmp40_->type;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp42_ = state;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp43_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp44_ = _tmp42_->board[_tmp43_];
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp45_ = _tmp44_->type;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp36_ = _tmp41_ != _tmp45_;
#line 1458 "chess-state.c"
				} else {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp36_ = FALSE;
#line 1462 "chess-state.c"
				}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp36_) {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 1470 "chess-state.c"
				}
			}
		}
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1479 "chess-state.c"
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* value = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	Color _tmp28_ = 0;
	GString* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	GString* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GString* _tmp53_ = NULL;
	GString* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	GString* _tmp56_ = NULL;
	ChessPlayer* _tmp57_ = NULL;
	Color _tmp58_ = 0;
	GString* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = g_string_new ("");
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	value = _tmp0_;
#line 1516 "chess-state.c"
	{
		gint rank = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		rank = 7;
#line 1521 "chess-state.c"
		{
			gboolean _tmp1_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp1_ = TRUE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1528 "chess-state.c"
				gint _tmp3_ = 0;
				gint skip_count = 0;
				gint _tmp21_ = 0;
				gint _tmp24_ = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp1_) {
#line 1535 "chess-state.c"
					gint _tmp2_ = 0;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp2_ = rank;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					rank = _tmp2_ - 1;
#line 1541 "chess-state.c"
				}
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp1_ = FALSE;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp3_ = rank;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp3_ >= 0)) {
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 1551 "chess-state.c"
				}
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				skip_count = 0;
#line 1555 "chess-state.c"
				{
					gint file = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 1560 "chess-state.c"
					{
						gboolean _tmp4_ = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp4_ = TRUE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 1567 "chess-state.c"
							gint _tmp6_ = 0;
							ChessPiece* p = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							ChessPiece* _tmp10_ = NULL;
							ChessPiece* _tmp11_ = NULL;
							ChessPiece* _tmp12_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!_tmp4_) {
#line 1578 "chess-state.c"
								gint _tmp5_ = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp5_ = file;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								file = _tmp5_ + 1;
#line 1584 "chess-state.c"
							}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp4_ = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp6_ = file;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!(_tmp6_ < 8)) {
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								break;
#line 1594 "chess-state.c"
							}
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp7_ = rank;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp8_ = file;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp9_ = chess_state_get_index (self, _tmp7_, _tmp8_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp10_ = self->board[_tmp9_];
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp11_ = _g_object_ref0 (_tmp10_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							p = _tmp11_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp12_ = p;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp12_ == NULL) {
#line 1612 "chess-state.c"
								gint _tmp13_ = 0;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp13_ = skip_count;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								skip_count = _tmp13_ + 1;
#line 1618 "chess-state.c"
							} else {
								gint _tmp14_ = 0;
								GString* _tmp17_ = NULL;
								ChessPiece* _tmp18_ = NULL;
								gunichar _tmp19_ = 0U;
								gunichar _tmp20_ = 0U;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp14_ = skip_count;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (_tmp14_ > 0) {
#line 1629 "chess-state.c"
									GString* _tmp15_ = NULL;
									gint _tmp16_ = 0;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp15_ = value;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp16_ = skip_count;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									g_string_append_printf (_tmp15_, "%d", _tmp16_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									skip_count = 0;
#line 1640 "chess-state.c"
								}
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp17_ = value;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp18_ = p;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp19_ = chess_piece_get_symbol (_tmp18_);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp20_ = _tmp19_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								g_string_append_printf (_tmp17_, "%c", (gint) _tmp20_);
#line 1652 "chess-state.c"
							}
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (p);
#line 1656 "chess-state.c"
						}
					}
				}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp21_ = skip_count;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp21_ > 0) {
#line 1664 "chess-state.c"
					GString* _tmp22_ = NULL;
					gint _tmp23_ = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp22_ = value;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp23_ = skip_count;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					g_string_append_printf (_tmp22_, "%d", _tmp23_);
#line 1673 "chess-state.c"
				}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp24_ = rank;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp24_ != 0) {
#line 1679 "chess-state.c"
					GString* _tmp25_ = NULL;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp25_ = value;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					g_string_append_c (_tmp25_, '/');
#line 1685 "chess-state.c"
				}
			}
		}
	}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp26_ = value;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp26_, ' ');
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp27_ = self->current_player;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp28_ = _tmp27_->color;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp28_ == COLOR_WHITE) {
#line 1700 "chess-state.c"
		GString* _tmp29_ = NULL;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp29_ = value;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp29_, 'w');
#line 1706 "chess-state.c"
	} else {
		GString* _tmp30_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp30_ = value;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp30_, 'b');
#line 1713 "chess-state.c"
	}
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp31_ = value;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp31_, ' ');
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp32_ = self->can_castle_kingside[COLOR_WHITE];
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp32_) {
#line 1723 "chess-state.c"
		GString* _tmp33_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp33_ = value;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp33_, 'K');
#line 1729 "chess-state.c"
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp34_ = self->can_castle_queenside[COLOR_WHITE];
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp34_) {
#line 1735 "chess-state.c"
		GString* _tmp35_ = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp35_ = value;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp35_, 'Q');
#line 1741 "chess-state.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp36_ = self->can_castle_kingside[COLOR_BLACK];
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp36_) {
#line 1747 "chess-state.c"
		GString* _tmp37_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp37_ = value;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp37_, 'k');
#line 1753 "chess-state.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp38_ = self->can_castle_queenside[COLOR_BLACK];
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp38_) {
#line 1759 "chess-state.c"
		GString* _tmp39_ = NULL;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp39_ = value;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp39_, 'q');
#line 1765 "chess-state.c"
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp40_ = self->can_castle_kingside[COLOR_WHITE];
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp41_ = self->can_castle_queenside[COLOR_WHITE];
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp42_ = self->can_castle_kingside[COLOR_BLACK];
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp43_ = self->can_castle_queenside[COLOR_BLACK];
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!(((_tmp40_ | _tmp41_) | _tmp42_) | _tmp43_)) {
#line 1777 "chess-state.c"
		GString* _tmp44_ = NULL;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp44_ = value;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp44_, '-');
#line 1783 "chess-state.c"
	}
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp45_ = value;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp45_, ' ');
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp46_ = self->en_passant_index;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp46_ >= 0) {
#line 1793 "chess-state.c"
		GString* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp47_ = value;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp48_ = self->en_passant_index;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp49_ = chess_state_get_file (self, _tmp48_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp50_ = self->en_passant_index;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp51_ = chess_state_get_rank (self, _tmp50_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp47_, "%c%d", 'a' + _tmp49_, _tmp51_ + 1);
#line 1811 "chess-state.c"
	} else {
		GString* _tmp52_ = NULL;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp52_ = value;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp52_, '-');
#line 1818 "chess-state.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp53_ = value;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp53_, ' ');
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp54_ = value;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp55_ = self->halfmove_clock;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_printf (_tmp54_, "%d", _tmp55_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp56_ = value;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp56_, ' ');
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp57_ = self->current_player;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp58_ = _tmp57_->color;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp58_ == COLOR_WHITE) {
#line 1840 "chess-state.c"
		GString* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp59_ = value;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp60_ = self->number;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp59_, "%d", _tmp60_ / 2);
#line 1849 "chess-state.c"
	} else {
		GString* _tmp61_ = NULL;
		gint _tmp62_ = 0;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp61_ = value;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp62_ = self->number;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp61_, "%d", (_tmp62_ / 2) + 1);
#line 1859 "chess-state.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp63_ = value;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp64_ = _tmp63_->str;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp65_ = g_strdup (_tmp64_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = _tmp65_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_string_free0 (value);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1873 "chess-state.c"
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = rank;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = file;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = (_tmp0_ * 8) + _tmp1_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1891 "chess-state.c"
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = index;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = _tmp0_ / 8;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1906 "chess-state.c"
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = index;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = _tmp0_ % 8;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 1921 "chess-state.c"
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ChessPlayer* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	PieceType _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = self->current_player;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = move;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	r0 = _tmp2_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	f0 = _tmp3_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	r1 = _tmp4_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	f1 = _tmp5_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	promotion_type = _tmp6_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!_tmp7_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 1974 "chess-state.c"
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp8_ = self->current_player;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp9_ = r0;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp10_ = f0;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp11_ = r1;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp12_ = f1;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp13_ = promotion_type;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp14_ = apply;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!_tmp15_) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 1998 "chess-state.c"
	}
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 2004 "chess-state.c"
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint start = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint end = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Color color = 0;
	ChessPlayer* _tmp6_ = NULL;
	Color _tmp7_ = 0;
	Color _tmp8_ = 0;
	Color _tmp9_ = 0;
	Color opponent_color = 0;
	ChessPiece* piece = NULL;
	gint _tmp10_ = 0;
	ChessPiece* _tmp11_ = NULL;
	ChessPiece* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	ChessPiece* _tmp14_ = NULL;
	gint64 end_mask = 0LL;
	gint _tmp18_ = 0;
	gint64 _tmp19_ = 0LL;
	gint64 move_mask = 0LL;
	Color _tmp20_ = 0;
	ChessPiece* _tmp21_ = NULL;
	PieceType _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint64 _tmp24_ = 0LL;
	gint64 _tmp25_ = 0LL;
	gint64 _tmp26_ = 0LL;
	gint64 over_mask = 0LL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint64 _tmp29_ = 0LL;
	gint64 _tmp30_ = 0LL;
	gint64 _tmp31_ = 0LL;
	gint64 _tmp32_ = 0LL;
	ChessPiece* victim = NULL;
	gint _tmp33_ = 0;
	ChessPiece* _tmp34_ = NULL;
	ChessPiece* _tmp35_ = NULL;
	gint victim_index = 0;
	gint _tmp36_ = 0;
	gboolean _tmp37_ = FALSE;
	ChessPiece* _tmp38_ = NULL;
	gint rook_start = 0;
	gint rook_end = 0;
	gboolean is_promotion = FALSE;
	gboolean ambiguous_rank = FALSE;
	gboolean ambiguous_file = FALSE;
	ChessPiece* _tmp42_ = NULL;
	PieceType _tmp43_ = 0;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp114_ = FALSE;
	gint64 old_white_mask = 0LL;
	gint64 _tmp147_ = 0LL;
	gint64 old_black_mask = 0LL;
	gint64 _tmp148_ = 0LL;
	gboolean old_white_can_castle_kingside = FALSE;
	gboolean _tmp149_ = FALSE;
	gboolean old_white_can_castle_queenside = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean old_black_can_castle_kingside = FALSE;
	gboolean _tmp151_ = FALSE;
	gboolean old_black_can_castle_queenside = FALSE;
	gboolean _tmp152_ = FALSE;
	gint old_en_passant_index = 0;
	gint _tmp153_ = 0;
	gint old_halfmove_clock = 0;
	gint _tmp154_ = 0;
	gint _tmp155_ = 0;
	ChessPiece* _tmp156_ = NULL;
	gint _tmp157_ = 0;
	gint64 _tmp158_ = 0LL;
	gint64 _tmp159_ = 0LL;
	gint _tmp160_ = 0;
	gint64 _tmp161_ = 0LL;
	gint64 _tmp162_ = 0LL;
	ChessPiece* _tmp163_ = NULL;
	gboolean _tmp172_ = FALSE;
	Color _tmp182_ = 0;
	gint64 _tmp183_ = 0LL;
	gint64 _tmp184_ = 0LL;
	Color _tmp185_ = 0;
	gint _tmp186_ = 0;
	gint64 _tmp187_ = 0LL;
	gint64 _tmp188_ = 0LL;
	gint _tmp189_ = 0;
	ChessPiece* _tmp207_ = NULL;
	PieceType _tmp208_ = 0;
	gboolean _tmp239_ = FALSE;
	ChessPiece* _tmp240_ = NULL;
	PieceType _tmp241_ = 0;
	gboolean _tmp247_ = FALSE;
	ChessPiece* _tmp248_ = NULL;
	PieceType _tmp249_ = 0;
	gboolean _result_ = FALSE;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_ = FALSE;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_ = FALSE;
	ChessPlayer* _tmp294_ = NULL;
	Color _tmp295_ = 0;
	ChessPlayer* _tmp298_ = NULL;
	ChessPlayer* _tmp299_ = NULL;
	CheckState _tmp300_ = 0;
	ChessMove* _tmp301_ = NULL;
	ChessMove* _tmp302_ = NULL;
	gint _tmp303_ = 0;
	ChessMove* _tmp304_ = NULL;
	ChessPiece* _tmp305_ = NULL;
	ChessPiece* _tmp306_ = NULL;
	gboolean _tmp307_ = FALSE;
	ChessMove* _tmp312_ = NULL;
	ChessPiece* _tmp313_ = NULL;
	ChessPiece* _tmp314_ = NULL;
	gint _tmp315_ = 0;
	ChessMove* _tmp320_ = NULL;
	gint _tmp321_ = 0;
	ChessMove* _tmp322_ = NULL;
	gint _tmp323_ = 0;
	ChessMove* _tmp324_ = NULL;
	gint _tmp325_ = 0;
	ChessMove* _tmp326_ = NULL;
	gint _tmp327_ = 0;
	ChessMove* _tmp328_ = NULL;
	gboolean _tmp329_ = FALSE;
	ChessMove* _tmp330_ = NULL;
	gboolean _tmp331_ = FALSE;
	ChessMove* _tmp332_ = NULL;
	CheckState _tmp333_ = 0;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = r0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = f0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	start = _tmp2_;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp3_ = r1;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp4_ = f1;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	end = _tmp5_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp6_ = player;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_ = _tmp6_->color;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	color = _tmp7_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp9_ = color;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp9_ == COLOR_WHITE) {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp8_ = COLOR_BLACK;
#line 2175 "chess-state.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp8_ = COLOR_WHITE;
#line 2179 "chess-state.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	opponent_color = _tmp8_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp10_ = start;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp11_ = self->board[_tmp10_];
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	piece = _tmp12_;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp14_ = piece;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp14_ == NULL) {
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp13_ = TRUE;
#line 2197 "chess-state.c"
	} else {
		ChessPiece* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp15_ = piece;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp16_ = _tmp15_->player;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp17_ = player;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp13_ = _tmp16_ != _tmp17_;
#line 2210 "chess-state.c"
	}
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp13_) {
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 2220 "chess-state.c"
	}
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp18_ = end;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp19_ = BIT_BOARD_set_location_masks[_tmp18_];
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	end_mask = _tmp19_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp20_ = color;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp21_ = piece;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp22_ = _tmp21_->type;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp23_ = start;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp24_ = BIT_BOARD_move_masks[(((_tmp20_ * 64) * 6) + (_tmp22_ * 64)) + _tmp23_];
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	move_mask = _tmp24_;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp25_ = end_mask;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp26_ = move_mask;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if ((_tmp25_ & _tmp26_) == ((gint64) 0)) {
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 2252 "chess-state.c"
	}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp27_ = start;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp28_ = end;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp29_ = BIT_BOARD_over_masks[(_tmp27_ * 64) + _tmp28_];
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	over_mask = _tmp29_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp30_ = over_mask;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp31_ = self->priv->piece_masks[COLOR_WHITE];
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp32_ = self->priv->piece_masks[COLOR_BLACK];
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if ((_tmp30_ & (_tmp31_ | _tmp32_)) != ((gint64) 0)) {
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 2276 "chess-state.c"
	}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp33_ = end;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp34_ = self->board[_tmp33_];
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	victim = _tmp35_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp36_ = end;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	victim_index = _tmp36_;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp38_ = victim;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp38_ != NULL) {
#line 2294 "chess-state.c"
		ChessPiece* _tmp39_ = NULL;
		ChessPlayer* _tmp40_ = NULL;
		ChessPlayer* _tmp41_ = NULL;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp39_ = victim;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp40_ = _tmp39_->player;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp41_ = player;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp37_ = _tmp40_ == _tmp41_;
#line 2306 "chess-state.c"
	} else {
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp37_ = FALSE;
#line 2310 "chess-state.c"
	}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp37_) {
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 2322 "chess-state.c"
	}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	rook_start = -1;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	rook_end = -1;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	is_promotion = FALSE;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	ambiguous_rank = FALSE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	ambiguous_file = FALSE;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp42_ = piece;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp43_ = _tmp42_->type;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	switch (_tmp43_) {
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case PIECE_TYPE_PAWN:
#line 2342 "chess-state.c"
		{
			gboolean _tmp44_ = FALSE;
			ChessPiece* _tmp45_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gboolean _tmp59_ = FALSE;
			gint _tmp60_ = 0;
			ChessPiece* _tmp62_ = NULL;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp45_ = victim;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp45_ == NULL) {
#line 2355 "chess-state.c"
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp46_ = end;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp47_ = self->en_passant_index;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp44_ = _tmp46_ == _tmp47_;
#line 2364 "chess-state.c"
			} else {
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp44_ = FALSE;
#line 2368 "chess-state.c"
			}
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp44_) {
#line 2372 "chess-state.c"
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				ChessPiece* _tmp53_ = NULL;
				ChessPiece* _tmp54_ = NULL;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp49_ = r1;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp49_ == 2) {
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp48_ = 3;
#line 2386 "chess-state.c"
				} else {
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp48_ = 4;
#line 2390 "chess-state.c"
				}
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp50_ = f1;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp51_ = chess_state_get_index (self, _tmp48_, _tmp50_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				victim_index = _tmp51_;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp52_ = victim_index;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp53_ = self->board[_tmp52_];
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp54_ = _g_object_ref0 (_tmp53_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (victim);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				victim = _tmp54_;
#line 2408 "chess-state.c"
			}
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp55_ = f0;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp56_ = f1;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp55_ != _tmp56_) {
#line 2416 "chess-state.c"
				ChessPiece* _tmp57_ = NULL;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp57_ = victim;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp57_ == NULL) {
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2430 "chess-state.c"
				}
			} else {
				ChessPiece* _tmp58_ = NULL;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp58_ = victim;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp58_ != NULL) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2446 "chess-state.c"
				}
			}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp60_ = r1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp60_ == 0) {
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp59_ = TRUE;
#line 2455 "chess-state.c"
			} else {
				gint _tmp61_ = 0;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp61_ = r1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp59_ = _tmp61_ == 7;
#line 2462 "chess-state.c"
			}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			is_promotion = _tmp59_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp62_ = victim;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp62_ != NULL) {
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				ambiguous_file = TRUE;
#line 2472 "chess-state.c"
			}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			break;
#line 2476 "chess-state.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case PIECE_TYPE_KING:
#line 2480 "chess-state.c"
		{
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp63_ = f0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp64_ = f1;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp65_ = abs (_tmp63_ - _tmp64_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp65_ > 1) {
#line 2493 "chess-state.c"
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				ChessPiece* rook = NULL;
				gint _tmp84_ = 0;
				ChessPiece* _tmp85_ = NULL;
				ChessPiece* _tmp86_ = NULL;
				gboolean _tmp87_ = FALSE;
				gboolean _tmp88_ = FALSE;
				ChessPiece* _tmp89_ = NULL;
				gint64 rook_over_mask = 0LL;
				gint _tmp96_ = 0;
				gint _tmp97_ = 0;
				gint64 _tmp98_ = 0LL;
				gint64 _tmp99_ = 0LL;
				gint64 _tmp100_ = 0LL;
				gint64 _tmp101_ = 0LL;
				CheckState _tmp102_ = 0;
				ChessPlayer* _tmp103_ = NULL;
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
				gint _tmp106_ = 0;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
				gint _tmp109_ = 0;
				gboolean _tmp110_ = FALSE;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp67_ = f1;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp68_ = f0;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp67_ > _tmp68_) {
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp66_ = 7;
#line 2537 "chess-state.c"
				} else {
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp66_ = 0;
#line 2541 "chess-state.c"
				}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp69_ = r0;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp70_ = chess_state_get_index (self, _tmp69_, _tmp66_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				rook_start = _tmp70_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp72_ = f1;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp73_ = f0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp72_ > _tmp73_) {
#line 2555 "chess-state.c"
					gint _tmp74_ = 0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp74_ = f1;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp71_ = _tmp74_ - 1;
#line 2561 "chess-state.c"
				} else {
					gint _tmp75_ = 0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp75_ = f1;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp71_ = _tmp75_ + 1;
#line 2568 "chess-state.c"
				}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp76_ = r0;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp77_ = chess_state_get_index (self, _tmp76_, _tmp71_);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				rook_end = _tmp77_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp78_ = f1;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp79_ = f0;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp78_ > _tmp79_) {
#line 2582 "chess-state.c"
					Color _tmp80_ = 0;
					gboolean _tmp81_ = FALSE;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp80_ = color;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp81_ = self->can_castle_kingside[_tmp80_];
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!_tmp81_) {
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						result = FALSE;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (victim);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (piece);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						return result;
#line 2599 "chess-state.c"
					}
				} else {
					Color _tmp82_ = 0;
					gboolean _tmp83_ = FALSE;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp82_ = color;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp83_ = self->can_castle_queenside[_tmp82_];
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!_tmp83_) {
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						result = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (victim);
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (piece);
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						return result;
#line 2618 "chess-state.c"
					}
				}
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp84_ = rook_start;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp85_ = self->board[_tmp84_];
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp86_ = _g_object_ref0 (_tmp85_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				rook = _tmp86_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp89_ = rook;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp89_ == NULL) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp88_ = TRUE;
#line 2635 "chess-state.c"
				} else {
					ChessPiece* _tmp90_ = NULL;
					PieceType _tmp91_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp90_ = rook;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp91_ = _tmp90_->type;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp88_ = _tmp91_ != PIECE_TYPE_ROOK;
#line 2645 "chess-state.c"
				}
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp88_) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp87_ = TRUE;
#line 2651 "chess-state.c"
				} else {
					ChessPiece* _tmp92_ = NULL;
					Color _tmp93_ = 0;
					Color _tmp94_ = 0;
					Color _tmp95_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp92_ = rook;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp93_ = chess_piece_get_color (_tmp92_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp94_ = _tmp93_;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp95_ = color;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp87_ = _tmp94_ != _tmp95_;
#line 2667 "chess-state.c"
				}
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp87_) {
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2681 "chess-state.c"
				}
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp96_ = rook_start;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp97_ = rook_end;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp98_ = BIT_BOARD_over_masks[(_tmp96_ * 64) + _tmp97_];
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				rook_over_mask = _tmp98_;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp99_ = rook_over_mask;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp100_ = self->priv->piece_masks[COLOR_WHITE];
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp101_ = self->priv->piece_masks[COLOR_BLACK];
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if ((_tmp99_ & (_tmp100_ | _tmp101_)) != ((gint64) 0)) {
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2709 "chess-state.c"
				}
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp102_ = self->check_state;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp102_ == CHECK_STATE_CHECK) {
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2725 "chess-state.c"
				}
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp103_ = player;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp104_ = r0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp105_ = f0;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp106_ = rook_end;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp107_ = chess_state_get_rank (self, _tmp106_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp108_ = rook_end;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp109_ = chess_state_get_file (self, _tmp108_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp110_ = chess_state_move_with_coords (self, _tmp103_, _tmp104_, _tmp105_, _tmp107_, _tmp109_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp110_) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 2755 "chess-state.c"
				}
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (rook);
#line 2759 "chess-state.c"
			}
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			break;
#line 2763 "chess-state.c"
		}
		default:
		{
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			break;
#line 2769 "chess-state.c"
		}
	}
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp112_ = apply;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!_tmp112_) {
#line 2776 "chess-state.c"
		gboolean _tmp113_ = FALSE;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp113_ = test_check;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp111_ = !_tmp113_;
#line 2782 "chess-state.c"
	} else {
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp111_ = FALSE;
#line 2786 "chess-state.c"
	}
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp111_) {
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = TRUE;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 2798 "chess-state.c"
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp114_ = apply;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp114_) {
#line 2804 "chess-state.c"
		{
			gint i = 0;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			i = 0;
#line 2809 "chess-state.c"
			{
				gboolean _tmp115_ = FALSE;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp115_ = TRUE;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				while (TRUE) {
#line 2816 "chess-state.c"
					gint _tmp117_ = 0;
					gint _tmp118_ = 0;
					gint _tmp119_ = 0;
					ChessPiece* p = NULL;
					gint _tmp120_ = 0;
					ChessPiece* _tmp121_ = NULL;
					ChessPiece* _tmp122_ = NULL;
					gboolean _tmp123_ = FALSE;
					gboolean _tmp124_ = FALSE;
					ChessPiece* _tmp125_ = NULL;
					gint r = 0;
					gint _tmp133_ = 0;
					gint _tmp134_ = 0;
					gint f = 0;
					gint _tmp135_ = 0;
					gint _tmp136_ = 0;
					ChessPlayer* _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gint _tmp139_ = 0;
					gint _tmp140_ = 0;
					gint _tmp141_ = 0;
					gboolean _tmp142_ = FALSE;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!_tmp115_) {
#line 2841 "chess-state.c"
						gint _tmp116_ = 0;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp116_ = i;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						i = _tmp116_ + 1;
#line 2847 "chess-state.c"
					}
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp115_ = FALSE;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp117_ = i;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (!(_tmp117_ < 64)) {
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						break;
#line 2857 "chess-state.c"
					}
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp118_ = i;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp119_ = start;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp118_ == _tmp119_) {
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						continue;
#line 2867 "chess-state.c"
					}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp120_ = i;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp121_ = self->board[_tmp120_];
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp122_ = _g_object_ref0 (_tmp121_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					p = _tmp122_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp125_ = p;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp125_ == NULL) {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp124_ = TRUE;
#line 2883 "chess-state.c"
					} else {
						ChessPiece* _tmp126_ = NULL;
						ChessPlayer* _tmp127_ = NULL;
						ChessPlayer* _tmp128_ = NULL;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp126_ = p;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp127_ = _tmp126_->player;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp128_ = player;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp124_ = _tmp127_ != _tmp128_;
#line 2896 "chess-state.c"
					}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp124_) {
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp123_ = TRUE;
#line 2902 "chess-state.c"
					} else {
						ChessPiece* _tmp129_ = NULL;
						PieceType _tmp130_ = 0;
						ChessPiece* _tmp131_ = NULL;
						PieceType _tmp132_ = 0;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp129_ = p;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp130_ = _tmp129_->type;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp131_ = piece;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp132_ = _tmp131_->type;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp123_ = _tmp130_ != _tmp132_;
#line 2918 "chess-state.c"
					}
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp123_) {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (p);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						continue;
#line 2926 "chess-state.c"
					}
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp133_ = i;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp134_ = chess_state_get_rank (self, _tmp133_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					r = _tmp134_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp135_ = i;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp136_ = chess_state_get_file (self, _tmp135_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					f = _tmp136_;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp137_ = player;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp138_ = r;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp139_ = f;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp140_ = r1;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp141_ = f1;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp142_ = chess_state_move_with_coords (self, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp142_) {
#line 2954 "chess-state.c"
						gint _tmp143_ = 0;
						gint _tmp144_ = 0;
						gint _tmp145_ = 0;
						gint _tmp146_ = 0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp143_ = r;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp144_ = r0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp143_ != _tmp144_) {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							ambiguous_rank = TRUE;
#line 2967 "chess-state.c"
						}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp145_ = f;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp146_ = f0;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp145_ != _tmp146_) {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							ambiguous_file = TRUE;
#line 2977 "chess-state.c"
						}
					}
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 2982 "chess-state.c"
				}
			}
		}
	}
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp147_ = self->priv->piece_masks[COLOR_WHITE];
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_white_mask = _tmp147_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp148_ = self->priv->piece_masks[COLOR_BLACK];
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_black_mask = _tmp148_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp149_ = self->can_castle_kingside[COLOR_WHITE];
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_white_can_castle_kingside = _tmp149_;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp150_ = self->can_castle_queenside[COLOR_WHITE];
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_white_can_castle_queenside = _tmp150_;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp151_ = self->can_castle_kingside[COLOR_BLACK];
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_black_can_castle_kingside = _tmp151_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp152_ = self->can_castle_queenside[COLOR_BLACK];
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_black_can_castle_queenside = _tmp152_;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp153_ = self->en_passant_index;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_en_passant_index = _tmp153_;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp154_ = self->halfmove_clock;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	old_halfmove_clock = _tmp154_;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp155_ = start;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->board[_tmp155_]);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->board[_tmp155_] = NULL;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp156_ = self->board[_tmp155_];
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp157_ = start;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp158_ = BIT_BOARD_clear_location_masks[_tmp157_];
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[COLOR_WHITE] &= _tmp158_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp159_ = self->priv->piece_masks[COLOR_WHITE];
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp160_ = start;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp161_ = BIT_BOARD_clear_location_masks[_tmp160_];
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[COLOR_BLACK] &= _tmp161_;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp162_ = self->priv->piece_masks[COLOR_BLACK];
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp163_ = victim;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp163_ != NULL) {
#line 3047 "chess-state.c"
		gint _tmp164_ = 0;
		ChessPiece* _tmp165_ = NULL;
		gint _tmp166_ = 0;
		gint64 _tmp167_ = 0LL;
		gint64 _tmp168_ = 0LL;
		gint _tmp169_ = 0;
		gint64 _tmp170_ = 0LL;
		gint64 _tmp171_ = 0LL;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp164_ = victim_index;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp164_]);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp164_] = NULL;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp165_ = self->board[_tmp164_];
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp166_ = victim_index;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp167_ = BIT_BOARD_clear_location_masks[_tmp166_];
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_WHITE] &= _tmp167_;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp168_ = self->priv->piece_masks[COLOR_WHITE];
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp169_ = victim_index;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp170_ = BIT_BOARD_clear_location_masks[_tmp169_];
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_BLACK] &= _tmp170_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp171_ = self->priv->piece_masks[COLOR_BLACK];
#line 3080 "chess-state.c"
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp172_ = is_promotion;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp172_) {
#line 3086 "chess-state.c"
		gint _tmp173_ = 0;
		ChessPlayer* _tmp174_ = NULL;
		PieceType _tmp175_ = 0;
		ChessPiece* _tmp176_ = NULL;
		ChessPiece* _tmp177_ = NULL;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp173_ = end;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp174_ = player;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp175_ = promotion_type;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp176_ = chess_piece_new (_tmp174_, _tmp175_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp173_]);
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp173_] = _tmp176_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp177_ = self->board[_tmp173_];
#line 3106 "chess-state.c"
	} else {
		gint _tmp178_ = 0;
		ChessPiece* _tmp179_ = NULL;
		ChessPiece* _tmp180_ = NULL;
		ChessPiece* _tmp181_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp178_ = end;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp179_ = piece;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp180_ = _g_object_ref0 (_tmp179_);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp178_]);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp178_] = _tmp180_;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp181_ = self->board[_tmp178_];
#line 3124 "chess-state.c"
	}
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp182_ = color;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp183_ = end_mask;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[_tmp182_] |= _tmp183_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp184_ = self->priv->piece_masks[_tmp182_];
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp185_ = opponent_color;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp186_ = end;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp187_ = BIT_BOARD_clear_location_masks[_tmp186_];
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[_tmp185_] &= _tmp187_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp188_ = self->priv->piece_masks[_tmp185_];
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp189_ = rook_start;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp189_ >= 0) {
#line 3148 "chess-state.c"
		ChessPiece* rook = NULL;
		gint _tmp190_ = 0;
		ChessPiece* _tmp191_ = NULL;
		ChessPiece* _tmp192_ = NULL;
		gint _tmp193_ = 0;
		ChessPiece* _tmp194_ = NULL;
		Color _tmp195_ = 0;
		gint _tmp196_ = 0;
		gint64 _tmp197_ = 0LL;
		gint64 _tmp198_ = 0LL;
		gint _tmp199_ = 0;
		ChessPiece* _tmp200_ = NULL;
		ChessPiece* _tmp201_ = NULL;
		ChessPiece* _tmp202_ = NULL;
		Color _tmp203_ = 0;
		gint _tmp204_ = 0;
		gint64 _tmp205_ = 0LL;
		gint64 _tmp206_ = 0LL;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp190_ = rook_start;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp191_ = self->board[_tmp190_];
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp192_ = _g_object_ref0 (_tmp191_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		rook = _tmp192_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp193_ = rook_start;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp193_]);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp193_] = NULL;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp194_ = self->board[_tmp193_];
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp195_ = color;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp196_ = rook_start;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp197_ = BIT_BOARD_clear_location_masks[_tmp196_];
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[_tmp195_] &= _tmp197_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp198_ = self->priv->piece_masks[_tmp195_];
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp199_ = rook_end;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp200_ = rook;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp201_ = _g_object_ref0 (_tmp200_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp199_]);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp199_] = _tmp201_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp202_ = self->board[_tmp199_];
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp203_ = color;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp204_ = rook_end;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp205_ = BIT_BOARD_set_location_masks[_tmp204_];
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[_tmp203_] |= _tmp205_;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp206_ = self->priv->piece_masks[_tmp203_];
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (rook);
#line 3217 "chess-state.c"
	}
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp207_ = piece;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp208_ = _tmp207_->type;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp208_ == PIECE_TYPE_KING) {
#line 3225 "chess-state.c"
		Color _tmp209_ = 0;
		gboolean _tmp210_ = FALSE;
		Color _tmp211_ = 0;
		gboolean _tmp212_ = FALSE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp209_ = color;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[_tmp209_] = FALSE;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp210_ = self->can_castle_kingside[_tmp209_];
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp211_ = color;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[_tmp211_] = FALSE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp212_ = self->can_castle_queenside[_tmp211_];
#line 3242 "chess-state.c"
	} else {
		ChessPiece* _tmp213_ = NULL;
		PieceType _tmp214_ = 0;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp213_ = piece;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp214_ = _tmp213_->type;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp214_ == PIECE_TYPE_ROOK) {
#line 3252 "chess-state.c"
			gint _tmp215_ = 0;
			Color _tmp216_ = 0;
			gint base_rank = 0;
			gint _tmp217_ = 0;
			gint _tmp218_ = 0;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp216_ = color;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp216_ == COLOR_WHITE) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp215_ = 0;
#line 3264 "chess-state.c"
			} else {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp215_ = 7;
#line 3268 "chess-state.c"
			}
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			base_rank = _tmp215_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp217_ = r0;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp218_ = base_rank;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp217_ == _tmp218_) {
#line 3278 "chess-state.c"
				gint _tmp219_ = 0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp219_ = f0;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp219_ == 0) {
#line 3284 "chess-state.c"
					Color _tmp220_ = 0;
					gboolean _tmp221_ = FALSE;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp220_ = color;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					self->can_castle_queenside[_tmp220_] = FALSE;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp221_ = self->can_castle_queenside[_tmp220_];
#line 3293 "chess-state.c"
				} else {
					gint _tmp222_ = 0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp222_ = f0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp222_ == 7) {
#line 3300 "chess-state.c"
						Color _tmp223_ = 0;
						gboolean _tmp224_ = FALSE;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp223_ = color;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						self->can_castle_kingside[_tmp223_] = FALSE;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp224_ = self->can_castle_kingside[_tmp223_];
#line 3309 "chess-state.c"
					}
				}
			}
		} else {
			gboolean _tmp225_ = FALSE;
			ChessPiece* _tmp226_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp226_ = victim;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp226_ != NULL) {
#line 3320 "chess-state.c"
				ChessPiece* _tmp227_ = NULL;
				PieceType _tmp228_ = 0;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp227_ = victim;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp228_ = _tmp227_->type;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp225_ = _tmp228_ == PIECE_TYPE_ROOK;
#line 3329 "chess-state.c"
			} else {
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp225_ = FALSE;
#line 3333 "chess-state.c"
			}
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp225_) {
#line 3337 "chess-state.c"
				gint _tmp229_ = 0;
				Color _tmp230_ = 0;
				gint base_rank = 0;
				gint _tmp231_ = 0;
				gint _tmp232_ = 0;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp230_ = opponent_color;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp230_ == COLOR_WHITE) {
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp229_ = 0;
#line 3349 "chess-state.c"
				} else {
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp229_ = 7;
#line 3353 "chess-state.c"
				}
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				base_rank = _tmp229_;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp231_ = r1;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp232_ = base_rank;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp231_ == _tmp232_) {
#line 3363 "chess-state.c"
					gint _tmp233_ = 0;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp233_ = f1;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp233_ == 0) {
#line 3369 "chess-state.c"
						Color _tmp234_ = 0;
						gboolean _tmp235_ = FALSE;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp234_ = opponent_color;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						self->can_castle_queenside[_tmp234_] = FALSE;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp235_ = self->can_castle_queenside[_tmp234_];
#line 3378 "chess-state.c"
					} else {
						gint _tmp236_ = 0;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp236_ = f1;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp236_ == 7) {
#line 3385 "chess-state.c"
							Color _tmp237_ = 0;
							gboolean _tmp238_ = FALSE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp237_ = opponent_color;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							self->can_castle_kingside[_tmp237_] = FALSE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp238_ = self->can_castle_kingside[_tmp237_];
#line 3394 "chess-state.c"
						}
					}
				}
			}
		}
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp240_ = piece;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp241_ = _tmp240_->type;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp241_ == PIECE_TYPE_PAWN) {
#line 3407 "chess-state.c"
		gint64 _tmp242_ = 0LL;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp242_ = over_mask;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp239_ = _tmp242_ != ((gint64) 0);
#line 3413 "chess-state.c"
	} else {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp239_ = FALSE;
#line 3417 "chess-state.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp239_) {
#line 3421 "chess-state.c"
		gint _tmp243_ = 0;
		gint _tmp244_ = 0;
		gint _tmp245_ = 0;
		gint _tmp246_ = 0;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp243_ = r0;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp244_ = r1;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp245_ = f0;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp246_ = chess_state_get_index (self, (_tmp243_ + _tmp244_) / 2, _tmp245_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp246_;
#line 3436 "chess-state.c"
	} else {
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = -1;
#line 3440 "chess-state.c"
	}
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp248_ = piece;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp249_ = _tmp248_->type;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp249_ == PIECE_TYPE_PAWN) {
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp247_ = TRUE;
#line 3450 "chess-state.c"
	} else {
		ChessPiece* _tmp250_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp250_ = victim;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp247_ = _tmp250_ != NULL;
#line 3457 "chess-state.c"
	}
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp247_) {
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = 0;
#line 3463 "chess-state.c"
	} else {
		gint _tmp251_ = 0;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp251_ = self->halfmove_clock;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = _tmp251_ + 1;
#line 3470 "chess-state.c"
	}
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_result_ = TRUE;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp253_ = test_check;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp253_) {
#line 3478 "chess-state.c"
		ChessPlayer* _tmp254_ = NULL;
		gboolean _tmp255_ = FALSE;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp254_ = player;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp255_ = chess_state_is_in_check (self, _tmp254_);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp252_ = _tmp255_;
#line 3487 "chess-state.c"
	} else {
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp252_ = FALSE;
#line 3491 "chess-state.c"
	}
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp252_) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_result_ = FALSE;
#line 3497 "chess-state.c"
	}
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp257_ = apply;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!_tmp257_) {
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp256_ = TRUE;
#line 3505 "chess-state.c"
	} else {
		gboolean _tmp258_ = FALSE;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp258_ = _result_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp256_ = !_tmp258_;
#line 3512 "chess-state.c"
	}
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp256_) {
#line 3516 "chess-state.c"
		gint _tmp259_ = 0;
		ChessPiece* _tmp260_ = NULL;
		ChessPiece* _tmp261_ = NULL;
		ChessPiece* _tmp262_ = NULL;
		gint _tmp263_ = 0;
		ChessPiece* _tmp264_ = NULL;
		ChessPiece* _tmp265_ = NULL;
		gint _tmp270_ = 0;
		gint64 _tmp280_ = 0LL;
		gint64 _tmp281_ = 0LL;
		gint64 _tmp282_ = 0LL;
		gint64 _tmp283_ = 0LL;
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_ = FALSE;
		gboolean _tmp288_ = FALSE;
		gboolean _tmp289_ = FALSE;
		gboolean _tmp290_ = FALSE;
		gboolean _tmp291_ = FALSE;
		gint _tmp292_ = 0;
		gint _tmp293_ = 0;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp259_ = start;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp260_ = piece;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp261_ = _g_object_ref0 (_tmp260_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp259_]);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp259_] = _tmp261_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp262_ = self->board[_tmp259_];
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp263_ = end;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp263_]);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->board[_tmp263_] = NULL;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp264_ = self->board[_tmp263_];
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp265_ = victim;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp265_ != NULL) {
#line 3563 "chess-state.c"
			gint _tmp266_ = 0;
			ChessPiece* _tmp267_ = NULL;
			ChessPiece* _tmp268_ = NULL;
			ChessPiece* _tmp269_ = NULL;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp266_ = victim_index;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp267_ = victim;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp268_ = _g_object_ref0 (_tmp267_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp266_]);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			self->board[_tmp266_] = _tmp268_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp269_ = self->board[_tmp266_];
#line 3580 "chess-state.c"
		}
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp270_ = rook_start;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp270_ >= 0) {
#line 3586 "chess-state.c"
			ChessPiece* rook = NULL;
			gint _tmp271_ = 0;
			ChessPiece* _tmp272_ = NULL;
			ChessPiece* _tmp273_ = NULL;
			gint _tmp274_ = 0;
			ChessPiece* _tmp275_ = NULL;
			ChessPiece* _tmp276_ = NULL;
			ChessPiece* _tmp277_ = NULL;
			gint _tmp278_ = 0;
			ChessPiece* _tmp279_ = NULL;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp271_ = rook_end;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp272_ = self->board[_tmp271_];
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp273_ = _g_object_ref0 (_tmp272_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			rook = _tmp273_;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp274_ = rook_start;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp275_ = rook;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp276_ = _g_object_ref0 (_tmp275_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp274_]);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			self->board[_tmp274_] = _tmp276_;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp277_ = self->board[_tmp274_];
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp278_ = rook_end;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp278_]);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			self->board[_tmp278_] = NULL;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp279_ = self->board[_tmp278_];
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (rook);
#line 3627 "chess-state.c"
		}
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp280_ = old_white_mask;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_WHITE] = _tmp280_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp281_ = self->priv->piece_masks[COLOR_WHITE];
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp282_ = old_black_mask;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_BLACK] = _tmp282_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp283_ = self->priv->piece_masks[COLOR_BLACK];
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp284_ = old_white_can_castle_kingside;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[COLOR_WHITE] = _tmp284_;
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp285_ = self->can_castle_kingside[COLOR_WHITE];
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp286_ = old_white_can_castle_queenside;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[COLOR_WHITE] = _tmp286_;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp287_ = self->can_castle_queenside[COLOR_WHITE];
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp288_ = old_black_can_castle_kingside;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[COLOR_BLACK] = _tmp288_;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp289_ = self->can_castle_kingside[COLOR_BLACK];
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp290_ = old_black_can_castle_queenside;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[COLOR_BLACK] = _tmp290_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp291_ = self->can_castle_queenside[COLOR_BLACK];
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp292_ = old_en_passant_index;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp292_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp293_ = old_halfmove_clock;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = _tmp293_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = _result_;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 3681 "chess-state.c"
	}
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp295_ = color;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp295_ == COLOR_WHITE) {
#line 3687 "chess-state.c"
		ChessPlayer* _tmp296_ = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp296_ = self->players[COLOR_BLACK];
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp294_ = _tmp296_;
#line 3693 "chess-state.c"
	} else {
		ChessPlayer* _tmp297_ = NULL;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp297_ = self->players[COLOR_WHITE];
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp294_ = _tmp297_;
#line 3700 "chess-state.c"
	}
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp298_ = _g_object_ref0 (_tmp294_);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->current_player);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->current_player = _tmp298_;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp299_ = self->current_player;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp300_ = chess_state_get_check_state (self, _tmp299_);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->check_state = _tmp300_;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp301_ = chess_move_new ();
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->last_move);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->last_move = _tmp301_;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp302_ = self->last_move;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp303_ = self->number;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp302_->number = _tmp303_;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp304_ = self->last_move;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp305_ = piece;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp306_ = _g_object_ref0 (_tmp305_);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp304_->piece);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp304_->piece = _tmp306_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp307_ = is_promotion;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp307_) {
#line 3740 "chess-state.c"
		ChessMove* _tmp308_ = NULL;
		gint _tmp309_ = 0;
		ChessPiece* _tmp310_ = NULL;
		ChessPiece* _tmp311_ = NULL;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp308_ = self->last_move;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp309_ = end;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp310_ = self->board[_tmp309_];
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp311_ = _g_object_ref0 (_tmp310_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp308_->promotion_piece);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp308_->promotion_piece = _tmp311_;
#line 3757 "chess-state.c"
	}
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp312_ = self->last_move;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp313_ = victim;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp314_ = _g_object_ref0 (_tmp313_);
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp312_->victim);
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp312_->victim = _tmp314_;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp315_ = rook_end;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp315_ >= 0) {
#line 3773 "chess-state.c"
		ChessMove* _tmp316_ = NULL;
		gint _tmp317_ = 0;
		ChessPiece* _tmp318_ = NULL;
		ChessPiece* _tmp319_ = NULL;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp316_ = self->last_move;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp317_ = rook_end;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp318_ = self->board[_tmp317_];
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp319_ = _g_object_ref0 (_tmp318_);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp316_->moved_rook);
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp316_->moved_rook = _tmp319_;
#line 3790 "chess-state.c"
	}
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp320_ = self->last_move;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp321_ = r0;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp320_->r0 = _tmp321_;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp322_ = self->last_move;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp323_ = f0;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp322_->f0 = _tmp323_;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp324_ = self->last_move;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp325_ = r1;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp324_->r1 = _tmp325_;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp326_ = self->last_move;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp327_ = f1;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp326_->f1 = _tmp327_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp328_ = self->last_move;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp329_ = ambiguous_rank;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp328_->ambiguous_rank = _tmp329_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp330_ = self->last_move;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp331_ = ambiguous_file;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp330_->ambiguous_file = _tmp331_;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp332_ = self->last_move;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp333_ = self->check_state;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp332_->check_state = _tmp333_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (victim);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (piece);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 3842 "chess-state.c"
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_ = 0;
	ChessPlayer* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_ = NULL;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_vala_rule = CHESS_RULE_CHECKMATE;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = self->check_state;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
#line 3863 "chess-state.c"
		ChessPlayer* _tmp1_ = NULL;
		Color _tmp2_ = 0;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp1_ = self->current_player;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp2_ = _tmp1_->color;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp2_ == COLOR_WHITE) {
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = CHESS_RESULT_BLACK_WON;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (rule) {
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*rule = _vala_rule;
#line 3880 "chess-state.c"
			}
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 3884 "chess-state.c"
		} else {
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = CHESS_RESULT_WHITE_WON;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (rule) {
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*rule = _vala_rule;
#line 3894 "chess-state.c"
			}
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 3898 "chess-state.c"
		}
	}
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp3_ = self->current_player;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp4_ = chess_state_can_move (self, _tmp3_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (!_tmp4_) {
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_vala_rule = CHESS_RULE_STALEMATE;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = CHESS_RESULT_DRAW;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (rule) {
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*rule = _vala_rule;
#line 3915 "chess-state.c"
		}
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 3919 "chess-state.c"
	}
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp7_ = self->last_move;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp7_ != NULL) {
#line 3925 "chess-state.c"
		ChessMove* _tmp8_ = NULL;
		ChessPiece* _tmp9_ = NULL;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp8_ = self->last_move;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp9_ = _tmp8_->victim;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 3934 "chess-state.c"
	} else {
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp6_ = FALSE;
#line 3938 "chess-state.c"
	}
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp6_) {
#line 3942 "chess-state.c"
		gboolean _tmp10_ = FALSE;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp10_ = chess_state_have_sufficient_material (self);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp5_ = !_tmp10_;
#line 3948 "chess-state.c"
	} else {
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp5_ = FALSE;
#line 3952 "chess-state.c"
	}
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp5_) {
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = CHESS_RESULT_DRAW;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (rule) {
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*rule = _vala_rule;
#line 3964 "chess-state.c"
		}
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 3968 "chess-state.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = CHESS_RESULT_IN_PROGRESS;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (rule) {
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*rule = _vala_rule;
#line 3976 "chess-state.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 3980 "chess-state.c"
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, 0);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = player;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 3998 "chess-state.c"
		ChessPlayer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp2_ = player;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp3_) {
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = CHECK_STATE_CHECKMATE;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 4011 "chess-state.c"
		} else {
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = CHECK_STATE_CHECK;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 4017 "chess-state.c"
		}
	}
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = CHECK_STATE_NONE;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 4024 "chess-state.c"
}


gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	ChessPlayer* opponent = NULL;
	ChessPlayer* _tmp5_ = NULL;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = player;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp2_ = _tmp1_->color;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 4045 "chess-state.c"
		ChessPlayer* _tmp3_ = NULL;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp3_;
#line 4051 "chess-state.c"
	} else {
		ChessPlayer* _tmp4_ = NULL;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp4_;
#line 4058 "chess-state.c"
	}
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	opponent = _tmp5_;
#line 4064 "chess-state.c"
	{
		gint king_index = 0;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		king_index = 0;
#line 4069 "chess-state.c"
		{
			gboolean _tmp6_ = FALSE;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp6_ = TRUE;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4076 "chess-state.c"
				gint _tmp8_ = 0;
				ChessPiece* p = NULL;
				gint _tmp9_ = 0;
				ChessPiece* _tmp10_ = NULL;
				ChessPiece* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				ChessPiece* _tmp14_ = NULL;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp6_) {
#line 4087 "chess-state.c"
					gint _tmp7_ = 0;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp7_ = king_index;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					king_index = _tmp7_ + 1;
#line 4093 "chess-state.c"
				}
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp6_ = FALSE;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp8_ = king_index;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp8_ < 64)) {
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 4103 "chess-state.c"
				}
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp9_ = king_index;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp10_ = self->board[_tmp9_];
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp11_ = _g_object_ref0 (_tmp10_);
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				p = _tmp11_;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp14_ = p;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp14_ != NULL) {
#line 4117 "chess-state.c"
					ChessPiece* _tmp15_ = NULL;
					ChessPlayer* _tmp16_ = NULL;
					ChessPlayer* _tmp17_ = NULL;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp15_ = p;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp16_ = _tmp15_->player;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp17_ = player;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp13_ = _tmp16_ == _tmp17_;
#line 4129 "chess-state.c"
				} else {
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp13_ = FALSE;
#line 4133 "chess-state.c"
				}
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp13_) {
#line 4137 "chess-state.c"
					ChessPiece* _tmp18_ = NULL;
					PieceType _tmp19_ = 0;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp18_ = p;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp19_ = _tmp18_->type;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp12_ = _tmp19_ == PIECE_TYPE_KING;
#line 4146 "chess-state.c"
				} else {
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp12_ = FALSE;
#line 4150 "chess-state.c"
				}
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp12_) {
#line 4154 "chess-state.c"
					{
						gint start = 0;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						start = 0;
#line 4159 "chess-state.c"
						{
							gboolean _tmp20_ = FALSE;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp20_ = TRUE;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4166 "chess-state.c"
								gint _tmp22_ = 0;
								ChessPlayer* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								gboolean _tmp32_ = FALSE;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!_tmp20_) {
#line 4180 "chess-state.c"
									gint _tmp21_ = 0;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp21_ = start;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									start = _tmp21_ + 1;
#line 4186 "chess-state.c"
								}
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp20_ = FALSE;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp22_ = start;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!(_tmp22_ < 64)) {
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									break;
#line 4196 "chess-state.c"
								}
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp23_ = opponent;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp24_ = start;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp25_ = chess_state_get_rank (self, _tmp24_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp26_ = start;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp27_ = chess_state_get_file (self, _tmp26_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp28_ = king_index;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp29_ = chess_state_get_rank (self, _tmp28_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp30_ = king_index;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp31_ = chess_state_get_file (self, _tmp30_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp32_ = chess_state_move_with_coords (self, _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, PIECE_TYPE_QUEEN, FALSE, FALSE);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (_tmp32_) {
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									result = TRUE;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (opponent);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									return result;
#line 4228 "chess-state.c"
								}
							}
						}
					}
				}
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4236 "chess-state.c"
			}
		}
	}
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = FALSE;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (opponent);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 4246 "chess-state.c"
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 4256 "chess-state.c"
	{
		gint piece_index = 0;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		piece_index = 0;
#line 4261 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4268 "chess-state.c"
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_ = NULL;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4278 "chess-state.c"
					gint _tmp1_ = 0;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp1_ = piece_index;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					piece_index = _tmp1_ + 1;
#line 4284 "chess-state.c"
				}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp2_ = piece_index;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 4294 "chess-state.c"
				}
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp3_ = piece_index;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp7_ = p;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp7_ != NULL) {
#line 4308 "chess-state.c"
					ChessPiece* _tmp8_ = NULL;
					ChessPlayer* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp8_ = p;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp9_ = _tmp8_->player;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp10_ = player;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp6_ = _tmp9_ == _tmp10_;
#line 4320 "chess-state.c"
				} else {
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp6_ = FALSE;
#line 4324 "chess-state.c"
				}
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp6_) {
#line 4328 "chess-state.c"
					{
						gint end = 0;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						end = 0;
#line 4333 "chess-state.c"
						{
							gboolean _tmp11_ = FALSE;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp11_ = TRUE;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4340 "chess-state.c"
								gint _tmp13_ = 0;
								ChessPlayer* _tmp14_ = NULL;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gboolean _tmp23_ = FALSE;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!_tmp11_) {
#line 4354 "chess-state.c"
									gint _tmp12_ = 0;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp12_ = end;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									end = _tmp12_ + 1;
#line 4360 "chess-state.c"
								}
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp11_ = FALSE;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp13_ = end;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!(_tmp13_ < 64)) {
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									break;
#line 4370 "chess-state.c"
								}
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp14_ = player;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp15_ = piece_index;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp17_ = piece_index;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp18_ = chess_state_get_file (self, _tmp17_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp19_ = end;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp21_ = end;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp22_ = chess_state_get_file (self, _tmp21_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (_tmp23_) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									result = FALSE;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									return result;
#line 4400 "chess-state.c"
								}
							}
						}
					}
				}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4408 "chess-state.c"
			}
		}
	}
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 4416 "chess-state.c"
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces = FALSE;
	gboolean _tmp24_ = FALSE;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	have_pieces = FALSE;
#line 4430 "chess-state.c"
	{
		gint start = 0;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		start = 0;
#line 4435 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4442 "chess-state.c"
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_ = NULL;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4452 "chess-state.c"
					gint _tmp1_ = 0;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp1_ = start;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					start = _tmp1_ + 1;
#line 4458 "chess-state.c"
				}
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp2_ = start;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 4468 "chess-state.c"
				}
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp3_ = start;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp7_ = p;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp7_ != NULL) {
#line 4482 "chess-state.c"
					ChessPiece* _tmp8_ = NULL;
					ChessPlayer* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp8_ = p;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp9_ = _tmp8_->player;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp10_ = player;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp6_ = _tmp9_ == _tmp10_;
#line 4494 "chess-state.c"
				} else {
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp6_ = FALSE;
#line 4498 "chess-state.c"
				}
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp6_) {
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					have_pieces = TRUE;
#line 4504 "chess-state.c"
					{
						gint end = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						end = 0;
#line 4509 "chess-state.c"
						{
							gboolean _tmp11_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp11_ = TRUE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4516 "chess-state.c"
								gint _tmp13_ = 0;
								ChessPlayer* _tmp14_ = NULL;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gboolean _tmp23_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!_tmp11_) {
#line 4530 "chess-state.c"
									gint _tmp12_ = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp12_ = end;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									end = _tmp12_ + 1;
#line 4536 "chess-state.c"
								}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp11_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp13_ = end;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (!(_tmp13_ < 64)) {
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									break;
#line 4546 "chess-state.c"
								}
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp14_ = player;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp15_ = start;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp17_ = start;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp18_ = chess_state_get_file (self, _tmp17_);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp19_ = end;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp21_ = end;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp22_ = chess_state_get_file (self, _tmp21_);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								if (_tmp23_) {
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									result = TRUE;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									return result;
#line 4576 "chess-state.c"
								}
							}
						}
					}
				}
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4584 "chess-state.c"
			}
		}
	}
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp24_ = have_pieces;
#line 664 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp24_) {
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 4596 "chess-state.c"
	} else {
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = TRUE;
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 4602 "chess-state.c"
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count = 0;
	gint white_bishop_count = 0;
	gboolean white_bishop_on_white_square = FALSE;
	gboolean white_bishop_on_black_square = FALSE;
	gint black_knight_count = 0;
	gint black_bishop_count = 0;
	gboolean black_bishop_on_white_square = FALSE;
	gboolean black_bishop_on_black_square = FALSE;
#line 670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	white_knight_count = 0;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	white_bishop_count = 0;
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	white_bishop_on_white_square = FALSE;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	white_bishop_on_black_square = FALSE;
#line 676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	black_knight_count = 0;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	black_bishop_count = 0;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	black_bishop_on_white_square = FALSE;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	black_bishop_on_black_square = FALSE;
#line 4635 "chess-state.c"
	{
		gint i = 0;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 4640 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4647 "chess-state.c"
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				ChessPiece* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				ChessPiece* _tmp9_ = NULL;
				PieceType _tmp10_ = 0;
				ChessPiece* _tmp15_ = NULL;
				PieceType _tmp16_ = 0;
				ChessPiece* _tmp22_ = NULL;
				PieceType _tmp23_ = 0;
				gboolean _tmp33_ = FALSE;
				gint _tmp34_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_ = 0;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gint _tmp50_ = 0;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				gint _tmp55_ = 0;
				gboolean _tmp58_ = FALSE;
				gint _tmp59_ = 0;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4682 "chess-state.c"
					gint _tmp1_ = 0;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp1_ = i;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					i = _tmp1_ + 1;
#line 4688 "chess-state.c"
				}
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp2_ = i;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					break;
#line 4698 "chess-state.c"
				}
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp3_ = i;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp6_ = p;
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp6_ == NULL) {
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					continue;
#line 4716 "chess-state.c"
				}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp9_ = p;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp10_ = _tmp9_->type;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp10_ == PIECE_TYPE_PAWN) {
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp8_ = TRUE;
#line 4726 "chess-state.c"
				} else {
					ChessPiece* _tmp11_ = NULL;
					PieceType _tmp12_ = 0;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp11_ = p;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp12_ = _tmp11_->type;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp8_ = _tmp12_ == PIECE_TYPE_ROOK;
#line 4736 "chess-state.c"
				}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp8_) {
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp7_ = TRUE;
#line 4742 "chess-state.c"
				} else {
					ChessPiece* _tmp13_ = NULL;
					PieceType _tmp14_ = 0;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp13_ = p;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp14_ = _tmp13_->type;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp7_ = _tmp14_ == PIECE_TYPE_QUEEN;
#line 4752 "chess-state.c"
				}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp7_) {
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 4762 "chess-state.c"
				}
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp15_ = p;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp16_ = _tmp15_->type;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp16_ == PIECE_TYPE_KNIGHT) {
#line 4770 "chess-state.c"
					ChessPiece* _tmp17_ = NULL;
					Color _tmp18_ = 0;
					Color _tmp19_ = 0;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp17_ = p;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp18_ = chess_piece_get_color (_tmp17_);
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp19_ = _tmp18_;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp19_ == COLOR_WHITE) {
#line 4782 "chess-state.c"
						gint _tmp20_ = 0;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp20_ = white_knight_count;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						white_knight_count = _tmp20_ + 1;
#line 4788 "chess-state.c"
					} else {
						gint _tmp21_ = 0;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp21_ = black_knight_count;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						black_knight_count = _tmp21_ + 1;
#line 4795 "chess-state.c"
					}
				}
#line 700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp22_ = p;
#line 700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp23_ = _tmp22_->type;
#line 700 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp23_ == PIECE_TYPE_BISHOP) {
#line 4804 "chess-state.c"
					Color color = 0;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					ChessPiece* _tmp26_ = NULL;
					Color _tmp27_ = 0;
					Color _tmp28_ = 0;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					color = COLOR_BLACK;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp24_ = i;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp25_ = i;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (((_tmp24_ + (_tmp25_ / 8)) % 2) != 0) {
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						color = COLOR_WHITE;
#line 4821 "chess-state.c"
					}
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp26_ = p;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp27_ = chess_piece_get_color (_tmp26_);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp28_ = _tmp27_;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp28_ == COLOR_WHITE) {
#line 4831 "chess-state.c"
						Color _tmp29_ = 0;
						gint _tmp30_ = 0;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp29_ = color;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp29_ == COLOR_WHITE) {
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							white_bishop_on_white_square = TRUE;
#line 4840 "chess-state.c"
						} else {
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							white_bishop_on_black_square = TRUE;
#line 4844 "chess-state.c"
						}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp30_ = white_bishop_count;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						white_bishop_count = _tmp30_ + 1;
#line 4850 "chess-state.c"
					} else {
						Color _tmp31_ = 0;
						gint _tmp32_ = 0;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp31_ = color;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp31_ == COLOR_WHITE) {
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							black_bishop_on_white_square = TRUE;
#line 4860 "chess-state.c"
						} else {
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							black_bishop_on_black_square = TRUE;
#line 4864 "chess-state.c"
						}
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp32_ = black_bishop_count;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						black_bishop_count = _tmp32_ + 1;
#line 4870 "chess-state.c"
					}
				}
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp34_ = white_knight_count;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp34_ > 1) {
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp33_ = TRUE;
#line 4879 "chess-state.c"
				} else {
					gint _tmp35_ = 0;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp35_ = black_knight_count;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp33_ = _tmp35_ > 1;
#line 4886 "chess-state.c"
				}
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp33_) {
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 4896 "chess-state.c"
				}
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp37_ = white_bishop_count;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp37_ > 0) {
#line 4902 "chess-state.c"
					gint _tmp38_ = 0;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp38_ = white_knight_count;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp36_ = _tmp38_ > 0;
#line 4908 "chess-state.c"
				} else {
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp36_ = FALSE;
#line 4912 "chess-state.c"
				}
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp36_) {
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 4922 "chess-state.c"
				}
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp40_ = black_bishop_count;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp40_ > 0) {
#line 4928 "chess-state.c"
					gint _tmp41_ = 0;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp41_ = black_knight_count;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp39_ = _tmp41_ > 0;
#line 4934 "chess-state.c"
				} else {
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp39_ = FALSE;
#line 4938 "chess-state.c"
				}
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp39_) {
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 4948 "chess-state.c"
				}
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp43_ = white_bishop_on_white_square;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp43_) {
#line 4954 "chess-state.c"
					gboolean _tmp44_ = FALSE;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp44_ = white_bishop_on_black_square;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp42_ = _tmp44_;
#line 4960 "chess-state.c"
				} else {
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp42_ = FALSE;
#line 4964 "chess-state.c"
				}
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp42_) {
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 4974 "chess-state.c"
				}
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp46_ = black_bishop_on_white_square;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp46_) {
#line 4980 "chess-state.c"
					gboolean _tmp47_ = FALSE;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp47_ = black_bishop_on_black_square;
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp45_ = _tmp47_;
#line 4986 "chess-state.c"
				} else {
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp45_ = FALSE;
#line 4990 "chess-state.c"
				}
#line 766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp45_) {
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 5000 "chess-state.c"
				}
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp50_ = white_bishop_count;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp50_ > 0) {
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp49_ = TRUE;
#line 5008 "chess-state.c"
				} else {
					gint _tmp51_ = 0;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp51_ = white_knight_count;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp49_ = _tmp51_ > 0;
#line 5015 "chess-state.c"
				}
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp49_) {
#line 5019 "chess-state.c"
					gint _tmp52_ = 0;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp52_ = black_knight_count;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp48_ = _tmp52_ > 0;
#line 5025 "chess-state.c"
				} else {
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp48_ = FALSE;
#line 5029 "chess-state.c"
				}
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp48_) {
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 5039 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp55_ = black_bishop_count;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp55_ > 0) {
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp54_ = TRUE;
#line 5047 "chess-state.c"
				} else {
					gint _tmp56_ = 0;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp56_ = black_knight_count;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp54_ = _tmp56_ > 0;
#line 5054 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp54_) {
#line 5058 "chess-state.c"
					gint _tmp57_ = 0;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp57_ = white_knight_count;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp53_ = _tmp57_ > 0;
#line 5064 "chess-state.c"
				} else {
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp53_ = FALSE;
#line 5068 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp53_) {
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 5078 "chess-state.c"
				}
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp59_ = white_bishop_count;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp59_ > 0) {
#line 5084 "chess-state.c"
					gint _tmp60_ = 0;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp60_ = black_bishop_count;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp58_ = _tmp60_ > 0;
#line 5090 "chess-state.c"
				} else {
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp58_ = FALSE;
#line 5094 "chess-state.c"
				}
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp58_) {
#line 5098 "chess-state.c"
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_ = FALSE;
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp62_ = white_bishop_on_white_square;
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp62_) {
#line 5105 "chess-state.c"
						gboolean _tmp63_ = FALSE;
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp63_ = black_bishop_on_black_square;
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp61_ = _tmp63_;
#line 5111 "chess-state.c"
					} else {
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp61_ = FALSE;
#line 5115 "chess-state.c"
					}
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (_tmp61_) {
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						result = TRUE;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (p);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						return result;
#line 5125 "chess-state.c"
					} else {
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_ = FALSE;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp65_ = white_bishop_on_black_square;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp65_) {
#line 5133 "chess-state.c"
							gboolean _tmp66_ = FALSE;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp66_ = black_bishop_on_white_square;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp64_ = _tmp66_;
#line 5139 "chess-state.c"
						} else {
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp64_ = FALSE;
#line 5143 "chess-state.c"
						}
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						if (_tmp64_) {
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							result = TRUE;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (p);
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							return result;
#line 5153 "chess-state.c"
						}
					}
				}
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 5159 "chess-state.c"
			}
		}
	}
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = FALSE;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 5167 "chess-state.c"
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_ = 0U;
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_vala_type = PIECE_TYPE_PAWN;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = c;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	switch (_tmp0_) {
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'P':
#line 5185 "chess-state.c"
		{
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_PAWN;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5195 "chess-state.c"
			}
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5199 "chess-state.c"
		}
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'R':
#line 5203 "chess-state.c"
		{
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_ROOK;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5213 "chess-state.c"
			}
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5217 "chess-state.c"
		}
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'N':
#line 5221 "chess-state.c"
		{
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_KNIGHT;
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5231 "chess-state.c"
			}
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5235 "chess-state.c"
		}
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'B':
#line 5239 "chess-state.c"
		{
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_BISHOP;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5249 "chess-state.c"
			}
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5253 "chess-state.c"
		}
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'Q':
#line 5257 "chess-state.c"
		{
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_QUEEN;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5267 "chess-state.c"
			}
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5271 "chess-state.c"
		}
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case 'K':
#line 5275 "chess-state.c"
		{
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_KING;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5285 "chess-state.c"
			}
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5289 "chess-state.c"
		}
		default:
		{
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			result = FALSE;
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5299 "chess-state.c"
			}
#line 812 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			return result;
#line 5303 "chess-state.c"
		}
	}
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (type) {
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*type = _vala_type;
#line 5310 "chess-state.c"
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp150_ = NULL;
	gint _tmp151_ = 0;
	gchar _tmp152_ = '\0';
	const gchar* _tmp158_ = NULL;
	gint _tmp159_ = 0;
	gchar _tmp160_ = '\0';
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	i = 0;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp0_ = move;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 5347 "chess-state.c"
		ChessPlayer* _tmp2_ = NULL;
		Color _tmp3_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp2_ = player;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = _tmp2_->color;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp3_ == COLOR_WHITE) {
#line 5359 "chess-state.c"
			gint _tmp4_ = 0;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r1 = 0;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp4_ = _vala_r1;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp4_;
#line 5367 "chess-state.c"
		} else {
			gint _tmp5_ = 0;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r1 = 7;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp5_ = _vala_r1;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp5_;
#line 5376 "chess-state.c"
		}
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_vala_f0 = 4;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_vala_f1 = 2;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp6_ = i;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp7_ = strlen ("O-O-O");
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp8_ = _tmp7_;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = _tmp6_ + ((gint) _tmp8_);
#line 5390 "chess-state.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp9_ = move;
#line 831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
#line 831 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp10_) {
#line 5400 "chess-state.c"
			ChessPlayer* _tmp11_ = NULL;
			Color _tmp12_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp11_ = player;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp12_ = _tmp11_->color;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp12_ == COLOR_WHITE) {
#line 5412 "chess-state.c"
				gint _tmp13_ = 0;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r1 = 0;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp13_ = _vala_r1;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp13_;
#line 5420 "chess-state.c"
			} else {
				gint _tmp14_ = 0;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r1 = 7;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp14_ = _vala_r1;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp14_;
#line 5429 "chess-state.c"
			}
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_f0 = 4;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_f1 = 6;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp15_ = i;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp16_ = strlen ("O-O");
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp17_ = _tmp16_;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			i = _tmp15_ + ((gint) _tmp17_);
#line 5443 "chess-state.c"
		} else {
			PieceType type = 0;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gchar _tmp20_ = '\0';
			PieceType _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gchar _tmp30_ = '\0';
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gchar _tmp41_ = '\0';
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			gchar _tmp52_ = '\0';
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			gchar _tmp60_ = '\0';
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gchar _tmp72_ = '\0';
			const gchar* _tmp81_ = NULL;
			gint _tmp82_ = 0;
			gchar _tmp83_ = '\0';
			gboolean _tmp101_ = FALSE;
			gint _tmp102_ = 0;
			gboolean _tmp105_ = FALSE;
			gint _tmp106_ = 0;
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			type = PIECE_TYPE_PAWN;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp18_ = move;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp19_ = i;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			type = _tmp21_;
#line 844 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp22_) {
#line 5495 "chess-state.c"
				gint _tmp23_ = 0;
#line 845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp23_ = i;
#line 845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp23_ + 1;
#line 5501 "chess-state.c"
			}
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_f1 = -1;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp24_ = _vala_f1;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r1 = _tmp24_;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp25_ = _vala_r1;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_f0 = _tmp25_;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp26_ = _vala_f0;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp26_;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp28_ = move;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp29_ = i;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp30_ >= 'a') {
#line 5525 "chess-state.c"
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gchar _tmp33_ = '\0';
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp31_ = move;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp32_ = i;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp27_ = _tmp33_ <= 'h';
#line 5537 "chess-state.c"
			} else {
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp27_ = FALSE;
#line 5541 "chess-state.c"
			}
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp27_) {
#line 5545 "chess-state.c"
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gchar _tmp36_ = '\0';
				gint _tmp37_ = 0;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp34_ = move;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp35_ = i;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp36_ = string_get (_tmp34_, (glong) _tmp35_);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_f1 = (gint) (_tmp36_ - 'a');
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp37_ = i;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp37_ + 1;
#line 5562 "chess-state.c"
			}
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp39_ = move;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp40_ = i;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp41_ >= '1') {
#line 5572 "chess-state.c"
				const gchar* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gchar _tmp44_ = '\0';
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp42_ = move;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp43_ = i;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp44_ = string_get (_tmp42_, (glong) _tmp43_);
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp38_ = _tmp44_ <= '8';
#line 5584 "chess-state.c"
			} else {
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp38_ = FALSE;
#line 5588 "chess-state.c"
			}
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp38_) {
#line 5592 "chess-state.c"
				const gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				gchar _tmp47_ = '\0';
				gint _tmp48_ = 0;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp45_ = move;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp46_ = i;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp47_ = string_get (_tmp45_, (glong) _tmp46_);
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r1 = (gint) (_tmp47_ - '1');
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp48_ = i;
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp48_ + 1;
#line 5609 "chess-state.c"
			}
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp50_ = move;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp51_ = i;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp52_ == 'x') {
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp49_ = TRUE;
#line 5621 "chess-state.c"
			} else {
				const gchar* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gchar _tmp55_ = '\0';
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp53_ = move;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp54_ = i;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp55_ = string_get (_tmp53_, (glong) _tmp54_);
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp49_ = _tmp55_ == '-';
#line 5634 "chess-state.c"
			}
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp49_) {
#line 5638 "chess-state.c"
				gint _tmp56_ = 0;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp56_ = i;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp56_ + 1;
#line 5644 "chess-state.c"
			}
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp58_ = move;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp59_ = i;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp60_ = string_get (_tmp58_, (glong) _tmp59_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp60_ >= 'a') {
#line 5654 "chess-state.c"
				const gchar* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gchar _tmp63_ = '\0';
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp61_ = move;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp62_ = i;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp57_ = _tmp63_ <= 'h';
#line 5666 "chess-state.c"
			} else {
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp57_ = FALSE;
#line 5670 "chess-state.c"
			}
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp57_) {
#line 5674 "chess-state.c"
				gint _tmp64_ = 0;
				const gchar* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gchar _tmp67_ = '\0';
				gint _tmp68_ = 0;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp64_ = _vala_f1;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_f0 = _tmp64_;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp65_ = move;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp66_ = i;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp67_ = string_get (_tmp65_, (glong) _tmp66_);
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_f1 = (gint) (_tmp67_ - 'a');
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp68_ = i;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp68_ + 1;
#line 5696 "chess-state.c"
			}
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp70_ = move;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp71_ = i;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp72_ = string_get (_tmp70_, (glong) _tmp71_);
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp72_ >= '1') {
#line 5706 "chess-state.c"
				const gchar* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gchar _tmp75_ = '\0';
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp73_ = move;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp74_ = i;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp75_ = string_get (_tmp73_, (glong) _tmp74_);
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp69_ = _tmp75_ <= '8';
#line 5718 "chess-state.c"
			} else {
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp69_ = FALSE;
#line 5722 "chess-state.c"
			}
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp69_) {
#line 5726 "chess-state.c"
				gint _tmp76_ = 0;
				const gchar* _tmp77_ = NULL;
				gint _tmp78_ = 0;
				gchar _tmp79_ = '\0';
				gint _tmp80_ = 0;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp76_ = _vala_r1;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp76_;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp77_ = move;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp78_ = i;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r1 = (gint) (_tmp79_ - '1');
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp80_ = i;
#line 870 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp80_ + 1;
#line 5748 "chess-state.c"
			}
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp81_ = move;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp82_ = i;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp83_ == '=') {
#line 5758 "chess-state.c"
				gint _tmp84_ = 0;
				const gchar* _tmp85_ = NULL;
				gint _tmp86_ = 0;
				gchar _tmp87_ = '\0';
				PieceType _tmp88_ = 0;
				gboolean _tmp89_ = FALSE;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp84_ = i;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				i = _tmp84_ + 1;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp85_ = move;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp86_ = i;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp87_ = string_get (_tmp85_, (glong) _tmp86_);
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp89_ = chess_state_decode_piece_type (self, (gunichar) _tmp87_, &_tmp88_);
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_promotion_type = _tmp88_;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp89_) {
#line 5781 "chess-state.c"
					gint _tmp90_ = 0;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp90_ = i;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					i = _tmp90_ + 1;
#line 5787 "chess-state.c"
				}
			} else {
				const gchar* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gchar _tmp93_ = '\0';
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp91_ = move;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp92_ = i;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp93_ = string_get (_tmp91_, (glong) _tmp92_);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp93_ != '\0') {
#line 5801 "chess-state.c"
					const gchar* _tmp94_ = NULL;
					gint _tmp95_ = 0;
					gchar _tmp96_ = '\0';
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp94_ = move;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp95_ = i;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp96_ = string_get (_tmp94_, (glong) _tmp95_);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					switch (_tmp96_) {
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'q':
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'Q':
#line 5817 "chess-state.c"
						{
							gint _tmp97_ = 0;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp97_ = i;
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							i = _tmp97_ + 1;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							break;
#line 5828 "chess-state.c"
						}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'n':
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'N':
#line 5834 "chess-state.c"
						{
							gint _tmp98_ = 0;
#line 889 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp98_ = i;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							i = _tmp98_ + 1;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							break;
#line 5845 "chess-state.c"
						}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'r':
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'R':
#line 5851 "chess-state.c"
						{
							gint _tmp99_ = 0;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_ROOK;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp99_ = i;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							i = _tmp99_ + 1;
#line 896 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							break;
#line 5862 "chess-state.c"
						}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'b':
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						case 'B':
#line 5868 "chess-state.c"
						{
							gint _tmp100_ = 0;
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_BISHOP;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp100_ = i;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							i = _tmp100_ + 1;
#line 901 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							break;
#line 5879 "chess-state.c"
						}
						default:
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						break;
#line 5884 "chess-state.c"
					}
				}
			}
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp102_ = _vala_r1;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp102_ < 0) {
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp101_ = TRUE;
#line 5894 "chess-state.c"
			} else {
				gint _tmp103_ = 0;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp103_ = _vala_f1;
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp101_ = _tmp103_ < 0;
#line 5901 "chess-state.c"
			}
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp101_) {
#line 5905 "chess-state.c"
				const gchar* _tmp104_ = NULL;
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp104_ = move;
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				g_debug ("chess-state.vala:908: Move %s missing destination", _tmp104_);
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				result = FALSE;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (r0) {
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					*r0 = _vala_r0;
#line 5917 "chess-state.c"
				}
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (f0) {
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					*f0 = _vala_f0;
#line 5923 "chess-state.c"
				}
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (r1) {
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					*r1 = _vala_r1;
#line 5929 "chess-state.c"
				}
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (f1) {
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					*f1 = _vala_f1;
#line 5935 "chess-state.c"
				}
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (promotion_type) {
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					*promotion_type = _vala_promotion_type;
#line 5941 "chess-state.c"
				}
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				return result;
#line 5945 "chess-state.c"
			}
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp106_ = _vala_r0;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp106_ < 0) {
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp105_ = TRUE;
#line 5953 "chess-state.c"
			} else {
				gint _tmp107_ = 0;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp107_ = _vala_f0;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp105_ = _tmp107_ < 0;
#line 5960 "chess-state.c"
			}
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			if (_tmp105_) {
#line 5964 "chess-state.c"
				gint match_rank = 0;
				gint match_file = 0;
				gint _tmp146_ = 0;
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				match_rank = -1;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				match_file = -1;
#line 5974 "chess-state.c"
				{
					gint file = 0;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 5979 "chess-state.c"
					{
						gboolean _tmp108_ = FALSE;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						_tmp108_ = TRUE;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 5986 "chess-state.c"
							gint _tmp110_ = 0;
							gboolean _tmp111_ = FALSE;
							gint _tmp112_ = 0;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!_tmp108_) {
#line 5992 "chess-state.c"
								gint _tmp109_ = 0;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp109_ = file;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								file = _tmp109_ + 1;
#line 5998 "chess-state.c"
							}
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp108_ = FALSE;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp110_ = file;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (!(_tmp110_ < 8)) {
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								break;
#line 6008 "chess-state.c"
							}
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							_tmp112_ = _vala_f0;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp112_ >= 0) {
#line 6014 "chess-state.c"
								gint _tmp113_ = 0;
								gint _tmp114_ = 0;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp113_ = file;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp114_ = _vala_f0;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp111_ = _tmp113_ != _tmp114_;
#line 6023 "chess-state.c"
							} else {
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								_tmp111_ = FALSE;
#line 6027 "chess-state.c"
							}
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
							if (_tmp111_) {
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								continue;
#line 6033 "chess-state.c"
							}
							{
								gint rank = 0;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
								rank = 0;
#line 6039 "chess-state.c"
								{
									gboolean _tmp115_ = FALSE;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									_tmp115_ = TRUE;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
									while (TRUE) {
#line 6046 "chess-state.c"
										gint _tmp117_ = 0;
										gboolean _tmp118_ = FALSE;
										gint _tmp119_ = 0;
										ChessPiece* piece = NULL;
										gint _tmp122_ = 0;
										gint _tmp123_ = 0;
										gint _tmp124_ = 0;
										ChessPiece* _tmp125_ = NULL;
										ChessPiece* _tmp126_ = NULL;
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_ = FALSE;
										ChessPiece* _tmp129_ = NULL;
										ChessPlayer* _tmp136_ = NULL;
										gint _tmp137_ = 0;
										gint _tmp138_ = 0;
										gint _tmp139_ = 0;
										gint _tmp140_ = 0;
										gboolean _tmp141_ = FALSE;
										gint _tmp142_ = 0;
										gint _tmp144_ = 0;
										gint _tmp145_ = 0;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (!_tmp115_) {
#line 6070 "chess-state.c"
											gint _tmp116_ = 0;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp116_ = rank;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											rank = _tmp116_ + 1;
#line 6076 "chess-state.c"
										}
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp115_ = FALSE;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp117_ = rank;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (!(_tmp117_ < 8)) {
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											break;
#line 6086 "chess-state.c"
										}
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp119_ = _vala_r0;
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp119_ >= 0) {
#line 6092 "chess-state.c"
											gint _tmp120_ = 0;
											gint _tmp121_ = 0;
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp120_ = rank;
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp121_ = _vala_r0;
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp118_ = _tmp120_ != _tmp121_;
#line 6101 "chess-state.c"
										} else {
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp118_ = FALSE;
#line 6105 "chess-state.c"
										}
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp118_) {
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											continue;
#line 6111 "chess-state.c"
										}
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp122_ = rank;
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp123_ = file;
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp124_ = chess_state_get_index (self, _tmp122_, _tmp123_);
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp125_ = self->board[_tmp124_];
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp126_ = _g_object_ref0 (_tmp125_);
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										piece = _tmp126_;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp129_ = piece;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp129_ == NULL) {
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp128_ = TRUE;
#line 6131 "chess-state.c"
										} else {
											ChessPiece* _tmp130_ = NULL;
											PieceType _tmp131_ = 0;
											PieceType _tmp132_ = 0;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp130_ = piece;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp131_ = _tmp130_->type;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp132_ = type;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp128_ = _tmp131_ != _tmp132_;
#line 6144 "chess-state.c"
										}
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp128_) {
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp127_ = TRUE;
#line 6150 "chess-state.c"
										} else {
											ChessPiece* _tmp133_ = NULL;
											ChessPlayer* _tmp134_ = NULL;
											ChessPlayer* _tmp135_ = NULL;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp133_ = piece;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp134_ = _tmp133_->player;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp135_ = player;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp127_ = _tmp134_ != _tmp135_;
#line 6163 "chess-state.c"
										}
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp127_) {
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											continue;
#line 6171 "chess-state.c"
										}
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp136_ = player;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp137_ = rank;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp138_ = file;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp139_ = _vala_r1;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp140_ = _vala_f1;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp141_ = chess_state_move_with_coords (self, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (!_tmp141_) {
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											continue;
#line 6191 "chess-state.c"
										}
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp142_ = match_rank;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										if (_tmp142_ >= 0) {
#line 6197 "chess-state.c"
											const gchar* _tmp143_ = NULL;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_tmp143_ = move;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											g_debug ("chess-state.vala:939: Move %s is ambiguous", _tmp143_);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											result = FALSE;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											if (r0) {
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
												*r0 = _vala_r0;
#line 6211 "chess-state.c"
											}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											if (f0) {
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
												*f0 = _vala_f0;
#line 6217 "chess-state.c"
											}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											if (r1) {
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
												*r1 = _vala_r1;
#line 6223 "chess-state.c"
											}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											if (f1) {
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
												*f1 = _vala_f1;
#line 6229 "chess-state.c"
											}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											if (promotion_type) {
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
												*promotion_type = _vala_promotion_type;
#line 6235 "chess-state.c"
											}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
											return result;
#line 6239 "chess-state.c"
										}
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp144_ = rank;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										match_rank = _tmp144_;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_tmp145_ = file;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										match_file = _tmp145_;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
										_g_object_unref0 (piece);
#line 6251 "chess-state.c"
									}
								}
							}
						}
					}
				}
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp146_ = match_rank;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				if (_tmp146_ < 0) {
#line 6262 "chess-state.c"
					const gchar* _tmp147_ = NULL;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					_tmp147_ = move;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					g_debug ("chess-state.vala:950: Move %s has no matches", _tmp147_);
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (r0) {
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						*r0 = _vala_r0;
#line 6274 "chess-state.c"
					}
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (f0) {
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						*f0 = _vala_f0;
#line 6280 "chess-state.c"
					}
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (r1) {
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						*r1 = _vala_r1;
#line 6286 "chess-state.c"
					}
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (f1) {
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						*f1 = _vala_f1;
#line 6292 "chess-state.c"
					}
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					if (promotion_type) {
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
						*promotion_type = _vala_promotion_type;
#line 6298 "chess-state.c"
					}
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
					return result;
#line 6302 "chess-state.c"
				}
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp148_ = match_rank;
#line 954 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp148_;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_tmp149_ = match_file;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
				_vala_f0 = _tmp149_;
#line 6312 "chess-state.c"
			}
		}
	}
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp150_ = move;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp151_ = i;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp152_ = string_get (_tmp150_, (glong) _tmp151_);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp152_ == '+') {
#line 6324 "chess-state.c"
		gint _tmp153_ = 0;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp153_ = i;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		i = _tmp153_ + 1;
#line 6330 "chess-state.c"
	} else {
		const gchar* _tmp154_ = NULL;
		gint _tmp155_ = 0;
		gchar _tmp156_ = '\0';
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp154_ = move;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp155_ = i;
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp156_ = string_get (_tmp154_, (glong) _tmp155_);
#line 961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (_tmp156_ == '#') {
#line 6343 "chess-state.c"
			gint _tmp157_ = 0;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			_tmp157_ = i;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			i = _tmp157_ + 1;
#line 6349 "chess-state.c"
		}
	}
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp158_ = move;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp159_ = i;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp160_ = string_get (_tmp158_, (glong) _tmp159_);
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp160_ != '\0') {
#line 6360 "chess-state.c"
		const gchar* _tmp161_ = NULL;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp161_ = move;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_debug ("chess-state.vala:966: Move %s has unexpected characters", _tmp161_);
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (r0) {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*r0 = _vala_r0;
#line 6372 "chess-state.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (f0) {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*f0 = _vala_f0;
#line 6378 "chess-state.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (r1) {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*r1 = _vala_r1;
#line 6384 "chess-state.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (f1) {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*f1 = _vala_f1;
#line 6390 "chess-state.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		if (promotion_type) {
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
			*promotion_type = _vala_promotion_type;
#line 6396 "chess-state.c"
		}
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		return result;
#line 6400 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (r0) {
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*r0 = _vala_r0;
#line 6408 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (f0) {
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*f0 = _vala_f0;
#line 6414 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (r1) {
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*r1 = _vala_r1;
#line 6420 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (f1) {
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*f1 = _vala_f1;
#line 6426 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (promotion_type) {
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		*promotion_type = _vala_promotion_type;
#line 6432 "chess-state.c"
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 6436 "chess-state.c"
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp1_ = self->current_player;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_tmp2_ = _tmp1_->color;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 6453 "chess-state.c"
		ChessPlayer* _tmp3_ = NULL;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp3_;
#line 6459 "chess-state.c"
	} else {
		ChessPlayer* _tmp4_ = NULL;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp4_;
#line 6466 "chess-state.c"
	}
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	result = _tmp0_;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	return result;
#line 6472 "chess-state.c"
}


static void chess_state_class_init (ChessStateClass * klass) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	chess_state_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_state_get_property;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_state_finalize;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_STATE_OPPONENT, g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6487 "chess-state.c"
}


static void chess_state_instance_init (ChessState * self) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->priv = CHESS_STATE_GET_PRIVATE (self);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->number = 0;
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->en_passant_index = -1;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self->last_move = NULL;
#line 6500 "chess-state.c"
}


static void chess_state_finalize (GObject* obj) {
	ChessState * self;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->current_player);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_vala_array_destroy (self->board, 64, (GDestroyNotify) g_object_unref);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->last_move);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (chess_state_parent_class)->finalize (obj);
#line 6518 "chess-state.c"
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, NULL };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessState", &g_define_type_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_STATE, ChessState);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
	switch (property_id) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		case CHESS_STATE_OPPONENT:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		g_value_set_object (value, chess_state_get_opponent (self));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		break;
#line 6545 "chess-state.c"
		default:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-state.vala"
		break;
#line 6551 "chess-state.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



