/* rygel-music-item.c generated by valac 0.25.3.10-37e0, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <gee.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMusicItemPrivate {
	gint _track_number;
	RygelThumbnail* _album_art;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_music_item_parent_class = NULL;
extern GRegex* rygel_media_item_address_regex;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_MUSIC_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemPrivate))
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY,
	RYGEL_MUSIC_ITEM_TRACK_NUMBER,
	RYGEL_MUSIC_ITEM_ALBUM_ART
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value);
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
gint rygel_music_item_get_track_number (RygelMusicItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_music_item_set_track_number (RygelMusicItem* self, gint value);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
static void rygel_music_item_finalize (GObject* obj);
static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = upnp_class;
	self = (RygelMusicItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
	return self;
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
}


void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelMediaArtStore* media_art_store = NULL;
	RygelMediaArtStore* _tmp1_ = NULL;
	RygelMediaArtStore* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_album_art;
	_vala_assert (_tmp0_ == NULL, "this.album_art == null");
	_tmp1_ = rygel_media_art_store_get_default ();
	media_art_store = _tmp1_;
	_tmp2_ = media_art_store;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (media_art_store);
		return;
	}
	{
		RygelThumbnail* _tmp3_ = NULL;
		RygelMediaArtStore* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_ = NULL;
		RygelThumbnail* _tmp6_ = NULL;
		_tmp4_ = media_art_store;
		_tmp5_ = rygel_media_art_store_find_media_art_any (_tmp4_, self, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		rygel_music_item_set_album_art (self, _tmp6_);
		_rygel_icon_info_unref0 (_tmp3_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (media_art_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (media_art_store);
}


static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelThumbnail* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = didl_item;
	_tmp1_ = allow_internal;
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_album_art;
	if (_tmp2_ != NULL) {
		gchar* protocol = NULL;
		RygelThumbnail* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = self->priv->_album_art;
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
		_tmp5_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp4_, &_inner_error_);
		protocol = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp7_ = allow_internal;
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = protocol;
			_tmp6_ = g_strcmp0 (_tmp8_, "internal") != 0;
		}
		if (_tmp6_) {
			GUPnPDIDLLiteItem* _tmp9_ = NULL;
			RygelThumbnail* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp9_ = didl_item;
			_tmp10_ = self->priv->_album_art;
			_tmp11_ = ((RygelIconInfo*) _tmp10_)->uri;
			gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp9_, _tmp11_);
		}
		_g_free0 (protocol);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMusicItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMusicItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = media_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MUSIC_ITEM)) {
		result = 1;
		return result;
	}
	_tmp1_ = media_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp1_) : NULL);
	item = _tmp2_;
	_tmp3_ = property;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gint _tmp7_ = 0;
				RygelMusicItem* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				_tmp7_ = self->priv->_track_number;
				_tmp8_ = item;
				_tmp9_ = _tmp8_->priv->_track_number;
				_tmp10_ = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
				result = _tmp10_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				_tmp11_ = item;
				_tmp12_ = property;
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp11_, _tmp12_);
				result = _tmp13_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = (RygelMusicItem*) base;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
	_tmp1_ = didl_object;
	_tmp2_ = gupnp_didl_lite_object_get_track_number (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_music_item_set_track_number (self, _tmp3_);
}


static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GUPnPDIDLLiteObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = serializer;
	_tmp1_ = http_server;
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
	didl_item = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = self->priv->_track_number;
	if (_tmp3_ >= 0) {
		GUPnPDIDLLiteObject* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = didl_item;
		_tmp5_ = self->priv->_track_number;
		gupnp_didl_lite_object_set_track_number (_tmp4_, _tmp5_);
	}
	_tmp6_ = didl_item;
	_tmp7_ = gupnp_didl_lite_object_get_album_art (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		gchar* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		GUPnPDIDLLiteObject* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		RygelHTTPServer* _tmp14_ = NULL;
		GUPnPContext* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		GUPnPDIDLLiteObject* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp10_ = rygel_media_item_address_regex;
		_tmp11_ = didl_item;
		_tmp12_ = gupnp_didl_lite_object_get_album_art (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = http_server;
		_tmp15_ = _tmp14_->context;
		_tmp16_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_regex_replace_literal (_tmp10_, _tmp13_, (gssize) (-1), 0, _tmp17_, 0, &_inner_error_);
		_tmp9_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		_tmp19_ = didl_item;
		_tmp20_ = _tmp9_;
		_tmp9_ = NULL;
		gupnp_didl_lite_object_set_album_art (_tmp19_, _tmp20_);
		_g_free0 (_tmp9_);
	}
	result = didl_item;
	return result;
}


static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelMusicItem * self;
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelMusicItem*) base;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = server;
	_tmp1_ = didl_item;
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_proxy_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		RygelThumbnail* _tmp6_ = NULL;
		_tmp6_ = self->priv->_album_art;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		RygelHTTPServer* _tmp7_ = NULL;
		RygelThumbnail* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = server;
		_tmp8_ = self->priv->_album_art;
		_tmp9_ = ((RygelIconInfo*) _tmp8_)->uri;
		_tmp10_ = rygel_http_server_need_proxy (_tmp7_, _tmp9_);
		_tmp2_ = _tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GUPnPDIDLLiteItem* _tmp11_ = NULL;
		RygelHTTPServer* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp11_ = didl_item;
		_tmp12_ = server;
		_tmp13_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp12_, (RygelMediaItem*) self, 0, -1, NULL, NULL);
		_tmp14_ = _tmp13_;
		gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp11_, _tmp14_);
		_g_free0 (_tmp14_);
	}
}


gint rygel_music_item_get_track_number (RygelMusicItem* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_track_number;
	result = _tmp0_;
	return result;
}


void rygel_music_item_set_track_number (RygelMusicItem* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_track_number = _tmp0_;
	g_object_notify ((GObject *) self, "track-number");
}


RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self) {
	RygelThumbnail* result;
	RygelThumbnail* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_album_art;
	result = _tmp0_;
	return result;
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
	return self ? rygel_icon_info_ref (self) : NULL;
}


void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _rygel_icon_info_ref0 (_tmp0_);
	_rygel_icon_info_unref0 (self->priv->_album_art);
	self->priv->_album_art = _tmp1_;
	g_object_notify ((GObject *) self, "album-art");
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMusicItemPrivate));
	((RygelMediaItemClass *) klass)->add_resources = rygel_music_item_real_add_resources;
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_music_item_real_compare_by_property;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_music_item_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->serialize = rygel_music_item_real_serialize;
	((RygelMediaItemClass *) klass)->add_proxy_resources = rygel_music_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_music_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_music_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_TRACK_NUMBER, g_param_spec_int ("track-number", "track-number", "track-number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ALBUM_ART, rygel_param_spec_icon_info ("album-art", "album-art", "album-art", RYGEL_TYPE_THUMBNAIL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
	self->priv = RYGEL_MUSIC_ITEM_GET_PRIVATE (self);
	self->priv->_track_number = -1;
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	_rygel_icon_info_unref0 (self->priv->_album_art);
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	switch (property_id) {
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
		g_value_set_int (value, rygel_music_item_get_track_number (self));
		break;
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
		rygel_value_set_icon_info (value, rygel_music_item_get_album_art (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	switch (property_id) {
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
		rygel_music_item_set_track_number (self, g_value_get_int (value));
		break;
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
		rygel_music_item_set_album_art (self, rygel_value_get_icon_info (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



