/* sudoku-generator.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GENERATOR_THREAD (generator_thread_get_type ())
#define GENERATOR_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERATOR_THREAD, GeneratorThread))
#define GENERATOR_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERATOR_THREAD, GeneratorThreadClass))
#define IS_GENERATOR_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERATOR_THREAD))
#define IS_GENERATOR_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERATOR_THREAD))
#define GENERATOR_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERATOR_THREAD, GeneratorThreadClass))

typedef struct _GeneratorThread GeneratorThread;
typedef struct _GeneratorThreadClass GeneratorThreadClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GeneratorThreadPrivate GeneratorThreadPrivate;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint nboards;
	DifficultyCategory category;
	SudokuBoard** result;
	gint result_length1;
	GeeArrayList* boards_list;
	GeeArrayList* _tmp0_;
	SudokuBoard** boards;
	gint _tmp1_;
	SudokuBoard** _tmp2_;
	gint boards_length1;
	gint _boards_size_;
	GThread* threads[16];
	gint ncpu_usable;
	gint _tmp3_;
	gint _tmp4_;
	gint nthreads;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint base_nsudokus_each;
	gint _tmp8_;
	gint _tmp9_;
	gint remainder;
	gint _tmp10_;
	gint _tmp11_;
	gint nsudokus_per_thread;
	gint _tmp12_;
	gint i;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeneratorThread* gen_thread;
	gint _tmp21_;
	DifficultyCategory _tmp22_;
	GeneratorThread* _tmp23_;
	gint _tmp24_;
	GeneratorThread* _tmp25_;
	GThread* _tmp26_;
	GThread* _tmp27_;
	gint _vala1_i;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GThread* _tmp33_;
	GThread* _tmp34_;
	gint _vala2_i;
	gboolean _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	SudokuBoard** _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gpointer _tmp45_;
	SudokuBoard* _tmp46_;
	SudokuBoard** _tmp47_;
	gint _tmp47__length1;
};

struct _GeneratorThread {
	GObject parent_instance;
	GeneratorThreadPrivate * priv;
};

struct _GeneratorThreadClass {
	GObjectClass parent_class;
};

struct _GeneratorThreadPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeArrayList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};


static gpointer sudoku_generator_parent_class = NULL;
static gpointer generator_thread_parent_class = NULL;

GType sudoku_generator_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
static SudokuGenerator* sudoku_generator_new (void);
static SudokuGenerator* sudoku_generator_construct (GType object_type);
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_);
SudokuBoard** sudoku_generator_generate_boards_finish (GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static gint sudoku_generator_get_number_of_processors (void);
GType generator_thread_get_type (void) G_GNUC_CONST;
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
GeneratorThread* generator_thread_new (gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target);
GeneratorThread* generator_thread_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target);
void* generator_thread_run (GeneratorThread* self);
static gpointer _generator_thread_run_gthread_func (gpointer self);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);
#define GENERATOR_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GENERATOR_THREAD, GeneratorThreadPrivate))
enum  {
	GENERATOR_THREAD_DUMMY_PROPERTY
};
static gboolean __lambda4_ (GeneratorThread* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void generator_thread_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
	return self;
}


static SudokuGenerator* sudoku_generator_new (void) {
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
}


SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint* puzzle = NULL;
	DifficultyCategory _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	SudokuBoard* _tmp27_ = NULL;
	DifficultyCategory _tmp28_ = 0;
	_tmp0_ = sudoku_board_new (3, 3);
	board = _tmp0_;
	_tmp1_ = category;
	_tmp2_ = qqwing_generate_puzzle ((gint) _tmp1_);
	puzzle = _tmp2_;
	puzzle_length1 = -1;
	_puzzle_size_ = puzzle_length1;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = row;
				_tmp6_ = board;
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint val = 0;
							gint* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp16_ = 0;
							SudokuBoard* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = col;
								col = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = col;
							_tmp12_ = board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp11_ < _tmp14_)) {
								break;
							}
							_tmp15_ = puzzle;
							_tmp15__length1 = puzzle_length1;
							_tmp16_ = row;
							_tmp17_ = board;
							_tmp18_ = sudoku_board_get_cols (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = col;
							_tmp21_ = _tmp15_[(_tmp16_ * _tmp19_) + _tmp20_];
							val = _tmp21_;
							_tmp22_ = val;
							if (_tmp22_ != 0) {
								SudokuBoard* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								_tmp23_ = board;
								_tmp24_ = row;
								_tmp25_ = col;
								_tmp26_ = val;
								sudoku_board_insert (_tmp23_, _tmp24_, _tmp25_, _tmp26_, TRUE);
							}
						}
					}
				}
			}
		}
	}
	_tmp27_ = board;
	_tmp28_ = category;
	sudoku_board_set_difficulty_category (_tmp27_, _tmp28_);
	result = board;
	puzzle = (g_free (puzzle), NULL);
	return result;
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_object_unref), NULL);
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, sudoku_generator_generate_boards_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
	_tmp0_ = nboards;
	_data_->nboards = _tmp0_;
	_tmp1_ = category;
	_data_->category = _tmp1_;
	sudoku_generator_generate_boards_async_co (_data_);
}


SudokuBoard** sudoku_generator_generate_boards_finish (GAsyncResult* _res_, int* result_length1, GError** error) {
	SudokuBoard** result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
	return result;
}


static gpointer _generator_thread_run_gthread_func (gpointer self) {
	gpointer result;
	result = generator_thread_run ((GeneratorThread*) self);
	return result;
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->boards_list = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->nboards;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (SudokuBoard*, _data_->_tmp1_ + 1);
	_data_->boards_length1 = 0;
	_data_->_boards_size_ = 0;
	_data_->boards = _data_->_tmp2_;
	_data_->boards_length1 = _data_->_tmp1_;
	_data_->_boards_size_ = _data_->boards_length1;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = sudoku_generator_get_number_of_processors ();
	_data_->_tmp4_ = 0;
	_data_->_tmp4_ = MAX (1, _data_->_tmp3_ - 1);
	_data_->ncpu_usable = _data_->_tmp4_;
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = _data_->ncpu_usable;
	_data_->_tmp6_ = 0;
	_data_->_tmp6_ = _data_->nboards;
	_data_->_tmp7_ = 0;
	_data_->_tmp7_ = MIN (_data_->_tmp5_, _data_->_tmp6_);
	_data_->nthreads = _data_->_tmp7_;
	_data_->_tmp8_ = 0;
	_data_->_tmp8_ = _data_->nboards;
	_data_->_tmp9_ = 0;
	_data_->_tmp9_ = _data_->nthreads;
	_data_->base_nsudokus_each = _data_->_tmp8_ / _data_->_tmp9_;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->nboards;
	_data_->_tmp11_ = 0;
	_data_->_tmp11_ = _data_->nthreads;
	_data_->remainder = _data_->_tmp10_ % _data_->_tmp11_;
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = _data_->base_nsudokus_each;
	_data_->nsudokus_per_thread = _data_->_tmp12_;
	{
		_data_->i = 0;
		{
			_data_->_tmp13_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp13_) {
					_data_->_tmp14_ = 0;
					_data_->_tmp14_ = _data_->i;
					_data_->i = _data_->_tmp14_ + 1;
				}
				_data_->_tmp13_ = FALSE;
				_data_->_tmp15_ = 0;
				_data_->_tmp15_ = _data_->i;
				_data_->_tmp16_ = 0;
				_data_->_tmp16_ = _data_->nthreads;
				if (!(_data_->_tmp15_ < _data_->_tmp16_)) {
					break;
				}
				_data_->_tmp17_ = 0;
				_data_->_tmp17_ = _data_->i;
				_data_->_tmp18_ = 0;
				_data_->_tmp18_ = _data_->nthreads;
				_data_->_tmp19_ = 0;
				_data_->_tmp19_ = _data_->remainder;
				if (_data_->_tmp17_ > ((_data_->_tmp18_ - _data_->_tmp19_) - 1)) {
					_data_->_tmp20_ = 0;
					_data_->_tmp20_ = _data_->base_nsudokus_each;
					_data_->nsudokus_per_thread = _data_->_tmp20_ + 1;
				}
				_data_->_tmp21_ = 0;
				_data_->_tmp21_ = _data_->nsudokus_per_thread;
				_data_->_tmp22_ = 0;
				_data_->_tmp22_ = _data_->category;
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = generator_thread_new (_data_->_tmp21_, _data_->_tmp22_, &_data_->boards_list, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
				_data_->gen_thread = _data_->_tmp23_;
				_data_->_tmp24_ = 0;
				_data_->_tmp24_ = _data_->i;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->gen_thread;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = g_thread_new ("Generator thread", _generator_thread_run_gthread_func, g_object_ref (_data_->_tmp25_));
				_g_thread_unref0 (_data_->threads[_data_->_tmp24_]);
				_data_->threads[_data_->_tmp24_] = _data_->_tmp26_;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->threads[_data_->_tmp24_];
				_g_object_unref0 (_data_->gen_thread);
			}
		}
	}
	{
		_data_->_vala1_i = 0;
		{
			_data_->_tmp28_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp28_) {
					_data_->_tmp29_ = 0;
					_data_->_tmp29_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp29_ + 1;
				}
				_data_->_tmp28_ = FALSE;
				_data_->_tmp30_ = 0;
				_data_->_tmp30_ = _data_->_vala1_i;
				_data_->_tmp31_ = 0;
				_data_->_tmp31_ = _data_->nthreads;
				if (!(_data_->_tmp30_ < _data_->_tmp31_)) {
					break;
				}
				_data_->_state_ = 1;
				return FALSE;
				_state_1:
				;
				_data_->_tmp32_ = 0;
				_data_->_tmp32_ = _data_->_vala1_i;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = _data_->threads[_data_->_tmp32_];
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _g_thread_ref0 (_data_->_tmp33_);
				g_thread_join (_data_->_tmp34_);
			}
		}
	}
	{
		_data_->_vala2_i = 0;
		{
			_data_->_tmp35_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp35_) {
					_data_->_tmp36_ = 0;
					_data_->_tmp36_ = _data_->_vala2_i;
					_data_->_vala2_i = _data_->_tmp36_ + 1;
				}
				_data_->_tmp35_ = FALSE;
				_data_->_tmp37_ = 0;
				_data_->_tmp37_ = _data_->_vala2_i;
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = _data_->boards_list;
				_data_->_tmp39_ = 0;
				_data_->_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp38_);
				_data_->_tmp40_ = 0;
				_data_->_tmp40_ = _data_->_tmp39_;
				if (!(_data_->_tmp37_ < _data_->_tmp40_)) {
					break;
				}
				_data_->_tmp41_ = NULL;
				_data_->_tmp41__length1 = 0;
				_data_->_tmp41_ = _data_->boards;
				_data_->_tmp41__length1 = _data_->boards_length1;
				_data_->_tmp42_ = 0;
				_data_->_tmp42_ = _data_->_vala2_i;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->boards_list;
				_data_->_tmp44_ = 0;
				_data_->_tmp44_ = _data_->_vala2_i;
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp43_, _data_->_tmp44_);
				_g_object_unref0 (_data_->_tmp41_[_data_->_tmp42_]);
				_data_->_tmp41_[_data_->_tmp42_] = (SudokuBoard*) _data_->_tmp45_;
				_data_->_tmp46_ = NULL;
				_data_->_tmp46_ = _data_->_tmp41_[_data_->_tmp42_];
			}
		}
	}
	_data_->_tmp47_ = NULL;
	_data_->_tmp47__length1 = 0;
	_data_->_tmp47_ = _data_->boards;
	_data_->_tmp47__length1 = _data_->boards_length1;
	_data_->result_length1 = _data_->_tmp47__length1;
	_data_->result = _data_->_tmp47_;
	_vala_array_destroy (_data_->threads, 16, (GDestroyNotify) g_thread_unref);
	_g_object_unref0 (_data_->boards_list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_vala_array_destroy (_data_->threads, 16, (GDestroyNotify) g_thread_unref);
	_data_->boards = (_vala_array_free (_data_->boards, _data_->boards_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->boards_list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint cells_length1 = 0;
	gint cells_length2 = 0;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	g_return_if_fail (board != NULL);
	_tmp0_ = board;
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
	cells = _tmp3_;
	cells_length1 = _tmp1_;
	cells_length2 = _tmp2_;
	_tmp4_ = board;
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = board;
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
	puzzle = _tmp10_;
	puzzle_length1 = _tmp6_ * _tmp9_;
	_puzzle_size_ = puzzle_length1;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = row;
					row = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = row;
				_tmp14_ = board;
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(_tmp13_ < _tmp16_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							if (!_tmp17_) {
								gint _tmp18_ = 0;
								_tmp18_ = col;
								col = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = col;
							_tmp20_ = board;
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(_tmp19_ < _tmp22_)) {
								break;
							}
							_tmp23_ = puzzle;
							_tmp23__length1 = puzzle_length1;
							_tmp24_ = row;
							_tmp25_ = board;
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = col;
							_tmp29_ = cells;
							_tmp29__length1 = cells_length1;
							_tmp29__length2 = cells_length2;
							_tmp30_ = row;
							_tmp31_ = col;
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
						}
					}
				}
			}
		}
	}
	_tmp34_ = puzzle;
	_tmp34__length1 = puzzle_length1;
	qqwing_print_stats (_tmp34_);
	puzzle = (g_free (puzzle), NULL);
	cells = (g_free (cells), NULL);
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = qqwing_get_version ();
	result = _tmp0_;
	return result;
}


static gint sudoku_generator_get_number_of_processors (void) {
	gint result = 0;
	gint ncpu = 0;
	gchar* nproc_stdout = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		g_spawn_command_line_sync ("nproc", &_tmp0_, NULL, NULL, &_inner_error_);
		_g_free0 (nproc_stdout);
		nproc_stdout = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			_g_free0 (nproc_stdout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp1_ = atoi (nproc_stdout);
		ncpu = _tmp1_;
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("sudoku-generator.vala:85: Call to nproc failed. Puzzles will be genera" \
"ted in a single thread");
		ncpu = 1;
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (nproc_stdout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = ncpu;
	_g_free0 (nproc_stdout);
	return result;
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeneratorThread* generator_thread_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target) {
	GeneratorThread * self = NULL;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GSourceFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	g_return_val_if_fail (*boards_list != NULL, NULL);
	self = (GeneratorThread*) g_object_new (object_type, NULL);
	_tmp0_ = nsudokus;
	self->priv->nsudokus = _tmp0_;
	_tmp1_ = level;
	self->priv->level = _tmp1_;
	_tmp2_ = *boards_list;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->boards_list);
	self->priv->boards_list = _tmp3_;
	_tmp4_ = callback;
	_tmp4__target = callback_target;
	self->priv->callback = _tmp4_;
	self->priv->callback_target = _tmp4__target;
	return self;
}


GeneratorThread* generator_thread_new (gint nsudokus, DifficultyCategory level, GeeArrayList** boards_list, GSourceFunc callback, void* callback_target) {
	return generator_thread_construct (TYPE_GENERATOR_THREAD, nsudokus, level, boards_list, callback, callback_target);
}


static gboolean __lambda4_ (GeneratorThread* self) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((GeneratorThread*) self);
	return result;
}


void* generator_thread_run (GeneratorThread* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GeeArrayList* _tmp4_ = NULL;
				DifficultyCategory _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				SudokuBoard* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->nsudokus;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->boards_list;
				_tmp5_ = self->priv->level;
				_tmp6_ = sudoku_generator_generate_board (_tmp5_);
				_tmp7_ = _tmp6_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp7_);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	result = NULL;
	return result;
}


static void generator_thread_class_init (GeneratorThreadClass * klass) {
	generator_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeneratorThreadPrivate));
	G_OBJECT_CLASS (klass)->finalize = generator_thread_finalize;
}


static void generator_thread_instance_init (GeneratorThread * self) {
	self->priv = GENERATOR_THREAD_GET_PRIVATE (self);
}


static void generator_thread_finalize (GObject* obj) {
	GeneratorThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GENERATOR_THREAD, GeneratorThread);
	_g_object_unref0 (self->priv->boards_list);
	G_OBJECT_CLASS (generator_thread_parent_class)->finalize (obj);
}


GType generator_thread_get_type (void) {
	static volatile gsize generator_thread_type_id__volatile = 0;
	if (g_once_init_enter (&generator_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeneratorThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) generator_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeneratorThread), 0, (GInstanceInitFunc) generator_thread_instance_init, NULL };
		GType generator_thread_type_id;
		generator_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "GeneratorThread", &g_define_type_info, 0);
		g_once_init_leave (&generator_thread_type_id__volatile, generator_thread_type_id);
	}
	return generator_thread_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



