/* chess-engine-cecp.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from chess-engine-cecp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;
typedef struct _ChessEngineCECPPrivate ChessEngineCECPPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*do_undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEngineCECP {
	ChessEngine parent_instance;
	ChessEngineCECPPrivate * priv;
};

struct _ChessEngineCECPClass {
	ChessEngineClass parent_class;
};

struct _ChessEngineCECPPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gboolean moving;
	gchar** options;
	gint options_length1;
	gint _options_size_;
};


static gpointer chess_engine_cecp_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_CECP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPPrivate))
enum  {
	CHESS_ENGINE_CECP_DUMMY_PROPERTY
};
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup20 (gchar** self, int length);
static void chess_engine_cecp_start_cb (ChessEngineCECP* self);
static void _chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_cecp_real_process_input (ChessEngine* base, gchar* data, int data_length1);
void chess_engine_stop (ChessEngine* self);
static gchar* _vala_array_dup21 (gchar* self, int length);
static void chess_engine_cecp_real_start_game (ChessEngine* base);
static void chess_engine_cecp_real_request_move (ChessEngine* base);
static void chess_engine_cecp_real_report_move (ChessEngine* base, ChessMove* move);
static void chess_engine_cecp_real_do_undo (ChessEngine* base);
static void chess_engine_cecp_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup20 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _chess_engine_cecp_start_cb_chess_engine_starting (ChessEngine* _sender, gpointer self) {
	chess_engine_cecp_start_cb ((ChessEngineCECP*) self);
}


ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1) {
	ChessEngineCECP * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint _tmp2_ = 0U;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (binary != NULL, NULL);
	_tmp0_ = binary;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = delay_seconds;
	self = (ChessEngineCECP*) chess_engine_construct (object_type, _tmp0_, _tmp1_, _tmp1__length1, _tmp2_);
	_tmp3_ = options;
	_tmp3__length1 = options_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup20 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp4_;
	self->priv->options_length1 = _tmp4__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_cecp_start_cb_chess_engine_starting, self, 0);
	return self;
}


ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1) {
	return chess_engine_cecp_construct (TYPE_CHESS_ENGINE_CECP, binary, args, args_length1, delay_seconds, options, options_length1);
}


static void chess_engine_cecp_start_cb (ChessEngineCECP* self) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "xboard");
	chess_engine_write_line ((ChessEngine*) self, "random");
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < _tmp0__length1; o_it = o_it + 1) {
			gchar* _tmp1_ = NULL;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				const gchar* _tmp2_ = NULL;
				_tmp2_ = o;
				chess_engine_write_line ((ChessEngine*) self, _tmp2_);
				_g_free0 (o);
			}
		}
	}
	chess_engine_set_ready ((ChessEngine*) self, TRUE);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* _vala_array_dup21 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static void chess_engine_cecp_real_process_input (ChessEngine* base, gchar* data, int data_length1) {
	ChessEngineCECP * self;
	gint current = 0;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	self = (ChessEngineCECP*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = (gint) (_tmp1__length1 + _tmp2__length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + _tmp2__length1));
	(_tmp3_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp3_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp3_;
	self->priv->_buffer_size_ = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gchar* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gchar* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gchar _tmp14_ = '\0';
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = data;
				_tmp7__length1 = data_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->buffer;
				_tmp8__length1 = self->priv->buffer_length1;
				_tmp9_ = current;
				_tmp10_ = i;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp8_[_tmp9_ + _tmp10_] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_ + _tmp10_];
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		gchar _tmp27_ = '\0';
		gchar* line = NULL;
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar** move_prefixes = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gint move_prefixes_length1 = 0;
		gint _move_prefixes_size_ = 0;
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp55_ = FALSE;
		const gchar* _tmp56_ = NULL;
		gchar* _tmp84_ = NULL;
		gint _tmp84__length1 = 0;
		gint _tmp85_ = 0;
		gchar* _tmp86_ = NULL;
		gint _tmp86__length1 = 0;
		gchar* _tmp87_ = NULL;
		gint _tmp87__length1 = 0;
		{
			gboolean _tmp15_ = FALSE;
			offset = 0;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_ = FALSE;
				gint _tmp18_ = 0;
				gchar* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = offset;
					offset = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = offset;
				_tmp19_ = self->priv->buffer;
				_tmp19__length1 = self->priv->buffer_length1;
				if (_tmp18_ < _tmp19__length1) {
					gchar* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					gchar _tmp22_ = '\0';
					_tmp20_ = self->priv->buffer;
					_tmp20__length1 = self->priv->buffer_length1;
					_tmp21_ = offset;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp17_ = _tmp22_ != '\n';
				} else {
					_tmp17_ = FALSE;
				}
				if (!_tmp17_) {
					break;
				}
			}
		}
		_tmp23_ = offset;
		_tmp24_ = self->priv->buffer;
		_tmp24__length1 = self->priv->buffer_length1;
		if (_tmp23_ >= _tmp24__length1) {
			return;
		}
		_tmp25_ = self->priv->buffer;
		_tmp25__length1 = self->priv->buffer_length1;
		_tmp26_ = offset;
		_tmp25_[_tmp26_] = '\0';
		_tmp27_ = _tmp25_[_tmp26_];
		_tmp28_ = self->priv->buffer;
		_tmp28__length1 = self->priv->buffer_length1;
		_tmp29_ = g_strdup ((const gchar*) _tmp28_);
		line = _tmp29_;
		_tmp30_ = line;
		g_debug ("chess-engine-cecp.vala:55: Read from engine: '%s'", _tmp30_);
		_tmp31_ = g_strdup ("My move is: ");
		_tmp32_ = g_strdup ("My move is : ");
		_tmp33_ = g_strdup ("my move is ");
		_tmp34_ = g_strdup ("move ");
		_tmp35_ = g_new0 (gchar*, 4 + 1);
		_tmp35_[0] = _tmp31_;
		_tmp35_[1] = _tmp32_;
		_tmp35_[2] = _tmp33_;
		_tmp35_[3] = _tmp34_;
		move_prefixes = _tmp35_;
		move_prefixes_length1 = 4;
		_move_prefixes_size_ = move_prefixes_length1;
		_tmp36_ = move_prefixes;
		_tmp36__length1 = move_prefixes_length1;
		{
			gchar** prefix_collection = NULL;
			gint prefix_collection_length1 = 0;
			gint _prefix_collection_size_ = 0;
			gint prefix_it = 0;
			prefix_collection = _tmp36_;
			prefix_collection_length1 = _tmp36__length1;
			for (prefix_it = 0; prefix_it < _tmp36__length1; prefix_it = prefix_it + 1) {
				gchar* _tmp37_ = NULL;
				gchar* prefix = NULL;
				_tmp37_ = g_strdup (prefix_collection[prefix_it]);
				prefix = _tmp37_;
				{
					const gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					_tmp38_ = line;
					_tmp39_ = prefix;
					_tmp40_ = g_str_has_prefix (_tmp38_, _tmp39_);
					if (_tmp40_) {
						gchar* move = NULL;
						const gchar* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						gint _tmp43_ = 0;
						gint _tmp44_ = 0;
						const gchar* _tmp45_ = NULL;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						gchar* _tmp48_ = NULL;
						const gchar* _tmp49_ = NULL;
						const gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_ = NULL;
						_tmp41_ = line;
						_tmp42_ = prefix;
						_tmp43_ = strlen (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = line;
						_tmp46_ = strlen (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = string_slice (_tmp41_, (glong) _tmp44_, (glong) _tmp47_);
						move = _tmp48_;
						_tmp49_ = move;
						g_debug ("chess-engine-cecp.vala:63: Engine moves %s", _tmp49_);
						self->priv->moving = TRUE;
						_tmp50_ = move;
						_tmp51_ = string_strip (_tmp50_);
						_tmp52_ = _tmp51_;
						g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp52_);
						_g_free0 (_tmp52_);
						_g_free0 (move);
					}
					_g_free0 (prefix);
				}
			}
		}
		_tmp56_ = line;
		if (g_strcmp0 (_tmp56_, "resign") == 0) {
			_tmp55_ = TRUE;
		} else {
			const gchar* _tmp57_ = NULL;
			_tmp57_ = line;
			_tmp55_ = g_strcmp0 (_tmp57_, "tellics resign") == 0;
		}
		if (_tmp55_) {
			_tmp54_ = TRUE;
		} else {
			gboolean _tmp58_ = FALSE;
			const gchar* _tmp59_ = NULL;
			gboolean _tmp60_ = FALSE;
			_tmp59_ = line;
			_tmp60_ = g_str_has_prefix (_tmp59_, "1-0 {");
			if (_tmp60_) {
				const gchar* _tmp61_ = NULL;
				gboolean _tmp62_ = FALSE;
				_tmp61_ = line;
				_tmp62_ = string_contains (_tmp61_, "resign");
				_tmp58_ = _tmp62_;
			} else {
				_tmp58_ = FALSE;
			}
			_tmp54_ = _tmp58_;
		}
		if (_tmp54_) {
			_tmp53_ = TRUE;
		} else {
			gboolean _tmp63_ = FALSE;
			const gchar* _tmp64_ = NULL;
			gboolean _tmp65_ = FALSE;
			_tmp64_ = line;
			_tmp65_ = g_str_has_prefix (_tmp64_, "0-1 {");
			if (_tmp65_) {
				const gchar* _tmp66_ = NULL;
				gboolean _tmp67_ = FALSE;
				_tmp66_ = line;
				_tmp67_ = string_contains (_tmp66_, "resign");
				_tmp63_ = _tmp67_;
			} else {
				_tmp63_ = FALSE;
			}
			_tmp53_ = _tmp63_;
		}
		if (_tmp53_) {
			g_signal_emit_by_name ((ChessEngine*) self, "resigned");
		} else {
			const gchar* _tmp68_ = NULL;
			gboolean _tmp69_ = FALSE;
			_tmp68_ = line;
			_tmp69_ = g_str_has_prefix (_tmp68_, "Illegal move: ");
			if (_tmp69_) {
				chess_engine_stop ((ChessEngine*) self);
				g_signal_emit_by_name ((ChessEngine*) self, "error");
			} else {
				gboolean _tmp70_ = FALSE;
				const gchar* _tmp71_ = NULL;
				gboolean _tmp72_ = FALSE;
				_tmp71_ = line;
				_tmp72_ = g_str_has_prefix (_tmp71_, "1-0");
				if (_tmp72_) {
					_tmp70_ = TRUE;
				} else {
					const gchar* _tmp73_ = NULL;
					gboolean _tmp74_ = FALSE;
					_tmp73_ = line;
					_tmp74_ = g_str_has_prefix (_tmp73_, "0-1");
					_tmp70_ = _tmp74_;
				}
				if (_tmp70_) {
					chess_engine_stop ((ChessEngine*) self);
				} else {
					gboolean _tmp75_ = FALSE;
					gboolean _tmp76_ = FALSE;
					gboolean _tmp77_ = FALSE;
					const gchar* _tmp78_ = NULL;
					_tmp78_ = line;
					if (g_strcmp0 (_tmp78_, "game is a draw") == 0) {
						_tmp77_ = TRUE;
					} else {
						const gchar* _tmp79_ = NULL;
						_tmp79_ = line;
						_tmp77_ = g_strcmp0 (_tmp79_, "draw") == 0;
					}
					if (_tmp77_) {
						_tmp76_ = TRUE;
					} else {
						const gchar* _tmp80_ = NULL;
						_tmp80_ = line;
						_tmp76_ = g_strcmp0 (_tmp80_, "Draw") == 0;
					}
					if (_tmp76_) {
						_tmp75_ = TRUE;
					} else {
						const gchar* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						_tmp81_ = line;
						_tmp82_ = g_str_has_prefix (_tmp81_, "1/2-1/2");
						_tmp75_ = _tmp82_;
					}
					if (_tmp75_) {
						g_signal_emit_by_name ((ChessEngine*) self, "claim-draw");
					} else {
						const gchar* _tmp83_ = NULL;
						_tmp83_ = line;
						if (g_strcmp0 (_tmp83_, "offer draw") == 0) {
							g_signal_emit_by_name ((ChessEngine*) self, "offer-draw");
						}
					}
				}
			}
		}
		_tmp84_ = self->priv->buffer;
		_tmp84__length1 = self->priv->buffer_length1;
		_tmp85_ = offset;
		_tmp86_ = self->priv->buffer;
		_tmp86__length1 = self->priv->buffer_length1;
		_tmp87_ = ((_tmp84_ + (_tmp85_ + 1)) != NULL) ? _vala_array_dup21 (_tmp84_ + (_tmp85_ + 1), _tmp86__length1 - (_tmp85_ + 1)) : ((gpointer) (_tmp84_ + (_tmp85_ + 1)));
		_tmp87__length1 = _tmp86__length1 - (_tmp85_ + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp87_;
		self->priv->buffer_length1 = _tmp87__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		move_prefixes = (_vala_array_free (move_prefixes, move_prefixes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}


static void chess_engine_cecp_real_start_game (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
}


static void chess_engine_cecp_real_request_move (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "go");
}


static void chess_engine_cecp_real_report_move (ChessEngine* base, ChessMove* move) {
	ChessEngineCECP * self;
	gboolean _tmp0_ = FALSE;
	self = (ChessEngineCECP*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->moving;
	if (!_tmp0_) {
		ChessMove* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		chess_engine_write_line ((ChessEngine*) self, "force");
		_tmp1_ = move;
		_tmp2_ = chess_move_get_engine (_tmp1_);
		_tmp3_ = _tmp2_;
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	self->priv->moving = FALSE;
}


static void chess_engine_cecp_real_do_undo (ChessEngine* base) {
	ChessEngineCECP * self;
	self = (ChessEngineCECP*) base;
	chess_engine_write_line ((ChessEngine*) self, "force");
	chess_engine_write_line ((ChessEngine*) self, "undo");
}


static void chess_engine_cecp_class_init (ChessEngineCECPClass * klass) {
	chess_engine_cecp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEngineCECPPrivate));
	((ChessEngineClass *) klass)->process_input = chess_engine_cecp_real_process_input;
	((ChessEngineClass *) klass)->start_game = chess_engine_cecp_real_start_game;
	((ChessEngineClass *) klass)->request_move = chess_engine_cecp_real_request_move;
	((ChessEngineClass *) klass)->report_move = chess_engine_cecp_real_report_move;
	((ChessEngineClass *) klass)->do_undo = chess_engine_cecp_real_do_undo;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_cecp_finalize;
}


static void chess_engine_cecp_instance_init (ChessEngineCECP * self) {
	self->priv = CHESS_ENGINE_CECP_GET_PRIVATE (self);
	self->priv->moving = FALSE;
}


static void chess_engine_cecp_finalize (GObject* obj) {
	ChessEngineCECP * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_CECP, ChessEngineCECP);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (chess_engine_cecp_parent_class)->finalize (obj);
}


GType chess_engine_cecp_get_type (void) {
	static volatile gsize chess_engine_cecp_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_cecp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineCECPClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_cecp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineCECP), 0, (GInstanceInitFunc) chess_engine_cecp_instance_init, NULL };
		GType chess_engine_cecp_type_id;
		chess_engine_cecp_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineCECP", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_cecp_type_id__volatile, chess_engine_cecp_type_id);
	}
	return chess_engine_cecp_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



