/* libsudoku.h generated by valac 0.23.3.24-5b8db, the Vala compiler, do not modify */


#ifndef __LIBSUDOKU_H__
#define __LIBSUDOKU_H__

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define SUDOKU_GENERATOR_TYPE_RATED_SUDOKU (sudoku_generator_rated_sudoku_get_type ())

#define TYPE_DIFFICULTY_RATING (difficulty_rating_get_type ())
#define DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIFFICULTY_RATING, DifficultyRating))
#define DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))
#define IS_DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIFFICULTY_RATING))
#define IS_DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIFFICULTY_RATING))
#define DIFFICULTY_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))

typedef struct _DifficultyRating DifficultyRating;
typedef struct _DifficultyRatingClass DifficultyRatingClass;
typedef struct _SudokuGeneratorRatedSudoku SudokuGeneratorRatedSudoku;

#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;

#define TYPE_SUDOKU_SOLVER (sudoku_solver_get_type ())
#define SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SOLVER, SudokuSolver))
#define SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SOLVER, SudokuSolverClass))
#define IS_SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SOLVER))
#define IS_SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SOLVER))
#define SUDOKU_SOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SOLVER, SudokuSolverClass))

typedef struct _SudokuSolver SudokuSolver;
typedef struct _SudokuSolverClass SudokuSolverClass;
typedef struct _SudokuSolverPrivate SudokuSolverPrivate;

#define TYPE_GUESS_LIST (guess_list_get_type ())
#define GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS_LIST, GuessList))
#define GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS_LIST, GuessListClass))
#define IS_GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS_LIST))
#define IS_GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS_LIST))
#define GUESS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS_LIST, GuessListClass))

typedef struct _GuessList GuessList;
typedef struct _GuessListClass GuessListClass;

#define TYPE_BREADCRUMB_TRAIL (breadcrumb_trail_get_type ())
#define BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrail))
#define BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))
#define IS_BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BREADCRUMB_TRAIL))
#define IS_BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BREADCRUMB_TRAIL))
#define BREADCRUMB_TRAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))

typedef struct _BreadcrumbTrail BreadcrumbTrail;
typedef struct _BreadcrumbTrailClass BreadcrumbTrailClass;

#define SUDOKU_SOLVER_TYPE_ITERATOR (sudoku_solver_iterator_get_type ())
#define SUDOKU_SOLVER_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIterator))
#define SUDOKU_SOLVER_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))
#define SUDOKU_SOLVER_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_SOLVER_TYPE_ITERATOR))
#define SUDOKU_SOLVER_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_SOLVER_TYPE_ITERATOR, SudokuSolverIteratorClass))

typedef struct _SudokuSolverIterator SudokuSolverIterator;
typedef struct _SudokuSolverIteratorClass SudokuSolverIteratorClass;
typedef struct _SudokuSolverIteratorPrivate SudokuSolverIteratorPrivate;

#define TYPE_SUDOKU_RATER (sudoku_rater_get_type ())
#define SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_RATER, SudokuRater))
#define SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_RATER, SudokuRaterClass))
#define IS_SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_RATER))
#define IS_SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_RATER))
#define SUDOKU_RATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_RATER, SudokuRaterClass))

typedef struct _SudokuRater SudokuRater;
typedef struct _SudokuRaterClass SudokuRaterClass;
typedef struct _SudokuRaterPrivate SudokuRaterPrivate;

#define TYPE_GUESS (guess_get_type ())
#define GUESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS, Guess))
#define GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS, GuessClass))
#define IS_GUESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS))
#define IS_GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS))
#define GUESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS, GuessClass))

typedef struct _Guess Guess;
typedef struct _GuessClass GuessClass;
typedef struct _GuessPrivate GuessPrivate;
typedef struct _GuessListPrivate GuessListPrivate;
typedef struct _BreadcrumbTrailPrivate BreadcrumbTrailPrivate;

#define TYPE_PARALLEL_DICT (parallel_dict_get_type ())
#define PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARALLEL_DICT, ParallelDict))
#define PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARALLEL_DICT, ParallelDictClass))
#define IS_PARALLEL_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARALLEL_DICT))
#define IS_PARALLEL_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARALLEL_DICT))
#define PARALLEL_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARALLEL_DICT, ParallelDictClass))

typedef struct _ParallelDict ParallelDict;
typedef struct _ParallelDictClass ParallelDictClass;
typedef struct _ParallelDictPrivate ParallelDictPrivate;
typedef struct _DifficultyRatingPrivate DifficultyRatingPrivate;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gdouble difficulty_rating;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
	gint clues;
	SudokuBoard* start_board;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorRatedSudoku {
	SudokuBoard* board;
	DifficultyRating* diff;
};

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

typedef enum  {
	SUDOKU_ERROR_UNSOLVABLE_PUZZLE,
	SUDOKU_ERROR_CONFLICT_ERROR,
	SUDOKU_ERROR_ALREADY_SET_ERROR
} SudokuError;
#define SUDOKU_ERROR sudoku_error_quark ()
struct _SudokuSolver {
	GObject parent_instance;
	SudokuSolverPrivate * priv;
	SudokuBoard* board;
	GuessList* guesses;
	BreadcrumbTrail* breadcrumbs;
	gint backtraces;
	gboolean solved;
};

struct _SudokuSolverClass {
	GObjectClass parent_class;
	gboolean (*guess_least_open_square) (SudokuSolver* self, GError** error);
	void (*insert) (SudokuSolver* self, gint row, gint col, gint val);
};

struct _SudokuSolverIterator {
	GObject parent_instance;
	SudokuSolverIteratorPrivate * priv;
};

struct _SudokuSolverIteratorClass {
	GObjectClass parent_class;
};

struct _SudokuRater {
	SudokuSolver parent_instance;
	SudokuRaterPrivate * priv;
};

struct _SudokuRaterClass {
	SudokuSolverClass parent_class;
};

struct _Guess {
	GObject parent_instance;
	GuessPrivate * priv;
	GeeArrayList* children;
	GeeHashMap* consequences;
};

struct _GuessClass {
	GObjectClass parent_class;
};

struct _GuessList {
	GeeArrayList parent_instance;
	GuessListPrivate * priv;
};

struct _GuessListClass {
	GeeArrayListClass parent_class;
};

struct _BreadcrumbTrail {
	GuessList parent_instance;
	BreadcrumbTrailPrivate * priv;
};

struct _BreadcrumbTrailClass {
	GuessListClass parent_class;
};

struct _ParallelDict {
	GObject parent_instance;
	ParallelDictPrivate * priv;
};

struct _ParallelDictClass {
	GObjectClass parent_class;
};

struct _DifficultyRating {
	GObject parent_instance;
	DifficultyRatingPrivate * priv;
	gfloat rating;
};

struct _DifficultyRatingClass {
	GObjectClass parent_class;
};


GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
void sudoku_board_set_from_string (SudokuBoard* self, const gchar* s, const gchar* delimiter, const gchar* empty_value, const gchar* rating_delimiter);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gboolean sudoku_board_get_complete (SudokuBoard* self);
GType house_get_type (void) G_GNUC_CONST;
void coord_init (Coord *self, gint row, gint col);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
GType sudoku_game_get_type (void) G_GNUC_CONST;
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_game_undo (SudokuGame* self);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gchar* sudoku_game_seconds_to_hms_string (gdouble time_in_seconds);
GType sudoku_generator_get_type (void) G_GNUC_CONST;
SudokuGenerator* sudoku_generator_new (void);
SudokuGenerator* sudoku_generator_construct (GType object_type);
void sudoku_generator_gen_stats (void);
SudokuBoard* sudoku_generator_generate (SudokuGenerator* self, gfloat* difficulty_range, int difficulty_range_length1, gboolean symmetric);
SudokuBoard* sudoku_generator_make_symmetric_puzzle (SudokuGenerator* self, gint line);
SudokuBoard* sudoku_generator_make_puzzle_by_boxes (SudokuGenerator* self, gfloat skew_by);
GType sudoku_generator_rated_sudoku_get_type (void) G_GNUC_CONST;
GType difficulty_rating_get_type (void) G_GNUC_CONST;
SudokuGeneratorRatedSudoku* sudoku_generator_rated_sudoku_dup (const SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_free (SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_copy (const SudokuGeneratorRatedSudoku* self, SudokuGeneratorRatedSudoku* dest);
void sudoku_generator_rated_sudoku_destroy (SudokuGeneratorRatedSudoku* self);
SudokuGeneratorRatedSudoku* sudoku_generator_make_unique_puzzle (SudokuGenerator* self, gint line, gboolean strict_number_of_clues);
void sudoku_generator_rated_sudoku_init (SudokuGeneratorRatedSudoku *self, SudokuBoard* board, DifficultyRating* diff);
GType sudoku_saver_get_type (void) G_GNUC_CONST;
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
void sudoku_saver_save_game (SudokuSaver* self, SudokuGame* game);
void sudoku_saver_add_game_to_finished (SudokuSaver* self, SudokuGame* game, gboolean delete_savegame);
const gchar* sudoku_saver_get_savegame_file (void);
const gchar* sudoku_saver_get_finishgame_dir (void);
GQuark sudoku_error_quark (void);
GType sudoku_solver_get_type (void) G_GNUC_CONST;
GType guess_list_get_type (void) G_GNUC_CONST;
GType breadcrumb_trail_get_type (void) G_GNUC_CONST;
SudokuSolver* sudoku_solver_new (SudokuBoard** board);
SudokuSolver* sudoku_solver_construct (GType object_type, SudokuBoard** board);
gboolean sudoku_solver_quick_has_solution (SudokuSolver* self);
gboolean sudoku_solver_quick_has_unique_solution (SudokuSolver* self);
gboolean sudoku_solver_quick_has_many_solution (SudokuSolver* self);
gint sudoku_solver_quick_count_solutions (SudokuSolver* self, gint break_at);
GType sudoku_solver_iterator_get_type (void) G_GNUC_CONST;
SudokuSolverIterator* sudoku_solver_iterator (SudokuSolver* self);
gboolean sudoku_solver_has_unique_solution (SudokuSolver* self);
SudokuBoard* sudoku_solver_solve (SudokuSolver* self);
GeeArrayList* sudoku_solver_fill_deterministically (SudokuSolver* self);
GeeArrayList* sudoku_solver_fill_must_fills (SudokuSolver* self, GError** error);
gboolean sudoku_solver_guess_least_open_square (SudokuSolver* self, GError** error);
void sudoku_solver_insert (SudokuSolver* self, gint row, gint col, gint val);
SudokuSolverIterator* sudoku_solver_iterator_new (SudokuSolver* solver);
SudokuSolverIterator* sudoku_solver_iterator_construct (GType object_type, SudokuSolver* solver);
gboolean sudoku_solver_iterator_next (SudokuSolverIterator* self);
SudokuBoard* sudoku_solver_iterator_get (SudokuSolverIterator* self);
GType sudoku_rater_get_type (void) G_GNUC_CONST;
SudokuRater* sudoku_rater_new (SudokuBoard** board);
SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board);
DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self);
GType guess_get_type (void) G_GNUC_CONST;
Guess* guess_new (gint row, gint col, gint val);
Guess* guess_construct (GType object_type, gint row, gint col, gint val);
void guess_add_consequence (Guess* self, gint row, gint col, gint val);
gint guess_get_row (Guess* self);
gint guess_get_col (Guess* self);
gint guess_get_val (Guess* self);
Guess** guess_list_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
Guess** guess_list_remove_children (GuessList* self, Guess* guess, int* result_length1);
Guess** guess_list_remove_guesses_for (GuessList* self, gint row, gint col, int* result_length1);
GuessList* guess_list_new (void);
GuessList* guess_list_construct (GType object_type);
void breadcrumb_trail_append (BreadcrumbTrail* self, Guess* guess);
BreadcrumbTrail* breadcrumb_trail_new (void);
BreadcrumbTrail* breadcrumb_trail_construct (GType object_type);
GType parallel_dict_get_type (void) G_GNUC_CONST;
void parallel_dict_set (ParallelDict* self, Coord* k, GeeHashSet* v);
void parallel_dict_unset (ParallelDict* self, Coord* k);
gboolean parallel_dict_contains (ParallelDict* self, Coord* key);
ParallelDict* parallel_dict_new (void);
ParallelDict* parallel_dict_construct (GType object_type);
gchar* difficulty_category_to_string (DifficultyCategory self);
DifficultyRating* difficulty_rating_new (GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
DifficultyRating* difficulty_rating_construct (GType object_type, GeeHashMap* fill_must_fillables, GeeHashMap* elimination_fillables, GuessList* guesses, gint backtraces, gint squares_filled);
gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1);
DifficultyCategory difficulty_rating_get_category (DifficultyRating* self);
gchar* difficulty_rating_to_string (DifficultyRating* self);

extern const gfloat DIFFICULTY_RATING_VERY_HARD_RANGE[2];
extern const gfloat DIFFICULTY_RATING_HARD_RANGE[2];
extern const gfloat DIFFICULTY_RATING_MEDIUM_RANGE[2];
extern const gfloat DIFFICULTY_RATING_EASY_RANGE[2];

G_END_DECLS

#endif
