/* puzzle.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from puzzle.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*
  1   2   4

  8   *   16

  32  64  128
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
typedef struct _PuzzlePrivate PuzzlePrivate;
typedef struct _ParamSpecPuzzle ParamSpecPuzzle;

struct _Puzzle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GTypeClass parent_class;
	void (*finalize) (Puzzle *self);
};

struct _ParamSpecPuzzle {
	GParamSpec parent_instance;
};


static gpointer puzzle_parent_class = NULL;

gpointer puzzle_ref (gpointer instance);
void puzzle_unref (gpointer instance);
GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_puzzle (GValue* value, gpointer v_object);
void value_take_puzzle (GValue* value, gpointer v_object);
gpointer value_get_puzzle (const GValue* value);
GType puzzle_get_type (void) G_GNUC_CONST;
enum  {
	PUZZLE_DUMMY_PROPERTY
};
Puzzle* puzzle_new (gint width, gint height, const gchar* data);
Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data);
static gchar* _vala_array_dup1 (gchar* self, int length);
static gchar* _vala_array_dup2 (gchar* self, int length);
static void puzzle_set_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y, gchar id);
static gchar* _vala_array_dup3 (gchar* self, int length);
static gchar* _vala_array_dup4 (gchar* self, int length);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
gboolean puzzle_game_over (Puzzle* self);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static gboolean puzzle_check_valid_move (Puzzle* self, gint id, gint dx, gint dy);
static gboolean puzzle_do_move_piece (Puzzle* self, gchar id, gint dx, gint dy);
static gchar* _vala_array_dup5 (gchar* self, int length);
static gchar* _vala_array_dup6 (gchar* self, int length);
static void puzzle_finalize (Puzzle* obj);

const gint image_map[110] = {0, 0, 64, 1, 66, 2, 2, 3, 16, 4, 24, 5, 8, 6, 208, 7, 248, 8, 104, 9, 214, 10, 255, 11, 107, 12, 22, 13, 31, 14, 11, 15, 18, 16, 10, 17, 80, 18, 72, 19, 56, 5, 152, 5, 70, 2, 67, 2, 194, 2, 98, 2, 9, 6, 20, 4, 144, 4, 3, 3, 40, 6, 25, 5, 28, 5, 96, 1, 19, 16, 201, 19, 146, 16, 198, 2, 84, 18, 46, 17, 112, 18, 6, 3, 184, 5, 192, 1, 147, 16, 73, 19, 42, 17, 200, 19, 99, 2, 116, 18, 29, 5, 14, 17, 26, 25, 224, 1, -1, -1};

static gchar* _vala_array_dup1 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar* _vala_array_dup2 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* _vala_array_dup3 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar* _vala_array_dup4 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


Puzzle* puzzle_construct (GType object_type, gint width, gint height, const gchar* data) {
	Puzzle* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gchar* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gchar* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	self = (Puzzle*) g_type_create_instance (object_type);
	_tmp0_ = width;
	self->width = _tmp0_;
	_tmp1_ = height;
	self->height = _tmp1_;
	_tmp2_ = width;
	_tmp3_ = height;
	_tmp4_ = g_new0 (gchar, (_tmp2_ + 2) * (_tmp3_ + 2));
	self->map = (g_free (self->map), NULL);
	self->map = _tmp4_;
	self->map_length1 = (_tmp2_ + 2) * (_tmp3_ + 2);
	_tmp5_ = self->map;
	_tmp5__length1 = self->map_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->move_map = (g_free (self->move_map), NULL);
	self->move_map = _tmp6_;
	self->move_map_length1 = _tmp6__length1;
	_tmp7_ = self->map;
	_tmp7__length1 = self->map_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup2 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	self->undomove_map = (g_free (self->undomove_map), NULL);
	self->undomove_map = _tmp8_;
	self->undomove_map_length1 = _tmp8__length1;
	_tmp9_ = data;
	if (_tmp9_ != NULL) {
		gint i = 0;
		i = 0;
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					if (!_tmp10_) {
						gint _tmp11_ = 0;
						_tmp11_ = y;
						y = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = y;
					_tmp13_ = height;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp14_ = FALSE;
							_tmp14_ = TRUE;
							while (TRUE) {
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								const gchar* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gchar _tmp23_ = '\0';
								gint _tmp24_ = 0;
								if (!_tmp14_) {
									gint _tmp15_ = 0;
									_tmp15_ = x;
									x = _tmp15_ + 1;
								}
								_tmp14_ = FALSE;
								_tmp16_ = x;
								_tmp17_ = width;
								if (!(_tmp16_ < _tmp17_)) {
									break;
								}
								_tmp18_ = self->map;
								_tmp18__length1 = self->map_length1;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = data;
								_tmp22_ = i;
								_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
								puzzle_set_piece_id (self, _tmp18_, _tmp18__length1, _tmp19_, _tmp20_, _tmp23_);
								_tmp24_ = i;
								i = _tmp24_ + 1;
							}
						}
					}
				}
			}
		}
	}
	_tmp25_ = self->map;
	_tmp25__length1 = self->map_length1;
	_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup3 (_tmp25_, _tmp25__length1) : ((gpointer) _tmp25_);
	_tmp26__length1 = _tmp25__length1;
	self->orig_map = (g_free (self->orig_map), NULL);
	self->orig_map = _tmp26_;
	self->orig_map_length1 = _tmp26__length1;
	_tmp27_ = self->map;
	_tmp27__length1 = self->map_length1;
	_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup4 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
	_tmp28__length1 = _tmp27__length1;
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->lastmove_map = _tmp28_;
	self->lastmove_map_length1 = _tmp28__length1;
	return self;
}


Puzzle* puzzle_new (gint width, gint height, const gchar* data) {
	return puzzle_construct (TYPE_PUZZLE, width, height, data);
}


gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y) {
	gchar result = '\0';
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar _tmp4_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = src;
	_tmp0__length1 = src_length1;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = self->width;
	_tmp4_ = _tmp0_[(_tmp1_ + 1) + ((_tmp2_ + 1) * (_tmp3_ + 2))];
	result = _tmp4_;
	return result;
}


static void puzzle_set_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y, gchar id) {
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar _tmp4_ = '\0';
	gchar _tmp5_ = '\0';
	g_return_if_fail (self != NULL);
	_tmp0_ = src;
	_tmp0__length1 = src_length1;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = self->width;
	_tmp4_ = id;
	_tmp0_[(_tmp1_ + 1) + ((_tmp2_ + 1) * (_tmp3_ + 2))] = _tmp4_;
	_tmp5_ = _tmp0_[(_tmp1_ + 1) + ((_tmp2_ + 1) * (_tmp3_ + 2))];
}


gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar c = '\0';
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar _tmp6_ = '\0';
	gchar _tmp7_ = '\0';
	gchar _tmp8_ = '\0';
	gchar _tmp9_ = '\0';
	gint nr = 0;
	gchar* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gchar _tmp14_ = '\0';
	gchar _tmp15_ = '\0';
	gchar* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gchar _tmp21_ = '\0';
	gchar _tmp22_ = '\0';
	gchar* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gchar _tmp28_ = '\0';
	gchar _tmp29_ = '\0';
	gchar* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gchar _tmp35_ = '\0';
	gchar _tmp36_ = '\0';
	gchar* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gchar _tmp42_ = '\0';
	gchar _tmp43_ = '\0';
	gchar* _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gchar _tmp49_ = '\0';
	gchar _tmp50_ = '\0';
	gchar* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gchar _tmp56_ = '\0';
	gchar _tmp57_ = '\0';
	gchar* _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gchar _tmp63_ = '\0';
	gchar _tmp64_ = '\0';
	gint i = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	x = _tmp0_ + 1;
	_tmp1_ = y;
	y = _tmp1_ + 1;
	_tmp2_ = self->map;
	_tmp2__length1 = self->map_length1;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = self->width;
	_tmp6_ = _tmp2_[_tmp3_ + (_tmp4_ * (_tmp5_ + 2))];
	c = _tmp6_;
	_tmp7_ = c;
	if (_tmp7_ == '-') {
		result = 23;
		return result;
	}
	_tmp8_ = c;
	if (_tmp8_ == ' ') {
		result = 21;
		return result;
	}
	_tmp9_ = c;
	if (_tmp9_ == '.') {
		result = 20;
		return result;
	}
	nr = 0;
	_tmp10_ = self->map;
	_tmp10__length1 = self->map_length1;
	_tmp11_ = x;
	_tmp12_ = y;
	_tmp13_ = self->width;
	_tmp14_ = _tmp10_[(_tmp11_ - 1) + ((_tmp12_ - 1) * (_tmp13_ + 2))];
	_tmp15_ = c;
	if (_tmp14_ == _tmp15_) {
		gint _tmp16_ = 0;
		_tmp16_ = nr;
		nr = _tmp16_ + 1;
	}
	_tmp17_ = self->map;
	_tmp17__length1 = self->map_length1;
	_tmp18_ = x;
	_tmp19_ = y;
	_tmp20_ = self->width;
	_tmp21_ = _tmp17_[(_tmp18_ - 0) + ((_tmp19_ - 1) * (_tmp20_ + 2))];
	_tmp22_ = c;
	if (_tmp21_ == _tmp22_) {
		gint _tmp23_ = 0;
		_tmp23_ = nr;
		nr = _tmp23_ + 2;
	}
	_tmp24_ = self->map;
	_tmp24__length1 = self->map_length1;
	_tmp25_ = x;
	_tmp26_ = y;
	_tmp27_ = self->width;
	_tmp28_ = _tmp24_[(_tmp25_ + 1) + ((_tmp26_ - 1) * (_tmp27_ + 2))];
	_tmp29_ = c;
	if (_tmp28_ == _tmp29_) {
		gint _tmp30_ = 0;
		_tmp30_ = nr;
		nr = _tmp30_ + 4;
	}
	_tmp31_ = self->map;
	_tmp31__length1 = self->map_length1;
	_tmp32_ = x;
	_tmp33_ = y;
	_tmp34_ = self->width;
	_tmp35_ = _tmp31_[(_tmp32_ - 1) + ((_tmp33_ - 0) * (_tmp34_ + 2))];
	_tmp36_ = c;
	if (_tmp35_ == _tmp36_) {
		gint _tmp37_ = 0;
		_tmp37_ = nr;
		nr = _tmp37_ + 8;
	}
	_tmp38_ = self->map;
	_tmp38__length1 = self->map_length1;
	_tmp39_ = x;
	_tmp40_ = y;
	_tmp41_ = self->width;
	_tmp42_ = _tmp38_[(_tmp39_ + 1) + ((_tmp40_ - 0) * (_tmp41_ + 2))];
	_tmp43_ = c;
	if (_tmp42_ == _tmp43_) {
		gint _tmp44_ = 0;
		_tmp44_ = nr;
		nr = _tmp44_ + 16;
	}
	_tmp45_ = self->map;
	_tmp45__length1 = self->map_length1;
	_tmp46_ = x;
	_tmp47_ = y;
	_tmp48_ = self->width;
	_tmp49_ = _tmp45_[(_tmp46_ - 1) + ((_tmp47_ + 1) * (_tmp48_ + 2))];
	_tmp50_ = c;
	if (_tmp49_ == _tmp50_) {
		gint _tmp51_ = 0;
		_tmp51_ = nr;
		nr = _tmp51_ + 32;
	}
	_tmp52_ = self->map;
	_tmp52__length1 = self->map_length1;
	_tmp53_ = x;
	_tmp54_ = y;
	_tmp55_ = self->width;
	_tmp56_ = _tmp52_[(_tmp53_ - 0) + ((_tmp54_ + 1) * (_tmp55_ + 2))];
	_tmp57_ = c;
	if (_tmp56_ == _tmp57_) {
		gint _tmp58_ = 0;
		_tmp58_ = nr;
		nr = _tmp58_ + 64;
	}
	_tmp59_ = self->map;
	_tmp59__length1 = self->map_length1;
	_tmp60_ = x;
	_tmp61_ = y;
	_tmp62_ = self->width;
	_tmp63_ = _tmp59_[(_tmp60_ + 1) + ((_tmp61_ + 1) * (_tmp62_ + 2))];
	_tmp64_ = c;
	if (_tmp63_ == _tmp64_) {
		gint _tmp65_ = 0;
		_tmp65_ = nr;
		nr = _tmp65_ + 128;
	}
	i = 0;
	while (TRUE) {
		gboolean _tmp66_ = FALSE;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp72_ = 0;
		_tmp67_ = nr;
		_tmp68_ = i;
		_tmp69_ = image_map[_tmp68_];
		if (_tmp67_ != _tmp69_) {
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			_tmp70_ = i;
			_tmp71_ = image_map[_tmp70_];
			_tmp66_ = _tmp71_ != (-1);
		} else {
			_tmp66_ = FALSE;
		}
		if (!_tmp66_) {
			break;
		}
		_tmp72_ = i;
		i = _tmp72_ + 2;
	}
	_tmp73_ = i;
	_tmp74_ = image_map[_tmp73_ + 1];
	result = _tmp74_;
	return result;
}


gboolean puzzle_game_over (Puzzle* self) {
	gboolean result = FALSE;
	gboolean over = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	over = TRUE;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean _tmp8_ = FALSE;
							gchar* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gchar _tmp12_ = '\0';
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp9_ = self->map;
							_tmp9__length1 = self->map_length1;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp12_ = puzzle_get_piece_id (self, _tmp9_, _tmp9__length1, _tmp10_, _tmp11_);
							if (_tmp12_ == '*') {
								gchar* _tmp13_ = NULL;
								gint _tmp13__length1 = 0;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gchar _tmp16_ = '\0';
								_tmp13_ = self->orig_map;
								_tmp13__length1 = self->orig_map_length1;
								_tmp14_ = x;
								_tmp15_ = y;
								_tmp16_ = puzzle_get_piece_id (self, _tmp13_, _tmp13__length1, _tmp14_, _tmp15_);
								_tmp8_ = _tmp16_ != '.';
							} else {
								_tmp8_ = FALSE;
							}
							if (_tmp8_) {
								over = FALSE;
							}
						}
					}
				}
			}
		}
	}
	result = over;
	return result;
}


gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gchar* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gchar _tmp11_ = '\0';
							gchar* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gchar _tmp15_ = '\0';
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = m1;
							_tmp8__length1 = m1_length1;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = puzzle_get_piece_id (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_);
							_tmp12_ = m2;
							_tmp12__length1 = m2_length1;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = puzzle_get_piece_id (self, _tmp12_, _tmp12__length1, _tmp13_, _tmp14_);
							if (_tmp11_ != _tmp15_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean puzzle_movable (Puzzle* self, gint id) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = id;
	if (_tmp3_ == ((gint) '#')) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = id;
		_tmp2_ = _tmp4_ == ((gint) '.');
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = id;
		_tmp1_ = _tmp5_ == ((gint) ' ');
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp6_ = 0;
		_tmp6_ = id;
		_tmp0_ = _tmp6_ == ((gint) '-');
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2) {
	gboolean result = FALSE;
	gboolean return_value = FALSE;
	gchar _tmp0_ = '\0';
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar _tmp5_ = '\0';
	gchar _tmp6_ = '\0';
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	return_value = FALSE;
	_tmp0_ = id;
	_tmp1_ = puzzle_movable (self, (gint) _tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->map;
	_tmp2__length1 = self->map_length1;
	_tmp3_ = x2;
	_tmp4_ = y2;
	_tmp5_ = puzzle_get_piece_id (self, _tmp2_, _tmp2__length1, _tmp3_, _tmp4_);
	_tmp6_ = id;
	if (_tmp5_ == _tmp6_) {
		return_value = TRUE;
	}
	_tmp9_ = y1;
	_tmp10_ = y2;
	if (_tmp9_ == _tmp10_) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp11_ = x1;
		_tmp12_ = x2;
		_tmp13_ = abs (_tmp11_ - _tmp12_);
		_tmp8_ = _tmp13_ == 1;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp15_ = x1;
		_tmp16_ = x2;
		if (_tmp15_ == _tmp16_) {
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp17_ = y1;
			_tmp18_ = y2;
			_tmp19_ = abs (_tmp17_ - _tmp18_);
			_tmp14_ = _tmp19_ == 1;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp7_ = _tmp14_;
	}
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = y1;
	_tmp21_ = y2;
	_tmp22_ = abs (_tmp20_ - _tmp21_);
	if (_tmp22_ == 1) {
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp23_ = y1;
		_tmp24_ = y2;
		if ((_tmp23_ - _tmp24_) < 0) {
			gchar _tmp25_ = '\0';
			gboolean _tmp26_ = FALSE;
			_tmp25_ = id;
			_tmp26_ = puzzle_check_valid_move (self, (gint) _tmp25_, 0, 1);
			if (_tmp26_) {
				gchar _tmp27_ = '\0';
				gboolean _tmp28_ = FALSE;
				_tmp27_ = id;
				_tmp28_ = puzzle_do_move_piece (self, _tmp27_, 0, 1);
				result = _tmp28_;
				return result;
			}
		}
		_tmp29_ = y1;
		_tmp30_ = y2;
		if ((_tmp29_ - _tmp30_) > 0) {
			gchar _tmp31_ = '\0';
			gboolean _tmp32_ = FALSE;
			_tmp31_ = id;
			_tmp32_ = puzzle_check_valid_move (self, (gint) _tmp31_, 0, -1);
			if (_tmp32_) {
				gchar _tmp33_ = '\0';
				gboolean _tmp34_ = FALSE;
				_tmp33_ = id;
				_tmp34_ = puzzle_do_move_piece (self, _tmp33_, 0, -1);
				result = _tmp34_;
				return result;
			}
		}
	}
	_tmp35_ = x1;
	_tmp36_ = x2;
	_tmp37_ = abs (_tmp35_ - _tmp36_);
	if (_tmp37_ == 1) {
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp38_ = x1;
		_tmp39_ = x2;
		if ((_tmp38_ - _tmp39_) < 0) {
			gchar _tmp40_ = '\0';
			gboolean _tmp41_ = FALSE;
			_tmp40_ = id;
			_tmp41_ = puzzle_check_valid_move (self, (gint) _tmp40_, 1, 0);
			if (_tmp41_) {
				gchar _tmp42_ = '\0';
				gboolean _tmp43_ = FALSE;
				_tmp42_ = id;
				_tmp43_ = puzzle_do_move_piece (self, _tmp42_, 1, 0);
				result = _tmp43_;
				return result;
			}
		}
		_tmp44_ = x1;
		_tmp45_ = x2;
		if ((_tmp44_ - _tmp45_) > 0) {
			gchar _tmp46_ = '\0';
			gboolean _tmp47_ = FALSE;
			_tmp46_ = id;
			_tmp47_ = puzzle_check_valid_move (self, (gint) _tmp46_, -1, 0);
			if (_tmp47_) {
				gchar _tmp48_ = '\0';
				gboolean _tmp49_ = FALSE;
				_tmp48_ = id;
				_tmp49_ = puzzle_do_move_piece (self, _tmp48_, -1, 0);
				result = _tmp49_;
				return result;
			}
		}
	}
	result = return_value;
	return result;
}


static gboolean puzzle_check_valid_move (Puzzle* self, gint id, gint dx, gint dy) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = y;
				_tmp3_ = self->height;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gchar* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gchar _tmp11_ = '\0';
							gint _tmp12_ = 0;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = x;
								x = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = x;
							_tmp7_ = self->width;
							if (!(_tmp6_ < _tmp7_)) {
								break;
							}
							_tmp8_ = self->map;
							_tmp8__length1 = self->map_length1;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = puzzle_get_piece_id (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp10_);
							_tmp12_ = id;
							if (((gint) _tmp11_) == _tmp12_) {
								gchar z = '\0';
								gchar* _tmp13_ = NULL;
								gint _tmp13__length1 = 0;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar _tmp18_ = '\0';
								gboolean _tmp19_ = FALSE;
								gboolean _tmp20_ = FALSE;
								gboolean _tmp21_ = FALSE;
								gchar _tmp22_ = '\0';
								_tmp13_ = self->map;
								_tmp13__length1 = self->map_length1;
								_tmp14_ = x;
								_tmp15_ = dx;
								_tmp16_ = y;
								_tmp17_ = dy;
								_tmp18_ = puzzle_get_piece_id (self, _tmp13_, _tmp13__length1, _tmp14_ + _tmp15_, _tmp16_ + _tmp17_);
								z = _tmp18_;
								_tmp22_ = z;
								if (_tmp22_ == ' ') {
									_tmp21_ = TRUE;
								} else {
									gchar _tmp23_ = '\0';
									_tmp23_ = z;
									_tmp21_ = _tmp23_ == '.';
								}
								if (_tmp21_) {
									_tmp20_ = TRUE;
								} else {
									gchar _tmp24_ = '\0';
									gint _tmp25_ = 0;
									_tmp24_ = z;
									_tmp25_ = id;
									_tmp20_ = ((gint) _tmp24_) == _tmp25_;
								}
								if (_tmp20_) {
									_tmp19_ = TRUE;
								} else {
									gboolean _tmp26_ = FALSE;
									gint _tmp27_ = 0;
									_tmp27_ = id;
									if (_tmp27_ == ((gint) '*')) {
										gchar _tmp28_ = '\0';
										_tmp28_ = z;
										_tmp26_ = _tmp28_ == '-';
									} else {
										_tmp26_ = FALSE;
									}
									_tmp19_ = _tmp26_;
								}
								if (!_tmp19_) {
									result = FALSE;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar* _vala_array_dup5 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gchar* _vala_array_dup6 (gchar* self, int length) {
	return g_memdup (self, length * sizeof (gchar));
}


static gboolean puzzle_do_move_piece (Puzzle* self, gchar id, gint dx, gint dy) {
	gboolean result = FALSE;
	gchar* tmpmap = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint tmpmap_length1 = 0;
	gint _tmpmap_size_ = 0;
	gchar* _tmp91_ = NULL;
	gint _tmp91__length1 = 0;
	gchar* _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->map;
	_tmp0__length1 = self->map_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	tmpmap = _tmp1_;
	tmpmap_length1 = _tmp1__length1;
	_tmpmap_size_ = tmpmap_length1;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = y;
					y = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = y;
				_tmp5_ = self->height;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gchar* _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gchar _tmp13_ = '\0';
							gchar _tmp14_ = '\0';
							if (!_tmp6_) {
								gint _tmp7_ = 0;
								_tmp7_ = x;
								x = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = x;
							_tmp9_ = self->width;
							if (!(_tmp8_ < _tmp9_)) {
								break;
							}
							_tmp10_ = tmpmap;
							_tmp10__length1 = tmpmap_length1;
							_tmp11_ = x;
							_tmp12_ = y;
							_tmp13_ = puzzle_get_piece_id (self, _tmp10_, _tmp10__length1, _tmp11_, _tmp12_);
							_tmp14_ = id;
							if (_tmp13_ == _tmp14_) {
								gchar* _tmp15_ = NULL;
								gint _tmp15__length1 = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								_tmp15_ = tmpmap;
								_tmp15__length1 = tmpmap_length1;
								_tmp16_ = x;
								_tmp17_ = y;
								puzzle_set_piece_id (self, _tmp15_, _tmp15__length1, _tmp16_, _tmp17_, ' ');
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				if (!_tmp18_) {
					gint _tmp19_ = 0;
					_tmp19_ = y;
					y = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = y;
				_tmp21_ = self->height;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp22_ = FALSE;
						_tmp22_ = TRUE;
						while (TRUE) {
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gchar* _tmp26_ = NULL;
							gint _tmp26__length1 = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gchar _tmp29_ = '\0';
							gchar _tmp30_ = '\0';
							if (!_tmp22_) {
								gint _tmp23_ = 0;
								_tmp23_ = x;
								x = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							_tmp24_ = x;
							_tmp25_ = self->width;
							if (!(_tmp24_ < _tmp25_)) {
								break;
							}
							_tmp26_ = self->map;
							_tmp26__length1 = self->map_length1;
							_tmp27_ = x;
							_tmp28_ = y;
							_tmp29_ = puzzle_get_piece_id (self, _tmp26_, _tmp26__length1, _tmp27_, _tmp28_);
							_tmp30_ = id;
							if (_tmp29_ == _tmp30_) {
								gchar* _tmp31_ = NULL;
								gint _tmp31__length1 = 0;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								gint _tmp35_ = 0;
								gchar _tmp36_ = '\0';
								_tmp31_ = tmpmap;
								_tmp31__length1 = tmpmap_length1;
								_tmp32_ = x;
								_tmp33_ = dx;
								_tmp34_ = y;
								_tmp35_ = dy;
								_tmp36_ = id;
								puzzle_set_piece_id (self, _tmp31_, _tmp31__length1, _tmp32_ + _tmp33_, _tmp34_ + _tmp35_, _tmp36_);
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				if (!_tmp37_) {
					gint _tmp38_ = 0;
					_tmp38_ = y;
					y = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = y;
				_tmp40_ = self->height;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp41_ = FALSE;
						_tmp41_ = TRUE;
						while (TRUE) {
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gchar* _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gchar _tmp49_ = '\0';
							gboolean _tmp57_ = FALSE;
							gchar* _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							gchar _tmp61_ = '\0';
							if (!_tmp41_) {
								gint _tmp42_ = 0;
								_tmp42_ = x;
								x = _tmp42_ + 1;
							}
							_tmp41_ = FALSE;
							_tmp43_ = x;
							_tmp44_ = self->width;
							if (!(_tmp43_ < _tmp44_)) {
								break;
							}
							_tmp46_ = tmpmap;
							_tmp46__length1 = tmpmap_length1;
							_tmp47_ = x;
							_tmp48_ = y;
							_tmp49_ = puzzle_get_piece_id (self, _tmp46_, _tmp46__length1, _tmp47_, _tmp48_);
							if (_tmp49_ == ' ') {
								gchar* _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								gchar _tmp53_ = '\0';
								_tmp50_ = self->orig_map;
								_tmp50__length1 = self->orig_map_length1;
								_tmp51_ = x;
								_tmp52_ = y;
								_tmp53_ = puzzle_get_piece_id (self, _tmp50_, _tmp50__length1, _tmp51_, _tmp52_);
								_tmp45_ = _tmp53_ == '.';
							} else {
								_tmp45_ = FALSE;
							}
							if (_tmp45_) {
								gchar* _tmp54_ = NULL;
								gint _tmp54__length1 = 0;
								gint _tmp55_ = 0;
								gint _tmp56_ = 0;
								_tmp54_ = tmpmap;
								_tmp54__length1 = tmpmap_length1;
								_tmp55_ = x;
								_tmp56_ = y;
								puzzle_set_piece_id (self, _tmp54_, _tmp54__length1, _tmp55_, _tmp56_, '.');
							}
							_tmp58_ = tmpmap;
							_tmp58__length1 = tmpmap_length1;
							_tmp59_ = x;
							_tmp60_ = y;
							_tmp61_ = puzzle_get_piece_id (self, _tmp58_, _tmp58__length1, _tmp59_, _tmp60_);
							if (_tmp61_ == ' ') {
								gchar* _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								gchar _tmp65_ = '\0';
								_tmp62_ = self->orig_map;
								_tmp62__length1 = self->orig_map_length1;
								_tmp63_ = x;
								_tmp64_ = y;
								_tmp65_ = puzzle_get_piece_id (self, _tmp62_, _tmp62__length1, _tmp63_, _tmp64_);
								_tmp57_ = _tmp65_ == '-';
							} else {
								_tmp57_ = FALSE;
							}
							if (_tmp57_) {
								gchar* _tmp66_ = NULL;
								gint _tmp66__length1 = 0;
								gint _tmp67_ = 0;
								gint _tmp68_ = 0;
								_tmp66_ = tmpmap;
								_tmp66__length1 = tmpmap_length1;
								_tmp67_ = x;
								_tmp68_ = y;
								puzzle_set_piece_id (self, _tmp66_, _tmp66__length1, _tmp67_, _tmp68_, '-');
							}
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp69_ = FALSE;
			_tmp69_ = TRUE;
			while (TRUE) {
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				if (!_tmp69_) {
					gint _tmp70_ = 0;
					_tmp70_ = y;
					y = _tmp70_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp71_ = y;
				_tmp72_ = self->height;
				if (!(_tmp71_ < _tmp72_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp73_ = FALSE;
						_tmp73_ = TRUE;
						while (TRUE) {
							gint _tmp75_ = 0;
							gint _tmp76_ = 0;
							gboolean _tmp77_ = FALSE;
							gchar* _tmp78_ = NULL;
							gint _tmp78__length1 = 0;
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							gchar _tmp81_ = '\0';
							gchar* _tmp82_ = NULL;
							gint _tmp82__length1 = 0;
							gint _tmp83_ = 0;
							gint _tmp84_ = 0;
							gchar _tmp85_ = '\0';
							if (!_tmp73_) {
								gint _tmp74_ = 0;
								_tmp74_ = x;
								x = _tmp74_ + 1;
							}
							_tmp73_ = FALSE;
							_tmp75_ = x;
							_tmp76_ = self->width;
							if (!(_tmp75_ < _tmp76_)) {
								break;
							}
							_tmp78_ = self->map;
							_tmp78__length1 = self->map_length1;
							_tmp79_ = x;
							_tmp80_ = y;
							_tmp81_ = puzzle_get_piece_id (self, _tmp78_, _tmp78__length1, _tmp79_, _tmp80_);
							_tmp82_ = tmpmap;
							_tmp82__length1 = tmpmap_length1;
							_tmp83_ = x;
							_tmp84_ = y;
							_tmp85_ = puzzle_get_piece_id (self, _tmp82_, _tmp82__length1, _tmp83_, _tmp84_);
							if (_tmp81_ != _tmp85_) {
								_tmp77_ = TRUE;
							} else {
								gchar* _tmp86_ = NULL;
								gint _tmp86__length1 = 0;
								gint _tmp87_ = 0;
								gint _tmp88_ = 0;
								gchar _tmp89_ = '\0';
								gchar _tmp90_ = '\0';
								_tmp86_ = tmpmap;
								_tmp86__length1 = tmpmap_length1;
								_tmp87_ = x;
								_tmp88_ = y;
								_tmp89_ = puzzle_get_piece_id (self, _tmp86_, _tmp86__length1, _tmp87_, _tmp88_);
								_tmp90_ = id;
								_tmp77_ = _tmp89_ == _tmp90_;
							}
							if (_tmp77_) {
							}
						}
					}
				}
			}
		}
	}
	g_signal_emit_by_name (self, "changed");
	_tmp91_ = tmpmap;
	_tmp91__length1 = tmpmap_length1;
	_tmp92_ = (_tmp91_ != NULL) ? _vala_array_dup6 (_tmp91_, _tmp91__length1) : ((gpointer) _tmp91_);
	_tmp92__length1 = _tmp91__length1;
	self->map = (g_free (self->map), NULL);
	self->map = _tmp92_;
	self->map_length1 = _tmp92__length1;
	result = TRUE;
	tmpmap = (g_free (tmpmap), NULL);
	return result;
}


static void value_puzzle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_puzzle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		puzzle_unref (value->data[0].v_pointer);
	}
}


static void value_puzzle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = puzzle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_puzzle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_puzzle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Puzzle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = puzzle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_puzzle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Puzzle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = puzzle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_puzzle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPuzzle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PUZZLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_puzzle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE), NULL);
	return value->data[0].v_pointer;
}


void value_set_puzzle (GValue* value, gpointer v_object) {
	Puzzle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PUZZLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		puzzle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		puzzle_unref (old);
	}
}


void value_take_puzzle (GValue* value, gpointer v_object) {
	Puzzle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PUZZLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PUZZLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		puzzle_unref (old);
	}
}


static void puzzle_class_init (PuzzleClass * klass) {
	puzzle_parent_class = g_type_class_peek_parent (klass);
	PUZZLE_CLASS (klass)->finalize = puzzle_finalize;
	g_signal_new ("changed", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("moved", TYPE_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void puzzle_instance_init (Puzzle * self) {
	self->moves = 0;
	self->ref_count = 1;
}


static void puzzle_finalize (Puzzle* obj) {
	Puzzle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE, Puzzle);
	self->map = (g_free (self->map), NULL);
	self->move_map = (g_free (self->move_map), NULL);
	self->orig_map = (g_free (self->orig_map), NULL);
	self->lastmove_map = (g_free (self->lastmove_map), NULL);
	self->undomove_map = (g_free (self->undomove_map), NULL);
}


GType puzzle_get_type (void) {
	static volatile gsize puzzle_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_puzzle_init, value_puzzle_free_value, value_puzzle_copy_value, value_puzzle_peek_pointer, "p", value_puzzle_collect_value, "p", value_puzzle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Puzzle), 0, (GInstanceInitFunc) puzzle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType puzzle_type_id;
		puzzle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Puzzle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&puzzle_type_id__volatile, puzzle_type_id);
	}
	return puzzle_type_id__volatile;
}


gpointer puzzle_ref (gpointer instance) {
	Puzzle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void puzzle_unref (gpointer instance) {
	Puzzle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PUZZLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



