/* alarm.c generated by valac 0.24.0.146-7a48b, the Vala compiler
 * generated from alarm.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>


#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef struct _ClocksAlarmItemPrivate ClocksAlarmItemPrivate;

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;

#define CLOCKS_ALARM_ITEM_TYPE_STATE (clocks_alarm_item_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_ALARM_TYPE_SETUP_DIALOG (clocks_alarm_setup_dialog_get_type ())
#define CLOCKS_ALARM_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog))
#define CLOCKS_ALARM_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))
#define CLOCKS_ALARM_IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))

typedef struct _ClocksAlarmSetupDialog ClocksAlarmSetupDialog;
typedef struct _ClocksAlarmSetupDialogClass ClocksAlarmSetupDialogClass;
typedef struct _ClocksAlarmSetupDialogPrivate ClocksAlarmSetupDialogPrivate;

#define CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT (clocks_utils_wall_clock_format_get_type ())

#define CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON (clocks_am_pm_toggle_button_get_type ())
#define CLOCKS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))

typedef struct _ClocksAmPmToggleButton ClocksAmPmToggleButton;
typedef struct _ClocksAmPmToggleButtonClass ClocksAmPmToggleButtonClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CLOCKS_AM_PM_TOGGLE_BUTTON_TYPE_AM_PM (clocks_am_pm_toggle_button_am_pm_get_type ())

#define CLOCKS_ALARM_TYPE_RINGING_PANEL (clocks_alarm_ringing_panel_get_type ())
#define CLOCKS_ALARM_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel))
#define CLOCKS_ALARM_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))
#define CLOCKS_ALARM_IS_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_IS_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_RINGING_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))

typedef struct _ClocksAlarmRingingPanel ClocksAlarmRingingPanel;
typedef struct _ClocksAlarmRingingPanelClass ClocksAlarmRingingPanelClass;
typedef struct _ClocksAlarmRingingPanelPrivate ClocksAlarmRingingPanelPrivate;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_ALARM_TYPE_MAIN_PANEL (clocks_alarm_main_panel_get_type ())
#define CLOCKS_ALARM_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel))
#define CLOCKS_ALARM_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelClass))
#define CLOCKS_ALARM_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL))
#define CLOCKS_ALARM_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_MAIN_PANEL))
#define CLOCKS_ALARM_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelClass))

typedef struct _ClocksAlarmMainPanel ClocksAlarmMainPanel;
typedef struct _ClocksAlarmMainPanelClass ClocksAlarmMainPanelClass;
typedef struct _ClocksAlarmMainPanelPrivate ClocksAlarmMainPanelPrivate;

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
typedef struct _Block4Data Block4Data;

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*get_thumb_properties) (ClocksContentItem* self, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
	const gchar* (*get_title_icon) (ClocksContentItem* self);
	void (*set_title_icon) (ClocksContentItem* self, const gchar* value);
	gboolean (*get_selectable) (ClocksContentItem* self);
	void (*set_selectable) (ClocksContentItem* self, gboolean value);
};

struct _ClocksAlarmItem {
	GObject parent_instance;
	ClocksAlarmItemPrivate * priv;
};

struct _ClocksAlarmItemClass {
	GObjectClass parent_class;
	void (*ring) (ClocksAlarmItem* self);
};

typedef enum  {
	CLOCKS_ALARM_ITEM_STATE_READY,
	CLOCKS_ALARM_ITEM_STATE_RINGING,
	CLOCKS_ALARM_ITEM_STATE_SNOOZING
} ClocksAlarmItemState;

struct _ClocksAlarmItemPrivate {
	gchar* _title_icon;
	gboolean _selectable;
	gchar* _id;
	gint _hour;
	gint _minute;
	ClocksUtilsWeekdays* _days;
	ClocksAlarmItemState _state;
	gchar* _name;
	gboolean _active;
	GDateTime* alarm_time;
	GDateTime* snooze_time;
	GDateTime* ring_end_time;
	ClocksUtilsBell* bell;
	GNotification* notification;
};

typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

struct _ClocksAlarmSetupDialog {
	GtkDialog parent_instance;
	ClocksAlarmSetupDialogPrivate * priv;
};

struct _ClocksAlarmSetupDialogClass {
	GtkDialogClass parent_class;
};

typedef enum  {
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR
} ClocksUtilsWallClockFormat;

struct _ClocksAlarmSetupDialogPrivate {
	ClocksUtilsWallClockFormat format;
	GtkGrid* time_grid;
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkEntry* name_entry;
	ClocksAmPmToggleButton* am_pm_button;
	GtkToggleButton** day_buttons;
	gint day_buttons_length1;
	gint _day_buttons_size_;
	GtkSwitch* active_switch;
	GtkBox* day_buttons_box;
	GtkAlignment* am_pm_alignment;
	GtkRevealer* label_revealer;
	GtkSizeGroup* am_pm_sizegroup;
	GList* alarms_list;
};

typedef enum  {
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM,
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM
} ClocksAmPmToggleButtonAmPm;

struct _ClocksAlarmRingingPanel {
	GtkEventBox parent_instance;
	ClocksAlarmRingingPanelPrivate * priv;
};

struct _ClocksAlarmRingingPanelClass {
	GtkEventBoxClass parent_class;
	void (*dismiss) (ClocksAlarmRingingPanel* self);
};

struct _ClocksAlarmRingingPanelPrivate {
	ClocksAlarmItem* _alarm;
	gulong alarm_state_handler;
	GtkLabel* time_label;
	GtkButton* stop_button;
	GtkButton* snooze_button;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksAlarmMainPanel {
	GtkStack parent_instance;
	ClocksAlarmMainPanelPrivate * priv;
};

struct _ClocksAlarmMainPanelClass {
	GtkStackClass parent_class;
};

struct _ClocksAlarmMainPanelPrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	GList* alarms;
	GSettings* settings;
	GtkButton* new_button;
	ClocksContentView* content_view;
	ClocksAlarmRingingPanel* ringing_panel;
};

struct _Block4Data {
	int _ref_count_;
	ClocksAlarmMainPanel* self;
	ClocksHeaderBar* header_bar;
};

typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;

struct _Block5Data {
	int _ref_count_;
	ClocksAlarmMainPanel* self;
	gboolean saved_active;
	ClocksAlarmItem* alarm;
};


static gpointer clocks_alarm_item_parent_class = NULL;
static ClocksContentItemIface* clocks_alarm_item_clocks_content_item_parent_iface = NULL;
static gpointer clocks_alarm_setup_dialog_parent_class = NULL;
static gpointer clocks_alarm_ringing_panel_parent_class = NULL;
static gpointer clocks_alarm_main_panel_parent_class = NULL;
static ClocksClockIface* clocks_alarm_main_panel_clocks_clock_parent_iface = NULL;

GType clocks_content_item_get_type (void) G_GNUC_CONST;
GType clocks_alarm_item_get_type (void) G_GNUC_CONST;
gpointer clocks_utils_weekdays_ref (gpointer instance);
void clocks_utils_weekdays_unref (gpointer instance);
GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void clocks_utils_value_set_weekdays (GValue* value, gpointer v_object);
void clocks_utils_value_take_weekdays (GValue* value, gpointer v_object);
gpointer clocks_utils_value_get_weekdays (const GValue* value);
GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST;
GType clocks_alarm_item_state_get_type (void) G_GNUC_CONST;
GType clocks_utils_bell_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemPrivate))
enum  {
	CLOCKS_ALARM_ITEM_DUMMY_PROPERTY,
	CLOCKS_ALARM_ITEM_TITLE_ICON,
	CLOCKS_ALARM_ITEM_SELECTABLE,
	CLOCKS_ALARM_ITEM_ID,
	CLOCKS_ALARM_ITEM_NAME,
	CLOCKS_ALARM_ITEM_HOUR,
	CLOCKS_ALARM_ITEM_MINUTE,
	CLOCKS_ALARM_ITEM_DAYS,
	CLOCKS_ALARM_ITEM_REPEAT_LABEL,
	CLOCKS_ALARM_ITEM_STATE,
	CLOCKS_ALARM_ITEM_TIME_LABEL,
	CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL,
	CLOCKS_ALARM_ITEM_ACTIVE
};
#define CLOCKS_ALARM_ITEM_SNOOZE_MINUTES 9
#define CLOCKS_ALARM_ITEM_RING_MINUTES 3
ClocksAlarmItem* clocks_alarm_item_new (void);
ClocksAlarmItem* clocks_alarm_item_construct (GType object_type);
void clocks_alarm_item_set_id (ClocksAlarmItem* self, const gchar* value);
ClocksUtilsWeekdays* clocks_utils_weekdays_new (void);
ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type);
void clocks_alarm_item_set_days (ClocksAlarmItem* self, ClocksUtilsWeekdays* value);
ClocksAlarmItem* clocks_alarm_item_new_with_data (const gchar* id, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days);
ClocksAlarmItem* clocks_alarm_item_construct_with_data (GType object_type, const gchar* id, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days);
static void clocks_alarm_item_setup_bell (ClocksAlarmItem* self);
void clocks_alarm_item_reset (ClocksAlarmItem* self);
ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid);
ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid);
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
const gchar* clocks_alarm_item_get_id (ClocksAlarmItem* self);
static void clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self);
static void clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self, GDateTime* start_time);
static void clocks_alarm_item_set_state (ClocksAlarmItem* self, ClocksAlarmItemState value);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
gint clocks_alarm_item_get_hour (ClocksAlarmItem* self);
gint clocks_alarm_item_get_minute (ClocksAlarmItem* self);
ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self);
gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST;
gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d);
static void clocks_alarm_item_start_ringing (ClocksAlarmItem* self, GDateTime* now);
void clocks_alarm_item_snooze (ClocksAlarmItem* self);
void clocks_utils_bell_stop (ClocksUtilsBell* self);
void clocks_alarm_item_stop (ClocksAlarmItem* self);
static gboolean clocks_alarm_item_compare_with_item (ClocksAlarmItem* self, ClocksAlarmItem* i);
gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
gboolean clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self, GList* alarms_list);
gboolean clocks_alarm_item_tick (ClocksAlarmItem* self);
ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self);
static void clocks_alarm_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class);
gchar* clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self);
gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self);
gchar* clocks_alarm_item_get_repeat_label (ClocksAlarmItem* self);
void clocks_alarm_item_serialize (ClocksAlarmItem* self, GVariantBuilder* builder);
GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
ClocksAlarmItem* clocks_alarm_item_deserialize (GVariant* alarm_variant);
ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
void clocks_alarm_item_set_hour (ClocksAlarmItem* self, gint value);
void clocks_alarm_item_set_minute (ClocksAlarmItem* self, gint value);
gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
void clocks_alarm_item_set_active (ClocksAlarmItem* self, gboolean value);
static void clocks_alarm_item_real_ring (ClocksAlarmItem* self);
void clocks_utils_bell_ring (ClocksUtilsBell* self);
static void clocks_alarm_item_finalize (GObject* obj);
const gchar* clocks_content_item_get_title_icon (ClocksContentItem* self);
gboolean clocks_content_item_get_selectable (ClocksContentItem* self);
static void _vala_clocks_alarm_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_content_item_set_title_icon (ClocksContentItem* self, const gchar* value);
void clocks_content_item_set_selectable (ClocksContentItem* self, gboolean value);
void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value);
static void _vala_clocks_alarm_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_alarm_setup_dialog_get_type (void) G_GNUC_CONST;
GType clocks_utils_wall_clock_format_get_type (void) G_GNUC_CONST;
GType clocks_am_pm_toggle_button_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_SETUP_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogPrivate))
enum  {
	CLOCKS_ALARM_SETUP_DIALOG_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (GtkWindow* parent, ClocksAlarmItem* alarm, GList* alarms);
ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type, GtkWindow* parent, ClocksAlarmItem* alarm, GList* alarms);
ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self);
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_new (void);
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_construct (GType object_type);
gchar* clocks_utils_weekdays_abbreviation (ClocksUtilsWeekdaysDay d);
static void _____lambda39_ (ClocksAlarmSetupDialog* self);
static void clocks_alarm_setup_dialog_avoid_duplicate_alarm (ClocksAlarmSetupDialog* self);
static void ______lambda39__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
ClocksUtilsWeekdaysDay clocks_utils_weekdays_get_first_weekday (void);
void clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm);
GType clocks_am_pm_toggle_button_am_pm_get_type (void) G_GNUC_CONST;
void clocks_am_pm_toggle_button_set_choice (ClocksAmPmToggleButton* self, ClocksAmPmToggleButtonAmPm value);
void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm);
ClocksAmPmToggleButtonAmPm clocks_am_pm_toggle_button_get_choice (ClocksAmPmToggleButton* self);
void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d, gboolean on);
static void clocks_alarm_setup_dialog_spinbuttons_changed (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button);
static void _clocks_alarm_setup_dialog_spinbuttons_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void clocks_alarm_setup_dialog_active_changed (ClocksAlarmSetupDialog* self);
static void _clocks_alarm_setup_dialog_active_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button);
static gboolean _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self);
static void clocks_alarm_setup_dialog_finalize (GObject* obj);
GType clocks_alarm_ringing_panel_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_RINGING_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelPrivate))
enum  {
	CLOCKS_ALARM_RINGING_PANEL_DUMMY_PROPERTY,
	CLOCKS_ALARM_RINGING_PANEL_ALARM
};
ClocksAlarmRingingPanel* clocks_alarm_ringing_panel_new (void);
ClocksAlarmRingingPanel* clocks_alarm_ringing_panel_construct (GType object_type);
GtkBuilder* clocks_utils_load_ui (const gchar* ui);
static void __lambda32_ (ClocksAlarmRingingPanel* self);
ClocksAlarmItem* clocks_alarm_ringing_panel_get_alarm (ClocksAlarmRingingPanel* self);
static void ___lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda34_ (ClocksAlarmRingingPanel* self);
static void ___lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self);
void clocks_alarm_ringing_panel_update (ClocksAlarmRingingPanel* self);
void clocks_alarm_ringing_panel_set_alarm (ClocksAlarmRingingPanel* self, ClocksAlarmItem* value);
static void _clocks_alarm_ringing_panel_alarm____lambda33_ (ClocksAlarmRingingPanel* self);
static void __clocks_alarm_ringing_panel_alarm____lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void clocks_alarm_ringing_panel_real_dismiss (ClocksAlarmRingingPanel* self);
static void clocks_alarm_ringing_panel_finalize (GObject* obj);
static void _vala_clocks_alarm_ringing_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_alarm_ringing_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_alarm_main_panel_get_type (void) G_GNUC_CONST;
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelPrivate))
enum  {
	CLOCKS_ALARM_MAIN_PANEL_DUMMY_PROPERTY,
	CLOCKS_ALARM_MAIN_PANEL_LABEL,
	CLOCKS_ALARM_MAIN_PANEL_HEADER_BAR,
	CLOCKS_ALARM_MAIN_PANEL_PANEL_ID
};
ClocksAlarmMainPanel* clocks_alarm_main_panel_new (ClocksHeaderBar* header_bar);
ClocksAlarmMainPanel* clocks_alarm_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda35_ (ClocksAlarmMainPanel* self, GSimpleAction* action, GVariant* param);
static ClocksAlarmItem* clocks_alarm_main_panel_find_item (ClocksAlarmMainPanel* self, const gchar* id);
static void ___lambda35__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda36_ (ClocksAlarmMainPanel* self, GSimpleAction* action, GVariant* param);
static void ___lambda36__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
ClocksContentView* clocks_content_view_new (GtkWidget* e, ClocksHeaderBar* b);
ClocksContentView* clocks_content_view_construct (GType object_type, GtkWidget* e, ClocksHeaderBar* b);
static void __lambda37_ (ClocksAlarmMainPanel* self, GObject* item);
static void clocks_alarm_main_panel_show_ringing_panel (ClocksAlarmMainPanel* self, ClocksAlarmItem* alarm);
static void clocks_alarm_main_panel_edit (ClocksAlarmMainPanel* self, ClocksAlarmItem* alarm);
static void ___lambda37__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self);
static void __lambda41_ (ClocksAlarmMainPanel* self);
GList* clocks_content_view_get_selected_items (ClocksContentView* self);
static void clocks_alarm_main_panel_save (ClocksAlarmMainPanel* self);
static void ___lambda41__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self);
static void __lambda42_ (ClocksAlarmMainPanel* self);
static void ___lambda42__clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender, gpointer self);
static void clocks_alarm_main_panel_load (ClocksAlarmMainPanel* self);
static void __lambda43_ (Block4Data* _data4_);
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value);
static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda44_ (ClocksAlarmMainPanel* self);
static void ___lambda44__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self);
void clocks_content_view_add_item (ClocksContentView* self, ClocksContentItem* item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda40_ (Block5Data* _data5_, GtkDialog* dialog, gint response);
static void ___lambda40__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_alarm_main_panel_real_activate_new (ClocksClock* base);
static void __lambda45_ (ClocksAlarmMainPanel* self, GtkDialog* dialog, gint response);
static void ___lambda45__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_alarm_main_panel_real_activate_select_all (ClocksClock* base);
void clocks_content_view_select_all (ClocksContentView* self);
static void clocks_alarm_main_panel_real_activate_select_none (ClocksClock* base);
void clocks_content_view_unselect_all (ClocksContentView* self);
static gboolean clocks_alarm_main_panel_real_escape_pressed (ClocksClock* base);
gboolean clocks_content_view_escape_pressed (ClocksContentView* self);
static void clocks_alarm_main_panel_real_update_header_bar (ClocksClock* base);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
void clocks_content_view_update_header_bar (ClocksContentView* self);
static void clocks_alarm_main_panel_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_alarm_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_alarm_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType clocks_alarm_item_state_get_type (void) {
	static volatile gsize clocks_alarm_item_state_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_item_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_ALARM_ITEM_STATE_READY, "CLOCKS_ALARM_ITEM_STATE_READY", "ready"}, {CLOCKS_ALARM_ITEM_STATE_RINGING, "CLOCKS_ALARM_ITEM_STATE_RINGING", "ringing"}, {CLOCKS_ALARM_ITEM_STATE_SNOOZING, "CLOCKS_ALARM_ITEM_STATE_SNOOZING", "snoozing"}, {0, NULL, NULL}};
		GType clocks_alarm_item_state_type_id;
		clocks_alarm_item_state_type_id = g_enum_register_static ("ClocksAlarmItemState", values);
		g_once_init_leave (&clocks_alarm_item_state_type_id__volatile, clocks_alarm_item_state_type_id);
	}
	return clocks_alarm_item_state_type_id__volatile;
}


ClocksAlarmItem* clocks_alarm_item_construct (GType object_type) {
	ClocksAlarmItem * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ClocksUtilsWeekdays* _tmp2_ = NULL;
	ClocksUtilsWeekdays* _tmp3_ = NULL;
	self = (ClocksAlarmItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_dbus_generate_guid ();
	_tmp1_ = _tmp0_;
	clocks_alarm_item_set_id (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = clocks_utils_weekdays_new ();
	_tmp3_ = _tmp2_;
	clocks_alarm_item_set_days (self, _tmp3_);
	_clocks_utils_weekdays_unref0 (_tmp3_);
	return self;
}


ClocksAlarmItem* clocks_alarm_item_new (void) {
	return clocks_alarm_item_construct (CLOCKS_ALARM_TYPE_ITEM);
}


ClocksAlarmItem* clocks_alarm_item_construct_with_data (GType object_type, const gchar* id, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days) {
	ClocksAlarmItem * self = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _id = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	ClocksUtilsWeekdays* _tmp10_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (days != NULL, NULL);
	_tmp1_ = id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = id;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_dbus_generate_guid ();
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	_id = _tmp5_;
	_tmp6_ = name;
	_tmp7_ = active;
	_tmp8_ = hour;
	_tmp9_ = minute;
	_tmp10_ = days;
	self = (ClocksAlarmItem*) g_object_new (object_type, "id", _id, "name", _tmp6_, "active", _tmp7_, "hour", _tmp8_, "minute", _tmp9_, "days", _tmp10_, NULL);
	clocks_alarm_item_setup_bell (self);
	clocks_alarm_item_reset (self);
	_g_free0 (_id);
	_g_free0 (_tmp0_);
	return self;
}


ClocksAlarmItem* clocks_alarm_item_new_with_data (const gchar* id, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days) {
	return clocks_alarm_item_construct_with_data (CLOCKS_ALARM_TYPE_ITEM, id, name, active, hour, minute, days);
}


static void clocks_alarm_item_setup_bell (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GNotification* _tmp2_ = NULL;
	GNotification* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GNotification* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GNotification* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_bell_new ("alarm-clock-elapsed");
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp0_;
	_tmp1_ = _ ("Alarm");
	_tmp2_ = g_notification_new (_tmp1_);
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp2_;
	_tmp3_ = self->priv->notification;
	_tmp4_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp5_ = _tmp4_;
	g_notification_set_body (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->notification;
	_tmp7_ = _ ("Stop");
	_tmp8_ = self->priv->_id;
	_tmp9_ = g_strconcat ("app.stop-alarm::", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_notification_add_button (_tmp6_, _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->notification;
	_tmp12_ = _ ("Snooze");
	_tmp13_ = self->priv->_id;
	_tmp14_ = g_strconcat ("app.snooze-alarm::", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	g_notification_add_button (_tmp11_, _tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
}


void clocks_alarm_item_reset (ClocksAlarmItem* self) {
	GDateTime* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	clocks_alarm_item_update_alarm_time (self);
	_tmp0_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self) {
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	GDateTime* dt = NULL;
	ClocksUtilsWallClock* _tmp5_ = NULL;
	GTimeZone* _tmp6_ = NULL;
	GTimeZone* _tmp7_ = NULL;
	GDateTime* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GDateTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GDateTime* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GDateTime* _tmp16_ = NULL;
	ClocksUtilsWeekdays* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GDateTime* _tmp35_ = NULL;
	GDateTime* _tmp36_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = wallclock;
	_tmp2_ = clocks_utils_wall_clock_get_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	now = _tmp4_;
	_tmp5_ = wallclock;
	_tmp6_ = clocks_utils_wall_clock_get_timezone (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now;
	_tmp9_ = g_date_time_get_year (_tmp8_);
	_tmp10_ = now;
	_tmp11_ = g_date_time_get_month (_tmp10_);
	_tmp12_ = now;
	_tmp13_ = g_date_time_get_day_of_month (_tmp12_);
	_tmp14_ = self->priv->_hour;
	_tmp15_ = self->priv->_minute;
	_tmp16_ = g_date_time_new (_tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp14_, _tmp15_, (gdouble) 0);
	dt = _tmp16_;
	_tmp17_ = self->priv->_days;
	_tmp18_ = clocks_utils_weekdays_get_empty (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GDateTime* _tmp20_ = NULL;
		GDateTime* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp20_ = dt;
		_tmp21_ = now;
		_tmp22_ = g_date_time_compare (_tmp20_, _tmp21_);
		if (_tmp22_ <= 0) {
			GDateTime* _tmp23_ = NULL;
			GDateTime* _tmp24_ = NULL;
			_tmp23_ = dt;
			_tmp24_ = g_date_time_add_days (_tmp23_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp24_;
		}
	} else {
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			GDateTime* _tmp26_ = NULL;
			GDateTime* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			GDateTime* _tmp33_ = NULL;
			GDateTime* _tmp34_ = NULL;
			_tmp26_ = dt;
			_tmp27_ = now;
			_tmp28_ = g_date_time_compare (_tmp26_, _tmp27_);
			if (_tmp28_ <= 0) {
				_tmp25_ = TRUE;
			} else {
				ClocksUtilsWeekdays* _tmp29_ = NULL;
				GDateTime* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gboolean _tmp32_ = FALSE;
				_tmp29_ = self->priv->_days;
				_tmp30_ = dt;
				_tmp31_ = g_date_time_get_day_of_week (_tmp30_);
				_tmp32_ = clocks_utils_weekdays_get (_tmp29_, (ClocksUtilsWeekdaysDay) (_tmp31_ - 1));
				_tmp25_ = !_tmp32_;
			}
			if (!_tmp25_) {
				break;
			}
			_tmp33_ = dt;
			_tmp34_ = g_date_time_add_days (_tmp33_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp34_;
		}
	}
	_tmp35_ = dt;
	_tmp36_ = _g_date_time_ref0 (_tmp35_);
	_g_date_time_unref0 (self->priv->alarm_time);
	self->priv->alarm_time = _tmp36_;
	_g_date_time_unref0 (dt);
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
}


static void clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self, GDateTime* start_time) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_time != NULL);
	_tmp0_ = start_time;
	_tmp1_ = g_date_time_add_minutes (_tmp0_, CLOCKS_ALARM_ITEM_SNOOZE_MINUTES);
	_g_date_time_unref0 (self->priv->snooze_time);
	self->priv->snooze_time = _tmp1_;
}


static void clocks_alarm_item_start_ringing (ClocksAlarmItem* self, GDateTime* now) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (now != NULL);
	_tmp0_ = now;
	clocks_alarm_item_update_snooze_time (self, _tmp0_);
	_tmp1_ = now;
	_tmp2_ = g_date_time_add_minutes (_tmp1_, CLOCKS_ALARM_ITEM_RING_MINUTES);
	_g_date_time_unref0 (self->priv->ring_end_time);
	self->priv->ring_end_time = _tmp2_;
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_RINGING);
	g_signal_emit_by_name (self, "ring");
}


void clocks_alarm_item_snooze (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_SNOOZING);
}


void clocks_alarm_item_stop (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	_tmp1_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp1_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}


static gboolean clocks_alarm_item_compare_with_item (ClocksAlarmItem* self, ClocksAlarmItem* i) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_ = NULL;
	ClocksAlarmItem* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	_tmp2_ = self->priv->alarm_time;
	_tmp3_ = i;
	_tmp4_ = _tmp3_->priv->alarm_time;
	_tmp5_ = g_date_time_compare (_tmp2_, _tmp4_);
	if (_tmp5_ == 0) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = clocks_alarm_item_get_active (self);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ClocksAlarmItem* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = i;
		_tmp9_ = clocks_alarm_item_get_active (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean clocks_alarm_item_check_duplicate_alarm (ClocksAlarmItem* self, GList* alarms_list) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	clocks_alarm_item_update_alarm_time (self);
	_tmp0_ = alarms_list;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp0_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksAlarmItem* _tmp1_ = NULL;
			ClocksAlarmItem* i = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksAlarmItem*) i_it->data);
			i = _tmp1_;
			{
				ClocksAlarmItem* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = clocks_alarm_item_compare_with_item (self, _tmp2_);
				if (_tmp3_) {
					result = TRUE;
					_g_object_unref0 (i);
					return result;
				}
				_g_object_unref0 (i);
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean clocks_alarm_item_tick (ClocksAlarmItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ClocksAlarmItemState last_state = 0;
	ClocksAlarmItemState _tmp2_ = 0;
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp3_ = NULL;
	GDateTime* now = NULL;
	ClocksUtilsWallClock* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	GDateTime* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	ClocksAlarmItemState _tmp9_ = 0;
	gboolean _tmp13_ = FALSE;
	ClocksAlarmItemState _tmp14_ = 0;
	gboolean _tmp19_ = FALSE;
	ClocksAlarmItemState _tmp20_ = 0;
	ClocksAlarmItemState _tmp25_ = 0;
	ClocksAlarmItemState _tmp26_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_state;
	last_state = _tmp2_;
	_tmp3_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp3_;
	_tmp4_ = wallclock;
	_tmp5_ = clocks_utils_wall_clock_get_date_time (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_date_time_ref0 (_tmp6_);
	now = _tmp7_;
	_tmp9_ = self->priv->_state;
	if (_tmp9_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
		GDateTime* _tmp10_ = NULL;
		GDateTime* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp10_ = now;
		_tmp11_ = self->priv->ring_end_time;
		_tmp12_ = g_date_time_compare (_tmp10_, _tmp11_);
		_tmp8_ = _tmp12_ > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		clocks_alarm_item_stop (self);
	}
	_tmp14_ = self->priv->_state;
	if (_tmp14_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		GDateTime* _tmp15_ = NULL;
		GDateTime* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp15_ = now;
		_tmp16_ = self->priv->snooze_time;
		_tmp17_ = g_date_time_compare (_tmp15_, _tmp16_);
		_tmp13_ = _tmp17_ > 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GDateTime* _tmp18_ = NULL;
		_tmp18_ = now;
		clocks_alarm_item_start_ringing (self, _tmp18_);
	}
	_tmp20_ = self->priv->_state;
	if (_tmp20_ == CLOCKS_ALARM_ITEM_STATE_READY) {
		GDateTime* _tmp21_ = NULL;
		GDateTime* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		_tmp21_ = now;
		_tmp22_ = self->priv->alarm_time;
		_tmp23_ = g_date_time_compare (_tmp21_, _tmp22_);
		_tmp19_ = _tmp23_ > 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GDateTime* _tmp24_ = NULL;
		_tmp24_ = now;
		clocks_alarm_item_start_ringing (self, _tmp24_);
		clocks_alarm_item_update_alarm_time (self);
	}
	_tmp25_ = self->priv->_state;
	_tmp26_ = last_state;
	result = _tmp25_ != _tmp26_;
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}


static void clocks_alarm_item_real_get_thumb_properties (ClocksContentItem* base, gchar** text, gchar** subtext, GdkPixbuf** pixbuf, gchar** css_class) {
	ClocksAlarmItem * self;
	gchar* _vala_text = NULL;
	gchar* _vala_subtext = NULL;
	GdkPixbuf* _vala_pixbuf = NULL;
	gchar* _vala_css_class = NULL;
	ClocksAlarmItemState _tmp0_ = 0;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp1_ = clocks_alarm_item_get_snooze_time_label (self);
		_tmp2_ = _tmp1_;
		_g_free0 (_vala_text);
		_vala_text = _tmp2_;
		_tmp3_ = clocks_alarm_item_get_time_label (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("(%s)", _tmp5_);
		_g_free0 (_vala_subtext);
		_vala_subtext = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp7_ = g_strdup ("snoozing");
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp7_;
	} else {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gchar* _tmp15_ = NULL;
		_tmp8_ = clocks_alarm_item_get_time_label (self);
		_tmp9_ = _tmp8_;
		_g_free0 (_vala_text);
		_vala_text = _tmp9_;
		_tmp10_ = clocks_alarm_item_get_repeat_label (self);
		_tmp11_ = _tmp10_;
		_g_free0 (_vala_subtext);
		_vala_subtext = _tmp11_;
		_tmp13_ = clocks_alarm_item_get_active (self);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			_tmp12_ = "active";
		} else {
			_tmp12_ = "inactive";
		}
		_tmp15_ = g_strdup (_tmp12_);
		_g_free0 (_vala_css_class);
		_vala_css_class = _tmp15_;
	}
	_g_object_unref0 (_vala_pixbuf);
	_vala_pixbuf = NULL;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (subtext) {
		*subtext = _vala_subtext;
	} else {
		_g_free0 (_vala_subtext);
	}
	if (pixbuf) {
		*pixbuf = _vala_pixbuf;
	} else {
		_g_object_unref0 (_vala_pixbuf);
	}
	if (css_class) {
		*css_class = _vala_css_class;
	} else {
		_g_free0 (_vala_css_class);
	}
}


void clocks_alarm_item_serialize (ClocksAlarmItem* self, GVariantBuilder* builder) {
	GVariantBuilder* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantType* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariantBuilder* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	GVariantBuilder* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_ = NULL;
	GVariantBuilder* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_ = NULL;
	GVariantBuilder* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariantBuilder* _tmp25_ = NULL;
	ClocksUtilsWeekdays* _tmp26_ = NULL;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_ = NULL;
	GVariantBuilder* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = g_variant_type_new ("a{sv}");
	_tmp2_ = _tmp1_;
	g_variant_builder_open (_tmp0_, _tmp2_);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = builder;
	_tmp4_ = clocks_content_item_get_name ((ClocksContentItem*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_variant_builder_add (_tmp3_, "{sv}", "name", _tmp7_, NULL);
	_g_variant_unref0 (_tmp7_);
	_tmp8_ = builder;
	_tmp9_ = self->priv->_id;
	_tmp10_ = g_variant_new_string (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_variant_builder_add (_tmp8_, "{sv}", "id", _tmp11_, NULL);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = builder;
	_tmp13_ = clocks_alarm_item_get_active (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_variant_new_boolean (_tmp14_);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	g_variant_builder_add (_tmp12_, "{sv}", "active", _tmp16_, NULL);
	_g_variant_unref0 (_tmp16_);
	_tmp17_ = builder;
	_tmp18_ = self->priv->_hour;
	_tmp19_ = g_variant_new_int32 ((gint32) _tmp18_);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	g_variant_builder_add (_tmp17_, "{sv}", "hour", _tmp20_, NULL);
	_g_variant_unref0 (_tmp20_);
	_tmp21_ = builder;
	_tmp22_ = self->priv->_minute;
	_tmp23_ = g_variant_new_int32 ((gint32) _tmp22_);
	g_variant_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	g_variant_builder_add (_tmp21_, "{sv}", "minute", _tmp24_, NULL);
	_g_variant_unref0 (_tmp24_);
	_tmp25_ = builder;
	_tmp26_ = self->priv->_days;
	_tmp27_ = clocks_utils_weekdays_serialize (_tmp26_);
	_tmp28_ = _tmp27_;
	g_variant_builder_add (_tmp25_, "{sv}", "days", _tmp28_, NULL);
	_g_variant_unref0 (_tmp28_);
	_tmp29_ = builder;
	g_variant_builder_close (_tmp29_);
}


ClocksAlarmItem* clocks_alarm_item_deserialize (GVariant* alarm_variant) {
	ClocksAlarmItem* result = NULL;
	gchar* name = NULL;
	gchar* id = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	ClocksUtilsWeekdays* days = NULL;
	ClocksUtilsWeekdays* _tmp0_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	const gchar* _tmp58_ = NULL;
	g_return_val_if_fail (alarm_variant != NULL, NULL);
	name = NULL;
	id = NULL;
	active = TRUE;
	hour = -1;
	minute = -1;
	_tmp0_ = clocks_utils_weekdays_new ();
	days = _tmp0_;
	{
		GVariantIter* _v_it = NULL;
		GVariant* _tmp1_ = NULL;
		GVariantIter* _tmp2_ = NULL;
		GVariant* v = NULL;
		_tmp1_ = alarm_variant;
		_tmp2_ = g_variant_iter_new (_tmp1_);
		_v_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_ = NULL;
			GVariant* _tmp4_ = NULL;
			GVariant* _tmp5_ = NULL;
			gchar* key = NULL;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp3_ = _v_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (v);
			v = _tmp4_;
			_tmp5_ = v;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = v;
			_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_variant_get_string (_tmp8_, NULL);
			_tmp10_ = g_strdup (_tmp9_);
			_tmp11_ = _tmp10_;
			_g_variant_unref0 (_tmp8_);
			key = _tmp11_;
			_tmp12_ = key;
			if (g_strcmp0 (_tmp12_, "name") == 0) {
				GVariant* _tmp13_ = NULL;
				GVariant* _tmp14_ = NULL;
				GVariant* _tmp15_ = NULL;
				GVariant* _tmp16_ = NULL;
				GVariant* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				_tmp13_ = v;
				_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_variant_get_child_value (_tmp15_, (gsize) 0);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_variant_get_string (_tmp17_, NULL);
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (name);
				name = _tmp19_;
				_g_variant_unref0 (_tmp17_);
				_g_variant_unref0 (_tmp15_);
			} else {
				const gchar* _tmp20_ = NULL;
				_tmp20_ = key;
				if (g_strcmp0 (_tmp20_, "id") == 0) {
					GVariant* _tmp21_ = NULL;
					GVariant* _tmp22_ = NULL;
					GVariant* _tmp23_ = NULL;
					GVariant* _tmp24_ = NULL;
					GVariant* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					_tmp21_ = v;
					_tmp22_ = g_variant_get_child_value (_tmp21_, (gsize) 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_variant_get_child_value (_tmp23_, (gsize) 0);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_variant_get_string (_tmp25_, NULL);
					_tmp27_ = g_strdup (_tmp26_);
					_g_free0 (id);
					id = _tmp27_;
					_g_variant_unref0 (_tmp25_);
					_g_variant_unref0 (_tmp23_);
				} else {
					const gchar* _tmp28_ = NULL;
					_tmp28_ = key;
					if (g_strcmp0 (_tmp28_, "active") == 0) {
						GVariant* _tmp29_ = NULL;
						GVariant* _tmp30_ = NULL;
						GVariant* _tmp31_ = NULL;
						GVariant* _tmp32_ = NULL;
						GVariant* _tmp33_ = NULL;
						gboolean _tmp34_ = FALSE;
						_tmp29_ = v;
						_tmp30_ = g_variant_get_child_value (_tmp29_, (gsize) 1);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_variant_get_child_value (_tmp31_, (gsize) 0);
						_tmp33_ = _tmp32_;
						_tmp34_ = g_variant_get_boolean (_tmp33_);
						active = _tmp34_;
						_g_variant_unref0 (_tmp33_);
						_g_variant_unref0 (_tmp31_);
					} else {
						const gchar* _tmp35_ = NULL;
						_tmp35_ = key;
						if (g_strcmp0 (_tmp35_, "hour") == 0) {
							GVariant* _tmp36_ = NULL;
							GVariant* _tmp37_ = NULL;
							GVariant* _tmp38_ = NULL;
							GVariant* _tmp39_ = NULL;
							GVariant* _tmp40_ = NULL;
							gint32 _tmp41_ = 0;
							_tmp36_ = v;
							_tmp37_ = g_variant_get_child_value (_tmp36_, (gsize) 1);
							_tmp38_ = _tmp37_;
							_tmp39_ = g_variant_get_child_value (_tmp38_, (gsize) 0);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_variant_get_int32 (_tmp40_);
							hour = (gint) _tmp41_;
							_g_variant_unref0 (_tmp40_);
							_g_variant_unref0 (_tmp38_);
						} else {
							const gchar* _tmp42_ = NULL;
							_tmp42_ = key;
							if (g_strcmp0 (_tmp42_, "minute") == 0) {
								GVariant* _tmp43_ = NULL;
								GVariant* _tmp44_ = NULL;
								GVariant* _tmp45_ = NULL;
								GVariant* _tmp46_ = NULL;
								GVariant* _tmp47_ = NULL;
								gint32 _tmp48_ = 0;
								_tmp43_ = v;
								_tmp44_ = g_variant_get_child_value (_tmp43_, (gsize) 1);
								_tmp45_ = _tmp44_;
								_tmp46_ = g_variant_get_child_value (_tmp45_, (gsize) 0);
								_tmp47_ = _tmp46_;
								_tmp48_ = g_variant_get_int32 (_tmp47_);
								minute = (gint) _tmp48_;
								_g_variant_unref0 (_tmp47_);
								_g_variant_unref0 (_tmp45_);
							} else {
								const gchar* _tmp49_ = NULL;
								_tmp49_ = key;
								if (g_strcmp0 (_tmp49_, "days") == 0) {
									GVariant* _tmp50_ = NULL;
									GVariant* _tmp51_ = NULL;
									GVariant* _tmp52_ = NULL;
									GVariant* _tmp53_ = NULL;
									GVariant* _tmp54_ = NULL;
									ClocksUtilsWeekdays* _tmp55_ = NULL;
									_tmp50_ = v;
									_tmp51_ = g_variant_get_child_value (_tmp50_, (gsize) 1);
									_tmp52_ = _tmp51_;
									_tmp53_ = g_variant_get_child_value (_tmp52_, (gsize) 0);
									_tmp54_ = _tmp53_;
									_tmp55_ = clocks_utils_weekdays_deserialize (_tmp54_);
									_clocks_utils_weekdays_unref0 (days);
									days = _tmp55_;
									_g_variant_unref0 (_tmp54_);
									_g_variant_unref0 (_tmp52_);
								}
							}
						}
					}
				}
			}
			_g_free0 (key);
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	_tmp58_ = name;
	if (_tmp58_ != NULL) {
		gint _tmp59_ = 0;
		_tmp59_ = hour;
		_tmp57_ = _tmp59_ >= 0;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		gint _tmp60_ = 0;
		_tmp60_ = minute;
		_tmp56_ = _tmp60_ >= 0;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gboolean _tmp63_ = FALSE;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		ClocksUtilsWeekdays* _tmp66_ = NULL;
		ClocksAlarmItem* _tmp67_ = NULL;
		_tmp61_ = id;
		_tmp62_ = name;
		_tmp63_ = active;
		_tmp64_ = hour;
		_tmp65_ = minute;
		_tmp66_ = days;
		_tmp67_ = clocks_alarm_item_new_with_data (_tmp61_, _tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_);
		result = _tmp67_;
		_clocks_utils_weekdays_unref0 (days);
		_g_free0 (id);
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		_tmp69_ = name;
		if (_tmp69_ != NULL) {
			const gchar* _tmp70_ = NULL;
			_tmp70_ = name;
			_tmp68_ = _tmp70_;
		} else {
			_tmp68_ = "name missing";
		}
		g_warning ("alarm.vala:276: Invalid alarm %s", _tmp68_);
	}
	result = NULL;
	_clocks_utils_weekdays_unref0 (days);
	_g_free0 (id);
	_g_free0 (name);
	return result;
}


static const gchar* clocks_alarm_item_real_get_title_icon (ClocksContentItem* base) {
	const gchar* result;
	ClocksAlarmItem* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_title_icon;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_item_real_set_title_icon (ClocksContentItem* base, const gchar* value) {
	ClocksAlarmItem* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title_icon);
	self->priv->_title_icon = _tmp1_;
	g_object_notify ((GObject *) self, "title-icon");
}


static gboolean clocks_alarm_item_real_get_selectable (ClocksContentItem* base) {
	gboolean result;
	ClocksAlarmItem* self;
	gboolean _tmp0_ = FALSE;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_selectable;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_item_real_set_selectable (ClocksContentItem* base, gboolean value) {
	ClocksAlarmItem* self;
	gboolean _tmp0_ = FALSE;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = value;
	self->priv->_selectable = _tmp0_;
	g_object_notify ((GObject *) self, "selectable");
}


const gchar* clocks_alarm_item_get_id (ClocksAlarmItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_id (ClocksAlarmItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


static const gchar* clocks_alarm_item_real_get_name (ClocksContentItem* base) {
	const gchar* result;
	ClocksAlarmItem* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_item_real_set_name (ClocksContentItem* base, const gchar* value) {
	ClocksAlarmItem* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksAlarmItem*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	clocks_alarm_item_setup_bell (self);
	g_object_notify ((GObject *) self, "name");
}


gint clocks_alarm_item_get_hour (ClocksAlarmItem* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_hour;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_hour (ClocksAlarmItem* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hour = _tmp0_;
	g_object_notify ((GObject *) self, "hour");
}


gint clocks_alarm_item_get_minute (ClocksAlarmItem* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_minute;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_minute (ClocksAlarmItem* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_minute = _tmp0_;
	g_object_notify ((GObject *) self, "minute");
}


ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self) {
	ClocksUtilsWeekdays* result;
	ClocksUtilsWeekdays* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	result = _tmp0_;
	return result;
}


static gpointer _clocks_utils_weekdays_ref0 (gpointer self) {
	return self ? clocks_utils_weekdays_ref (self) : NULL;
}


void clocks_alarm_item_set_days (ClocksAlarmItem* self, ClocksUtilsWeekdays* value) {
	ClocksUtilsWeekdays* _tmp0_ = NULL;
	ClocksUtilsWeekdays* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _clocks_utils_weekdays_ref0 (_tmp0_);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	self->priv->_days = _tmp1_;
	g_object_notify ((GObject *) self, "days");
}


gchar* clocks_alarm_item_get_repeat_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWeekdays* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	_tmp1_ = clocks_utils_weekdays_get_label (_tmp0_);
	result = _tmp1_;
	return result;
}


ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self) {
	ClocksAlarmItemState result;
	ClocksAlarmItemState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_item_set_state (ClocksAlarmItem* self, ClocksAlarmItemState value) {
	ClocksAlarmItemState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->alarm_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar* clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->snooze_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_active (ClocksAlarmItem* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_active;
	if (_tmp0_ != _tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = value;
		self->priv->_active = _tmp2_;
		_tmp3_ = self->priv->_active;
		if (_tmp3_) {
			clocks_alarm_item_reset (self);
		} else {
			ClocksAlarmItemState _tmp4_ = 0;
			_tmp4_ = self->priv->_state;
			if (_tmp4_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
				clocks_alarm_item_stop (self);
			}
		}
	}
	g_object_notify ((GObject *) self, "active");
}


static void clocks_alarm_item_real_ring (ClocksAlarmItem* self) {
	GApplication* app = NULL;
	GApplication* _tmp0_ = NULL;
	GApplication* _tmp1_ = NULL;
	GNotification* _tmp2_ = NULL;
	ClocksUtilsBell* _tmp3_ = NULL;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = self->priv->notification;
	g_application_send_notification (app, NULL, _tmp2_);
	_tmp3_ = self->priv->bell;
	clocks_utils_bell_ring (_tmp3_);
	_g_object_unref0 (app);
}


static void clocks_alarm_item_class_init (ClocksAlarmItemClass * klass) {
	clocks_alarm_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmItemPrivate));
	((ClocksAlarmItemClass *) klass)->ring = clocks_alarm_item_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TITLE_ICON, g_param_spec_string ("title-icon", "title-icon", "title-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SELECTABLE, g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS, clocks_utils_param_spec_weekdays ("days", "days", "days", CLOCKS_UTILS_TYPE_WEEKDAYS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_REPEAT_LABEL, g_param_spec_string ("repeat-label", "repeat-label", "repeat-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_STATE, g_param_spec_enum ("state", "state", "state", CLOCKS_ALARM_ITEM_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_LABEL, g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL, g_param_spec_string ("snooze-time-label", "snooze-time-label", "snooze-time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("ring", CLOCKS_ALARM_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksAlarmItemClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_item_clocks_content_item_interface_init (ClocksContentItemIface * iface) {
	clocks_alarm_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_thumb_properties = (void (*)(ClocksContentItem*, gchar**, gchar**, GdkPixbuf**, gchar**)) clocks_alarm_item_real_get_thumb_properties;
	iface->get_title_icon = clocks_alarm_item_real_get_title_icon;
	iface->set_title_icon = clocks_alarm_item_real_set_title_icon;
	iface->get_selectable = clocks_alarm_item_real_get_selectable;
	iface->set_selectable = clocks_alarm_item_real_set_selectable;
	iface->get_name = clocks_alarm_item_real_get_name;
	iface->set_name = clocks_alarm_item_real_set_name;
}


static void clocks_alarm_item_instance_init (ClocksAlarmItem * self) {
	self->priv = CLOCKS_ALARM_ITEM_GET_PRIVATE (self);
	self->priv->_title_icon = NULL;
	self->priv->_selectable = TRUE;
}


static void clocks_alarm_item_finalize (GObject* obj) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	_g_free0 (self->priv->_title_icon);
	_g_free0 (self->priv->_id);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	_g_free0 (self->priv->_name);
	_g_date_time_unref0 (self->priv->alarm_time);
	_g_date_time_unref0 (self->priv->snooze_time);
	_g_date_time_unref0 (self->priv->ring_end_time);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (clocks_alarm_item_parent_class)->finalize (obj);
}


GType clocks_alarm_item_get_type (void) {
	static volatile gsize clocks_alarm_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmItem), 0, (GInstanceInitFunc) clocks_alarm_item_instance_init, NULL };
		static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_alarm_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_alarm_item_type_id;
		clocks_alarm_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmItem", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_alarm_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
		g_once_init_leave (&clocks_alarm_item_type_id__volatile, clocks_alarm_item_type_id);
	}
	return clocks_alarm_item_type_id__volatile;
}


static void _vala_clocks_alarm_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_TITLE_ICON:
		g_value_set_string (value, clocks_content_item_get_title_icon ((ClocksContentItem*) self));
		break;
		case CLOCKS_ALARM_ITEM_SELECTABLE:
		g_value_set_boolean (value, clocks_content_item_get_selectable ((ClocksContentItem*) self));
		break;
		case CLOCKS_ALARM_ITEM_ID:
		g_value_set_string (value, clocks_alarm_item_get_id (self));
		break;
		case CLOCKS_ALARM_ITEM_NAME:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_ALARM_ITEM_HOUR:
		g_value_set_int (value, clocks_alarm_item_get_hour (self));
		break;
		case CLOCKS_ALARM_ITEM_MINUTE:
		g_value_set_int (value, clocks_alarm_item_get_minute (self));
		break;
		case CLOCKS_ALARM_ITEM_DAYS:
		clocks_utils_value_set_weekdays (value, clocks_alarm_item_get_days (self));
		break;
		case CLOCKS_ALARM_ITEM_REPEAT_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_repeat_label (self));
		break;
		case CLOCKS_ALARM_ITEM_STATE:
		g_value_set_enum (value, clocks_alarm_item_get_state (self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_snooze_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE:
		g_value_set_boolean (value, clocks_alarm_item_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_TITLE_ICON:
		clocks_content_item_set_title_icon ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_SELECTABLE:
		clocks_content_item_set_selectable ((ClocksContentItem*) self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_ITEM_ID:
		clocks_alarm_item_set_id (self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_NAME:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_HOUR:
		clocks_alarm_item_set_hour (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_MINUTE:
		clocks_alarm_item_set_minute (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_DAYS:
		clocks_alarm_item_set_days (self, clocks_utils_value_get_weekdays (value));
		break;
		case CLOCKS_ALARM_ITEM_STATE:
		clocks_alarm_item_set_state (self, g_value_get_enum (value));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE:
		clocks_alarm_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _____lambda39_ (ClocksAlarmSetupDialog* self) {
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}


static void ______lambda39__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_____lambda39_ ((ClocksAlarmSetupDialog*) self);
}


ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type, GtkWindow* parent, ClocksAlarmItem* alarm, GList* alarms) {
	ClocksAlarmSetupDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkGrid* _tmp10_ = NULL;
	ClocksUtilsWallClock* _tmp11_ = NULL;
	ClocksUtilsWallClock* _tmp12_ = NULL;
	ClocksUtilsWallClockFormat _tmp13_ = 0;
	ClocksUtilsWallClockFormat _tmp14_ = 0;
	ClocksAmPmToggleButton* _tmp15_ = NULL;
	ClocksUtilsWallClockFormat _tmp16_ = 0;
	GtkToggleButton** _tmp26_ = NULL;
	ClocksUtilsWeekdaysDay first_weekday = 0;
	ClocksUtilsWeekdaysDay _tmp43_ = 0;
	ClocksAlarmItem* _tmp53_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp1_ = alarm;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("Edit Alarm");
		_tmp0_ = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("New Alarm");
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = parent;
	self = (ClocksAlarmSetupDialog*) g_object_new (object_type, "transient-for", _tmp4_, "title", _tmp0_, "use-header-bar", 1, NULL);
	__g_list_free__g_object_unref0_0 (self->priv->alarms_list);
	self->priv->alarms_list = NULL;
	_tmp5_ = alarms;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp5_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksAlarmItem* i = NULL;
			i = (ClocksAlarmItem*) i_it->data;
			{
				ClocksAlarmItem* _tmp6_ = NULL;
				ClocksAlarmItem* _tmp7_ = NULL;
				_tmp6_ = i;
				_tmp7_ = alarm;
				if (_tmp6_ != _tmp7_) {
					ClocksAlarmItem* _tmp8_ = NULL;
					ClocksAlarmItem* _tmp9_ = NULL;
					_tmp8_ = i;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					self->priv->alarms_list = g_list_prepend (self->priv->alarms_list, _tmp9_);
				}
			}
		}
	}
	_tmp10_ = self->priv->time_grid;
	gtk_widget_set_direction ((GtkWidget*) _tmp10_, GTK_TEXT_DIR_LTR);
	_tmp11_ = clocks_utils_wall_clock_get_default ();
	_tmp12_ = _tmp11_;
	_tmp13_ = clocks_utils_wall_clock_get_format (_tmp12_);
	_tmp14_ = _tmp13_;
	self->priv->format = _tmp14_;
	_g_object_unref0 (_tmp12_);
	_tmp15_ = clocks_am_pm_toggle_button_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->am_pm_button);
	self->priv->am_pm_button = _tmp15_;
	_tmp16_ = self->priv->format;
	if (_tmp16_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR) {
		GtkSpinButton* _tmp17_ = NULL;
		_tmp17_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp17_, (gdouble) 0, (gdouble) 23);
	} else {
		GtkSpinButton* _tmp18_ = NULL;
		GtkSizeGroup* _tmp19_ = NULL;
		ClocksAmPmToggleButton* _tmp20_ = NULL;
		GtkAlignment* _tmp21_ = NULL;
		GtkAlignment* _tmp22_ = NULL;
		GtkWidget* _tmp23_ = NULL;
		GtkAlignment* _tmp24_ = NULL;
		ClocksAmPmToggleButton* _tmp25_ = NULL;
		_tmp18_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp18_, (gdouble) 1, (gdouble) 12);
		_tmp19_ = self->priv->am_pm_sizegroup;
		_tmp20_ = self->priv->am_pm_button;
		gtk_size_group_add_widget (_tmp19_, (GtkWidget*) _tmp20_);
		_tmp21_ = self->priv->am_pm_alignment;
		_tmp22_ = self->priv->am_pm_alignment;
		_tmp23_ = gtk_bin_get_child ((GtkBin*) _tmp22_);
		gtk_container_remove ((GtkContainer*) _tmp21_, _tmp23_);
		_tmp24_ = self->priv->am_pm_alignment;
		_tmp25_ = self->priv->am_pm_button;
		gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	}
	_tmp26_ = g_new0 (GtkToggleButton*, 7 + 1);
	self->priv->day_buttons = (_vala_array_free (self->priv->day_buttons, self->priv->day_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->day_buttons = _tmp26_;
	self->priv->day_buttons_length1 = 7;
	self->priv->_day_buttons_size_ = self->priv->day_buttons_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp29_ = 0;
				GtkToggleButton* button = NULL;
				gint _tmp30_ = 0;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				GtkToggleButton* _tmp33_ = NULL;
				GtkToggleButton* _tmp34_ = NULL;
				GtkToggleButton** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				GtkToggleButton* _tmp37_ = NULL;
				GtkToggleButton* _tmp38_ = NULL;
				GtkToggleButton* _tmp39_ = NULL;
				GtkToggleButton** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gint _tmp41_ = 0;
				GtkToggleButton* _tmp42_ = NULL;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = i;
				if (!(_tmp29_ < 7)) {
					break;
				}
				_tmp30_ = i;
				_tmp31_ = clocks_utils_weekdays_abbreviation ((ClocksUtilsWeekdaysDay) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp32_);
				g_object_ref_sink (_tmp33_);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp32_);
				button = _tmp34_;
				_tmp35_ = self->priv->day_buttons;
				_tmp35__length1 = self->priv->day_buttons_length1;
				_tmp36_ = i;
				_tmp37_ = button;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_g_object_unref0 (_tmp35_[_tmp36_]);
				_tmp35_[_tmp36_] = _tmp38_;
				_tmp39_ = _tmp35_[_tmp36_];
				_tmp40_ = self->priv->day_buttons;
				_tmp40__length1 = self->priv->day_buttons_length1;
				_tmp41_ = i;
				_tmp42_ = _tmp40_[_tmp41_];
				g_signal_connect_object (_tmp42_, "toggled", (GCallback) ______lambda39__gtk_toggle_button_toggled, self, 0);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp43_ = clocks_utils_weekdays_get_first_weekday ();
	first_weekday = _tmp43_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				gint _tmp46_ = 0;
				ClocksUtilsWeekdaysDay day_number = 0;
				ClocksUtilsWeekdaysDay _tmp47_ = 0;
				gint _tmp48_ = 0;
				GtkBox* _tmp49_ = NULL;
				GtkToggleButton** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				ClocksUtilsWeekdaysDay _tmp51_ = 0;
				GtkToggleButton* _tmp52_ = NULL;
				if (!_tmp44_) {
					gint _tmp45_ = 0;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp46_ = i;
				if (!(_tmp46_ < 7)) {
					break;
				}
				_tmp47_ = first_weekday;
				_tmp48_ = i;
				day_number = (_tmp47_ + _tmp48_) % 7;
				_tmp49_ = self->priv->day_buttons_box;
				_tmp50_ = self->priv->day_buttons;
				_tmp50__length1 = self->priv->day_buttons_length1;
				_tmp51_ = day_number;
				_tmp52_ = _tmp50_[_tmp51_];
				gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp52_, TRUE, TRUE, (guint) 0);
			}
		}
	}
	_tmp53_ = alarm;
	clocks_alarm_setup_dialog_set_from_alarm (self, _tmp53_);
	return self;
}


ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (GtkWindow* parent, ClocksAlarmItem* alarm, GList* alarms) {
	return clocks_alarm_setup_dialog_construct (CLOCKS_ALARM_TYPE_SETUP_DIALOG, parent, alarm, alarms);
}


void clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm) {
	gchar* name = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	ClocksUtilsWeekdays* days = NULL;
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksUtilsWallClockFormat _tmp28_ = 0;
	GtkSpinButton* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	GtkSpinButton* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	GtkEntry* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	ClocksUtilsWeekdays* _tmp40_ = NULL;
	GtkSwitch* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = alarm;
	if (_tmp0_ == NULL) {
		ClocksUtilsWallClock* wc = NULL;
		ClocksUtilsWallClock* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		ClocksUtilsWallClock* _tmp4_ = NULL;
		GDateTime* _tmp5_ = NULL;
		GDateTime* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		ClocksUtilsWallClock* _tmp8_ = NULL;
		GDateTime* _tmp9_ = NULL;
		GDateTime* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp1_ = clocks_utils_wall_clock_get_default ();
		wc = _tmp1_;
		_tmp2_ = _ ("Alarm");
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (name);
		name = _tmp3_;
		_tmp4_ = wc;
		_tmp5_ = clocks_utils_wall_clock_get_date_time (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_get_hour (_tmp6_);
		hour = _tmp7_;
		_tmp8_ = wc;
		_tmp9_ = clocks_utils_wall_clock_get_date_time (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_get_minute (_tmp10_);
		minute = _tmp11_;
		days = NULL;
		active = TRUE;
		_g_object_unref0 (wc);
	} else {
		ClocksAlarmItem* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		ClocksAlarmItem* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		ClocksAlarmItem* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		ClocksAlarmItem* _tmp22_ = NULL;
		ClocksUtilsWeekdays* _tmp23_ = NULL;
		ClocksUtilsWeekdays* _tmp24_ = NULL;
		ClocksAlarmItem* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		_tmp12_ = alarm;
		_tmp13_ = clocks_content_item_get_name ((ClocksContentItem*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (name);
		name = _tmp15_;
		_tmp16_ = alarm;
		_tmp17_ = clocks_alarm_item_get_hour (_tmp16_);
		_tmp18_ = _tmp17_;
		hour = _tmp18_;
		_tmp19_ = alarm;
		_tmp20_ = clocks_alarm_item_get_minute (_tmp19_);
		_tmp21_ = _tmp20_;
		minute = _tmp21_;
		_tmp22_ = alarm;
		_tmp23_ = clocks_alarm_item_get_days (_tmp22_);
		_tmp24_ = _tmp23_;
		days = _tmp24_;
		_tmp25_ = alarm;
		_tmp26_ = clocks_alarm_item_get_active (_tmp25_);
		_tmp27_ = _tmp26_;
		active = _tmp27_;
	}
	_tmp28_ = self->priv->format;
	if (_tmp28_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		gint _tmp29_ = 0;
		gint _tmp33_ = 0;
		_tmp29_ = hour;
		if (_tmp29_ < 12) {
			ClocksAmPmToggleButton* _tmp30_ = NULL;
			_tmp30_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp30_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM);
		} else {
			ClocksAmPmToggleButton* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			_tmp31_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp31_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM);
			_tmp32_ = hour;
			hour = _tmp32_ - 12;
		}
		_tmp33_ = hour;
		if (_tmp33_ == 0) {
			hour = 12;
		}
	}
	_tmp34_ = self->priv->h_spinbutton;
	_tmp35_ = hour;
	gtk_spin_button_set_value (_tmp34_, (gdouble) _tmp35_);
	_tmp36_ = self->priv->m_spinbutton;
	_tmp37_ = minute;
	gtk_spin_button_set_value (_tmp36_, (gdouble) _tmp37_);
	_tmp38_ = self->priv->name_entry;
	_tmp39_ = name;
	gtk_entry_set_text (_tmp38_, _tmp39_);
	_tmp40_ = days;
	if (_tmp40_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp41_ = FALSE;
				_tmp41_ = TRUE;
				while (TRUE) {
					gint _tmp43_ = 0;
					GtkToggleButton** _tmp44_ = NULL;
					gint _tmp44__length1 = 0;
					gint _tmp45_ = 0;
					GtkToggleButton* _tmp46_ = NULL;
					ClocksUtilsWeekdays* _tmp47_ = NULL;
					gint _tmp48_ = 0;
					gboolean _tmp49_ = FALSE;
					if (!_tmp41_) {
						gint _tmp42_ = 0;
						_tmp42_ = i;
						i = _tmp42_ + 1;
					}
					_tmp41_ = FALSE;
					_tmp43_ = i;
					if (!(_tmp43_ < 7)) {
						break;
					}
					_tmp44_ = self->priv->day_buttons;
					_tmp44__length1 = self->priv->day_buttons_length1;
					_tmp45_ = i;
					_tmp46_ = _tmp44_[_tmp45_];
					_tmp47_ = days;
					_tmp48_ = i;
					_tmp49_ = clocks_utils_weekdays_get (_tmp47_, (ClocksUtilsWeekdaysDay) _tmp48_);
					gtk_toggle_button_set_active (_tmp46_, _tmp49_);
				}
			}
		}
	}
	_tmp50_ = self->priv->active_switch;
	_tmp51_ = active;
	gtk_switch_set_active (_tmp50_, _tmp51_);
	_g_free0 (name);
}


void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm) {
	gchar* name = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean active = FALSE;
	GtkSwitch* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint hour = 0;
	GtkSpinButton* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint minute = 0;
	GtkSpinButton* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	ClocksUtilsWallClockFormat _tmp10_ = 0;
	ClocksAlarmItem* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	ClocksAlarmItem* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	ClocksAlarmItem* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ClocksAlarmItem* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_tmp0_ = self->priv->name_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->active_switch;
	_tmp4_ = gtk_switch_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	active = _tmp5_;
	_tmp6_ = self->priv->h_spinbutton;
	_tmp7_ = gtk_spin_button_get_value_as_int (_tmp6_);
	hour = _tmp7_;
	_tmp8_ = self->priv->m_spinbutton;
	_tmp9_ = gtk_spin_button_get_value_as_int (_tmp8_);
	minute = _tmp9_;
	_tmp10_ = self->priv->format;
	if (_tmp10_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		ClocksAmPmToggleButtonAmPm choice = 0;
		ClocksAmPmToggleButton* _tmp11_ = NULL;
		ClocksAmPmToggleButtonAmPm _tmp12_ = 0;
		ClocksAmPmToggleButtonAmPm _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		ClocksAmPmToggleButtonAmPm _tmp15_ = 0;
		_tmp11_ = self->priv->am_pm_button;
		_tmp12_ = clocks_am_pm_toggle_button_get_choice (_tmp11_);
		_tmp13_ = _tmp12_;
		choice = _tmp13_;
		_tmp15_ = choice;
		if (_tmp15_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM) {
			gint _tmp16_ = 0;
			_tmp16_ = hour;
			_tmp14_ = _tmp16_ == 12;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			hour = 0;
		} else {
			gboolean _tmp17_ = FALSE;
			ClocksAmPmToggleButtonAmPm _tmp18_ = 0;
			_tmp18_ = choice;
			if (_tmp18_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM) {
				gint _tmp19_ = 0;
				_tmp19_ = hour;
				_tmp17_ = _tmp19_ != 12;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				gint _tmp20_ = 0;
				_tmp20_ = hour;
				hour = _tmp20_ + 12;
			}
		}
	}
	_tmp21_ = alarm;
	_tmp22_ = name;
	clocks_content_item_set_name ((ClocksContentItem*) _tmp21_, _tmp22_);
	_tmp23_ = alarm;
	_tmp24_ = active;
	clocks_alarm_item_set_active (_tmp23_, _tmp24_);
	_tmp25_ = alarm;
	_tmp26_ = hour;
	clocks_alarm_item_set_hour (_tmp25_, _tmp26_);
	_tmp27_ = alarm;
	_tmp28_ = minute;
	clocks_alarm_item_set_minute (_tmp27_, _tmp28_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp31_ = 0;
				ClocksAlarmItem* _tmp32_ = NULL;
				ClocksUtilsWeekdays* _tmp33_ = NULL;
				ClocksUtilsWeekdays* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				GtkToggleButton** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				GtkToggleButton* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				if (!_tmp29_) {
					gint _tmp30_ = 0;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = i;
				if (!(_tmp31_ < 7)) {
					break;
				}
				_tmp32_ = alarm;
				_tmp33_ = clocks_alarm_item_get_days (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = i;
				_tmp36_ = self->priv->day_buttons;
				_tmp36__length1 = self->priv->day_buttons_length1;
				_tmp37_ = i;
				_tmp38_ = _tmp36_[_tmp37_];
				_tmp39_ = gtk_toggle_button_get_active (_tmp38_);
				_tmp40_ = _tmp39_;
				clocks_utils_weekdays_set (_tmp34_, (ClocksUtilsWeekdaysDay) _tmp35_, _tmp40_);
			}
		}
	}
	_g_free0 (name);
}


static void clocks_alarm_setup_dialog_avoid_duplicate_alarm (ClocksAlarmSetupDialog* self) {
	ClocksAlarmItem* alarm = NULL;
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	ClocksAlarmItem* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_item_new ();
	alarm = _tmp0_;
	_tmp1_ = alarm;
	clocks_alarm_setup_dialog_apply_to_alarm (self, _tmp1_);
	_tmp2_ = alarm;
	_tmp3_ = self->priv->alarms_list;
	_tmp4_ = clocks_alarm_item_check_duplicate_alarm (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GtkRevealer* _tmp5_ = NULL;
		gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, FALSE);
		_tmp5_ = self->priv->label_revealer;
		gtk_revealer_set_reveal_child (_tmp5_, TRUE);
	} else {
		GtkRevealer* _tmp6_ = NULL;
		gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, TRUE);
		_tmp6_ = self->priv->label_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, FALSE);
	}
	_g_object_unref0 (alarm);
}


static void clocks_alarm_setup_dialog_spinbuttons_changed (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin_button != NULL);
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}


static void _clocks_alarm_setup_dialog_spinbuttons_changed_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	clocks_alarm_setup_dialog_spinbuttons_changed ((ClocksAlarmSetupDialog*) self, _sender);
}


static void clocks_alarm_setup_dialog_active_changed (ClocksAlarmSetupDialog* self) {
	g_return_if_fail (self != NULL);
	clocks_alarm_setup_dialog_avoid_duplicate_alarm (self);
}


static void _clocks_alarm_setup_dialog_active_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	clocks_alarm_setup_dialog_active_changed ((ClocksAlarmSetupDialog*) self);
}


static gboolean clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button) {
	gboolean result = FALSE;
	GtkSpinButton* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = spin_button;
	_tmp1_ = spin_button;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	_tmp3_ = g_strdup_printf ("%02i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = TRUE;
	return result;
}


static gboolean _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self) {
	gboolean result;
	result = clocks_alarm_setup_dialog_show_leading_zeros ((ClocksAlarmSetupDialog*) self, _sender);
	return result;
}


static void clocks_alarm_setup_dialog_class_init (ClocksAlarmSetupDialogClass * klass) {
	gint ClocksAlarmSetupDialog_private_offset;
	clocks_alarm_setup_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmSetupDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_setup_dialog_finalize;
	ClocksAlarmSetupDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/alarmsetupdialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_grid", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, time_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_spinbutton", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, h_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_spinbutton", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, m_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "active_switch", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, active_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "day_buttons_box", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, day_buttons_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "am_pm_alignment", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, am_pm_alignment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_revealer", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, label_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "am_pm_sizegroup", FALSE, ClocksAlarmSetupDialog_private_offset + G_STRUCT_OFFSET (ClocksAlarmSetupDialogPrivate, am_pm_sizegroup));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "spinbuttons_changed", G_CALLBACK(_clocks_alarm_setup_dialog_spinbuttons_changed_gtk_spin_button_value_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "active_changed", G_CALLBACK(_clocks_alarm_setup_dialog_active_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_leading_zeros", G_CALLBACK(_clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output));
}


static void clocks_alarm_setup_dialog_instance_init (ClocksAlarmSetupDialog * self) {
	self->priv = CLOCKS_ALARM_SETUP_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_alarm_setup_dialog_finalize (GObject* obj) {
	ClocksAlarmSetupDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog);
	_g_object_unref0 (self->priv->time_grid);
	_g_object_unref0 (self->priv->h_spinbutton);
	_g_object_unref0 (self->priv->m_spinbutton);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->am_pm_button);
	self->priv->day_buttons = (_vala_array_free (self->priv->day_buttons, self->priv->day_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->active_switch);
	_g_object_unref0 (self->priv->day_buttons_box);
	_g_object_unref0 (self->priv->am_pm_alignment);
	_g_object_unref0 (self->priv->label_revealer);
	_g_object_unref0 (self->priv->am_pm_sizegroup);
	__g_list_free__g_object_unref0_0 (self->priv->alarms_list);
	G_OBJECT_CLASS (clocks_alarm_setup_dialog_parent_class)->finalize (obj);
}


GType clocks_alarm_setup_dialog_get_type (void) {
	static volatile gsize clocks_alarm_setup_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_setup_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmSetupDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_setup_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmSetupDialog), 0, (GInstanceInitFunc) clocks_alarm_setup_dialog_instance_init, NULL };
		GType clocks_alarm_setup_dialog_type_id;
		clocks_alarm_setup_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ClocksAlarmSetupDialog", &g_define_type_info, 0);
		g_once_init_leave (&clocks_alarm_setup_dialog_type_id__volatile, clocks_alarm_setup_dialog_type_id);
	}
	return clocks_alarm_setup_dialog_type_id__volatile;
}


static void __lambda32_ (ClocksAlarmRingingPanel* self) {
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	_tmp0_ = clocks_alarm_ringing_panel_get_alarm (self);
	_tmp1_ = _tmp0_;
	clocks_alarm_item_stop (_tmp1_);
}


static void ___lambda32__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda32_ ((ClocksAlarmRingingPanel*) self);
}


static void __lambda34_ (ClocksAlarmRingingPanel* self) {
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	_tmp0_ = clocks_alarm_ringing_panel_get_alarm (self);
	_tmp1_ = _tmp0_;
	clocks_alarm_item_snooze (_tmp1_);
}


static void ___lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda34_ ((ClocksAlarmRingingPanel*) self);
}


ClocksAlarmRingingPanel* clocks_alarm_ringing_panel_construct (GType object_type) {
	ClocksAlarmRingingPanel * self = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkGrid* grid = NULL;
	GObject* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	self = (ClocksAlarmRingingPanel*) g_object_new (object_type, NULL);
	_tmp0_ = clocks_utils_load_ui ("alarm.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "ringing_panel");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp1_) : NULL);
	grid = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "time_label");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp3_) : NULL);
	_g_object_unref0 (self->priv->time_label);
	self->priv->time_label = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "stop_button");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->stop_button);
	self->priv->stop_button = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "snooze_button");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->snooze_button);
	self->priv->snooze_button = _tmp8_;
	_tmp9_ = self->priv->stop_button;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) ___lambda32__gtk_button_clicked, self, 0);
	_tmp10_ = self->priv->snooze_button;
	g_signal_connect_object (_tmp10_, "clicked", (GCallback) ___lambda34__gtk_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksAlarmRingingPanel* clocks_alarm_ringing_panel_new (void) {
	return clocks_alarm_ringing_panel_construct (CLOCKS_ALARM_TYPE_RINGING_PANEL);
}


void clocks_alarm_ringing_panel_update (ClocksAlarmRingingPanel* self) {
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_alarm_ringing_panel_get_alarm (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ClocksAlarmItem* _tmp2_ = NULL;
		ClocksAlarmItem* _tmp3_ = NULL;
		ClocksAlarmItemState _tmp4_ = 0;
		ClocksAlarmItemState _tmp5_ = 0;
		_tmp2_ = clocks_alarm_ringing_panel_get_alarm (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = clocks_alarm_item_get_state (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
			GtkLabel* _tmp6_ = NULL;
			ClocksAlarmItem* _tmp7_ = NULL;
			ClocksAlarmItem* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp6_ = self->priv->time_label;
			_tmp7_ = clocks_alarm_ringing_panel_get_alarm (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = clocks_alarm_item_get_snooze_time_label (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_;
			gtk_label_set_text (_tmp6_, _tmp11_);
			_g_free0 (_tmp11_);
		} else {
			GtkLabel* _tmp12_ = NULL;
			ClocksAlarmItem* _tmp13_ = NULL;
			ClocksAlarmItem* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp12_ = self->priv->time_label;
			_tmp13_ = clocks_alarm_ringing_panel_get_alarm (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = clocks_alarm_item_get_time_label (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_;
			gtk_label_set_text (_tmp12_, _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
}


ClocksAlarmItem* clocks_alarm_ringing_panel_get_alarm (ClocksAlarmRingingPanel* self) {
	ClocksAlarmItem* result;
	ClocksAlarmItem* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alarm;
	result = _tmp0_;
	return result;
}


static void _clocks_alarm_ringing_panel_alarm____lambda33_ (ClocksAlarmRingingPanel* self) {
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	ClocksAlarmItemState _tmp2_ = 0;
	ClocksAlarmItemState _tmp3_ = 0;
	_tmp0_ = clocks_alarm_ringing_panel_get_alarm (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_alarm_item_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != CLOCKS_ALARM_ITEM_STATE_RINGING) {
		g_signal_emit_by_name (self, "dismiss");
	}
}


static void __clocks_alarm_ringing_panel_alarm____lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_clocks_alarm_ringing_panel_alarm____lambda33_ ((ClocksAlarmRingingPanel*) self);
}


void clocks_alarm_ringing_panel_set_alarm (ClocksAlarmRingingPanel* self, ClocksAlarmItem* value) {
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp3_ = NULL;
	ClocksAlarmItem* _tmp4_ = NULL;
	ClocksAlarmItem* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alarm;
	if (_tmp0_ != NULL) {
		ClocksAlarmItem* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		_tmp1_ = self->priv->_alarm;
		_tmp2_ = self->priv->alarm_state_handler;
		g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	}
	_tmp3_ = value;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_alarm);
	self->priv->_alarm = _tmp4_;
	_tmp5_ = self->priv->_alarm;
	if (_tmp5_ != NULL) {
		ClocksAlarmItem* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
		_tmp6_ = self->priv->_alarm;
		_tmp7_ = g_signal_connect_object ((GObject*) _tmp6_, "notify::state", (GCallback) __clocks_alarm_ringing_panel_alarm____lambda33__g_object_notify, self, 0);
		self->priv->alarm_state_handler = _tmp7_;
	}
	g_object_notify ((GObject *) self, "alarm");
}


static void clocks_alarm_ringing_panel_real_dismiss (ClocksAlarmRingingPanel* self) {
	clocks_alarm_ringing_panel_set_alarm (self, NULL);
}


static void clocks_alarm_ringing_panel_class_init (ClocksAlarmRingingPanelClass * klass) {
	clocks_alarm_ringing_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmRingingPanelPrivate));
	((ClocksAlarmRingingPanelClass *) klass)->dismiss = clocks_alarm_ringing_panel_real_dismiss;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_ringing_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_ringing_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_ringing_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_RINGING_PANEL_ALARM, g_param_spec_object ("alarm", "alarm", "alarm", CLOCKS_ALARM_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("dismiss", CLOCKS_ALARM_TYPE_RINGING_PANEL, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksAlarmRingingPanelClass, dismiss), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_ringing_panel_instance_init (ClocksAlarmRingingPanel * self) {
	self->priv = CLOCKS_ALARM_RINGING_PANEL_GET_PRIVATE (self);
}


static void clocks_alarm_ringing_panel_finalize (GObject* obj) {
	ClocksAlarmRingingPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel);
	_g_object_unref0 (self->priv->_alarm);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->stop_button);
	_g_object_unref0 (self->priv->snooze_button);
	G_OBJECT_CLASS (clocks_alarm_ringing_panel_parent_class)->finalize (obj);
}


GType clocks_alarm_ringing_panel_get_type (void) {
	static volatile gsize clocks_alarm_ringing_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_ringing_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmRingingPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_ringing_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmRingingPanel), 0, (GInstanceInitFunc) clocks_alarm_ringing_panel_instance_init, NULL };
		GType clocks_alarm_ringing_panel_type_id;
		clocks_alarm_ringing_panel_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ClocksAlarmRingingPanel", &g_define_type_info, 0);
		g_once_init_leave (&clocks_alarm_ringing_panel_type_id__volatile, clocks_alarm_ringing_panel_type_id);
	}
	return clocks_alarm_ringing_panel_type_id__volatile;
}


static void _vala_clocks_alarm_ringing_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmRingingPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel);
	switch (property_id) {
		case CLOCKS_ALARM_RINGING_PANEL_ALARM:
		g_value_set_object (value, clocks_alarm_ringing_panel_get_alarm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_ringing_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmRingingPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel);
	switch (property_id) {
		case CLOCKS_ALARM_RINGING_PANEL_ALARM:
		clocks_alarm_ringing_panel_set_alarm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ClocksAlarmMainPanel* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->header_bar);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda35_ (ClocksAlarmMainPanel* self, GSimpleAction* action, GVariant* param) {
	ClocksAlarmItem* item = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ClocksAlarmItem* _tmp2_ = NULL;
	ClocksAlarmItem* _tmp3_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = param;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = clocks_alarm_main_panel_find_item (self, _tmp1_);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		ClocksAlarmItem* _tmp4_ = NULL;
		_tmp4_ = item;
		clocks_alarm_item_stop (_tmp4_);
	}
	_g_object_unref0 (item);
}


static void ___lambda35__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda35_ ((ClocksAlarmMainPanel*) self, _sender, parameter);
}


static void __lambda36_ (ClocksAlarmMainPanel* self, GSimpleAction* action, GVariant* param) {
	ClocksAlarmItem* item = NULL;
	GVariant* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ClocksAlarmItem* _tmp2_ = NULL;
	ClocksAlarmItem* _tmp3_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = param;
	_tmp1_ = g_variant_get_string (_tmp0_, NULL);
	_tmp2_ = clocks_alarm_main_panel_find_item (self, _tmp1_);
	item = _tmp2_;
	_tmp3_ = item;
	if (_tmp3_ != NULL) {
		ClocksAlarmItem* _tmp4_ = NULL;
		_tmp4_ = item;
		clocks_alarm_item_snooze (_tmp4_);
	}
	_g_object_unref0 (item);
}


static void ___lambda36__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda36_ ((ClocksAlarmMainPanel*) self, _sender, parameter);
}


static void __lambda37_ (ClocksAlarmMainPanel* self, GObject* item) {
	ClocksAlarmItem* alarm = NULL;
	GObject* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	ClocksAlarmItem* _tmp2_ = NULL;
	ClocksAlarmItemState _tmp3_ = 0;
	ClocksAlarmItemState _tmp4_ = 0;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
	alarm = _tmp1_;
	_tmp2_ = alarm;
	_tmp3_ = clocks_alarm_item_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		ClocksAlarmItem* _tmp5_ = NULL;
		_tmp5_ = alarm;
		clocks_alarm_main_panel_show_ringing_panel (self, _tmp5_);
	} else {
		ClocksAlarmItem* _tmp6_ = NULL;
		_tmp6_ = alarm;
		clocks_alarm_main_panel_edit (self, _tmp6_);
	}
	_g_object_unref0 (alarm);
}


static void ___lambda37__clocks_content_view_item_activated (ClocksContentView* _sender, GObject* item, gpointer self) {
	__lambda37_ ((ClocksAlarmMainPanel*) self, item);
}


static void __lambda41_ (ClocksAlarmMainPanel* self) {
	ClocksContentView* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_get_selected_items (_tmp0_);
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp1_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GObject* _tmp2_ = NULL;
			GObject* i = NULL;
			_tmp2_ = _g_object_ref0 ((GObject*) i_it->data);
			i = _tmp2_;
			{
				GObject* _tmp3_ = NULL;
				_tmp3_ = i;
				self->priv->alarms = g_list_remove (self->priv->alarms, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem));
				_g_object_unref0 (i);
			}
		}
		__g_list_free__g_object_unref0_0 (i_collection);
	}
	clocks_alarm_main_panel_save (self);
}


static void ___lambda41__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self) {
	__lambda41_ ((ClocksAlarmMainPanel*) self);
}


static void __lambda42_ (ClocksAlarmMainPanel* self) {
	ClocksContentView* _tmp0_ = NULL;
	_tmp0_ = self->priv->content_view;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
}


static void ___lambda42__clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender, gpointer self) {
	__lambda42_ ((ClocksAlarmMainPanel*) self);
}


static void __lambda43_ (Block4Data* _data4_) {
	ClocksAlarmMainPanel* self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	ClocksContentView* _tmp2_ = NULL;
	self = _data4_->self;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->content_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget)) {
		ClocksHeaderBar* _tmp3_ = NULL;
		_tmp3_ = _data4_->header_bar;
		clocks_header_bar_set_mode (_tmp3_, CLOCKS_HEADER_BAR_MODE_NORMAL);
	} else {
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		ClocksAlarmRingingPanel* _tmp6_ = NULL;
		_tmp4_ = gtk_stack_get_visible_child ((GtkStack*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->ringing_panel;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_WIDGET, GtkWidget)) {
			ClocksHeaderBar* _tmp7_ = NULL;
			_tmp7_ = _data4_->header_bar;
			clocks_header_bar_set_mode (_tmp7_, CLOCKS_HEADER_BAR_MODE_STANDALONE);
		}
	}
}


static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda43_ (self);
}


static void __lambda44_ (ClocksAlarmMainPanel* self) {
	GList* _tmp0_ = NULL;
	_tmp0_ = self->priv->alarms;
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ClocksAlarmItem* _tmp1_ = NULL;
			ClocksAlarmItem* a = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksAlarmItem*) a_it->data);
			a = _tmp1_;
			{
				ClocksAlarmItem* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = a;
				_tmp3_ = clocks_alarm_item_tick (_tmp2_);
				if (_tmp3_) {
					ClocksAlarmItem* _tmp4_ = NULL;
					ClocksAlarmItemState _tmp5_ = 0;
					ClocksAlarmItemState _tmp6_ = 0;
					_tmp4_ = a;
					_tmp5_ = clocks_alarm_item_get_state (_tmp4_);
					_tmp6_ = _tmp5_;
					if (_tmp6_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
						ClocksAlarmItem* _tmp7_ = NULL;
						_tmp7_ = a;
						clocks_alarm_main_panel_show_ringing_panel (self, _tmp7_);
						g_signal_emit_by_name (self, "ring");
					} else {
						ClocksAlarmRingingPanel* _tmp8_ = NULL;
						ClocksAlarmItem* _tmp9_ = NULL;
						ClocksAlarmItem* _tmp10_ = NULL;
						ClocksAlarmItem* _tmp11_ = NULL;
						_tmp8_ = self->priv->ringing_panel;
						_tmp9_ = clocks_alarm_ringing_panel_get_alarm (_tmp8_);
						_tmp10_ = _tmp9_;
						_tmp11_ = a;
						if (_tmp10_ == _tmp11_) {
							ClocksAlarmRingingPanel* _tmp12_ = NULL;
							_tmp12_ = self->priv->ringing_panel;
							clocks_alarm_ringing_panel_update (_tmp12_);
						}
					}
				}
				_g_object_unref0 (a);
			}
		}
	}
}


static void ___lambda44__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self) {
	__lambda44_ ((ClocksAlarmMainPanel*) self);
}


ClocksAlarmMainPanel* clocks_alarm_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksAlarmMainPanel * self = NULL;
	Block4Data* _data4_;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ClocksHeaderBar* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GApplication* app = NULL;
	GApplication* _tmp5_ = NULL;
	GApplication* _tmp6_ = NULL;
	GAction* action = NULL;
	GAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	GAction* _tmp9_ = NULL;
	GAction* _tmp10_ = NULL;
	GAction* _tmp11_ = NULL;
	GAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	ClocksHeaderBar* _tmp18_ = NULL;
	GtkButton* _tmp19_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GtkWidget* empty_view = NULL;
	GObject* _tmp21_ = NULL;
	GtkWidget* _tmp22_ = NULL;
	ClocksHeaderBar* _tmp23_ = NULL;
	ClocksContentView* _tmp24_ = NULL;
	ClocksContentView* _tmp25_ = NULL;
	ClocksContentView* _tmp26_ = NULL;
	ClocksContentView* _tmp27_ = NULL;
	ClocksAlarmRingingPanel* _tmp28_ = NULL;
	ClocksAlarmRingingPanel* _tmp29_ = NULL;
	ClocksAlarmRingingPanel* _tmp30_ = NULL;
	ClocksContentView* _tmp31_ = NULL;
	ClocksUtilsWallClock* _tmp32_ = NULL;
	ClocksUtilsWallClock* _tmp33_ = NULL;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = header_bar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->header_bar);
	_data4_->header_bar = _tmp1_;
	_tmp2_ = _ ("Alarm");
	_tmp3_ = _data4_->header_bar;
	self = (ClocksAlarmMainPanel*) g_object_new (object_type, "label", _tmp2_, "header-bar", _tmp3_, "panel-id", CLOCKS_PANEL_ID_ALARM, NULL);
	_data4_->self = g_object_ref (self);
	__g_list_free__g_object_unref0_0 (self->priv->alarms);
	self->priv->alarms = NULL;
	_tmp4_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = g_application_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	app = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) app, "stop-alarm");
	_tmp8_ = _g_object_ref0 (_tmp7_);
	action = _tmp8_;
	_tmp9_ = action;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction), "activate", (GCallback) ___lambda35__g_simple_action_activate, self, 0);
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) app, "snooze-alarm");
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (action);
	action = _tmp11_;
	_tmp12_ = action;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction), "activate", (GCallback) ___lambda36__g_simple_action_activate, self, 0);
	_tmp13_ = _ ("New");
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->new_button);
	self->priv->new_button = _tmp14_;
	_tmp15_ = self->priv->new_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = self->priv->new_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->new_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp17_, "win.new");
	_tmp18_ = _data4_->header_bar;
	_tmp19_ = self->priv->new_button;
	gtk_header_bar_pack_start ((GtkHeaderBar*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = clocks_utils_load_ui ("alarm.ui");
	builder = _tmp20_;
	_tmp21_ = gtk_builder_get_object (builder, "empty_panel");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp21_) : NULL);
	empty_view = _tmp22_;
	_tmp23_ = _data4_->header_bar;
	_tmp24_ = clocks_content_view_new (empty_view, _tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->content_view);
	self->priv->content_view = _tmp24_;
	_tmp25_ = self->priv->content_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->content_view;
	g_signal_connect_object (_tmp26_, "item-activated", (GCallback) ___lambda37__clocks_content_view_item_activated, self, 0);
	_tmp27_ = self->priv->content_view;
	g_signal_connect_object (_tmp27_, "delete-selected", (GCallback) ___lambda41__clocks_content_view_delete_selected, self, 0);
	_tmp28_ = clocks_alarm_ringing_panel_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->ringing_panel);
	self->priv->ringing_panel = _tmp28_;
	_tmp29_ = self->priv->ringing_panel;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->ringing_panel;
	g_signal_connect_object (_tmp30_, "dismiss", (GCallback) ___lambda42__clocks_alarm_ringing_panel_dismiss, self, 0);
	clocks_alarm_main_panel_load (self);
	g_signal_connect_data ((GObject*) self, "notify::visible-child", (GCallback) ___lambda43__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp31_ = self->priv->content_view;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp31_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp32_ = clocks_utils_wall_clock_get_default ();
	_tmp33_ = _tmp32_;
	g_signal_connect_object (_tmp33_, "tick", (GCallback) ___lambda44__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp33_);
	_g_object_unref0 (empty_view);
	_g_object_unref0 (builder);
	_g_object_unref0 (action);
	_g_object_unref0 (app);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}


ClocksAlarmMainPanel* clocks_alarm_main_panel_new (ClocksHeaderBar* header_bar) {
	return clocks_alarm_main_panel_construct (CLOCKS_ALARM_TYPE_MAIN_PANEL, header_bar);
}


static ClocksAlarmItem* clocks_alarm_main_panel_find_item (ClocksAlarmMainPanel* self, const gchar* id) {
	ClocksAlarmItem* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->alarms;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp0_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksAlarmItem* _tmp1_ = NULL;
			ClocksAlarmItem* i = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksAlarmItem*) i_it->data);
			i = _tmp1_;
			{
				ClocksAlarmItem* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				_tmp2_ = i;
				_tmp3_ = clocks_alarm_item_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = id;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = i;
					return result;
				}
				_g_object_unref0 (i);
			}
		}
	}
	result = NULL;
	return result;
}


static void clocks_alarm_main_panel_load (ClocksAlarmMainPanel* self) {
	g_return_if_fail (self != NULL);
	{
		GVariantIter* _a_it = NULL;
		GSettings* _tmp0_ = NULL;
		GVariant* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		GVariantIter* _tmp3_ = NULL;
		GVariantIter* _tmp4_ = NULL;
		GVariant* a = NULL;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, "alarms");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		_a_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_ = NULL;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			ClocksAlarmItem* alarm = NULL;
			GVariant* _tmp8_ = NULL;
			ClocksAlarmItem* _tmp9_ = NULL;
			ClocksAlarmItem* _tmp10_ = NULL;
			_tmp5_ = _a_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (a);
			a = _tmp6_;
			_tmp7_ = a;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = a;
			_tmp9_ = clocks_alarm_item_deserialize (_tmp8_);
			alarm = _tmp9_;
			_tmp10_ = alarm;
			if (_tmp10_ != NULL) {
				ClocksAlarmItem* _tmp11_ = NULL;
				ClocksAlarmItem* _tmp12_ = NULL;
				ClocksContentView* _tmp13_ = NULL;
				ClocksAlarmItem* _tmp14_ = NULL;
				_tmp11_ = alarm;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				self->priv->alarms = g_list_prepend (self->priv->alarms, _tmp12_);
				_tmp13_ = self->priv->content_view;
				_tmp14_ = alarm;
				clocks_content_view_add_item (_tmp13_, (ClocksContentItem*) _tmp14_);
			}
			_g_object_unref0 (alarm);
		}
		_g_variant_unref0 (a);
		_g_variant_iter_free0 (_a_it);
	}
	self->priv->alarms = g_list_reverse (self->priv->alarms);
}


static void clocks_alarm_main_panel_save (ClocksAlarmMainPanel* self) {
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantBuilder* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GSettings* _tmp8_ = NULL;
	GVariantBuilder* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_type_new ("aa{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = self->priv->alarms;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp4_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksAlarmItem* _tmp5_ = NULL;
			ClocksAlarmItem* i = NULL;
			_tmp5_ = _g_object_ref0 ((ClocksAlarmItem*) i_it->data);
			i = _tmp5_;
			{
				ClocksAlarmItem* _tmp6_ = NULL;
				GVariantBuilder* _tmp7_ = NULL;
				_tmp6_ = i;
				_tmp7_ = builder;
				clocks_alarm_item_serialize (_tmp6_, _tmp7_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = builder;
	_tmp10_ = g_variant_builder_end (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "alarms", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_g_variant_builder_unref0 (builder);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ClocksAlarmMainPanel* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->alarm);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda40_ (Block5Data* _data5_, GtkDialog* dialog, gint response) {
	ClocksAlarmMainPanel* self;
	gint _tmp0_ = 0;
	GtkDialog* _tmp5_ = NULL;
	self = _data5_->self;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		GtkDialog* _tmp1_ = NULL;
		ClocksAlarmItem* _tmp2_ = NULL;
		ClocksAlarmItem* _tmp3_ = NULL;
		_tmp1_ = dialog;
		_tmp2_ = _data5_->alarm;
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _tmp2_);
		_tmp3_ = _data5_->alarm;
		clocks_alarm_item_reset (_tmp3_);
		clocks_alarm_main_panel_save (self);
	} else {
		ClocksAlarmItem* _tmp4_ = NULL;
		_tmp4_ = _data5_->alarm;
		clocks_alarm_item_set_active (_tmp4_, _data5_->saved_active);
	}
	_tmp5_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
}


static void ___lambda40__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda40_ (self, _sender, response_id);
}


static void clocks_alarm_main_panel_edit (ClocksAlarmMainPanel* self, ClocksAlarmItem* alarm) {
	Block5Data* _data5_;
	ClocksAlarmItem* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	ClocksAlarmSetupDialog* dialog = NULL;
	GtkWidget* _tmp2_ = NULL;
	ClocksAlarmItem* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClocksAlarmSetupDialog* _tmp5_ = NULL;
	ClocksAlarmItem* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ClocksAlarmItem* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = alarm;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->alarm);
	_data5_->alarm = _tmp1_;
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp3_ = _data5_->alarm;
	_tmp4_ = self->priv->alarms;
	_tmp5_ = clocks_alarm_setup_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WINDOW, GtkWindow), _tmp3_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = _data5_->alarm;
	_tmp7_ = clocks_alarm_item_get_active (_tmp6_);
	_tmp8_ = _tmp7_;
	_data5_->saved_active = _tmp8_;
	_tmp9_ = _data5_->alarm;
	clocks_alarm_item_set_active (_tmp9_, FALSE);
	g_signal_connect_data ((GtkDialog*) dialog, "response", (GCallback) ___lambda40__gtk_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void clocks_alarm_main_panel_show_ringing_panel (ClocksAlarmMainPanel* self, ClocksAlarmItem* alarm) {
	ClocksAlarmRingingPanel* _tmp0_ = NULL;
	ClocksAlarmItem* _tmp1_ = NULL;
	ClocksAlarmRingingPanel* _tmp2_ = NULL;
	ClocksAlarmRingingPanel* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_tmp0_ = self->priv->ringing_panel;
	_tmp1_ = alarm;
	clocks_alarm_ringing_panel_set_alarm (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->ringing_panel;
	clocks_alarm_ringing_panel_update (_tmp2_);
	_tmp3_ = self->priv->ringing_panel;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp3_);
}


static void __lambda45_ (ClocksAlarmMainPanel* self, GtkDialog* dialog, gint response) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp9_ = NULL;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		ClocksAlarmItem* alarm = NULL;
		ClocksAlarmItem* _tmp1_ = NULL;
		GtkDialog* _tmp2_ = NULL;
		ClocksAlarmItem* _tmp3_ = NULL;
		ClocksAlarmItem* _tmp4_ = NULL;
		ClocksAlarmItem* _tmp5_ = NULL;
		ClocksContentView* _tmp6_ = NULL;
		ClocksAlarmItem* _tmp7_ = NULL;
		ClocksAlarmItem* _tmp8_ = NULL;
		_tmp1_ = clocks_alarm_item_new ();
		alarm = _tmp1_;
		_tmp2_ = dialog;
		_tmp3_ = alarm;
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _tmp3_);
		_tmp4_ = alarm;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		self->priv->alarms = g_list_append (self->priv->alarms, _tmp5_);
		_tmp6_ = self->priv->content_view;
		_tmp7_ = alarm;
		clocks_content_view_add_item (_tmp6_, (ClocksContentItem*) _tmp7_);
		_tmp8_ = alarm;
		clocks_alarm_item_reset (_tmp8_);
		clocks_alarm_main_panel_save (self);
		_g_object_unref0 (alarm);
	}
	_tmp9_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
}


static void ___lambda45__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda45_ ((ClocksAlarmMainPanel*) self, _sender, response_id);
}


static void clocks_alarm_main_panel_real_activate_new (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksAlarmSetupDialog* dialog = NULL;
	GtkWidget* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ClocksAlarmSetupDialog* _tmp2_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = self->priv->alarms;
	_tmp2_ = clocks_alarm_setup_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_WINDOW, GtkWindow), NULL, _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda45__gtk_dialog_response, self, 0);
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void clocks_alarm_main_panel_real_activate_select_all (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksContentView* _tmp0_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_select_all (_tmp0_);
}


static void clocks_alarm_main_panel_real_activate_select_none (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksContentView* _tmp0_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_unselect_all (_tmp0_);
}


static gboolean clocks_alarm_main_panel_real_escape_pressed (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	gboolean result = FALSE;
	ClocksContentView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->content_view;
	_tmp1_ = clocks_content_view_escape_pressed (_tmp0_);
	result = _tmp1_;
	return result;
}


static void clocks_alarm_main_panel_real_update_header_bar (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	ClocksHeaderBarMode _tmp2_ = 0;
	ClocksHeaderBarMode _tmp3_ = 0;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = clocks_clock_get_header_bar ((ClocksClock*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_header_bar_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case CLOCKS_HEADER_BAR_MODE_NORMAL:
		{
			GtkButton* _tmp4_ = NULL;
			ClocksContentView* _tmp5_ = NULL;
			_tmp4_ = self->priv->new_button;
			gtk_widget_show ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp5_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_SELECTION:
		{
			ClocksContentView* _tmp6_ = NULL;
			_tmp6_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp6_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_STANDALONE:
		{
			ClocksHeaderBar* _tmp7_ = NULL;
			ClocksHeaderBar* _tmp8_ = NULL;
			ClocksAlarmRingingPanel* _tmp9_ = NULL;
			ClocksAlarmItem* _tmp10_ = NULL;
			ClocksAlarmItem* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp7_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->ringing_panel;
			_tmp10_ = clocks_alarm_ringing_panel_get_alarm (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = clocks_content_item_get_name ((ClocksContentItem*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) (-1));
			_tmp15_ = _tmp14_;
			gtk_header_bar_set_title ((GtkHeaderBar*) _tmp8_, _tmp15_);
			_g_free0 (_tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static const gchar* clocks_alarm_main_panel_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksAlarmMainPanel* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_main_panel_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksAlarmMainPanel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_alarm_main_panel_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksAlarmMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_main_panel_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksAlarmMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static ClocksPanelId clocks_alarm_main_panel_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksAlarmMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_main_panel_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksAlarmMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = value;
	self->priv->_panel_id = _tmp0_;
	g_object_notify ((GObject *) self, "panel-id");
}


static void clocks_alarm_main_panel_class_init (ClocksAlarmMainPanelClass * klass) {
	clocks_alarm_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmMainPanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_MAIN_PANEL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_MAIN_PANEL_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_MAIN_PANEL_PANEL_ID, g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("ring", CLOCKS_ALARM_TYPE_MAIN_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_main_panel_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_alarm_main_panel_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_new;
	iface->activate_select_all = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_select_all;
	iface->activate_select_none = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_select_none;
	iface->escape_pressed = (gboolean (*)(ClocksClock*)) clocks_alarm_main_panel_real_escape_pressed;
	iface->update_header_bar = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_update_header_bar;
	iface->get_label = clocks_alarm_main_panel_real_get_label;
	iface->set_label = clocks_alarm_main_panel_real_set_label;
	iface->get_header_bar = clocks_alarm_main_panel_real_get_header_bar;
	iface->set_header_bar = clocks_alarm_main_panel_real_set_header_bar;
	iface->get_panel_id = clocks_alarm_main_panel_real_get_panel_id;
	iface->set_panel_id = clocks_alarm_main_panel_real_set_panel_id;
}


static void clocks_alarm_main_panel_instance_init (ClocksAlarmMainPanel * self) {
	self->priv = CLOCKS_ALARM_MAIN_PANEL_GET_PRIVATE (self);
}


static void clocks_alarm_main_panel_finalize (GObject* obj) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	__g_list_free__g_object_unref0_0 (self->priv->alarms);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->new_button);
	_g_object_unref0 (self->priv->content_view);
	_g_object_unref0 (self->priv->ringing_panel);
	G_OBJECT_CLASS (clocks_alarm_main_panel_parent_class)->finalize (obj);
}


GType clocks_alarm_main_panel_get_type (void) {
	static volatile gsize clocks_alarm_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmMainPanel), 0, (GInstanceInitFunc) clocks_alarm_main_panel_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_alarm_main_panel_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_alarm_main_panel_type_id;
		clocks_alarm_main_panel_type_id = g_type_register_static (GTK_TYPE_STACK, "ClocksAlarmMainPanel", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_alarm_main_panel_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_alarm_main_panel_type_id__volatile, clocks_alarm_main_panel_type_id);
	}
	return clocks_alarm_main_panel_type_id__volatile;
}


static void _vala_clocks_alarm_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	switch (property_id) {
		case CLOCKS_ALARM_MAIN_PANEL_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_PANEL_ID:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	switch (property_id) {
		case CLOCKS_ALARM_MAIN_PANEL_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_PANEL_ID:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



