/* sudoku-view.c generated by valac 0.24.0.88-5dc64, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <pango/pangocairo.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sudoku_game_unref0(var) ((var == NULL) ? NULL : (var = (sudoku_game_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint _row;
	gint _col;
	gboolean _show_possibilities;
	gboolean _warn_about_unfillable_squares;
	gboolean _selected;
	gboolean _highlight;
	gboolean _invalid;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _Block4Data {
	int _ref_count_;
	SudokuCellView* self;
	gint row;
	gint col;
};

struct _SudokuGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuGame *self);
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GTypeClass parent_class;
	void (*finalize) (SudokuBoard *self);
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkEventBox* box;
	GtkGrid* grid;
	gint _selected_x;
	gint _selected_y;
	gboolean _show_highlights;
	gboolean _show_warnings;
	gboolean _show_possibilities;
};

struct _Block5Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
gpointer sudoku_game_ref (gpointer instance);
void sudoku_game_unref (gpointer instance);
GParamSpec* param_spec_sudoku_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_game (GValue* value, gpointer v_object);
void value_take_sudoku_game (GValue* value, gpointer v_object);
gpointer value_get_sudoku_game (const GValue* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_ROW,
	SUDOKU_CELL_VIEW_COL,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_WARN_ABOUT_UNFILLABLE_SQUARES,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_HIGHLIGHT,
	SUDOKU_CELL_VIEW_INVALID,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game, gboolean small);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game, gboolean small);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
gpointer sudoku_board_ref (gpointer instance);
void sudoku_board_unref (gpointer instance);
GParamSpec* param_spec_sudoku_board (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_sudoku_board (GValue* value, gpointer v_object);
void value_take_sudoku_board (GValue* value, gpointer v_object);
gpointer value_get_sudoku_board (const GValue* value);
GType sudoku_board_get_type (void) G_GNUC_CONST;
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda6_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda6__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
static gboolean __lambda7_ (SudokuCellView* self);
static gboolean ___lambda7__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda8_ (Block4Data* _data4_, gint number, gboolean state);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void ___lambda8__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void sudoku_cell_view_real_get_preferred_width (GtkWidget* base, gint* minimal_width, gint* natural_width);
static void sudoku_cell_view_real_get_preferred_height (GtkWidget* base, gint* minimal_height, gint* natural_height);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
gint sudoku_cell_view_get_row (SudokuCellView* self);
gint sudoku_cell_view_get_col (SudokuCellView* self);
void coord_init (Coord *self, gint row, gint col);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
void sudoku_cell_view_set_row (SudokuCellView* self, gint value);
void sudoku_cell_view_set_col (SudokuCellView* self, gint value);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_warn_about_unfillable_squares (SudokuCellView* self);
void sudoku_cell_view_set_warn_about_unfillable_squares (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_highlight (SudokuCellView* self);
void sudoku_cell_view_set_highlight (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_invalid (SudokuCellView* self);
void sudoku_cell_view_set_invalid (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SELECTED_X,
	SUDOKU_VIEW_SELECTED_Y,
	SUDOKU_VIEW_SHOW_HIGHLIGHTS,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES
};
SudokuView* sudoku_view_new (SudokuGame* game, gboolean preview);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game, gboolean preview);
void sudoku_view_set_game (SudokuView* self, SudokuGame* game, gboolean preview);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean _________lambda10_ (Block6Data* _data6_);
static gboolean __________lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _________lambda11_ (Block6Data* _data6_);
void sudoku_view_set_selected_x (SudokuView* self, gint value);
void sudoku_view_set_selected_y (SudokuView* self, gint value);
static gboolean __________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _________lambda12_ (Block6Data* _data6_, GObject* s, GParamSpec* p);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
static void __________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_set_cell_value (SudokuView* self, gint x, gint y, gint value);
void sudoku_view_cell_grab_focus (SudokuView* self, gint row, gint col);
void sudoku_view_set_cell_background_color (SudokuView* self, gint row, gint col, GdkRGBA* color);
void sudoku_view_set_row_background_color (SudokuView* self, gint row, GdkRGBA* color, GdkRGBA* fixed_color);
void sudoku_view_set_col_background_color (SudokuView* self, gint col, GdkRGBA* color, GdkRGBA* fixed_color);
void sudoku_view_set_block_background_color (SudokuView* self, gint block_row, gint block_col, GdkRGBA* color, GdkRGBA* fixed_color);
void sudoku_view_reset_cell_background_colors (SudokuView* self);
gint sudoku_view_get_selected_x (SudokuView* self);
gint sudoku_view_get_selected_y (SudokuView* self);
gboolean sudoku_view_get_show_highlights (SudokuView* self);
void sudoku_view_set_show_highlights (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GdkRGBA SUDOKU_VIEW_fixed_cell_color = {0.93, 0.93, 0.93, (gdouble) 0};
const GdkRGBA SUDOKU_VIEW_free_cell_color = {1.0, 1.0, 1.0, 1.0};

static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SudokuCellView* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gpointer _sudoku_game_ref0 (gpointer self) {
	return self ? sudoku_game_ref (self) : NULL;
}


static void __lambda6_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkPopover* _tmp2_ = NULL;
	g_return_if_fail (o != NULL);
	_tmp0_ = number;
	sudoku_cell_view_set_value (self, _tmp0_);
	_tmp1_ = number;
	if (_tmp1_ == 0) {
		g_object_notify ((GObject*) self, "value");
	}
	_tmp2_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


static void ___lambda6__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
	__lambda6_ ((SudokuCellView*) self, _sender, number);
}


static gboolean __lambda7_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean ___lambda7__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda7_ ((SudokuCellView*) self);
	return result;
}


static void __lambda8_ (Block4Data* _data4_, gint number, gboolean state) {
	SudokuCellView* self;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp2__length3 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	self = _data4_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _tmp1_->earmarks;
	_tmp2__length1 = _tmp1_->earmarks_length1;
	_tmp2__length2 = _tmp1_->earmarks_length2;
	_tmp2__length3 = _tmp1_->earmarks_length3;
	_tmp3_ = _data4_->row;
	_tmp4_ = _data4_->col;
	_tmp5_ = number;
	_tmp6_ = state;
	_tmp2_[(((_tmp3_ * _tmp2__length2) + _tmp4_) * _tmp2__length3) + (_tmp5_ - 1)] = _tmp6_;
	_tmp7_ = _tmp2_[(((_tmp3_ * _tmp2__length2) + _tmp4_) * _tmp2__length3) + (_tmp5_ - 1)];
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void ___lambda8__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
	__lambda8_ (self, number, active);
}


static gboolean __lambda9_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->earmark_popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
	return result;
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
	return result;
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game, gboolean small) {
	SudokuCellView * self = NULL;
	Block4Data* _data4_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkStyle* _tmp6_ = NULL;
	GtkStyle* _tmp7_ = NULL;
	PangoFontDescription* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuBoard* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	SudokuGame* _tmp15_ = NULL;
	NumberPicker* _tmp16_ = NULL;
	NumberPicker* _tmp17_ = NULL;
	GtkPopover* _tmp18_ = NULL;
	GtkPopover* _tmp19_ = NULL;
	NumberPicker* _tmp20_ = NULL;
	GtkPopover* _tmp21_ = NULL;
	GtkPopover* _tmp22_ = NULL;
	GtkPopover* _tmp23_ = NULL;
	SudokuGame* _tmp24_ = NULL;
	NumberPicker* _tmp25_ = NULL;
	NumberPicker* _tmp26_ = NULL;
	NumberPicker* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GtkPopover* _tmp30_ = NULL;
	GtkPopover* _tmp31_ = NULL;
	NumberPicker* _tmp32_ = NULL;
	GtkPopover* _tmp33_ = NULL;
	GtkPopover* _tmp34_ = NULL;
	GtkPopover* _tmp35_ = NULL;
	SudokuGame* _tmp36_ = NULL;
	g_return_val_if_fail (*game != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = row;
	_data4_->row = _tmp0_;
	_tmp1_ = col;
	_data4_->col = _tmp1_;
	self = (SudokuCellView*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	_tmp2_ = *game;
	_tmp3_ = _sudoku_game_ref0 (_tmp2_);
	_sudoku_game_unref0 (self->priv->game);
	self->priv->game = _tmp3_;
	_tmp4_ = _data4_->row;
	self->priv->_row = _tmp4_;
	_tmp5_ = _data4_->col;
	self->priv->_col = _tmp5_;
	_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->font_desc;
	pango_font_description_set_size (_tmp8_, PANGO_SCALE * 13);
	_tmp9_ = *game;
	_tmp10_ = _tmp9_->board;
	_tmp11_ = self->priv->_row;
	_tmp12_ = self->priv->_col;
	_tmp13_ = sudoku_board_get (_tmp10_, _tmp11_, _tmp12_);
	sudoku_cell_view_set_value (self, _tmp13_);
	_tmp14_ = small;
	if (_tmp14_) {
		self->priv->size_ratio = 0.83;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return self;
	}
	_tmp15_ = *game;
	_tmp16_ = number_picker_new (&_tmp15_->board, FALSE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->number_picker);
	self->priv->number_picker = _tmp16_;
	_tmp17_ = self->priv->number_picker;
	g_signal_connect_object (_tmp17_, "number-picked", (GCallback) ___lambda6__number_picker_number_picked, self, 0);
	_tmp18_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp18_;
	_tmp19_ = self->priv->popover;
	_tmp20_ = self->priv->number_picker;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->popover;
	gtk_popover_set_modal (_tmp21_, FALSE);
	_tmp22_ = self->priv->popover;
	gtk_popover_set_position (_tmp22_, GTK_POS_BOTTOM);
	_tmp23_ = self->priv->popover;
	g_signal_connect_object ((GtkWidget*) _tmp23_, "focus-out-event", (GCallback) ___lambda7__gtk_widget_focus_out_event, self, 0);
	_tmp24_ = *game;
	_tmp25_ = number_picker_new (&_tmp24_->board, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->earmark_picker);
	self->priv->earmark_picker = _tmp25_;
	_tmp26_ = self->priv->earmark_picker;
	g_signal_connect_data (_tmp26_, "earmark-state-changed", (GCallback) ___lambda8__number_picker_earmark_state_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp27_ = self->priv->earmark_picker;
	_tmp28_ = _data4_->row;
	_tmp29_ = _data4_->col;
	number_picker_set_earmarks (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->earmark_popover);
	self->priv->earmark_popover = _tmp30_;
	_tmp31_ = self->priv->earmark_popover;
	_tmp32_ = self->priv->earmark_picker;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->earmark_popover;
	gtk_popover_set_modal (_tmp33_, FALSE);
	_tmp34_ = self->priv->earmark_popover;
	gtk_popover_set_position (_tmp34_, GTK_POS_BOTTOM);
	_tmp35_ = self->priv->earmark_popover;
	g_signal_connect_object ((GtkWidget*) _tmp35_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_KEY_PRESS_MASK);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp36_ = *game;
	g_signal_connect_object (_tmp36_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game, gboolean small) {
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game, small);
}


static void sudoku_cell_view_real_get_preferred_width (GtkWidget* base, gint* minimal_width, gint* natural_width) {
	SudokuCellView * self;
	gint _vala_minimal_width = 0;
	gint _vala_natural_width = 0;
	gint width = 0;
	gint height = 0;
	gint side = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gdouble _tmp8_ = 0.0;
	self = (SudokuCellView*) base;
	_tmp0_ = self->priv->layout;
	pango_layout_get_size (_tmp0_, &_tmp1_, &_tmp2_);
	width = _tmp1_;
	height = _tmp2_;
	_tmp4_ = width;
	_tmp5_ = height;
	if (_tmp4_ > _tmp5_) {
		gint _tmp6_ = 0;
		_tmp6_ = width;
		_tmp3_ = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = height;
		_tmp3_ = _tmp7_;
	}
	side = _tmp3_;
	_tmp8_ = self->priv->size_ratio;
	_vala_natural_width = ((gint) (_tmp8_ * side)) / PANGO_SCALE;
	_vala_minimal_width = _vala_natural_width;
	if (minimal_width) {
		*minimal_width = _vala_minimal_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void sudoku_cell_view_real_get_preferred_height (GtkWidget* base, gint* minimal_height, gint* natural_height) {
	SudokuCellView * self;
	gint _vala_minimal_height = 0;
	gint _vala_natural_height = 0;
	gint width = 0;
	gint height = 0;
	gint side = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gdouble _tmp8_ = 0.0;
	self = (SudokuCellView*) base;
	_tmp0_ = self->priv->layout;
	pango_layout_get_size (_tmp0_, &_tmp1_, &_tmp2_);
	width = _tmp1_;
	height = _tmp2_;
	_tmp4_ = width;
	_tmp5_ = height;
	if (_tmp4_ > _tmp5_) {
		gint _tmp6_ = 0;
		_tmp6_ = width;
		_tmp3_ = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = height;
		_tmp3_ = _tmp7_;
	}
	side = _tmp3_;
	_tmp8_ = self->priv->size_ratio;
	_vala_natural_height = ((gint) (_tmp8_ * side)) / PANGO_SCALE;
	_vala_minimal_height = _vala_natural_height;
	if (minimal_height) {
		*minimal_height = _vala_minimal_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GdkEventButton* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ != ((guint) 1)) {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
		result = FALSE;
		return result;
	}
	_tmp7_ = event;
	_tmp8_ = _tmp7_->button;
	if (_tmp8_ == ((guint) 1)) {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp10_ = self->priv->_show_possibilities;
		if (!_tmp10_) {
			GdkEventButton* _tmp11_ = NULL;
			GdkModifierType _tmp12_ = 0;
			_tmp11_ = event;
			_tmp12_ = _tmp11_->state;
			_tmp9_ = (_tmp12_ & GDK_CONTROL_MASK) > 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			sudoku_cell_view_show_earmark_picker (self);
		} else {
			sudoku_cell_view_show_number_picker (self);
		}
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp14_ = self->priv->_show_possibilities;
		if (!_tmp14_) {
			GdkEventButton* _tmp15_ = NULL;
			guint _tmp16_ = 0U;
			_tmp15_ = event;
			_tmp16_ = _tmp15_->button;
			_tmp13_ = _tmp16_ == ((guint) 3);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			sudoku_cell_view_show_earmark_picker (self);
		}
	}
	result = FALSE;
	return result;
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		NumberPicker* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GtkPopover* _tmp5_ = NULL;
		GtkPopover* _tmp6_ = NULL;
		_tmp2_ = self->priv->number_picker;
		_tmp3_ = sudoku_cell_view_get_value (self);
		_tmp4_ = _tmp3_;
		number_picker_set_clear_button_visibility (_tmp2_, _tmp4_ != 0);
		_tmp5_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->popover;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	}
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkPopover* _tmp2_ = NULL;
		GtkPopover* _tmp3_ = NULL;
		_tmp2_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->earmark_popover;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	}
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->earmark_popover;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	result = FALSE;
	return result;
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key_name != NULL, 0);
	_tmp1_ = key_name;
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key_name;
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp3_ = key_name;
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
		result = 1;
		return result;
	}
	_tmp4_ = key_name;
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
		result = 2;
		return result;
	}
	_tmp5_ = key_name;
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
		result = 3;
		return result;
	}
	_tmp6_ = key_name;
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
		result = 4;
		return result;
	}
	_tmp7_ = key_name;
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
		result = 5;
		return result;
	}
	_tmp8_ = key_name;
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
		result = 6;
		return result;
	}
	_tmp9_ = key_name;
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
		result = 7;
		return result;
	}
	_tmp10_ = key_name;
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
		result = 8;
		return result;
	}
	_tmp11_ = key_name;
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
		result = 9;
		return result;
	}
	result = -1;
	return result;
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint k_no = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_ = 0;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_ = NULL;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	_tmp2_ = gdk_keyval_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	k_name = _tmp3_;
	_tmp4_ = k_name;
	_tmp5_ = atoi (_tmp4_);
	k_no = _tmp5_;
	_tmp6_ = k_no;
	if (_tmp6_ == 0) {
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = k_name;
		_tmp8_ = sudoku_cell_view_key_map_keypad (self, _tmp7_);
		k_no = _tmp8_;
	}
	_tmp10_ = k_no;
	if (_tmp10_ >= 1) {
		gint _tmp11_ = 0;
		_tmp11_ = k_no;
		_tmp9_ = _tmp11_ <= 9;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp12_ = FALSE;
		GdkEventKey* _tmp13_ = NULL;
		GdkModifierType _tmp14_ = 0;
		_tmp13_ = event;
		_tmp14_ = _tmp13_->state;
		if ((_tmp14_ & GDK_CONTROL_MASK) > 0) {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			_tmp15_ = sudoku_cell_view_get_is_fixed (self);
			_tmp16_ = _tmp15_;
			_tmp12_ = !_tmp16_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean new_state = FALSE;
			SudokuGame* _tmp17_ = NULL;
			SudokuBoard* _tmp18_ = NULL;
			gboolean* _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			gint _tmp19__length2 = 0;
			gint _tmp19__length3 = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gboolean _tmp23_ = FALSE;
			NumberPicker* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			_tmp17_ = self->priv->game;
			_tmp18_ = _tmp17_->board;
			_tmp19_ = _tmp18_->earmarks;
			_tmp19__length1 = _tmp18_->earmarks_length1;
			_tmp19__length2 = _tmp18_->earmarks_length2;
			_tmp19__length3 = _tmp18_->earmarks_length3;
			_tmp20_ = self->priv->_row;
			_tmp21_ = self->priv->_col;
			_tmp22_ = k_no;
			_tmp23_ = _tmp19_[(((_tmp20_ * _tmp19__length2) + _tmp21_) * _tmp19__length3) + (_tmp22_ - 1)];
			new_state = !_tmp23_;
			_tmp24_ = self->priv->earmark_picker;
			_tmp25_ = self->priv->_row;
			_tmp26_ = self->priv->_col;
			_tmp27_ = k_no;
			_tmp28_ = new_state;
			_tmp29_ = number_picker_set_earmark (_tmp24_, _tmp25_, _tmp26_, _tmp27_ - 1, _tmp28_);
			if (_tmp29_) {
				SudokuGame* _tmp30_ = NULL;
				SudokuBoard* _tmp31_ = NULL;
				gboolean* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp32__length2 = 0;
				gint _tmp32__length3 = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				gboolean _tmp37_ = FALSE;
				_tmp30_ = self->priv->game;
				_tmp31_ = _tmp30_->board;
				_tmp32_ = _tmp31_->earmarks;
				_tmp32__length1 = _tmp31_->earmarks_length1;
				_tmp32__length2 = _tmp31_->earmarks_length2;
				_tmp32__length3 = _tmp31_->earmarks_length3;
				_tmp33_ = self->priv->_row;
				_tmp34_ = self->priv->_col;
				_tmp35_ = k_no;
				_tmp36_ = new_state;
				_tmp32_[(((_tmp33_ * _tmp32__length2) + _tmp34_) * _tmp32__length3) + (_tmp35_ - 1)] = _tmp36_;
				_tmp37_ = _tmp32_[(((_tmp33_ * _tmp32__length2) + _tmp34_) * _tmp32__length3) + (_tmp35_ - 1)];
				gtk_widget_queue_draw ((GtkWidget*) self);
			}
		} else {
			gint _tmp38_ = 0;
			_tmp38_ = k_no;
			sudoku_cell_view_set_value (self, _tmp38_);
		}
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp41_ = k_no;
	if (_tmp41_ == 0) {
		_tmp40_ = TRUE;
	} else {
		const gchar* _tmp42_ = NULL;
		_tmp42_ = k_name;
		_tmp40_ = g_strcmp0 (_tmp42_, "BackSpace") == 0;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		const gchar* _tmp43_ = NULL;
		_tmp43_ = k_name;
		_tmp39_ = g_strcmp0 (_tmp43_, "Delete") == 0;
	}
	if (_tmp39_) {
		sudoku_cell_view_set_value (self, 0);
		g_object_notify ((GObject*) self, "value");
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp46_ = k_name;
	if (g_strcmp0 (_tmp46_, "space") == 0) {
		_tmp45_ = TRUE;
	} else {
		const gchar* _tmp47_ = NULL;
		_tmp47_ = k_name;
		_tmp45_ = g_strcmp0 (_tmp47_, "Return") == 0;
	}
	if (_tmp45_) {
		_tmp44_ = TRUE;
	} else {
		const gchar* _tmp48_ = NULL;
		_tmp48_ = k_name;
		_tmp44_ = g_strcmp0 (_tmp48_, "KP_Enter") == 0;
	}
	if (_tmp44_) {
		sudoku_cell_view_show_number_picker (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	result = FALSE;
	_g_free0 (k_name);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	GtkStyleContext* styleContext = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	cairo_t* _tmp22_ = NULL;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	SudokuGame* _tmp26_ = NULL;
	SudokuBoard* _tmp27_ = NULL;
	GeeSet* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	Coord _tmp33_ = {0};
	gboolean _tmp34_ = FALSE;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp140_ = FALSE;
	gboolean _tmp141_ = FALSE;
	cairo_t* _tmp142_ = NULL;
	gint _tmp143_ = 0;
	gboolean _tmp144_ = FALSE;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	styleContext = _tmp1_;
	_tmp2_ = self->priv->_selected;
	if (_tmp2_) {
		GdkRGBA color = {0};
		GtkStyleContext* _tmp3_ = NULL;
		GdkRGBA _tmp4_ = {0};
		cairo_t* _tmp5_ = NULL;
		GdkRGBA _tmp6_ = {0};
		gdouble _tmp7_ = 0.0;
		GdkRGBA _tmp8_ = {0};
		gdouble _tmp9_ = 0.0;
		GdkRGBA _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		_tmp3_ = styleContext;
		gtk_style_context_get_background_color (_tmp3_, GTK_STATE_FLAG_SELECTED, &_tmp4_);
		color = _tmp4_;
		_tmp5_ = c;
		_tmp6_ = color;
		_tmp7_ = _tmp6_.red;
		_tmp8_ = color;
		_tmp9_ = _tmp8_.green;
		_tmp10_ = color;
		_tmp11_ = _tmp10_.blue;
		cairo_set_source_rgb (_tmp5_, _tmp7_, _tmp9_, _tmp11_);
	} else {
		cairo_t* _tmp12_ = NULL;
		GdkRGBA _tmp13_ = {0};
		gdouble _tmp14_ = 0.0;
		GdkRGBA _tmp15_ = {0};
		gdouble _tmp16_ = 0.0;
		GdkRGBA _tmp17_ = {0};
		gdouble _tmp18_ = 0.0;
		_tmp12_ = c;
		_tmp13_ = self->priv->_background_color;
		_tmp14_ = _tmp13_.red;
		_tmp15_ = self->priv->_background_color;
		_tmp16_ = _tmp15_.green;
		_tmp17_ = self->priv->_background_color;
		_tmp18_ = _tmp17_.blue;
		cairo_set_source_rgb (_tmp12_, _tmp14_, _tmp16_, _tmp18_);
	}
	_tmp19_ = c;
	_tmp20_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp21_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_rectangle (_tmp19_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp20_, (gdouble) _tmp21_);
	_tmp22_ = c;
	cairo_fill (_tmp22_);
	_tmp23_ = self->priv->layout;
	pango_layout_get_pixel_size (_tmp23_, &_tmp24_, &_tmp25_);
	glyph_width = _tmp24_;
	glyph_height = _tmp25_;
	_tmp26_ = self->priv->game;
	_tmp27_ = _tmp26_->board;
	_tmp28_ = _tmp27_->broken_coords;
	_tmp29_ = sudoku_cell_view_get_row (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = sudoku_cell_view_get_col (self);
	_tmp32_ = _tmp31_;
	coord_init (&_tmp33_, _tmp30_, _tmp32_);
	_tmp34_ = gee_collection_contains ((GeeCollection*) _tmp28_, &_tmp33_);
	if (_tmp34_) {
		cairo_t* _tmp35_ = NULL;
		_tmp35_ = c;
		cairo_set_source_rgb (_tmp35_, 1.0, 0.0, 0.0);
	} else {
		gboolean _tmp36_ = FALSE;
		_tmp36_ = self->priv->_selected;
		if (_tmp36_) {
			GdkRGBA color = {0};
			GtkStyleContext* _tmp37_ = NULL;
			GdkRGBA _tmp38_ = {0};
			cairo_t* _tmp39_ = NULL;
			GdkRGBA _tmp40_ = {0};
			gdouble _tmp41_ = 0.0;
			GdkRGBA _tmp42_ = {0};
			gdouble _tmp43_ = 0.0;
			GdkRGBA _tmp44_ = {0};
			gdouble _tmp45_ = 0.0;
			_tmp37_ = styleContext;
			gtk_style_context_get_color (_tmp37_, GTK_STATE_FLAG_SELECTED, &_tmp38_);
			color = _tmp38_;
			_tmp39_ = c;
			_tmp40_ = color;
			_tmp41_ = _tmp40_.red;
			_tmp42_ = color;
			_tmp43_ = _tmp42_.green;
			_tmp44_ = color;
			_tmp45_ = _tmp44_.blue;
			cairo_set_source_rgb (_tmp39_, _tmp41_, _tmp43_, _tmp45_);
		} else {
			cairo_t* _tmp46_ = NULL;
			_tmp46_ = c;
			cairo_set_source_rgb (_tmp46_, 0.0, 0.0, 0.0);
		}
	}
	_tmp47_ = sudoku_cell_view_get_value (self);
	_tmp48_ = _tmp47_;
	if (_tmp48_ != 0) {
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gdouble scale = 0.0;
		gint _tmp53_ = 0;
		gdouble _tmp54_ = 0.0;
		gint _tmp55_ = 0;
		cairo_t* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gdouble _tmp59_ = 0.0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gdouble _tmp62_ = 0.0;
		cairo_t* _tmp63_ = NULL;
		cairo_t* _tmp64_ = NULL;
		gdouble _tmp65_ = 0.0;
		gdouble _tmp66_ = 0.0;
		cairo_t* _tmp67_ = NULL;
		PangoLayout* _tmp68_ = NULL;
		cairo_t* _tmp69_ = NULL;
		PangoLayout* _tmp70_ = NULL;
		cairo_t* _tmp71_ = NULL;
		_tmp49_ = self->priv->layout;
		pango_layout_get_size (_tmp49_, &_tmp50_, &_tmp51_);
		width = _tmp50_;
		height = _tmp51_;
		_tmp52_ = height;
		height = _tmp52_ / PANGO_SCALE;
		_tmp53_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp54_ = self->priv->size_ratio;
		_tmp55_ = height;
		scale = (((gdouble) _tmp53_) / _tmp54_) / _tmp55_;
		_tmp56_ = c;
		_tmp57_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp58_ = glyph_width;
		_tmp59_ = scale;
		_tmp60_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp61_ = glyph_height;
		_tmp62_ = scale;
		cairo_move_to (_tmp56_, (_tmp57_ - (_tmp58_ * _tmp59_)) / 2, (_tmp60_ - (_tmp61_ * _tmp62_)) / 2);
		_tmp63_ = c;
		cairo_save (_tmp63_);
		_tmp64_ = c;
		_tmp65_ = scale;
		_tmp66_ = scale;
		cairo_scale (_tmp64_, _tmp65_, _tmp66_);
		_tmp67_ = c;
		_tmp68_ = self->priv->layout;
		pango_cairo_update_layout (_tmp67_, _tmp68_);
		_tmp69_ = c;
		_tmp70_ = self->priv->layout;
		pango_cairo_show_layout (_tmp69_, _tmp70_);
		_tmp71_ = c;
		cairo_restore (_tmp71_);
	}
	_tmp72_ = self->priv->_show_possibilities;
	if (!_tmp72_) {
		gdouble earmark_size = 0.0;
		gint _tmp73_ = 0;
		gdouble _tmp74_ = 0.0;
		cairo_t* _tmp75_ = NULL;
		gdouble _tmp76_ = 0.0;
		cairo_t* _tmp77_ = NULL;
		gdouble _tmp78_ = 0.0;
		cairo_t* _tmp79_ = NULL;
		cairo_t* _tmp80_ = NULL;
		SudokuGame* _tmp81_ = NULL;
		SudokuBoard* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		_tmp73_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp74_ = self->priv->size_ratio;
		earmark_size = _tmp73_ / (_tmp74_ * 2);
		_tmp75_ = c;
		_tmp76_ = earmark_size;
		cairo_set_font_size (_tmp75_, _tmp76_);
		_tmp77_ = c;
		_tmp78_ = earmark_size;
		cairo_move_to (_tmp77_, (gdouble) 0, _tmp78_);
		_tmp79_ = c;
		cairo_set_source_rgb (_tmp79_, 0.0, 0.0, 0.0);
		_tmp80_ = c;
		_tmp81_ = self->priv->game;
		_tmp82_ = _tmp81_->board;
		_tmp83_ = self->priv->_row;
		_tmp84_ = self->priv->_col;
		_tmp85_ = sudoku_board_get_earmarks_string (_tmp82_, _tmp83_, _tmp84_);
		_tmp86_ = _tmp85_;
		cairo_show_text (_tmp80_, _tmp86_);
		_g_free0 (_tmp86_);
	} else {
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		_tmp87_ = sudoku_cell_view_get_value (self);
		_tmp88_ = _tmp87_;
		if (_tmp88_ == 0) {
			gdouble possibility_size = 0.0;
			gint _tmp89_ = 0;
			gdouble _tmp90_ = 0.0;
			cairo_t* _tmp91_ = NULL;
			gdouble _tmp92_ = 0.0;
			cairo_t* _tmp93_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp94_ = NULL;
			SudokuBoard* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			gboolean* _tmp101_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp102_ = 0;
			SudokuGame* _tmp103_ = NULL;
			SudokuBoard* _tmp104_ = NULL;
			gint _tmp105_ = 0;
			gint _tmp106_ = 0;
			gint width = 0;
			gint _tmp107_ = 0;
			SudokuGame* _tmp108_ = NULL;
			SudokuBoard* _tmp109_ = NULL;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			gint num = 0;
			_tmp89_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp90_ = self->priv->size_ratio;
			possibility_size = _tmp89_ / (_tmp90_ * 2);
			_tmp91_ = c;
			_tmp92_ = possibility_size;
			cairo_set_font_size (_tmp91_, _tmp92_);
			_tmp93_ = c;
			cairo_set_source_rgb (_tmp93_, 0.0, 0.0, 0.0);
			_tmp94_ = self->priv->game;
			_tmp95_ = _tmp94_->board;
			_tmp96_ = sudoku_cell_view_get_row (self);
			_tmp97_ = _tmp96_;
			_tmp98_ = sudoku_cell_view_get_col (self);
			_tmp99_ = _tmp98_;
			_tmp101_ = sudoku_board_get_possibilities_as_bool_array (_tmp95_, _tmp97_, _tmp99_, &_tmp100_);
			possibilities = _tmp101_;
			possibilities_length1 = _tmp100_;
			_possibilities_size_ = possibilities_length1;
			_tmp102_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp103_ = self->priv->game;
			_tmp104_ = _tmp103_->board;
			_tmp105_ = sudoku_board_get_block_cols (_tmp104_);
			_tmp106_ = _tmp105_;
			height = _tmp102_ / _tmp106_;
			_tmp107_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
			_tmp108_ = self->priv->game;
			_tmp109_ = _tmp108_->board;
			_tmp110_ = sudoku_board_get_block_rows (_tmp109_);
			_tmp111_ = _tmp110_;
			width = _tmp107_ / _tmp111_;
			num = 0;
			{
				gint row = 0;
				row = 0;
				{
					gboolean _tmp112_ = FALSE;
					_tmp112_ = TRUE;
					while (TRUE) {
						gint _tmp114_ = 0;
						SudokuGame* _tmp115_ = NULL;
						SudokuBoard* _tmp116_ = NULL;
						gint _tmp117_ = 0;
						gint _tmp118_ = 0;
						if (!_tmp112_) {
							gint _tmp113_ = 0;
							_tmp113_ = row;
							row = _tmp113_ + 1;
						}
						_tmp112_ = FALSE;
						_tmp114_ = row;
						_tmp115_ = self->priv->game;
						_tmp116_ = _tmp115_->board;
						_tmp117_ = sudoku_board_get_block_rows (_tmp116_);
						_tmp118_ = _tmp117_;
						if (!(_tmp114_ < _tmp118_)) {
							break;
						}
						{
							gint col = 0;
							col = 0;
							{
								gboolean _tmp119_ = FALSE;
								_tmp119_ = TRUE;
								while (TRUE) {
									gint _tmp121_ = 0;
									SudokuGame* _tmp122_ = NULL;
									SudokuBoard* _tmp123_ = NULL;
									gint _tmp124_ = 0;
									gint _tmp125_ = 0;
									gint _tmp126_ = 0;
									gboolean* _tmp127_ = NULL;
									gint _tmp127__length1 = 0;
									gint _tmp128_ = 0;
									gboolean _tmp129_ = FALSE;
									if (!_tmp119_) {
										gint _tmp120_ = 0;
										_tmp120_ = col;
										col = _tmp120_ + 1;
									}
									_tmp119_ = FALSE;
									_tmp121_ = col;
									_tmp122_ = self->priv->game;
									_tmp123_ = _tmp122_->board;
									_tmp124_ = sudoku_board_get_block_cols (_tmp123_);
									_tmp125_ = _tmp124_;
									if (!(_tmp121_ < _tmp125_)) {
										break;
									}
									_tmp126_ = num;
									num = _tmp126_ + 1;
									_tmp127_ = possibilities;
									_tmp127__length1 = possibilities_length1;
									_tmp128_ = num;
									_tmp129_ = _tmp127_[_tmp128_ - 1];
									if (_tmp129_) {
										cairo_t* _tmp130_ = NULL;
										gint _tmp131_ = 0;
										gint _tmp132_ = 0;
										gint _tmp133_ = 0;
										gint _tmp134_ = 0;
										gdouble _tmp135_ = 0.0;
										cairo_t* _tmp136_ = NULL;
										gint _tmp137_ = 0;
										gchar* _tmp138_ = NULL;
										gchar* _tmp139_ = NULL;
										_tmp130_ = c;
										_tmp131_ = col;
										_tmp132_ = width;
										_tmp133_ = row;
										_tmp134_ = height;
										_tmp135_ = possibility_size;
										cairo_move_to (_tmp130_, (gdouble) (_tmp131_ * _tmp132_), (_tmp133_ * _tmp134_) + _tmp135_);
										_tmp136_ = c;
										_tmp137_ = num;
										_tmp138_ = g_strdup_printf ("%d", _tmp137_);
										_tmp139_ = _tmp138_;
										cairo_show_text (_tmp136_, _tmp139_);
										_g_free0 (_tmp139_);
									}
								}
							}
						}
					}
				}
			}
			possibilities = (g_free (possibilities), NULL);
		}
	}
	_tmp140_ = sudoku_cell_view_get_is_fixed (self);
	_tmp141_ = _tmp140_;
	if (_tmp141_) {
		result = FALSE;
		_g_object_unref0 (styleContext);
		return result;
	}
	_tmp142_ = c;
	_tmp143_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_move_to (_tmp142_, (gdouble) 0, (gdouble) (_tmp143_ - 3));
	_tmp144_ = self->priv->_warn_about_unfillable_squares;
	if (_tmp144_) {
		cairo_t* _tmp145_ = NULL;
		cairo_t* _tmp146_ = NULL;
		_tmp145_ = c;
		cairo_set_source_rgb (_tmp145_, 1.0, 0.0, 0.0);
		_tmp146_ = c;
		cairo_show_text (_tmp146_, "None");
	} else {
		cairo_t* _tmp147_ = NULL;
		_tmp147_ = c;
		cairo_set_source_rgb (_tmp147_, 0.0, 0.0, 0.0);
	}
	result = FALSE;
	_g_object_unref0 (styleContext);
	return result;
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = row;
	_tmp2_ = sudoku_cell_view_get_row (self);
	_tmp3_ = _tmp2_;
	if (_tmp1_ == _tmp3_) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = col;
		_tmp5_ = sudoku_cell_view_get_col (self);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp4_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = new_val;
		sudoku_cell_view_set_value (self, _tmp7_);
		_tmp8_ = new_val;
		if (_tmp8_ == 0) {
			g_object_notify ((GObject*) self, "value");
		}
	}
}


gint sudoku_cell_view_get_row (SudokuCellView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_row;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_row (SudokuCellView* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_row = _tmp0_;
	g_object_notify ((GObject *) self, "row");
}


gint sudoku_cell_view_get_col (SudokuCellView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_col;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_col (SudokuCellView* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_col = _tmp0_;
	g_object_notify ((GObject *) self, "col");
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->_row;
	_tmp3_ = self->priv->_col;
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp30_ = 0;
	SudokuGame* _tmp31_ = NULL;
	SudokuBoard* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	SudokuGame* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		_tmp4_ = self->priv->_row;
		_tmp5_ = self->priv->_col;
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
		text = _tmp7_;
		_tmp8_ = text;
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp9_;
		_tmp10_ = self->priv->layout;
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_->font_desc;
		pango_layout_set_font_description (_tmp10_, _tmp13_);
		_g_free0 (text);
		return;
	}
	_tmp14_ = value;
	if (_tmp14_ == 0) {
		gchar* text = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		PangoLayout* _tmp17_ = NULL;
		PangoLayout* _tmp18_ = NULL;
		GtkStyle* _tmp19_ = NULL;
		GtkStyle* _tmp20_ = NULL;
		PangoFontDescription* _tmp21_ = NULL;
		SudokuGame* _tmp22_ = NULL;
		SudokuBoard* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		_tmp15_ = g_strdup ("");
		text = _tmp15_;
		_tmp16_ = text;
		_tmp17_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp16_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp17_;
		_tmp18_ = self->priv->layout;
		_tmp19_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_->font_desc;
		pango_layout_set_font_description (_tmp18_, _tmp21_);
		_tmp22_ = self->priv->game;
		_tmp23_ = _tmp22_->board;
		_tmp24_ = self->priv->_row;
		_tmp25_ = self->priv->_col;
		_tmp26_ = sudoku_board_get (_tmp23_, _tmp24_, _tmp25_);
		if (_tmp26_ != 0) {
			SudokuGame* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			_tmp27_ = self->priv->game;
			_tmp28_ = self->priv->_row;
			_tmp29_ = self->priv->_col;
			sudoku_game_remove (_tmp27_, _tmp28_, _tmp29_);
		}
		_g_free0 (text);
		return;
	}
	_tmp30_ = value;
	_tmp31_ = self->priv->game;
	_tmp32_ = _tmp31_->board;
	_tmp33_ = self->priv->_row;
	_tmp34_ = self->priv->_col;
	_tmp35_ = sudoku_board_get (_tmp32_, _tmp33_, _tmp34_);
	if (_tmp30_ == _tmp35_) {
		gchar* text = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		PangoLayout* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		GtkStyle* _tmp41_ = NULL;
		GtkStyle* _tmp42_ = NULL;
		PangoFontDescription* _tmp43_ = NULL;
		_tmp36_ = value;
		_tmp37_ = g_strdup_printf ("%d", _tmp36_);
		text = _tmp37_;
		_tmp38_ = text;
		_tmp39_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp38_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp39_;
		_tmp40_ = self->priv->layout;
		_tmp41_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_->font_desc;
		pango_layout_set_font_description (_tmp40_, _tmp43_);
		_g_free0 (text);
		return;
	}
	_tmp44_ = self->priv->game;
	_tmp45_ = self->priv->_row;
	_tmp46_ = self->priv->_col;
	_tmp47_ = value;
	sudoku_game_insert (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
	g_object_notify ((GObject *) self, "value");
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _tmp1_->is_fixed;
	_tmp2__length1 = _tmp1_->is_fixed_length1;
	_tmp2__length2 = _tmp1_->is_fixed_length2;
	_tmp3_ = self->priv->_row;
	_tmp4_ = self->priv->_col;
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
	result = _tmp5_;
	return result;
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_possibilities = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "show-possibilities");
}


gboolean sudoku_cell_view_get_warn_about_unfillable_squares (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_warn_about_unfillable_squares;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_warn_about_unfillable_squares (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_warn_about_unfillable_squares = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "warn-about-unfillable-squares");
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selected = _tmp0_;
	g_object_notify ((GObject *) self, "selected");
}


gboolean sudoku_cell_view_get_highlight (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_highlight;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_highlight (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_highlight = _tmp0_;
	g_object_notify ((GObject *) self, "highlight");
}


gboolean sudoku_cell_view_get_invalid (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_invalid;
	result = _tmp0_;
	return result;
}


void sudoku_cell_view_set_invalid (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_invalid = _tmp0_;
	g_object_notify ((GObject *) self, "invalid");
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_color;
	*result = _tmp0_;
	return;
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_background_color = _tmp0_;
	g_object_notify ((GObject *) self, "background-color");
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = sudoku_cell_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = sudoku_cell_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->button_press_event = sudoku_cell_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = sudoku_cell_view_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->draw = sudoku_cell_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_ROW, g_param_spec_int ("row", "row", "row", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_COL, g_param_spec_int ("col", "col", "col", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_WARN_ABOUT_UNFILLABLE_SQUARES, g_param_spec_boolean ("warn-about-unfillable-squares", "warn-about-unfillable-squares", "warn-about-unfillable-squares", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_HIGHLIGHT, g_param_spec_boolean ("highlight", "highlight", "highlight", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_INVALID, g_param_spec_boolean ("invalid", "invalid", "invalid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
	self->priv->size_ratio = (gdouble) 2;
	self->priv->_warn_about_unfillable_squares = FALSE;
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->earmark_popover);
	_sudoku_game_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->number_picker);
	_g_object_unref0 (self->priv->earmark_picker);
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_ROW:
		g_value_set_int (value, sudoku_cell_view_get_row (self));
		break;
		case SUDOKU_CELL_VIEW_COL:
		g_value_set_int (value, sudoku_cell_view_get_col (self));
		break;
		case SUDOKU_CELL_VIEW_VALUE:
		g_value_set_int (value, sudoku_cell_view_get_value (self));
		break;
		case SUDOKU_CELL_VIEW_IS_FIXED:
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
		break;
		case SUDOKU_CELL_VIEW_WARN_ABOUT_UNFILLABLE_SQUARES:
		g_value_set_boolean (value, sudoku_cell_view_get_warn_about_unfillable_squares (self));
		break;
		case SUDOKU_CELL_VIEW_SELECTED:
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHT:
		g_value_set_boolean (value, sudoku_cell_view_get_highlight (self));
		break;
		case SUDOKU_CELL_VIEW_INVALID:
		g_value_set_boolean (value, sudoku_cell_view_get_invalid (self));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
		{
			GdkRGBA boxed;
			sudoku_cell_view_get_background_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_ROW:
		sudoku_cell_view_set_row (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_COL:
		sudoku_cell_view_set_col (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_VALUE:
		sudoku_cell_view_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_WARN_ABOUT_UNFILLABLE_SQUARES:
		sudoku_cell_view_set_warn_about_unfillable_squares (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SELECTED:
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_HIGHLIGHT:
		sudoku_cell_view_set_highlight (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_INVALID:
		sudoku_cell_view_set_invalid (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game, gboolean preview) {
	SudokuView * self = NULL;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GdkRGBA _tmp2_ = {0};
	GtkEventBox* _tmp3_ = NULL;
	GtkEventBox* _tmp4_ = NULL;
	SudokuGame* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (game != NULL, NULL);
	self = (SudokuView*) g_object_new (object_type, NULL);
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp0_;
	_tmp1_ = self->priv->box;
	_tmp2_.red = 0.0;
	_tmp2_.green = 0.0;
	_tmp2_.blue = 0.0;
	_tmp2_.alpha = 1.0;
	gtk_widget_override_background_color ((GtkWidget*) _tmp1_, GTK_STATE_FLAG_NORMAL, &_tmp2_);
	_tmp3_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->box;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
	_tmp5_ = game;
	_tmp6_ = preview;
	sudoku_view_set_game (self, _tmp5_, _tmp6_);
	return self;
}


SudokuView* sudoku_view_new (SudokuGame* game, gboolean preview) {
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game, preview);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SudokuView* self;
		self = _data5_->self;
		_sudoku_game_unref0 (_data5_->game);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SudokuView* self;
		self = _data6_->_data5_->self;
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean _________lambda10_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data6_->cell_row;
	_tmp1_ = _data6_->cell_col;
	g_signal_emit_by_name (self, "cell-focus-out-event", _tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean __________lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _________lambda10_ (self);
	return result;
}


static gboolean _________lambda11_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = _data6_->cell_col;
	sudoku_view_set_selected_x (self, _tmp0_);
	_tmp1_ = _data6_->cell_row;
	sudoku_view_set_selected_y (self, _tmp1_);
	_tmp2_ = _data6_->cell_row;
	_tmp3_ = _data6_->cell_col;
	g_signal_emit_by_name (self, "cell-focus-in-event", _tmp2_, _tmp3_);
	result = FALSE;
	return result;
}


static gboolean __________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _________lambda11_ (self);
	return result;
}


static void _________lambda12_ (Block6Data* _data6_, GObject* s, GParamSpec* p) {
	Block5Data* _data5_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp3_ = self->priv->_show_possibilities;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->_show_warnings;
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = _data5_->game;
		_tmp6_ = _tmp5_->board;
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = self->priv->previous_board_broken_state;
		_tmp0_ = _tmp9_;
	}
	if (_tmp0_) {
		SudokuGame* _tmp62_ = NULL;
		SudokuBoard* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gint _tmp12_ = 0;
					SudokuGame* _tmp13_ = NULL;
					SudokuBoard* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					if (!_tmp10_) {
						gint _tmp11_ = 0;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = _data5_->game;
					_tmp14_ = _tmp13_->board;
					_tmp15_ = sudoku_board_get_rows (_tmp14_);
					_tmp16_ = _tmp15_;
					if (!(_tmp12_ < _tmp16_)) {
						break;
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp17_ = FALSE;
							_tmp17_ = TRUE;
							while (TRUE) {
								gint _tmp19_ = 0;
								SudokuGame* _tmp20_ = NULL;
								SudokuBoard* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gboolean _tmp24_ = FALSE;
								gboolean _tmp25_ = FALSE;
								gboolean _tmp26_ = FALSE;
								if (!_tmp17_) {
									gint _tmp18_ = 0;
									_tmp18_ = j;
									j = _tmp18_ + 1;
								}
								_tmp17_ = FALSE;
								_tmp19_ = j;
								_tmp20_ = _data5_->game;
								_tmp21_ = _tmp20_->board;
								_tmp22_ = sudoku_board_get_cols (_tmp21_);
								_tmp23_ = _tmp22_;
								if (!(_tmp19_ < _tmp23_)) {
									break;
								}
								_tmp26_ = self->priv->_show_warnings;
								if (_tmp26_) {
									SudokuCellView** _tmp27_ = NULL;
									gint _tmp27__length1 = 0;
									gint _tmp27__length2 = 0;
									gint _tmp28_ = 0;
									gint _tmp29_ = 0;
									SudokuCellView* _tmp30_ = NULL;
									gint _tmp31_ = 0;
									gint _tmp32_ = 0;
									_tmp27_ = self->priv->cells;
									_tmp27__length1 = self->priv->cells_length1;
									_tmp27__length2 = self->priv->cells_length2;
									_tmp28_ = i;
									_tmp29_ = j;
									_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
									_tmp31_ = sudoku_cell_view_get_value (_tmp30_);
									_tmp32_ = _tmp31_;
									_tmp25_ = _tmp32_ == 0;
								} else {
									_tmp25_ = FALSE;
								}
								if (_tmp25_) {
									SudokuGame* _tmp33_ = NULL;
									SudokuBoard* _tmp34_ = NULL;
									SudokuCellView** _tmp35_ = NULL;
									gint _tmp35__length1 = 0;
									gint _tmp35__length2 = 0;
									gint _tmp36_ = 0;
									gint _tmp37_ = 0;
									SudokuCellView* _tmp38_ = NULL;
									gint _tmp39_ = 0;
									gint _tmp40_ = 0;
									SudokuCellView** _tmp41_ = NULL;
									gint _tmp41__length1 = 0;
									gint _tmp41__length2 = 0;
									gint _tmp42_ = 0;
									gint _tmp43_ = 0;
									SudokuCellView* _tmp44_ = NULL;
									gint _tmp45_ = 0;
									gint _tmp46_ = 0;
									gint _tmp47_ = 0;
									_tmp33_ = _data5_->game;
									_tmp34_ = _tmp33_->board;
									_tmp35_ = self->priv->cells;
									_tmp35__length1 = self->priv->cells_length1;
									_tmp35__length2 = self->priv->cells_length2;
									_tmp36_ = i;
									_tmp37_ = j;
									_tmp38_ = _tmp35_[(_tmp36_ * _tmp35__length2) + _tmp37_];
									_tmp39_ = sudoku_cell_view_get_row (_tmp38_);
									_tmp40_ = _tmp39_;
									_tmp41_ = self->priv->cells;
									_tmp41__length1 = self->priv->cells_length1;
									_tmp41__length2 = self->priv->cells_length2;
									_tmp42_ = i;
									_tmp43_ = j;
									_tmp44_ = _tmp41_[(_tmp42_ * _tmp41__length2) + _tmp43_];
									_tmp45_ = sudoku_cell_view_get_col (_tmp44_);
									_tmp46_ = _tmp45_;
									_tmp47_ = sudoku_board_count_possibilities (_tmp34_, _tmp40_, _tmp46_);
									_tmp24_ = _tmp47_ == 0;
								} else {
									_tmp24_ = FALSE;
								}
								if (_tmp24_) {
									SudokuCellView** _tmp48_ = NULL;
									gint _tmp48__length1 = 0;
									gint _tmp48__length2 = 0;
									gint _tmp49_ = 0;
									gint _tmp50_ = 0;
									SudokuCellView* _tmp51_ = NULL;
									gboolean _tmp52_ = FALSE;
									gboolean _tmp53_ = FALSE;
									_tmp48_ = self->priv->cells;
									_tmp48__length1 = self->priv->cells_length1;
									_tmp48__length2 = self->priv->cells_length2;
									_tmp49_ = i;
									_tmp50_ = j;
									_tmp51_ = _tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_];
									_tmp52_ = sudoku_cell_view_get_warn_about_unfillable_squares (_tmp51_);
									_tmp53_ = _tmp52_;
									if (!_tmp53_) {
										SudokuCellView** _tmp54_ = NULL;
										gint _tmp54__length1 = 0;
										gint _tmp54__length2 = 0;
										gint _tmp55_ = 0;
										gint _tmp56_ = 0;
										SudokuCellView* _tmp57_ = NULL;
										_tmp54_ = self->priv->cells;
										_tmp54__length1 = self->priv->cells_length1;
										_tmp54__length2 = self->priv->cells_length2;
										_tmp55_ = i;
										_tmp56_ = j;
										_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
										sudoku_cell_view_set_warn_about_unfillable_squares (_tmp57_, TRUE);
									}
								} else {
									SudokuCellView** _tmp58_ = NULL;
									gint _tmp58__length1 = 0;
									gint _tmp58__length2 = 0;
									gint _tmp59_ = 0;
									gint _tmp60_ = 0;
									SudokuCellView* _tmp61_ = NULL;
									_tmp58_ = self->priv->cells;
									_tmp58__length1 = self->priv->cells_length1;
									_tmp58__length2 = self->priv->cells_length2;
									_tmp59_ = i;
									_tmp60_ = j;
									_tmp61_ = _tmp58_[(_tmp59_ * _tmp58__length2) + _tmp60_];
									sudoku_cell_view_set_warn_about_unfillable_squares (_tmp61_, FALSE);
								}
							}
						}
					}
				}
			}
		}
		_tmp62_ = _data5_->game;
		_tmp63_ = _tmp62_->board;
		_tmp64_ = sudoku_board_get_broken (_tmp63_);
		_tmp65_ = _tmp64_;
		self->priv->previous_board_broken_state = _tmp65_;
	}
	_tmp66_ = _data6_->cell_row;
	_tmp67_ = _data6_->cell_col;
	g_signal_emit_by_name (self, "cell-value-changed-event", _tmp66_, _tmp67_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_________lambda12_ (self, _sender, pspec);
}


void sudoku_view_set_game (SudokuView* self, SudokuGame* game, gboolean preview) {
	Block5Data* _data5_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	SudokuGame* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	SudokuGame* _tmp13_ = NULL;
	SudokuBoard* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	SudokuGame* _tmp17_ = NULL;
	SudokuBoard* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	SudokuCellView** _tmp21_ = NULL;
	GtkEventBox* _tmp89_ = NULL;
	GtkGrid* _tmp90_ = NULL;
	GtkGrid* _tmp91_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = game;
	_tmp1_ = _sudoku_game_ref0 (_tmp0_);
	_sudoku_game_unref0 (_data5_->game);
	_data5_->game = _tmp1_;
	_tmp2_ = self->priv->grid;
	if (_tmp2_ != NULL) {
		GtkEventBox* _tmp3_ = NULL;
		GtkGrid* _tmp4_ = NULL;
		_tmp3_ = self->priv->box;
		_tmp4_ = self->priv->grid;
		gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	}
	_tmp5_ = _data5_->game;
	_tmp6_ = _sudoku_game_ref0 (_tmp5_);
	_sudoku_game_unref0 (self->game);
	self->game = _tmp6_;
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp7_;
	_tmp8_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp8_, 1);
	_tmp9_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp9_, 1);
	_tmp10_ = self->priv->grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 3);
	_tmp11_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp11_, FALSE);
	_tmp12_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp12_, FALSE);
	_tmp13_ = _data5_->game;
	_tmp14_ = _tmp13_->board;
	_tmp15_ = sudoku_board_get_rows (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _data5_->game;
	_tmp18_ = _tmp17_->board;
	_tmp19_ = sudoku_board_get_cols (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_new0 (SudokuCellView*, (_tmp16_ * _tmp20_) + 1);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->cells = _tmp21_;
	self->priv->cells_length1 = _tmp16_;
	self->priv->cells_length2 = _tmp20_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				SudokuGame* _tmp25_ = NULL;
				SudokuBoard* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = row;
					row = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = row;
				_tmp25_ = _data5_->game;
				_tmp26_ = _tmp25_->board;
				_tmp27_ = sudoku_board_get_rows (_tmp26_);
				_tmp28_ = _tmp27_;
				if (!(_tmp24_ < _tmp28_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp29_ = FALSE;
						_tmp29_ = TRUE;
						while (TRUE) {
							Block6Data* _data6_;
							gint _tmp31_ = 0;
							SudokuGame* _tmp32_ = NULL;
							SudokuBoard* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gboolean _tmp38_ = FALSE;
							SudokuCellView* _tmp39_ = NULL;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							SudokuCellView* _tmp42_ = NULL;
							gboolean _tmp43_ = FALSE;
							gboolean _tmp44_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							SudokuCellView* _tmp57_ = NULL;
							gboolean _tmp58_ = FALSE;
							gint _tmp59_ = 0;
							gboolean _tmp74_ = FALSE;
							gint _tmp75_ = 0;
							GtkGrid* _tmp85_ = NULL;
							SudokuCellView* _tmp86_ = NULL;
							gint _tmp87_ = 0;
							gint _tmp88_ = 0;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->_data5_ = block5_data_ref (_data5_);
							if (!_tmp29_) {
								gint _tmp30_ = 0;
								_tmp30_ = col;
								col = _tmp30_ + 1;
							}
							_tmp29_ = FALSE;
							_tmp31_ = col;
							_tmp32_ = _data5_->game;
							_tmp33_ = _tmp32_->board;
							_tmp34_ = sudoku_board_get_cols (_tmp33_);
							_tmp35_ = _tmp34_;
							if (!(_tmp31_ < _tmp35_)) {
								block6_data_unref (_data6_);
								_data6_ = NULL;
								break;
							}
							_tmp36_ = row;
							_tmp37_ = col;
							_tmp38_ = preview;
							_tmp39_ = sudoku_cell_view_new (_tmp36_, _tmp37_, &self->game, _tmp38_);
							g_object_ref_sink (_tmp39_);
							cell = _tmp39_;
							_tmp40_ = row;
							_data6_->cell_row = _tmp40_;
							_tmp41_ = col;
							_data6_->cell_col = _tmp41_;
							_tmp42_ = cell;
							_tmp43_ = sudoku_cell_view_get_is_fixed (_tmp42_);
							_tmp44_ = _tmp43_;
							if (_tmp44_) {
								SudokuCellView* _tmp45_ = NULL;
								_tmp45_ = cell;
								sudoku_cell_view_set_background_color (_tmp45_, &SUDOKU_VIEW_fixed_cell_color);
							} else {
								SudokuCellView* _tmp46_ = NULL;
								_tmp46_ = cell;
								sudoku_cell_view_set_background_color (_tmp46_, &SUDOKU_VIEW_free_cell_color);
							}
							_tmp47_ = preview;
							if (!_tmp47_) {
								SudokuCellView* _tmp48_ = NULL;
								SudokuCellView* _tmp49_ = NULL;
								SudokuCellView* _tmp50_ = NULL;
								_tmp48_ = cell;
								g_signal_connect_data ((GtkWidget*) _tmp48_, "focus-out-event", (GCallback) __________lambda10__gtk_widget_focus_out_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
								_tmp49_ = cell;
								g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) __________lambda11__gtk_widget_focus_in_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
								_tmp50_ = cell;
								g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) __________lambda12__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							}
							_tmp51_ = self->priv->cells;
							_tmp51__length1 = self->priv->cells_length1;
							_tmp51__length2 = self->priv->cells_length2;
							_tmp52_ = row;
							_tmp53_ = col;
							_tmp54_ = cell;
							_tmp55_ = _g_object_ref0 (_tmp54_);
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
							_tmp57_ = cell;
							gtk_widget_show ((GtkWidget*) _tmp57_);
							_tmp59_ = col;
							if (_tmp59_ != 0) {
								gint _tmp60_ = 0;
								SudokuGame* _tmp61_ = NULL;
								SudokuBoard* _tmp62_ = NULL;
								gint _tmp63_ = 0;
								gint _tmp64_ = 0;
								_tmp60_ = col;
								_tmp61_ = _data5_->game;
								_tmp62_ = _tmp61_->board;
								_tmp63_ = sudoku_board_get_block_cols (_tmp62_);
								_tmp64_ = _tmp63_;
								_tmp58_ = (_tmp60_ % _tmp64_) == 0;
							} else {
								_tmp58_ = FALSE;
							}
							if (_tmp58_) {
								GtkTextDirection _tmp65_ = 0;
								_tmp65_ = gtk_widget_get_direction ((GtkWidget*) self);
								if (_tmp65_ == GTK_TEXT_DIR_RTL) {
									SudokuCellView* _tmp66_ = NULL;
									GtkGrid* _tmp67_ = NULL;
									guint _tmp68_ = 0U;
									guint _tmp69_ = 0U;
									_tmp66_ = cell;
									_tmp67_ = self->priv->grid;
									_tmp68_ = gtk_container_get_border_width ((GtkContainer*) _tmp67_);
									_tmp69_ = _tmp68_;
									gtk_widget_set_margin_right ((GtkWidget*) _tmp66_, (gint) _tmp69_);
								} else {
									SudokuCellView* _tmp70_ = NULL;
									GtkGrid* _tmp71_ = NULL;
									guint _tmp72_ = 0U;
									guint _tmp73_ = 0U;
									_tmp70_ = cell;
									_tmp71_ = self->priv->grid;
									_tmp72_ = gtk_container_get_border_width ((GtkContainer*) _tmp71_);
									_tmp73_ = _tmp72_;
									gtk_widget_set_margin_left ((GtkWidget*) _tmp70_, (gint) _tmp73_);
								}
							}
							_tmp75_ = row;
							if (_tmp75_ != 0) {
								gint _tmp76_ = 0;
								SudokuGame* _tmp77_ = NULL;
								SudokuBoard* _tmp78_ = NULL;
								gint _tmp79_ = 0;
								gint _tmp80_ = 0;
								_tmp76_ = row;
								_tmp77_ = _data5_->game;
								_tmp78_ = _tmp77_->board;
								_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
								_tmp80_ = _tmp79_;
								_tmp74_ = (_tmp76_ % _tmp80_) == 0;
							} else {
								_tmp74_ = FALSE;
							}
							if (_tmp74_) {
								SudokuCellView* _tmp81_ = NULL;
								GtkGrid* _tmp82_ = NULL;
								guint _tmp83_ = 0U;
								guint _tmp84_ = 0U;
								_tmp81_ = cell;
								_tmp82_ = self->priv->grid;
								_tmp83_ = gtk_container_get_border_width ((GtkContainer*) _tmp82_);
								_tmp84_ = _tmp83_;
								gtk_widget_set_margin_top ((GtkWidget*) _tmp81_, (gint) _tmp84_);
							}
							_tmp85_ = self->priv->grid;
							_tmp86_ = cell;
							_tmp87_ = col;
							_tmp88_ = row;
							gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, _tmp87_, _tmp88_, 1, 1);
							_g_object_unref0 (cell);
							block6_data_unref (_data6_);
							_data6_ = NULL;
						}
					}
				}
			}
		}
	}
	_tmp89_ = self->priv->box;
	_tmp90_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->grid;
	gtk_widget_show ((GtkWidget*) _tmp91_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


void sudoku_view_set_cell_value (SudokuView* self, gint x, gint y, gint value) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = y;
	_tmp2_ = x;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = value;
	sudoku_cell_view_set_value (_tmp3_, _tmp4_);
	_tmp5_ = value;
	if (_tmp5_ == 0) {
		SudokuCellView** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint _tmp6__length2 = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		SudokuCellView* _tmp9_ = NULL;
		_tmp6_ = self->priv->cells;
		_tmp6__length1 = self->priv->cells_length1;
		_tmp6__length2 = self->priv->cells_length2;
		_tmp7_ = y;
		_tmp8_ = x;
		_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
		g_object_notify ((GObject*) _tmp9_, "value");
	}
}


void sudoku_view_cell_grab_focus (SudokuView* self, gint row, gint col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
}


void sudoku_view_set_cell_background_color (SudokuView* self, gint row, gint col, GdkRGBA* color) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	GdkRGBA _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = row;
	_tmp2_ = col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = *color;
	sudoku_cell_view_set_background_color (_tmp3_, &_tmp4_);
}


void sudoku_view_set_row_background_color (SudokuView* self, gint row, GdkRGBA* color, GdkRGBA* fixed_color) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (fixed_color != NULL);
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				SudokuCellView** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp7__length2 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				SudokuCellView* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = col;
					col = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = col;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->cells;
				_tmp7__length1 = self->priv->cells_length1;
				_tmp7__length2 = self->priv->cells_length2;
				_tmp8_ = row;
				_tmp9_ = col;
				_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
				_tmp11_ = sudoku_cell_view_get_is_fixed (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					SudokuCellView** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gint _tmp13__length2 = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					SudokuCellView* _tmp16_ = NULL;
					GdkRGBA _tmp17_ = {0};
					_tmp13_ = self->priv->cells;
					_tmp13__length1 = self->priv->cells_length1;
					_tmp13__length2 = self->priv->cells_length2;
					_tmp14_ = row;
					_tmp15_ = col;
					_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
					_tmp17_ = *fixed_color;
					sudoku_cell_view_set_background_color (_tmp16_, &_tmp17_);
				} else {
					SudokuCellView** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp18__length2 = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					SudokuCellView* _tmp21_ = NULL;
					GdkRGBA _tmp22_ = {0};
					_tmp18_ = self->priv->cells;
					_tmp18__length1 = self->priv->cells_length1;
					_tmp18__length2 = self->priv->cells_length2;
					_tmp19_ = row;
					_tmp20_ = col;
					_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
					_tmp22_ = *color;
					sudoku_cell_view_set_background_color (_tmp21_, &_tmp22_);
				}
			}
		}
	}
}


void sudoku_view_set_col_background_color (SudokuView* self, gint col, GdkRGBA* color, GdkRGBA* fixed_color) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (fixed_color != NULL);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				SudokuCellView** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp7__length2 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				SudokuCellView* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = row;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->cells;
				_tmp7__length1 = self->priv->cells_length1;
				_tmp7__length2 = self->priv->cells_length2;
				_tmp8_ = row;
				_tmp9_ = col;
				_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
				_tmp11_ = sudoku_cell_view_get_is_fixed (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					SudokuCellView** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gint _tmp13__length2 = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					SudokuCellView* _tmp16_ = NULL;
					GdkRGBA _tmp17_ = {0};
					_tmp13_ = self->priv->cells;
					_tmp13__length1 = self->priv->cells_length1;
					_tmp13__length2 = self->priv->cells_length2;
					_tmp14_ = row;
					_tmp15_ = col;
					_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
					_tmp17_ = *fixed_color;
					sudoku_cell_view_set_background_color (_tmp16_, &_tmp17_);
				} else {
					SudokuCellView** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp18__length2 = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					SudokuCellView* _tmp21_ = NULL;
					GdkRGBA _tmp22_ = {0};
					_tmp18_ = self->priv->cells;
					_tmp18__length1 = self->priv->cells_length1;
					_tmp18__length2 = self->priv->cells_length2;
					_tmp19_ = row;
					_tmp20_ = col;
					_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
					_tmp22_ = *color;
					sudoku_cell_view_set_background_color (_tmp21_, &_tmp22_);
				}
			}
		}
	}
}


void sudoku_view_set_block_background_color (SudokuView* self, gint block_row, gint block_col, GdkRGBA* color, GdkRGBA* fixed_color) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (fixed_color != NULL);
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp0_ = NULL;
		SudokuBoard* _tmp1_ = NULL;
		GeeMap* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		Coord _tmp5_ = {0};
		gpointer _tmp6_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _coord_index = 0;
		_tmp0_ = self->game;
		_tmp1_ = _tmp0_->board;
		_tmp2_ = _tmp1_->coords_for_block;
		_tmp3_ = block_row;
		_tmp4_ = block_col;
		coord_init (&_tmp5_, _tmp3_, _tmp4_);
		_tmp6_ = gee_map_get (_tmp2_, &_tmp5_);
		_coord_list = (GeeList*) _tmp6_;
		_tmp7_ = _coord_list;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_coord_size = _tmp9_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			SudokuCellView** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp16__length2 = 0;
			Coord* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			Coord* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			SudokuCellView* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			_tmp10_ = _coord_index;
			_coord_index = _tmp10_ + 1;
			_tmp11_ = _coord_index;
			_tmp12_ = _coord_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _coord_list;
			_tmp14_ = _coord_index;
			_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
			coord = (Coord*) _tmp15_;
			_tmp16_ = self->priv->cells;
			_tmp16__length1 = self->priv->cells_length1;
			_tmp16__length2 = self->priv->cells_length2;
			_tmp17_ = coord;
			_tmp18_ = (*_tmp17_).row;
			_tmp19_ = coord;
			_tmp20_ = (*_tmp19_).col;
			_tmp21_ = _tmp16_[(_tmp18_ * _tmp16__length2) + _tmp20_];
			_tmp22_ = sudoku_cell_view_get_is_fixed (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				SudokuCellView** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp24__length2 = 0;
				Coord* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				Coord* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				SudokuCellView* _tmp29_ = NULL;
				GdkRGBA _tmp30_ = {0};
				_tmp24_ = self->priv->cells;
				_tmp24__length1 = self->priv->cells_length1;
				_tmp24__length2 = self->priv->cells_length2;
				_tmp25_ = coord;
				_tmp26_ = (*_tmp25_).row;
				_tmp27_ = coord;
				_tmp28_ = (*_tmp27_).col;
				_tmp29_ = _tmp24_[(_tmp26_ * _tmp24__length2) + _tmp28_];
				_tmp30_ = *fixed_color;
				sudoku_cell_view_set_background_color (_tmp29_, &_tmp30_);
			} else {
				SudokuCellView** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp31__length2 = 0;
				Coord* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				Coord* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				SudokuCellView* _tmp36_ = NULL;
				GdkRGBA _tmp37_ = {0};
				_tmp31_ = self->priv->cells;
				_tmp31__length1 = self->priv->cells_length1;
				_tmp31__length2 = self->priv->cells_length2;
				_tmp32_ = coord;
				_tmp33_ = (*_tmp32_).row;
				_tmp34_ = coord;
				_tmp35_ = (*_tmp34_).col;
				_tmp36_ = _tmp31_[(_tmp33_ * _tmp31__length2) + _tmp35_];
				_tmp37_ = *color;
				sudoku_cell_view_set_background_color (_tmp36_, &_tmp37_);
			}
			_coord_free0 (coord);
		}
		_g_object_unref0 (_coord_list);
	}
}


void sudoku_view_reset_cell_background_colors (SudokuView* self) {
	g_return_if_fail (self != NULL);
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = j;
					j = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = j;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = i;
							_tmp10_ = self->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_rows (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = sudoku_cell_view_get_is_fixed (_tmp17_);
							_tmp19_ = _tmp18_;
							if (_tmp19_) {
								SudokuCellView** _tmp20_ = NULL;
								gint _tmp20__length1 = 0;
								gint _tmp20__length2 = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								SudokuCellView* _tmp23_ = NULL;
								_tmp20_ = self->priv->cells;
								_tmp20__length1 = self->priv->cells_length1;
								_tmp20__length2 = self->priv->cells_length2;
								_tmp21_ = i;
								_tmp22_ = j;
								_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
								sudoku_cell_view_set_background_color (_tmp23_, &SUDOKU_VIEW_fixed_cell_color);
							} else {
								SudokuCellView** _tmp24_ = NULL;
								gint _tmp24__length1 = 0;
								gint _tmp24__length2 = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								SudokuCellView* _tmp27_ = NULL;
								_tmp24_ = self->priv->cells;
								_tmp24__length1 = self->priv->cells_length1;
								_tmp24__length2 = self->priv->cells_length2;
								_tmp25_ = i;
								_tmp26_ = j;
								_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
								sudoku_cell_view_set_background_color (_tmp27_, &SUDOKU_VIEW_free_cell_color);
							}
						}
					}
				}
			}
		}
	}
}


gint sudoku_view_get_selected_x (SudokuView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_selected_x;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_selected_x (SudokuView* self, gint value) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	SudokuCellView* _tmp5_ = NULL;
	SudokuCellView** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	SudokuCellView* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	SudokuCellView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	SudokuCellView* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = sudoku_view_get_selected_y (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sudoku_view_get_selected_x (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_[(_tmp2_ * _tmp0__length2) + _tmp4_];
	sudoku_cell_view_set_selected (_tmp5_, FALSE);
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = sudoku_view_get_selected_y (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = sudoku_view_get_selected_x (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp6_[(_tmp8_ * _tmp6__length2) + _tmp10_];
	gtk_widget_queue_draw ((GtkWidget*) _tmp11_);
	_tmp12_ = value;
	self->priv->_selected_x = _tmp12_;
	_tmp13_ = self->priv->cells;
	_tmp13__length1 = self->priv->cells_length1;
	_tmp13__length2 = self->priv->cells_length2;
	_tmp14_ = sudoku_view_get_selected_y (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = sudoku_view_get_selected_x (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
	sudoku_cell_view_set_selected (_tmp18_, TRUE);
	g_object_notify ((GObject *) self, "selected-x");
}


gint sudoku_view_get_selected_y (SudokuView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_selected_y;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_selected_y (SudokuView* self, gint value) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	SudokuCellView* _tmp5_ = NULL;
	SudokuCellView** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	SudokuCellView* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	SudokuCellView** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	SudokuCellView* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = sudoku_view_get_selected_y (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sudoku_view_get_selected_x (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_[(_tmp2_ * _tmp0__length2) + _tmp4_];
	sudoku_cell_view_set_selected (_tmp5_, FALSE);
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = sudoku_view_get_selected_y (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = sudoku_view_get_selected_x (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp6_[(_tmp8_ * _tmp6__length2) + _tmp10_];
	gtk_widget_queue_draw ((GtkWidget*) _tmp11_);
	_tmp12_ = value;
	self->priv->_selected_y = _tmp12_;
	_tmp13_ = self->priv->cells;
	_tmp13__length1 = self->priv->cells_length1;
	_tmp13__length2 = self->priv->cells_length2;
	_tmp14_ = sudoku_view_get_selected_y (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = sudoku_view_get_selected_x (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
	sudoku_cell_view_set_selected (_tmp18_, TRUE);
	g_object_notify ((GObject *) self, "selected-y");
}


gboolean sudoku_view_get_show_highlights (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_highlights;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_show_highlights (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_highlights = _tmp0_;
	g_object_notify ((GObject *) self, "show-highlights");
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_warnings = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->game;
				_tmp5_ = _tmp4_->board;
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp3_ < _tmp7_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gboolean _tmp15_ = FALSE;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp17_ = FALSE;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = self->game;
							_tmp12_ = _tmp11_->board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp10_ < _tmp14_)) {
								break;
							}
							_tmp17_ = self->priv->_show_warnings;
							if (_tmp17_) {
								SudokuCellView** _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								SudokuCellView* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								_tmp18_ = self->priv->cells;
								_tmp18__length1 = self->priv->cells_length1;
								_tmp18__length2 = self->priv->cells_length2;
								_tmp19_ = i;
								_tmp20_ = j;
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
								_tmp22_ = sudoku_cell_view_get_value (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp16_ = _tmp23_ == 0;
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								SudokuGame* _tmp24_ = NULL;
								SudokuBoard* _tmp25_ = NULL;
								SudokuCellView** _tmp26_ = NULL;
								gint _tmp26__length1 = 0;
								gint _tmp26__length2 = 0;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								SudokuCellView* _tmp29_ = NULL;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								SudokuCellView** _tmp32_ = NULL;
								gint _tmp32__length1 = 0;
								gint _tmp32__length2 = 0;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								SudokuCellView* _tmp35_ = NULL;
								gint _tmp36_ = 0;
								gint _tmp37_ = 0;
								gint _tmp38_ = 0;
								_tmp24_ = self->game;
								_tmp25_ = _tmp24_->board;
								_tmp26_ = self->priv->cells;
								_tmp26__length1 = self->priv->cells_length1;
								_tmp26__length2 = self->priv->cells_length2;
								_tmp27_ = i;
								_tmp28_ = j;
								_tmp29_ = _tmp26_[(_tmp27_ * _tmp26__length2) + _tmp28_];
								_tmp30_ = sudoku_cell_view_get_row (_tmp29_);
								_tmp31_ = _tmp30_;
								_tmp32_ = self->priv->cells;
								_tmp32__length1 = self->priv->cells_length1;
								_tmp32__length2 = self->priv->cells_length2;
								_tmp33_ = i;
								_tmp34_ = j;
								_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
								_tmp36_ = sudoku_cell_view_get_col (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = sudoku_board_count_possibilities (_tmp25_, _tmp31_, _tmp37_);
								_tmp15_ = _tmp38_ == 0;
							} else {
								_tmp15_ = FALSE;
							}
							if (_tmp15_) {
								SudokuCellView** _tmp39_ = NULL;
								gint _tmp39__length1 = 0;
								gint _tmp39__length2 = 0;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								SudokuCellView* _tmp42_ = NULL;
								_tmp39_ = self->priv->cells;
								_tmp39__length1 = self->priv->cells_length1;
								_tmp39__length2 = self->priv->cells_length2;
								_tmp40_ = i;
								_tmp41_ = j;
								_tmp42_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
								sudoku_cell_view_set_warn_about_unfillable_squares (_tmp42_, TRUE);
							} else {
								SudokuCellView** _tmp43_ = NULL;
								gint _tmp43__length1 = 0;
								gint _tmp43__length2 = 0;
								gint _tmp44_ = 0;
								gint _tmp45_ = 0;
								SudokuCellView* _tmp46_ = NULL;
								_tmp43_ = self->priv->cells;
								_tmp43__length1 = self->priv->cells_length1;
								_tmp43__length2 = self->priv->cells_length2;
								_tmp44_ = i;
								_tmp45_ = j;
								_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
								sudoku_cell_view_set_warn_about_unfillable_squares (_tmp46_, FALSE);
							}
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_possibilities = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->game;
				_tmp5_ = _tmp4_->board;
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp3_ < _tmp7_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp10_ = j;
							_tmp11_ = self->game;
							_tmp12_ = _tmp11_->board;
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
							_tmp14_ = _tmp13_;
							if (!(_tmp10_ < _tmp14_)) {
								break;
							}
							_tmp15_ = self->priv->cells;
							_tmp15__length1 = self->priv->cells_length1;
							_tmp15__length2 = self->priv->cells_length2;
							_tmp16_ = i;
							_tmp17_ = j;
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
							_tmp19_ = value;
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
						}
					}
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "show-possibilities");
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SELECTED_X, g_param_spec_int ("selected-x", "selected-x", "selected-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SELECTED_Y, g_param_spec_int ("selected-y", "selected-y", "selected-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_HIGHLIGHTS, g_param_spec_boolean ("show-highlights", "show-highlights", "show-highlights", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("cell_focus_in_event", TYPE_SUDOKU_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("cell_focus_out_event", TYPE_SUDOKU_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("cell_value_changed_event", TYPE_SUDOKU_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void sudoku_view_instance_init (SudokuView * self) {
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
	self->priv->previous_board_broken_state = FALSE;
	self->priv->_selected_x = 0;
	self->priv->_selected_y = 0;
	self->priv->_show_highlights = FALSE;
	self->priv->_show_warnings = FALSE;
	self->priv->_show_possibilities = FALSE;
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
	_sudoku_game_unref0 (self->game);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (GTK_TYPE_ASPECT_FRAME, "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SELECTED_X:
		g_value_set_int (value, sudoku_view_get_selected_x (self));
		break;
		case SUDOKU_VIEW_SELECTED_Y:
		g_value_set_int (value, sudoku_view_get_selected_y (self));
		break;
		case SUDOKU_VIEW_SHOW_HIGHLIGHTS:
		g_value_set_boolean (value, sudoku_view_get_show_highlights (self));
		break;
		case SUDOKU_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SELECTED_X:
		sudoku_view_set_selected_x (self, g_value_get_int (value));
		break;
		case SUDOKU_VIEW_SELECTED_Y:
		sudoku_view_set_selected_y (self, g_value_get_int (value));
		break;
		case SUDOKU_VIEW_SHOW_HIGHLIGHTS:
		sudoku_view_set_show_highlights (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_WARNINGS:
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



