/* gitg-lanes.c generated by valac 0.23.1.3-23cc3-dirty, the Vala compiler
 * generated from gitg-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_LANES (gitg_lanes_get_type ())
#define GITG_LANES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANES, GitgLanes))
#define GITG_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANES, GitgLanesClass))
#define GITG_IS_LANES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANES))
#define GITG_IS_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANES))
#define GITG_LANES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANES, GitgLanesClass))

typedef struct _GitgLanes GitgLanes;
typedef struct _GitgLanesClass GitgLanesClass;
typedef struct _GitgLanesPrivate GitgLanesPrivate;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;
typedef struct _GitgLanesLaneContainer GitgLanesLaneContainer;
typedef struct _GitgLanesCollapsedLane GitgLanesCollapsedLane;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __g_slist_free__gitg_lanes_lane_container_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__gitg_lanes_lane_container_free0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _gitg_lanes_lane_container_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_lane_container_free (var), NULL)))
#define _ggit_commit_parents_unref0(var) ((var == NULL) ? NULL : (var = (ggit_commit_parents_unref (var), NULL)))
#define _gitg_lanes_collapsed_lane_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _GitgLanes {
	GObject parent_instance;
	GitgLanesPrivate * priv;
};

struct _GitgLanesClass {
	GObjectClass parent_class;
};

struct _GitgLanesPrivate {
	gint _inactive_max;
	gint _inactive_collapse;
	gint _inactive_gap;
	gboolean _inactive_enabled;
	GSList* d_previous;
	GSList* d_lanes;
	GHashTable* d_collapsed;
};

struct _GitgLanesLaneContainer {
	GitgLane* lane;
	guint inactive;
	GgitOId* from;
	GgitOId* to;
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4
} GitgLaneTag;

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};

struct _GitgLanesCollapsedLane {
	GitgColor* color;
	guint index;
	GgitOId* from;
	GgitOId* to;
};


static gpointer gitg_lanes_parent_class = NULL;

GType gitg_lanes_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
static void gitg_lanes_lane_container_free (GitgLanesLaneContainer* self);
static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self);
#define GITG_LANES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_LANES, GitgLanesPrivate))
enum  {
	GITG_LANES_DUMMY_PROPERTY,
	GITG_LANES_INACTIVE_MAX,
	GITG_LANES_INACTIVE_COLLAPSE,
	GITG_LANES_INACTIVE_GAP,
	GITG_LANES_INACTIVE_ENABLED
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void _gitg_lanes_lane_container_free0_ (gpointer var);
static void _g_slist_free__gitg_lanes_lane_container_free0_ (GSList* self);
GitgLanes* gitg_lanes_new (void);
GitgLanes* gitg_lanes_construct (GType object_type);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void _gitg_lanes_collapsed_lane_free0_ (gpointer var);
void gitg_lanes_reset (GitgLanes* self);
void gitg_color_reset (void);
GType gitg_lane_get_type (void) G_GNUC_CONST;
GSList* gitg_lanes_next (GitgLanes* self, GitgCommit* next, gint* nextpos);
gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self);
static void gitg_lanes_collapse_lanes (GitgLanes* self);
static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit);
static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to);
GType gitg_color_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GitgColor* gitg_color_copy (GitgColor* self);
static GSList* gitg_lanes_lanes_list (GitgLanes* self);
static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos);
static void gitg_lanes_init_next_layer (GitgLanes* self);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
gint gitg_lanes_get_inactive_collapse (GitgLanes* self);
gint gitg_lanes_get_inactive_gap (GitgLanes* self);
static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
gint gitg_lanes_get_inactive_max (GitgLanes* self);
static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction);
static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index);
static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction);
static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane);
GitgLane* gitg_lane_new_with_color (GitgColor* color);
GitgLane* gitg_lane_construct_with_color (GType object_type, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color);
GitgLane* gitg_lane_copy (GitgLane* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id);
static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index);
void gitg_lanes_set_inactive_max (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value);
static void gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self);
static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self);
static void gitg_lanes_finalize (GObject* obj);
static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 220 "gitg-lanes.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_free (self);
#line 229 "gitg-lanes.c"
}


static void _gitg_lanes_lane_container_free0_ (gpointer var) {
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (gitg_lanes_lane_container_free (var), NULL));
#line 236 "gitg-lanes.c"
}


static void _g_slist_free__gitg_lanes_lane_container_free0_ (GSList* self) {
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_foreach (self, (GFunc) _gitg_lanes_lane_container_free0_, NULL);
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slist_free (self);
#line 245 "gitg-lanes.c"
}


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 254 "gitg-lanes.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 263 "gitg-lanes.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 270 "gitg-lanes.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 277 "gitg-lanes.c"
}


static void _gitg_lanes_collapsed_lane_free0_ (gpointer var) {
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL));
#line 284 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_construct (GType object_type) {
	GitgLanes * self = NULL;
	GHashTable* _tmp0_ = NULL;
#line 89 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanes*) g_object_new (object_type, NULL);
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, _gitg_lanes_collapsed_lane_free0_);
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 91 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_collapsed = _tmp0_;
#line 94 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_reset (self);
#line 89 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 303 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_new (void) {
#line 89 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_construct (GITG_TYPE_LANES);
#line 310 "gitg-lanes.c"
}


void gitg_lanes_reset (GitgLanes* self) {
	GHashTable* _tmp0_ = NULL;
#line 97 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_previous);
#line 99 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = NULL;
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__gitg_lanes_lane_container_free0_0 (self->priv->d_lanes);
#line 100 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_lanes = NULL;
#line 102 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_color_reset ();
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_collapsed;
#line 104 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_remove_all (_tmp0_);
#line 332 "gitg-lanes.c"
}


GSList* gitg_lanes_next (GitgLanes* self, GitgCommit* next, gint* nextpos) {
	gint _vala_nextpos = 0;
	GSList* result = NULL;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgLanesLaneContainer* mylane = NULL;
	GgitOId* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GitgLanesLaneContainer* _tmp6_ = NULL;
	GitgLanesLaneContainer* _tmp7_ = NULL;
	GSList* res = NULL;
	GSList* _tmp23_ = NULL;
	GitgCommit* _tmp24_ = NULL;
	gint _tmp25_ = 0;
#line 107 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (next != NULL, NULL);
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 110 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp1_;
#line 112 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->_inactive_enabled;
#line 112 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp2_) {
#line 366 "gitg-lanes.c"
		GitgCommit* _tmp3_ = NULL;
#line 114 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lanes (self);
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = next;
#line 115 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lanes (self, _tmp3_);
#line 374 "gitg-lanes.c"
	}
#line 118 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = myoid;
#line 118 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gitg_lanes_find_lane_by_oid (self, _tmp4_, &_tmp5_);
#line 118 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_vala_nextpos = _tmp5_;
#line 118 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	mylane = _tmp6_;
#line 120 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = mylane;
#line 120 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp7_ == NULL) {
#line 388 "gitg-lanes.c"
		GgitOId* _tmp8_ = NULL;
		GitgLanesLaneContainer* _tmp9_ = NULL;
		GSList* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = myoid;
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = gitg_lanes_lane_container_new (_tmp8_, NULL);
#line 123 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_lanes = g_slist_append (self->priv->d_lanes, _tmp9_);
#line 124 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = self->priv->d_lanes;
#line 124 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = g_slist_length (_tmp10_);
#line 124 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_vala_nextpos = ((gint) _tmp11_) - 1;
#line 405 "gitg-lanes.c"
	} else {
		GitgLanesLaneContainer* _tmp12_ = NULL;
		GitgLane* _tmp13_ = NULL;
		GitgLanesLaneContainer* _tmp14_ = NULL;
		GitgLane* _tmp15_ = NULL;
		GitgColor* _tmp16_ = NULL;
		GitgColor* _tmp17_ = NULL;
		GitgLanesLaneContainer* _tmp18_ = NULL;
		GitgLanesLaneContainer* _tmp19_ = NULL;
		GitgCommit* _tmp20_ = NULL;
		GgitOId* _tmp21_ = NULL;
		GitgLanesLaneContainer* _tmp22_ = NULL;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = mylane;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->lane;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = mylane;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->lane;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = _tmp15_->color;
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = gitg_color_copy (_tmp16_);
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_tmp13_->color);
#line 129 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_->color = _tmp17_;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp18_ = mylane;
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp18_->to);
#line 131 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp18_->to = NULL;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp19_ = mylane;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp20_ = next;
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp21_ = ggit_object_get_id ((GgitObject*) _tmp20_);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp19_->from);
#line 132 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp19_->from = _tmp21_;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp22_ = mylane;
#line 133 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp22_->inactive = (guint) 0;
#line 454 "gitg-lanes.c"
	}
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp23_ = gitg_lanes_lanes_list (self);
#line 136 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	res = _tmp23_;
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp24_ = next;
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp25_ = _vala_nextpos;
#line 137 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_prepare_lanes (self, _tmp24_, _tmp25_);
#line 139 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = res;
#line 139 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 139 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (nextpos) {
#line 139 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*nextpos = _vala_nextpos;
#line 474 "gitg-lanes.c"
	}
#line 139 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 478 "gitg-lanes.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 485 "gitg-lanes.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 492 "gitg-lanes.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self ? g_object_ref (self) : NULL;
#line 499 "gitg-lanes.c"
}


static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos) {
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitCommitParents* _tmp1_ = NULL;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgLanesLaneContainer* mylane = NULL;
	GSList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	gboolean _tmp76_ = FALSE;
	GitgLanesLaneContainer* _tmp77_ = NULL;
	gboolean _tmp80_ = FALSE;
	GSList* _tmp82_ = NULL;
	guint _tmp83_ = 0U;
	gint _tmp84_ = 0;
	gint _tmp85_ = 0;
	GitgCommit* _tmp88_ = NULL;
	GitgCommit* _tmp89_ = NULL;
#line 142 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (next != NULL);
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_commit_get_parents ((GgitCommit*) _tmp0_);
#line 144 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp1_;
#line 145 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = next;
#line 145 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 145 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp3_;
#line 147 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_init_next_layer (self);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_lanes;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = pos;
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = g_slist_nth_data (_tmp4_, (guint) _tmp5_);
#line 148 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	mylane = (GitgLanesLaneContainer*) _tmp6_;
#line 549 "gitg-lanes.c"
	{
		guint i = 0U;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 554 "gitg-lanes.c"
		{
			gboolean _tmp7_ = FALSE;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = TRUE;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 561 "gitg-lanes.c"
				gboolean _tmp8_ = FALSE;
				guint _tmp10_ = 0U;
				GgitCommitParents* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				gint lnpos = 0;
				GgitOId* poid = NULL;
				GgitCommitParents* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				GgitOId* _tmp15_ = NULL;
				GitgLanesLaneContainer* container = NULL;
				GgitOId* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GitgLanesLaneContainer* _tmp18_ = NULL;
				GitgLanesLaneContainer* _tmp19_ = NULL;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = _tmp7_;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp8_) {
#line 580 "gitg-lanes.c"
					guint _tmp9_ = 0U;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp9_ = i;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					i = _tmp9_ + 1;
#line 586 "gitg-lanes.c"
				}
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = FALSE;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = i;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = parents;
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = ggit_commit_parents_size (_tmp11_);
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp10_ < _tmp12_)) {
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					break;
#line 600 "gitg-lanes.c"
				}
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = parents;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = i;
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = ggit_commit_parents_get_id (_tmp13_, _tmp14_);
#line 153 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				poid = _tmp15_;
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = poid;
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp18_ = gitg_lanes_find_lane_by_oid (self, _tmp16_, &_tmp17_);
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				lnpos = _tmp17_;
#line 155 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				container = _tmp18_;
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp19_ = container;
#line 157 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (_tmp19_ != NULL) {
#line 622 "gitg-lanes.c"
					gboolean _tmp20_ = FALSE;
					guint _tmp21_ = 0U;
					gboolean _tmp24_ = FALSE;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp21_ = i;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp21_ == ((guint) 0)) {
#line 630 "gitg-lanes.c"
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp22_ = pos;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp23_ = lnpos;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp20_ = _tmp22_ < _tmp23_;
#line 639 "gitg-lanes.c"
					} else {
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp20_ = FALSE;
#line 643 "gitg-lanes.c"
					}
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp24_ = _tmp20_;
#line 161 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp24_) {
#line 649 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp25_ = NULL;
						GgitOId* _tmp26_ = NULL;
						GgitOId* _tmp27_ = NULL;
						GitgLanesLaneContainer* _tmp28_ = NULL;
						GgitOId* _tmp29_ = NULL;
						GgitOId* _tmp30_ = NULL;
						GitgLanesLaneContainer* _tmp31_ = NULL;
						GitgLane* _tmp32_ = NULL;
						gint _tmp33_ = 0;
						GitgLanesLaneContainer* _tmp34_ = NULL;
						GitgLane* _tmp35_ = NULL;
						GitgLanesLaneContainer* _tmp36_ = NULL;
						GitgLane* _tmp37_ = NULL;
						GitgColor* _tmp38_ = NULL;
						GitgColor* _tmp39_ = NULL;
						GitgLanesLaneContainer* _tmp40_ = NULL;
						GitgLanesLaneContainer* _tmp41_ = NULL;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp25_ = mylane;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp26_ = poid;
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp27_ = __vala_GgitOId_copy0 (_tmp26_);
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp25_->to);
#line 167 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp25_->to = _tmp27_;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp28_ = mylane;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp29_ = myoid;
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp30_ = __vala_GgitOId_copy0 (_tmp29_);
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp28_->from);
#line 168 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp28_->from = _tmp30_;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp31_ = mylane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp32_ = _tmp31_->lane;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp33_ = lnpos;
#line 169 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp32_->from = g_slist_append (_tmp32_->from, (gpointer) ((gintptr) _tmp33_));
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp34_ = mylane;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp35_ = _tmp34_->lane;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp36_ = mylane;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp37_ = _tmp36_->lane;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp38_ = _tmp37_->color;
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp39_ = gitg_color_copy (_tmp38_);
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp35_->color);
#line 170 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp35_->color = _tmp39_;
#line 171 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp40_ = mylane;
#line 171 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp40_->inactive = (guint) 0;
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp41_ = container;
#line 172 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						self->priv->d_lanes = g_slist_remove (self->priv->d_lanes, _tmp41_);
#line 719 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* _tmp42_ = NULL;
						GgitOId* _tmp43_ = NULL;
						GgitOId* _tmp44_ = NULL;
						GitgLanesLaneContainer* _tmp45_ = NULL;
						GitgLane* _tmp46_ = NULL;
						gint _tmp47_ = 0;
						GitgLanesLaneContainer* _tmp48_ = NULL;
						GitgLane* _tmp49_ = NULL;
						GitgLanesLaneContainer* _tmp50_ = NULL;
						GitgLane* _tmp51_ = NULL;
						GitgColor* _tmp52_ = NULL;
						GitgColor* _tmp53_ = NULL;
						GitgLanesLaneContainer* _tmp54_ = NULL;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp42_ = container;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp43_ = myoid;
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp44_ = __vala_GgitOId_copy0 (_tmp43_);
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp42_->from);
#line 176 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp42_->from = _tmp44_;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp45_ = container;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp46_ = _tmp45_->lane;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp47_ = pos;
#line 177 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp46_->from = g_slist_append (_tmp46_->from, (gpointer) ((gintptr) _tmp47_));
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp48_ = container;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp49_ = _tmp48_->lane;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp50_ = container;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp51_ = _tmp50_->lane;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp52_ = _tmp51_->color;
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp53_ = gitg_color_copy (_tmp52_);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp49_->color);
#line 178 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp49_->color = _tmp53_;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp54_ = container;
#line 179 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp54_->inactive = (guint) 0;
#line 772 "gitg-lanes.c"
					}
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (poid);
#line 182 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					continue;
#line 778 "gitg-lanes.c"
				} else {
					gboolean _tmp55_ = FALSE;
					GitgLanesLaneContainer* _tmp56_ = NULL;
					gboolean _tmp59_ = FALSE;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp56_ = mylane;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp56_ != NULL) {
#line 787 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp57_ = NULL;
						GgitOId* _tmp58_ = NULL;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp57_ = mylane;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp58_ = _tmp57_->to;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp55_ = _tmp58_ == NULL;
#line 796 "gitg-lanes.c"
					} else {
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp55_ = FALSE;
#line 800 "gitg-lanes.c"
					}
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp59_ = _tmp55_;
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					if (_tmp59_) {
#line 806 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp60_ = NULL;
						GgitOId* _tmp61_ = NULL;
						GgitOId* _tmp62_ = NULL;
						GitgLanesLaneContainer* _tmp63_ = NULL;
						GitgLane* _tmp64_ = NULL;
						GitgLanesLaneContainer* _tmp65_ = NULL;
						GitgLane* _tmp66_ = NULL;
						GitgColor* _tmp67_ = NULL;
						GitgColor* _tmp68_ = NULL;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp60_ = mylane;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp61_ = poid;
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp62_ = __vala_GgitOId_copy0 (_tmp61_);
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp60_->to);
#line 188 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp60_->to = _tmp62_;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp63_ = mylane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp64_ = _tmp63_->lane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp65_ = mylane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp66_ = _tmp65_->lane;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp67_ = _tmp66_->color;
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp68_ = gitg_color_copy (_tmp67_);
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp64_->color);
#line 190 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp64_->color = _tmp68_;
#line 842 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* newlane = NULL;
						GgitOId* _tmp69_ = NULL;
						GgitOId* _tmp70_ = NULL;
						GitgLanesLaneContainer* _tmp71_ = NULL;
						GitgLanesLaneContainer* _tmp72_ = NULL;
						GitgLane* _tmp73_ = NULL;
						gint _tmp74_ = 0;
						GitgLanesLaneContainer* _tmp75_ = NULL;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp69_ = myoid;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp70_ = poid;
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp71_ = gitg_lanes_lane_container_new (_tmp69_, _tmp70_);
#line 195 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						newlane = _tmp71_;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp72_ = newlane;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp73_ = _tmp72_->lane;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp74_ = pos;
#line 197 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp73_->from = g_slist_prepend (_tmp73_->from, (gpointer) ((gintptr) _tmp74_));
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_tmp75_ = newlane;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						newlane = NULL;
#line 198 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						self->priv->d_lanes = g_slist_append (self->priv->d_lanes, _tmp75_);
#line 184 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
						_gitg_lanes_lane_container_free0 (newlane);
#line 876 "gitg-lanes.c"
					}
				}
#line 150 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (poid);
#line 881 "gitg-lanes.c"
			}
		}
	}
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp77_ = mylane;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp77_ != NULL) {
#line 889 "gitg-lanes.c"
		GitgLanesLaneContainer* _tmp78_ = NULL;
		GgitOId* _tmp79_ = NULL;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp78_ = mylane;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp79_ = _tmp78_->to;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = _tmp79_ == NULL;
#line 898 "gitg-lanes.c"
	} else {
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = FALSE;
#line 902 "gitg-lanes.c"
	}
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp80_ = _tmp76_;
#line 202 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp80_) {
#line 908 "gitg-lanes.c"
		GitgLanesLaneContainer* _tmp81_ = NULL;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp81_ = mylane;
#line 205 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_lanes = g_slist_remove (self->priv->d_lanes, _tmp81_);
#line 914 "gitg-lanes.c"
	}
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp82_ = self->priv->d_previous;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp83_ = g_slist_length (_tmp82_);
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp84_ = self->priv->_inactive_collapse;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp85_ = self->priv->_inactive_gap;
#line 209 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp83_ == ((guint) ((_tmp84_ + _tmp85_) + 1))) {
#line 926 "gitg-lanes.c"
		GSList* _tmp86_ = NULL;
		GSList* _tmp87_ = NULL;
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp86_ = self->priv->d_previous;
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp87_ = g_slist_last (_tmp86_);
#line 211 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_previous = g_slist_delete_link (self->priv->d_previous, _tmp87_);
#line 935 "gitg-lanes.c"
	}
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp88_ = next;
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp89_ = _g_object_ref0 (_tmp88_);
#line 214 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = g_slist_prepend (self->priv->d_previous, _tmp89_);
#line 142 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 142 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_ggit_commit_parents_unref0 (parents);
#line 947 "gitg-lanes.c"
}


static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLanesCollapsedLane* _tmp1_ = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GHashTable* _tmp4_ = NULL;
	GitgLanesLaneContainer* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GitgLanesCollapsedLane* _tmp8_ = NULL;
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lanes_collapsed_lane_new (_tmp0_);
#line 220 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = _tmp1_;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = collapsed;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 221 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->index = (guint) _tmp3_;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_collapsed;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = container;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = _tmp5_->to;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = __vala_GgitOId_copy0 (_tmp6_);
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = collapsed;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = NULL;
#line 223 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
#line 217 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_collapsed_lane_free0 (collapsed);
#line 994 "gitg-lanes.c"
}


static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesLaneContainer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSList* item = NULL;
	GSList* _tmp2_ = NULL;
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = index;
#line 229 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_add_collapsed (self, _tmp0_, _tmp1_);
#line 231 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->d_previous;
#line 231 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	item = _tmp2_;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1019 "gitg-lanes.c"
		GSList* _tmp3_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		GitgCommit* _tmp6_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp7_ = NULL;
		GSList* _tmp8_ = NULL;
		GitgLane* lane = NULL;
		GSList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gconstpointer _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
		GSList* _tmp13_ = NULL;
		GSList* _tmp42_ = NULL;
		GSList* _tmp43_ = NULL;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = item;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp3_ != NULL)) {
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1042 "gitg-lanes.c"
		}
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = item;
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = _tmp4_->data;
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _g_object_ref0 ((GitgCommit*) _tmp5_);
#line 235 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp6_;
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = commit;
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = gitg_commit_get_lanes (_tmp7_);
#line 236 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp8_;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = lns;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = index;
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = g_slist_nth_data (_tmp9_, (guint) _tmp10_);
#line 237 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lane = (GitgLane*) _tmp11_;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = item;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->next;
#line 239 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp13_ != NULL) {
#line 1072 "gitg-lanes.c"
			gint newindex = 0;
			GitgLane* _tmp14_ = NULL;
			GSList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			GitgCommit* _tmp17_ = NULL;
			GitgLane* _tmp18_ = NULL;
			GSList* _tmp19_ = NULL;
			GSList* _tmp20_ = NULL;
			GSList* _tmp21_ = NULL;
			GSList* _tmp22_ = NULL;
			guint mylane = 0U;
			GitgCommit* _tmp25_ = NULL;
			guint _tmp26_ = 0U;
			guint _tmp27_ = 0U;
			guint _tmp28_ = 0U;
			gint _tmp29_ = 0;
			gint _tmp34_ = 0;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = lane;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = _tmp14_->from;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp16_ = _tmp15_->data;
#line 241 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			newindex = (gint) ((gintptr) _tmp16_);
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp17_ = commit;
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = lane;
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp19_ = gitg_commit_remove_lane (_tmp17_, _tmp18_);
#line 243 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			lns = _tmp19_;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp20_ = item;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp21_ = _tmp20_->next;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp22_ = _tmp21_->next;
#line 245 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp22_ != NULL) {
#line 1114 "gitg-lanes.c"
				GSList* _tmp23_ = NULL;
				gint _tmp24_ = 0;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp23_ = lns;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp24_ = newindex;
#line 247 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_merge_indices (self, _tmp23_, _tmp24_, -1);
#line 1123 "gitg-lanes.c"
			}
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp25_ = commit;
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp26_ = gitg_commit_get_mylane (_tmp25_);
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp27_ = _tmp26_;
#line 250 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			mylane = _tmp27_;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp28_ = mylane;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp29_ = index;
#line 252 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp28_ > ((guint) _tmp29_)) {
#line 1139 "gitg-lanes.c"
				GitgCommit* _tmp30_ = NULL;
				GitgCommit* _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				guint _tmp33_ = 0U;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp30_ = commit;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp31_ = commit;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp32_ = gitg_commit_get_mylane (_tmp31_);
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp33_ = _tmp32_;
#line 254 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_commit_set_mylane (_tmp31_, _tmp33_ - 1);
#line 1154 "gitg-lanes.c"
			}
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp34_ = newindex;
#line 257 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			index = _tmp34_;
#line 1160 "gitg-lanes.c"
		} else {
			GitgLane* _tmp35_ = NULL;
			GitgLane* _tmp36_ = NULL;
			GitgLaneTag _tmp37_ = 0;
			GitgLane* _tmp38_ = NULL;
			GitgLanesLaneContainer* _tmp39_ = NULL;
			GgitOId* _tmp40_ = NULL;
			GgitOId* _tmp41_ = NULL;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp35_ = lane;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp36_ = lane;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp37_ = _tmp36_->tag;
#line 261 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp36_->tag = _tmp37_ | GITG_LANE_TAG_END;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp38_ = lane;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = container;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp40_ = _tmp39_->to;
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = __vala_GgitOId_copy0 (_tmp40_);
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp38_->boundary_id);
#line 262 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp38_->boundary_id = _tmp41_;
#line 1189 "gitg-lanes.c"
		}
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = item;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 265 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		item = _tmp43_;
#line 233 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1199 "gitg-lanes.c"
	}
}


static void gitg_lanes_collapse_lanes (GitgLanes* self) {
	gint index = 0;
	GSList* item = NULL;
	GSList* _tmp0_ = NULL;
#line 269 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 272 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	item = _tmp0_;
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1218 "gitg-lanes.c"
		GSList* _tmp1_ = NULL;
		GitgLanesLaneContainer* container = NULL;
		GSList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		GitgLanesLaneContainer* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GitgLanesLaneContainer* _tmp11_ = NULL;
		GitgLanesLaneContainer* _tmp12_ = NULL;
		GitgLane* _tmp13_ = NULL;
		GSList* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gint _tmp16_ = 0;
		GSList* next = NULL;
		GSList* _tmp17_ = NULL;
		GSList* _tmp18_ = NULL;
		GSList* _tmp19_ = NULL;
		GSList* _tmp20_ = NULL;
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = item;
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp1_ != NULL)) {
#line 274 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1244 "gitg-lanes.c"
		}
#line 276 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = item;
#line 276 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = _tmp2_->data;
#line 276 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container = (GitgLanesLaneContainer*) _tmp3_;
#line 278 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = container;
#line 278 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = _tmp4_->inactive;
#line 278 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = self->priv->_inactive_max;
#line 278 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = self->priv->_inactive_gap;
#line 278 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp5_ != ((guint) (_tmp6_ + _tmp7_))) {
#line 1262 "gitg-lanes.c"
			GSList* _tmp8_ = NULL;
			GSList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
#line 280 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = item;
#line 280 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _tmp8_->next;
#line 280 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			item = _tmp9_;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = index;
#line 281 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			index = _tmp10_ + 1;
#line 282 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			continue;
#line 1278 "gitg-lanes.c"
		}
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = container;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = container;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->lane;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->from;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->data;
#line 285 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lane (self, _tmp11_, (gint) ((gintptr) _tmp15_));
#line 286 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = index;
#line 286 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_update_current_lane_merge_indices (self, _tmp16_, -1);
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = item;
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp18_ = _tmp17_->next;
#line 288 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		next = _tmp18_;
#line 289 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp19_ = item;
#line 289 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_lanes = g_slist_remove_link (self->priv->d_lanes, _tmp19_);
#line 290 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp20_ = next;
#line 290 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		item = _tmp20_;
#line 1310 "gitg-lanes.c"
	}
}


static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index) {
	gint result = 0;
	guint len = 0U;
	GitgCommit* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
#line 294 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 294 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (commit != NULL, 0);
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_slist_length (_tmp1_);
#line 297 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	len = _tmp2_;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = len;
#line 299 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (((guint) _tmp3_) > _tmp4_) {
#line 1341 "gitg-lanes.c"
		guint _tmp5_ = 0U;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = len;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		result = (gint) _tmp5_;
#line 301 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1349 "gitg-lanes.c"
	} else {
		gint _tmp6_ = 0;
#line 305 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = index;
#line 305 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		result = _tmp6_;
#line 305 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1358 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction) {
#line 309 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1368 "gitg-lanes.c"
		GSList* _tmp0_ = NULL;
		gint idx = 0;
		GSList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gboolean _tmp11_ = FALSE;
		GSList* _tmp15_ = NULL;
		GSList* _tmp16_ = NULL;
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = from;
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp0_ != NULL)) {
#line 313 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1385 "gitg-lanes.c"
		}
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = from;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _tmp1_->data;
#line 315 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		idx = (gint) ((gintptr) _tmp2_);
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = idx;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = index;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp4_ > _tmp5_) {
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = TRUE;
#line 1401 "gitg-lanes.c"
		} else {
			gboolean _tmp6_ = FALSE;
			gint _tmp7_ = 0;
			gboolean _tmp10_ = FALSE;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = direction;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (_tmp7_ > 0) {
#line 1410 "gitg-lanes.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = idx;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = index;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = _tmp8_ == _tmp9_;
#line 1419 "gitg-lanes.c"
			} else {
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = FALSE;
#line 1423 "gitg-lanes.c"
			}
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = _tmp6_;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = _tmp10_;
#line 1429 "gitg-lanes.c"
		}
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = _tmp3_;
#line 317 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp11_) {
#line 1435 "gitg-lanes.c"
			GSList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = from;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = idx;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = direction;
#line 319 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_->data = (gpointer) ((gintptr) (_tmp13_ + _tmp14_));
#line 1447 "gitg-lanes.c"
		}
#line 322 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = from;
#line 322 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = _tmp15_->next;
#line 322 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		from = _tmp16_;
#line 1455 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction) {
	GSList* _tmp0_ = NULL;
#line 326 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lanes;
#line 1466 "gitg-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lane_collection = _tmp0_;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 1474 "gitg-lanes.c"
			GitgLane* lane = NULL;
#line 330 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			lane = (GitgLane*) lane_it->data;
#line 1478 "gitg-lanes.c"
			{
				GitgLane* _tmp1_ = NULL;
				GSList* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 332 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = lane;
#line 332 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->from;
#line 332 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = index;
#line 332 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp4_ = direction;
#line 332 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_lane_merge_indices (self, _tmp2_, _tmp3_, _tmp4_);
#line 1494 "gitg-lanes.c"
			}
		}
	}
}


static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction) {
	GSList* _tmp0_ = NULL;
#line 335 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 1507 "gitg-lanes.c"
	{
		GSList* container_collection = NULL;
		GSList* container_it = NULL;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container_collection = _tmp0_;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		for (container_it = container_collection; container_it != NULL; container_it = container_it->next) {
#line 1515 "gitg-lanes.c"
			GitgLanesLaneContainer* container = NULL;
#line 338 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) container_it->data;
#line 1519 "gitg-lanes.c"
			{
				GitgLanesLaneContainer* _tmp1_ = NULL;
				GitgLane* _tmp2_ = NULL;
				GSList* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = container;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->lane;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = _tmp2_->from;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp4_ = index;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = direction;
#line 340 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_lane_merge_indices (self, _tmp3_, _tmp4_, _tmp5_);
#line 1538 "gitg-lanes.c"
			}
		}
	}
}


static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane) {
	guint index = 0U;
	GitgLanesCollapsedLane* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GitgLane* ln = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	guint len = 0U;
	GSList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	gint next = 0;
	GSList* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gint _tmp13_ = 0;
	GitgLanesLaneContainer* container = NULL;
	GitgLanesCollapsedLane* _tmp14_ = NULL;
	GgitOId* _tmp15_ = NULL;
	GitgLanesCollapsedLane* _tmp16_ = NULL;
	GgitOId* _tmp17_ = NULL;
	GitgLanesCollapsedLane* _tmp18_ = NULL;
	GitgColor* _tmp19_ = NULL;
	GitgLanesLaneContainer* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	GitgLanesLaneContainer* _tmp22_ = NULL;
	GitgLane* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GitgLanesLaneContainer* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gint _tmp27_ = 0;
	guint cnt = 0U;
	GSList* ptr = NULL;
	GSList* _tmp28_ = NULL;
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (lane != NULL);
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lane;
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->index;
#line 348 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = _tmp1_;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = lane;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _tmp2_->color;
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = gitg_lane_new_with_color (_tmp3_);
#line 349 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ln = _tmp4_;
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->priv->d_lanes;
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = g_slist_length (_tmp5_);
#line 350 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	len = _tmp6_;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = index;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = len;
#line 352 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp7_ > _tmp8_) {
#line 1611 "gitg-lanes.c"
		guint _tmp9_ = 0U;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = len;
#line 354 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		index = _tmp9_;
#line 1617 "gitg-lanes.c"
	}
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp10_ = self->priv->d_previous;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = _tmp10_->data;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = index;
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp13_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp11_, (gint) _tmp12_);
#line 357 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	next = _tmp13_;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = lane;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp15_ = _tmp14_->from;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp16_ = lane;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp17_ = _tmp16_->to;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp18_ = lane;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp19_ = _tmp18_->color;
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp20_ = gitg_lanes_lane_container_new_with_color (_tmp15_, _tmp17_, _tmp19_);
#line 359 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	container = _tmp20_;
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp21_ = index;
#line 363 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_update_current_lane_merge_indices (self, (gint) _tmp21_, 1);
#line 365 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp22_ = container;
#line 365 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp23_ = _tmp22_->lane;
#line 365 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp24_ = next;
#line 365 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp23_->from = g_slist_prepend (_tmp23_->from, (gpointer) ((gintptr) _tmp24_));
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp25_ = container;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	container = NULL;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp26_ = index;
#line 366 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_lanes = g_slist_insert (self->priv->d_lanes, _tmp25_, (gint) _tmp26_);
#line 368 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp27_ = next;
#line 368 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = (guint) _tmp27_;
#line 369 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	cnt = (guint) 0;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp28_ = self->priv->d_previous;
#line 371 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ptr = _tmp28_;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1677 "gitg-lanes.c"
		GSList* _tmp29_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
		GitgCommit* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		gint _tmp34_ = 0;
		GitgLane* copy = NULL;
		GitgLane* _tmp35_ = NULL;
		GitgLane* _tmp36_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp37_ = NULL;
		GSList* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		GSList* _tmp40_ = NULL;
		GSList* _tmp41_ = NULL;
		gboolean _tmp44_ = FALSE;
		GitgCommit* _tmp61_ = NULL;
		GitgLane* _tmp62_ = NULL;
		guint _tmp63_ = 0U;
		guint mylane = 0U;
		GitgCommit* _tmp64_ = NULL;
		guint _tmp65_ = 0U;
		guint _tmp66_ = 0U;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		gint _tmp73_ = 0;
		guint _tmp74_ = 0U;
		GSList* _tmp75_ = NULL;
		GSList* _tmp76_ = NULL;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp29_ = ptr;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp29_ != NULL)) {
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1714 "gitg-lanes.c"
		}
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp30_ = ptr;
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = _tmp30_->data;
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp32_ = _g_object_ref0 ((GitgCommit*) _tmp31_);
#line 375 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp32_;
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp33_ = cnt;
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = self->priv->_inactive_collapse;
#line 377 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp33_ == ((guint) _tmp34_)) {
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_g_object_unref0 (commit);
#line 379 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1734 "gitg-lanes.c"
		}
#line 383 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = ln;
#line 383 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = gitg_lane_copy (_tmp35_);
#line 383 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		copy = _tmp36_;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp37_ = commit;
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp38_ = gitg_commit_get_lanes (_tmp37_);
#line 384 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp38_;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp40_ = ptr;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp41_ = _tmp40_->next;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp41_ == NULL) {
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = TRUE;
#line 1756 "gitg-lanes.c"
		} else {
			guint _tmp42_ = 0U;
			gint _tmp43_ = 0;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp42_ = cnt;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp43_ = self->priv->_inactive_collapse;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = (_tmp42_ + 1) == ((guint) _tmp43_);
#line 1766 "gitg-lanes.c"
		}
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp44_ = _tmp39_;
#line 386 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp44_) {
#line 1772 "gitg-lanes.c"
			GitgLane* _tmp45_ = NULL;
			GitgLanesCollapsedLane* _tmp46_ = NULL;
			GgitOId* _tmp47_ = NULL;
			GgitOId* _tmp48_ = NULL;
			GitgLane* _tmp49_ = NULL;
			GitgLane* _tmp50_ = NULL;
			GitgLaneTag _tmp51_ = 0;
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp45_ = copy;
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = lane;
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp47_ = _tmp46_->from;
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp48_ = __vala_GgitOId_copy0 (_tmp47_);
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp45_->boundary_id);
#line 388 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp45_->boundary_id = _tmp48_;
#line 389 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp49_ = copy;
#line 389 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp50_ = copy;
#line 389 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp51_ = _tmp50_->tag;
#line 389 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp50_->tag = _tmp51_ | GITG_LANE_TAG_START;
#line 1800 "gitg-lanes.c"
		} else {
			GSList* _tmp52_ = NULL;
			GSList* _tmp53_ = NULL;
			gconstpointer _tmp54_ = NULL;
			guint _tmp55_ = 0U;
			gint _tmp56_ = 0;
			GitgLane* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			GSList* _tmp59_ = NULL;
			guint _tmp60_ = 0U;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp52_ = ptr;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp53_ = _tmp52_->next;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp54_ = _tmp53_->data;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp55_ = index;
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp56_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp54_, (gint) _tmp55_);
#line 393 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			next = _tmp56_;
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp57_ = copy;
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp58_ = next;
#line 394 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp57_->from = g_slist_prepend (_tmp57_->from, (gpointer) ((gintptr) _tmp58_));
#line 396 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp59_ = lns;
#line 396 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp60_ = index;
#line 396 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_merge_indices (self, _tmp59_, (gint) _tmp60_, 1);
#line 1835 "gitg-lanes.c"
		}
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp61_ = commit;
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp62_ = copy;
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp63_ = index;
#line 399 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_commit_insert_lane (_tmp61_, _tmp62_, (gint) _tmp63_);
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp64_ = commit;
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp65_ = gitg_commit_get_mylane (_tmp64_);
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp66_ = _tmp65_;
#line 401 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp66_;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp67_ = mylane;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp68_ = index;
#line 403 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp67_ >= _tmp68_) {
#line 1859 "gitg-lanes.c"
			GitgCommit* _tmp69_ = NULL;
			GitgCommit* _tmp70_ = NULL;
			guint _tmp71_ = 0U;
			guint _tmp72_ = 0U;
#line 405 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp69_ = commit;
#line 405 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp70_ = commit;
#line 405 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp71_ = gitg_commit_get_mylane (_tmp70_);
#line 405 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp72_ = _tmp71_;
#line 405 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			gitg_commit_set_mylane (_tmp70_, _tmp72_ + 1);
#line 1874 "gitg-lanes.c"
		}
#line 408 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp73_ = next;
#line 408 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp73_;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp74_ = cnt;
#line 409 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		cnt = _tmp74_ + 1;
#line 411 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = ptr;
#line 411 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = _tmp75_->next;
#line 411 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		ptr = _tmp76_;
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (copy);
#line 373 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1894 "gitg-lanes.c"
	}
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_free0 (container);
#line 346 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (ln);
#line 1900 "gitg-lanes.c"
}


static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GitgLanesCollapsedLane* _tmp3_ = NULL;
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (id != NULL);
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_collapsed;
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = id;
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 417 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	collapsed = (GitgLanesCollapsedLane*) _tmp2_;
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = collapsed;
#line 419 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 1926 "gitg-lanes.c"
		GitgLanesCollapsedLane* _tmp4_ = NULL;
		GHashTable* _tmp5_ = NULL;
		GgitOId* _tmp6_ = NULL;
#line 421 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = collapsed;
#line 421 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lane (self, _tmp4_);
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->priv->d_collapsed;
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = id;
#line 422 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_hash_table_remove (_tmp5_, _tmp6_);
#line 1940 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit) {
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp3_ = NULL;
	GgitCommitParents* _tmp4_ = NULL;
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (commit != NULL);
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_;
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_expand_lane_from_oid (self, _tmp2_);
#line 428 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = commit;
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = ggit_commit_get_parents ((GgitCommit*) _tmp3_);
#line 430 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp4_;
#line 1972 "gitg-lanes.c"
	{
		guint i = 0U;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 1977 "gitg-lanes.c"
		{
			gboolean _tmp5_ = FALSE;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = TRUE;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 1984 "gitg-lanes.c"
				gboolean _tmp6_ = FALSE;
				guint _tmp8_ = 0U;
				GgitCommitParents* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				GgitCommitParents* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				GgitOId* _tmp13_ = NULL;
				GgitOId* _tmp14_ = NULL;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = _tmp5_;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp6_) {
#line 1997 "gitg-lanes.c"
					guint _tmp7_ = 0U;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					_tmp7_ = i;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					i = _tmp7_ + 1;
#line 2003 "gitg-lanes.c"
				}
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = FALSE;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = i;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = parents;
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = ggit_commit_parents_size (_tmp9_);
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp8_ < _tmp10_)) {
#line 432 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
					break;
#line 2017 "gitg-lanes.c"
				}
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = parents;
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = i;
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = ggit_commit_parents_get_id (_tmp11_, _tmp12_);
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = _tmp13_;
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_expand_lane_from_oid (self, _tmp14_);
#line 434 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (_tmp14_);
#line 2031 "gitg-lanes.c"
			}
		}
	}
#line 426 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_ggit_commit_parents_unref0 (parents);
#line 2037 "gitg-lanes.c"
}


static void gitg_lanes_init_next_layer (GitgLanes* self) {
	gint index = 0;
	GSList* _tmp0_ = NULL;
#line 438 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 440 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 2050 "gitg-lanes.c"
	{
		GSList* container_collection = NULL;
		GSList* container_it = NULL;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container_collection = _tmp0_;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		for (container_it = container_collection; container_it != NULL; container_it = container_it->next) {
#line 2058 "gitg-lanes.c"
			GitgLanesLaneContainer* container = NULL;
#line 442 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) container_it->data;
#line 2062 "gitg-lanes.c"
			{
				GitgLanesLaneContainer* _tmp1_ = NULL;
				gint _tmp2_ = 0;
#line 444 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = container;
#line 444 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = index;
#line 444 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				index = _tmp2_ + 1;
#line 444 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_lane_container_next (_tmp1_, _tmp2_);
#line 2074 "gitg-lanes.c"
			}
		}
	}
}


static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos) {
	gint _vala_pos = 0;
	GitgLanesLaneContainer* result = NULL;
	gint p = 0;
	GSList* ptr = NULL;
	GSList* _tmp0_ = NULL;
#line 448 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 451 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	p = 0;
#line 452 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 452 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ptr = _tmp0_;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 2099 "gitg-lanes.c"
		GSList* _tmp1_ = NULL;
		GitgLanesLaneContainer* container = NULL;
		GSList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GitgLanesLaneContainer* _tmp5_ = NULL;
		gboolean _tmp10_ = FALSE;
		gint _tmp13_ = 0;
		GSList* _tmp14_ = NULL;
		GSList* _tmp15_ = NULL;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = ptr;
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp1_ != NULL)) {
#line 454 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			break;
#line 2116 "gitg-lanes.c"
		}
#line 456 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = ptr;
#line 456 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = _tmp2_->data;
#line 456 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container = (GitgLanesLaneContainer*) _tmp3_;
#line 458 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = container;
#line 458 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp5_ != NULL) {
#line 2128 "gitg-lanes.c"
			GgitOId* _tmp6_ = NULL;
			GitgLanesLaneContainer* _tmp7_ = NULL;
			GgitOId* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
#line 459 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = id;
#line 459 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = container;
#line 459 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _tmp7_->to;
#line 459 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = ggit_oid_equal (_tmp6_, _tmp8_);
#line 459 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp4_ = _tmp9_;
#line 2143 "gitg-lanes.c"
		} else {
#line 458 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp4_ = FALSE;
#line 2147 "gitg-lanes.c"
		}
#line 458 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = _tmp4_;
#line 458 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		if (_tmp10_) {
#line 2153 "gitg-lanes.c"
			gint _tmp11_ = 0;
			GitgLanesLaneContainer* _tmp12_ = NULL;
#line 461 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = p;
#line 461 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_vala_pos = _tmp11_;
#line 462 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = container;
#line 462 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			result = _tmp12_;
#line 462 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			if (pos) {
#line 462 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				*pos = _vala_pos;
#line 2168 "gitg-lanes.c"
			}
#line 462 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			return result;
#line 2172 "gitg-lanes.c"
		}
#line 465 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = p;
#line 465 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		p = _tmp13_ + 1;
#line 466 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = ptr;
#line 466 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->next;
#line 466 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		ptr = _tmp15_;
#line 2184 "gitg-lanes.c"
	}
#line 469 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_vala_pos = -1;
#line 470 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = NULL;
#line 470 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (pos) {
#line 470 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		*pos = _vala_pos;
#line 2194 "gitg-lanes.c"
	}
#line 470 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2198 "gitg-lanes.c"
}


static GSList* gitg_lanes_lanes_list (GitgLanes* self) {
	GSList* result = NULL;
	GSList* ret = NULL;
	GSList* _tmp0_ = NULL;
#line 473 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 475 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ret = NULL;
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 2212 "gitg-lanes.c"
	{
		GSList* container_collection = NULL;
		GSList* container_it = NULL;
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		container_collection = _tmp0_;
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		for (container_it = container_collection; container_it != NULL; container_it = container_it->next) {
#line 2220 "gitg-lanes.c"
			GitgLanesLaneContainer* container = NULL;
#line 477 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) container_it->data;
#line 2224 "gitg-lanes.c"
			{
				GitgLanesLaneContainer* _tmp1_ = NULL;
				GitgLane* _tmp2_ = NULL;
				GitgLane* _tmp3_ = NULL;
#line 479 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = container;
#line 479 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->lane;
#line 479 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = gitg_lane_copy (_tmp2_);
#line 479 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
				ret = g_slist_prepend (ret, _tmp3_);
#line 2237 "gitg-lanes.c"
			}
		}
	}
#line 482 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	ret = g_slist_reverse (ret);
#line 483 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = ret;
#line 483 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2247 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_max (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_max;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2262 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_max (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_max = _tmp0_;
#line 25 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-max");
#line 2276 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_collapse (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_collapse;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2291 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_collapse = _tmp0_;
#line 26 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-collapse");
#line 2305 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_gap (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_gap;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2320 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_gap = _tmp0_;
#line 27 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-gap");
#line 2334 "gitg-lanes.c"
}


gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_enabled;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2349 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_enabled = _tmp0_;
#line 28 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-enabled");
#line 2363 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color) {
	GitgLanesLaneContainer* self;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgColor* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = g_slice_new0 (GitgLanesLaneContainer);
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_instance_init (self);
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = __vala_GgitOId_copy0 (_tmp0_);
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 46 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp1_;
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = to;
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 47 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp3_;
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = color;
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = gitg_lane_new_with_color (_tmp4_);
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 48 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp5_;
#line 49 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->inactive = (guint) 0;
#line 42 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2407 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to) {
	GitgLanesLaneContainer* self;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
#line 52 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_instance_init (self);
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = to;
#line 55 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) gitg_lanes_lane_container_new_with_color (_tmp0_, _tmp1_, NULL);
#line 52 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2425 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index) {
	GitgLane* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	GitgLane* _tmp2_ = NULL;
	GitgLane* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GgitOId* _tmp6_ = NULL;
#line 58 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->lane;
#line 60 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lane_copy (_tmp0_);
#line 60 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 60 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp1_;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->lane;
#line 62 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->tag = GITG_LANE_TAG_NONE;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = self->lane;
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (_tmp3_->from);
#line 63 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_->from = NULL;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->lane;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = index;
#line 64 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_->from = g_slist_prepend (_tmp4_->from, (gpointer) ((gintptr) _tmp5_));
#line 66 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = self->to;
#line 66 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	if (_tmp6_ != NULL) {
#line 2467 "gitg-lanes.c"
		guint _tmp7_ = 0U;
#line 68 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = self->inactive;
#line 68 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		self->inactive = _tmp7_ + 1;
#line 2473 "gitg-lanes.c"
	}
}


static void gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self) {
}


static void gitg_lanes_lane_container_free (GitgLanesLaneContainer* self) {
#line 37 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 39 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 40 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 35 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slice_free (GitgLanesLaneContainer, self);
#line 2491 "gitg-lanes.c"
}


static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container) {
	GitgLanesCollapsedLane* self;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	GitgColor* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLanesLaneContainer* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgLanesLaneContainer* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = g_slice_new0 (GitgLanesCollapsedLane);
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_collapsed_lane_instance_init (self);
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->lane;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_->color;
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 83 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->color = _tmp3_;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = container;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = _tmp4_->from;
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = __vala_GgitOId_copy0 (_tmp5_);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 84 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp6_;
#line 85 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = container;
#line 85 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = _tmp7_->to;
#line 85 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = __vala_GgitOId_copy0 (_tmp8_);
#line 85 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 85 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp9_;
#line 81 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2547 "gitg-lanes.c"
}


static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self) {
}


static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self) {
#line 76 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 78 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 79 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 74 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_slice_free (GitgLanesCollapsedLane, self);
#line 2564 "gitg-lanes.c"
}


static void gitg_lanes_class_init (GitgLanesClass * klass) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_type_class_add_private (klass, sizeof (GitgLanesPrivate));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_lanes_get_property;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_lanes_set_property;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_lanes_finalize;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_MAX, g_param_spec_int ("inactive-max", "inactive-max", "inactive-max", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_COLLAPSE, g_param_spec_int ("inactive-collapse", "inactive-collapse", "inactive-collapse", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_GAP, g_param_spec_int ("inactive-gap", "inactive-gap", "inactive-gap", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_ENABLED, g_param_spec_boolean ("inactive-enabled", "inactive-enabled", "inactive-enabled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2587 "gitg-lanes.c"
}


static void gitg_lanes_instance_init (GitgLanes * self) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self->priv = GITG_LANES_GET_PRIVATE (self);
#line 2594 "gitg-lanes.c"
}


static void gitg_lanes_finalize (GObject* obj) {
	GitgLanes * self;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LANES, GitgLanes);
#line 30 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__g_object_unref0_0 (self->priv->d_previous);
#line 31 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__gitg_lanes_lane_container_free0_0 (self->priv->d_lanes);
#line 32 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (gitg_lanes_parent_class)->finalize (obj);
#line 2610 "gitg-lanes.c"
}


GType gitg_lanes_get_type (void) {
	static volatile gsize gitg_lanes_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanes), 0, (GInstanceInitFunc) gitg_lanes_instance_init, NULL };
		GType gitg_lanes_type_id;
		gitg_lanes_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgLanes", &g_define_type_info, 0);
		g_once_init_leave (&gitg_lanes_type_id__volatile, gitg_lanes_type_id);
	}
	return gitg_lanes_type_id__volatile;
}


static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_max (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_collapse (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_gap (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		g_value_set_boolean (value, gitg_lanes_get_inactive_enabled (self));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 2655 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 2661 "gitg-lanes.c"
	}
}


static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_max (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_collapse (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_gap (self, g_value_get_int (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_enabled (self, g_value_get_boolean (value));
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 2695 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/git/gnome/gitg/libgitg/gitg-lanes.vala"
		break;
#line 2701 "gitg-lanes.c"
	}
}



