/* gkr-backend.c generated by valac 0.22.1, the Vala compiler
 * generated from gkr-backend.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsecret/secret.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gcr/gcr-base.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include "config.h"


#define SEAHORSE_GKR_TYPE_MY_SERVICE (seahorse_gkr_my_service_get_type ())
#define SEAHORSE_GKR_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyService))
#define SEAHORSE_GKR_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))
#define SEAHORSE_GKR_IS_MY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_IS_MY_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_MY_SERVICE))
#define SEAHORSE_GKR_MY_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_MY_SERVICE, SeahorseGkrMyServiceClass))

typedef struct _SeahorseGkrMyService SeahorseGkrMyService;
typedef struct _SeahorseGkrMyServiceClass SeahorseGkrMyServiceClass;
typedef struct _SeahorseGkrMyServicePrivate SeahorseGkrMyServicePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SeahorseGkrMyService {
	SecretService parent_instance;
	SeahorseGkrMyServicePrivate * priv;
};

struct _SeahorseGkrMyServiceClass {
	SecretServiceClass parent_class;
};

struct _SeahorseGkrBackendPrivate {
	SecretService* _service;
	GHashTable* _keyrings;
	GHashTable* _aliases;
	GtkActionGroup* _actions;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseGkrBackend * self;
	gchar* name;
};

struct _SeahorseGkrBackendActionsPrivate {
	SeahorseGkrBackend* _backend;
	gboolean _initialized;
};


static gpointer seahorse_gkr_my_service_parent_class = NULL;
static gpointer seahorse_gkr_backend_parent_class = NULL;
static SeahorseGkrBackend* seahorse_gkr_backend__instance;
static SeahorseGkrBackend* seahorse_gkr_backend__instance = NULL;
static GcrCollectionIface* seahorse_gkr_backend_gcr_collection_parent_iface = NULL;
static SeahorseBackendIface* seahorse_gkr_backend_seahorse_backend_parent_iface = NULL;
static gpointer seahorse_gkr_backend_actions_parent_class = NULL;
static GWeakRef seahorse_gkr_backend_actions__instance;
static GWeakRef seahorse_gkr_backend_actions__instance = {0};

GType seahorse_gkr_my_service_get_type (void) G_GNUC_CONST;
enum  {
	SEAHORSE_GKR_MY_SERVICE_DUMMY_PROPERTY
};
static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base);
static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base);
SeahorseGkrMyService* seahorse_gkr_my_service_new (void);
SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type);
#define SEAHORSE_GKR_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackendPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_NAME,
	SEAHORSE_GKR_BACKEND_LABEL,
	SEAHORSE_GKR_BACKEND_DESCRIPTION,
	SEAHORSE_GKR_BACKEND_ACTIONS,
	SEAHORSE_GKR_BACKEND_ALIASES,
	SEAHORSE_GKR_BACKEND_SERVICE
};
static void seahorse_gkr_backend_real_dispose (GObject* base);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static guint seahorse_gkr_backend_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object);
static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri);
static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self);
static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend___lambda13_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ___lambda14_ (SeahorseGkrBackend* self, GParamSpec* pspec);
static void ____lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res);
static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __seahorse_gkr_backend___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_backend_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActionsPrivate))
enum  {
	SEAHORSE_GKR_BACKEND_ACTIONS_DUMMY_PROPERTY,
	SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND
};
static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action);
static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self);
#define SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI "\"<ui>\n" \
"\t\t\t<popup name='SeahorseGkrBackend'>\n" \
"\t\t\t\t<menuitem action='keyring-new'/>\n" \
"\t\t\t</popup>\n" \
"\t\t</ui>"
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend);
static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend);
static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_backend_actions___lambda12_ (SeahorseGkrBackendActions* self, GParamSpec* pspec);
static void __seahorse_gkr_backend_actions___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void seahorse_gkr_backend_actions_finalize (GObject* obj);
static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS[2] = {{"keyring-new", NULL, "New password keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", NULL, "New password...", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};
static const GtkActionEntry SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW[2] = {{"keyring-new", "folder", "Password Keyring", "", "Used to store application and network passwords", (GCallback) _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback}, {"keyring-item-new", SEAHORSE_ICON_PASSWORD, "Stored Password", "", "Safely store a password or secret.", (GCallback) _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback}};

static GType seahorse_gkr_my_service_real_get_collection_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
#line 24 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) base;
#line 25 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_TYPE_KEYRING;
#line 25 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 165 "gkr-backend.c"
}


static GType seahorse_gkr_my_service_real_get_item_gtype (SecretService* base) {
	SeahorseGkrMyService * self;
	GType result = 0UL;
#line 28 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) base;
#line 29 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_TYPE_ITEM;
#line 29 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 178 "gkr-backend.c"
}


SeahorseGkrMyService* seahorse_gkr_my_service_construct (GType object_type) {
	SeahorseGkrMyService * self = NULL;
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrMyService*) g_object_new (object_type, NULL);
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	return self;
#line 188 "gkr-backend.c"
}


SeahorseGkrMyService* seahorse_gkr_my_service_new (void) {
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_my_service_construct (SEAHORSE_GKR_TYPE_MY_SERVICE);
#line 195 "gkr-backend.c"
}


static void seahorse_gkr_my_service_class_init (SeahorseGkrMyServiceClass * klass) {
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_my_service_parent_class = g_type_class_peek_parent (klass);
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	SECRET_SERVICE_CLASS (klass)->get_collection_gtype = seahorse_gkr_my_service_real_get_collection_gtype;
#line 23 "/data/src/seahorse/gkr/gkr-backend.vala"
	SECRET_SERVICE_CLASS (klass)->get_item_gtype = seahorse_gkr_my_service_real_get_item_gtype;
#line 206 "gkr-backend.c"
}


static void seahorse_gkr_my_service_instance_init (SeahorseGkrMyService * self) {
}


GType seahorse_gkr_my_service_get_type (void) {
	static volatile gsize seahorse_gkr_my_service_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_my_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrMyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_my_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrMyService), 0, (GInstanceInitFunc) seahorse_gkr_my_service_instance_init, NULL };
		GType seahorse_gkr_my_service_type_id;
		seahorse_gkr_my_service_type_id = g_type_register_static (secret_service_get_type (), "SeahorseGkrMyService", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_my_service_type_id__volatile, seahorse_gkr_my_service_type_id);
	}
	return seahorse_gkr_my_service_type_id__volatile;
}


static void seahorse_gkr_backend_real_dispose (GObject* base) {
	SeahorseGkrBackend * self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
#line 91 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 92 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_aliases;
#line 92 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_hash_table_remove_all (_tmp0_);
#line 93 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = self->priv->_keyrings;
#line 93 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_hash_table_remove_all (_tmp1_);
#line 94 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_actions;
#line 94 "/data/src/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_sensitive (_tmp2_, FALSE);
#line 95 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 247 "gkr-backend.c"
}


static void _g_free0_ (gpointer var) {
#line 99 "/data/src/seahorse/gkr/gkr-backend.vala"
	var = (g_free (var), NULL);
#line 254 "gkr-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 261 "gkr-backend.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 268 "gkr-backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_list_free (self);
#line 277 "gkr-backend.c"
}


void seahorse_gkr_backend_refresh_collections (SeahorseGkrBackend* self) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* keyrings = NULL;
	SecretService* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gchar* object_path = NULL;
	GList* _tmp5_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp25_ = NULL;
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 99 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = g_str_hash;
#line 99 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_str_equal;
#line 99 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
#line 99 "/data/src/seahorse/gkr/gkr-backend.vala"
	seen = _tmp2_;
#line 100 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_service;
#line 100 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = secret_service_get_collections (_tmp3_);
#line 100 "/data/src/seahorse/gkr/gkr-backend.vala"
	keyrings = _tmp4_;
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = keyrings;
#line 311 "gkr-backend.c"
	{
		GList* keyring_collection = NULL;
		GList* keyring_it = NULL;
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
		keyring_collection = _tmp5_;
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
		for (keyring_it = keyring_collection; keyring_it != NULL; keyring_it = keyring_it->next) {
#line 319 "gkr-backend.c"
			SecretCollection* _tmp6_ = NULL;
			SecretCollection* keyring = NULL;
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp6_ = _g_object_ref0 ((SecretCollection*) keyring_it->data);
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
			keyring = _tmp6_;
#line 326 "gkr-backend.c"
			{
				SecretCollection* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				GHashTable* _tmp10_ = NULL;
				gconstpointer _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GHashTable* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				GHashTable* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gconstpointer _tmp18_ = NULL;
#line 104 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp7_ = keyring;
#line 104 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp7_);
#line 104 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 104 "/data/src/seahorse/gkr/gkr-backend.vala"
				_g_free0 (object_path);
#line 104 "/data/src/seahorse/gkr/gkr-backend.vala"
				object_path = _tmp9_;
#line 107 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp10_ = self->priv->_aliases;
#line 107 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp11_ = g_hash_table_lookup (_tmp10_, "session");
#line 107 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp12_ = object_path;
#line 107 "/data/src/seahorse/gkr/gkr-backend.vala"
				if (g_strcmp0 ((const gchar*) _tmp11_, _tmp12_) == 0) {
#line 108 "/data/src/seahorse/gkr/gkr-backend.vala"
					_g_object_unref0 (keyring);
#line 108 "/data/src/seahorse/gkr/gkr-backend.vala"
					continue;
#line 362 "gkr-backend.c"
				}
#line 110 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp13_ = seen;
#line 110 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp14_ = object_path;
#line 110 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp15_ = g_strdup (_tmp14_);
#line 110 "/data/src/seahorse/gkr/gkr-backend.vala"
				g_hash_table_add (_tmp13_, _tmp15_);
#line 111 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp16_ = self->priv->_keyrings;
#line 111 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp17_ = object_path;
#line 111 "/data/src/seahorse/gkr/gkr-backend.vala"
				_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
#line 111 "/data/src/seahorse/gkr/gkr-backend.vala"
				if (((SeahorseGkrKeyring*) _tmp18_) == NULL) {
#line 380 "gkr-backend.c"
					GHashTable* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					SecretCollection* _tmp22_ = NULL;
					SeahorseGkrKeyring* _tmp23_ = NULL;
					SecretCollection* _tmp24_ = NULL;
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp19_ = self->priv->_keyrings;
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp20_ = object_path;
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp21_ = g_strdup (_tmp20_);
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp22_ = keyring;
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
#line 112 "/data/src/seahorse/gkr/gkr-backend.vala"
					g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
#line 113 "/data/src/seahorse/gkr/gkr-backend.vala"
					_tmp24_ = keyring;
#line 113 "/data/src/seahorse/gkr/gkr-backend.vala"
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp24_);
#line 403 "gkr-backend.c"
				}
#line 103 "/data/src/seahorse/gkr/gkr-backend.vala"
				_g_object_unref0 (keyring);
#line 407 "gkr-backend.c"
			}
		}
	}
#line 118 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp25_ = self->priv->_keyrings;
#line 118 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_hash_table_iter_init (&iter, _tmp25_);
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
	while (TRUE) {
#line 417 "gkr-backend.c"
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		gchar* _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gconstpointer _tmp31_ = NULL;
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp27_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp26_), (gpointer*) NULL);
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_free0 (object_path);
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp28_ = g_strdup (_tmp26_);
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
		object_path = _tmp28_;
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
		if (!_tmp27_) {
#line 119 "/data/src/seahorse/gkr/gkr-backend.vala"
			break;
#line 436 "gkr-backend.c"
		}
#line 120 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp29_ = seen;
#line 120 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp30_ = object_path;
#line 120 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
#line 120 "/data/src/seahorse/gkr/gkr-backend.vala"
		if (((const gchar*) _tmp31_) == NULL) {
#line 446 "gkr-backend.c"
			SeahorseGkrKeyring* keyring = NULL;
			GHashTable* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gconstpointer _tmp34_ = NULL;
			SeahorseGkrKeyring* _tmp35_ = NULL;
			SeahorseGkrKeyring* _tmp36_ = NULL;
#line 121 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp32_ = self->priv->_keyrings;
#line 121 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp33_ = object_path;
#line 121 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
#line 121 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp35_ = _g_object_ref0 ((SeahorseGkrKeyring*) _tmp34_);
#line 121 "/data/src/seahorse/gkr/gkr-backend.vala"
			keyring = _tmp35_;
#line 122 "/data/src/seahorse/gkr/gkr-backend.vala"
			g_hash_table_iter_remove (&iter);
#line 123 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp36_ = keyring;
#line 123 "/data/src/seahorse/gkr/gkr-backend.vala"
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp36_);
#line 120 "/data/src/seahorse/gkr/gkr-backend.vala"
			_g_object_unref0 (keyring);
#line 471 "gkr-backend.c"
		}
	}
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_free0 (object_path);
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	__g_list_free__g_object_unref0_0 (keyrings);
#line 98 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (seen);
#line 480 "gkr-backend.c"
}


static guint seahorse_gkr_backend_real_get_length (GcrCollection* base) {
	SeahorseGkrBackend * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 128 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 129 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 129 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_hash_table_size (_tmp0_);
#line 129 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 129 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 499 "gkr-backend.c"
}


static GList* seahorse_gkr_backend_real_get_objects (GcrCollection* base) {
	SeahorseGkrBackend * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
#line 132 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 133 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend_get_keyrings (self);
#line 133 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 133 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 515 "gkr-backend.c"
}


static gboolean seahorse_gkr_backend_real_contains (GcrCollection* base, GObject* object) {
	SeahorseGkrBackend * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
#line 136 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 136 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 137 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = object;
#line 137 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING)) {
#line 531 "gkr-backend.c"
		SeahorseGkrKeyring* keyring = NULL;
		GObject* _tmp1_ = NULL;
		SeahorseGkrKeyring* _tmp2_ = NULL;
		GHashTable* _tmp3_ = NULL;
		SeahorseGkrKeyring* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		SeahorseGkrKeyring* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 138 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = object;
#line 138 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
#line 138 "/data/src/seahorse/gkr/gkr-backend.vala"
		keyring = _tmp2_;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp3_ = self->priv->_keyrings;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp4_ = keyring;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp5_ = seahorse_place_get_uri ((SeahorsePlace*) _tmp4_);
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp6_ = _tmp5_;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp7_ = _tmp6_;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp8_ = g_hash_table_lookup (_tmp3_, _tmp7_);
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp9_ = keyring;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp10_ = ((SeahorseGkrKeyring*) _tmp8_) == _tmp9_;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_free0 (_tmp7_);
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		result = _tmp10_;
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (keyring);
#line 139 "/data/src/seahorse/gkr/gkr-backend.vala"
		return result;
#line 573 "gkr-backend.c"
	}
#line 141 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = FALSE;
#line 141 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 579 "gkr-backend.c"
}


static SeahorsePlace* seahorse_gkr_backend_real_lookup_place (SeahorseBackend* base, const gchar* uri) {
	SeahorseGkrBackend * self;
	SeahorsePlace* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	SeahorsePlace* _tmp3_ = NULL;
#line 144 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 144 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = uri;
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = _g_object_ref0 ((SeahorsePlace*) ((SeahorseGkrKeyring*) _tmp2_));
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp3_;
#line 145 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 606 "gkr-backend.c"
}


void seahorse_gkr_backend_initialize (void) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackend* _tmp3_ = NULL;
#line 149 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 149 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp0_ == NULL);
#line 150 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_gkr_backend_new ();
#line 150 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 150 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_backend_register ((SeahorseBackend*) _tmp2_);
#line 150 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 151 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_backend__instance;
#line 151 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 631 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_instance (void) {
	SeahorseGkrBackend* result = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
#line 155 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 155 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
#line 156 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_gkr_backend__instance;
#line 156 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 156 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp2_;
#line 156 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 652 "gkr-backend.c"
}


GList* seahorse_gkr_backend_get_keyrings (SeahorseGkrBackend* self) {
	GList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 159 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_keyrings;
#line 160 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_hash_table_get_values (_tmp0_);
#line 160 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 160 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 670 "gkr-backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	return _data1_;
#line 679 "gkr-backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 688 "gkr-backend.c"
		SeahorseGkrBackend * self;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
		self = _data1_->self;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_free0 (_data1_->name);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (self);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 698 "gkr-backend.c"
	}
}


static void __lambda3_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrBackend * self;
	GError * _inner_error_ = NULL;
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = _data1_->self;
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 710 "gkr-backend.c"
	{
		gchar* object_path = NULL;
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 168 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp0_ = self->priv->_service;
#line 168 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = res;
#line 168 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = secret_service_read_alias_dbus_path_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 168 "/data/src/seahorse/gkr/gkr-backend.vala"
		object_path = _tmp2_;
#line 168 "/data/src/seahorse/gkr/gkr-backend.vala"
		if (_inner_error_ != NULL) {
#line 726 "gkr-backend.c"
			goto __catch0_g_error;
		}
#line 169 "/data/src/seahorse/gkr/gkr-backend.vala"
		if (object_path != NULL) {
#line 731 "gkr-backend.c"
			GHashTable* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 170 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp3_ = self->priv->_aliases;
#line 170 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp4_ = _data1_->name;
#line 170 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 170 "/data/src/seahorse/gkr/gkr-backend.vala"
			_tmp6_ = g_strdup (object_path);
#line 170 "/data/src/seahorse/gkr/gkr-backend.vala"
			g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
#line 171 "/data/src/seahorse/gkr/gkr-backend.vala"
			g_object_notify ((GObject*) self, "aliases");
#line 748 "gkr-backend.c"
		}
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_free0 (object_path);
#line 752 "gkr-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		err = _inner_error_;
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		_inner_error_ = NULL;
#line 174 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp7_ = _data1_->name;
#line 174 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp8_ = err;
#line 174 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp9_ = _tmp8_->message;
#line 174 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_warning ("gkr-backend.vala:174: Couldn't read secret service alias %s: %s", _tmp7_, _tmp9_);
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_error_free0 (err);
#line 775 "gkr-backend.c"
	}
	__finally0:
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_inner_error_ != NULL) {
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_clear_error (&_inner_error_);
#line 167 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 786 "gkr-backend.c"
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	__lambda3_ (self, source_object, res);
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	block1_data_unref (self);
#line 796 "gkr-backend.c"
}


static void seahorse_gkr_backend_read_alias (SeahorseGkrBackend* self, const gchar* name) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	SecretService* _tmp2_ = NULL;
	SecretService* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (name != NULL);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_data1_->_ref_count_ = 1;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_data1_->self = g_object_ref (self);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = name;
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_free0 (_data1_->name);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_data1_->name = _tmp1_;
#line 164 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_service;
#line 164 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_tmp2_ == NULL) {
#line 165 "/data/src/seahorse/gkr/gkr-backend.vala"
		block1_data_unref (_data1_);
#line 165 "/data/src/seahorse/gkr/gkr-backend.vala"
		_data1_ = NULL;
#line 165 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 835 "gkr-backend.c"
	}
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_service;
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _data1_->name;
#line 166 "/data/src/seahorse/gkr/gkr-backend.vala"
	secret_service_read_alias_dbus_path (_tmp3_, _tmp4_, NULL, ___lambda3__gasync_ready_callback, block1_data_ref (_data1_));
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	block1_data_unref (_data1_);
#line 163 "/data/src/seahorse/gkr/gkr-backend.vala"
	_data1_ = NULL;
#line 847 "gkr-backend.c"
}


static void seahorse_gkr_backend_refresh_aliases (SeahorseGkrBackend* self) {
#line 180 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 181 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "default");
#line 182 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "session");
#line 183 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_read_alias (self, "login");
#line 860 "gkr-backend.c"
}


void seahorse_gkr_backend_refresh (SeahorseGkrBackend* self) {
#line 186 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 187 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_aliases (self);
#line 188 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_collections (self);
#line 871 "gkr-backend.c"
}


gboolean seahorse_gkr_backend_has_alias (SeahorseGkrBackend* self, const gchar* alias, SeahorseGkrKeyring* keyring) {
	gboolean result = FALSE;
	gchar* object_path = NULL;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
#line 190 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 190 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (alias != NULL, FALSE);
#line 190 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (keyring != NULL, FALSE);
#line 192 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = keyring;
#line 192 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp0_);
#line 192 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 192 "/data/src/seahorse/gkr/gkr-backend.vala"
	object_path = _tmp2_;
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_aliases;
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = alias;
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = g_strcmp0 ((const gchar*) _tmp5_, object_path) == 0;
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_free0 (object_path);
#line 193 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 910 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_construct (GType object_type) {
	SeahorseGkrBackend * self = NULL;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) g_object_new (object_type, NULL);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	return self;
#line 920 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_new (void) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_backend_construct (SEAHORSE_GKR_TYPE_BACKEND);
#line 927 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_name (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
#line 35 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 35 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = SEAHORSE_GKR_NAME;
#line 35 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 940 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_label (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
#line 39 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 39 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = _ ("Passwords");
#line 39 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 39 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 956 "gkr-backend.c"
}


static const gchar* seahorse_gkr_backend_real_get_description (SeahorseBackend* base) {
	const gchar* result;
	SeahorseGkrBackend* self;
	const gchar* _tmp0_ = NULL;
#line 43 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 43 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = _ ("Stored personal passwords, credentials and secrets");
#line 43 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 43 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 972 "gkr-backend.c"
}


static GtkActionGroup* seahorse_gkr_backend_real_get_actions (SeahorseBackend* base) {
	GtkActionGroup* result;
	SeahorseGkrBackend* self;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
#line 47 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackend*) base;
#line 47 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_actions;
#line 47 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 47 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp1_;
#line 47 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 991 "gkr-backend.c"
}


GHashTable* seahorse_gkr_backend_get_aliases (SeahorseGkrBackend* self) {
	GHashTable* result;
	GHashTable* _tmp0_ = NULL;
#line 51 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_aliases;
#line 51 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 51 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1006 "gkr-backend.c"
}


SecretService* seahorse_gkr_backend_get_service (SeahorseGkrBackend* self) {
	SecretService* result;
	SecretService* _tmp0_ = NULL;
#line 55 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_service;
#line 55 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 55 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1021 "gkr-backend.c"
}


static void ___lambda14_ (SeahorseGkrBackend* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 76 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (pspec != NULL);
#line 77 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = pspec;
#line 77 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _tmp0_->name;
#line 77 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (g_strcmp0 (_tmp1_, "collections") == 0) {
#line 78 "/data/src/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_refresh_collections (self);
#line 1038 "gkr-backend.c"
	}
}


static void ____lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 76 "/data/src/seahorse/gkr/gkr-backend.vala"
	___lambda14_ (self, pspec);
#line 1046 "gkr-backend.c"
}


static void ___lambda15_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
#line 80 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 81 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_refresh_collections (self);
#line 1055 "gkr-backend.c"
}


static void ____lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 80 "/data/src/seahorse/gkr/gkr-backend.vala"
	___lambda15_ (self, source_object, res);
#line 80 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_unref (self);
#line 1064 "gkr-backend.c"
}


static void _seahorse_gkr_backend___lambda13_ (SeahorseGkrBackend* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 73 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (res != NULL);
#line 1072 "gkr-backend.c"
	{
		SecretService* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		SecretService* _tmp2_ = NULL;
		SecretService* _tmp3_ = NULL;
		SecretService* _tmp4_ = NULL;
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp1_ = res;
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp2_ = secret_service_open_finish (_tmp1_, &_inner_error_);
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp0_ = _tmp2_;
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		if (_inner_error_ != NULL) {
#line 1087 "gkr-backend.c"
			goto __catch1_g_error;
		}
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_object_unref0 (self->priv->_service);
#line 75 "/data/src/seahorse/gkr/gkr-backend.vala"
		self->priv->_service = _tmp0_;
#line 76 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp3_ = self->priv->_service;
#line 76 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_signal_connect_object ((GObject*) _tmp3_, "notify", (GCallback) ____lambda14__g_object_notify, self, 0);
#line 80 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp4_ = self->priv->_service;
#line 80 "/data/src/seahorse/gkr/gkr-backend.vala"
		secret_service_load_collections (_tmp4_, NULL, ____lambda15__gasync_ready_callback, g_object_ref (self));
#line 83 "/data/src/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_refresh_aliases (self);
#line 1104 "gkr-backend.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		err = _inner_error_;
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		_inner_error_ = NULL;
#line 85 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp5_ = err;
#line 85 "/data/src/seahorse/gkr/gkr-backend.vala"
		_tmp6_ = _tmp5_->message;
#line 85 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_warning ("gkr-backend.vala:85: couldn't connect to secret service: %s", _tmp6_);
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		_g_error_free0 (err);
#line 1124 "gkr-backend.c"
	}
	__finally1:
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_inner_error_ != NULL) {
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_clear_error (&_inner_error_);
#line 74 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 1135 "gkr-backend.c"
	}
#line 87 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject*) self, "service");
#line 1139 "gkr-backend.c"
}


static void __seahorse_gkr_backend___lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 72 "/data/src/seahorse/gkr/gkr-backend.vala"
	_seahorse_gkr_backend___lambda13_ (self, source_object, res);
#line 72 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_unref (self);
#line 1148 "gkr-backend.c"
}


static GObject * seahorse_gkr_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackend * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
#line 64 "/data/src/seahorse/gkr/gkr-backend.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_parent_class);
#line 64 "/data/src/seahorse/gkr/gkr-backend.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 64 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 65 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = seahorse_gkr_backend__instance;
#line 65 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (_tmp0_ == NULL, NULL);
#line 66 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (self);
#line 66 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (seahorse_gkr_backend__instance);
#line 66 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend__instance = _tmp1_;
#line 68 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = seahorse_gkr_backend_actions_instance (self);
#line 68 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_actions);
#line 68 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_actions = _tmp2_;
#line 69 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = g_str_hash;
#line 69 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = g_str_equal;
#line 69 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
#line 69 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_keyrings);
#line 69 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_keyrings = _tmp5_;
#line 70 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp6_ = g_str_hash;
#line 70 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp7_ = g_str_equal;
#line 70 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_free0_);
#line 70 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_aliases);
#line 70 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_aliases = _tmp8_;
#line 72 "/data/src/seahorse/gkr/gkr-backend.vala"
	secret_service_open (SEAHORSE_GKR_TYPE_MY_SERVICE, NULL, SECRET_SERVICE_OPEN_SESSION, NULL, __seahorse_gkr_backend___lambda13__gasync_ready_callback, g_object_ref (self));
#line 64 "/data/src/seahorse/gkr/gkr-backend.vala"
	return obj;
#line 1211 "gkr-backend.c"
}


static void seahorse_gkr_backend_class_init (SeahorseGkrBackendClass * klass) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_parent_class = g_type_class_peek_parent (klass);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendPrivate));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->dispose = seahorse_gkr_backend_real_dispose;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_get_property;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_constructor;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_finalize;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS, g_param_spec_object ("actions", "actions", "actions", GTK_TYPE_ACTION_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ALIASES, g_param_spec_boxed ("aliases", "aliases", "aliases", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_SERVICE, g_param_spec_object ("service", "service", "service", secret_service_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1240 "gkr-backend.c"
}


static void seahorse_gkr_backend_gcr_collection_interface_init (GcrCollectionIface * iface) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_length = (guint (*)(GcrCollection*)) seahorse_gkr_backend_real_get_length;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_objects = (GList* (*)(GcrCollection*)) seahorse_gkr_backend_real_get_objects;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->contains = (gboolean (*)(GcrCollection*, GObject*)) seahorse_gkr_backend_real_contains;
#line 1253 "gkr-backend.c"
}


static void seahorse_gkr_backend_seahorse_backend_interface_init (SeahorseBackendIface * iface) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_seahorse_backend_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->lookup_place = (SeahorsePlace* (*)(SeahorseBackend*, const gchar*)) seahorse_gkr_backend_real_lookup_place;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_name = seahorse_gkr_backend_real_get_name;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_label = seahorse_gkr_backend_real_get_label;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_description = seahorse_gkr_backend_real_get_description;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	iface->get_actions = seahorse_gkr_backend_real_get_actions;
#line 1270 "gkr-backend.c"
}


static void seahorse_gkr_backend_instance_init (SeahorseGkrBackend * self) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv = SEAHORSE_GKR_BACKEND_GET_PRIVATE (self);
#line 1277 "gkr-backend.c"
}


static void seahorse_gkr_backend_finalize (GObject* obj) {
	SeahorseGkrBackend * self;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 59 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_service);
#line 60 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_keyrings);
#line 61 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_hash_table_unref0 (self->priv->_aliases);
#line 62 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_actions);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_parent_class)->finalize (obj);
#line 1295 "gkr-backend.c"
}


GType seahorse_gkr_backend_get_type (void) {
	static volatile gsize seahorse_gkr_backend_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackend), 0, (GInstanceInitFunc) seahorse_gkr_backend_instance_init, NULL };
		static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_backend_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_backend_info = { (GInterfaceInitFunc) seahorse_gkr_backend_seahorse_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_backend_type_id;
		seahorse_gkr_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseGkrBackend", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, gcr_collection_get_type (), &gcr_collection_info);
		g_type_add_interface_static (seahorse_gkr_backend_type_id, SEAHORSE_TYPE_BACKEND, &seahorse_backend_info);
		g_once_init_leave (&seahorse_gkr_backend_type_id__volatile, seahorse_gkr_backend_type_id);
	}
	return seahorse_gkr_backend_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND, SeahorseGkrBackend);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_NAME:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_name ((SeahorseBackend*) self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_LABEL:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_label ((SeahorseBackend*) self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_DESCRIPTION:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_string (value, seahorse_backend_get_description ((SeahorseBackend*) self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_take_object (value, seahorse_backend_get_actions ((SeahorseBackend*) self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ALIASES:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_boxed (value, seahorse_gkr_backend_get_aliases (self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_SERVICE:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_object (value, seahorse_gkr_backend_get_service (self));
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1356 "gkr-backend.c"
		default:
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1362 "gkr-backend.c"
	}
}


static void _seahorse_gkr_backend_actions_on_new_keyring_gtk_action_callback (GtkAction* action, gpointer self) {
#line 240 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_on_new_keyring (action);
#line 1370 "gkr-backend.c"
}


static void _seahorse_gkr_backend_actions_on_new_item_gtk_action_callback (GtkAction* action, gpointer self) {
#line 240 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_on_new_item (action);
#line 1377 "gkr-backend.c"
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_construct (GType object_type, SeahorseGkrBackend* backend) {
	SeahorseGkrBackendActions * self = NULL;
	SeahorseGkrBackend* _tmp0_ = NULL;
#line 228 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (backend != NULL, NULL);
#line 229 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = backend;
#line 229 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = (SeahorseGkrBackendActions*) g_object_new (object_type, "name", "KeyringBackend", "backend", _tmp0_, NULL);
#line 228 "/data/src/seahorse/gkr/gkr-backend.vala"
	return self;
#line 1392 "gkr-backend.c"
}


static SeahorseGkrBackendActions* seahorse_gkr_backend_actions_new (SeahorseGkrBackend* backend) {
#line 228 "/data/src/seahorse/gkr/gkr-backend.vala"
	return seahorse_gkr_backend_actions_construct (SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, backend);
#line 1399 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_on_new_keyring (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrKeyringAdd* _tmp3_ = NULL;
	SeahorseGkrKeyringAdd* _tmp4_ = NULL;
#line 232 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (action != NULL);
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = action;
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_action_get_window (_tmp0_);
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_keyring_add_new (_tmp2_);
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_ref_sink (_tmp3_);
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _tmp3_;
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp4_);
#line 233 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 1427 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_on_new_item (GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	SeahorseGkrItemAdd* _tmp3_ = NULL;
	SeahorseGkrItemAdd* _tmp4_ = NULL;
#line 236 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (action != NULL);
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = action;
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = seahorse_action_get_window (_tmp0_);
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = _tmp1_;
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_item_add_new (_tmp2_);
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_ref_sink (_tmp3_);
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = _tmp3_;
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp4_);
#line 237 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (_tmp2_);
#line 1455 "gkr-backend.c"
}


GtkActionGroup* seahorse_gkr_backend_actions_instance (SeahorseGkrBackend* backend) {
	GtkActionGroup* result = NULL;
	SeahorseGkrBackendActions* actions = NULL;
	GObject* _tmp0_ = NULL;
	SeahorseGkrBackendActions* _tmp1_ = NULL;
	SeahorseGkrBackend* _tmp2_ = NULL;
	SeahorseGkrBackendActions* _tmp3_ = NULL;
	SeahorseGkrBackendActions* _tmp4_ = NULL;
#line 261 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (backend != NULL, NULL);
#line 262 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = g_weak_ref_get (&seahorse_gkr_backend_actions__instance);
#line 262 "/data/src/seahorse/gkr/gkr-backend.vala"
	actions = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 263 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = actions;
#line 263 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_tmp1_ != NULL) {
#line 264 "/data/src/seahorse/gkr/gkr-backend.vala"
		result = (GtkActionGroup*) actions;
#line 264 "/data/src/seahorse/gkr/gkr-backend.vala"
		return result;
#line 1481 "gkr-backend.c"
	}
#line 265 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = backend;
#line 265 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = seahorse_gkr_backend_actions_new (_tmp2_);
#line 265 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (actions);
#line 265 "/data/src/seahorse/gkr/gkr-backend.vala"
	actions = _tmp3_;
#line 266 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = actions;
#line 266 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_weak_ref_set (&seahorse_gkr_backend_actions__instance, (GObject*) _tmp4_);
#line 267 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = (GtkActionGroup*) actions;
#line 267 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1499 "gkr-backend.c"
}


SeahorseGkrBackend* seahorse_gkr_backend_actions_get_backend (SeahorseGkrBackendActions* self) {
	SeahorseGkrBackend* result;
	SeahorseGkrBackend* _tmp0_ = NULL;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_backend;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	result = _tmp0_;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	return result;
#line 1514 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_set_backend (SeahorseGkrBackendActions* self, SeahorseGkrBackend* value) {
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (self != NULL);
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = value;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_backend);
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_backend = _tmp1_;
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject *) self, "backend");
#line 1533 "gkr-backend.c"
}


static void _seahorse_gkr_backend_actions___lambda12_ (SeahorseGkrBackendActions* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	SeahorseGkrBackend* _tmp3_ = NULL;
	SecretService* _tmp4_ = NULL;
	SecretService* _tmp5_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkActionGroup* _tmp8_ = NULL;
	GtkActionGroup* _tmp9_ = NULL;
#line 206 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_return_if_fail (pspec != NULL);
#line 207 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = pspec;
#line 207 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = _tmp0_->name;
#line 207 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (g_strcmp0 (_tmp1_, "service") == 0) {
#line 208 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 1559 "gkr-backend.c"
	}
#line 209 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp2_ = self->priv->_initialized;
#line 209 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_tmp2_) {
#line 210 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 1567 "gkr-backend.c"
	}
#line 211 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp3_ = self->priv->_backend;
#line 211 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp4_ = seahorse_gkr_backend_get_service (_tmp3_);
#line 211 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp5_ = _tmp4_;
#line 211 "/data/src/seahorse/gkr/gkr-backend.vala"
	if (_tmp5_ == NULL) {
#line 212 "/data/src/seahorse/gkr/gkr-backend.vala"
		return;
#line 1579 "gkr-backend.c"
	}
#line 214 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_initialized = TRUE;
#line 215 "/data/src/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_add_actions ((GtkActionGroup*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_ACTIONS), NULL);
#line 216 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_actions_register_definition ((SeahorseActions*) self, SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND_UI);
#line 219 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp6_ = gtk_action_group_new ("gkr-generate");
#line 219 "/data/src/seahorse/gkr/gkr-backend.vala"
	actions = _tmp6_;
#line 220 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp7_ = actions;
#line 220 "/data/src/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_translation_domain (_tmp7_, GETTEXT_PACKAGE);
#line 221 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp8_ = actions;
#line 221 "/data/src/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_add_actions (_tmp8_, SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW, G_N_ELEMENTS (SEAHORSE_GKR_BACKEND_ACTIONS_ENTRIES_NEW), NULL);
#line 222 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp9_ = actions;
#line 222 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_registry_register_object ((GObject*) _tmp9_, "generator");
#line 206 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (actions);
#line 1605 "gkr-backend.c"
}


static void __seahorse_gkr_backend_actions___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 206 "/data/src/seahorse/gkr/gkr-backend.vala"
	_seahorse_gkr_backend_actions___lambda12_ (self, pspec);
#line 1612 "gkr-backend.c"
}


static GObject * seahorse_gkr_backend_actions_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrBackendActions * self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
#line 202 "/data/src/seahorse/gkr/gkr-backend.vala"
	parent_class = G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class);
#line 202 "/data/src/seahorse/gkr/gkr-backend.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 202 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 203 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv->_initialized = FALSE;
#line 204 "/data/src/seahorse/gkr/gkr-backend.vala"
	gtk_action_group_set_translation_domain ((GtkActionGroup*) self, GETTEXT_PACKAGE);
#line 206 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp0_ = self->priv->_backend;
#line 206 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) __seahorse_gkr_backend_actions___lambda12__g_object_notify, self, G_CONNECT_AFTER);
#line 225 "/data/src/seahorse/gkr/gkr-backend.vala"
	_tmp1_ = self->priv->_backend;
#line 225 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_notify ((GObject*) _tmp1_, "service");
#line 202 "/data/src/seahorse/gkr/gkr-backend.vala"
	return obj;
#line 1642 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_class_init (SeahorseGkrBackendActionsClass * klass) {
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	seahorse_gkr_backend_actions_parent_class = g_type_class_peek_parent (klass);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_type_class_add_private (klass, sizeof (SeahorseGkrBackendActionsPrivate));
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_backend_actions_get_property;
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_backend_actions_set_property;
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_backend_actions_constructor;
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_backend_actions_finalize;
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND, g_param_spec_object ("backend", "backend", "backend", SEAHORSE_GKR_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1661 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_instance_init (SeahorseGkrBackendActions * self) {
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	self->priv = SEAHORSE_GKR_BACKEND_ACTIONS_GET_PRIVATE (self);
#line 1668 "gkr-backend.c"
}


static void seahorse_gkr_backend_actions_finalize (GObject* obj) {
	SeahorseGkrBackendActions * self;
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 198 "/data/src/seahorse/gkr/gkr-backend.vala"
	_g_object_unref0 (self->priv->_backend);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	G_OBJECT_CLASS (seahorse_gkr_backend_actions_parent_class)->finalize (obj);
#line 1680 "gkr-backend.c"
}


GType seahorse_gkr_backend_actions_get_type (void) {
	static volatile gsize seahorse_gkr_backend_actions_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_backend_actions_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrBackendActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_backend_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrBackendActions), 0, (GInstanceInitFunc) seahorse_gkr_backend_actions_instance_init, NULL };
		GType seahorse_gkr_backend_actions_type_id;
		seahorse_gkr_backend_actions_type_id = g_type_register_static (SEAHORSE_TYPE_ACTIONS, "SeahorseGkrBackendActions", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_backend_actions_type_id__volatile, seahorse_gkr_backend_actions_type_id);
	}
	return seahorse_gkr_backend_actions_type_id__volatile;
}


static void _vala_seahorse_gkr_backend_actions_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		g_value_set_object (value, seahorse_gkr_backend_actions_get_backend (self));
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1707 "gkr-backend.c"
		default:
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1713 "gkr-backend.c"
	}
}


static void _vala_seahorse_gkr_backend_actions_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrBackendActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_BACKEND_ACTIONS, SeahorseGkrBackendActions);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
	switch (property_id) {
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		case SEAHORSE_GKR_BACKEND_ACTIONS_BACKEND:
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		seahorse_gkr_backend_actions_set_backend (self, g_value_get_object (value));
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1729 "gkr-backend.c"
		default:
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 197 "/data/src/seahorse/gkr/gkr-backend.vala"
		break;
#line 1735 "gkr-backend.c"
	}
}



