/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2012-2013 Richard Hughes <richard@hughsie.com>
 * Copyright (C) 2013 Matthias Clasen <mclasen@redhat.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <glib/gi18n.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <locale.h>

#include "gs-application.h"
#include "gs-profile.h"

int
main (int argc, char **argv)
{
	int status = 0;
	GsApplication *application;
	GsProfile *profile;

	setlocale (LC_ALL, "");

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	/* workaround for https://bugzilla.gnome.org/show_bug.cgi?id=726475 */
	g_setenv ("GTK_DEBUG", "no-pixel-cache", FALSE);

	profile = gs_profile_new ();
	gs_profile_start (profile, "GsMain");
	application = gs_application_new ();
	status = g_application_run (G_APPLICATION (application), argc, argv);
	g_object_unref (application);
	gs_profile_stop (profile, "GsMain");
	gs_profile_dump (profile);
	g_object_unref (profile);

	return status;
}

/* vim: set noexpandtab: */
