/* rygel-http-item-uri.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp-av/gupnp-av.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* _item_id;
	gint _thumbnail_index;
	gint _subtitle_index;
	gchar* _transcode_target;
	gchar* _playlist_format;
	RygelHTTPServer* _http_server;
	gchar* real_extension;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_ITEM_ID,
	RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX,
	RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX,
	RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET,
	RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT,
	RYGEL_HTTP_ITEM_URI_HTTP_SERVER,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
GType rygel_media_object_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value);
void rygel_http_item_uri_set_playlist_format (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
static gchar* rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self, const gchar* data);
static guchar* rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self, const gchar* data, int* result_length1);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
	return self ? rygel_icon_info_ref (self) : NULL;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	RygelHTTPServer* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaObject* _tmp8_ = NULL;
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp9_ = NULL;
	RygelMediaItem* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	_tmp0_ = object;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_http_item_uri_set_item_id (self, _tmp2_);
	_tmp3_ = thumbnail_index;
	rygel_http_item_uri_set_thumbnail_index (self, _tmp3_);
	_tmp4_ = subtitle_index;
	rygel_http_item_uri_set_subtitle_index (self, _tmp4_);
	_tmp5_ = transcode_target;
	rygel_http_item_uri_set_transcode_target (self, _tmp5_);
	_tmp6_ = http_server;
	rygel_http_item_uri_set_http_server (self, _tmp6_);
	_tmp7_ = playlist_format;
	rygel_http_item_uri_set_playlist_format (self, _tmp7_);
	rygel_http_item_uri_set_extension (self, "");
	_tmp8_ = object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_ITEM)) {
		return self;
	}
	_tmp9_ = object;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp9_) : NULL);
	item = _tmp10_;
	_tmp11_ = thumbnail_index;
	if (_tmp11_ > (-1)) {
		RygelMediaItem* _tmp12_ = NULL;
		_tmp12_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_VISUAL_ITEM)) {
			GeeArrayList* thumbnails = NULL;
			RygelMediaItem* _tmp13_ = NULL;
			GeeArrayList* _tmp14_ = NULL;
			GeeArrayList* _tmp15_ = NULL;
			GeeArrayList* _tmp16_ = NULL;
			GeeArrayList* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp13_ = item;
			_tmp14_ = rygel_visual_item_get_thumbnails (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp13_) : NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			thumbnails = _tmp16_;
			_tmp17_ = thumbnails;
			_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = thumbnail_index;
			if (_tmp19_ > _tmp20_) {
				GeeArrayList* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gpointer _tmp23_ = NULL;
				RygelThumbnail* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				_tmp21_ = thumbnails;
				_tmp22_ = thumbnail_index;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_);
				_tmp24_ = (RygelThumbnail*) _tmp23_;
				_tmp25_ = ((RygelIconInfo*) _tmp24_)->file_extension;
				rygel_http_item_uri_set_extension (self, _tmp25_);
				_rygel_icon_info_unref0 (_tmp24_);
			}
			_g_object_unref0 (thumbnails);
		} else {
			RygelMediaItem* _tmp26_ = NULL;
			_tmp26_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, RYGEL_TYPE_MUSIC_ITEM)) {
				RygelThumbnail* album_art = NULL;
				RygelMediaItem* _tmp27_ = NULL;
				RygelThumbnail* _tmp28_ = NULL;
				RygelThumbnail* _tmp29_ = NULL;
				RygelThumbnail* _tmp30_ = NULL;
				RygelThumbnail* _tmp31_ = NULL;
				_tmp27_ = item;
				_tmp28_ = rygel_music_item_get_album_art (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp27_) : NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = _rygel_icon_info_ref0 (_tmp29_);
				album_art = _tmp30_;
				_tmp31_ = album_art;
				if (_tmp31_ != NULL) {
					RygelThumbnail* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					_tmp32_ = album_art;
					_tmp33_ = ((RygelIconInfo*) _tmp32_)->file_extension;
					rygel_http_item_uri_set_extension (self, _tmp33_);
				}
				_rygel_icon_info_unref0 (album_art);
			}
		}
	} else {
		gint _tmp34_ = 0;
		_tmp34_ = subtitle_index;
		if (_tmp34_ > (-1)) {
			RygelMediaItem* _tmp35_ = NULL;
			_tmp35_ = item;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, RYGEL_TYPE_VIDEO_ITEM)) {
				GeeArrayList* subtitles = NULL;
				RygelMediaItem* _tmp36_ = NULL;
				GeeArrayList* _tmp37_ = NULL;
				GeeArrayList* _tmp38_ = NULL;
				GeeArrayList* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				_tmp36_ = item;
				_tmp37_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp36_) : NULL)->subtitles;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				subtitles = _tmp38_;
				_tmp39_ = subtitles;
				_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = subtitle_index;
				if (_tmp41_ > _tmp42_) {
					GeeArrayList* _tmp43_ = NULL;
					gint _tmp44_ = 0;
					gpointer _tmp45_ = NULL;
					RygelSubtitle* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					_tmp43_ = subtitles;
					_tmp44_ = subtitle_index;
					_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
					_tmp46_ = (RygelSubtitle*) _tmp45_;
					_tmp47_ = _tmp46_->caption_type;
					rygel_http_item_uri_set_extension (self, _tmp47_);
					_rygel_subtitle_unref0 (_tmp46_);
				}
				_g_object_unref0 (subtitles);
			}
		} else {
			const gchar* _tmp48_ = NULL;
			_tmp48_ = transcode_target;
			if (_tmp48_ != NULL) {
				{
					RygelTranscoder* tc = NULL;
					RygelHTTPServer* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					RygelTranscoder* _tmp51_ = NULL;
					RygelTranscoder* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					_tmp49_ = self->priv->_http_server;
					_tmp50_ = transcode_target;
					_tmp51_ = rygel_transcode_manager_get_transcoder ((RygelTranscodeManager*) _tmp49_, _tmp50_, &_inner_error_);
					tc = _tmp51_;
					if (_inner_error_ != NULL) {
						goto __catch37_g_error;
					}
					_tmp52_ = tc;
					_tmp53_ = rygel_transcoder_get_extension (_tmp52_);
					_tmp54_ = _tmp53_;
					rygel_http_item_uri_set_extension (self, _tmp54_);
					_g_object_unref0 (tc);
				}
				goto __finally37;
				__catch37_g_error:
				{
					GError* _error_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally37:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (item);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp55_ = rygel_http_item_uri_get_extension (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strcmp0 (_tmp57_, "") == 0;
	_g_free0 (_tmp57_);
	if (_tmp58_) {
		gchar* uri_extension = NULL;
		gchar* _tmp59_ = NULL;
		const gchar* _tmp80_ = NULL;
		_tmp59_ = g_strdup ("");
		uri_extension = _tmp59_;
		{
			GeeArrayList* _uri_string_list = NULL;
			RygelMediaItem* _tmp60_ = NULL;
			GeeArrayList* _tmp61_ = NULL;
			GeeArrayList* _tmp62_ = NULL;
			gint _uri_string_size = 0;
			GeeArrayList* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gint _uri_string_index = 0;
			_tmp60_ = item;
			_tmp61_ = ((RygelMediaObject*) _tmp60_)->uris;
			_tmp62_ = _g_object_ref0 (_tmp61_);
			_uri_string_list = _tmp62_;
			_tmp63_ = _uri_string_list;
			_tmp64_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_uri_string_size = _tmp65_;
			_uri_string_index = -1;
			while (TRUE) {
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				gchar* uri_string = NULL;
				GeeArrayList* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				gpointer _tmp71_ = NULL;
				gchar* basename = NULL;
				const gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
				gint dot_index = 0;
				const gchar* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				_tmp66_ = _uri_string_index;
				_uri_string_index = _tmp66_ + 1;
				_tmp67_ = _uri_string_index;
				_tmp68_ = _uri_string_size;
				if (!(_tmp67_ < _tmp68_)) {
					break;
				}
				_tmp69_ = _uri_string_list;
				_tmp70_ = _uri_string_index;
				_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_);
				uri_string = (gchar*) _tmp71_;
				_tmp72_ = uri_string;
				_tmp73_ = g_path_get_basename (_tmp72_);
				basename = _tmp73_;
				_tmp74_ = basename;
				_tmp75_ = string_last_index_of (_tmp74_, ".", 0);
				dot_index = _tmp75_;
				_tmp76_ = dot_index;
				if (_tmp76_ > (-1)) {
					const gchar* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gchar* _tmp79_ = NULL;
					_tmp77_ = basename;
					_tmp78_ = dot_index;
					_tmp79_ = string_substring (_tmp77_, (glong) (_tmp78_ + 1), (glong) (-1));
					_g_free0 (uri_extension);
					uri_extension = _tmp79_;
					_g_free0 (basename);
					_g_free0 (uri_string);
					break;
				}
				_g_free0 (basename);
				_g_free0 (uri_string);
			}
			_g_object_unref0 (_uri_string_list);
		}
		_tmp80_ = uri_extension;
		if (g_strcmp0 (_tmp80_, "") == 0) {
			RygelMediaItem* _tmp81_ = NULL;
			const gchar* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			_tmp81_ = item;
			_tmp82_ = rygel_media_item_get_mime_type (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp83_);
			_tmp85_ = _tmp84_;
			rygel_http_item_uri_set_extension (self, _tmp85_);
			_g_free0 (_tmp85_);
		} else {
			const gchar* _tmp86_ = NULL;
			_tmp86_ = uri_extension;
			rygel_http_item_uri_set_extension (self, _tmp86_);
		}
		_g_free0 (uri_extension);
	}
	_g_object_unref0 (item);
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format) {
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, object, http_server, thumbnail_index, subtitle_index, transcode_target, playlist_format);
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self, const gchar* data) {
	gchar* result = NULL;
	gchar* enc64 = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	_tmp3_ = (guchar*) _tmp2_;
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guchar);
	_tmp4_ = g_base64_encode (_tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guchar));
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	enc64 = _tmp5_;
	_tmp6_ = enc64;
	_tmp7_ = string_replace (_tmp6_, "/", "_");
	_g_free0 (enc64);
	enc64 = _tmp7_;
	_tmp8_ = enc64;
	_tmp9_ = string_replace (_tmp8_, "+", "-");
	result = _tmp9_;
	_g_free0 (enc64);
	return result;
}


static guchar* rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self, const gchar* data, int* result_length1) {
	guchar* result = NULL;
	gchar* dec64 = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	size_t _tmp5_;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = string_replace (_tmp0_, "_", "/");
	dec64 = _tmp1_;
	_tmp2_ = dec64;
	_tmp3_ = string_replace (_tmp2_, "-", "+");
	_g_free0 (dec64);
	dec64 = _tmp3_;
	_tmp4_ = dec64;
	_tmp6_ = g_base64_decode (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_free0 (dec64);
	return result;
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	gchar* request_uri = NULL;
	const gchar* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gboolean _tmp12_ = FALSE;
	gchar* last_part = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint dot_index = 0;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	const gchar* _tmp75_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	rygel_http_item_uri_set_thumbnail_index (self, -1);
	rygel_http_item_uri_set_subtitle_index (self, -1);
	rygel_http_item_uri_set_transcode_target (self, NULL);
	_tmp0_ = http_server;
	rygel_http_item_uri_set_http_server (self, _tmp0_);
	rygel_http_item_uri_set_extension (self, "");
	_tmp1_ = uri;
	_tmp2_ = http_server;
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
	request_uri = _tmp5_;
	_tmp6_ = request_uri;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
	parts = _tmp8_;
	parts_length1 = _vala_array_length (_tmp7_);
	_parts_size_ = parts_length1;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	if (_tmp10__length1 < 2) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp11_ = parts;
		_tmp11__length1 = parts_length1;
		_tmp9_ = (_tmp11__length1 % 2) == 0;
	}
	_tmp12_ = _tmp9_;
	if (_tmp12_) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		_tmp13_ = _ ("Invalid URI '%s'");
		_tmp14_ = request_uri;
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = parts;
	_tmp16__length1 = parts_length1;
	_tmp17_ = parts;
	_tmp17__length1 = parts_length1;
	_tmp18_ = _tmp16_[_tmp17__length1 - 1];
	_tmp19_ = g_strdup (_tmp18_);
	last_part = _tmp19_;
	_tmp20_ = last_part;
	_tmp21_ = string_last_index_of (_tmp20_, ".", 0);
	dot_index = _tmp21_;
	_tmp22_ = dot_index;
	if (_tmp22_ > (-1)) {
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		const gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp23_ = last_part;
		_tmp24_ = dot_index;
		_tmp25_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) (-1));
		_tmp26_ = _tmp25_;
		rygel_http_item_uri_set_extension (self, _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = parts;
		_tmp27__length1 = parts_length1;
		_tmp28_ = parts;
		_tmp28__length1 = parts_length1;
		_tmp29_ = last_part;
		_tmp30_ = dot_index;
		_tmp31_ = string_substring (_tmp29_, (glong) 0, (glong) _tmp30_);
		_g_free0 (_tmp27_[_tmp28__length1 - 1]);
		_tmp27_[_tmp28__length1 - 1] = _tmp31_;
		_tmp32_ = _tmp27_[_tmp28__length1 - 1];
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gboolean _tmp34_ = FALSE;
				gint _tmp36_ = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				GQuark _tmp43_ = 0U;
				static GQuark _tmp42_label0 = 0;
				static GQuark _tmp42_label1 = 0;
				static GQuark _tmp42_label2 = 0;
				static GQuark _tmp42_label3 = 0;
				static GQuark _tmp42_label4 = 0;
				_tmp34_ = _tmp33_;
				if (!_tmp34_) {
					gint _tmp35_ = 0;
					_tmp35_ = i;
					i = _tmp35_ + 2;
				}
				_tmp33_ = FALSE;
				_tmp36_ = i;
				_tmp37_ = parts;
				_tmp37__length1 = parts_length1;
				if (!(_tmp36_ < (_tmp37__length1 - 1))) {
					break;
				}
				_tmp38_ = parts;
				_tmp38__length1 = parts_length1;
				_tmp39_ = i;
				_tmp40_ = _tmp38_[_tmp39_];
				_tmp41_ = _tmp40_;
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
				if (_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("i")))) {
					switch (0) {
						default:
						{
							guchar* data = NULL;
							gchar** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							gint _tmp45_ = 0;
							const gchar* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							guchar* _tmp50_ = NULL;
							guchar* _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint data_length1 = 0;
							gint _data_size_ = 0;
							GString* builder = NULL;
							GString* _tmp52_ = NULL;
							GString* _tmp53_ = NULL;
							guchar* _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							GString* _tmp55_ = NULL;
							const gchar* _tmp56_ = NULL;
							_tmp44_ = parts;
							_tmp44__length1 = parts_length1;
							_tmp45_ = i;
							_tmp46_ = _tmp44_[_tmp45_ + 1];
							_tmp47_ = soup_uri_decode (_tmp46_);
							_tmp48_ = _tmp47_;
							_tmp50_ = rygel_http_item_uri_base64_urldecode (self, _tmp48_, &_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp51__length1 = _tmp49_;
							_g_free0 (_tmp48_);
							data = _tmp51_;
							data_length1 = _tmp51__length1;
							_data_size_ = data_length1;
							_tmp52_ = g_string_new ("");
							builder = _tmp52_;
							_tmp53_ = builder;
							_tmp54_ = data;
							_tmp54__length1 = data_length1;
							g_string_append (_tmp53_, (const gchar*) _tmp54_);
							_tmp55_ = builder;
							_tmp56_ = _tmp55_->str;
							rygel_http_item_uri_set_item_id (self, _tmp56_);
							_g_string_free0 (builder);
							data = (g_free (data), NULL);
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("tr")))) {
					switch (0) {
						default:
						{
							gchar** _tmp57_ = NULL;
							gint _tmp57__length1 = 0;
							gint _tmp58_ = 0;
							const gchar* _tmp59_ = NULL;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_ = NULL;
							_tmp57_ = parts;
							_tmp57__length1 = parts_length1;
							_tmp58_ = i;
							_tmp59_ = _tmp57_[_tmp58_ + 1];
							_tmp60_ = soup_uri_decode (_tmp59_);
							_tmp61_ = _tmp60_;
							rygel_http_item_uri_set_transcode_target (self, _tmp61_);
							_g_free0 (_tmp61_);
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("th")))) {
					switch (0) {
						default:
						{
							gchar** _tmp62_ = NULL;
							gint _tmp62__length1 = 0;
							gint _tmp63_ = 0;
							const gchar* _tmp64_ = NULL;
							gint _tmp65_ = 0;
							_tmp62_ = parts;
							_tmp62__length1 = parts_length1;
							_tmp63_ = i;
							_tmp64_ = _tmp62_[_tmp63_ + 1];
							_tmp65_ = atoi (_tmp64_);
							rygel_http_item_uri_set_thumbnail_index (self, _tmp65_);
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("sub")))) {
					switch (0) {
						default:
						{
							gchar** _tmp66_ = NULL;
							gint _tmp66__length1 = 0;
							gint _tmp67_ = 0;
							const gchar* _tmp68_ = NULL;
							gint _tmp69_ = 0;
							_tmp66_ = parts;
							_tmp66__length1 = parts_length1;
							_tmp67_ = i;
							_tmp68_ = _tmp66_[_tmp67_ + 1];
							_tmp69_ = atoi (_tmp68_);
							rygel_http_item_uri_set_subtitle_index (self, _tmp69_);
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label4) ? _tmp42_label4 : (_tmp42_label4 = g_quark_from_static_string ("pl")))) {
					switch (0) {
						default:
						{
							gchar** _tmp70_ = NULL;
							gint _tmp70__length1 = 0;
							gint _tmp71_ = 0;
							const gchar* _tmp72_ = NULL;
							gchar* _tmp73_ = NULL;
							gchar* _tmp74_ = NULL;
							_tmp70_ = parts;
							_tmp70__length1 = parts_length1;
							_tmp71_ = i;
							_tmp72_ = _tmp70_[_tmp71_ + 1];
							_tmp73_ = soup_uri_decode (_tmp72_);
							_tmp74_ = _tmp73_;
							rygel_http_item_uri_set_playlist_format (self, _tmp74_);
							_g_free0 (_tmp74_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	_tmp75_ = self->priv->_item_id;
	if (_tmp75_ == NULL) {
		const gchar* _tmp76_ = NULL;
		GError* _tmp77_ = NULL;
		_tmp76_ = _ ("Not found");
		_tmp77_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp76_);
		_inner_error_ = _tmp77_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (last_part);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (last_part);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (last_part);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	gchar* data = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* escaped = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_id;
	_tmp1_ = rygel_http_item_uri_base64_urlencode (self, _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	_tmp3_ = g_uri_escape_string (_tmp2_, "", TRUE);
	escaped = _tmp3_;
	_tmp4_ = escaped;
	_tmp5_ = g_strconcat ("/i/", _tmp4_, NULL);
	path = _tmp5_;
	_tmp6_ = self->priv->_transcode_target;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp7_ = self->priv->_transcode_target;
		_tmp8_ = g_uri_escape_string (_tmp7_, "", TRUE);
		_g_free0 (escaped);
		escaped = _tmp8_;
		_tmp9_ = path;
		_tmp10_ = escaped;
		_tmp11_ = g_strconcat ("/tr/", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
		_g_free0 (path);
		path = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		gint _tmp14_ = 0;
		_tmp14_ = self->priv->_thumbnail_index;
		if (_tmp14_ >= 0) {
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = path;
			_tmp16_ = self->priv->_thumbnail_index;
			_tmp17_ = g_strdup_printf ("%i", _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat ("/th/", _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
			_g_free0 (path);
			path = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
		} else {
			gint _tmp22_ = 0;
			_tmp22_ = self->priv->_subtitle_index;
			if (_tmp22_ >= 0) {
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				_tmp23_ = path;
				_tmp24_ = self->priv->_subtitle_index;
				_tmp25_ = g_strdup_printf ("%i", _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strconcat ("/sub/", _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
				_g_free0 (path);
				path = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			} else {
				const gchar* _tmp30_ = NULL;
				_tmp30_ = self->priv->_playlist_format;
				if (_tmp30_ != NULL) {
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					_tmp31_ = path;
					_tmp32_ = self->priv->_playlist_format;
					_tmp33_ = g_uri_escape_string (_tmp32_, "", TRUE);
					_tmp34_ = _tmp33_;
					_tmp35_ = g_strconcat ("/pl/", _tmp34_, NULL);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp31_, _tmp36_, NULL);
					_g_free0 (path);
					path = _tmp37_;
					_g_free0 (_tmp36_);
					_g_free0 (_tmp34_);
				}
			}
		}
	}
	_tmp38_ = path;
	_tmp39_ = rygel_http_item_uri_get_extension (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp38_, _tmp41_, NULL);
	_g_free0 (path);
	path = _tmp42_;
	_g_free0 (_tmp41_);
	_tmp43_ = path;
	_tmp44_ = rygel_http_item_uri_create_uri_for_path (self, _tmp43_);
	result = _tmp44_;
	_g_free0 (path);
	_g_free0 (escaped);
	_g_free0 (data);
	return result;
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	RygelHTTPServer* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_http_server;
	_tmp1_ = _tmp0_->context;
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_http_server;
	_tmp5_ = _tmp4_->context;
	_tmp6_ = gupnp_context_get_port (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_http_server;
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = path;
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
	result = _tmp12_;
	return result;
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gchar* _tmp35_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_ = NULL;
		gchar** videos = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint videos_length1 = 0;
		gint _videos_size_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		GeeHashMap* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		gchar** images = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint images_length1 = 0;
		gint _images_size_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		GeeHashMap* _tmp26_ = NULL;
		GeeHashMap* _tmp27_ = NULL;
		GeeHashMap* _tmp28_ = NULL;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
		rygel_http_item_uri_mime_to_ext = _tmp1_;
		_tmp2_ = g_strdup ("mpeg");
		_tmp3_ = g_strdup ("webm");
		_tmp4_ = g_strdup ("ogg");
		_tmp5_ = g_new0 (gchar*, 3 + 1);
		_tmp5_[0] = _tmp2_;
		_tmp5_[1] = _tmp3_;
		_tmp5_[2] = _tmp4_;
		videos = _tmp5_;
		videos_length1 = 3;
		_videos_size_ = videos_length1;
		_tmp6_ = videos;
		_tmp6__length1 = videos_length1;
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
			video_collection = _tmp6_;
			video_collection_length1 = _tmp6__length1;
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
				gchar* _tmp7_ = NULL;
				gchar* video = NULL;
				_tmp7_ = g_strdup (video_collection[video_it]);
				video = _tmp7_;
				{
					GeeHashMap* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
					_tmp9_ = video;
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = video;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
					_g_free0 (_tmp11_);
					_g_free0 (video);
				}
			}
		}
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
		_tmp16_ = g_strdup ("jpeg");
		_tmp17_ = g_strdup ("png");
		_tmp18_ = g_new0 (gchar*, 2 + 1);
		_tmp18_[0] = _tmp16_;
		_tmp18_[1] = _tmp17_;
		images = _tmp18_;
		images_length1 = 2;
		_images_size_ = images_length1;
		_tmp19_ = images;
		_tmp19__length1 = images_length1;
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
			image_collection = _tmp19_;
			image_collection_length1 = _tmp19__length1;
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
				gchar* _tmp20_ = NULL;
				gchar* image = NULL;
				_tmp20_ = g_strdup (image_collection[image_it]);
				image = _tmp20_;
				{
					GeeHashMap* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
					_tmp22_ = image;
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = image;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
					_g_free0 (_tmp24_);
					_g_free0 (image);
				}
			}
		}
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "text/xml", "xml");
		_tmp28_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "application/ogg", "ogg");
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp29_ = rygel_http_item_uri_mime_to_ext;
	_tmp30_ = mime_type;
	_tmp31_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp29_, _tmp30_);
	if (_tmp31_) {
		GeeHashMap* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
		_tmp32_ = rygel_http_item_uri_mime_to_ext;
		_tmp33_ = mime_type;
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
		result = (gchar*) _tmp34_;
		return result;
	}
	_tmp35_ = g_strdup ("");
	result = _tmp35_;
	return result;
}


const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_id;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_item_id);
	self->priv->_item_id = _tmp1_;
	g_object_notify ((GObject *) self, "item-id");
}


gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_thumbnail_index;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_thumbnail_index = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnail-index");
}


gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subtitle_index;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_subtitle_index = _tmp0_;
	g_object_notify ((GObject *) self, "subtitle-index");
}


const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_transcode_target;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_transcode_target);
	self->priv->_transcode_target = _tmp1_;
	g_object_notify ((GObject *) self, "transcode-target");
}


const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_playlist_format;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_playlist_format (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_playlist_format);
	self->priv->_playlist_format = _tmp1_;
	g_object_notify ((GObject *) self, "playlist-format");
}


RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self) {
	RygelHTTPServer* result;
	RygelHTTPServer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_http_server;
	result = _tmp0_;
	return result;
}


void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value) {
	RygelHTTPServer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_http_server = _tmp0_;
	g_object_notify ((GObject *) self, "http-server");
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->real_extension;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->priv->real_extension;
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup ("");
	result = _tmp3_;
	return result;
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->real_extension);
	self->priv->real_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_ITEM_ID, g_param_spec_string ("item-id", "item-id", "item-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX, g_param_spec_int ("thumbnail-index", "thumbnail-index", "thumbnail-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX, g_param_spec_int ("subtitle-index", "subtitle-index", "subtitle-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET, g_param_spec_string ("transcode-target", "transcode-target", "transcode-target", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT, g_param_spec_string ("playlist-format", "playlist-format", "playlist-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_HTTP_SERVER, g_param_spec_object ("http-server", "http-server", "http-server", RYGEL_TYPE_HTTP_SERVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
	self->priv->_thumbnail_index = -1;
	self->priv->_subtitle_index = -1;
	self->priv->_transcode_target = NULL;
	self->priv->_playlist_format = NULL;
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	_g_free0 (self->priv->_item_id);
	_g_free0 (self->priv->_transcode_target);
	_g_free0 (self->priv->_playlist_format);
	_g_free0 (self->priv->real_extension);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	switch (property_id) {
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
		g_value_set_string (value, rygel_http_item_uri_get_item_id (self));
		break;
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
		g_value_set_int (value, rygel_http_item_uri_get_thumbnail_index (self));
		break;
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
		g_value_set_int (value, rygel_http_item_uri_get_subtitle_index (self));
		break;
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
		g_value_set_string (value, rygel_http_item_uri_get_transcode_target (self));
		break;
		case RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT:
		g_value_set_string (value, rygel_http_item_uri_get_playlist_format (self));
		break;
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
		g_value_set_object (value, rygel_http_item_uri_get_http_server (self));
		break;
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	switch (property_id) {
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
		rygel_http_item_uri_set_item_id (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
		rygel_http_item_uri_set_thumbnail_index (self, g_value_get_int (value));
		break;
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
		rygel_http_item_uri_set_subtitle_index (self, g_value_get_int (value));
		break;
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
		rygel_http_item_uri_set_transcode_target (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT:
		rygel_http_item_uri_set_playlist_format (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
		rygel_http_item_uri_set_http_server (self, g_value_get_object (value));
		break;
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



