/* game.c generated by valac 0.22.0.22-b05f, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_PLAYER (player_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _GamePrivate {
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	gint undo_history[1344];
	gint undo_index;
	Player _current_color;
};


static gpointer game_parent_class = NULL;

GType game_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_WIDTH,
	GAME_HEIGHT,
	GAME_CURRENT_COLOR,
	GAME_N_TILES,
	GAME_N_LIGHT_TILES,
	GAME_N_DARK_TILES
};
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void game_set_tile (Game* self, gint x, gint y, Player color, gboolean update_history);
static void game_set_current_color (Game* self, Player value);
Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint width, gint height);
Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint width, gint height);
Player player_from_char (gchar c);
gchar* game_to_string (Game* self);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gint game_get_width (Game* self);
gint game_get_height (Game* self);
Player game_get_current_color (Game* self);
Player game_get_owner (Game* self, gint x, gint y);
static gboolean game_is_valid_location (Game* self, gint x, gint y);
gboolean game_is_complete (Game* self);
gboolean game_can_move (Game* self, Player color);
gint game_get_n_tiles (Game* self);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static gint game_place (Game* self, gint x, gint y, Player color, gboolean apply);
gint game_place_tile (Game* self, gint x, gint y);
Player player_flip_color (Player p);
void game_pass (Game* self);
static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color, gboolean apply);
gint game_count_tiles (Game* self, Player color);
gboolean game_can_undo (Game* self);
void game_undo (Game* self, gint count);
gchar* player_to_string (Player self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


Game* game_construct (GType object_type, gint width, gint height) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Player* _tmp2_ = NULL;
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_new0 (Player, _tmp0_ * _tmp1_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp2_;
	self->priv->tiles_length1 = _tmp0_;
	self->priv->tiles_length2 = _tmp1_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = x;
				_tmp7_ = width;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_ = FALSE;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							Player* _tmp13_ = NULL;
							gint _tmp13__length1 = 0;
							gint _tmp13__length2 = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Player _tmp16_ = 0;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = y;
								y = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = y;
							_tmp12_ = height;
							if (!(_tmp11_ < _tmp12_)) {
								break;
							}
							_tmp13_ = self->priv->tiles;
							_tmp13__length1 = self->priv->tiles_length1;
							_tmp13__length2 = self->priv->tiles_length2;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = PLAYER_NONE;
							_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
						}
					}
				}
			}
		}
	}
	game_set_tile (self, 3, 3, PLAYER_LIGHT, FALSE);
	game_set_tile (self, 3, 4, PLAYER_DARK, FALSE);
	game_set_tile (self, 4, 3, PLAYER_DARK, FALSE);
	game_set_tile (self, 4, 4, PLAYER_LIGHT, FALSE);
	game_set_current_color (self, PLAYER_DARK);
	return self;
}


Game* game_new (gint width, gint height) {
	return game_construct (TYPE_GAME, width, height);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


Game* game_construct_from_strings (GType object_type, gchar** setup, int setup_length1, Player to_move, gint width, gint height) {
	Game * self = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Player* _tmp9_ = NULL;
	Player _tmp30_ = 0;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	_tmp0_ = setup;
	_tmp0__length1 = setup_length1;
	_tmp1_ = height;
	g_return_val_if_fail (_tmp0__length1 == _tmp1_, NULL);
	_tmp2_ = setup;
	_tmp2__length1 = setup_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = width;
	g_return_val_if_fail (_tmp5_ == _tmp6_, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp7_ = width;
	_tmp8_ = height;
	_tmp9_ = g_new0 (Player, _tmp7_ * _tmp8_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp9_;
	self->priv->tiles_length1 = _tmp7_;
	self->priv->tiles_length2 = _tmp8_;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = y;
					y = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = y;
				_tmp14_ = height;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							gboolean _tmp16_ = FALSE;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							Player* _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							gint _tmp20__length2 = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gchar** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							const gchar* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gchar _tmp27_ = '\0';
							Player _tmp28_ = 0;
							Player _tmp29_ = 0;
							_tmp16_ = _tmp15_;
							if (!_tmp16_) {
								gint _tmp17_ = 0;
								_tmp17_ = x;
								x = _tmp17_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp18_ = x;
							_tmp19_ = width;
							if (!(_tmp18_ < _tmp19_)) {
								break;
							}
							_tmp20_ = self->priv->tiles;
							_tmp20__length1 = self->priv->tiles_length1;
							_tmp20__length2 = self->priv->tiles_length2;
							_tmp21_ = x;
							_tmp22_ = y;
							_tmp23_ = setup;
							_tmp23__length1 = setup_length1;
							_tmp24_ = y;
							_tmp25_ = _tmp23_[_tmp24_];
							_tmp26_ = x;
							_tmp27_ = string_get (_tmp25_, (glong) _tmp26_);
							_tmp28_ = player_from_char (_tmp27_);
							_tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_] = _tmp28_;
							_tmp29_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
						}
					}
				}
			}
		}
	}
	_tmp30_ = to_move;
	game_set_current_color (self, _tmp30_);
	_tmp31_ = setup;
	_tmp31__length1 = setup_length1;
	_tmp32_ = g_strjoinv ("\n", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = string_strip (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = game_to_string (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = string_strip (_tmp37_);
	_tmp39_ = _tmp38_;
	g_warn_if_fail (g_strcmp0 (_tmp35_, _tmp39_) == 0);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	return self;
}


Game* game_new_from_strings (gchar** setup, int setup_length1, Player to_move, gint width, gint height) {
	return game_construct_from_strings (TYPE_GAME, setup, setup_length1, to_move, width, height);
}


Game* game_construct_copy (GType object_type, Game* game) {
	Game * self = NULL;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player* _tmp6_ = NULL;
	Game* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	Game* _tmp41_ = NULL;
	Player _tmp42_ = 0;
	g_return_val_if_fail (game != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = game;
	_tmp1_ = game_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game;
	_tmp4_ = game_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_new0 (Player, _tmp2_ * _tmp5_);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	self->priv->tiles = _tmp6_;
	self->priv->tiles_length1 = _tmp2_;
	self->priv->tiles_length2 = _tmp5_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = x;
					x = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = x;
				_tmp11_ = game_get_width (self);
				_tmp12_ = _tmp11_;
				if (!(_tmp10_ < _tmp12_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_ = FALSE;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Player* _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
							Player _tmp27_ = 0;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_ = 0;
								_tmp15_ = y;
								y = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = y;
							_tmp17_ = game_get_height (self);
							_tmp18_ = _tmp17_;
							if (!(_tmp16_ < _tmp18_)) {
								break;
							}
							_tmp19_ = self->priv->tiles;
							_tmp19__length1 = self->priv->tiles_length1;
							_tmp19__length2 = self->priv->tiles_length2;
							_tmp20_ = x;
							_tmp21_ = y;
							_tmp22_ = game;
							_tmp23_ = _tmp22_->priv->tiles;
							_tmp23__length1 = _tmp22_->priv->tiles_length1;
							_tmp23__length2 = _tmp22_->priv->tiles_length2;
							_tmp24_ = x;
							_tmp25_ = y;
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
							_tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_] = _tmp26_;
							_tmp27_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				gint _tmp31_ = 0;
				Game* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				Game* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				_tmp29_ = _tmp28_;
				if (!_tmp29_) {
					gint _tmp30_ = 0;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = game;
				_tmp33_ = _tmp32_->priv->undo_index;
				if (!(_tmp31_ < _tmp33_)) {
					break;
				}
				_tmp34_ = i;
				_tmp35_ = game;
				_tmp36_ = i;
				_tmp37_ = _tmp35_->priv->undo_history[_tmp36_];
				self->priv->undo_history[_tmp34_] = _tmp37_;
				_tmp38_ = self->priv->undo_history[_tmp34_];
			}
		}
	}
	_tmp39_ = game;
	_tmp40_ = _tmp39_->priv->undo_index;
	self->priv->undo_index = _tmp40_;
	_tmp41_ = game;
	_tmp42_ = _tmp41_->priv->_current_color;
	game_set_current_color (self, _tmp42_);
	return self;
}


Game* game_new_copy (Game* game) {
	return game_construct_copy (TYPE_GAME, game);
}


Player game_get_owner (Game* self, gint x, gint y) {
	Player result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = game_is_valid_location (self, _tmp0_, _tmp1_);
	if (_tmp2_) {
		Player* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gint _tmp3__length2 = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		Player _tmp6_ = 0;
		_tmp3_ = self->priv->tiles;
		_tmp3__length1 = self->priv->tiles_length1;
		_tmp3__length2 = self->priv->tiles_length2;
		_tmp4_ = x;
		_tmp5_ = y;
		_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
		result = _tmp6_;
		return result;
	} else {
		result = PLAYER_NONE;
		return result;
	}
}


gboolean game_is_complete (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = game_can_move (self, PLAYER_LIGHT);
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = game_can_move (self, PLAYER_DARK);
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	_tmp4_ = result;
	_tmp5_ = game_get_n_tiles (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_width (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = game_get_height (self);
	_tmp10_ = _tmp9_;
	g_warn_if_fail (_tmp4_ || (_tmp6_ < (_tmp8_ * _tmp10_)));
	return result;
}


gboolean game_can_move (Game* self, Player color) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = game_get_width (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Player _tmp14_ = 0;
							gboolean _tmp15_ = FALSE;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = game_get_height (self);
							_tmp11_ = _tmp10_;
							if (!(_tmp9_ < _tmp11_)) {
								break;
							}
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = color;
							_tmp15_ = game_can_place (self, _tmp12_, _tmp13_, _tmp14_);
							if (_tmp15_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean game_can_place (Game* self, gint x, gint y, Player color) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Player _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = color;
	_tmp3_ = game_place (self, _tmp0_, _tmp1_, _tmp2_, FALSE);
	result = _tmp3_ > 0;
	return result;
}


gint game_place_tile (Game* self, gint x, gint y) {
	gint result = 0;
	gint n_tiles = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Player _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Player _tmp5_ = 0;
	Player _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = self->priv->_current_color;
	_tmp3_ = game_place (self, _tmp0_, _tmp1_, _tmp2_, TRUE);
	n_tiles = _tmp3_;
	_tmp4_ = n_tiles;
	if (_tmp4_ == 0) {
		result = 0;
		return result;
	}
	_tmp5_ = self->priv->_current_color;
	_tmp6_ = player_flip_color (_tmp5_);
	game_set_current_color (self, _tmp6_);
	_tmp7_ = game_is_complete (self);
	if (_tmp7_) {
		g_signal_emit_by_name (self, "complete");
	} else {
		g_signal_emit_by_name (self, "move");
	}
	result = n_tiles;
	return result;
}


void game_pass (Game* self) {
	Player _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Player _tmp5_ = 0;
	Player _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_color;
	_tmp1_ = game_can_move (self, _tmp0_);
	g_return_if_fail (!_tmp1_);
	_tmp2_ = self->priv->undo_index;
	self->priv->undo_history[_tmp2_] = 0;
	_tmp3_ = self->priv->undo_history[_tmp2_];
	_tmp4_ = self->priv->undo_index;
	self->priv->undo_index = _tmp4_ + 1;
	_tmp5_ = self->priv->_current_color;
	_tmp6_ = player_flip_color (_tmp5_);
	game_set_current_color (self, _tmp6_);
	g_signal_emit_by_name (self, "move");
}


static gint game_place (Game* self, gint x, gint y, Player color, gboolean apply) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint n_flips = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Player _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Player _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	Player _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Player _tmp30_ = 0;
	gboolean _tmp31_ = FALSE;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	Player _tmp36_ = 0;
	gboolean _tmp37_ = FALSE;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	Player _tmp42_ = 0;
	gboolean _tmp43_ = FALSE;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	Player _tmp48_ = 0;
	gboolean _tmp49_ = FALSE;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	Player _tmp54_ = 0;
	gboolean _tmp55_ = FALSE;
	gint _tmp56_ = 0;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp60_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = game_is_valid_location (self, _tmp1_, _tmp2_);
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Player* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp4__length2 = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		Player _tmp7_ = 0;
		_tmp4_ = self->priv->tiles;
		_tmp4__length1 = self->priv->tiles_length1;
		_tmp4__length2 = self->priv->tiles_length2;
		_tmp5_ = x;
		_tmp6_ = y;
		_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
		_tmp0_ = _tmp7_ != PLAYER_NONE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = 0;
		return result;
	}
	n_flips = 0;
	_tmp9_ = n_flips;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = color;
	_tmp13_ = apply;
	_tmp14_ = game_flip_tiles (self, _tmp10_, _tmp11_, 1, 0, _tmp12_, _tmp13_);
	n_flips = _tmp9_ + _tmp14_;
	_tmp15_ = n_flips;
	_tmp16_ = x;
	_tmp17_ = y;
	_tmp18_ = color;
	_tmp19_ = apply;
	_tmp20_ = game_flip_tiles (self, _tmp16_, _tmp17_, 1, 1, _tmp18_, _tmp19_);
	n_flips = _tmp15_ + _tmp20_;
	_tmp21_ = n_flips;
	_tmp22_ = x;
	_tmp23_ = y;
	_tmp24_ = color;
	_tmp25_ = apply;
	_tmp26_ = game_flip_tiles (self, _tmp22_, _tmp23_, 0, 1, _tmp24_, _tmp25_);
	n_flips = _tmp21_ + _tmp26_;
	_tmp27_ = n_flips;
	_tmp28_ = x;
	_tmp29_ = y;
	_tmp30_ = color;
	_tmp31_ = apply;
	_tmp32_ = game_flip_tiles (self, _tmp28_, _tmp29_, -1, 1, _tmp30_, _tmp31_);
	n_flips = _tmp27_ + _tmp32_;
	_tmp33_ = n_flips;
	_tmp34_ = x;
	_tmp35_ = y;
	_tmp36_ = color;
	_tmp37_ = apply;
	_tmp38_ = game_flip_tiles (self, _tmp34_, _tmp35_, -1, 0, _tmp36_, _tmp37_);
	n_flips = _tmp33_ + _tmp38_;
	_tmp39_ = n_flips;
	_tmp40_ = x;
	_tmp41_ = y;
	_tmp42_ = color;
	_tmp43_ = apply;
	_tmp44_ = game_flip_tiles (self, _tmp40_, _tmp41_, -1, -1, _tmp42_, _tmp43_);
	n_flips = _tmp39_ + _tmp44_;
	_tmp45_ = n_flips;
	_tmp46_ = x;
	_tmp47_ = y;
	_tmp48_ = color;
	_tmp49_ = apply;
	_tmp50_ = game_flip_tiles (self, _tmp46_, _tmp47_, 0, -1, _tmp48_, _tmp49_);
	n_flips = _tmp45_ + _tmp50_;
	_tmp51_ = n_flips;
	_tmp52_ = x;
	_tmp53_ = y;
	_tmp54_ = color;
	_tmp55_ = apply;
	_tmp56_ = game_flip_tiles (self, _tmp52_, _tmp53_, 1, -1, _tmp54_, _tmp55_);
	n_flips = _tmp51_ + _tmp56_;
	_tmp58_ = apply;
	if (_tmp58_) {
		gint _tmp59_ = 0;
		_tmp59_ = n_flips;
		_tmp57_ = _tmp59_ > 0;
	} else {
		_tmp57_ = FALSE;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		_tmp61_ = self->priv->undo_index;
		_tmp62_ = n_flips;
		self->priv->undo_history[_tmp61_] = _tmp62_ + 1;
		_tmp63_ = self->priv->undo_history[_tmp61_];
		_tmp64_ = self->priv->undo_index;
		self->priv->undo_index = _tmp64_ + 1;
	}
	result = n_flips;
	return result;
}


gint game_count_tiles (Game* self, Player color) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = game_get_width (self);
				_tmp5_ = _tmp4_;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							Player* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp12__length2 = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							Player _tmp15_ = 0;
							Player _tmp16_ = 0;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = game_get_height (self);
							_tmp11_ = _tmp10_;
							if (!(_tmp9_ < _tmp11_)) {
								break;
							}
							_tmp12_ = self->priv->tiles;
							_tmp12__length1 = self->priv->tiles_length1;
							_tmp12__length2 = self->priv->tiles_length2;
							_tmp13_ = x;
							_tmp14_ = y;
							_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
							_tmp16_ = color;
							if (_tmp15_ == _tmp16_) {
								gint _tmp17_ = 0;
								_tmp17_ = count;
								count = _tmp17_ + 1;
							}
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gboolean game_is_valid_location (Game* self, gint x, gint y) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = x;
	if (_tmp3_ >= 0) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = x;
		_tmp5_ = game_get_width (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		_tmp8_ = y;
		_tmp1_ = _tmp8_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp10_ = y;
		_tmp11_ = game_get_height (self);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp10_ < _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp13_ = _tmp0_;
	result = _tmp13_;
	return result;
}


static gint game_flip_tiles (Game* self, gint x, gint y, gint x_step, gint y_step, Player color, gboolean apply) {
	gint result = 0;
	Player enemy = 0;
	Player _tmp0_ = 0;
	gint enemy_count = 0;
	gint xt = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint yt = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	enemy = PLAYER_LIGHT;
	_tmp0_ = color;
	if (_tmp0_ == PLAYER_LIGHT) {
		enemy = PLAYER_DARK;
	}
	enemy_count = 0;
	_tmp1_ = x;
	_tmp2_ = x_step;
	xt = _tmp1_ + _tmp2_;
	_tmp3_ = y;
	_tmp4_ = y_step;
	yt = _tmp3_ + _tmp4_;
	while (TRUE) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		Player* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gint _tmp8__length2 = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Player _tmp11_ = 0;
		Player _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp5_ = xt;
		_tmp6_ = yt;
		_tmp7_ = game_is_valid_location (self, _tmp5_, _tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->tiles;
		_tmp8__length1 = self->priv->tiles_length1;
		_tmp8__length2 = self->priv->tiles_length2;
		_tmp9_ = xt;
		_tmp10_ = yt;
		_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
		_tmp12_ = enemy;
		if (_tmp11_ != _tmp12_) {
			break;
		}
		_tmp13_ = enemy_count;
		enemy_count = _tmp13_ + 1;
		_tmp14_ = xt;
		_tmp15_ = x_step;
		xt = _tmp14_ + _tmp15_;
		_tmp16_ = yt;
		_tmp17_ = y_step;
		yt = _tmp16_ + _tmp17_;
	}
	_tmp20_ = enemy_count;
	if (_tmp20_ == 0) {
		_tmp19_ = TRUE;
	} else {
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = xt;
		_tmp22_ = yt;
		_tmp23_ = game_is_valid_location (self, _tmp21_, _tmp22_);
		_tmp19_ = !_tmp23_;
	}
	_tmp24_ = _tmp19_;
	if (_tmp24_) {
		_tmp18_ = TRUE;
	} else {
		Player* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp25__length2 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		Player _tmp28_ = 0;
		Player _tmp29_ = 0;
		_tmp25_ = self->priv->tiles;
		_tmp25__length1 = self->priv->tiles_length1;
		_tmp25__length2 = self->priv->tiles_length2;
		_tmp26_ = xt;
		_tmp27_ = yt;
		_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
		_tmp29_ = color;
		_tmp18_ = _tmp28_ != _tmp29_;
	}
	_tmp30_ = _tmp18_;
	if (_tmp30_) {
		result = 0;
		return result;
	}
	_tmp31_ = apply;
	if (_tmp31_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					gboolean _tmp33_ = FALSE;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					Player _tmp43_ = 0;
					_tmp33_ = _tmp32_;
					if (!_tmp33_) {
						gint _tmp34_ = 0;
						_tmp34_ = i;
						i = _tmp34_ + 1;
					}
					_tmp32_ = FALSE;
					_tmp35_ = i;
					_tmp36_ = enemy_count;
					if (!(_tmp35_ <= _tmp36_)) {
						break;
					}
					_tmp37_ = x;
					_tmp38_ = i;
					_tmp39_ = x_step;
					_tmp40_ = y;
					_tmp41_ = i;
					_tmp42_ = y_step;
					_tmp43_ = color;
					game_set_tile (self, _tmp37_ + (_tmp38_ * _tmp39_), _tmp40_ + (_tmp41_ * _tmp42_), _tmp43_, TRUE);
				}
			}
		}
	}
	result = enemy_count;
	return result;
}


gboolean game_can_undo (Game* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->undo_index;
	result = _tmp0_ > 0;
	return result;
}


void game_undo (Game* self, gint count) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	_tmp1_ = count;
	g_return_if_fail ((_tmp0_ == 1) || (_tmp1_ == 2));
	_tmp2_ = game_can_undo (self);
	if (!_tmp2_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint n_changes = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				Player _tmp28_ = 0;
				Player _tmp29_ = 0;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = count;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->undo_index;
				_tmp9_ = self->priv->undo_history[_tmp8_ - 1];
				n_changes = _tmp9_;
				_tmp10_ = self->priv->undo_index;
				self->priv->undo_index = _tmp10_ - 1;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp12_ = FALSE;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint n = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Player c = 0;
							gint _tmp19_ = 0;
							gint xy = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Player _tmp27_ = 0;
							_tmp12_ = _tmp11_;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = j;
								j = _tmp13_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp14_ = j;
							_tmp15_ = n_changes;
							if (!(_tmp14_ < _tmp15_)) {
								break;
							}
							_tmp16_ = self->priv->undo_index;
							_tmp17_ = self->priv->undo_history[_tmp16_ - 1];
							n = _tmp17_;
							_tmp18_ = self->priv->undo_index;
							self->priv->undo_index = _tmp18_ - 1;
							_tmp19_ = n;
							c = (Player) (_tmp19_ >> 6);
							_tmp20_ = n;
							xy = _tmp20_ & 0x3F;
							_tmp21_ = xy;
							_tmp22_ = game_get_width (self);
							_tmp23_ = _tmp22_;
							_tmp24_ = xy;
							_tmp25_ = game_get_width (self);
							_tmp26_ = _tmp25_;
							_tmp27_ = c;
							game_set_tile (self, _tmp21_ % _tmp23_, _tmp24_ / _tmp26_, _tmp27_, FALSE);
						}
					}
				}
				_tmp28_ = self->priv->_current_color;
				_tmp29_ = player_flip_color (_tmp28_);
				game_set_current_color (self, _tmp29_);
			}
		}
	}
}


static void game_set_tile (Game* self, gint x, gint y, Player color, gboolean update_history) {
	Player* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	Player* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp17__length2 = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Player _tmp20_ = 0;
	Player _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = color;
	if (_tmp3_ == _tmp4_) {
		return;
	}
	_tmp5_ = update_history;
	if (_tmp5_) {
		gint _tmp6_ = 0;
		Player* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Player _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp6_ = self->priv->undo_index;
		_tmp7_ = self->priv->tiles;
		_tmp7__length1 = self->priv->tiles_length1;
		_tmp7__length2 = self->priv->tiles_length2;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
		_tmp11_ = y;
		_tmp12_ = game_get_width (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = x;
		self->priv->undo_history[_tmp6_] = (((gint) _tmp10_) << 6) | ((_tmp11_ * _tmp13_) + _tmp14_);
		_tmp15_ = self->priv->undo_history[_tmp6_];
		_tmp16_ = self->priv->undo_index;
		self->priv->undo_index = _tmp16_ + 1;
	}
	_tmp17_ = self->priv->tiles;
	_tmp17__length1 = self->priv->tiles_length1;
	_tmp17__length2 = self->priv->tiles_length2;
	_tmp18_ = x;
	_tmp19_ = y;
	_tmp20_ = color;
	_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_] = _tmp20_;
	_tmp21_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
	_tmp22_ = x;
	_tmp23_ = y;
	g_signal_emit_by_name (self, "square-changed", _tmp22_, _tmp23_);
}


gchar* game_to_string (Game* self) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = y;
					y = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = y;
				_tmp5_ = game_get_height (self);
				_tmp6_ = _tmp5_;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gboolean _tmp8_ = FALSE;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							const gchar* _tmp13_ = NULL;
							Player* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Player _tmp17_ = 0;
							gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_ = NULL;
							_tmp8_ = _tmp7_;
							if (!_tmp8_) {
								gint _tmp9_ = 0;
								_tmp9_ = x;
								x = _tmp9_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp10_ = x;
							_tmp11_ = game_get_width (self);
							_tmp12_ = _tmp11_;
							if (!(_tmp10_ < _tmp12_)) {
								break;
							}
							_tmp13_ = s;
							_tmp14_ = self->priv->tiles;
							_tmp14__length1 = self->priv->tiles_length1;
							_tmp14__length2 = self->priv->tiles_length2;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = player_to_string (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
							_g_free0 (s);
							s = _tmp20_;
							_g_free0 (_tmp19_);
						}
					}
				}
				_tmp21_ = s;
				_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
				_g_free0 (s);
				s = _tmp22_;
			}
		}
	}
	result = s;
	return result;
}


gint game_get_width (Game* self) {
	gint result;
	Player* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0__length1;
	result = _tmp1_;
	return result;
}


gint game_get_height (Game* self) {
	gint result;
	Player* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0__length2;
	result = _tmp1_;
	return result;
}


Player game_get_current_color (Game* self) {
	Player result;
	Player _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_current_color;
	result = _tmp0_;
	return result;
}


static void game_set_current_color (Game* self, Player value) {
	Player _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_current_color = _tmp0_;
	g_object_notify ((GObject *) self, "current-color");
}


gint game_get_n_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_get_n_light_tiles (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_n_dark_tiles (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ + _tmp3_;
	return result;
}


gint game_get_n_light_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_count_tiles (self, PLAYER_LIGHT);
	result = _tmp0_;
	return result;
}


gint game_get_n_dark_tiles (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = game_count_tiles (self, PLAYER_DARK);
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CURRENT_COLOR, g_param_spec_enum ("current-color", "current-color", "current-color", TYPE_PLAYER, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_TILES, g_param_spec_int ("n-tiles", "n-tiles", "n-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_LIGHT_TILES, g_param_spec_int ("n-light-tiles", "n-light-tiles", "n-light-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_N_DARK_TILES, g_param_spec_int ("n-dark-tiles", "n-dark-tiles", "n-dark-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("square_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->undo_index = 0;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_WIDTH:
		g_value_set_int (value, game_get_width (self));
		break;
		case GAME_HEIGHT:
		g_value_set_int (value, game_get_height (self));
		break;
		case GAME_CURRENT_COLOR:
		g_value_set_enum (value, game_get_current_color (self));
		break;
		case GAME_N_TILES:
		g_value_set_int (value, game_get_n_tiles (self));
		break;
		case GAME_N_LIGHT_TILES:
		g_value_set_int (value, game_get_n_light_tiles (self));
		break;
		case GAME_N_DARK_TILES:
		g_value_set_int (value, game_get_n_dark_tiles (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_CURRENT_COLOR:
		game_set_current_color (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



