/* test-chess-game.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from test-chess-game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GL_CHESS (gl_chess_get_type ())
#define GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GL_CHESS, GlChess))
#define GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GL_CHESS, GlChessClass))
#define IS_GL_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GL_CHESS))
#define IS_GL_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GL_CHESS))
#define GL_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GL_CHESS, GlChessClass))

typedef struct _GlChess GlChess;
typedef struct _GlChessClass GlChessClass;
typedef struct _GlChessPrivate GlChessPrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ParamSpecGlChess ParamSpecGlChess;

struct _GlChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GlChessPrivate * priv;
};

struct _GlChessClass {
	GTypeClass parent_class;
	void (*finalize) (GlChess *self);
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ParamSpecGlChess {
	GParamSpec parent_instance;
};


static gpointer gl_chess_parent_class = NULL;
static gint gl_chess_test_count;
static gint gl_chess_test_count = 0;
static gint gl_chess_failure_count;
static gint gl_chess_failure_count = 0;

gpointer gl_chess_ref (gpointer instance);
void gl_chess_unref (gpointer instance);
GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gl_chess (GValue* value, gpointer v_object);
void value_take_gl_chess (GValue* value, gpointer v_object);
gpointer value_get_gl_chess (const GValue* value);
GType gl_chess_get_type (void) G_GNUC_CONST;
enum  {
	GL_CHESS_DUMMY_PROPERTY
};
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule, gboolean verify_san);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
gchar* chess_state_get_fen (ChessState* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
const gchar* chess_result_to_string (ChessResult self);
static void gl_chess_test_bad_move (const gchar* fen, const gchar* move);
gint gl_chess_main (gchar** args, int args_length1);
GlChess* gl_chess_new (void);
GlChess* gl_chess_construct (GType object_type);
static void gl_chess_finalize (GlChess* obj);


static void gl_chess_test_good_move (const gchar* fen, const gchar* move, const gchar* result_fen, ChessResult _result_, ChessRule rule, gboolean verify_san) {
	ChessState* state = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ChessState* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp32_ = FALSE;
	ChessRule move_rule = 0;
	ChessResult move_result = 0;
	ChessState* _tmp42_ = NULL;
	ChessRule _tmp43_ = 0;
	ChessResult _tmp44_ = 0;
	gboolean _tmp45_ = FALSE;
	ChessResult _tmp46_ = 0;
	ChessResult _tmp47_ = 0;
	gboolean _tmp50_ = FALSE;
	FILE* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (fen != NULL);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (move != NULL);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (result_fen != NULL);
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp0_ = fen;
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp1_ = chess_state_new (_tmp0_);
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	state = _tmp1_;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp2_ = gl_chess_test_count;
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_count = _tmp2_ + 1;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp3_ = state;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp4_ = move;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp5_ = chess_state_move (_tmp3_, _tmp4_, TRUE);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (!_tmp5_) {
#line 257 "test-chess-game.c"
		FILE* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp6_ = stderr;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp7_ = gl_chess_test_count;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp8_ = fen;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp9_ = move;
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		fprintf (_tmp6_, "%d. FAIL %s + %s is an invalid move\n", _tmp7_, _tmp8_, _tmp9_);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp10_ = gl_chess_failure_count;
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_failure_count = _tmp10_ + 1;
#line 27 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_chess_state_unref0 (state);
#line 27 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return;
#line 281 "test-chess-game.c"
	}
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp11_ = state;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp12_ = chess_state_get_fen (_tmp11_);
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp13_ = _tmp12_;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp14_ = result_fen;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp15_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_g_free0 (_tmp13_);
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp15_) {
#line 297 "test-chess-game.c"
		FILE* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		ChessState* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp16_ = stderr;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp17_ = gl_chess_test_count;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp18_ = fen;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp19_ = move;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp20_ = state;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp21_ = chess_state_get_fen (_tmp20_);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp22_ = _tmp21_;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp23_ = result_fen;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		fprintf (_tmp16_, "%d. FAIL %s + %s has state %s not %s\n", _tmp17_, _tmp18_, _tmp19_, _tmp22_, _tmp23_);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_g_free0 (_tmp22_);
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp24_ = gl_chess_failure_count;
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_failure_count = _tmp24_ + 1;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_chess_state_unref0 (state);
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return;
#line 335 "test-chess-game.c"
	}
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp26_ = verify_san;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp26_) {
#line 341 "test-chess-game.c"
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp27_ = state;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp28_ = _tmp27_->last_move;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp29_ = chess_move_get_san (_tmp28_);
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp30_ = _tmp29_;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp31_ = move;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp25_ = g_strcmp0 (_tmp30_, _tmp31_) != 0;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_g_free0 (_tmp30_);
#line 361 "test-chess-game.c"
	} else {
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp25_ = FALSE;
#line 365 "test-chess-game.c"
	}
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp32_ = _tmp25_;
#line 39 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp32_) {
#line 371 "test-chess-game.c"
		FILE* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		ChessState* _tmp37_ = NULL;
		ChessMove* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp33_ = stderr;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp34_ = gl_chess_test_count;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp35_ = fen;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp36_ = move;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp37_ = state;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp38_ = _tmp37_->last_move;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp39_ = chess_move_get_san (_tmp38_);
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp40_ = _tmp39_;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		fprintf (_tmp33_, "%d. FAIL %s + %s has SAN move %s\n", _tmp34_, _tmp35_, _tmp36_, _tmp40_);
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_g_free0 (_tmp40_);
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp41_ = gl_chess_failure_count;
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_failure_count = _tmp41_ + 1;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_chess_state_unref0 (state);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return;
#line 409 "test-chess-game.c"
	}
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp42_ = state;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp44_ = chess_state_get_result (_tmp42_, &_tmp43_);
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	move_rule = _tmp43_;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	move_result = _tmp44_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp46_ = move_result;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp47_ = _result_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp46_ != _tmp47_) {
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp45_ = TRUE;
#line 427 "test-chess-game.c"
	} else {
		ChessRule _tmp48_ = 0;
		ChessRule _tmp49_ = 0;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp48_ = move_rule;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp49_ = rule;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp45_ = _tmp48_ != _tmp49_;
#line 437 "test-chess-game.c"
	}
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp50_ = _tmp45_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp50_) {
#line 443 "test-chess-game.c"
		FILE* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		const gchar* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		ChessResult _tmp55_ = 0;
		GEnumValue* _tmp56_;
		ChessResult _tmp57_ = 0;
		GEnumValue* _tmp58_;
		gint _tmp59_ = 0;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp51_ = stderr;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp52_ = gl_chess_test_count;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp53_ = fen;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp54_ = move;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp55_ = move_result;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp56_ = g_enum_get_value (g_type_class_ref (TYPE_CHESS_RESULT), _tmp55_);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp57_ = _result_;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp58_ = g_enum_get_value (g_type_class_ref (TYPE_CHESS_RESULT), _tmp57_);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		fprintf (_tmp51_, "%d. FAIL %s + %s has result %s not %s\n", _tmp52_, _tmp53_, _tmp54_, (_tmp56_ != NULL) ? _tmp56_->value_name : NULL, (_tmp58_ != NULL) ? _tmp58_->value_name : NULL);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp59_ = gl_chess_failure_count;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_failure_count = _tmp59_ + 1;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_chess_state_unref0 (state);
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return;
#line 479 "test-chess-game.c"
	}
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp60_ = stderr;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp61_ = gl_chess_test_count;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp62_ = fen;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp63_ = move;
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	fprintf (_tmp60_, "%d. PASS %s + %s is valid\n", _tmp61_, _tmp62_, _tmp63_);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_chess_state_unref0 (state);
#line 493 "test-chess-game.c"
}


static void gl_chess_test_bad_move (const gchar* fen, const gchar* move) {
	ChessState* state = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	FILE* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (fen != NULL);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (move != NULL);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp0_ = fen;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp1_ = chess_state_new (_tmp0_);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	state = _tmp1_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp2_ = gl_chess_test_count;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_count = _tmp2_ + 1;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp3_ = state;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp4_ = move;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp5_ = chess_state_move (_tmp3_, _tmp4_, FALSE);
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (_tmp5_) {
#line 531 "test-chess-game.c"
		FILE* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp6_ = stderr;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp7_ = gl_chess_test_count;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp8_ = fen;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp9_ = move;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		fprintf (_tmp6_, "%d. FAIL %s + %s is valid\n", _tmp7_, _tmp8_, _tmp9_);
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_tmp10_ = gl_chess_failure_count;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_failure_count = _tmp10_ + 1;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		_chess_state_unref0 (state);
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return;
#line 555 "test-chess-game.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp11_ = stderr;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp12_ = gl_chess_test_count;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp13_ = fen;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp14_ = move;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	fprintf (_tmp11_, "%d. PASS %s + %s is invalid\n", _tmp12_, _tmp13_, _tmp14_);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_chess_state_unref0 (state);
#line 569 "test-chess-game.c"
}


gint gl_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a3", "8/8/8/8/8/P7/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/8/8/8/P7/8 w - - 0 1", "a4", "8/8/8/8/P7/8/8/8 b - a3 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 83 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/P7/8/8 w - - 0 1", "a2a5");
#line 86 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a8=Q", "Q7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 88 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a7a8q", "Q7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/P7/8/8/8/8/8/8 w - - 0 1", "a7a8N", "N7/8/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 94 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/pP6/8/8/8/8 w - a6 0 1", "bxa6", "8/8/P7/8/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/pP6/8/8/8/8 w - - 0 1", "b5a6");
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/pQ6/8/8/8/8 w - a6 0 1", "Qa6", "8/8/Q7/p7/8/8/8/8 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/pQ6/8/8/8/8 w - a6 0 1", "bxa6");
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/8/8/8/8/4K2R w K - 0 1", "O-O", "8/8/8/8/8/8/8/5RK1 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 110 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("8/8/8/8/8/8/8/R3K3 w Q - 0 1", "O-O-O", "8/8/8/8/8/8/8/2KR4 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K2R w - - 0 1", "O-O");
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/4K3 w K - 0 1", "O-O");
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/8/8/5K2 w K - 0 1", "O-O");
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("5r2/8/8/8/8/8/8/4K2R w K - 0 1", "O-O");
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/8/6p1/4K2R w K - 0 1", "O-O");
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("8/8/8/8/8/8/4p3/R3K3 w Q - 0 1", "O-O-O");
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_bad_move ("4r3/8/8/8/8/8/4R3/4K3 w - - 0 1", "e2f2");
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/8/8/8/8/8/8/1R6 w - - 0 1", "Ra1+", "k7/8/8/8/8/8/8/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/8/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1#", "k7/8/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_WHITE_WON, CHESS_RULE_CHECKMATE, FALSE);
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/7r/8/8/8/8/1R6/1R6 w - - 0 1", "Ra1+", "k7/7r/8/8/8/8/1R6/R7 b - - 1 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/8/7R/8/8/8/8/1R6 w - - 0 1", "Rh7", "k7/7R/8/8/8/8/8/1R6 b - - 1 1", CHESS_RESULT_DRAW, CHESS_RULE_STALEMATE, FALSE);
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/8 w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/8 b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/7N w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/7N b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/6Nn w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/6Nn b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k7/7p/7K/8/8/8/8/6Nb w - - 0 1", "Kxh7", "k7/7K/8/8/8/8/8/6Nb b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/4B1B1/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/4B1B1/8/8/8/8 b - - 0 1", CHESS_RESULT_DRAW, CHESS_RULE_INSUFFICIENT_MATERIAL, FALSE);
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/5B1B/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/5B1B/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k6b/6bp/7K/7B/8/8/8/8 w - - 0 1", "Kxh7", "k6b/6bK/8/7B/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_test_good_move ("k2b1b1b/6bp/7K/6BB/8/8/8/8 w - - 0 1", "Kxh7", "k2b1b1b/6bK/8/6BB/8/8/8/8 b - - 0 1", CHESS_RESULT_IN_PROGRESS, CHESS_RULE_CHECKMATE, FALSE);
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp0_ = stdout;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp1_ = gl_chess_test_count;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp2_ = gl_chess_failure_count;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp3_ = gl_chess_test_count;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	fprintf (_tmp0_, "%d/%d tests successful\n", _tmp1_ - _tmp2_, _tmp3_);
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	_tmp4_ = gl_chess_failure_count;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	result = _tmp4_;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return result;
#line 660 "test-chess-game.c"
}


int main (int argc, char ** argv) {
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_type_init ();
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return gl_chess_main (argv, argc);
#line 669 "test-chess-game.c"
}


GlChess* gl_chess_construct (GType object_type) {
	GlChess* self = NULL;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	self = (GlChess*) g_type_create_instance (object_type);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return self;
#line 679 "test-chess-game.c"
}


GlChess* gl_chess_new (void) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return gl_chess_construct (TYPE_GL_CHESS);
#line 686 "test-chess-game.c"
}


static void value_gl_chess_init (GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	value->data[0].v_pointer = NULL;
#line 693 "test-chess-game.c"
}


static void value_gl_chess_free_value (GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_unref (value->data[0].v_pointer);
#line 702 "test-chess-game.c"
	}
}


static void value_gl_chess_copy_value (const GValue* src_value, GValue* dest_value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (src_value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		dest_value->data[0].v_pointer = gl_chess_ref (src_value->data[0].v_pointer);
#line 712 "test-chess-game.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 716 "test-chess-game.c"
	}
}


static gpointer value_gl_chess_peek_pointer (const GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return value->data[0].v_pointer;
#line 724 "test-chess-game.c"
}


static gchar* value_gl_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (collect_values[0].v_pointer) {
#line 731 "test-chess-game.c"
		GlChess* object;
		object = collect_values[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 738 "test-chess-game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 742 "test-chess-game.c"
		}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = gl_chess_ref (object);
#line 746 "test-chess-game.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 750 "test-chess-game.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return NULL;
#line 754 "test-chess-game.c"
}


static gchar* value_gl_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GlChess** object_p;
	object_p = collect_values[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (!object_p) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 765 "test-chess-game.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (!value->data[0].v_pointer) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		*object_p = NULL;
#line 771 "test-chess-game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		*object_p = value->data[0].v_pointer;
#line 775 "test-chess-game.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		*object_p = gl_chess_ref (value->data[0].v_pointer);
#line 779 "test-chess-game.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return NULL;
#line 783 "test-chess-game.c"
}


GParamSpec* param_spec_gl_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGlChess* spec;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GL_CHESS), NULL);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return G_PARAM_SPEC (spec);
#line 797 "test-chess-game.c"
}


gpointer value_get_gl_chess (const GValue* value) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS), NULL);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return value->data[0].v_pointer;
#line 806 "test-chess-game.c"
}


void value_set_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	old = value->data[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (v_object) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_ref (value->data[0].v_pointer);
#line 826 "test-chess-game.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 830 "test-chess-game.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (old) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_unref (old);
#line 836 "test-chess-game.c"
	}
}


void value_take_gl_chess (GValue* value, gpointer v_object) {
	GlChess* old;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GL_CHESS));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	old = value->data[0].v_pointer;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (v_object) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GL_CHESS));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 855 "test-chess-game.c"
	} else {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 859 "test-chess-game.c"
	}
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (old) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		gl_chess_unref (old);
#line 865 "test-chess-game.c"
	}
}


static void gl_chess_class_init (GlChessClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	gl_chess_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	GL_CHESS_CLASS (klass)->finalize = gl_chess_finalize;
#line 875 "test-chess-game.c"
}


static void gl_chess_instance_init (GlChess * self) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	self->ref_count = 1;
#line 882 "test-chess-game.c"
}


static void gl_chess_finalize (GlChess* obj) {
	GlChess * self;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GL_CHESS, GlChess);
#line 890 "test-chess-game.c"
}


GType gl_chess_get_type (void) {
	static volatile gsize gl_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gl_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gl_chess_init, value_gl_chess_free_value, value_gl_chess_copy_value, value_gl_chess_peek_pointer, "p", value_gl_chess_collect_value, "p", value_gl_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GlChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gl_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlChess), 0, (GInstanceInitFunc) gl_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gl_chess_type_id;
		gl_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GlChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gl_chess_type_id__volatile, gl_chess_type_id);
	}
	return gl_chess_type_id__volatile;
}


gpointer gl_chess_ref (gpointer instance) {
	GlChess* self;
	self = instance;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	return instance;
#line 915 "test-chess-game.c"
}


void gl_chess_unref (gpointer instance) {
	GlChess* self;
	self = instance;
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		GL_CHESS_GET_CLASS (self)->finalize (self);
#line 11 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/test-chess-game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 928 "test-chess-game.c"
	}
}



