/* chess-game.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecChessPiece ParamSpecChessPiece;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _chess_move_unref0(var) ((var == NULL) ? NULL : (var = (chess_move_unref (var), NULL)))
typedef struct _ParamSpecChessMove ParamSpecChessMove;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())
typedef struct _ParamSpecChessState ParamSpecChessState;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__chess_state_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_state_unref0_ (var), NULL)))
typedef struct _ParamSpecChessGame ParamSpecChessGame;

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPlayerPrivate {
	gboolean _local_human;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

struct _ParamSpecChessPiece {
	GParamSpec parent_instance;
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

struct _ParamSpecChessMove {
	GParamSpec parent_instance;
};

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

struct _ParamSpecChessState {
	GParamSpec parent_instance;
};

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	gboolean _is_superpaused;
	ChessClock* _clock;
};

struct _ParamSpecChessGame {
	GParamSpec parent_instance;
};


static gpointer chess_player_parent_class = NULL;
static gpointer chess_piece_parent_class = NULL;
static gpointer chess_move_parent_class = NULL;
static gpointer chess_state_parent_class = NULL;
static gpointer chess_game_parent_class = NULL;

GType color_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
#define CHESS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_PLAYER, ChessPlayerPrivate))
enum  {
	CHESS_PLAYER_DUMMY_PROPERTY,
	CHESS_PLAYER_LOCAL_HUMAN
};
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
GType piece_type_get_type (void) G_GNUC_CONST;
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
void chess_player_undo (ChessPlayer* self);
gboolean chess_player_resign (ChessPlayer* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_player_finalize (GObject* obj);
static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_PIECE_DUMMY_PROPERTY
};
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
Color chess_piece_get_color (ChessPiece* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
static void chess_piece_finalize (ChessPiece* obj);
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MOVE_DUMMY_PROPERTY
};
gchar* chess_move_get_lan (ChessMove* self);
gchar* chess_move_get_san (ChessMove* self);
static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
static void chess_move_finalize (ChessMove* obj);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
enum  {
	CHESS_STATE_DUMMY_PROPERTY
};
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
static gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static void chess_state_finalize (ChessState* obj);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY
};
void chess_clock_stop (ChessClock* self);
static void _chess_state_unref0_ (gpointer var);
static void _g_list_free__chess_state_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gboolean chess_game_is_three_fold_repeat (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
void chess_game_abandon (ChessGame* self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
void chess_game_pause (ChessGame* self);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
void chess_game_superpause (ChessGame* self);
static void chess_game_set_is_superpaused (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
gboolean chess_game_get_is_superpaused (ChessGame* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_game_finalize (ChessGame* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType color_get_type (void) {
	static volatile gsize color_type_id__volatile = 0;
	if (g_once_init_enter (&color_type_id__volatile)) {
		static const GEnumValue values[] = {{COLOR_WHITE, "COLOR_WHITE", "white"}, {COLOR_BLACK, "COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType color_type_id;
		color_type_id = g_enum_register_static ("Color", values);
		g_once_init_leave (&color_type_id__volatile, color_type_id);
	}
	return color_type_id__volatile;
}


ChessPlayer* chess_player_construct (GType object_type, Color color) {
	ChessPlayer * self = NULL;
	Color _tmp0_ = 0;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessPlayer*) g_object_new (object_type, NULL);
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = color;
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->color = _tmp0_;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 451 "chess-game.c"
}


ChessPlayer* chess_player_new (Color color) {
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_player_construct (TYPE_CHESS_PLAYER, color);
#line 458 "chess-game.c"
}


gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = move;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = apply;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "do-move", _tmp0_, _tmp1_, &_tmp2_);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp2_;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 481 "chess-game.c"
}


gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type) {
	gboolean result = FALSE;
	gchar* move = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	PieceType _tmp5_ = 0;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = f0;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = r0;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = f1;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = r1;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = g_strdup_printf ("%c%d%c%d", 'a' + _tmp0_, _tmp1_ + 1, 'a' + _tmp2_, _tmp3_ + 1);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move = _tmp4_;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = promotion_type;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp5_) {
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_QUEEN:
#line 517 "chess-game.c"
		{
#line 55 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 521 "chess-game.c"
		}
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_KNIGHT:
#line 525 "chess-game.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp6_ = move;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp7_ = g_strconcat (_tmp6_, "=N", NULL);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_g_free0 (move);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			move = _tmp7_;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 539 "chess-game.c"
		}
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_ROOK:
#line 543 "chess-game.c"
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp8_ = move;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp9_ = g_strconcat (_tmp8_, "=R", NULL);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_g_free0 (move);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			move = _tmp9_;
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 557 "chess-game.c"
		}
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_BISHOP:
#line 561 "chess-game.c"
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp10_ = move;
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp11_ = g_strconcat (_tmp10_, "=B", NULL);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_g_free0 (move);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			move = _tmp11_;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 575 "chess-game.c"
		}
		default:
		{
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 581 "chess-game.c"
		}
	}
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = move;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = apply;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "do-move", _tmp12_, _tmp13_, &_tmp14_);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp14_;
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_free0 (move);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 596 "chess-game.c"
}


void chess_player_undo (ChessPlayer* self) {
#line 72 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "do-undo");
#line 605 "chess-game.c"
}


gboolean chess_player_resign (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 77 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "do-resign", &_tmp0_);
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 620 "chess-game.c"
}


gboolean chess_player_claim_draw (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "do-claim-draw", &_tmp0_);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 635 "chess-game.c"
}


gboolean chess_player_get_local_human (ChessPlayer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->_local_human;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 650 "chess-game.c"
}


void chess_player_set_local_human (ChessPlayer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = value;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_local_human = _tmp0_;
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_object_notify ((GObject *) self, "local-human");
#line 664 "chess-game.c"
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (return_value != NULL);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = closure->data;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 686 "chess-game.c"
	} else {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = closure->data;
#line 692 "chess-game.c"
	}
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	callback = (GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_value_set_boolean (return_value, v_return);
#line 700 "chess-game.c"
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (return_value != NULL);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (n_param_values == 1);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = closure->data;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 722 "chess-game.c"
	} else {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = closure->data;
#line 728 "chess-game.c"
	}
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	v_return = callback (data1, data2);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_value_set_boolean (return_value, v_return);
#line 736 "chess-game.c"
}


static void chess_player_class_init (ChessPlayerClass * klass) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_player_parent_class = g_type_class_peek_parent (klass);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_type_class_add_private (klass, sizeof (ChessPlayerPrivate));
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_player_get_property;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_player_set_property;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_player_finalize;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PLAYER_LOCAL_HUMAN, g_param_spec_boolean ("local-human", "local-human", "local-human", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("start_turn", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("do_move", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("do_undo", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("do_resign", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("do_claim_draw", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
#line 763 "chess-game.c"
}


static void chess_player_instance_init (ChessPlayer * self) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv = CHESS_PLAYER_GET_PRIVATE (self);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_local_human = FALSE;
#line 772 "chess-game.c"
}


static void chess_player_finalize (GObject* obj) {
	ChessPlayer * self;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PLAYER, ChessPlayer);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_OBJECT_CLASS (chess_player_parent_class)->finalize (obj);
#line 782 "chess-game.c"
}


GType chess_player_get_type (void) {
	static volatile gsize chess_player_type_id__volatile = 0;
	if (g_once_init_enter (&chess_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPlayer), 0, (GInstanceInitFunc) chess_player_instance_init, NULL };
		GType chess_player_type_id;
		chess_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPlayer", &g_define_type_info, 0);
		g_once_init_leave (&chess_player_type_id__volatile, chess_player_type_id);
	}
	return chess_player_type_id__volatile;
}


static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (property_id) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHESS_PLAYER_LOCAL_HUMAN:
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_value_set_boolean (value, chess_player_get_local_human (self));
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 809 "chess-game.c"
		default:
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 815 "chess-game.c"
	}
}


static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (property_id) {
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHESS_PLAYER_LOCAL_HUMAN:
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_player_set_local_human (self, g_value_get_boolean (value));
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 831 "chess-game.c"
		default:
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 837 "chess-game.c"
	}
}


GType piece_type_get_type (void) {
	static volatile gsize piece_type_type_id__volatile = 0;
	if (g_once_init_enter (&piece_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIECE_TYPE_PAWN, "PIECE_TYPE_PAWN", "pawn"}, {PIECE_TYPE_ROOK, "PIECE_TYPE_ROOK", "rook"}, {PIECE_TYPE_KNIGHT, "PIECE_TYPE_KNIGHT", "knight"}, {PIECE_TYPE_BISHOP, "PIECE_TYPE_BISHOP", "bishop"}, {PIECE_TYPE_QUEEN, "PIECE_TYPE_QUEEN", "queen"}, {PIECE_TYPE_KING, "PIECE_TYPE_KING", "king"}, {0, NULL, NULL}};
		GType piece_type_type_id;
		piece_type_type_id = g_enum_register_static ("PieceType", values);
		g_once_init_leave (&piece_type_type_id__volatile, piece_type_type_id);
	}
	return piece_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 857 "chess-game.c"
}


ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type) {
	ChessPiece* self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	PieceType _tmp2_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, NULL);
#line 144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessPiece*) g_type_create_instance (object_type);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = player;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->player);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->player = _tmp1_;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = type;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->type = _tmp2_;
#line 144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 884 "chess-game.c"
}


ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type) {
#line 144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_piece_construct (TYPE_CHESS_PIECE, player, type);
#line 891 "chess-game.c"
}


Color chess_piece_get_color (ChessPiece* self) {
	Color result;
	ChessPlayer* _tmp0_ = NULL;
	Color _tmp1_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->player;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_->color;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp1_;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 909 "chess-game.c"
}


gunichar chess_piece_get_symbol (ChessPiece* self) {
	gunichar result;
	gunichar c = 0U;
	PieceType _tmp0_ = 0;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	gunichar _tmp5_ = 0U;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	c = (gunichar) ' ';
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->type;
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp0_) {
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_PAWN:
#line 930 "chess-game.c"
		{
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'p';
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 936 "chess-game.c"
		}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_ROOK:
#line 940 "chess-game.c"
		{
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'r';
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 946 "chess-game.c"
		}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_KNIGHT:
#line 950 "chess-game.c"
		{
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'n';
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 956 "chess-game.c"
		}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_BISHOP:
#line 960 "chess-game.c"
		{
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'b';
#line 130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 966 "chess-game.c"
		}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_QUEEN:
#line 970 "chess-game.c"
		{
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'q';
#line 133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 976 "chess-game.c"
		}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_KING:
#line 980 "chess-game.c"
		{
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			c = (gunichar) 'k';
#line 136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 986 "chess-game.c"
		}
		default:
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 991 "chess-game.c"
	}
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->player;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 999 "chess-game.c"
		gunichar _tmp3_ = 0U;
		gunichar _tmp4_ = 0U;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = c;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = g_unichar_toupper (_tmp3_);
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		c = _tmp4_;
#line 1008 "chess-game.c"
	}
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = c;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp5_;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1016 "chess-game.c"
}


static void value_chess_piece_init (GValue* value) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	value->data[0].v_pointer = NULL;
#line 1023 "chess-game.c"
}


static void value_chess_piece_free_value (GValue* value) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (value->data[0].v_pointer) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_piece_unref (value->data[0].v_pointer);
#line 1032 "chess-game.c"
	}
}


static void value_chess_piece_copy_value (const GValue* src_value, GValue* dest_value) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (src_value->data[0].v_pointer) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = chess_piece_ref (src_value->data[0].v_pointer);
#line 1042 "chess-game.c"
	} else {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1046 "chess-game.c"
	}
}


static gpointer value_chess_piece_peek_pointer (const GValue* value) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 1054 "chess-game.c"
}


static gchar* value_chess_piece_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (collect_values[0].v_pointer) {
#line 1061 "chess-game.c"
		ChessPiece* object;
		object = collect_values[0].v_pointer;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1068 "chess-game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1072 "chess-game.c"
		}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = chess_piece_ref (object);
#line 1076 "chess-game.c"
	} else {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 1080 "chess-game.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 1084 "chess-game.c"
}


static gchar* value_chess_piece_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessPiece** object_p;
	object_p = collect_values[0].v_pointer;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!object_p) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1095 "chess-game.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!value->data[0].v_pointer) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = NULL;
#line 1101 "chess-game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = value->data[0].v_pointer;
#line 1105 "chess-game.c"
	} else {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = chess_piece_ref (value->data[0].v_pointer);
#line 1109 "chess-game.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 1113 "chess-game.c"
}


GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessPiece* spec;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_PIECE), NULL);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return G_PARAM_SPEC (spec);
#line 1127 "chess-game.c"
}


gpointer value_get_chess_piece (const GValue* value) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE), NULL);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 1136 "chess-game.c"
}


void value_set_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_piece_ref (value->data[0].v_pointer);
#line 1156 "chess-game.c"
	} else {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 1160 "chess-game.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_piece_unref (old);
#line 1166 "chess-game.c"
	}
}


void value_take_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 1185 "chess-game.c"
	} else {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 1189 "chess-game.c"
	}
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_piece_unref (old);
#line 1195 "chess-game.c"
	}
}


static void chess_piece_class_init (ChessPieceClass * klass) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_piece_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	CHESS_PIECE_CLASS (klass)->finalize = chess_piece_finalize;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("moved", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("promoted", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("died", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1211 "chess-game.c"
}


static void chess_piece_instance_init (ChessPiece * self) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->ref_count = 1;
#line 1218 "chess-game.c"
}


static void chess_piece_finalize (ChessPiece* obj) {
	ChessPiece * self;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PIECE, ChessPiece);
#line 100 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->player);
#line 1228 "chess-game.c"
}


GType chess_piece_get_type (void) {
	static volatile gsize chess_piece_type_id__volatile = 0;
	if (g_once_init_enter (&chess_piece_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_piece_init, value_chess_piece_free_value, value_chess_piece_copy_value, value_chess_piece_peek_pointer, "p", value_chess_piece_collect_value, "p", value_chess_piece_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessPieceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_piece_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPiece), 0, (GInstanceInitFunc) chess_piece_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_piece_type_id;
		chess_piece_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessPiece", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_piece_type_id__volatile, chess_piece_type_id);
	}
	return chess_piece_type_id__volatile;
}


gpointer chess_piece_ref (gpointer instance) {
	ChessPiece* self;
	self = instance;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return instance;
#line 1253 "chess-game.c"
}


void chess_piece_unref (gpointer instance) {
	ChessPiece* self;
	self = instance;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		CHESS_PIECE_GET_CLASS (self)->finalize (self);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1266 "chess-game.c"
	}
}


GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


gchar* chess_move_get_lan (ChessMove* self) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	static const gchar promotion_symbols[] = {' ', 'R', 'N', 'B', 'Q', 'K'};
#line 1291 "chess-game.c"
	ChessPiece* _tmp17_ = NULL;
	CheckState _tmp22_ = 0;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->moved_rook;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ != NULL) {
#line 1303 "chess-game.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = self->f1;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = self->f0;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp1_ > _tmp2_) {
#line 1312 "chess-game.c"
			gchar* _tmp3_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp3_ = g_strdup ("O-O");
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = _tmp3_;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 1320 "chess-game.c"
		} else {
			gchar* _tmp4_ = NULL;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp4_ = g_strdup ("O-O-O");
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = _tmp4_;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 1329 "chess-game.c"
		}
	}
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = g_string_new ("");
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	builder = _tmp5_;
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = self->victim;
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp6_ != NULL) {
#line 1340 "chess-game.c"
		GString* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp7_ = builder;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = self->f0;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = self->r0;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp10_ = self->f1;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp11_ = self->r1;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp7_, "%c%dx%c%d", 'a' + _tmp8_, _tmp9_ + 1, 'a' + _tmp10_, _tmp11_ + 1);
#line 1358 "chess-game.c"
	} else {
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp12_ = builder;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp13_ = self->f0;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = self->r0;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp15_ = self->f1;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp16_ = self->r1;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp12_, "%c%d-%c%d", 'a' + _tmp13_, _tmp14_ + 1, 'a' + _tmp15_, _tmp16_ + 1);
#line 1377 "chess-game.c"
	}
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = self->promotion_piece;
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp17_ != NULL) {
#line 1383 "chess-game.c"
		GString* _tmp18_ = NULL;
		ChessPiece* _tmp19_ = NULL;
		PieceType _tmp20_ = 0;
		gchar _tmp21_ = '\0';
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp18_ = builder;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp19_ = self->promotion_piece;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp20_ = _tmp19_->type;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp21_ = promotion_symbols[_tmp20_];
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp18_, "=%c", (gint) _tmp21_);
#line 1398 "chess-game.c"
	}
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = self->check_state;
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp22_) {
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHECK_STATE_CHECK:
#line 1406 "chess-game.c"
		{
			GString* _tmp23_ = NULL;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp23_ = builder;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			g_string_append_c (_tmp23_, '+');
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 1415 "chess-game.c"
		}
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHECK_STATE_CHECKMATE:
#line 1419 "chess-game.c"
		{
			GString* _tmp24_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp24_ = builder;
#line 199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			g_string_append_c (_tmp24_, '#');
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 1428 "chess-game.c"
		}
		default:
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 1433 "chess-game.c"
	}
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp25_ = builder;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_ = _tmp25_->str;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp27_;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_string_free0 (builder);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1447 "chess-game.c"
}


gchar* chess_move_get_san (ChessMove* self) {
	gchar* result = NULL;
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	static const gchar* piece_names[] = {"", "R", "N", "B", "Q", "K"};
#line 1455 "chess-game.c"
	gchar* _tmp0_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_move_make_san (self, (gchar**) piece_names, (G_N_ELEMENTS (piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1465 "chess-game.c"
}


gchar* chess_move_get_fan (ChessMove* self) {
	gchar* result = NULL;
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	static const gchar* white_piece_names[] = {"", "♜", "♞", "♝", "♛", "♚"};
#line 215 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	static const gchar* black_piece_names[] = {"", "♖", "♘", "♗", "♕", "♔"};
#line 1475 "chess-game.c"
	ChessPiece* _tmp0_ = NULL;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->piece;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_piece_get_color (_tmp0_);
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 1489 "chess-game.c"
		gchar* _tmp3_ = NULL;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = chess_move_make_san (self, (gchar**) white_piece_names, (G_N_ELEMENTS (white_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = _tmp3_;
#line 217 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 1497 "chess-game.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = chess_move_make_san (self, (gchar**) black_piece_names, (G_N_ELEMENTS (black_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = _tmp4_;
#line 219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 1506 "chess-game.c"
	}
}


static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	ChessPiece* _tmp8_ = NULL;
	PieceType _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ChessPiece* _tmp17_ = NULL;
	GString* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	ChessPiece* _tmp22_ = NULL;
	CheckState _tmp28_ = 0;
	GString* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->moved_rook;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ != NULL) {
#line 1539 "chess-game.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 226 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = self->f1;
#line 226 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = self->f0;
#line 226 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp1_ > _tmp2_) {
#line 1548 "chess-game.c"
			gchar* _tmp3_ = NULL;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp3_ = g_strdup ("O-O");
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = _tmp3_;
#line 227 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 1556 "chess-game.c"
		} else {
			gchar* _tmp4_ = NULL;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp4_ = g_strdup ("O-O-O");
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = _tmp4_;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 1565 "chess-game.c"
		}
	}
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = g_string_new ("");
#line 232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	builder = _tmp5_;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = builder;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = piece_names;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7__length1 = piece_names_length1;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = self->piece;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _tmp8_->type;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = _tmp7_[_tmp9_];
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append (_tmp6_, _tmp10_);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = self->ambiguous_file;
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp11_) {
#line 1590 "chess-game.c"
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp12_ = builder;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp13_ = self->f0;
#line 235 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp12_, "%c", 'a' + _tmp13_);
#line 1599 "chess-game.c"
	}
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = self->ambiguous_rank;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp14_) {
#line 1605 "chess-game.c"
		GString* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp15_ = builder;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp16_ = self->r0;
#line 237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp15_, "%d", _tmp16_ + 1);
#line 1614 "chess-game.c"
	}
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = self->victim;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp17_ != NULL) {
#line 1620 "chess-game.c"
		GString* _tmp18_ = NULL;
#line 239 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp18_ = builder;
#line 239 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append (_tmp18_, "x");
#line 1626 "chess-game.c"
	}
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp19_ = builder;
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp20_ = self->f1;
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp21_ = self->r1;
#line 240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_printf (_tmp19_, "%c%d", 'a' + _tmp20_, _tmp21_ + 1);
#line 242 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = self->promotion_piece;
#line 242 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp22_ != NULL) {
#line 1640 "chess-game.c"
		GString* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		ChessPiece* _tmp25_ = NULL;
		PieceType _tmp26_ = 0;
		const gchar* _tmp27_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp23_ = builder;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp24_ = piece_names;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp24__length1 = piece_names_length1;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp25_ = self->promotion_piece;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp26_ = _tmp25_->type;
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp27_ = _tmp24_[_tmp26_];
#line 243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp23_, "=%s", _tmp27_);
#line 1661 "chess-game.c"
	}
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_ = self->check_state;
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp28_) {
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHECK_STATE_CHECK:
#line 1669 "chess-game.c"
		{
			GString* _tmp29_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp29_ = builder;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			g_string_append_c (_tmp29_, '+');
#line 249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 1678 "chess-game.c"
		}
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case CHECK_STATE_CHECKMATE:
#line 1682 "chess-game.c"
		{
			GString* _tmp30_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp30_ = builder;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			g_string_append_c (_tmp30_, '#');
#line 252 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 1691 "chess-game.c"
		}
		default:
#line 245 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		break;
#line 1696 "chess-game.c"
	}
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp31_ = builder;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp32_ = _tmp31_->str;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp33_ = g_strdup (_tmp32_);
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp33_;
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_string_free0 (builder);
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1710 "chess-game.c"
}


gchar* chess_move_get_engine (ChessMove* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	static const gchar promotion_symbols[] = {' ', 'r', 'n', 'b', 'q', ' '};
#line 1720 "chess-game.c"
	ChessPiece* _tmp1_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 259 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 261 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = g_string_new ("");
#line 261 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	builder = _tmp0_;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->promotion_piece;
#line 263 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp1_ != NULL) {
#line 1735 "chess-game.c"
		GString* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		ChessPiece* _tmp7_ = NULL;
		PieceType _tmp8_ = 0;
		gchar _tmp9_ = '\0';
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = builder;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = self->f0;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->r0;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = self->f1;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = self->r1;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp7_ = self->promotion_piece;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = _tmp7_->type;
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = promotion_symbols[_tmp8_];
#line 264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp2_, "%c%d%c%d%c", 'a' + _tmp3_, _tmp4_ + 1, 'a' + _tmp5_, _tmp6_ + 1, (gint) _tmp9_);
#line 1762 "chess-game.c"
	} else {
		GString* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp10_ = builder;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp11_ = self->f0;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp12_ = self->r0;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp13_ = self->f1;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = self->r1;
#line 266 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp10_, "%c%d%c%d", 'a' + _tmp11_, _tmp12_ + 1, 'a' + _tmp13_, _tmp14_ + 1);
#line 1781 "chess-game.c"
	}
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = builder;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp16_ = _tmp15_->str;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp17_;
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_string_free0 (builder);
#line 267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1795 "chess-game.c"
}


static gpointer _chess_piece_ref0 (gpointer self) {
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self ? chess_piece_ref (self) : NULL;
#line 1802 "chess-game.c"
}


ChessMove* chess_move_copy (ChessMove* self) {
	ChessMove* result = NULL;
	ChessMove* move = NULL;
	ChessMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ChessPiece* _tmp2_ = NULL;
	ChessPiece* _tmp3_ = NULL;
	ChessPiece* _tmp4_ = NULL;
	ChessPiece* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
	ChessPiece* _tmp7_ = NULL;
	ChessPiece* _tmp8_ = NULL;
	ChessPiece* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	CheckState _tmp16_ = 0;
#line 270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_move_new ();
#line 272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move = _tmp0_;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->number;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->number = _tmp1_;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = self->piece;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = _chess_piece_ref0 (_tmp2_);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (move->piece);
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->piece = _tmp3_;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = self->promotion_piece;
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _chess_piece_ref0 (_tmp4_);
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (move->promotion_piece);
#line 275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->promotion_piece = _tmp5_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = self->moved_rook;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = _chess_piece_ref0 (_tmp6_);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (move->moved_rook);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->moved_rook = _tmp7_;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = self->victim;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _chess_piece_ref0 (_tmp8_);
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (move->victim);
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->victim = _tmp9_;
#line 278 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = self->r0;
#line 278 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->r0 = _tmp10_;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = self->f0;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->f0 = _tmp11_;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = self->r1;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->r1 = _tmp12_;
#line 281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = self->f1;
#line 281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->f1 = _tmp13_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = self->ambiguous_rank;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->ambiguous_rank = _tmp14_;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = self->ambiguous_file;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->ambiguous_file = _tmp15_;
#line 284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp16_ = self->check_state;
#line 284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move->check_state = _tmp16_;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = move;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 1900 "chess-game.c"
}


ChessMove* chess_move_construct (GType object_type) {
	ChessMove* self = NULL;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessMove*) g_type_create_instance (object_type);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 1910 "chess-game.c"
}


ChessMove* chess_move_new (void) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_move_construct (TYPE_CHESS_MOVE);
#line 1917 "chess-game.c"
}


static void value_chess_move_init (GValue* value) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	value->data[0].v_pointer = NULL;
#line 1924 "chess-game.c"
}


static void value_chess_move_free_value (GValue* value) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (value->data[0].v_pointer) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_move_unref (value->data[0].v_pointer);
#line 1933 "chess-game.c"
	}
}


static void value_chess_move_copy_value (const GValue* src_value, GValue* dest_value) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (src_value->data[0].v_pointer) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = chess_move_ref (src_value->data[0].v_pointer);
#line 1943 "chess-game.c"
	} else {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1947 "chess-game.c"
	}
}


static gpointer value_chess_move_peek_pointer (const GValue* value) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 1955 "chess-game.c"
}


static gchar* value_chess_move_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (collect_values[0].v_pointer) {
#line 1962 "chess-game.c"
		ChessMove* object;
		object = collect_values[0].v_pointer;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1969 "chess-game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1973 "chess-game.c"
		}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = chess_move_ref (object);
#line 1977 "chess-game.c"
	} else {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 1981 "chess-game.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 1985 "chess-game.c"
}


static gchar* value_chess_move_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessMove** object_p;
	object_p = collect_values[0].v_pointer;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!object_p) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1996 "chess-game.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!value->data[0].v_pointer) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = NULL;
#line 2002 "chess-game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = value->data[0].v_pointer;
#line 2006 "chess-game.c"
	} else {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = chess_move_ref (value->data[0].v_pointer);
#line 2010 "chess-game.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 2014 "chess-game.c"
}


GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessMove* spec;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MOVE), NULL);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return G_PARAM_SPEC (spec);
#line 2028 "chess-game.c"
}


gpointer value_get_chess_move (const GValue* value) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE), NULL);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 2037 "chess-game.c"
}


void value_set_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_move_ref (value->data[0].v_pointer);
#line 2057 "chess-game.c"
	} else {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 2061 "chess-game.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_move_unref (old);
#line 2067 "chess-game.c"
	}
}


void value_take_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 2086 "chess-game.c"
	} else {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 2090 "chess-game.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_move_unref (old);
#line 2096 "chess-game.c"
	}
}


static void chess_move_class_init (ChessMoveClass * klass) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_move_parent_class = g_type_class_peek_parent (klass);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	CHESS_MOVE_CLASS (klass)->finalize = chess_move_finalize;
#line 2106 "chess-game.c"
}


static void chess_move_instance_init (ChessMove * self) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->ref_count = 1;
#line 2113 "chess-game.c"
}


static void chess_move_finalize (ChessMove* obj) {
	ChessMove * self;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MOVE, ChessMove);
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (self->piece);
#line 162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (self->promotion_piece);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (self->moved_rook);
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (self->victim);
#line 2129 "chess-game.c"
}


GType chess_move_get_type (void) {
	static volatile gsize chess_move_type_id__volatile = 0;
	if (g_once_init_enter (&chess_move_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_move_init, value_chess_move_free_value, value_chess_move_copy_value, value_chess_move_peek_pointer, "p", value_chess_move_collect_value, "p", value_chess_move_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessMove), 0, (GInstanceInitFunc) chess_move_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_move_type_id;
		chess_move_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessMove", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_move_type_id__volatile, chess_move_type_id);
	}
	return chess_move_type_id__volatile;
}


gpointer chess_move_ref (gpointer instance) {
	ChessMove* self;
	self = instance;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return instance;
#line 2154 "chess-game.c"
}


void chess_move_unref (gpointer instance) {
	ChessMove* self;
	self = instance;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		CHESS_MOVE_GET_CLASS (self)->finalize (self);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2167 "chess-game.c"
	}
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState* self = NULL;
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessState*) g_type_create_instance (object_type);
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 2178 "chess-game.c"
}


static ChessState* chess_state_new_empty (void) {
#line 310 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_state_construct_empty (TYPE_CHESS_STATE);
#line 2185 "chess-game.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/home/mcatanzaro/jhbuild/install/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 2203 "chess-game.c"
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState* self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** ranks = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint ranks_length1 = 0;
	gint _ranks_size_ = 0;
	gchar** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	const gchar* _tmp70_ = NULL;
	gchar** _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
	const gchar* _tmp78_ = NULL;
	gchar** _tmp99_ = NULL;
	gint _tmp99__length1 = 0;
	const gchar* _tmp100_ = NULL;
	gchar** _tmp108_ = NULL;
	gint _tmp108__length1 = 0;
	const gchar* _tmp109_ = NULL;
	gint _tmp110_ = 0;
	gchar** _tmp111_ = NULL;
	gint _tmp111__length1 = 0;
	const gchar* _tmp112_ = NULL;
	gint _tmp113_ = 0;
	ChessPlayer* _tmp114_ = NULL;
	Color _tmp115_ = 0;
	ChessPlayer* _tmp117_ = NULL;
	CheckState _tmp118_ = 0;
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessState*) g_type_create_instance (object_type);
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_player_new (COLOR_WHITE);
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->players[COLOR_WHITE]);
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->players[COLOR_WHITE] = _tmp0_;
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->players[COLOR_WHITE];
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = chess_player_new (COLOR_BLACK);
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->players[COLOR_BLACK]);
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->players[COLOR_BLACK] = _tmp2_;
#line 317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = self->players[COLOR_BLACK];
#line 2268 "chess-game.c"
	{
		gint i = 0;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = 0;
#line 2273 "chess-game.c"
		{
			gboolean _tmp4_ = FALSE;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp4_ = TRUE;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 2280 "chess-game.c"
				gboolean _tmp5_ = FALSE;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				ChessPiece* _tmp9_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp5_ = _tmp4_;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp5_) {
#line 2289 "chess-game.c"
					gint _tmp6_ = 0;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp6_ = i;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					i = _tmp6_ + 1;
#line 2295 "chess-game.c"
				}
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = FALSE;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp7_ = i;
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp7_ < 64)) {
#line 318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 2305 "chess-game.c"
				}
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp8_ = i;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (self->board[_tmp8_]);
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				self->board[_tmp8_] = NULL;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp9_ = self->board[_tmp8_];
#line 2315 "chess-game.c"
			}
		}
	}
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = fen;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	fields = _tmp12_;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	fields_length1 = _vala_array_length (_tmp11_);
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_fields_size_ = fields_length1;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = fields;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13__length1 = fields_length1;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = _tmp13_[0];
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	ranks = _tmp16_;
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	ranks_length1 = _vala_array_length (_tmp15_);
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_ranks_size_ = ranks_length1;
#line 2343 "chess-game.c"
	{
		gint rank = 0;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		rank = 0;
#line 2348 "chess-game.c"
		{
			gboolean _tmp17_ = FALSE;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp17_ = TRUE;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 2355 "chess-game.c"
				gboolean _tmp18_ = FALSE;
				gint _tmp20_ = 0;
				gchar* rank_string = NULL;
				gchar** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp18_ = _tmp17_;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp18_) {
#line 2368 "chess-game.c"
					gint _tmp19_ = 0;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp19_ = rank;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					rank = _tmp19_ + 1;
#line 2374 "chess-game.c"
				}
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp17_ = FALSE;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp20_ = rank;
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp20_ < 8)) {
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 2384 "chess-game.c"
				}
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp21_ = ranks;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp21__length1 = ranks_length1;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp22_ = rank;
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp23_ = _tmp21_[7 - _tmp22_];
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp24_ = g_strdup (_tmp23_);
#line 331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				rank_string = _tmp24_;
#line 2398 "chess-game.c"
				{
					gint file = 0;
					gint offset = 0;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					file = 0;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					offset = 0;
#line 2406 "chess-game.c"
					{
						gboolean _tmp25_ = FALSE;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp25_ = TRUE;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						while (TRUE) {
#line 2413 "chess-game.c"
							gboolean _tmp26_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gint _tmp29_ = 0;
							gboolean _tmp34_ = FALSE;
							gchar c = '\0';
							const gchar* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							gchar _tmp37_ = '\0';
							gboolean _tmp38_ = FALSE;
							gchar _tmp39_ = '\0';
							gboolean _tmp41_ = FALSE;
							PieceType type = 0;
							Color _tmp44_ = 0;
							gchar _tmp45_ = '\0';
							gboolean _tmp46_ = FALSE;
							Color color = 0;
							Color _tmp47_ = 0;
							gchar _tmp48_ = '\0';
							gchar _tmp49_ = '\0';
							PieceType _tmp50_ = 0;
							gboolean _tmp51_ = FALSE;
							gint index = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							ChessPiece* piece = NULL;
							Color _tmp55_ = 0;
							ChessPlayer* _tmp56_ = NULL;
							PieceType _tmp57_ = 0;
							ChessPiece* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							ChessPiece* _tmp60_ = NULL;
							ChessPiece* _tmp61_ = NULL;
							ChessPiece* _tmp62_ = NULL;
							gint64 mask = 0LL;
							gint _tmp63_ = 0;
							gint64 _tmp64_ = 0LL;
							Color _tmp65_ = 0;
							gint64 _tmp66_ = 0LL;
							gint64 _tmp67_ = 0LL;
							gint _tmp68_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp26_ = _tmp25_;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!_tmp26_) {
#line 2459 "chess-game.c"
								gint _tmp27_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp27_ = offset;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								offset = _tmp27_ + 1;
#line 2465 "chess-game.c"
							}
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp25_ = FALSE;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp29_ = file;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp29_ < 8) {
#line 2473 "chess-game.c"
								gint _tmp30_ = 0;
								const gchar* _tmp31_ = NULL;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp30_ = offset;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp31_ = rank_string;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp32_ = strlen (_tmp31_);
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp33_ = _tmp32_;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp28_ = _tmp30_ < _tmp33_;
#line 2488 "chess-game.c"
							} else {
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp28_ = FALSE;
#line 2492 "chess-game.c"
							}
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp34_ = _tmp28_;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!_tmp34_) {
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								break;
#line 2500 "chess-game.c"
							}
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp35_ = rank_string;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp36_ = offset;
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							c = _tmp37_;
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp39_ = c;
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp39_ >= '1') {
#line 2514 "chess-game.c"
								gchar _tmp40_ = '\0';
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp40_ = c;
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp38_ = _tmp40_ <= '8';
#line 2520 "chess-game.c"
							} else {
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp38_ = FALSE;
#line 2524 "chess-game.c"
							}
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp41_ = _tmp38_;
#line 335 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp41_) {
#line 2530 "chess-game.c"
								gint _tmp42_ = 0;
								gchar _tmp43_ = '\0';
#line 337 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp42_ = file;
#line 337 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp43_ = c;
#line 337 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								file = _tmp42_ + (_tmp43_ - '0');
#line 338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								continue;
#line 2541 "chess-game.c"
							}
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp45_ = c;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp46_ = g_ascii_isupper (_tmp45_);
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp46_) {
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp44_ = COLOR_WHITE;
#line 2551 "chess-game.c"
							} else {
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp44_ = COLOR_BLACK;
#line 2555 "chess-game.c"
							}
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp47_ = _tmp44_;
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							color = _tmp47_;
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp48_ = c;
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp49_ = g_ascii_toupper (_tmp48_);
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp51_ = chess_state_decode_piece_type (self, (gunichar) _tmp49_, &_tmp50_);
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							type = _tmp50_;
#line 343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!_tmp51_) {
#line 2571 "chess-game.c"
							}
#line 346 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp52_ = rank;
#line 346 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp53_ = file;
#line 346 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp54_ = chess_state_get_index (self, _tmp52_, _tmp53_);
#line 346 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							index = _tmp54_;
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp55_ = color;
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp56_ = self->players[_tmp55_];
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp57_ = type;
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp58_ = chess_piece_new (_tmp56_, _tmp57_);
#line 347 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							piece = _tmp58_;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp59_ = index;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp60_ = piece;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp61_ = _chess_piece_ref0 (_tmp60_);
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_chess_piece_unref0 (self->board[_tmp59_]);
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							self->board[_tmp59_] = _tmp61_;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp62_ = self->board[_tmp59_];
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp63_ = index;
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp64_ = BIT_BOARD_set_location_masks[_tmp63_];
#line 349 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							mask = _tmp64_;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp65_ = color;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp66_ = mask;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							self->priv->piece_masks[_tmp65_] |= _tmp66_;
#line 350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp67_ = self->priv->piece_masks[_tmp65_];
#line 351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp68_ = file;
#line 351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							file = _tmp68_ + 1;
#line 332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_chess_piece_unref0 (piece);
#line 2623 "chess-game.c"
						}
					}
				}
#line 329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_g_free0 (rank_string);
#line 2629 "chess-game.c"
			}
		}
	}
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp69_ = fields;
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp69__length1 = fields_length1;
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp70_ = _tmp69_[1];
#line 356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_strcmp0 (_tmp70_, "w") == 0) {
#line 2641 "chess-game.c"
		ChessPlayer* _tmp71_ = NULL;
		ChessPlayer* _tmp72_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp71_ = self->players[COLOR_WHITE];
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp72_ = _g_object_ref0 (_tmp71_);
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_g_object_unref0 (self->current_player);
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->current_player = _tmp72_;
#line 2652 "chess-game.c"
	} else {
		gchar** _tmp73_ = NULL;
		gint _tmp73__length1 = 0;
		const gchar* _tmp74_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp73_ = fields;
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp73__length1 = fields_length1;
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp74_ = _tmp73_[1];
#line 358 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (g_strcmp0 (_tmp74_, "b") == 0) {
#line 2665 "chess-game.c"
			ChessPlayer* _tmp75_ = NULL;
			ChessPlayer* _tmp76_ = NULL;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp75_ = self->players[COLOR_BLACK];
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp76_ = _g_object_ref0 (_tmp75_);
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_g_object_unref0 (self->current_player);
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			self->current_player = _tmp76_;
#line 2676 "chess-game.c"
		}
	}
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp77_ = fields;
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp77__length1 = fields_length1;
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp78_ = _tmp77_[2];
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_strcmp0 (_tmp78_, "-") != 0) {
#line 2687 "chess-game.c"
		{
			gint i = 0;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			i = 0;
#line 2692 "chess-game.c"
			{
				gboolean _tmp79_ = FALSE;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp79_ = TRUE;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				while (TRUE) {
#line 2699 "chess-game.c"
					gboolean _tmp80_ = FALSE;
					gint _tmp82_ = 0;
					gchar** _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					const gchar* _tmp84_ = NULL;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					gchar c = '\0';
					gchar** _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					const gchar* _tmp88_ = NULL;
					gint _tmp89_ = 0;
					gchar _tmp90_ = '\0';
					gchar _tmp91_ = '\0';
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp80_ = _tmp79_;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp80_) {
#line 2718 "chess-game.c"
						gint _tmp81_ = 0;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp81_ = i;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						i = _tmp81_ + 1;
#line 2724 "chess-game.c"
					}
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp79_ = FALSE;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp82_ = i;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp83_ = fields;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp83__length1 = fields_length1;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp84_ = _tmp83_[2];
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp85_ = strlen (_tmp84_);
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp86_ = _tmp85_;
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!(_tmp82_ < _tmp86_)) {
#line 366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						break;
#line 2744 "chess-game.c"
					}
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp87_ = fields;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp87__length1 = fields_length1;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp88_ = _tmp87_[2];
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp89_ = i;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp90_ = string_get (_tmp88_, (glong) _tmp89_);
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					c = _tmp90_;
#line 369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp91_ = c;
#line 369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp91_ == 'K') {
#line 2762 "chess-game.c"
						gboolean _tmp92_ = FALSE;
#line 370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
#line 370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp92_ = self->can_castle_kingside[COLOR_WHITE];
#line 2768 "chess-game.c"
					} else {
						gchar _tmp93_ = '\0';
#line 371 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp93_ = c;
#line 371 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp93_ == 'Q') {
#line 2775 "chess-game.c"
							gboolean _tmp94_ = FALSE;
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp94_ = self->can_castle_queenside[COLOR_WHITE];
#line 2781 "chess-game.c"
						} else {
							gchar _tmp95_ = '\0';
#line 373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp95_ = c;
#line 373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp95_ == 'k') {
#line 2788 "chess-game.c"
								gboolean _tmp96_ = FALSE;
#line 374 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
#line 374 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp96_ = self->can_castle_kingside[COLOR_BLACK];
#line 2794 "chess-game.c"
							} else {
								gchar _tmp97_ = '\0';
#line 375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp97_ = c;
#line 375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (_tmp97_ == 'q') {
#line 2801 "chess-game.c"
									gboolean _tmp98_ = FALSE;
#line 376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
#line 376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp98_ = self->can_castle_queenside[COLOR_BLACK];
#line 2807 "chess-game.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp99_ = fields;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp99__length1 = fields_length1;
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp100_ = _tmp99_[3];
#line 383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_strcmp0 (_tmp100_, "-") != 0) {
#line 2824 "chess-game.c"
		gchar** _tmp101_ = NULL;
		gint _tmp101__length1 = 0;
		const gchar* _tmp102_ = NULL;
		gchar _tmp103_ = '\0';
		gchar** _tmp104_ = NULL;
		gint _tmp104__length1 = 0;
		const gchar* _tmp105_ = NULL;
		gchar _tmp106_ = '\0';
		gint _tmp107_ = 0;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp101_ = fields;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp101__length1 = fields_length1;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp102_ = _tmp101_[3];
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp103_ = string_get (_tmp102_, (glong) 1);
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp104_ = fields;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp104__length1 = fields_length1;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp105_ = _tmp104_[3];
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp106_ = string_get (_tmp105_, (glong) 0);
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp107_ = chess_state_get_index (self, (gint) (_tmp103_ - '1'), (gint) (_tmp106_ - 'a'));
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->en_passant_index = _tmp107_;
#line 2854 "chess-game.c"
	}
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp108_ = fields;
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp108__length1 = fields_length1;
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp109_ = _tmp108_[4];
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp110_ = atoi (_tmp109_);
#line 391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->halfmove_clock = _tmp110_;
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp111_ = fields;
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp111__length1 = fields_length1;
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp112_ = _tmp111_[5];
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp113_ = atoi (_tmp112_);
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->number = (_tmp113_ - 1) * 2;
#line 395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp114_ = self->current_player;
#line 395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp115_ = _tmp114_->color;
#line 395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp115_ == COLOR_BLACK) {
#line 2882 "chess-game.c"
		gint _tmp116_ = 0;
#line 396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp116_ = self->number;
#line 396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->number = _tmp116_ + 1;
#line 2888 "chess-game.c"
	}
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp117_ = self->current_player;
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp118_ = chess_state_get_check_state (self, _tmp117_);
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->check_state = _tmp118_;
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 2902 "chess-game.c"
}


ChessState* chess_state_new (const gchar* fen) {
#line 314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_state_construct (TYPE_CHESS_STATE, fen);
#line 2909 "chess-game.c"
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* state = NULL;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	ChessPlayer* _tmp4_ = NULL;
	ChessPlayer* _tmp5_ = NULL;
	ChessPlayer* _tmp6_ = NULL;
	ChessState* _tmp7_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessState* _tmp11_ = NULL;
	ChessPlayer* _tmp12_ = NULL;
	ChessPlayer* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ChessState* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	ChessState* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	ChessState* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	ChessState* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	ChessState* _tmp28_ = NULL;
	CheckState _tmp29_ = 0;
	ChessMove* _tmp30_ = NULL;
	ChessState* _tmp44_ = NULL;
	gint64 _tmp45_ = 0LL;
	gint64 _tmp46_ = 0LL;
	ChessState* _tmp47_ = NULL;
	gint64 _tmp48_ = 0LL;
	gint64 _tmp49_ = 0LL;
	ChessState* _tmp50_ = NULL;
	gint _tmp51_ = 0;
#line 401 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 403 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_state_new_empty ();
#line 403 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	state = _tmp0_;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = state;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = self->number;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_->number = _tmp2_;
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = state;
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = self->players[COLOR_WHITE];
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
#line 406 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = state;
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = self->players[COLOR_BLACK];
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
#line 407 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = state;
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = self->current_player;
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (_tmp11_->current_player);
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_->current_player = _tmp13_;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = state;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = state;
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
#line 410 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp20_ = state;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_ = state;
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
#line 412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
#line 413 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_ = state;
#line 413 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = self->en_passant_index;
#line 413 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_->en_passant_index = _tmp27_;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_ = state;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp29_ = self->check_state;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_->check_state = _tmp29_;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp30_ = self->last_move;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp30_ != NULL) {
#line 3049 "chess-game.c"
		ChessState* _tmp31_ = NULL;
		ChessMove* _tmp32_ = NULL;
		ChessMove* _tmp33_ = NULL;
#line 416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp31_ = state;
#line 416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp32_ = self->last_move;
#line 416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp33_ = chess_move_copy (_tmp32_);
#line 416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_move_unref0 (_tmp31_->last_move);
#line 416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp31_->last_move = _tmp33_;
#line 3063 "chess-game.c"
	}
	{
		gint i = 0;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = 0;
#line 3069 "chess-game.c"
		{
			gboolean _tmp34_ = FALSE;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp34_ = TRUE;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 3076 "chess-game.c"
				gboolean _tmp35_ = FALSE;
				gint _tmp37_ = 0;
				ChessState* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				ChessPiece* _tmp41_ = NULL;
				ChessPiece* _tmp42_ = NULL;
				ChessPiece* _tmp43_ = NULL;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp35_ = _tmp34_;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp35_) {
#line 3089 "chess-game.c"
					gint _tmp36_ = 0;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp36_ = i;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					i = _tmp36_ + 1;
#line 3095 "chess-game.c"
				}
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp34_ = FALSE;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp37_ = i;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp37_ < 64)) {
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 3105 "chess-game.c"
				}
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp38_ = state;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp39_ = i;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp40_ = i;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp41_ = self->board[_tmp40_];
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp42_ = _chess_piece_ref0 (_tmp41_);
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (_tmp38_->board[_tmp39_]);
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp38_->board[_tmp39_] = _tmp42_;
#line 418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp43_ = _tmp38_->board[_tmp39_];
#line 3123 "chess-game.c"
			}
		}
	}
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp44_ = state;
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp45_ = self->priv->piece_masks[COLOR_WHITE];
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp44_->priv->piece_masks[COLOR_WHITE] = _tmp45_;
#line 419 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp46_ = _tmp44_->priv->piece_masks[COLOR_WHITE];
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp47_ = state;
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp48_ = self->priv->piece_masks[COLOR_BLACK];
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp47_->priv->piece_masks[COLOR_BLACK] = _tmp48_;
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp49_ = _tmp47_->priv->piece_masks[COLOR_BLACK];
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp50_ = state;
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp51_ = self->halfmove_clock;
#line 421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp50_->halfmove_clock = _tmp51_;
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = state;
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3153 "chess-game.c"
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp7_ = 0LL;
	ChessState* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp39_ = FALSE;
#line 426 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 426 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (state != NULL, FALSE);
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = self->priv->piece_masks[COLOR_WHITE];
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = state;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _tmp8_->priv->piece_masks[COLOR_WHITE];
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp7_ != _tmp9_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = TRUE;
#line 3190 "chess-game.c"
	} else {
		gint64 _tmp10_ = 0LL;
		ChessState* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp10_ = self->priv->piece_masks[COLOR_BLACK];
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp11_ = state;
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp12_ = _tmp11_->priv->piece_masks[COLOR_BLACK];
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = _tmp10_ != _tmp12_;
#line 3203 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = _tmp6_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp13_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = TRUE;
#line 3211 "chess-game.c"
	} else {
		ChessPlayer* _tmp14_ = NULL;
		Color _tmp15_ = 0;
		ChessState* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		Color _tmp18_ = 0;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = self->current_player;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp15_ = _tmp14_->color;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp16_ = state;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp17_ = _tmp16_->current_player;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp18_ = _tmp17_->color;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = _tmp15_ != _tmp18_;
#line 3230 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp19_ = _tmp5_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp19_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = TRUE;
#line 3238 "chess-game.c"
	} else {
		gboolean _tmp20_ = FALSE;
		ChessState* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp20_ = self->can_castle_kingside[COLOR_WHITE];
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp21_ = state;
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp22_ = _tmp21_->can_castle_kingside[COLOR_WHITE];
#line 439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = _tmp20_ != _tmp22_;
#line 3251 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_ = _tmp4_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp23_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = TRUE;
#line 3259 "chess-game.c"
	} else {
		gboolean _tmp24_ = FALSE;
		ChessState* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
#line 440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp24_ = self->can_castle_queenside[COLOR_WHITE];
#line 440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp25_ = state;
#line 440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp26_ = _tmp25_->can_castle_queenside[COLOR_WHITE];
#line 440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = _tmp24_ != _tmp26_;
#line 3272 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = _tmp3_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp27_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = TRUE;
#line 3280 "chess-game.c"
	} else {
		gboolean _tmp28_ = FALSE;
		ChessState* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
#line 441 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp28_ = self->can_castle_kingside[COLOR_BLACK];
#line 441 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp29_ = state;
#line 441 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp30_ = _tmp29_->can_castle_kingside[COLOR_BLACK];
#line 441 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = _tmp28_ != _tmp30_;
#line 3293 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp31_ = _tmp2_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp31_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = TRUE;
#line 3301 "chess-game.c"
	} else {
		gboolean _tmp32_ = FALSE;
		ChessState* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp32_ = self->can_castle_queenside[COLOR_BLACK];
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp33_ = state;
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp34_ = _tmp33_->can_castle_queenside[COLOR_BLACK];
#line 442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = _tmp32_ != _tmp34_;
#line 3314 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp35_ = _tmp1_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp35_) {
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = TRUE;
#line 3322 "chess-game.c"
	} else {
		gint _tmp36_ = 0;
		ChessState* _tmp37_ = NULL;
		gint _tmp38_ = 0;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp36_ = self->en_passant_index;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp37_ = state;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp38_ = _tmp37_->en_passant_index;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp36_ != _tmp38_;
#line 3335 "chess-game.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp39_ = _tmp0_;
#line 436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp39_) {
#line 444 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 444 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 3345 "chess-game.c"
	}
	{
		gint i = 0;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = 0;
#line 3351 "chess-game.c"
		{
			gboolean _tmp40_ = FALSE;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp40_ = TRUE;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 3358 "chess-game.c"
				gboolean _tmp41_ = FALSE;
				gint _tmp43_ = 0;
				gboolean _tmp44_ = FALSE;
				gint _tmp45_ = 0;
				ChessPiece* _tmp46_ = NULL;
				gboolean _tmp54_ = FALSE;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp41_ = _tmp40_;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp41_) {
#line 3369 "chess-game.c"
					gint _tmp42_ = 0;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp42_ = i;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					i = _tmp42_ + 1;
#line 3375 "chess-game.c"
				}
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp40_ = FALSE;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp43_ = i;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp43_ < 64)) {
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 3385 "chess-game.c"
				}
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp45_ = i;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp46_ = self->board[_tmp45_];
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp46_ != NULL) {
#line 3393 "chess-game.c"
					gint _tmp47_ = 0;
					ChessPiece* _tmp48_ = NULL;
					PieceType _tmp49_ = 0;
					ChessState* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					ChessPiece* _tmp52_ = NULL;
					PieceType _tmp53_ = 0;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp47_ = i;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp48_ = self->board[_tmp47_];
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp49_ = _tmp48_->type;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp50_ = state;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp51_ = i;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp52_ = _tmp50_->board[_tmp51_];
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp53_ = _tmp52_->type;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp44_ = _tmp49_ != _tmp53_;
#line 3417 "chess-game.c"
				} else {
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp44_ = FALSE;
#line 3421 "chess-game.c"
				}
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp54_ = _tmp44_;
#line 449 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp54_) {
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 3431 "chess-game.c"
				}
			}
		}
	}
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3440 "chess-game.c"
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* value = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp28_ = NULL;
	ChessPlayer* _tmp29_ = NULL;
	Color _tmp30_ = 0;
	GString* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GString* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GString* _tmp55_ = NULL;
	GString* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	GString* _tmp58_ = NULL;
	ChessPlayer* _tmp59_ = NULL;
	Color _tmp60_ = 0;
	GString* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = g_string_new ("");
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	value = _tmp0_;
#line 3477 "chess-game.c"
	{
		gint rank = 0;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		rank = 7;
#line 3482 "chess-game.c"
		{
			gboolean _tmp1_ = FALSE;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp1_ = TRUE;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 3489 "chess-game.c"
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				gint skip_count = 0;
				gint _tmp23_ = 0;
				gint _tmp26_ = 0;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp2_ = _tmp1_;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp2_) {
#line 3499 "chess-game.c"
					gint _tmp3_ = 0;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp3_ = rank;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					rank = _tmp3_ - 1;
#line 3505 "chess-game.c"
				}
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp1_ = FALSE;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = rank;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp4_ >= 0)) {
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 3515 "chess-game.c"
				}
#line 462 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				skip_count = 0;
#line 3519 "chess-game.c"
				{
					gint file = 0;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					file = 0;
#line 3524 "chess-game.c"
					{
						gboolean _tmp5_ = FALSE;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp5_ = TRUE;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						while (TRUE) {
#line 3531 "chess-game.c"
							gboolean _tmp6_ = FALSE;
							gint _tmp8_ = 0;
							ChessPiece* p = NULL;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							ChessPiece* _tmp12_ = NULL;
							ChessPiece* _tmp13_ = NULL;
							ChessPiece* _tmp14_ = NULL;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp6_ = _tmp5_;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!_tmp6_) {
#line 3545 "chess-game.c"
								gint _tmp7_ = 0;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp7_ = file;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								file = _tmp7_ + 1;
#line 3551 "chess-game.c"
							}
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp5_ = FALSE;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp8_ = file;
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!(_tmp8_ < 8)) {
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								break;
#line 3561 "chess-game.c"
							}
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp9_ = rank;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp10_ = file;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp11_ = chess_state_get_index (self, _tmp9_, _tmp10_);
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp12_ = self->board[_tmp11_];
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp13_ = _chess_piece_ref0 (_tmp12_);
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							p = _tmp13_;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp14_ = p;
#line 466 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp14_ == NULL) {
#line 3579 "chess-game.c"
								gint _tmp15_ = 0;
#line 467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp15_ = skip_count;
#line 467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								skip_count = _tmp15_ + 1;
#line 3585 "chess-game.c"
							} else {
								gint _tmp16_ = 0;
								GString* _tmp19_ = NULL;
								ChessPiece* _tmp20_ = NULL;
								gunichar _tmp21_ = 0U;
								gunichar _tmp22_ = 0U;
#line 470 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp16_ = skip_count;
#line 470 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (_tmp16_ > 0) {
#line 3596 "chess-game.c"
									GString* _tmp17_ = NULL;
									gint _tmp18_ = 0;
#line 472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp17_ = value;
#line 472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp18_ = skip_count;
#line 472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									g_string_append_printf (_tmp17_, "%d", _tmp18_);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									skip_count = 0;
#line 3607 "chess-game.c"
								}
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp19_ = value;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp20_ = p;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp21_ = chess_piece_get_symbol (_tmp20_);
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp22_ = _tmp21_;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								g_string_append_printf (_tmp19_, "%c", (gint) _tmp22_);
#line 3619 "chess-game.c"
							}
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_chess_piece_unref0 (p);
#line 3623 "chess-game.c"
						}
					}
				}
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp23_ = skip_count;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp23_ > 0) {
#line 3631 "chess-game.c"
					GString* _tmp24_ = NULL;
					gint _tmp25_ = 0;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp24_ = value;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp25_ = skip_count;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					g_string_append_printf (_tmp24_, "%d", _tmp25_);
#line 3640 "chess-game.c"
				}
#line 480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp26_ = rank;
#line 480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp26_ != 0) {
#line 3646 "chess-game.c"
					GString* _tmp27_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp27_ = value;
#line 481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					g_string_append_c (_tmp27_, '/');
#line 3652 "chess-game.c"
				}
			}
		}
	}
#line 484 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_ = value;
#line 484 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_c (_tmp28_, ' ');
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp29_ = self->current_player;
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp30_ = _tmp29_->color;
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp30_ == COLOR_WHITE) {
#line 3667 "chess-game.c"
		GString* _tmp31_ = NULL;
#line 486 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp31_ = value;
#line 486 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp31_, 'w');
#line 3673 "chess-game.c"
	} else {
		GString* _tmp32_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp32_ = value;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp32_, 'b');
#line 3680 "chess-game.c"
	}
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp33_ = value;
#line 490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_c (_tmp33_, ' ');
#line 491 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp34_ = self->can_castle_kingside[COLOR_WHITE];
#line 491 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp34_) {
#line 3690 "chess-game.c"
		GString* _tmp35_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp35_ = value;
#line 492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp35_, 'K');
#line 3696 "chess-game.c"
	}
#line 493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp36_ = self->can_castle_queenside[COLOR_WHITE];
#line 493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp36_) {
#line 3702 "chess-game.c"
		GString* _tmp37_ = NULL;
#line 494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp37_ = value;
#line 494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp37_, 'Q');
#line 3708 "chess-game.c"
	}
#line 495 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp38_ = self->can_castle_kingside[COLOR_BLACK];
#line 495 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp38_) {
#line 3714 "chess-game.c"
		GString* _tmp39_ = NULL;
#line 496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp39_ = value;
#line 496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp39_, 'k');
#line 3720 "chess-game.c"
	}
#line 497 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp40_ = self->can_castle_queenside[COLOR_BLACK];
#line 497 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp40_) {
#line 3726 "chess-game.c"
		GString* _tmp41_ = NULL;
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp41_ = value;
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp41_, 'q');
#line 3732 "chess-game.c"
	}
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp42_ = self->can_castle_kingside[COLOR_WHITE];
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp43_ = self->can_castle_queenside[COLOR_WHITE];
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp44_ = self->can_castle_kingside[COLOR_BLACK];
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp45_ = self->can_castle_queenside[COLOR_BLACK];
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!(((_tmp42_ | _tmp43_) | _tmp44_) | _tmp45_)) {
#line 3744 "chess-game.c"
		GString* _tmp46_ = NULL;
#line 500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp46_ = value;
#line 500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp46_, '-');
#line 3750 "chess-game.c"
	}
#line 502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp47_ = value;
#line 502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_c (_tmp47_, ' ');
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp48_ = self->en_passant_index;
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp48_ >= 0) {
#line 3760 "chess-game.c"
		GString* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp49_ = value;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp50_ = self->en_passant_index;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp51_ = chess_state_get_file (self, _tmp50_);
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp52_ = self->en_passant_index;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp53_ = chess_state_get_rank (self, _tmp52_);
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp49_, "%c%d", 'a' + _tmp51_, _tmp53_ + 1);
#line 3778 "chess-game.c"
	} else {
		GString* _tmp54_ = NULL;
#line 506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp54_ = value;
#line 506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_c (_tmp54_, '-');
#line 3785 "chess-game.c"
	}
#line 508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp55_ = value;
#line 508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_c (_tmp55_, ' ');
#line 509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp56_ = value;
#line 509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp57_ = self->halfmove_clock;
#line 509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_printf (_tmp56_, "%d", _tmp57_);
#line 511 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp58_ = value;
#line 511 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_string_append_c (_tmp58_, ' ');
#line 512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp59_ = self->current_player;
#line 512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp60_ = _tmp59_->color;
#line 512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp60_ == COLOR_WHITE) {
#line 3807 "chess-game.c"
		GString* _tmp61_ = NULL;
		gint _tmp62_ = 0;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp61_ = value;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp62_ = self->number;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp61_, "%d", _tmp62_ / 2);
#line 3816 "chess-game.c"
	} else {
		GString* _tmp63_ = NULL;
		gint _tmp64_ = 0;
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp63_ = value;
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp64_ = self->number;
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_string_append_printf (_tmp63_, "%d", (_tmp64_ / 2) + 1);
#line 3826 "chess-game.c"
	}
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp65_ = value;
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp66_ = _tmp65_->str;
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp67_ = g_strdup (_tmp66_);
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp67_;
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_string_free0 (value);
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3840 "chess-game.c"
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = rank;
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = file;
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = (_tmp0_ * 8) + _tmp1_;
#line 522 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3858 "chess-game.c"
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = index;
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_ / 8;
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3873 "chess-game.c"
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = index;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_ % 8;
#line 532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3888 "chess-game.c"
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ChessPlayer* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	PieceType _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->current_player;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = move;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	r0 = _tmp2_;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	f0 = _tmp3_;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	r1 = _tmp4_;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	f1 = _tmp5_;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	promotion_type = _tmp6_;
#line 540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp7_) {
#line 541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 3941 "chess-game.c"
	}
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = self->current_player;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = r0;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = f0;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = r1;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = f1;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = promotion_type;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = apply;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp15_) {
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 3965 "chess-game.c"
	}
#line 546 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 546 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 3971 "chess-game.c"
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint start = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint end = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Color color = 0;
	ChessPlayer* _tmp6_ = NULL;
	Color _tmp7_ = 0;
	Color _tmp8_ = 0;
	Color _tmp9_ = 0;
	Color opponent_color = 0;
	Color _tmp10_ = 0;
	ChessPiece* piece = NULL;
	gint _tmp11_ = 0;
	ChessPiece* _tmp12_ = NULL;
	ChessPiece* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	ChessPiece* _tmp15_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint64 end_mask = 0LL;
	gint _tmp20_ = 0;
	gint64 _tmp21_ = 0LL;
	gint64 move_mask = 0LL;
	Color _tmp22_ = 0;
	ChessPiece* _tmp23_ = NULL;
	PieceType _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint64 _tmp26_ = 0LL;
	gint64 _tmp27_ = 0LL;
	gint64 _tmp28_ = 0LL;
	gint64 over_mask = 0LL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint64 _tmp31_ = 0LL;
	gint64 _tmp32_ = 0LL;
	gint64 _tmp33_ = 0LL;
	gint64 _tmp34_ = 0LL;
	ChessPiece* victim = NULL;
	gint _tmp35_ = 0;
	ChessPiece* _tmp36_ = NULL;
	ChessPiece* _tmp37_ = NULL;
	gint victim_index = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	ChessPiece* _tmp40_ = NULL;
	gboolean _tmp44_ = FALSE;
	gint rook_start = 0;
	gint rook_end = 0;
	gboolean is_promotion = FALSE;
	gboolean ambiguous_rank = FALSE;
	gboolean ambiguous_file = FALSE;
	ChessPiece* _tmp45_ = NULL;
	PieceType _tmp46_ = 0;
	gboolean _tmp121_ = FALSE;
	gboolean _tmp122_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_ = FALSE;
	gint64 old_white_mask = 0LL;
	gint64 _tmp161_ = 0LL;
	gint64 old_black_mask = 0LL;
	gint64 _tmp162_ = 0LL;
	gboolean old_white_can_castle_kingside = FALSE;
	gboolean _tmp163_ = FALSE;
	gboolean old_white_can_castle_queenside = FALSE;
	gboolean _tmp164_ = FALSE;
	gboolean old_black_can_castle_kingside = FALSE;
	gboolean _tmp165_ = FALSE;
	gboolean old_black_can_castle_queenside = FALSE;
	gboolean _tmp166_ = FALSE;
	gint old_en_passant_index = 0;
	gint _tmp167_ = 0;
	gint old_halfmove_clock = 0;
	gint _tmp168_ = 0;
	gint _tmp169_ = 0;
	ChessPiece* _tmp170_ = NULL;
	gint _tmp171_ = 0;
	gint64 _tmp172_ = 0LL;
	gint64 _tmp173_ = 0LL;
	gint _tmp174_ = 0;
	gint64 _tmp175_ = 0LL;
	gint64 _tmp176_ = 0LL;
	ChessPiece* _tmp177_ = NULL;
	gboolean _tmp186_ = FALSE;
	Color _tmp196_ = 0;
	gint64 _tmp197_ = 0LL;
	gint64 _tmp198_ = 0LL;
	Color _tmp199_ = 0;
	gint _tmp200_ = 0;
	gint64 _tmp201_ = 0LL;
	gint64 _tmp202_ = 0LL;
	gint _tmp203_ = 0;
	ChessPiece* _tmp221_ = NULL;
	PieceType _tmp222_ = 0;
	gboolean _tmp256_ = FALSE;
	ChessPiece* _tmp257_ = NULL;
	PieceType _tmp258_ = 0;
	gboolean _tmp260_ = FALSE;
	gboolean _tmp265_ = FALSE;
	ChessPiece* _tmp266_ = NULL;
	PieceType _tmp267_ = 0;
	gboolean _tmp269_ = FALSE;
	gboolean _result_ = FALSE;
	gboolean _tmp271_ = FALSE;
	gboolean _tmp272_ = FALSE;
	gboolean _tmp275_ = FALSE;
	gboolean _tmp276_ = FALSE;
	gboolean _tmp277_ = FALSE;
	gboolean _tmp279_ = FALSE;
	ChessPlayer* _tmp315_ = NULL;
	Color _tmp316_ = 0;
	ChessPlayer* _tmp319_ = NULL;
	ChessPlayer* _tmp320_ = NULL;
	ChessPlayer* _tmp321_ = NULL;
	CheckState _tmp322_ = 0;
	ChessMove* _tmp323_ = NULL;
	ChessMove* _tmp324_ = NULL;
	gint _tmp325_ = 0;
	ChessMove* _tmp326_ = NULL;
	ChessPiece* _tmp327_ = NULL;
	ChessPiece* _tmp328_ = NULL;
	gboolean _tmp329_ = FALSE;
	ChessMove* _tmp334_ = NULL;
	ChessPiece* _tmp335_ = NULL;
	ChessPiece* _tmp336_ = NULL;
	gint _tmp337_ = 0;
	ChessMove* _tmp342_ = NULL;
	gint _tmp343_ = 0;
	ChessMove* _tmp344_ = NULL;
	gint _tmp345_ = 0;
	ChessMove* _tmp346_ = NULL;
	gint _tmp347_ = 0;
	ChessMove* _tmp348_ = NULL;
	gint _tmp349_ = 0;
	ChessMove* _tmp350_ = NULL;
	gboolean _tmp351_ = FALSE;
	ChessMove* _tmp352_ = NULL;
	gboolean _tmp353_ = FALSE;
	ChessMove* _tmp354_ = NULL;
	CheckState _tmp355_ = 0;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = r0;
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = f0;
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	start = _tmp2_;
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = r1;
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = f1;
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
#line 556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	end = _tmp5_;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = player;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = _tmp6_->color;
#line 558 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	color = _tmp7_;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = color;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp9_ == COLOR_WHITE) {
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = COLOR_BLACK;
#line 4151 "chess-game.c"
	} else {
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = COLOR_WHITE;
#line 4155 "chess-game.c"
	}
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = _tmp8_;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	opponent_color = _tmp10_;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = start;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = self->board[_tmp11_];
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = _chess_piece_ref0 (_tmp12_);
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	piece = _tmp13_;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = piece;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp15_ == NULL) {
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = TRUE;
#line 4175 "chess-game.c"
	} else {
		ChessPiece* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		ChessPlayer* _tmp18_ = NULL;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp16_ = piece;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp17_ = _tmp16_->player;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp18_ = player;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = _tmp17_ != _tmp18_;
#line 4188 "chess-game.c"
	}
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp19_ = _tmp14_;
#line 563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp19_) {
#line 564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 4200 "chess-game.c"
	}
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp20_ = end;
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp21_ = BIT_BOARD_set_location_masks[_tmp20_];
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	end_mask = _tmp21_;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = color;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_ = piece;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp24_ = _tmp23_->type;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp25_ = start;
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_ = BIT_BOARD_move_masks[(((_tmp22_ * 64) * 6) + (_tmp24_ * 64)) + _tmp25_];
#line 568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	move_mask = _tmp26_;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = end_mask;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_ = move_mask;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if ((_tmp27_ & _tmp28_) == ((gint64) 0)) {
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 4232 "chess-game.c"
	}
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp29_ = start;
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp30_ = end;
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp31_ = BIT_BOARD_over_masks[(_tmp29_ * 64) + _tmp30_];
#line 573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	over_mask = _tmp31_;
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp32_ = over_mask;
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp33_ = self->priv->piece_masks[COLOR_WHITE];
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp34_ = self->priv->piece_masks[COLOR_BLACK];
#line 574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if ((_tmp32_ & (_tmp33_ | _tmp34_)) != ((gint64) 0)) {
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 575 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 4256 "chess-game.c"
	}
#line 578 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp35_ = end;
#line 578 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp36_ = self->board[_tmp35_];
#line 578 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp37_ = _chess_piece_ref0 (_tmp36_);
#line 578 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	victim = _tmp37_;
#line 579 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp38_ = end;
#line 579 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	victim_index = _tmp38_;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp40_ = victim;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp40_ != NULL) {
#line 4274 "chess-game.c"
		ChessPiece* _tmp41_ = NULL;
		ChessPlayer* _tmp42_ = NULL;
		ChessPlayer* _tmp43_ = NULL;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp41_ = victim;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp42_ = _tmp41_->player;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp43_ = player;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp39_ = _tmp42_ == _tmp43_;
#line 4286 "chess-game.c"
	} else {
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp39_ = FALSE;
#line 4290 "chess-game.c"
	}
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp44_ = _tmp39_;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp44_) {
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (victim);
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 4304 "chess-game.c"
	}
#line 586 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	rook_start = -1;
#line 586 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	rook_end = -1;
#line 587 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	is_promotion = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	ambiguous_rank = FALSE;
#line 589 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	ambiguous_file = FALSE;
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp45_ = piece;
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp46_ = _tmp45_->type;
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp46_) {
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_PAWN:
#line 4324 "chess-game.c"
		{
			gboolean _tmp47_ = FALSE;
			ChessPiece* _tmp48_ = NULL;
			gboolean _tmp51_ = FALSE;
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			gboolean _tmp64_ = FALSE;
			gint _tmp65_ = 0;
			gboolean _tmp67_ = FALSE;
			ChessPiece* _tmp68_ = NULL;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp48_ = victim;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp48_ == NULL) {
#line 4339 "chess-game.c"
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp49_ = end;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp50_ = self->en_passant_index;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp47_ = _tmp49_ == _tmp50_;
#line 4348 "chess-game.c"
			} else {
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp47_ = FALSE;
#line 4352 "chess-game.c"
			}
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp51_ = _tmp47_;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp51_) {
#line 4358 "chess-game.c"
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				ChessPiece* _tmp58_ = NULL;
				ChessPiece* _tmp59_ = NULL;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp53_ = r1;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp53_ == 2) {
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp52_ = 3;
#line 4373 "chess-game.c"
				} else {
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp52_ = 4;
#line 4377 "chess-game.c"
				}
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp54_ = _tmp52_;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp55_ = f1;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp56_ = chess_state_get_index (self, _tmp54_, _tmp55_);
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				victim_index = _tmp56_;
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp57_ = victim_index;
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp58_ = self->board[_tmp57_];
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp59_ = _chess_piece_ref0 (_tmp58_);
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (victim);
#line 597 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				victim = _tmp59_;
#line 4397 "chess-game.c"
			}
#line 601 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp60_ = f0;
#line 601 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp61_ = f1;
#line 601 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp60_ != _tmp61_) {
#line 4405 "chess-game.c"
				ChessPiece* _tmp62_ = NULL;
#line 603 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp62_ = victim;
#line 603 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp62_ == NULL) {
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4419 "chess-game.c"
				}
			} else {
				ChessPiece* _tmp63_ = NULL;
#line 609 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp63_ = victim;
#line 609 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp63_ != NULL) {
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 610 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4435 "chess-game.c"
				}
			}
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp65_ = r1;
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp65_ == 0) {
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp64_ = TRUE;
#line 4444 "chess-game.c"
			} else {
				gint _tmp66_ = 0;
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp66_ = r1;
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp64_ = _tmp66_ == 7;
#line 4451 "chess-game.c"
			}
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp67_ = _tmp64_;
#line 612 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			is_promotion = _tmp67_;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp68_ = victim;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp68_ != NULL) {
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				ambiguous_file = TRUE;
#line 4463 "chess-game.c"
			}
#line 617 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 4467 "chess-game.c"
		}
#line 590 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case PIECE_TYPE_KING:
#line 4471 "chess-game.c"
		{
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp69_ = f0;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp70_ = f1;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp71_ = abs (_tmp69_ - _tmp70_);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp71_ > 1) {
#line 4484 "chess-game.c"
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
				ChessPiece* rook = NULL;
				gint _tmp92_ = 0;
				ChessPiece* _tmp93_ = NULL;
				ChessPiece* _tmp94_ = NULL;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				ChessPiece* _tmp97_ = NULL;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp105_ = FALSE;
				gint64 rook_over_mask = 0LL;
				gint _tmp106_ = 0;
				gint _tmp107_ = 0;
				gint64 _tmp108_ = 0LL;
				gint64 _tmp109_ = 0LL;
				gint64 _tmp110_ = 0LL;
				gint64 _tmp111_ = 0LL;
				CheckState _tmp112_ = 0;
				ChessPlayer* _tmp113_ = NULL;
				gint _tmp114_ = 0;
				gint _tmp115_ = 0;
				gint _tmp116_ = 0;
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				gint _tmp119_ = 0;
				gboolean _tmp120_ = FALSE;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp73_ = f1;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp74_ = f0;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp73_ > _tmp74_) {
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp72_ = 7;
#line 4532 "chess-game.c"
				} else {
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp72_ = 0;
#line 4536 "chess-game.c"
				}
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp75_ = r0;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp76_ = _tmp72_;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp77_ = chess_state_get_index (self, _tmp75_, _tmp76_);
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				rook_start = _tmp77_;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp79_ = f1;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp80_ = f0;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp79_ > _tmp80_) {
#line 4552 "chess-game.c"
					gint _tmp81_ = 0;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp81_ = f1;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp78_ = _tmp81_ - 1;
#line 4558 "chess-game.c"
				} else {
					gint _tmp82_ = 0;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp82_ = f1;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp78_ = _tmp82_ + 1;
#line 4565 "chess-game.c"
				}
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp83_ = r0;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp84_ = _tmp78_;
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp85_ = chess_state_get_index (self, _tmp83_, _tmp84_);
#line 624 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				rook_end = _tmp85_;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp86_ = f1;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp87_ = f0;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp86_ > _tmp87_) {
#line 4581 "chess-game.c"
					Color _tmp88_ = 0;
					gboolean _tmp89_ = FALSE;
#line 629 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp88_ = color;
#line 629 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp89_ = self->can_castle_kingside[_tmp88_];
#line 629 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp89_) {
#line 630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						result = FALSE;
#line 630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (victim);
#line 630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (piece);
#line 630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						return result;
#line 4598 "chess-game.c"
					}
				} else {
					Color _tmp90_ = 0;
					gboolean _tmp91_ = FALSE;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp90_ = color;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp91_ = self->can_castle_queenside[_tmp90_];
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp91_) {
#line 635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						result = FALSE;
#line 635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (victim);
#line 635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (piece);
#line 635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						return result;
#line 4617 "chess-game.c"
					}
				}
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp92_ = rook_start;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp93_ = self->board[_tmp92_];
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp94_ = _chess_piece_ref0 (_tmp93_);
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				rook = _tmp94_;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp97_ = rook;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp97_ == NULL) {
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp96_ = TRUE;
#line 4634 "chess-game.c"
				} else {
					ChessPiece* _tmp98_ = NULL;
					PieceType _tmp99_ = 0;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp98_ = rook;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp99_ = _tmp98_->type;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp96_ = _tmp99_ != PIECE_TYPE_ROOK;
#line 4644 "chess-game.c"
				}
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp100_ = _tmp96_;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp100_) {
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp95_ = TRUE;
#line 4652 "chess-game.c"
				} else {
					ChessPiece* _tmp101_ = NULL;
					Color _tmp102_ = 0;
					Color _tmp103_ = 0;
					Color _tmp104_ = 0;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp101_ = rook;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp102_ = chess_piece_get_color (_tmp101_);
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp103_ = _tmp102_;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp104_ = color;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp95_ = _tmp103_ != _tmp104_;
#line 4668 "chess-game.c"
				}
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp105_ = _tmp95_;
#line 639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp105_) {
#line 640 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 640 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (rook);
#line 640 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 640 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 640 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4684 "chess-game.c"
				}
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp106_ = rook_start;
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp107_ = rook_end;
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp108_ = BIT_BOARD_over_masks[(_tmp106_ * 64) + _tmp107_];
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				rook_over_mask = _tmp108_;
#line 644 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp109_ = rook_over_mask;
#line 644 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp110_ = self->priv->piece_masks[COLOR_WHITE];
#line 644 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp111_ = self->priv->piece_masks[COLOR_BLACK];
#line 644 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if ((_tmp109_ & (_tmp110_ | _tmp111_)) != ((gint64) 0)) {
#line 645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (rook);
#line 645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4712 "chess-game.c"
				}
#line 648 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp112_ = self->check_state;
#line 648 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp112_ == CHECK_STATE_CHECK) {
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (rook);
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4728 "chess-game.c"
				}
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp113_ = player;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp114_ = r0;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp115_ = f0;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp116_ = rook_end;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp117_ = chess_state_get_rank (self, _tmp116_);
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp118_ = rook_end;
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp119_ = chess_state_get_file (self, _tmp118_);
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp120_ = chess_state_move_with_coords (self, _tmp113_, _tmp114_, _tmp115_, _tmp117_, _tmp119_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 652 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp120_) {
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (rook);
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (victim);
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (piece);
#line 653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 4758 "chess-game.c"
				}
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (rook);
#line 4762 "chess-game.c"
			}
#line 655 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 4766 "chess-game.c"
		}
		default:
		{
#line 657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			break;
#line 4772 "chess-game.c"
		}
	}
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp122_ = apply;
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp122_) {
#line 4779 "chess-game.c"
		gboolean _tmp123_ = FALSE;
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp123_ = test_check;
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp121_ = !_tmp123_;
#line 4785 "chess-game.c"
	} else {
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp121_ = FALSE;
#line 4789 "chess-game.c"
	}
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp124_ = _tmp121_;
#line 660 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp124_) {
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = TRUE;
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (victim);
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 661 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 4803 "chess-game.c"
	}
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp125_ = apply;
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp125_) {
#line 4809 "chess-game.c"
		{
			gint i = 0;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			i = 0;
#line 4814 "chess-game.c"
			{
				gboolean _tmp126_ = FALSE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp126_ = TRUE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				while (TRUE) {
#line 4821 "chess-game.c"
					gboolean _tmp127_ = FALSE;
					gint _tmp129_ = 0;
					gint _tmp130_ = 0;
					gint _tmp131_ = 0;
					ChessPiece* p = NULL;
					gint _tmp132_ = 0;
					ChessPiece* _tmp133_ = NULL;
					ChessPiece* _tmp134_ = NULL;
					gboolean _tmp135_ = FALSE;
					gboolean _tmp136_ = FALSE;
					ChessPiece* _tmp137_ = NULL;
					gboolean _tmp141_ = FALSE;
					gboolean _tmp146_ = FALSE;
					gint r = 0;
					gint _tmp147_ = 0;
					gint _tmp148_ = 0;
					gint f = 0;
					gint _tmp149_ = 0;
					gint _tmp150_ = 0;
					ChessPlayer* _tmp151_ = NULL;
					gint _tmp152_ = 0;
					gint _tmp153_ = 0;
					gint _tmp154_ = 0;
					gint _tmp155_ = 0;
					gboolean _tmp156_ = FALSE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp127_ = _tmp126_;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp127_) {
#line 4851 "chess-game.c"
						gint _tmp128_ = 0;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp128_ = i;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						i = _tmp128_ + 1;
#line 4857 "chess-game.c"
					}
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp126_ = FALSE;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp129_ = i;
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!(_tmp129_ < 64)) {
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						break;
#line 4867 "chess-game.c"
					}
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp130_ = i;
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp131_ = start;
#line 669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp130_ == _tmp131_) {
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						continue;
#line 4877 "chess-game.c"
					}
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp132_ = i;
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp133_ = self->board[_tmp132_];
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp134_ = _chess_piece_ref0 (_tmp133_);
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					p = _tmp134_;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp137_ = p;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp137_ == NULL) {
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp136_ = TRUE;
#line 4893 "chess-game.c"
					} else {
						ChessPiece* _tmp138_ = NULL;
						ChessPlayer* _tmp139_ = NULL;
						ChessPlayer* _tmp140_ = NULL;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp138_ = p;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp139_ = _tmp138_->player;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp140_ = player;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp136_ = _tmp139_ != _tmp140_;
#line 4906 "chess-game.c"
					}
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp141_ = _tmp136_;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp141_) {
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp135_ = TRUE;
#line 4914 "chess-game.c"
					} else {
						ChessPiece* _tmp142_ = NULL;
						PieceType _tmp143_ = 0;
						ChessPiece* _tmp144_ = NULL;
						PieceType _tmp145_ = 0;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp142_ = p;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp143_ = _tmp142_->type;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp144_ = piece;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp145_ = _tmp144_->type;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp135_ = _tmp143_ != _tmp145_;
#line 4930 "chess-game.c"
					}
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp146_ = _tmp135_;
#line 674 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp146_) {
#line 675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (p);
#line 675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						continue;
#line 4940 "chess-game.c"
					}
#line 678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp147_ = i;
#line 678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp148_ = chess_state_get_rank (self, _tmp147_);
#line 678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					r = _tmp148_;
#line 679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp149_ = i;
#line 679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp150_ = chess_state_get_file (self, _tmp149_);
#line 679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					f = _tmp150_;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp151_ = player;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp152_ = r;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp153_ = f;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp154_ = r1;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp155_ = f1;
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp156_ = chess_state_move_with_coords (self, _tmp151_, _tmp152_, _tmp153_, _tmp154_, _tmp155_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp156_) {
#line 4968 "chess-game.c"
						gint _tmp157_ = 0;
						gint _tmp158_ = 0;
						gint _tmp159_ = 0;
						gint _tmp160_ = 0;
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp157_ = r;
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp158_ = r0;
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp157_ != _tmp158_) {
#line 683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							ambiguous_rank = TRUE;
#line 4981 "chess-game.c"
						}
#line 684 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp159_ = f;
#line 684 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp160_ = f0;
#line 684 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp159_ != _tmp160_) {
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							ambiguous_file = TRUE;
#line 4991 "chess-game.c"
						}
					}
#line 666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 4996 "chess-game.c"
				}
			}
		}
	}
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp161_ = self->priv->piece_masks[COLOR_WHITE];
#line 690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_white_mask = _tmp161_;
#line 691 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp162_ = self->priv->piece_masks[COLOR_BLACK];
#line 691 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_black_mask = _tmp162_;
#line 692 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp163_ = self->can_castle_kingside[COLOR_WHITE];
#line 692 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_white_can_castle_kingside = _tmp163_;
#line 693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp164_ = self->can_castle_queenside[COLOR_WHITE];
#line 693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_white_can_castle_queenside = _tmp164_;
#line 694 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp165_ = self->can_castle_kingside[COLOR_BLACK];
#line 694 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_black_can_castle_kingside = _tmp165_;
#line 695 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp166_ = self->can_castle_queenside[COLOR_BLACK];
#line 695 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_black_can_castle_queenside = _tmp166_;
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp167_ = self->en_passant_index;
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_en_passant_index = _tmp167_;
#line 697 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp168_ = self->halfmove_clock;
#line 697 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old_halfmove_clock = _tmp168_;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp169_ = start;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (self->board[_tmp169_]);
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->board[_tmp169_] = NULL;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp170_ = self->board[_tmp169_];
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp171_ = start;
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp172_ = BIT_BOARD_clear_location_masks[_tmp171_];
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->piece_masks[COLOR_WHITE] &= _tmp172_;
#line 701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp173_ = self->priv->piece_masks[COLOR_WHITE];
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp174_ = start;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp175_ = BIT_BOARD_clear_location_masks[_tmp174_];
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->piece_masks[COLOR_BLACK] &= _tmp175_;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp176_ = self->priv->piece_masks[COLOR_BLACK];
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp177_ = victim;
#line 703 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp177_ != NULL) {
#line 5061 "chess-game.c"
		gint _tmp178_ = 0;
		ChessPiece* _tmp179_ = NULL;
		gint _tmp180_ = 0;
		gint64 _tmp181_ = 0LL;
		gint64 _tmp182_ = 0LL;
		gint _tmp183_ = 0;
		gint64 _tmp184_ = 0LL;
		gint64 _tmp185_ = 0LL;
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp178_ = victim_index;
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp178_]);
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp178_] = NULL;
#line 705 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp179_ = self->board[_tmp178_];
#line 706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp180_ = victim_index;
#line 706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp181_ = BIT_BOARD_clear_location_masks[_tmp180_];
#line 706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[COLOR_WHITE] &= _tmp181_;
#line 706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp182_ = self->priv->piece_masks[COLOR_WHITE];
#line 707 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp183_ = victim_index;
#line 707 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp184_ = BIT_BOARD_clear_location_masks[_tmp183_];
#line 707 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[COLOR_BLACK] &= _tmp184_;
#line 707 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp185_ = self->priv->piece_masks[COLOR_BLACK];
#line 5094 "chess-game.c"
	}
#line 709 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp186_ = is_promotion;
#line 709 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp186_) {
#line 5100 "chess-game.c"
		gint _tmp187_ = 0;
		ChessPlayer* _tmp188_ = NULL;
		PieceType _tmp189_ = 0;
		ChessPiece* _tmp190_ = NULL;
		ChessPiece* _tmp191_ = NULL;
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp187_ = end;
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp188_ = player;
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp189_ = promotion_type;
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp190_ = chess_piece_new (_tmp188_, _tmp189_);
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp187_]);
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp187_] = _tmp190_;
#line 710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp191_ = self->board[_tmp187_];
#line 5120 "chess-game.c"
	} else {
		gint _tmp192_ = 0;
		ChessPiece* _tmp193_ = NULL;
		ChessPiece* _tmp194_ = NULL;
		ChessPiece* _tmp195_ = NULL;
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp192_ = end;
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp193_ = piece;
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp194_ = _chess_piece_ref0 (_tmp193_);
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp192_]);
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp192_] = _tmp194_;
#line 712 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp195_ = self->board[_tmp192_];
#line 5138 "chess-game.c"
	}
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp196_ = color;
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp197_ = end_mask;
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->piece_masks[_tmp196_] |= _tmp197_;
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp198_ = self->priv->piece_masks[_tmp196_];
#line 714 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp199_ = opponent_color;
#line 714 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp200_ = end;
#line 714 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp201_ = BIT_BOARD_clear_location_masks[_tmp200_];
#line 714 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->piece_masks[_tmp199_] &= _tmp201_;
#line 714 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp202_ = self->priv->piece_masks[_tmp199_];
#line 715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp203_ = rook_start;
#line 715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp203_ >= 0) {
#line 5162 "chess-game.c"
		ChessPiece* rook = NULL;
		gint _tmp204_ = 0;
		ChessPiece* _tmp205_ = NULL;
		ChessPiece* _tmp206_ = NULL;
		gint _tmp207_ = 0;
		ChessPiece* _tmp208_ = NULL;
		Color _tmp209_ = 0;
		gint _tmp210_ = 0;
		gint64 _tmp211_ = 0LL;
		gint64 _tmp212_ = 0LL;
		gint _tmp213_ = 0;
		ChessPiece* _tmp214_ = NULL;
		ChessPiece* _tmp215_ = NULL;
		ChessPiece* _tmp216_ = NULL;
		Color _tmp217_ = 0;
		gint _tmp218_ = 0;
		gint64 _tmp219_ = 0LL;
		gint64 _tmp220_ = 0LL;
#line 717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp204_ = rook_start;
#line 717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp205_ = self->board[_tmp204_];
#line 717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp206_ = _chess_piece_ref0 (_tmp205_);
#line 717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		rook = _tmp206_;
#line 718 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp207_ = rook_start;
#line 718 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp207_]);
#line 718 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp207_] = NULL;
#line 718 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp208_ = self->board[_tmp207_];
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp209_ = color;
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp210_ = rook_start;
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp211_ = BIT_BOARD_clear_location_masks[_tmp210_];
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[_tmp209_] &= _tmp211_;
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp212_ = self->priv->piece_masks[_tmp209_];
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp213_ = rook_end;
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp214_ = rook;
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp215_ = _chess_piece_ref0 (_tmp214_);
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp213_]);
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp213_] = _tmp215_;
#line 720 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp216_ = self->board[_tmp213_];
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp217_ = color;
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp218_ = rook_end;
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp219_ = BIT_BOARD_set_location_masks[_tmp218_];
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[_tmp217_] |= _tmp219_;
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp220_ = self->priv->piece_masks[_tmp217_];
#line 715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (rook);
#line 5231 "chess-game.c"
	}
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp221_ = piece;
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp222_ = _tmp221_->type;
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp222_ == PIECE_TYPE_KING) {
#line 5239 "chess-game.c"
		Color _tmp223_ = 0;
		gboolean _tmp224_ = FALSE;
		Color _tmp225_ = 0;
		gboolean _tmp226_ = FALSE;
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp223_ = color;
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_kingside[_tmp223_] = FALSE;
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp224_ = self->can_castle_kingside[_tmp223_];
#line 728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp225_ = color;
#line 728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_queenside[_tmp225_] = FALSE;
#line 728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp226_ = self->can_castle_queenside[_tmp225_];
#line 5256 "chess-game.c"
	} else {
		ChessPiece* _tmp227_ = NULL;
		PieceType _tmp228_ = 0;
#line 731 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp227_ = piece;
#line 731 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp228_ = _tmp227_->type;
#line 731 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp228_ == PIECE_TYPE_ROOK) {
#line 5266 "chess-game.c"
			gint _tmp229_ = 0;
			Color _tmp230_ = 0;
			gint base_rank = 0;
			gint _tmp231_ = 0;
			gint _tmp232_ = 0;
			gint _tmp233_ = 0;
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp230_ = color;
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp230_ == COLOR_WHITE) {
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp229_ = 0;
#line 5279 "chess-game.c"
			} else {
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp229_ = 7;
#line 5283 "chess-game.c"
			}
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp231_ = _tmp229_;
#line 733 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			base_rank = _tmp231_;
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp232_ = r0;
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp233_ = base_rank;
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp232_ == _tmp233_) {
#line 5295 "chess-game.c"
				gint _tmp234_ = 0;
#line 736 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp234_ = f0;
#line 736 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp234_ == 0) {
#line 5301 "chess-game.c"
					Color _tmp235_ = 0;
					gboolean _tmp236_ = FALSE;
#line 737 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp235_ = color;
#line 737 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					self->can_castle_queenside[_tmp235_] = FALSE;
#line 737 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp236_ = self->can_castle_queenside[_tmp235_];
#line 5310 "chess-game.c"
				} else {
					gint _tmp237_ = 0;
#line 738 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp237_ = f0;
#line 738 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp237_ == 7) {
#line 5317 "chess-game.c"
						Color _tmp238_ = 0;
						gboolean _tmp239_ = FALSE;
#line 739 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp238_ = color;
#line 739 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						self->can_castle_kingside[_tmp238_] = FALSE;
#line 739 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp239_ = self->can_castle_kingside[_tmp238_];
#line 5326 "chess-game.c"
					}
				}
			}
		} else {
			gboolean _tmp240_ = FALSE;
			ChessPiece* _tmp241_ = NULL;
			gboolean _tmp244_ = FALSE;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp241_ = victim;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp241_ != NULL) {
#line 5338 "chess-game.c"
				ChessPiece* _tmp242_ = NULL;
				PieceType _tmp243_ = 0;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp242_ = victim;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp243_ = _tmp242_->type;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp240_ = _tmp243_ == PIECE_TYPE_ROOK;
#line 5347 "chess-game.c"
			} else {
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp240_ = FALSE;
#line 5351 "chess-game.c"
			}
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp244_ = _tmp240_;
#line 743 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp244_) {
#line 5357 "chess-game.c"
				gint _tmp245_ = 0;
				Color _tmp246_ = 0;
				gint base_rank = 0;
				gint _tmp247_ = 0;
				gint _tmp248_ = 0;
				gint _tmp249_ = 0;
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp246_ = opponent_color;
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp246_ == COLOR_WHITE) {
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp245_ = 0;
#line 5370 "chess-game.c"
				} else {
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp245_ = 7;
#line 5374 "chess-game.c"
				}
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp247_ = _tmp245_;
#line 745 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				base_rank = _tmp247_;
#line 746 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp248_ = r1;
#line 746 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp249_ = base_rank;
#line 746 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp248_ == _tmp249_) {
#line 5386 "chess-game.c"
					gint _tmp250_ = 0;
#line 748 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp250_ = f1;
#line 748 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp250_ == 0) {
#line 5392 "chess-game.c"
						Color _tmp251_ = 0;
						gboolean _tmp252_ = FALSE;
#line 749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp251_ = opponent_color;
#line 749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						self->can_castle_queenside[_tmp251_] = FALSE;
#line 749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp252_ = self->can_castle_queenside[_tmp251_];
#line 5401 "chess-game.c"
					} else {
						gint _tmp253_ = 0;
#line 750 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp253_ = f1;
#line 750 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp253_ == 7) {
#line 5408 "chess-game.c"
							Color _tmp254_ = 0;
							gboolean _tmp255_ = FALSE;
#line 751 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp254_ = opponent_color;
#line 751 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							self->can_castle_kingside[_tmp254_] = FALSE;
#line 751 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp255_ = self->can_castle_kingside[_tmp254_];
#line 5417 "chess-game.c"
						}
					}
				}
			}
		}
	}
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp257_ = piece;
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp258_ = _tmp257_->type;
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp258_ == PIECE_TYPE_PAWN) {
#line 5430 "chess-game.c"
		gint64 _tmp259_ = 0LL;
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp259_ = over_mask;
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp256_ = _tmp259_ != ((gint64) 0);
#line 5436 "chess-game.c"
	} else {
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp256_ = FALSE;
#line 5440 "chess-game.c"
	}
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp260_ = _tmp256_;
#line 756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp260_) {
#line 5446 "chess-game.c"
		gint _tmp261_ = 0;
		gint _tmp262_ = 0;
		gint _tmp263_ = 0;
		gint _tmp264_ = 0;
#line 757 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp261_ = r0;
#line 757 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp262_ = r1;
#line 757 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp263_ = f0;
#line 757 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp264_ = chess_state_get_index (self, (_tmp261_ + _tmp262_) / 2, _tmp263_);
#line 757 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->en_passant_index = _tmp264_;
#line 5461 "chess-game.c"
	} else {
#line 759 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->en_passant_index = -1;
#line 5465 "chess-game.c"
	}
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp266_ = piece;
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp267_ = _tmp266_->type;
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp267_ == PIECE_TYPE_PAWN) {
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp265_ = TRUE;
#line 5475 "chess-game.c"
	} else {
		ChessPiece* _tmp268_ = NULL;
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp268_ = victim;
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp265_ = _tmp268_ != NULL;
#line 5482 "chess-game.c"
	}
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp269_ = _tmp265_;
#line 762 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp269_) {
#line 763 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->halfmove_clock = 0;
#line 5490 "chess-game.c"
	} else {
		gint _tmp270_ = 0;
#line 765 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp270_ = self->halfmove_clock;
#line 765 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->halfmove_clock = _tmp270_ + 1;
#line 5497 "chess-game.c"
	}
#line 768 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_result_ = TRUE;
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp272_ = test_check;
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp272_) {
#line 5505 "chess-game.c"
		ChessPlayer* _tmp273_ = NULL;
		gboolean _tmp274_ = FALSE;
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp273_ = player;
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp274_ = chess_state_is_in_check (self, _tmp273_);
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp271_ = _tmp274_;
#line 5514 "chess-game.c"
	} else {
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp271_ = FALSE;
#line 5518 "chess-game.c"
	}
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp275_ = _tmp271_;
#line 769 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp275_) {
#line 770 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_result_ = FALSE;
#line 5526 "chess-game.c"
	}
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp277_ = apply;
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp277_) {
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp276_ = TRUE;
#line 5534 "chess-game.c"
	} else {
		gboolean _tmp278_ = FALSE;
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp278_ = _result_;
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp276_ = !_tmp278_;
#line 5541 "chess-game.c"
	}
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp279_ = _tmp276_;
#line 773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp279_) {
#line 5547 "chess-game.c"
		gint _tmp280_ = 0;
		ChessPiece* _tmp281_ = NULL;
		ChessPiece* _tmp282_ = NULL;
		ChessPiece* _tmp283_ = NULL;
		gint _tmp284_ = 0;
		ChessPiece* _tmp285_ = NULL;
		ChessPiece* _tmp286_ = NULL;
		gint _tmp291_ = 0;
		gint64 _tmp301_ = 0LL;
		gint64 _tmp302_ = 0LL;
		gint64 _tmp303_ = 0LL;
		gint64 _tmp304_ = 0LL;
		gboolean _tmp305_ = FALSE;
		gboolean _tmp306_ = FALSE;
		gboolean _tmp307_ = FALSE;
		gboolean _tmp308_ = FALSE;
		gboolean _tmp309_ = FALSE;
		gboolean _tmp310_ = FALSE;
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_ = FALSE;
		gint _tmp313_ = 0;
		gint _tmp314_ = 0;
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp280_ = start;
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp281_ = piece;
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp282_ = _chess_piece_ref0 (_tmp281_);
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp280_]);
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp280_] = _tmp282_;
#line 775 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp283_ = self->board[_tmp280_];
#line 776 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp284_ = end;
#line 776 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (self->board[_tmp284_]);
#line 776 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->board[_tmp284_] = NULL;
#line 776 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp285_ = self->board[_tmp284_];
#line 777 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp286_ = victim;
#line 777 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp286_ != NULL) {
#line 5594 "chess-game.c"
			gint _tmp287_ = 0;
			ChessPiece* _tmp288_ = NULL;
			ChessPiece* _tmp289_ = NULL;
			ChessPiece* _tmp290_ = NULL;
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp287_ = victim_index;
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp288_ = victim;
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp289_ = _chess_piece_ref0 (_tmp288_);
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_chess_piece_unref0 (self->board[_tmp287_]);
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			self->board[_tmp287_] = _tmp289_;
#line 778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp290_ = self->board[_tmp287_];
#line 5611 "chess-game.c"
		}
#line 779 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp291_ = rook_start;
#line 779 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp291_ >= 0) {
#line 5617 "chess-game.c"
			ChessPiece* rook = NULL;
			gint _tmp292_ = 0;
			ChessPiece* _tmp293_ = NULL;
			ChessPiece* _tmp294_ = NULL;
			gint _tmp295_ = 0;
			ChessPiece* _tmp296_ = NULL;
			ChessPiece* _tmp297_ = NULL;
			ChessPiece* _tmp298_ = NULL;
			gint _tmp299_ = 0;
			ChessPiece* _tmp300_ = NULL;
#line 781 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp292_ = rook_end;
#line 781 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp293_ = self->board[_tmp292_];
#line 781 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp294_ = _chess_piece_ref0 (_tmp293_);
#line 781 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			rook = _tmp294_;
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp295_ = rook_start;
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp296_ = rook;
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp297_ = _chess_piece_ref0 (_tmp296_);
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_chess_piece_unref0 (self->board[_tmp295_]);
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			self->board[_tmp295_] = _tmp297_;
#line 782 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp298_ = self->board[_tmp295_];
#line 783 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp299_ = rook_end;
#line 783 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_chess_piece_unref0 (self->board[_tmp299_]);
#line 783 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			self->board[_tmp299_] = NULL;
#line 783 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp300_ = self->board[_tmp299_];
#line 779 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_chess_piece_unref0 (rook);
#line 5658 "chess-game.c"
		}
#line 785 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp301_ = old_white_mask;
#line 785 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[COLOR_WHITE] = _tmp301_;
#line 785 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp302_ = self->priv->piece_masks[COLOR_WHITE];
#line 786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp303_ = old_black_mask;
#line 786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->priv->piece_masks[COLOR_BLACK] = _tmp303_;
#line 786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp304_ = self->priv->piece_masks[COLOR_BLACK];
#line 787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp305_ = old_white_can_castle_kingside;
#line 787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_kingside[COLOR_WHITE] = _tmp305_;
#line 787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp306_ = self->can_castle_kingside[COLOR_WHITE];
#line 788 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp307_ = old_white_can_castle_queenside;
#line 788 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_queenside[COLOR_WHITE] = _tmp307_;
#line 788 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp308_ = self->can_castle_queenside[COLOR_WHITE];
#line 789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp309_ = old_black_can_castle_kingside;
#line 789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_kingside[COLOR_BLACK] = _tmp309_;
#line 789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp310_ = self->can_castle_kingside[COLOR_BLACK];
#line 790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp311_ = old_black_can_castle_queenside;
#line 790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->can_castle_queenside[COLOR_BLACK] = _tmp311_;
#line 790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp312_ = self->can_castle_queenside[COLOR_BLACK];
#line 791 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp313_ = old_en_passant_index;
#line 791 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->en_passant_index = _tmp313_;
#line 792 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp314_ = old_halfmove_clock;
#line 792 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		self->halfmove_clock = _tmp314_;
#line 794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = _result_;
#line 794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (victim);
#line 794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (piece);
#line 794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 5712 "chess-game.c"
	}
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp316_ = color;
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp316_ == COLOR_WHITE) {
#line 5718 "chess-game.c"
		ChessPlayer* _tmp317_ = NULL;
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp317_ = self->players[COLOR_BLACK];
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp315_ = _tmp317_;
#line 5724 "chess-game.c"
	} else {
		ChessPlayer* _tmp318_ = NULL;
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp318_ = self->players[COLOR_WHITE];
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp315_ = _tmp318_;
#line 5731 "chess-game.c"
	}
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp319_ = _tmp315_;
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp320_ = _g_object_ref0 (_tmp319_);
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->current_player);
#line 797 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->current_player = _tmp320_;
#line 798 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp321_ = self->current_player;
#line 798 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp322_ = chess_state_get_check_state (self, _tmp321_);
#line 798 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->check_state = _tmp322_;
#line 800 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp323_ = chess_move_new ();
#line 800 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_move_unref0 (self->last_move);
#line 800 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->last_move = _tmp323_;
#line 801 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp324_ = self->last_move;
#line 801 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp325_ = self->number;
#line 801 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp324_->number = _tmp325_;
#line 802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp326_ = self->last_move;
#line 802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp327_ = piece;
#line 802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp328_ = _chess_piece_ref0 (_tmp327_);
#line 802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (_tmp326_->piece);
#line 802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp326_->piece = _tmp328_;
#line 803 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp329_ = is_promotion;
#line 803 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp329_) {
#line 5773 "chess-game.c"
		ChessMove* _tmp330_ = NULL;
		gint _tmp331_ = 0;
		ChessPiece* _tmp332_ = NULL;
		ChessPiece* _tmp333_ = NULL;
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp330_ = self->last_move;
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp331_ = end;
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp332_ = self->board[_tmp331_];
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp333_ = _chess_piece_ref0 (_tmp332_);
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (_tmp330_->promotion_piece);
#line 804 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp330_->promotion_piece = _tmp333_;
#line 5790 "chess-game.c"
	}
#line 805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp334_ = self->last_move;
#line 805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp335_ = victim;
#line 805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp336_ = _chess_piece_ref0 (_tmp335_);
#line 805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (_tmp334_->victim);
#line 805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp334_->victim = _tmp336_;
#line 806 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp337_ = rook_end;
#line 806 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp337_ >= 0) {
#line 5806 "chess-game.c"
		ChessMove* _tmp338_ = NULL;
		gint _tmp339_ = 0;
		ChessPiece* _tmp340_ = NULL;
		ChessPiece* _tmp341_ = NULL;
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp338_ = self->last_move;
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp339_ = rook_end;
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp340_ = self->board[_tmp339_];
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp341_ = _chess_piece_ref0 (_tmp340_);
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_piece_unref0 (_tmp338_->moved_rook);
#line 807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp338_->moved_rook = _tmp341_;
#line 5823 "chess-game.c"
	}
#line 808 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp342_ = self->last_move;
#line 808 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp343_ = r0;
#line 808 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp342_->r0 = _tmp343_;
#line 809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp344_ = self->last_move;
#line 809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp345_ = f0;
#line 809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp344_->f0 = _tmp345_;
#line 810 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp346_ = self->last_move;
#line 810 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp347_ = r1;
#line 810 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp346_->r1 = _tmp347_;
#line 811 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp348_ = self->last_move;
#line 811 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp349_ = f1;
#line 811 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp348_->f1 = _tmp349_;
#line 812 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp350_ = self->last_move;
#line 812 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp351_ = ambiguous_rank;
#line 812 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp350_->ambiguous_rank = _tmp351_;
#line 813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp352_ = self->last_move;
#line 813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp353_ = ambiguous_file;
#line 813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp352_->ambiguous_file = _tmp353_;
#line 814 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp354_ = self->last_move;
#line 814 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp355_ = self->check_state;
#line 814 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp354_->check_state = _tmp355_;
#line 816 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 816 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (victim);
#line 816 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_piece_unref0 (piece);
#line 816 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 5875 "chess-game.c"
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_ = 0;
	ChessPlayer* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 819 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 821 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_vala_rule = CHESS_RULE_CHECKMATE;
#line 822 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->check_state;
#line 822 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
#line 5898 "chess-game.c"
		ChessPlayer* _tmp1_ = NULL;
		Color _tmp2_ = 0;
#line 824 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = self->current_player;
#line 824 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = _tmp1_->color;
#line 824 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp2_ == COLOR_WHITE) {
#line 826 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 827 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = CHESS_RESULT_BLACK_WON;
#line 827 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (rule) {
#line 827 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*rule = _vala_rule;
#line 5915 "chess-game.c"
			}
#line 827 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 5919 "chess-game.c"
		} else {
#line 831 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = CHESS_RESULT_WHITE_WON;
#line 832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (rule) {
#line 832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*rule = _vala_rule;
#line 5929 "chess-game.c"
			}
#line 832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 5933 "chess-game.c"
		}
	}
#line 836 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = self->current_player;
#line 836 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = chess_state_can_move (self, _tmp3_);
#line 836 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp4_) {
#line 838 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_vala_rule = CHESS_RULE_STALEMATE;
#line 839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = CHESS_RESULT_DRAW;
#line 839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (rule) {
#line 839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*rule = _vala_rule;
#line 5950 "chess-game.c"
		}
#line 839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 5954 "chess-game.c"
	}
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = self->last_move;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp7_ != NULL) {
#line 5960 "chess-game.c"
		ChessMove* _tmp8_ = NULL;
		ChessPiece* _tmp9_ = NULL;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = self->last_move;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = _tmp8_->victim;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 5969 "chess-game.c"
	} else {
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = FALSE;
#line 5973 "chess-game.c"
	}
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = _tmp6_;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp10_) {
#line 5979 "chess-game.c"
		gboolean _tmp11_ = FALSE;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp11_ = chess_state_have_sufficient_material (self);
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = !_tmp11_;
#line 5985 "chess-game.c"
	} else {
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = FALSE;
#line 5989 "chess-game.c"
	}
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = _tmp5_;
#line 842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp12_) {
#line 844 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
#line 845 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = CHESS_RESULT_DRAW;
#line 845 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (rule) {
#line 845 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*rule = _vala_rule;
#line 6003 "chess-game.c"
		}
#line 845 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 6007 "chess-game.c"
	}
#line 848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = CHESS_RESULT_IN_PROGRESS;
#line 848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (rule) {
#line 848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*rule = _vala_rule;
#line 6015 "chess-game.c"
	}
#line 848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 6019 "chess-game.c"
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 851 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 851 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, 0);
#line 853 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = player;
#line 853 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
#line 853 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp1_) {
#line 6037 "chess-game.c"
		ChessPlayer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 855 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = player;
#line 855 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
#line 855 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp3_) {
#line 856 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = CHECK_STATE_CHECKMATE;
#line 856 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 6050 "chess-game.c"
		} else {
#line 858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = CHECK_STATE_CHECK;
#line 858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 6056 "chess-game.c"
		}
	}
#line 860 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = CHECK_STATE_NONE;
#line 860 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 6063 "chess-game.c"
}


static gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	ChessPlayer* opponent = NULL;
	ChessPlayer* _tmp5_ = NULL;
	ChessPlayer* _tmp6_ = NULL;
#line 863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = player;
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 6085 "chess-game.c"
		ChessPlayer* _tmp3_ = NULL;
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp3_;
#line 6091 "chess-game.c"
	} else {
		ChessPlayer* _tmp4_ = NULL;
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp4_;
#line 6098 "chess-game.c"
	}
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _tmp0_;
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	opponent = _tmp6_;
#line 6106 "chess-game.c"
	{
		gint king_index = 0;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		king_index = 0;
#line 6111 "chess-game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp7_ = TRUE;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 6118 "chess-game.c"
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				ChessPiece* p = NULL;
				gint _tmp11_ = 0;
				ChessPiece* _tmp12_ = NULL;
				ChessPiece* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				ChessPiece* _tmp16_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp23_ = FALSE;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp8_ = _tmp7_;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp8_) {
#line 6134 "chess-game.c"
					gint _tmp9_ = 0;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = king_index;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					king_index = _tmp9_ + 1;
#line 6140 "chess-game.c"
				}
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp7_ = FALSE;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp10_ = king_index;
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp10_ < 64)) {
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 6150 "chess-game.c"
				}
#line 870 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp11_ = king_index;
#line 870 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp12_ = self->board[_tmp11_];
#line 870 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp13_ = _chess_piece_ref0 (_tmp12_);
#line 870 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				p = _tmp13_;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp16_ = p;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp16_ != NULL) {
#line 6164 "chess-game.c"
					ChessPiece* _tmp17_ = NULL;
					ChessPlayer* _tmp18_ = NULL;
					ChessPlayer* _tmp19_ = NULL;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp17_ = p;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp18_ = _tmp17_->player;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp19_ = player;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp15_ = _tmp18_ == _tmp19_;
#line 6176 "chess-game.c"
				} else {
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp15_ = FALSE;
#line 6180 "chess-game.c"
				}
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp20_ = _tmp15_;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp20_) {
#line 6186 "chess-game.c"
					ChessPiece* _tmp21_ = NULL;
					PieceType _tmp22_ = 0;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp21_ = p;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp22_ = _tmp21_->type;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp14_ = _tmp22_ == PIECE_TYPE_KING;
#line 6195 "chess-game.c"
				} else {
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp14_ = FALSE;
#line 6199 "chess-game.c"
				}
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp23_ = _tmp14_;
#line 871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp23_) {
#line 6205 "chess-game.c"
					{
						gint start = 0;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						start = 0;
#line 6210 "chess-game.c"
						{
							gboolean _tmp24_ = FALSE;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp24_ = TRUE;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							while (TRUE) {
#line 6217 "chess-game.c"
								gboolean _tmp25_ = FALSE;
								gint _tmp27_ = 0;
								ChessPlayer* _tmp28_ = NULL;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								gint _tmp32_ = 0;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								gint _tmp35_ = 0;
								gint _tmp36_ = 0;
								gboolean _tmp37_ = FALSE;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp25_ = _tmp24_;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!_tmp25_) {
#line 6234 "chess-game.c"
									gint _tmp26_ = 0;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp26_ = start;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									start = _tmp26_ + 1;
#line 6240 "chess-game.c"
								}
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp24_ = FALSE;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp27_ = start;
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!(_tmp27_ < 64)) {
#line 874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									break;
#line 6250 "chess-game.c"
								}
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp28_ = opponent;
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp29_ = start;
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp30_ = chess_state_get_rank (self, _tmp29_);
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp31_ = start;
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp32_ = chess_state_get_file (self, _tmp31_);
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp33_ = king_index;
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp34_ = chess_state_get_rank (self, _tmp33_);
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp35_ = king_index;
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp36_ = chess_state_get_file (self, _tmp35_);
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp37_ = chess_state_move_with_coords (self, _tmp28_, _tmp30_, _tmp32_, _tmp34_, _tmp36_, PIECE_TYPE_QUEEN, FALSE, FALSE);
#line 876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (_tmp37_) {
#line 880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									result = TRUE;
#line 880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_chess_piece_unref0 (p);
#line 880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_g_object_unref0 (opponent);
#line 880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									return result;
#line 6282 "chess-game.c"
								}
							}
						}
					}
				}
#line 868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (p);
#line 6290 "chess-game.c"
			}
		}
	}
#line 885 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = FALSE;
#line 885 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (opponent);
#line 885 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 6300 "chess-game.c"
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
#line 888 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 888 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 6310 "chess-game.c"
	{
		gint piece_index = 0;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		piece_index = 0;
#line 6315 "chess-game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp0_ = TRUE;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 6322 "chess-game.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				ChessPiece* p = NULL;
				gint _tmp4_ = 0;
				ChessPiece* _tmp5_ = NULL;
				ChessPiece* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				ChessPiece* _tmp8_ = NULL;
				gboolean _tmp12_ = FALSE;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp1_ = _tmp0_;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp1_) {
#line 6336 "chess-game.c"
					gint _tmp2_ = 0;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp2_ = piece_index;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					piece_index = _tmp2_ + 1;
#line 6342 "chess-game.c"
				}
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp0_ = FALSE;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = piece_index;
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp3_ < 64)) {
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 6352 "chess-game.c"
				}
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = piece_index;
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp5_ = self->board[_tmp4_];
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				p = _tmp6_;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp8_ = p;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp8_ != NULL) {
#line 6366 "chess-game.c"
					ChessPiece* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
					ChessPlayer* _tmp11_ = NULL;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = p;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp10_ = _tmp9_->player;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp11_ = player;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = _tmp10_ == _tmp11_;
#line 6378 "chess-game.c"
				} else {
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = FALSE;
#line 6382 "chess-game.c"
				}
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp12_ = _tmp7_;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp12_) {
#line 6388 "chess-game.c"
					{
						gint end = 0;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						end = 0;
#line 6393 "chess-game.c"
						{
							gboolean _tmp13_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp13_ = TRUE;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							while (TRUE) {
#line 6400 "chess-game.c"
								gboolean _tmp14_ = FALSE;
								gint _tmp16_ = 0;
								ChessPlayer* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gboolean _tmp26_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp14_ = _tmp13_;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!_tmp14_) {
#line 6417 "chess-game.c"
									gint _tmp15_ = 0;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp15_ = end;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									end = _tmp15_ + 1;
#line 6423 "chess-game.c"
								}
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp13_ = FALSE;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp16_ = end;
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!(_tmp16_ < 64)) {
#line 896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									break;
#line 6433 "chess-game.c"
								}
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp17_ = player;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp18_ = piece_index;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp19_ = chess_state_get_rank (self, _tmp18_);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp20_ = piece_index;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp21_ = chess_state_get_file (self, _tmp20_);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp22_ = end;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp23_ = chess_state_get_rank (self, _tmp22_);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp24_ = end;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp25_ = chess_state_get_file (self, _tmp24_);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp26_ = chess_state_move_with_coords (self, _tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp25_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (_tmp26_) {
#line 902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									result = FALSE;
#line 902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_chess_piece_unref0 (p);
#line 902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									return result;
#line 6463 "chess-game.c"
								}
							}
						}
					}
				}
#line 891 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (p);
#line 6471 "chess-game.c"
			}
		}
	}
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 6479 "chess-game.c"
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces = FALSE;
	gboolean _tmp27_ = FALSE;
#line 910 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 910 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 912 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	have_pieces = FALSE;
#line 6493 "chess-game.c"
	{
		gint start = 0;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		start = 0;
#line 6498 "chess-game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp0_ = TRUE;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 6505 "chess-game.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				ChessPiece* p = NULL;
				gint _tmp4_ = 0;
				ChessPiece* _tmp5_ = NULL;
				ChessPiece* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				ChessPiece* _tmp8_ = NULL;
				gboolean _tmp12_ = FALSE;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp1_ = _tmp0_;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp1_) {
#line 6519 "chess-game.c"
					gint _tmp2_ = 0;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp2_ = start;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					start = _tmp2_ + 1;
#line 6525 "chess-game.c"
				}
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp0_ = FALSE;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = start;
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp3_ < 64)) {
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 6535 "chess-game.c"
				}
#line 916 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = start;
#line 916 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp5_ = self->board[_tmp4_];
#line 916 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
#line 916 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				p = _tmp6_;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp8_ = p;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp8_ != NULL) {
#line 6549 "chess-game.c"
					ChessPiece* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
					ChessPlayer* _tmp11_ = NULL;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = p;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp10_ = _tmp9_->player;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp11_ = player;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = _tmp10_ == _tmp11_;
#line 6561 "chess-game.c"
				} else {
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = FALSE;
#line 6565 "chess-game.c"
				}
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp12_ = _tmp7_;
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp12_) {
#line 919 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					have_pieces = TRUE;
#line 6573 "chess-game.c"
					{
						gint end = 0;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						end = 0;
#line 6578 "chess-game.c"
						{
							gboolean _tmp13_ = FALSE;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp13_ = TRUE;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							while (TRUE) {
#line 6585 "chess-game.c"
								gboolean _tmp14_ = FALSE;
								gint _tmp16_ = 0;
								ChessPlayer* _tmp17_ = NULL;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gboolean _tmp26_ = FALSE;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp14_ = _tmp13_;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!_tmp14_) {
#line 6602 "chess-game.c"
									gint _tmp15_ = 0;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp15_ = end;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									end = _tmp15_ + 1;
#line 6608 "chess-game.c"
								}
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp13_ = FALSE;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp16_ = end;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (!(_tmp16_ < 64)) {
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									break;
#line 6618 "chess-game.c"
								}
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp17_ = player;
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp18_ = start;
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp19_ = chess_state_get_rank (self, _tmp18_);
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp20_ = start;
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp21_ = chess_state_get_file (self, _tmp20_);
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp22_ = end;
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp23_ = chess_state_get_rank (self, _tmp22_);
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp24_ = end;
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp25_ = chess_state_get_file (self, _tmp24_);
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp26_ = chess_state_move_with_coords (self, _tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp25_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 924 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								if (_tmp26_) {
#line 928 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									result = TRUE;
#line 928 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_chess_piece_unref0 (p);
#line 928 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									return result;
#line 6648 "chess-game.c"
								}
							}
						}
					}
				}
#line 914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (p);
#line 6656 "chess-game.c"
			}
		}
	}
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = have_pieces;
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp27_) {
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 6668 "chess-game.c"
	} else {
#line 937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = TRUE;
#line 937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 6674 "chess-game.c"
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count = 0;
	gint white_bishop_count = 0;
	gboolean white_bishop_on_white_square = FALSE;
	gboolean white_bishop_on_black_square = FALSE;
	gint black_knight_count = 0;
	gint black_bishop_count = 0;
	gboolean black_bishop_on_white_square = FALSE;
	gboolean black_bishop_on_black_square = FALSE;
#line 940 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 942 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	white_knight_count = 0;
#line 943 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	white_bishop_count = 0;
#line 944 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	white_bishop_on_white_square = FALSE;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	white_bishop_on_black_square = FALSE;
#line 946 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	black_knight_count = 0;
#line 947 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	black_bishop_count = 0;
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	black_bishop_on_white_square = FALSE;
#line 949 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	black_bishop_on_black_square = FALSE;
#line 6707 "chess-game.c"
	{
		gint i = 0;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = 0;
#line 6712 "chess-game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp0_ = TRUE;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			while (TRUE) {
#line 6719 "chess-game.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				ChessPiece* p = NULL;
				gint _tmp4_ = 0;
				ChessPiece* _tmp5_ = NULL;
				ChessPiece* _tmp6_ = NULL;
				ChessPiece* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				ChessPiece* _tmp10_ = NULL;
				PieceType _tmp11_ = 0;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp17_ = FALSE;
				ChessPiece* _tmp18_ = NULL;
				PieceType _tmp19_ = 0;
				ChessPiece* _tmp25_ = NULL;
				PieceType _tmp26_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_ = 0;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp44_ = FALSE;
				gint _tmp45_ = 0;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gboolean _tmp51_ = FALSE;
				gboolean _tmp52_ = FALSE;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp55_ = FALSE;
				gboolean _tmp56_ = FALSE;
				gboolean _tmp57_ = FALSE;
				gint _tmp58_ = 0;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp62_ = FALSE;
				gboolean _tmp63_ = FALSE;
				gboolean _tmp64_ = FALSE;
				gint _tmp65_ = 0;
				gboolean _tmp67_ = FALSE;
				gboolean _tmp69_ = FALSE;
				gboolean _tmp70_ = FALSE;
				gint _tmp71_ = 0;
				gboolean _tmp73_ = FALSE;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp1_ = _tmp0_;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!_tmp1_) {
#line 6769 "chess-game.c"
					gint _tmp2_ = 0;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp2_ = i;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					i = _tmp2_ + 1;
#line 6775 "chess-game.c"
				}
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp0_ = FALSE;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = i;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (!(_tmp3_ < 64)) {
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					break;
#line 6785 "chess-game.c"
				}
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = i;
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp5_ = self->board[_tmp4_];
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp6_ = _chess_piece_ref0 (_tmp5_);
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				p = _tmp6_;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp7_ = p;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp7_ == NULL) {
#line 955 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 955 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					continue;
#line 6803 "chess-game.c"
				}
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp10_ = p;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp11_ = _tmp10_->type;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp11_ == PIECE_TYPE_PAWN) {
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = TRUE;
#line 6813 "chess-game.c"
				} else {
					ChessPiece* _tmp12_ = NULL;
					PieceType _tmp13_ = 0;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp12_ = p;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp13_ = _tmp12_->type;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = _tmp13_ == PIECE_TYPE_ROOK;
#line 6823 "chess-game.c"
				}
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp14_ = _tmp9_;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp14_) {
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp8_ = TRUE;
#line 6831 "chess-game.c"
				} else {
					ChessPiece* _tmp15_ = NULL;
					PieceType _tmp16_ = 0;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp15_ = p;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp16_ = _tmp15_->type;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp8_ = _tmp16_ == PIECE_TYPE_QUEEN;
#line 6841 "chess-game.c"
				}
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp17_ = _tmp8_;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp17_) {
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 6853 "chess-game.c"
				}
#line 962 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp18_ = p;
#line 962 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp19_ = _tmp18_->type;
#line 962 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp19_ == PIECE_TYPE_KNIGHT) {
#line 6861 "chess-game.c"
					ChessPiece* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					Color _tmp22_ = 0;
#line 964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp20_ = p;
#line 964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp21_ = chess_piece_get_color (_tmp20_);
#line 964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp22_ = _tmp21_;
#line 964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp22_ == COLOR_WHITE) {
#line 6873 "chess-game.c"
						gint _tmp23_ = 0;
#line 965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp23_ = white_knight_count;
#line 965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						white_knight_count = _tmp23_ + 1;
#line 6879 "chess-game.c"
					} else {
						gint _tmp24_ = 0;
#line 967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp24_ = black_knight_count;
#line 967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						black_knight_count = _tmp24_ + 1;
#line 6886 "chess-game.c"
					}
				}
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp25_ = p;
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp26_ = _tmp25_->type;
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp26_ == PIECE_TYPE_BISHOP) {
#line 6895 "chess-game.c"
					Color color = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					ChessPiece* _tmp29_ = NULL;
					Color _tmp30_ = 0;
					Color _tmp31_ = 0;
#line 972 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					color = COLOR_BLACK;
#line 973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp27_ = i;
#line 973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp28_ = i;
#line 973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (((_tmp27_ + (_tmp28_ / 8)) % 2) != 0) {
#line 974 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						color = COLOR_WHITE;
#line 6912 "chess-game.c"
					}
#line 976 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp29_ = p;
#line 976 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp30_ = chess_piece_get_color (_tmp29_);
#line 976 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp31_ = _tmp30_;
#line 976 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp31_ == COLOR_WHITE) {
#line 6922 "chess-game.c"
						Color _tmp32_ = 0;
						gint _tmp33_ = 0;
#line 978 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp32_ = color;
#line 978 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp32_ == COLOR_WHITE) {
#line 979 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							white_bishop_on_white_square = TRUE;
#line 6931 "chess-game.c"
						} else {
#line 981 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							white_bishop_on_black_square = TRUE;
#line 6935 "chess-game.c"
						}
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp33_ = white_bishop_count;
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						white_bishop_count = _tmp33_ + 1;
#line 6941 "chess-game.c"
					} else {
						Color _tmp34_ = 0;
						gint _tmp35_ = 0;
#line 986 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp34_ = color;
#line 986 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp34_ == COLOR_WHITE) {
#line 987 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							black_bishop_on_white_square = TRUE;
#line 6951 "chess-game.c"
						} else {
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							black_bishop_on_black_square = TRUE;
#line 6955 "chess-game.c"
						}
#line 990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp35_ = black_bishop_count;
#line 990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						black_bishop_count = _tmp35_ + 1;
#line 6961 "chess-game.c"
					}
				}
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp37_ = white_knight_count;
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp37_ > 1) {
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp36_ = TRUE;
#line 6970 "chess-game.c"
				} else {
					gint _tmp38_ = 0;
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp38_ = black_knight_count;
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp36_ = _tmp38_ > 1;
#line 6977 "chess-game.c"
				}
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp39_ = _tmp36_;
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp39_) {
#line 1025 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1025 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1025 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 6989 "chess-game.c"
				}
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp41_ = white_bishop_count;
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp41_ > 0) {
#line 6995 "chess-game.c"
					gint _tmp42_ = 0;
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp42_ = white_knight_count;
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp40_ = _tmp42_ > 0;
#line 7001 "chess-game.c"
				} else {
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp40_ = FALSE;
#line 7005 "chess-game.c"
				}
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp43_ = _tmp40_;
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp43_) {
#line 1029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7017 "chess-game.c"
				}
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp45_ = black_bishop_count;
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp45_ > 0) {
#line 7023 "chess-game.c"
					gint _tmp46_ = 0;
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp46_ = black_knight_count;
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp44_ = _tmp46_ > 0;
#line 7029 "chess-game.c"
				} else {
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp44_ = FALSE;
#line 7033 "chess-game.c"
				}
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp47_ = _tmp44_;
#line 1030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp47_) {
#line 1031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7045 "chess-game.c"
				}
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp49_ = white_bishop_on_white_square;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp49_) {
#line 7051 "chess-game.c"
					gboolean _tmp50_ = FALSE;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp50_ = white_bishop_on_black_square;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp48_ = _tmp50_;
#line 7057 "chess-game.c"
				} else {
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp48_ = FALSE;
#line 7061 "chess-game.c"
				}
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp51_ = _tmp48_;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp51_) {
#line 1035 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1035 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1035 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7073 "chess-game.c"
				}
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp53_ = black_bishop_on_white_square;
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp53_) {
#line 7079 "chess-game.c"
					gboolean _tmp54_ = FALSE;
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp54_ = black_bishop_on_black_square;
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp52_ = _tmp54_;
#line 7085 "chess-game.c"
				} else {
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp52_ = FALSE;
#line 7089 "chess-game.c"
				}
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp55_ = _tmp52_;
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp55_) {
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7101 "chess-game.c"
				}
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp58_ = white_bishop_count;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp58_ > 0) {
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp57_ = TRUE;
#line 7109 "chess-game.c"
				} else {
					gint _tmp59_ = 0;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp59_ = white_knight_count;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp57_ = _tmp59_ > 0;
#line 7116 "chess-game.c"
				}
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp60_ = _tmp57_;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp60_) {
#line 7122 "chess-game.c"
					gint _tmp61_ = 0;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp61_ = black_knight_count;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp56_ = _tmp61_ > 0;
#line 7128 "chess-game.c"
				} else {
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp56_ = FALSE;
#line 7132 "chess-game.c"
				}
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp62_ = _tmp56_;
#line 1040 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp62_) {
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7144 "chess-game.c"
				}
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp65_ = black_bishop_count;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp65_ > 0) {
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp64_ = TRUE;
#line 7152 "chess-game.c"
				} else {
					gint _tmp66_ = 0;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp66_ = black_knight_count;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp64_ = _tmp66_ > 0;
#line 7159 "chess-game.c"
				}
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp67_ = _tmp64_;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp67_) {
#line 7165 "chess-game.c"
					gint _tmp68_ = 0;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp68_ = white_knight_count;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp63_ = _tmp68_ > 0;
#line 7171 "chess-game.c"
				} else {
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp63_ = FALSE;
#line 7175 "chess-game.c"
				}
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp69_ = _tmp63_;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp69_) {
#line 1043 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1043 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_piece_unref0 (p);
#line 1043 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 7187 "chess-game.c"
				}
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp71_ = white_bishop_count;
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp71_ > 0) {
#line 7193 "chess-game.c"
					gint _tmp72_ = 0;
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp72_ = black_bishop_count;
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp70_ = _tmp72_ > 0;
#line 7199 "chess-game.c"
				} else {
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp70_ = FALSE;
#line 7203 "chess-game.c"
				}
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp73_ = _tmp70_;
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp73_) {
#line 7209 "chess-game.c"
					gboolean _tmp74_ = FALSE;
					gboolean _tmp75_ = FALSE;
					gboolean _tmp77_ = FALSE;
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp75_ = white_bishop_on_white_square;
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp75_) {
#line 7217 "chess-game.c"
						gboolean _tmp76_ = FALSE;
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp76_ = black_bishop_on_black_square;
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp74_ = _tmp76_;
#line 7223 "chess-game.c"
					} else {
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp74_ = FALSE;
#line 7227 "chess-game.c"
					}
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp77_ = _tmp74_;
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (_tmp77_) {
#line 1049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						result = TRUE;
#line 1049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_chess_piece_unref0 (p);
#line 1049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						return result;
#line 7239 "chess-game.c"
					} else {
						gboolean _tmp78_ = FALSE;
						gboolean _tmp79_ = FALSE;
						gboolean _tmp81_ = FALSE;
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp79_ = white_bishop_on_black_square;
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp79_) {
#line 7248 "chess-game.c"
							gboolean _tmp80_ = FALSE;
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp80_ = black_bishop_on_white_square;
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp78_ = _tmp80_;
#line 7254 "chess-game.c"
						} else {
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp78_ = FALSE;
#line 7258 "chess-game.c"
						}
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp81_ = _tmp78_;
#line 1050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						if (_tmp81_) {
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							result = TRUE;
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_chess_piece_unref0 (p);
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							return result;
#line 7270 "chess-game.c"
						}
					}
				}
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_piece_unref0 (p);
#line 7276 "chess-game.c"
			}
		}
	}
#line 1055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = FALSE;
#line 1055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 7284 "chess-game.c"
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_ = 0U;
#line 1058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1060 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_vala_type = PIECE_TYPE_PAWN;
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = c;
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	switch (_tmp0_) {
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'P':
#line 7302 "chess-game.c"
		{
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_PAWN;
#line 1065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7312 "chess-game.c"
			}
#line 1065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7316 "chess-game.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'R':
#line 7320 "chess-game.c"
		{
#line 1067 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_ROOK;
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7330 "chess-game.c"
			}
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7334 "chess-game.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'N':
#line 7338 "chess-game.c"
		{
#line 1070 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_KNIGHT;
#line 1071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7348 "chess-game.c"
			}
#line 1071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7352 "chess-game.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'B':
#line 7356 "chess-game.c"
		{
#line 1073 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_BISHOP;
#line 1074 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1074 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1074 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7366 "chess-game.c"
			}
#line 1074 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7370 "chess-game.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'Q':
#line 7374 "chess-game.c"
		{
#line 1076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_QUEEN;
#line 1077 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1077 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1077 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7384 "chess-game.c"
			}
#line 1077 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7388 "chess-game.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		case 'K':
#line 7392 "chess-game.c"
		{
#line 1079 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_type = PIECE_TYPE_KING;
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = TRUE;
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7402 "chess-game.c"
			}
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7406 "chess-game.c"
		}
		default:
		{
#line 1082 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = FALSE;
#line 1082 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (type) {
#line 1082 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				*type = _vala_type;
#line 7416 "chess-game.c"
			}
#line 1082 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 7420 "chess-game.c"
		}
	}
#line 1058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (type) {
#line 1058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*type = _vala_type;
#line 7427 "chess-game.c"
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp163_ = NULL;
	gint _tmp164_ = 0;
	gchar _tmp165_ = '\0';
	const gchar* _tmp171_ = NULL;
	gint _tmp172_ = 0;
	gchar _tmp173_ = '\0';
#line 1086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 1086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 1088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	i = 0;
#line 1090 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = move;
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp1_) {
#line 7464 "chess-game.c"
		ChessPlayer* _tmp2_ = NULL;
		Color _tmp3_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = player;
#line 1093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = _tmp2_->color;
#line 1093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp3_ == COLOR_WHITE) {
#line 7476 "chess-game.c"
			gint _tmp4_ = 0;
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r1 = 0;
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp4_ = _vala_r1;
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r0 = _tmp4_;
#line 7484 "chess-game.c"
		} else {
			gint _tmp5_ = 0;
#line 1096 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r1 = 7;
#line 1096 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp5_ = _vala_r1;
#line 1096 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r0 = _tmp5_;
#line 7493 "chess-game.c"
		}
#line 1097 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_vala_f0 = 4;
#line 1098 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_vala_f1 = 2;
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = i;
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp7_ = strlen ("O-O-O");
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = _tmp7_;
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = _tmp6_ + ((gint) _tmp8_);
#line 7507 "chess-game.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 1101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = move;
#line 1101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
#line 1101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp10_) {
#line 7517 "chess-game.c"
			ChessPlayer* _tmp11_ = NULL;
			Color _tmp12_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
#line 1103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp11_ = player;
#line 1103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp12_ = _tmp11_->color;
#line 1103 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp12_ == COLOR_WHITE) {
#line 7529 "chess-game.c"
				gint _tmp13_ = 0;
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r1 = 0;
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp13_ = _vala_r1;
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r0 = _tmp13_;
#line 7537 "chess-game.c"
			} else {
				gint _tmp14_ = 0;
#line 1106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r1 = 7;
#line 1106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp14_ = _vala_r1;
#line 1106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r0 = _tmp14_;
#line 7546 "chess-game.c"
			}
#line 1107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_f0 = 4;
#line 1108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_f1 = 6;
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp15_ = i;
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp16_ = strlen ("O-O");
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp17_ = _tmp16_;
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			i = _tmp15_ + ((gint) _tmp17_);
#line 7560 "chess-game.c"
		} else {
			PieceType type = 0;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gchar _tmp20_ = '\0';
			PieceType _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gchar _tmp30_ = '\0';
			gboolean _tmp34_ = FALSE;
			gboolean _tmp39_ = FALSE;
			const gchar* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gchar _tmp42_ = '\0';
			gboolean _tmp46_ = FALSE;
			gboolean _tmp51_ = FALSE;
			const gchar* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gchar _tmp54_ = '\0';
			gboolean _tmp58_ = FALSE;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_ = NULL;
			gint _tmp62_ = 0;
			gchar _tmp63_ = '\0';
			gboolean _tmp67_ = FALSE;
			gboolean _tmp73_ = FALSE;
			const gchar* _tmp74_ = NULL;
			gint _tmp75_ = 0;
			gchar _tmp76_ = '\0';
			gboolean _tmp80_ = FALSE;
			const gchar* _tmp86_ = NULL;
			gint _tmp87_ = 0;
			gchar _tmp88_ = '\0';
			gboolean _tmp106_ = FALSE;
			gint _tmp107_ = 0;
			gboolean _tmp109_ = FALSE;
			gboolean _tmp111_ = FALSE;
			gint _tmp112_ = 0;
			gboolean _tmp114_ = FALSE;
#line 1113 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			type = PIECE_TYPE_PAWN;
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp18_ = move;
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp19_ = i;
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			type = _tmp21_;
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp22_) {
#line 7619 "chess-game.c"
				gint _tmp23_ = 0;
#line 1115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp23_ = i;
#line 1115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp23_ + 1;
#line 7625 "chess-game.c"
			}
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_f1 = -1;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp24_ = _vala_f1;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r1 = _tmp24_;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp25_ = _vala_r1;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_f0 = _tmp25_;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp26_ = _vala_f0;
#line 1117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_vala_r0 = _tmp26_;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp28_ = move;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp29_ = i;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp30_ >= 'a') {
#line 7649 "chess-game.c"
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gchar _tmp33_ = '\0';
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp31_ = move;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp32_ = i;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp27_ = _tmp33_ <= 'h';
#line 7661 "chess-game.c"
			} else {
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp27_ = FALSE;
#line 7665 "chess-game.c"
			}
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp34_ = _tmp27_;
#line 1118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp34_) {
#line 7671 "chess-game.c"
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gint _tmp38_ = 0;
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp35_ = move;
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp36_ = i;
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_f1 = (gint) (_tmp37_ - 'a');
#line 1121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp38_ = i;
#line 1121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp38_ + 1;
#line 7688 "chess-game.c"
			}
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp40_ = move;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp41_ = i;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp42_ = string_get (_tmp40_, (glong) _tmp41_);
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp42_ >= '1') {
#line 7698 "chess-game.c"
				const gchar* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gchar _tmp45_ = '\0';
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp43_ = move;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp44_ = i;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp45_ = string_get (_tmp43_, (glong) _tmp44_);
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp39_ = _tmp45_ <= '8';
#line 7710 "chess-game.c"
			} else {
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp39_ = FALSE;
#line 7714 "chess-game.c"
			}
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp46_ = _tmp39_;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp46_) {
#line 7720 "chess-game.c"
				const gchar* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gchar _tmp49_ = '\0';
				gint _tmp50_ = 0;
#line 1125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp47_ = move;
#line 1125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp48_ = i;
#line 1125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp49_ = string_get (_tmp47_, (glong) _tmp48_);
#line 1125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r1 = (gint) (_tmp49_ - '1');
#line 1126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp50_ = i;
#line 1126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp50_ + 1;
#line 7737 "chess-game.c"
			}
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp52_ = move;
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp53_ = i;
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp54_ = string_get (_tmp52_, (glong) _tmp53_);
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp54_ == 'x') {
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp51_ = TRUE;
#line 7749 "chess-game.c"
			} else {
				const gchar* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gchar _tmp57_ = '\0';
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp55_ = move;
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp56_ = i;
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp57_ = string_get (_tmp55_, (glong) _tmp56_);
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp51_ = _tmp57_ == '-';
#line 7762 "chess-game.c"
			}
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp58_ = _tmp51_;
#line 1128 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp58_) {
#line 7768 "chess-game.c"
				gint _tmp59_ = 0;
#line 1129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp59_ = i;
#line 1129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp59_ + 1;
#line 7774 "chess-game.c"
			}
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp61_ = move;
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp62_ = i;
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp63_ >= 'a') {
#line 7784 "chess-game.c"
				const gchar* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				gchar _tmp66_ = '\0';
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp64_ = move;
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp65_ = i;
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp66_ = string_get (_tmp64_, (glong) _tmp65_);
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp60_ = _tmp66_ <= 'h';
#line 7796 "chess-game.c"
			} else {
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp60_ = FALSE;
#line 7800 "chess-game.c"
			}
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp67_ = _tmp60_;
#line 1130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp67_) {
#line 7806 "chess-game.c"
				gint _tmp68_ = 0;
				const gchar* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				gchar _tmp71_ = '\0';
				gint _tmp72_ = 0;
#line 1132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp68_ = _vala_f1;
#line 1132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_f0 = _tmp68_;
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp69_ = move;
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp70_ = i;
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp71_ = string_get (_tmp69_, (glong) _tmp70_);
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_f1 = (gint) (_tmp71_ - 'a');
#line 1134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp72_ = i;
#line 1134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp72_ + 1;
#line 7828 "chess-game.c"
			}
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp74_ = move;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp75_ = i;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp76_ = string_get (_tmp74_, (glong) _tmp75_);
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp76_ >= '1') {
#line 7838 "chess-game.c"
				const gchar* _tmp77_ = NULL;
				gint _tmp78_ = 0;
				gchar _tmp79_ = '\0';
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp77_ = move;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp78_ = i;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp73_ = _tmp79_ <= '8';
#line 7850 "chess-game.c"
			} else {
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp73_ = FALSE;
#line 7854 "chess-game.c"
			}
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp80_ = _tmp73_;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp80_) {
#line 7860 "chess-game.c"
				gint _tmp81_ = 0;
				const gchar* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gchar _tmp84_ = '\0';
				gint _tmp85_ = 0;
#line 1138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp81_ = _vala_r1;
#line 1138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r0 = _tmp81_;
#line 1139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp82_ = move;
#line 1139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp83_ = i;
#line 1139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp84_ = string_get (_tmp82_, (glong) _tmp83_);
#line 1139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r1 = (gint) (_tmp84_ - '1');
#line 1140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp85_ = i;
#line 1140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp85_ + 1;
#line 7882 "chess-game.c"
			}
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp86_ = move;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp87_ = i;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp88_ = string_get (_tmp86_, (glong) _tmp87_);
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp88_ == '=') {
#line 7892 "chess-game.c"
				gint _tmp89_ = 0;
				const gchar* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gchar _tmp92_ = '\0';
				PieceType _tmp93_ = 0;
				gboolean _tmp94_ = FALSE;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp89_ = i;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				i = _tmp89_ + 1;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp90_ = move;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp91_ = i;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp92_ = string_get (_tmp90_, (glong) _tmp91_);
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp94_ = chess_state_decode_piece_type (self, (gunichar) _tmp92_, &_tmp93_);
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_promotion_type = _tmp93_;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp94_) {
#line 7915 "chess-game.c"
					gint _tmp95_ = 0;
#line 1146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp95_ = i;
#line 1146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					i = _tmp95_ + 1;
#line 7921 "chess-game.c"
				}
			} else {
				const gchar* _tmp96_ = NULL;
				gint _tmp97_ = 0;
				gchar _tmp98_ = '\0';
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp96_ = move;
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp97_ = i;
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp98_ = string_get (_tmp96_, (glong) _tmp97_);
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp98_ != '\0') {
#line 7935 "chess-game.c"
					const gchar* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					gchar _tmp101_ = '\0';
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp99_ = move;
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp100_ = i;
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp101_ = string_get (_tmp99_, (glong) _tmp100_);
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					switch (_tmp101_) {
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'q':
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'Q':
#line 7951 "chess-game.c"
						{
							gint _tmp102_ = 0;
#line 1154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 1155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp102_ = i;
#line 1155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							i = _tmp102_ + 1;
#line 1156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							break;
#line 7962 "chess-game.c"
						}
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'n':
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'N':
#line 7968 "chess-game.c"
						{
							gint _tmp103_ = 0;
#line 1159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
#line 1160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp103_ = i;
#line 1160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							i = _tmp103_ + 1;
#line 1161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							break;
#line 7979 "chess-game.c"
						}
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'r':
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'R':
#line 7985 "chess-game.c"
						{
							gint _tmp104_ = 0;
#line 1164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_vala_promotion_type = PIECE_TYPE_ROOK;
#line 1165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp104_ = i;
#line 1165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							i = _tmp104_ + 1;
#line 1166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							break;
#line 7996 "chess-game.c"
						}
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'b':
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						case 'B':
#line 8002 "chess-game.c"
						{
							gint _tmp105_ = 0;
#line 1169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_vala_promotion_type = PIECE_TYPE_BISHOP;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp105_ = i;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							i = _tmp105_ + 1;
#line 1171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							break;
#line 8013 "chess-game.c"
						}
						default:
#line 1150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						break;
#line 8018 "chess-game.c"
					}
				}
			}
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp107_ = _vala_r1;
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp107_ < 0) {
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp106_ = TRUE;
#line 8028 "chess-game.c"
			} else {
				gint _tmp108_ = 0;
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp108_ = _vala_f1;
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp106_ = _tmp108_ < 0;
#line 8035 "chess-game.c"
			}
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp109_ = _tmp106_;
#line 1176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp109_) {
#line 8041 "chess-game.c"
				const gchar* _tmp110_ = NULL;
#line 1178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp110_ = move;
#line 1178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				g_debug ("chess-game.vala:1178: Move %s missing destination", _tmp110_);
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				result = FALSE;
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (r0) {
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					*r0 = _vala_r0;
#line 8053 "chess-game.c"
				}
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (f0) {
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					*f0 = _vala_f0;
#line 8059 "chess-game.c"
				}
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (r1) {
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					*r1 = _vala_r1;
#line 8065 "chess-game.c"
				}
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (f1) {
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					*f1 = _vala_f1;
#line 8071 "chess-game.c"
				}
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (promotion_type) {
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					*promotion_type = _vala_promotion_type;
#line 8077 "chess-game.c"
				}
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				return result;
#line 8081 "chess-game.c"
			}
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp112_ = _vala_r0;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp112_ < 0) {
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp111_ = TRUE;
#line 8089 "chess-game.c"
			} else {
				gint _tmp113_ = 0;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp113_ = _vala_f0;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp111_ = _tmp113_ < 0;
#line 8096 "chess-game.c"
			}
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp114_ = _tmp111_;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			if (_tmp114_) {
#line 8102 "chess-game.c"
				gint match_rank = 0;
				gint match_file = 0;
				gint _tmp159_ = 0;
				gint _tmp161_ = 0;
				gint _tmp162_ = 0;
#line 1185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				match_rank = -1;
#line 1185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				match_file = -1;
#line 8112 "chess-game.c"
				{
					gint file = 0;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					file = 0;
#line 8117 "chess-game.c"
					{
						gboolean _tmp115_ = FALSE;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp115_ = TRUE;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						while (TRUE) {
#line 8124 "chess-game.c"
							gboolean _tmp116_ = FALSE;
							gint _tmp118_ = 0;
							gboolean _tmp119_ = FALSE;
							gint _tmp120_ = 0;
							gboolean _tmp123_ = FALSE;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp116_ = _tmp115_;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!_tmp116_) {
#line 8134 "chess-game.c"
								gint _tmp117_ = 0;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp117_ = file;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								file = _tmp117_ + 1;
#line 8140 "chess-game.c"
							}
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp115_ = FALSE;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp118_ = file;
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (!(_tmp118_ < 8)) {
#line 1187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								break;
#line 8150 "chess-game.c"
							}
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp120_ = _vala_f0;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp120_ >= 0) {
#line 8156 "chess-game.c"
								gint _tmp121_ = 0;
								gint _tmp122_ = 0;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp121_ = file;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp122_ = _vala_f0;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp119_ = _tmp121_ != _tmp122_;
#line 8165 "chess-game.c"
							} else {
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								_tmp119_ = FALSE;
#line 8169 "chess-game.c"
							}
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							_tmp123_ = _tmp119_;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
							if (_tmp123_) {
#line 1190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								continue;
#line 8177 "chess-game.c"
							}
							{
								gint rank = 0;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
								rank = 0;
#line 8183 "chess-game.c"
								{
									gboolean _tmp124_ = FALSE;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									_tmp124_ = TRUE;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
									while (TRUE) {
#line 8190 "chess-game.c"
										gboolean _tmp125_ = FALSE;
										gint _tmp127_ = 0;
										gboolean _tmp128_ = FALSE;
										gint _tmp129_ = 0;
										gboolean _tmp132_ = FALSE;
										ChessPiece* piece = NULL;
										gint _tmp133_ = 0;
										gint _tmp134_ = 0;
										gint _tmp135_ = 0;
										ChessPiece* _tmp136_ = NULL;
										ChessPiece* _tmp137_ = NULL;
										gboolean _tmp138_ = FALSE;
										gboolean _tmp139_ = FALSE;
										ChessPiece* _tmp140_ = NULL;
										gboolean _tmp144_ = FALSE;
										gboolean _tmp148_ = FALSE;
										ChessPlayer* _tmp149_ = NULL;
										gint _tmp150_ = 0;
										gint _tmp151_ = 0;
										gint _tmp152_ = 0;
										gint _tmp153_ = 0;
										gboolean _tmp154_ = FALSE;
										gint _tmp155_ = 0;
										gint _tmp157_ = 0;
										gint _tmp158_ = 0;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp125_ = _tmp124_;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (!_tmp125_) {
#line 8220 "chess-game.c"
											gint _tmp126_ = 0;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp126_ = rank;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											rank = _tmp126_ + 1;
#line 8226 "chess-game.c"
										}
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp124_ = FALSE;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp127_ = rank;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (!(_tmp127_ < 8)) {
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											break;
#line 8236 "chess-game.c"
										}
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp129_ = _vala_r0;
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp129_ >= 0) {
#line 8242 "chess-game.c"
											gint _tmp130_ = 0;
											gint _tmp131_ = 0;
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp130_ = rank;
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp131_ = _vala_r0;
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp128_ = _tmp130_ != _tmp131_;
#line 8251 "chess-game.c"
										} else {
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp128_ = FALSE;
#line 8255 "chess-game.c"
										}
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp132_ = _tmp128_;
#line 1194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp132_) {
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											continue;
#line 8263 "chess-game.c"
										}
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp133_ = rank;
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp134_ = file;
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp135_ = chess_state_get_index (self, _tmp133_, _tmp134_);
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp136_ = self->board[_tmp135_];
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp137_ = _chess_piece_ref0 (_tmp136_);
#line 1198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										piece = _tmp137_;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp140_ = piece;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp140_ == NULL) {
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp139_ = TRUE;
#line 8283 "chess-game.c"
										} else {
											ChessPiece* _tmp141_ = NULL;
											PieceType _tmp142_ = 0;
											PieceType _tmp143_ = 0;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp141_ = piece;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp142_ = _tmp141_->type;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp143_ = type;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp139_ = _tmp142_ != _tmp143_;
#line 8296 "chess-game.c"
										}
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp144_ = _tmp139_;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp144_) {
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp138_ = TRUE;
#line 8304 "chess-game.c"
										} else {
											ChessPiece* _tmp145_ = NULL;
											ChessPlayer* _tmp146_ = NULL;
											ChessPlayer* _tmp147_ = NULL;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp145_ = piece;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp146_ = _tmp145_->player;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp147_ = player;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp138_ = _tmp146_ != _tmp147_;
#line 8317 "chess-game.c"
										}
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp148_ = _tmp138_;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp148_) {
#line 1200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_chess_piece_unref0 (piece);
#line 1200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											continue;
#line 8327 "chess-game.c"
										}
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp149_ = player;
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp150_ = rank;
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp151_ = file;
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp152_ = _vala_r1;
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp153_ = _vala_f1;
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp154_ = chess_state_move_with_coords (self, _tmp149_, _tmp150_, _tmp151_, _tmp152_, _tmp153_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 1203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (!_tmp154_) {
#line 1204 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_chess_piece_unref0 (piece);
#line 1204 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											continue;
#line 8347 "chess-game.c"
										}
#line 1207 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp155_ = match_rank;
#line 1207 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										if (_tmp155_ >= 0) {
#line 8353 "chess-game.c"
											const gchar* _tmp156_ = NULL;
#line 1209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_tmp156_ = move;
#line 1209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											g_debug ("chess-game.vala:1209: Move %s is ambiguous", _tmp156_);
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											result = FALSE;
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											_chess_piece_unref0 (piece);
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											if (r0) {
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
												*r0 = _vala_r0;
#line 8367 "chess-game.c"
											}
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											if (f0) {
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
												*f0 = _vala_f0;
#line 8373 "chess-game.c"
											}
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											if (r1) {
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
												*r1 = _vala_r1;
#line 8379 "chess-game.c"
											}
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											if (f1) {
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
												*f1 = _vala_f1;
#line 8385 "chess-game.c"
											}
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											if (promotion_type) {
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
												*promotion_type = _vala_promotion_type;
#line 8391 "chess-game.c"
											}
#line 1210 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
											return result;
#line 8395 "chess-game.c"
										}
#line 1213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp157_ = rank;
#line 1213 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										match_rank = _tmp157_;
#line 1214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_tmp158_ = file;
#line 1214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										match_file = _tmp158_;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
										_chess_piece_unref0 (piece);
#line 8407 "chess-game.c"
									}
								}
							}
						}
					}
				}
#line 1218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp159_ = match_rank;
#line 1218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp159_ < 0) {
#line 8418 "chess-game.c"
					const gchar* _tmp160_ = NULL;
#line 1220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp160_ = move;
#line 1220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					g_debug ("chess-game.vala:1220: Move %s has no matches", _tmp160_);
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = FALSE;
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (r0) {
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						*r0 = _vala_r0;
#line 8430 "chess-game.c"
					}
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (f0) {
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						*f0 = _vala_f0;
#line 8436 "chess-game.c"
					}
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (r1) {
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						*r1 = _vala_r1;
#line 8442 "chess-game.c"
					}
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (f1) {
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						*f1 = _vala_f1;
#line 8448 "chess-game.c"
					}
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (promotion_type) {
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						*promotion_type = _vala_promotion_type;
#line 8454 "chess-game.c"
					}
#line 1221 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 8458 "chess-game.c"
				}
#line 1224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp161_ = match_rank;
#line 1224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_r0 = _tmp161_;
#line 1225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp162_ = match_file;
#line 1225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_vala_f0 = _tmp162_;
#line 8468 "chess-game.c"
			}
		}
	}
#line 1229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp163_ = move;
#line 1229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp164_ = i;
#line 1229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp165_ = string_get (_tmp163_, (glong) _tmp164_);
#line 1229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp165_ == '+') {
#line 8480 "chess-game.c"
		gint _tmp166_ = 0;
#line 1230 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp166_ = i;
#line 1230 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		i = _tmp166_ + 1;
#line 8486 "chess-game.c"
	} else {
		const gchar* _tmp167_ = NULL;
		gint _tmp168_ = 0;
		gchar _tmp169_ = '\0';
#line 1231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp167_ = move;
#line 1231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp168_ = i;
#line 1231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp169_ = string_get (_tmp167_, (glong) _tmp168_);
#line 1231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp169_ == '#') {
#line 8499 "chess-game.c"
			gint _tmp170_ = 0;
#line 1232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp170_ = i;
#line 1232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			i = _tmp170_ + 1;
#line 8505 "chess-game.c"
		}
	}
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp171_ = move;
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp172_ = i;
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp173_ = string_get (_tmp171_, (glong) _tmp172_);
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp173_ != '\0') {
#line 8516 "chess-game.c"
		const gchar* _tmp174_ = NULL;
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp174_ = move;
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_debug ("chess-game.vala:1236: Move %s has unexpected characters", _tmp174_);
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (r0) {
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*r0 = _vala_r0;
#line 8528 "chess-game.c"
		}
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (f0) {
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*f0 = _vala_f0;
#line 8534 "chess-game.c"
		}
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (r1) {
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*r1 = _vala_r1;
#line 8540 "chess-game.c"
		}
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (f1) {
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*f1 = _vala_f1;
#line 8546 "chess-game.c"
		}
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (promotion_type) {
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			*promotion_type = _vala_promotion_type;
#line 8552 "chess-game.c"
		}
#line 1237 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 8556 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (r0) {
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*r0 = _vala_r0;
#line 8564 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (f0) {
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*f0 = _vala_f0;
#line 8570 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (r1) {
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*r1 = _vala_r1;
#line 8576 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (f1) {
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*f1 = _vala_f1;
#line 8582 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (promotion_type) {
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*promotion_type = _vala_promotion_type;
#line 8588 "chess-game.c"
	}
#line 1240 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 8592 "chess-game.c"
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	ChessPlayer* _tmp5_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->current_player;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 8610 "chess-game.c"
		ChessPlayer* _tmp3_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp3_;
#line 8616 "chess-game.c"
	} else {
		ChessPlayer* _tmp4_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp4_;
#line 8623 "chess-game.c"
	}
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _tmp0_;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp5_;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 8631 "chess-game.c"
}


static void value_chess_state_init (GValue* value) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	value->data[0].v_pointer = NULL;
#line 8638 "chess-game.c"
}


static void value_chess_state_free_value (GValue* value) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (value->data[0].v_pointer) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_state_unref (value->data[0].v_pointer);
#line 8647 "chess-game.c"
	}
}


static void value_chess_state_copy_value (const GValue* src_value, GValue* dest_value) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (src_value->data[0].v_pointer) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = chess_state_ref (src_value->data[0].v_pointer);
#line 8657 "chess-game.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8661 "chess-game.c"
	}
}


static gpointer value_chess_state_peek_pointer (const GValue* value) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 8669 "chess-game.c"
}


static gchar* value_chess_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (collect_values[0].v_pointer) {
#line 8676 "chess-game.c"
		ChessState* object;
		object = collect_values[0].v_pointer;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8683 "chess-game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8687 "chess-game.c"
		}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = chess_state_ref (object);
#line 8691 "chess-game.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 8695 "chess-game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 8699 "chess-game.c"
}


static gchar* value_chess_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessState** object_p;
	object_p = collect_values[0].v_pointer;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!object_p) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8710 "chess-game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!value->data[0].v_pointer) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = NULL;
#line 8716 "chess-game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = value->data[0].v_pointer;
#line 8720 "chess-game.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = chess_state_ref (value->data[0].v_pointer);
#line 8724 "chess-game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 8728 "chess-game.c"
}


GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessState* spec;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_STATE), NULL);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return G_PARAM_SPEC (spec);
#line 8742 "chess-game.c"
}


gpointer value_get_chess_state (const GValue* value) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE), NULL);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 8751 "chess-game.c"
}


void value_set_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_state_ref (value->data[0].v_pointer);
#line 8771 "chess-game.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 8775 "chess-game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_state_unref (old);
#line 8781 "chess-game.c"
	}
}


void value_take_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 8800 "chess-game.c"
	} else {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 8804 "chess-game.c"
	}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_state_unref (old);
#line 8810 "chess-game.c"
	}
}


static void chess_state_class_init (ChessStateClass * klass) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_state_parent_class = g_type_class_peek_parent (klass);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	CHESS_STATE_CLASS (klass)->finalize = chess_state_finalize;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
#line 8822 "chess-game.c"
}


static void chess_state_instance_init (ChessState * self) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv = CHESS_STATE_GET_PRIVATE (self);
#line 291 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->number = 0;
#line 300 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->en_passant_index = -1;
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->last_move = NULL;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->ref_count = 1;
#line 8837 "chess-game.c"
}


static void chess_state_finalize (ChessState* obj) {
	ChessState * self;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->current_player);
#line 304 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_vala_array_destroy (self->board, 64, (GDestroyNotify) chess_piece_unref);
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_move_unref0 (self->last_move);
#line 8853 "chess-game.c"
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_state_init, value_chess_state_free_value, value_chess_state_copy_value, value_chess_state_peek_pointer, "p", value_chess_state_collect_value, "p", value_chess_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


gpointer chess_state_ref (gpointer instance) {
	ChessState* self;
	self = instance;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return instance;
#line 8878 "chess-game.c"
}


void chess_state_unref (gpointer instance) {
	ChessState* self;
	self = instance;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		CHESS_STATE_GET_CLASS (self)->finalize (self);
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8891 "chess-game.c"
	}
}


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _chess_state_unref0_ (gpointer var) {
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	(var == NULL) ? NULL : (var = (chess_state_unref (var), NULL));
#line 8923 "chess-game.c"
}


static void _g_list_free__chess_state_unref0_ (GList* self) {
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_list_foreach (self, (GFunc) _chess_state_unref0_, NULL);
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_list_free (self);
#line 8932 "chess-game.c"
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb (self, _sender, move, apply);
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 8941 "chess-game.c"
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_undo_cb (self, _sender);
#line 8948 "chess-game.c"
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb (self, _sender);
#line 1340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 8957 "chess-game.c"
}


static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_claim_draw_cb (self, _sender);
#line 1341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 8966 "chess-game.c"
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1) {
	ChessGame* self = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ChessPlayer* _tmp17_ = NULL;
	ChessPlayer* _tmp18_ = NULL;
	ChessPlayer* _tmp19_ = NULL;
	ChessPlayer* _tmp20_ = NULL;
	ChessPlayer* _tmp21_ = NULL;
	ChessPlayer* _tmp22_ = NULL;
	ChessPlayer* _tmp23_ = NULL;
	ChessPlayer* _tmp24_ = NULL;
	ChessPlayer* _tmp25_ = NULL;
	ChessPlayer* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	ChessPlayer* _tmp28_ = NULL;
	ChessPlayer* _tmp29_ = NULL;
	ChessPlayer* _tmp30_ = NULL;
	ChessPlayer* _tmp31_ = NULL;
	ChessPlayer* _tmp32_ = NULL;
#line 1323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 1323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = (ChessGame*) g_type_create_instance (object_type);
#line 1325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->is_started = FALSE;
#line 1326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = fen;
#line 1326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_state_new (_tmp0_);
#line 1326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
#line 1327 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->result = CHESS_RESULT_IN_PROGRESS;
#line 1329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = moves;
#line 1329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2__length1 = moves_length1;
#line 1329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 9012 "chess-game.c"
		{
			gint i = 0;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			i = 0;
#line 9017 "chess-game.c"
			{
				gboolean _tmp3_ = FALSE;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = TRUE;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				while (TRUE) {
#line 9024 "chess-game.c"
					gboolean _tmp4_ = FALSE;
					gint _tmp6_ = 0;
					gchar** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					ChessPlayer* _tmp8_ = NULL;
					ChessPlayer* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp11_ = 0;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp4_ = _tmp3_;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp4_) {
#line 9040 "chess-game.c"
						gint _tmp5_ = 0;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp5_ = i;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						i = _tmp5_ + 1;
#line 9046 "chess-game.c"
					}
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp3_ = FALSE;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp6_ = i;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = moves;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7__length1 = moves_length1;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!(_tmp6_ < _tmp7__length1)) {
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						break;
#line 9060 "chess-game.c"
					}
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp8_ = chess_game_get_current_player (self);
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = _tmp8_;
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp10_ = moves;
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp10__length1 = moves_length1;
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp11_ = i;
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp12_ = _tmp10_[_tmp11_];
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp13_ = chess_game_do_move (self, _tmp9_, _tmp12_, TRUE);
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					if (!_tmp13_) {
#line 9078 "chess-game.c"
						gchar** _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						gint _tmp15_ = 0;
						const gchar* _tmp16_ = NULL;
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp14_ = moves;
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp14__length1 = moves_length1;
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp15_ = i;
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						_tmp16_ = _tmp14_[_tmp15_];
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
						g_warning ("chess-game.vala:1334: Invalid move %s", _tmp16_);
#line 9093 "chess-game.c"
					}
				}
			}
		}
	}
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = chess_game_get_white (self);
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp18_ = _tmp17_;
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp18_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp19_ = chess_game_get_white (self);
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp20_ = _tmp19_;
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp20_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
#line 1340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp21_ = chess_game_get_white (self);
#line 1340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = _tmp21_;
#line 1340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp22_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
#line 1341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_ = chess_game_get_white (self);
#line 1341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp24_ = _tmp23_;
#line 1341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp24_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
#line 1342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp25_ = chess_game_get_black (self);
#line 1342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_ = _tmp25_;
#line 1342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp26_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self);
#line 1343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp27_ = chess_game_get_black (self);
#line 1343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp28_ = _tmp27_;
#line 1343 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp28_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self);
#line 1344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp29_ = chess_game_get_black (self);
#line 1344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp30_ = _tmp29_;
#line 1344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp30_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self);
#line 1345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp31_ = chess_game_get_black (self);
#line 1345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp32_ = _tmp31_;
#line 1345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_connect (_tmp32_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self);
#line 1323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self;
#line 9149 "chess-game.c"
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1) {
#line 1323 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1);
#line 9156 "chess-game.c"
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 1354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 1354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 1356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp0_) {
#line 1357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9181 "chess-game.c"
	}
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = player;
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = move;
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = apply;
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp4_;
#line 1359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 9195 "chess-game.c"
}


static gpointer _chess_state_ref0 (gpointer self) {
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return self ? chess_state_ref (self) : NULL;
#line 9202 "chess-game.c"
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessState* state = NULL;
	ChessState* _tmp3_ = NULL;
	ChessState* _tmp4_ = NULL;
	ChessState* _tmp5_ = NULL;
	ChessState* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	ChessState* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ChessState* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	ChessState* _tmp15_ = NULL;
	ChessMove* _tmp16_ = NULL;
	ChessPiece* _tmp17_ = NULL;
	ChessState* _tmp21_ = NULL;
	ChessMove* _tmp22_ = NULL;
	ChessPiece* _tmp23_ = NULL;
	ChessState* _tmp24_ = NULL;
	ChessMove* _tmp25_ = NULL;
	ChessPiece* _tmp26_ = NULL;
	ChessState* _tmp30_ = NULL;
	ChessMove* _tmp31_ = NULL;
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 1364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = player;
#line 1364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 1364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 1364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ != _tmp2_) {
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9251 "chess-game.c"
	}
#line 1367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = chess_game_get_current_state (self);
#line 1367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = _tmp3_;
#line 1367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = chess_state_copy (_tmp4_);
#line 1367 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	state = _tmp5_;
#line 1368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = state;
#line 1368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = _tmp6_->number;
#line 1368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_->number = _tmp7_ + 1;
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = state;
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = move;
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = apply;
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp11_) {
#line 1370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_state_unref0 (state);
#line 1370 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9283 "chess-game.c"
	}
#line 1372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = apply;
#line 1372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp12_) {
#line 1373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = TRUE;
#line 1373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_chess_state_unref0 (state);
#line 1373 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9295 "chess-game.c"
	}
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = state;
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = _chess_state_ref0 (_tmp13_);
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp15_ = state;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp16_ = _tmp15_->last_move;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp17_ = _tmp16_->victim;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp17_ != NULL) {
#line 9311 "chess-game.c"
		ChessState* _tmp18_ = NULL;
		ChessMove* _tmp19_ = NULL;
		ChessPiece* _tmp20_ = NULL;
#line 1377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp18_ = state;
#line 1377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp19_ = _tmp18_->last_move;
#line 1377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp20_ = _tmp19_->victim;
#line 1377 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_emit_by_name (_tmp20_, "died");
#line 9323 "chess-game.c"
	}
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp21_ = state;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp22_ = _tmp21_->last_move;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp23_ = _tmp22_->piece;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (_tmp23_, "moved");
#line 1379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp24_ = state;
#line 1379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp25_ = _tmp24_->last_move;
#line 1379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp26_ = _tmp25_->moved_rook;
#line 1379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp26_ != NULL) {
#line 9341 "chess-game.c"
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		ChessPiece* _tmp29_ = NULL;
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp27_ = state;
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp28_ = _tmp27_->last_move;
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp29_ = _tmp28_->moved_rook;
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_emit_by_name (_tmp29_, "moved");
#line 9353 "chess-game.c"
	}
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp30_ = state;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp31_ = _tmp30_->last_move;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "moved", _tmp31_);
#line 1382 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_complete_move (self);
#line 1384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 1384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_state_unref0 (state);
#line 1384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 9369 "chess-game.c"
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_ = 0;
#line 1387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1389 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 1389 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->hold_count = _tmp0_ + 1;
#line 9381 "chess-game.c"
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 1394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (_tmp0_ > 0);
#line 1396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->priv->hold_count;
#line 1396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->hold_count = _tmp1_ - 1;
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = self->priv->hold_count;
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == 0) {
#line 1398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_complete_move (self);
#line 9405 "chess-game.c"
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_ = 0;
	ChessRule rule = 0;
	ChessResult _result_ = 0;
	ChessState* _tmp1_ = NULL;
	ChessState* _tmp2_ = NULL;
	ChessRule _tmp3_ = 0;
	ChessResult _tmp4_ = 0;
	ChessResult _tmp5_ = 0;
#line 1401 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ > 0) {
#line 1405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9427 "chess-game.c"
	}
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_game_get_current_state (self);
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = chess_state_get_result (_tmp2_, &_tmp3_);
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	rule = _tmp3_;
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_result_ = _tmp4_;
#line 1409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _result_;
#line 1409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp5_ != CHESS_RESULT_IN_PROGRESS) {
#line 9443 "chess-game.c"
		ChessResult _tmp6_ = 0;
		ChessRule _tmp7_ = 0;
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = _result_;
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp7_ = rule;
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, _tmp6_, _tmp7_);
#line 9452 "chess-game.c"
	} else {
		ChessClock* _tmp8_ = NULL;
		ChessPlayer* _tmp13_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		ChessPlayer* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = self->priv->_clock;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp8_ != NULL) {
#line 9463 "chess-game.c"
			ChessClock* _tmp9_ = NULL;
			ChessPlayer* _tmp10_ = NULL;
			ChessPlayer* _tmp11_ = NULL;
			Color _tmp12_ = 0;
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp9_ = self->priv->_clock;
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp10_ = chess_game_get_current_player (self);
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp11_ = _tmp10_;
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp12_ = _tmp11_->color;
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			chess_clock_set_active_color (_tmp9_, _tmp12_);
#line 9478 "chess-game.c"
		}
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp13_ = chess_game_get_current_player (self);
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp14_ = _tmp13_;
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_emit_by_name (_tmp14_, "start-turn");
#line 1418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp15_ = chess_game_get_current_player (self);
#line 1418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp16_ = _tmp15_;
#line 1418 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_emit_by_name (self, "turn-started", _tmp16_);
#line 9492 "chess-game.c"
	}
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
#line 1422 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1422 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (player != NULL);
#line 1425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = player;
#line 1425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 1425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 1425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ == _tmp2_) {
#line 9516 "chess-game.c"
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
#line 1426 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = chess_game_get_opponent (self);
#line 1426 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = _tmp3_;
#line 1426 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_undo_cb (self, _tmp4_);
#line 9525 "chess-game.c"
	}
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = _tmp5_->next;
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp6_ == NULL) {
#line 1430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9535 "chess-game.c"
	}
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = self->move_stack;
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
#line 1434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "undo");
#line 9543 "chess-game.c"
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
#line 1437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 1439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1439 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp0_) {
#line 1440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9564 "chess-game.c"
	}
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = player;
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 1443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
#line 9574 "chess-game.c"
	} else {
#line 1445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
#line 9578 "chess-game.c"
	}
#line 1447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 1447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 9584 "chess-game.c"
}


static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessState* _tmp1_ = NULL;
	ChessState* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 1450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 1452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp0_) {
#line 1453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		result = FALSE;
#line 1453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return result;
#line 9606 "chess-game.c"
	}
#line 1455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = chess_game_get_current_state (self);
#line 1455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 1455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = _tmp2_->halfmove_clock;
#line 1455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp3_ >= 100) {
#line 1456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
#line 9618 "chess-game.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 1457 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = chess_game_is_three_fold_repeat (self);
#line 1457 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (_tmp4_) {
#line 1458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
#line 9627 "chess-game.c"
		} else {
#line 1460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			result = FALSE;
#line 1460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return result;
#line 9633 "chess-game.c"
		}
	}
#line 1462 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = TRUE;
#line 1462 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 9640 "chess-game.c"
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
#line 1476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_clock_expired_cb (self, _sender);
#line 9647 "chess-game.c"
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessPlayer* _tmp11_ = NULL;
#line 1465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->result;
#line 1467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
#line 1468 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9667 "chess-game.c"
	}
#line 1470 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = self->is_started;
#line 1470 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp1_) {
#line 1471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9675 "chess-game.c"
	}
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->is_started = TRUE;
#line 1474 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = self->priv->_clock;
#line 1474 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 9683 "chess-game.c"
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
#line 1476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = self->priv->_clock;
#line 1476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_connect (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self);
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp5_ = chess_game_get_current_player (self);
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = _tmp5_;
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp7_ = _tmp6_->color;
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_clock_set_active_color (_tmp4_, _tmp7_);
#line 9703 "chess-game.c"
	}
#line 1480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "started");
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = chess_game_get_current_player (self);
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _tmp8_;
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (_tmp9_, "start-turn");
#line 1482 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = chess_game_get_current_player (self);
#line 1482 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = _tmp10_;
#line 1482 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "turn-started", _tmp11_);
#line 9719 "chess-game.c"
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
#line 1485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (clock != NULL);
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_game_get_current_player (self);
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 1488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
#line 9741 "chess-game.c"
	} else {
#line 1490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
#line 9745 "chess-game.c"
	}
}


void chess_game_abandon (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
#line 1493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1495 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1495 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp0_) {
#line 1496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9760 "chess-game.c"
	}
#line 1497 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_ABANDONMENT);
#line 9764 "chess-game.c"
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_ = 0;
	ChessState* state = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	ChessState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ChessPiece* _tmp13_ = NULL;
	ChessPiece* _tmp14_ = NULL;
#line 1500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = move_number;
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ < 0) {
#line 9789 "chess-game.c"
		gint _tmp1_ = 0;
		GList* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 1503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = move_number;
#line 1503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp2_ = self->move_stack;
#line 1503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp3_ = g_list_length (_tmp2_);
#line 1503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		move_number = _tmp1_ + ((gint) _tmp3_);
#line 9801 "chess-game.c"
	}
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp4_ = self->move_stack;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp6_ = g_list_length (_tmp5_);
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = move_number;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp9_ = _chess_state_ref0 ((ChessState*) _tmp8_);
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	state = _tmp9_;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp10_ = rank;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp11_ = file;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp13_ = state->board[_tmp12_];
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp14_ = _chess_piece_ref0 (_tmp13_);
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp14_;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_chess_state_unref0 (state);
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 9833 "chess-game.c"
}


void chess_game_pause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 9852 "chess-game.c"
		ChessResult _tmp4_ = 0;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->result;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 9858 "chess-game.c"
	} else {
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = FALSE;
#line 9862 "chess-game.c"
	}
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _tmp1_;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp5_) {
#line 9868 "chess-game.c"
		gboolean _tmp6_ = FALSE;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = self->priv->_is_paused;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = !_tmp6_;
#line 9874 "chess-game.c"
	} else {
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = FALSE;
#line 9878 "chess-game.c"
	}
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = _tmp0_;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp7_) {
#line 9884 "chess-game.c"
		ChessClock* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
#line 1519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = chess_game_get_clock (self);
#line 1519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = _tmp8_;
#line 1519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_clock_pause (_tmp9_);
#line 1520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_set_is_paused (self, TRUE);
#line 9895 "chess-game.c"
	}
}


void chess_game_superpause (ChessGame* self) {
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_set_is_superpaused (self, TRUE);
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_pause (self);
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "superpaused");
#line 9909 "chess-game.c"
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 9928 "chess-game.c"
		ChessResult _tmp4_ = 0;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->result;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 9934 "chess-game.c"
	} else {
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = FALSE;
#line 9938 "chess-game.c"
	}
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp5_ = _tmp1_;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp5_) {
#line 9944 "chess-game.c"
		gboolean _tmp6_ = FALSE;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp6_ = self->priv->_is_paused;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = _tmp6_;
#line 9950 "chess-game.c"
	} else {
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp0_ = FALSE;
#line 9954 "chess-game.c"
	}
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp7_ = _tmp0_;
#line 1534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp7_) {
#line 9960 "chess-game.c"
		ChessClock* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp8_ = chess_game_get_clock (self);
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp9_ = _tmp8_;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_clock_unpause (_tmp9_);
#line 1537 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_set_is_paused (self, FALSE);
#line 1538 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_set_is_superpaused (self, FALSE);
#line 1539 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_signal_emit_by_name (self, "unpaused");
#line 9975 "chess-game.c"
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_ = FALSE;
	ChessResult _tmp1_ = 0;
	ChessRule _tmp2_ = 0;
	ChessClock* _tmp3_ = NULL;
#line 1543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!_tmp0_) {
#line 1546 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 9993 "chess-game.c"
	}
#line 1547 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _result_;
#line 1547 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->result = _tmp1_;
#line 1548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = rule;
#line 1548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->rule = _tmp2_;
#line 1549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->is_started = FALSE;
#line 1550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = self->priv->_clock;
#line 1550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 10009 "chess-game.c"
		ChessClock* _tmp4_ = NULL;
#line 1551 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 1551 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_clock_stop (_tmp4_);
#line 10015 "chess-game.c"
	}
#line 1552 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_emit_by_name (self, "ended");
#line 10019 "chess-game.c"
}


static gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
#line 1555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 10030 "chess-game.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		state_collection = _tmp0_;
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 10038 "chess-game.c"
			ChessState* _tmp1_ = NULL;
			ChessState* state = NULL;
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp1_ = _chess_state_ref0 ((ChessState*) state_it->data);
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			state = _tmp1_;
#line 10045 "chess-game.c"
			{
				ChessState* _tmp2_ = NULL;
				gint _tmp3_ = 0;
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp2_ = state;
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp3_ >= 3) {
#line 1560 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					result = TRUE;
#line 1560 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_chess_state_unref0 (state);
#line 1560 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					return result;
#line 10061 "chess-game.c"
				}
#line 1557 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_state_unref0 (state);
#line 10065 "chess-game.c"
			}
		}
	}
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = FALSE;
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10073 "chess-game.c"
}


gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_ = NULL;
#line 1566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (s1 != NULL, 0);
#line 1568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	count = 1;
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 10089 "chess-game.c"
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		s2_collection = _tmp0_;
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
#line 10097 "chess-game.c"
			ChessState* _tmp1_ = NULL;
			ChessState* s2 = NULL;
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			_tmp1_ = _chess_state_ref0 ((ChessState*) s2_it->data);
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			s2 = _tmp1_;
#line 10104 "chess-game.c"
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_ = NULL;
				ChessState* _tmp4_ = NULL;
				gboolean _tmp8_ = FALSE;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp3_ = s1;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp4_ = s2;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp3_ != _tmp4_) {
#line 10116 "chess-game.c"
					ChessState* _tmp5_ = NULL;
					ChessState* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp5_ = s1;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp6_ = s2;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp2_ = _tmp7_;
#line 10128 "chess-game.c"
				} else {
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp2_ = FALSE;
#line 10132 "chess-game.c"
				}
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_tmp8_ = _tmp2_;
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				if (_tmp8_) {
#line 10138 "chess-game.c"
					gint _tmp9_ = 0;
#line 1573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					_tmp9_ = count;
#line 1573 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
					count = _tmp9_ + 1;
#line 10144 "chess-game.c"
				}
#line 1570 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
				_chess_state_unref0 (s2);
#line 10148 "chess-game.c"
			}
		}
	}
#line 1576 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = count;
#line 1576 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10156 "chess-game.c"
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->_is_paused;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10171 "chess-game.c"
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = value;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_is_paused = _tmp0_;
#line 10183 "chess-game.c"
}


gboolean chess_game_get_is_superpaused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->_is_superpaused;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10198 "chess-game.c"
}


static void chess_game_set_is_superpaused (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = value;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_is_superpaused = _tmp0_;
#line 10210 "chess-game.c"
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_->data;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = (ChessState*) _tmp1_;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10228 "chess-game.c"
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp2_;
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10249 "chess-game.c"
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp2_;
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10270 "chess-game.c"
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _tmp1_->current_player;
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp2_;
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10291 "chess-game.c"
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = chess_state_get_opponent (_tmp1_);
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp3_;
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10315 "chess-game.c"
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_ = NULL;
#line 1314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 1314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp0_;
#line 1314 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10330 "chess-game.c"
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_ = FALSE;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
#line 1315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 1317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->is_started;
#line 1317 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_) {
#line 1318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return;
#line 10346 "chess-game.c"
	}
#line 1319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = value;
#line 1319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->priv->_clock);
#line 1319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_clock = _tmp2_;
#line 10356 "chess-game.c"
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	result = _tmp1_ - 1;
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return result;
#line 10374 "chess-game.c"
}


static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__CHESS_MOVE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__CHESS_MOVE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (n_param_values == 2);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = closure->data;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 10393 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		data2 = closure->data;
#line 10399 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	callback = (GMarshalFunc_VOID__CHESS_MOVE) (marshal_data ? marshal_data : cc->callback);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	callback (data1, value_get_chess_move (param_values + 1), data2);
#line 10405 "chess-game.c"
}


static void value_chess_game_init (GValue* value) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	value->data[0].v_pointer = NULL;
#line 10412 "chess-game.c"
}


static void value_chess_game_free_value (GValue* value) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (value->data[0].v_pointer) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_unref (value->data[0].v_pointer);
#line 10421 "chess-game.c"
	}
}


static void value_chess_game_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (src_value->data[0].v_pointer) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = chess_game_ref (src_value->data[0].v_pointer);
#line 10431 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 10435 "chess-game.c"
	}
}


static gpointer value_chess_game_peek_pointer (const GValue* value) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 10443 "chess-game.c"
}


static gchar* value_chess_game_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (collect_values[0].v_pointer) {
#line 10450 "chess-game.c"
		ChessGame* object;
		object = collect_values[0].v_pointer;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10457 "chess-game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10461 "chess-game.c"
		}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = chess_game_ref (object);
#line 10465 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 10469 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 10473 "chess-game.c"
}


static gchar* value_chess_game_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessGame** object_p;
	object_p = collect_values[0].v_pointer;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!object_p) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 10484 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (!value->data[0].v_pointer) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = NULL;
#line 10490 "chess-game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = value->data[0].v_pointer;
#line 10494 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		*object_p = chess_game_ref (value->data[0].v_pointer);
#line 10498 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return NULL;
#line 10502 "chess-game.c"
}


GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessGame* spec;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_GAME), NULL);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return G_PARAM_SPEC (spec);
#line 10516 "chess-game.c"
}


gpointer value_get_chess_game (const GValue* value) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME), NULL);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return value->data[0].v_pointer;
#line 10525 "chess-game.c"
}


void value_set_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_ref (value->data[0].v_pointer);
#line 10545 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 10549 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_unref (old);
#line 10555 "chess-game.c"
	}
}


void value_take_chess_game (GValue* value, gpointer v_object) {
	ChessGame* old;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_GAME));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	old = value->data[0].v_pointer;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (v_object) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_GAME));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = v_object;
#line 10574 "chess-game.c"
	} else {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		value->data[0].v_pointer = NULL;
#line 10578 "chess-game.c"
	}
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (old) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_game_unref (old);
#line 10584 "chess-game.c"
	}
}


static void chess_game_class_init (ChessGameClass * klass) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	chess_game_parent_class = g_type_class_peek_parent (klass);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	CHESS_GAME_CLASS (klass)->finalize = chess_game_finalize;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__CHESS_MOVE, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("superpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 10610 "chess-game.c"
}


static void chess_game_instance_init (ChessGame * self) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv = CHESS_GAME_GET_PRIVATE (self);
#line 1274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->hold_count = 0;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_is_paused = FALSE;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->priv->_is_superpaused = FALSE;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self->ref_count = 1;
#line 10625 "chess-game.c"
}


static void chess_game_finalize (ChessGame* obj) {
	ChessGame * self;
	ChessClock* _tmp0_ = NULL;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
#line 1350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 1350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (_tmp0_ != NULL) {
#line 10638 "chess-game.c"
		ChessClock* _tmp1_ = NULL;
#line 1351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		_tmp1_ = self->priv->_clock;
#line 1351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		chess_clock_stop (_tmp1_);
#line 10644 "chess-game.c"
	}
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	__g_list_free__chess_state_unref0_0 (self->move_stack);
#line 1311 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	_g_object_unref0 (self->priv->_clock);
#line 10650 "chess-game.c"
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_game_init, value_chess_game_free_value, value_chess_game_copy_value, value_chess_game_peek_pointer, "p", value_chess_game_collect_value, "p", value_chess_game_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessGame", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


gpointer chess_game_ref (gpointer instance) {
	ChessGame* self;
	self = instance;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	return instance;
#line 10675 "chess-game.c"
}


void chess_game_unref (gpointer instance) {
	ChessGame* self;
	self = instance;
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		CHESS_GAME_GET_CLASS (self)->finalize (self);
#line 1267 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 10688 "chess-game.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



