/* chess-clock.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from chess-clock.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>


#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClockPrivate {
	guint _white_initial_ms;
	guint _black_initial_ms;
	guint _white_ms_used;
	guint _black_ms_used;
	Color _active_color;
	GTimer* timer;
	guint expire_timeout_id;
	guint tick_timeout_id;
};


static gpointer chess_clock_parent_class = NULL;

GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_INITIAL_SECONDS,
	CHESS_CLOCK_BLACK_INITIAL_SECONDS,
	CHESS_CLOCK_WHITE_SECONDS_USED,
	CHESS_CLOCK_BLACK_SECONDS_USED,
	CHESS_CLOCK_ACTIVE_COLOR
};
ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds);
void chess_clock_start (ChessClock* self);
static gboolean chess_clock_get_is_active (ChessClock* self);
static void chess_clock_watch_timer (ChessClock* self);
static gboolean chess_clock_timer_expired_cb (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
static void chess_clock_stop_checking_timer (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self);
static guint chess_clock_ms_to_seconds (ChessClock* self, guint ms);
guint chess_clock_get_white_initial_seconds (ChessClock* self);
guint chess_clock_get_black_initial_seconds (ChessClock* self);
guint chess_clock_get_white_seconds_used (ChessClock* self);
guint chess_clock_get_black_seconds_used (ChessClock* self);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject* obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds) {
	ChessClock * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self = (ChessClock*) g_object_new (object_type, NULL);
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = white_initial_seconds;
#line 78 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_white_initial_ms = _tmp0_ * 1000;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = black_initial_seconds;
#line 79 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_black_initial_ms = _tmp1_ * 1000;
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return self;
#line 114 "chess-clock.c"
}


ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds) {
#line 76 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_initial_seconds, black_initial_seconds);
#line 121 "chess-clock.c"
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
#line 87 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = chess_clock_get_is_active (self);
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 89 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp1_) {
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return;
#line 139 "chess-clock.c"
	}
#line 92 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp2_ = self->priv->timer;
#line 92 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp2_ == NULL) {
#line 145 "chess-clock.c"
		GTimer* _tmp3_ = NULL;
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp3_ = g_timer_new ();
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_g_timer_destroy0 (self->priv->timer);
#line 95 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		self->priv->timer = _tmp3_;
#line 153 "chess-clock.c"
	} else {
		GTimer* _tmp4_ = NULL;
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp4_ = self->priv->timer;
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_timer_start (_tmp4_);
#line 160 "chess-clock.c"
	}
#line 102 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 164 "chess-clock.c"
}


static gboolean chess_clock_timer_expired_cb (ChessClock* self) {
	gboolean result = FALSE;
#line 105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_stop (self);
#line 108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_signal_emit_by_name (self, "expired");
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 180 "chess-clock.c"
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb (self);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 189 "chess-clock.c"
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint elapsed = 0U;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	guint used = 0U;
	Color _tmp3_ = 0;
	Color _tmp4_ = 0;
	guint next_tick_time = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->tick_timeout_id;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 115 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_signal_emit_by_name (self, "tick");
#line 214 "chess-clock.c"
	}
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
#line 117 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	elapsed = (guint) (_tmp2_ * 1000);
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp3_ = chess_clock_get_active_color (self);
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp4_ = _tmp3_;
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp4_ == COLOR_WHITE) {
#line 228 "chess-clock.c"
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp5_ = self->priv->_white_ms_used;
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp6_ = elapsed;
#line 120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		used = _tmp5_ + _tmp6_;
#line 237 "chess-clock.c"
	} else {
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp7_ = self->priv->_black_ms_used;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp8_ = elapsed;
#line 122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		used = _tmp7_ + _tmp8_;
#line 247 "chess-clock.c"
	}
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp9_ = used;
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	next_tick_time = ((_tmp9_ / 1000) + 1) * 1000;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp10_ = used;
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, next_tick_time - _tmp10_, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->tick_timeout_id = _tmp11_;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 263 "chess-clock.c"
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
	guint elapsed = 0U;
	GTimer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	Color _tmp5_ = 0;
	Color _tmp6_ = 0;
	GTimer* _tmp17_ = NULL;
#line 129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = chess_clock_get_is_active (self);
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (!_tmp1_) {
#line 132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return;
#line 287 "chess-clock.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp2_ = self->priv->timer;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_timer_stop (_tmp2_);
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_stop_checking_timer (self);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp3_ = self->priv->timer;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	elapsed = (guint) (_tmp4_ * 1000);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp5_ = chess_clock_get_active_color (self);
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp6_ = _tmp5_;
#line 138 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp6_ == COLOR_WHITE) {
#line 307 "chess-clock.c"
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp7_ = self->priv->_white_ms_used;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp8_ = elapsed;
#line 140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		self->priv->_white_ms_used = _tmp7_ + _tmp8_;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp9_ = self->priv->_white_ms_used;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp10_ = self->priv->_white_initial_ms;
#line 141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		if (_tmp9_ > _tmp10_) {
#line 324 "chess-clock.c"
			guint _tmp11_ = 0U;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp11_ = self->priv->_white_initial_ms;
#line 142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			self->priv->_white_ms_used = _tmp11_;
#line 330 "chess-clock.c"
		}
	} else {
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp12_ = self->priv->_black_ms_used;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp13_ = elapsed;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		self->priv->_black_ms_used = _tmp12_ + _tmp13_;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp14_ = self->priv->_black_ms_used;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp15_ = self->priv->_black_initial_ms;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		if (_tmp14_ > _tmp15_) {
#line 349 "chess-clock.c"
			guint _tmp16_ = 0U;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp16_ = self->priv->_black_initial_ms;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			self->priv->_black_ms_used = _tmp16_;
#line 355 "chess-clock.c"
		}
	}
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp17_ = self->priv->timer;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_timer_reset (_tmp17_);
#line 362 "chess-clock.c"
}


void chess_clock_pause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = chess_clock_get_is_active (self);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (!_tmp1_) {
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return;
#line 380 "chess-clock.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp2_ = self->priv->timer;
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_timer_stop (_tmp2_);
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_stop_checking_timer (self);
#line 388 "chess-clock.c"
}


void chess_clock_unpause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	GTimer* _tmp5_ = NULL;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp1_ == NULL) {
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp0_ = TRUE;
#line 405 "chess-clock.c"
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp2_ = chess_clock_get_is_active (self);
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp3_ = _tmp2_;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp0_ = _tmp3_;
#line 415 "chess-clock.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp4_ = _tmp0_;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp4_) {
#line 166 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return;
#line 423 "chess-clock.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp5_ = self->priv->timer;
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_timer_continue (_tmp5_);
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 431 "chess-clock.c"
}


static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_timer_expired_cb (self);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 440 "chess-clock.c"
}


static void chess_clock_watch_timer (ChessClock* self) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = chess_clock_get_active_color (self);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp1_ == COLOR_WHITE) {
#line 455 "chess-clock.c"
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp2_ = self->priv->_white_initial_ms;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp3_ = self->priv->_white_ms_used;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp2_ - _tmp3_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		self->priv->expire_timeout_id = _tmp4_;
#line 467 "chess-clock.c"
	} else {
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp5_ = self->priv->_black_initial_ms;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp6_ = self->priv->_black_ms_used;
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp5_ - _tmp6_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		self->priv->expire_timeout_id = _tmp7_;
#line 480 "chess-clock.c"
	}
#line 181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_tick_cb (self);
#line 484 "chess-clock.c"
}


static void chess_clock_stop_checking_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->expire_timeout_id;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_source_remove (_tmp0_);
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->expire_timeout_id = (guint) 0;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = self->priv->tick_timeout_id;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_source_remove (_tmp1_);
#line 189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 505 "chess-clock.c"
}


static guint chess_clock_ms_to_seconds (ChessClock* self, guint ms) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = ms;
#line 194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = (_tmp0_ + 500) / 1000;
#line 194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 520 "chess-clock.c"
}


guint chess_clock_get_white_initial_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->_white_initial_ms;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = chess_clock_ms_to_seconds (self, _tmp0_);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = _tmp1_;
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 538 "chess-clock.c"
}


guint chess_clock_get_black_initial_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->_black_initial_ms;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = chess_clock_ms_to_seconds (self, _tmp0_);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = _tmp1_;
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 556 "chess-clock.c"
}


guint chess_clock_get_white_seconds_used (ChessClock* self) {
	guint result;
	GTimer* _tmp0_ = NULL;
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 31 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->timer;
#line 31 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp0_ == NULL) {
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		result = (guint) 0;
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return result;
#line 573 "chess-clock.c"
	} else {
		Color _tmp1_ = 0;
		Color _tmp2_ = 0;
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp1_ = chess_clock_get_active_color (self);
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp2_ = _tmp1_;
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		if (_tmp2_ == COLOR_WHITE) {
#line 583 "chess-clock.c"
			guint _tmp3_ = 0U;
			GTimer* _tmp4_ = NULL;
			gdouble _tmp5_ = 0.0;
			guint _tmp6_ = 0U;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp3_ = self->priv->_white_ms_used;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp4_ = self->priv->timer;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp5_ = g_timer_elapsed (_tmp4_, NULL);
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp6_ = chess_clock_ms_to_seconds (self, _tmp3_ + ((guint) (_tmp5_ * 1000)));
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			result = _tmp6_;
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			return result;
#line 600 "chess-clock.c"
		} else {
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp7_ = self->priv->_white_ms_used;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp8_ = chess_clock_ms_to_seconds (self, _tmp7_);
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			result = _tmp8_;
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			return result;
#line 612 "chess-clock.c"
		}
	}
}


guint chess_clock_get_black_seconds_used (ChessClock* self) {
	guint result;
	GTimer* _tmp0_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 45 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->timer;
#line 45 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp0_ == NULL) {
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		result = (guint) 0;
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return result;
#line 631 "chess-clock.c"
	} else {
		Color _tmp1_ = 0;
		Color _tmp2_ = 0;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp1_ = chess_clock_get_active_color (self);
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp2_ = _tmp1_;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		if (_tmp2_ == COLOR_WHITE) {
#line 641 "chess-clock.c"
			guint _tmp3_ = 0U;
			guint _tmp4_ = 0U;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp3_ = self->priv->_black_ms_used;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp4_ = chess_clock_ms_to_seconds (self, _tmp3_);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			result = _tmp4_;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			return result;
#line 652 "chess-clock.c"
		} else {
			guint _tmp5_ = 0U;
			GTimer* _tmp6_ = NULL;
			gdouble _tmp7_ = 0.0;
			guint _tmp8_ = 0U;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp5_ = self->priv->_black_ms_used;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp6_ = self->priv->timer;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp7_ = g_timer_elapsed (_tmp6_, NULL);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			_tmp8_ = chess_clock_ms_to_seconds (self, _tmp5_ + ((guint) (_tmp7_ * 1000)));
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			result = _tmp8_;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
			return result;
#line 670 "chess-clock.c"
		}
	}
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = self->priv->_active_color;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = _tmp0_;
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 687 "chess-clock.c"
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	Color _tmp3_ = 0;
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp0_ = value;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = chess_clock_get_active_color (self);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp2_ = _tmp1_;
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp0_ == _tmp2_) {
#line 61 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		return;
#line 708 "chess-clock.c"
	}
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_stop (self);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp3_ = value;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_active_color = _tmp3_;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_start (self);
#line 58 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_notify ((GObject *) self, "active-color");
#line 720 "chess-clock.c"
}


static gboolean chess_clock_get_is_active (ChessClock* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	if (_tmp1_ != NULL) {
#line 735 "chess-clock.c"
		guint _tmp2_ = 0U;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp2_ = self->priv->expire_timeout_id;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp0_ = _tmp2_ != ((guint) 0);
#line 741 "chess-clock.c"
	} else {
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		_tmp0_ = FALSE;
#line 745 "chess-clock.c"
	}
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_tmp3_ = _tmp0_;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	result = _tmp3_;
#line 84 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	return result;
#line 753 "chess-clock.c"
}


static void chess_clock_class_init (ChessClockClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	chess_clock_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_INITIAL_SECONDS, g_param_spec_uint ("white-initial-seconds", "white-initial-seconds", "white-initial-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_INITIAL_SECONDS, g_param_spec_uint ("black-initial-seconds", "black-initial-seconds", "black-initial-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_SECONDS_USED, g_param_spec_uint ("white-seconds-used", "white-seconds-used", "white-seconds-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_SECONDS_USED, g_param_spec_uint ("black-seconds-used", "black-seconds-used", "black-seconds-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 782 "chess-clock.c"
}


static void chess_clock_instance_init (ChessClock * self) {
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_white_ms_used = (guint) 0;
#line 40 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_black_ms_used = (guint) 0;
#line 54 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->_active_color = COLOR_WHITE;
#line 70 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->expire_timeout_id = (guint) 0;
#line 71 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 799 "chess-clock.c"
}


static void chess_clock_finalize (GObject* obj) {
	ChessClock * self;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_CLOCK, ChessClock);
#line 69 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
#line 811 "chess-clock.c"
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_value_set_uint (value, chess_clock_get_white_initial_seconds (self));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_value_set_uint (value, chess_clock_get_black_initial_seconds (self));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_WHITE_SECONDS_USED:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_value_set_uint (value, chess_clock_get_white_seconds_used (self));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_BLACK_SECONDS_USED:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_value_set_uint (value, chess_clock_get_black_seconds_used (self));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		g_value_set_enum (value, chess_clock_get_active_color (self));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 862 "chess-clock.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 868 "chess-clock.c"
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		chess_clock_set_active_color (self, g_value_get_enum (value));
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 884 "chess-clock.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/chess-clock.vala"
		break;
#line 890 "chess-clock.c"
	}
}



