/* rygel-time-utils.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-time-utils.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_TIME_UTILS (rygel_time_utils_get_type ())
#define RYGEL_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtils))
#define RYGEL_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))
#define RYGEL_IS_TIME_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_IS_TIME_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TIME_UTILS))
#define RYGEL_TIME_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TIME_UTILS, RygelTimeUtilsClass))

typedef struct _RygelTimeUtils RygelTimeUtils;
typedef struct _RygelTimeUtilsClass RygelTimeUtilsClass;
typedef struct _RygelTimeUtilsPrivate RygelTimeUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecTimeUtils RygelParamSpecTimeUtils;

struct _RygelTimeUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTimeUtilsPrivate * priv;
};

struct _RygelTimeUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTimeUtils *self);
};

struct _RygelParamSpecTimeUtils {
	GParamSpec parent_instance;
};


static gpointer rygel_time_utils_parent_class = NULL;

gpointer rygel_time_utils_ref (gpointer instance);
void rygel_time_utils_unref (gpointer instance);
GParamSpec* rygel_param_spec_time_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_time_utils (GValue* value, gpointer v_object);
void rygel_value_take_time_utils (GValue* value, gpointer v_object);
gpointer rygel_value_get_time_utils (const GValue* value);
GType rygel_time_utils_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TIME_UTILS_DUMMY_PROPERTY
};
gint64 rygel_time_utils_time_from_string (const gchar* str);
gchar* rygel_time_utils_time_to_string (gint64 time);
RygelTimeUtils* rygel_time_utils_construct (GType object_type);
static void rygel_time_utils_finalize (RygelTimeUtils* obj);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gint64 rygel_time_utils_time_from_string (const gchar* str) {
	gint64 result = 0LL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* time_str;
	gint sign;
	const gchar* _tmp2_;
	gchar _tmp3_ = '\0';
	const gchar* _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_strdup (_tmp0_);
	time_str = _tmp1_;
	sign = 1;
	_tmp2_ = str;
	_tmp3_ = string_get (_tmp2_, (glong) 0);
	switch (_tmp3_) {
		case '-':
		{
			const gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			sign = -1;
			_tmp4_ = str;
			_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) (-1));
			_g_free0 (time_str);
			time_str = _tmp5_;
			break;
		}
		case '+':
		{
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp6_ = str;
			_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) (-1));
			_g_free0 (time_str);
			time_str = _tmp7_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp8_ = time_str;
	sscanf (_tmp8_, "%llu:%2llu:%2llu%*s", &hours, &minutes, &seconds);
	_tmp9_ = sign;
	result = (_tmp9_ * ((gint64) (((hours * 3600) + (minutes * 60)) + seconds))) * G_TIME_SPAN_SECOND;
	_g_free0 (time_str);
	return result;
}


gchar* rygel_time_utils_time_to_string (gint64 time) {
	gchar* result = NULL;
	guint64 hours = 0ULL;
	guint64 minutes = 0ULL;
	guint64 seconds = 0ULL;
	gchar* _tmp0_;
	gchar* sign;
	gint64 _tmp1_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	guint64 _tmp6_;
	guint64 _tmp7_;
	const gchar* _tmp8_;
	guint64 _tmp9_;
	gchar* _tmp10_ = NULL;
	_tmp0_ = g_strdup ("");
	sign = _tmp0_;
	_tmp1_ = time;
	if (_tmp1_ < ((gint64) 0)) {
		gchar* _tmp2_;
		gint64 _tmp3_;
		_tmp2_ = g_strdup ("-");
		_g_free0 (sign);
		sign = _tmp2_;
		_tmp3_ = time;
		time = -_tmp3_;
	}
	_tmp4_ = time;
	hours = (guint64) ((_tmp4_ / G_TIME_SPAN_SECOND) / 3600);
	_tmp5_ = time;
	seconds = (guint64) ((_tmp5_ / G_TIME_SPAN_SECOND) % 3600);
	_tmp6_ = seconds;
	minutes = _tmp6_ / 60;
	_tmp7_ = seconds;
	seconds = _tmp7_ % 60;
	_tmp8_ = sign;
	_tmp9_ = seconds;
	_tmp10_ = g_strdup_printf ("%s%llu:%.2llu:%.2llu", _tmp8_, hours, minutes, _tmp9_);
	result = _tmp10_;
	_g_free0 (sign);
	return result;
}


RygelTimeUtils* rygel_time_utils_construct (GType object_type) {
	RygelTimeUtils* self = NULL;
	self = (RygelTimeUtils*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_time_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_time_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_time_utils_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_time_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_time_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_time_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_time_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelTimeUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_time_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_time_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTimeUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_time_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_time_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTimeUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TIME_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_time_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_time_utils (GValue* value, gpointer v_object) {
	RygelTimeUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_time_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_time_utils_unref (old);
	}
}


void rygel_value_take_time_utils (GValue* value, gpointer v_object) {
	RygelTimeUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TIME_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TIME_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_time_utils_unref (old);
	}
}


static void rygel_time_utils_class_init (RygelTimeUtilsClass * klass) {
	rygel_time_utils_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TIME_UTILS_CLASS (klass)->finalize = rygel_time_utils_finalize;
}


static void rygel_time_utils_instance_init (RygelTimeUtils * self) {
	self->ref_count = 1;
}


static void rygel_time_utils_finalize (RygelTimeUtils* obj) {
	RygelTimeUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TIME_UTILS, RygelTimeUtils);
}


GType rygel_time_utils_get_type (void) {
	static volatile gsize rygel_time_utils_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_time_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_time_utils_init, rygel_value_time_utils_free_value, rygel_value_time_utils_copy_value, rygel_value_time_utils_peek_pointer, "p", rygel_value_time_utils_collect_value, "p", rygel_value_time_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTimeUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_time_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTimeUtils), 0, (GInstanceInitFunc) rygel_time_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_time_utils_type_id;
		rygel_time_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTimeUtils", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_time_utils_type_id__volatile, rygel_time_utils_type_id);
	}
	return rygel_time_utils_type_id__volatile;
}


gpointer rygel_time_utils_ref (gpointer instance) {
	RygelTimeUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_time_utils_unref (gpointer instance) {
	RygelTimeUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TIME_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



