/* rygel-http-byte-seek-test.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-byte-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK_TEST (rygel_http_byte_seek_test_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest))
#define RYGEL_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))

typedef struct _RygelHTTPByteSeekTest RygelHTTPByteSeekTest;
typedef struct _RygelHTTPByteSeekTestClass RygelHTTPByteSeekTestClass;
typedef struct _RygelHTTPByteSeekTestPrivate RygelHTTPByteSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPIdentityHandler {
	GObject parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTest {
	GObject parent_instance;
	RygelHTTPByteSeekTestPrivate * priv;
};

struct _RygelHTTPByteSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_byte_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_inverted_range (void);
RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type);
RygelHTTPGet* rygel_http_get_new_invalid_range (void);
RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_byte_seek_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_byte_seek_test_main (gchar** args, int args_length1);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type) {
	RygelHTTPIdentityHandler * self = NULL;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPIdentityHandler*) g_object_new (object_type, NULL);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 381 "rygel-http-byte-seek-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 388 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 395 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 421 "rygel-http-byte-seek-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 428 "rygel-http-byte-seek-test.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 437 "rygel-http-byte-seek-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 2048;
#line 444 "rygel-http-byte-seek-test.c"
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 454 "rygel-http-byte-seek-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 476 "rygel-http-byte-seek-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 483 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 490 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 516 "rygel-http-byte-seek-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 523 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 532 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 1024;
#line 539 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_finalize (GObject* obj) {
	RygelThumbnail * self;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
#line 549 "rygel-http-byte-seek-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 571 "rygel-http-byte-seek-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 578 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 587 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 512;
#line 594 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
#line 604 "rygel-http-byte-seek-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 626 "rygel-http-byte-seek-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 633 "rygel-http-byte-seek-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 640 "rygel-http-byte-seek-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error) {
	RygelClientHacks* result = NULL;
	RygelClientHacks* _tmp0_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = rygel_client_hacks_new ();
#line 50 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return result;
#line 671 "rygel-http-byte-seek-test.c"
}


gboolean rygel_client_hacks_force_seek (RygelClientHacks* self) {
	gboolean result = FALSE;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	result = FALSE;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return result;
#line 683 "rygel-http-byte-seek-test.c"
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks * self = NULL;
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelClientHacks*) g_object_new (object_type, NULL);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 693 "rygel-http-byte-seek-test.c"
}


RygelClientHacks* rygel_client_hacks_new (void) {
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
#line 700 "rygel-http-byte-seek-test.c"
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
#line 707 "rygel-http-byte-seek-test.c"
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, NULL };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelClientHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 730 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	RygelMediaItem* _tmp1_ = NULL;
	RygelHTTPIdentityHandler* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	RygelSubtitle* _tmp5_ = NULL;
	RygelSubtitle* _tmp6_ = NULL;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->msg = _tmp0_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_media_item_new ();
#line 70 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->object);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->object = (RygelMediaObject*) _tmp1_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_identity_handler_new ();
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->handler = _tmp2_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = thumbnail;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->thumbnail = _tmp4_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = subtitle;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->subtitle = _tmp6_;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 781 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 788 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 809 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 816 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = stop;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 837 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 844 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 868 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 92 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 875 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_append (_tmp1_, "Range", "bytes=34-0");
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 893 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_inverted_range (void) {
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_inverted_range (RYGEL_TYPE_HTTP_GET);
#line 900 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_append (_tmp1_, "Range", "bytes=a-b");
#line 106 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 918 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_invalid_range (void) {
#line 106 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_invalid_range (RYGEL_TYPE_HTTP_GET);
#line 925 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_set_range (_tmp1_, _tmp2_, _tmp3_);
#line 946 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 955 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->object);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 979 "rygel-http-byte-seek-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


gint rygel_http_byte_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPByteSeekTest* test = NULL;
		RygelHTTPByteSeekTest* _tmp0_ = NULL;
		RygelHTTPByteSeekTest* _tmp1_ = NULL;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp0_ = rygel_http_byte_seek_test_new ();
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		test = _tmp0_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp1_ = test;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		rygel_http_byte_seek_test_run (_tmp1_, &_inner_error_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (test);
#line 1014 "rygel-http-byte-seek-test.c"
			goto __catch0_g_error;
		}
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (test);
#line 1019 "rygel-http-byte-seek-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp2_ = _error_;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp3_ = _tmp2_->message;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("rygel-http-byte-seek-test.vala:129: %s", _tmp3_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		result = -1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return result;
#line 1043 "rygel-http-byte-seek-test.c"
	}
	__finally0:
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return 0;
#line 1054 "rygel-http-byte-seek-test.c"
	}
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	result = 0;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return result;
#line 1060 "rygel-http-byte-seek-test.c"
}


int main (int argc, char ** argv) {
#line 119 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_init ();
#line 119 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_main (argv, argc);
#line 1069 "rygel-http-byte-seek-test.c"
}


void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error) {
	RygelThumbnail** thumbnails = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail** _tmp1_ = NULL;
	gint thumbnails_length1 = 0;
	gint _thumbnails_size_ = 0;
	RygelSubtitle** subtitles = NULL;
	RygelSubtitle* _tmp2_ = NULL;
	RygelSubtitle** _tmp3_ = NULL;
	gint subtitles_length1 = 0;
	gint _subtitles_size_ = 0;
	RygelThumbnail** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[0] = NULL;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[1] = _tmp0_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = _tmp1_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails_length1 = 2;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_thumbnails_size_ = thumbnails_length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_subtitle_new ();
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[0] = NULL;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[1] = _tmp2_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = _tmp3_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles_length1 = 2;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_subtitles_size_ = subtitles_length1;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = thumbnails;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4__length1 = thumbnails_length1;
#line 1121 "rygel-http-byte-seek-test.c"
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection = _tmp4_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection_length1 = _tmp4__length1;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
#line 1133 "rygel-http-byte-seek-test.c"
			RygelThumbnail* _tmp5_ = NULL;
			RygelThumbnail* thumbnail = NULL;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnail = _tmp5_;
#line 1140 "rygel-http-byte-seek-test.c"
			{
				RygelSubtitle** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6_ = subtitles;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6__length1 = subtitles_length1;
#line 1148 "rygel-http-byte-seek-test.c"
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection = _tmp6_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection_length1 = _tmp6__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
#line 1160 "rygel-http-byte-seek-test.c"
						RygelSubtitle* _tmp7_ = NULL;
						RygelSubtitle* subtitle = NULL;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						subtitle = _tmp7_;
#line 1167 "rygel-http-byte-seek-test.c"
						{
							RygelThumbnail* _tmp8_ = NULL;
							RygelSubtitle* _tmp9_ = NULL;
							RygelThumbnail* _tmp10_ = NULL;
							RygelSubtitle* _tmp11_ = NULL;
							RygelThumbnail* _tmp12_ = NULL;
							RygelSubtitle* _tmp13_ = NULL;
							RygelThumbnail* _tmp14_ = NULL;
							RygelSubtitle* _tmp15_ = NULL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp8_ = thumbnail;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp9_ = subtitle;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1199 "rygel-http-byte-seek-test.c"
								} else {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1215 "rygel-http-byte-seek-test.c"
								}
							}
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp10_ = thumbnail;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp11_ = subtitle;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1240 "rygel-http-byte-seek-test.c"
								} else {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1256 "rygel-http-byte-seek-test.c"
								}
							}
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp12_ = thumbnail;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp13_ = subtitle;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1281 "rygel-http-byte-seek-test.c"
								} else {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1297 "rygel-http-byte-seek-test.c"
								}
							}
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp14_ = thumbnail;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp15_ = subtitle;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1322 "rygel-http-byte-seek-test.c"
								} else {
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1338 "rygel-http-byte-seek-test.c"
								}
							}
#line 142 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_g_object_unref0 (subtitle);
#line 1343 "rygel-http-byte-seek-test.c"
						}
					}
				}
#line 141 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_g_object_unref0 (thumbnail);
#line 1349 "rygel-http-byte-seek-test.c"
			}
		}
	}
	{
		RygelHTTPGet* _tmp16_ = NULL;
		RygelHTTPGet* _tmp17_ = NULL;
		RygelHTTPByteSeek* _tmp18_ = NULL;
		RygelHTTPByteSeek* _tmp19_ = NULL;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp16_ = rygel_http_get_new_inverted_range ();
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp17_ = _tmp16_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp18_ = rygel_http_byte_seek_new (_tmp17_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp19_ = _tmp18_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp19_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp17_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 1374 "rygel-http-byte-seek-test.c"
				goto __catch1_rygel_http_seek_error;
			}
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1387 "rygel-http-byte-seek-test.c"
		}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert_not_reached ();
#line 1391 "rygel-http-byte-seek-test.c"
	}
	goto __finally1;
	__catch1_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 1403 "rygel-http-byte-seek-test.c"
	}
	__finally1:
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1418 "rygel-http-byte-seek-test.c"
		} else {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1430 "rygel-http-byte-seek-test.c"
		}
	}
	{
		RygelHTTPGet* _tmp20_ = NULL;
		RygelHTTPGet* _tmp21_ = NULL;
		RygelHTTPByteSeek* _tmp22_ = NULL;
		RygelHTTPByteSeek* _tmp23_ = NULL;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp20_ = rygel_http_get_new_invalid_range ();
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp21_ = _tmp20_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp22_ = rygel_http_byte_seek_new (_tmp21_, &_inner_error_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp23_ = _tmp22_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp23_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp21_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 1454 "rygel-http-byte-seek-test.c"
				goto __catch2_rygel_http_seek_error;
			}
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1467 "rygel-http-byte-seek-test.c"
		}
#line 157 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert_not_reached ();
#line 1471 "rygel-http-byte-seek-test.c"
	}
	goto __finally2;
	__catch2_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 1483 "rygel-http-byte-seek-test.c"
	}
	__finally2:
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1498 "rygel-http-byte-seek-test.c"
		} else {
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1510 "rygel-http-byte-seek-test.c"
		}
	}
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1517 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type) {
	RygelHTTPByteSeekTest * self = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPByteSeekTest*) g_object_new (object_type, NULL);
#line 1526 "rygel-http-byte-seek-test.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp1_ = g_regex_new ("bytes +[0-9]+-[0-9]+/[0-9]+", G_REGEX_CASELESS, 0, &_inner_error_);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp0_ = _tmp1_;
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1538 "rygel-http-byte-seek-test.c"
				goto __catch3_g_regex_error;
			}
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return NULL;
#line 1547 "rygel-http-byte-seek-test.c"
		}
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_regex_unref0 (self->priv->range_regex);
#line 163 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		self->priv->range_regex = _tmp0_;
#line 1553 "rygel-http-byte-seek-test.c"
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* _error_ = NULL;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert_not_reached ();
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 1567 "rygel-http-byte-seek-test.c"
	}
	__finally3:
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return NULL;
#line 1578 "rygel-http-byte-seek-test.c"
	}
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 1582 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void) {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_TEST);
#line 1589 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	RygelHTTPGet* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	GError * _inner_error_ = NULL;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 176 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1620 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_ = NULL;
		RygelThumbnail* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 177 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1632 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_ = NULL;
		RygelSubtitle* _tmp9_ = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1642 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_ = NULL;
			RygelSubtitle* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1654 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_ = NULL;
			RygelMediaObject* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->object;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1667 "rygel-http-byte-seek-test.c"
		}
	}
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 0, _tmp17_ - 1, &_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1686 "rygel-http-byte-seek-test.c"
		} else {
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1696 "rygel-http-byte-seek-test.c"
		}
	}
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1701 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_ = NULL;
	RygelThumbnail* _tmp4_ = NULL;
	RygelHTTPGet* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	GError * _inner_error_ = NULL;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp0_, _tmp1_);
#line 190 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1732 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_ = NULL;
		RygelThumbnail* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1744 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_ = NULL;
		RygelSubtitle* _tmp9_ = NULL;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1754 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_ = NULL;
			RygelSubtitle* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1766 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_ = NULL;
			RygelMediaObject* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->object;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1779 "rygel-http-byte-seek-test.c"
		}
	}
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 128, _tmp17_ - 1, &_inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1798 "rygel-http-byte-seek-test.c"
		} else {
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1808 "rygel-http-byte-seek-test.c"
		}
	}
#line 187 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1813 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp0_, _tmp1_);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1845 "rygel-http-byte-seek-test.c"
		} else {
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1855 "rygel-http-byte-seek-test.c"
		}
	}
#line 204 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1860 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelHTTPGet* request = NULL;
	RygelThumbnail* _tmp0_ = NULL;
	RygelSubtitle* _tmp1_ = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp0_, _tmp1_);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1892 "rygel-http-byte-seek-test.c"
		} else {
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1902 "rygel-http-byte-seek-test.c"
		}
	}
#line 212 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1907 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelHTTPByteSeek* seek = NULL;
	RygelHTTPGet* _tmp2_ = NULL;
	RygelHTTPByteSeek* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	RygelHTTPGet* _tmp10_ = NULL;
	RygelThumbnail* _tmp11_ = NULL;
	RygelHTTPGet* _tmp29_ = NULL;
	SoupMessage* _tmp30_ = NULL;
	SoupMessageHeaders* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	RygelHTTPGet* _tmp48_ = NULL;
	SoupMessage* _tmp49_ = NULL;
	SoupMessageHeaders* _tmp50_ = NULL;
	gint64 _tmp51_ = 0LL;
	gint64 _tmp52_ = 0LL;
	gint64 _tmp53_ = 0LL;
	RygelHTTPGet* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = request;
#line 226 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_http_byte_seek_needed (_tmp0_);
#line 226 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_vala_assert (_tmp1_, "HTTPByteSeek.needed (request)");
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = request;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = rygel_http_byte_seek_new (_tmp2_, &_inner_error_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	seek = _tmp3_;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1961 "rygel-http-byte-seek-test.c"
		} else {
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1969 "rygel-http-byte-seek-test.c"
		}
	}
#line 229 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 231 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_vala_assert (seek != NULL, "seek != null");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = _tmp4_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = start;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_vala_assert (_tmp5_ == _tmp6_, "seek.start == start");
#line 233 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 233 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp8_ = _tmp7_;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp9_ = stop;
#line 233 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_vala_assert (_tmp8_ == _tmp9_, "seek.stop == stop");
#line 235 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp10_ = request;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp11_ = _tmp10_->thumbnail;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp11_ != NULL) {
#line 1998 "rygel-http-byte-seek-test.c"
		gint64 _tmp12_ = 0LL;
		gint64 _tmp13_ = 0LL;
		RygelHTTPGet* _tmp14_ = NULL;
		RygelThumbnail* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp12_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp13_ = _tmp12_;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp14_ = request;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp15_ = _tmp14_->thumbnail;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp16_ = _tmp15_->size;
#line 236 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_vala_assert (_tmp13_ == _tmp16_, "seek.total_length == request.thumbnail.size");
#line 2016 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp17_ = NULL;
		RygelSubtitle* _tmp18_ = NULL;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp17_ = request;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp18_ = _tmp17_->subtitle;
#line 237 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp18_ != NULL) {
#line 2026 "rygel-http-byte-seek-test.c"
			gint64 _tmp19_ = 0LL;
			gint64 _tmp20_ = 0LL;
			RygelHTTPGet* _tmp21_ = NULL;
			RygelSubtitle* _tmp22_ = NULL;
			gint64 _tmp23_ = 0LL;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp20_ = _tmp19_;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp21_ = request;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp22_ = _tmp21_->subtitle;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp23_ = _tmp22_->size;
#line 238 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_vala_assert (_tmp20_ == _tmp23_, "seek.total_length == request.subtitle.size");
#line 2044 "rygel-http-byte-seek-test.c"
		} else {
			gint64 _tmp24_ = 0LL;
			gint64 _tmp25_ = 0LL;
			RygelHTTPGet* _tmp26_ = NULL;
			RygelMediaObject* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp25_ = _tmp24_;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp26_ = request;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp27_ = _tmp26_->object;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp28_ = _tmp27_->size;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_vala_assert (_tmp25_ == _tmp28_, "seek.total_length == request.object.size");
#line 2063 "rygel-http-byte-seek-test.c"
		}
	}
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp29_ = request;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp30_ = _tmp29_->msg;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp31_ = _tmp30_->request_headers;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp32_ = soup_message_headers_get_one (_tmp31_, "Range");
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp32_ != NULL) {
#line 2076 "rygel-http-byte-seek-test.c"
		gchar* header = NULL;
		RygelHTTPGet* _tmp33_ = NULL;
		SoupMessage* _tmp34_ = NULL;
		SoupMessageHeaders* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		RygelHTTPGet* _tmp39_ = NULL;
		SoupMessage* _tmp40_ = NULL;
		SoupMessageHeaders* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		GRegex* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp33_ = request;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp34_ = _tmp33_->msg;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp35_ = _tmp34_->response_headers;
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp36_ = soup_message_headers_get_one (_tmp35_, "Accept-Ranges");
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 244 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp37_;
#line 245 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp38_ = header;
#line 245 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_vala_assert (g_strcmp0 (_tmp38_, "bytes") == 0, "header == \"bytes\"");
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp39_ = request;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp40_ = _tmp39_->msg;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp41_ = _tmp40_->response_headers;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp42_ = soup_message_headers_get_one (_tmp41_, "Content-Range");
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp43_;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp44_ = header;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_vala_assert (_tmp44_ != NULL, "header != null");
#line 248 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp45_ = self->priv->range_regex;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp46_ = header;
#line 248 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp47_ = g_regex_match (_tmp45_, _tmp46_, 0, NULL);
#line 248 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_vala_assert (_tmp47_, "this.range_regex.match (header)");
#line 243 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 2137 "rygel-http-byte-seek-test.c"
	}
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp48_ = request;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp49_ = _tmp48_->msg;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp50_ = _tmp49_->response_headers;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp51_ = soup_message_headers_get_content_length (_tmp50_);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp52_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp53_ = _tmp52_;
#line 251 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_vala_assert (_tmp51_ == _tmp53_, "request.msg.response_headers.get_content_length () ==                 seek.length");
#line 259 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp54_ = request;
#line 259 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_requested (_tmp54_);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (seek);
#line 2159 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_class_init (RygelHTTPByteSeekTestClass * klass) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_parent_class = g_type_class_peek_parent (klass);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekTestPrivate));
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_test_finalize;
#line 2170 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_instance_init (RygelHTTPByteSeekTest * self) {
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->priv = RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE (self);
#line 2177 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_finalize (GObject* obj) {
	RygelHTTPByteSeekTest * self;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_byte_seek_test_parent_class)->finalize (obj);
#line 2189 "rygel-http-byte-seek-test.c"
}


GType rygel_http_byte_seek_test_get_type (void) {
	static volatile gsize rygel_http_byte_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekTest), 0, (GInstanceInitFunc) rygel_http_byte_seek_test_instance_init, NULL };
		GType rygel_http_byte_seek_test_type_id;
		rygel_http_byte_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPByteSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_test_type_id__volatile, rygel_http_byte_seek_test_type_id);
	}
	return rygel_http_byte_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



