/* rygel-media-export-media-cache.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <uuid/uuid.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_ensure_exists (GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error);
static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new_root (void);
RygelNullContainer* rygel_null_container_construct_root (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error);
gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded);
gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "16"
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return dup;
#line 504 "rygel-media-export-media-cache.c"
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 511 "rygel-media-export-media-cache.c"
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	gchar* db_name = NULL;
	gchar* _tmp0_ = NULL;
	RygelMediaExportSQLFactory* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaExportObjectFactory* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_strdup ("media-export");
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	db_name = _tmp0_;
#line 540 "rygel-media-export-media-cache.c"
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_meta_config_get_default ();
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		config = _tmp1_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error_);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp3_;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (config);
#line 558 "rygel-media-export-media-cache.c"
			goto __catch5_g_error;
		}
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp2_) {
#line 563 "rygel-media-export-media-cache.c"
			gchar* _tmp4_ = NULL;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = g_strdup (":memory:");
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (db_name);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			db_name = _tmp4_;
#line 571 "rygel-media-export-media-cache.c"
		}
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (config);
#line 575 "rygel-media-export-media-cache.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 587 "rygel-media-export-media-cache.c"
	}
	__finally5:
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (db_name);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 600 "rygel-media-export-media-cache.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_new ();
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->sql = _tmp5_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = db_name;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, _tmp6_, &_inner_error_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (db_name);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 622 "rygel-media-export-media-cache.c"
	}
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_object_factory_new ();
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->factory = _tmp7_;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (db_name);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self;
#line 634 "rygel-media-export-media-cache.c"
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
#line 641 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp2_);
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 670 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_ensure_exists (GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 681 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* _tmp1_ = NULL;
		RygelMediaExportMediaCache* _tmp2_ = NULL;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_media_cache_new (&_inner_error_);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _tmp2_;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 694 "rygel-media-export-media-cache.c"
		}
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (rygel_media_export_media_cache_instance);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_instance = _tmp1_;
#line 700 "rygel-media-export-media-cache.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 708 "rygel-media-export-media-cache.c"
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* _tmp1_ = NULL;
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp1_;
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 724 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (array != NULL) {
#line 731 "rygel-media-export-media-cache.c"
		int i;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_unset (&array[i]);
#line 737 "rygel-media-export-media-cache.c"
		}
	}
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (array);
#line 742 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabase* _tmp3_ = NULL;
	RygelMediaExportSQLFactory* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = self->priv->db;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->sql;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 795 "rygel-media-export-media-cache.c"
		} else {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 805 "rygel-media-export-media-cache.c"
		}
	}
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 810 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, _tmp2_, &_inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 839 "rygel-media-export-media-cache.c"
		} else {
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 847 "rygel-media-export-media-cache.c"
		}
	}
}


/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer _g_error_copy0 (gpointer self) {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_error_copy (self) : NULL;
#line 860 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 870 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaContainer* _tmp1_ = NULL;
		RygelMediaContainer* _tmp2_ = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 884 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 893 "rygel-media-export-media-cache.c"
		}
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_container_metadata (self, _tmp1_, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 903 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = container;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, FALSE, &_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 916 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 929 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 938 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp4_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _error_;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp6_;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 964 "rygel-media-export-media-cache.c"
		goto __finally6;
	}
	__finally6:
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 974 "rygel-media-export-media-cache.c"
	}
}


/**
     * Add the item to the cache.
     */
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error) {
	GError * _inner_error_ = NULL;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 988 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaItem* _tmp1_ = NULL;
		RygelMediaItem* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		RygelMediaExportDatabase* _tmp4_ = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1003 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 1012 "rygel-media-export-media-cache.c"
		}
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = item;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_item_metadata (self, _tmp1_, &_inner_error_);
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1022 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = item;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = override_guarded;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, _tmp3_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1037 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1050 "rygel-media-export-media-cache.c"
				goto __catch7_rygel_media_export_database_error;
			}
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 1059 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		RygelMediaItem* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		RygelMediaExportDatabase* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _ ("Failed to add item with ID %s: %s");
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = item;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp6_);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp7_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _error_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_->message;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning (_tmp5_, _tmp8_, _tmp10_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->db;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp11_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = _error_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp13_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1105 "rygel-media-export-media-cache.c"
		goto __finally7;
	}
	__finally7:
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1115 "rygel-media-export-media-cache.c"
	}
}


/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* parent = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object_id;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = values;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3__length1 = values_length1;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp4_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1182 "rygel-media-export-media-cache.c"
		} else {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1194 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = cursor;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp6_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1209 "rygel-media-export-media-cache.c"
			gboolean _tmp7_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp10_ = NULL;
			sqlite3_stmt* _tmp11_ = NULL;
			RygelMediaContainer* parent_container = NULL;
			RygelMediaObject* _tmp12_ = NULL;
			RygelMediaContainer* _tmp13_ = NULL;
			RygelMediaObject* object = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			sqlite3_stmt* _tmp15_ = NULL;
			RygelMediaObject* _tmp16_ = NULL;
			RygelMediaObject* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaObject* _tmp19_ = NULL;
			RygelMediaObject* _tmp20_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = _statement_it;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = rygel_media_export_database_cursor_iterator_next (_tmp8_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _tmp9_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1249 "rygel-media-export-media-cache.c"
				} else {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1265 "rygel-media-export-media-cache.c"
				}
			}
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp7_) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1272 "rygel-media-export-media-cache.c"
			}
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = _statement_it;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = rygel_media_export_database_cursor_iterator_get (_tmp10_, &_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp11_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1296 "rygel-media-export-media-cache.c"
				} else {
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1312 "rygel-media-export-media-cache.c"
				}
			}
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = parent;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_container = _tmp13_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = parent_container;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = statement;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp14_, _tmp15_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = _tmp16_;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = object;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = parent_container;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp17_, _tmp18_);
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = object;
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 157 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent = _tmp20_;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent_container);
#line 1347 "rygel-media-export-media-cache.c"
		}
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1351 "rygel-media-export-media-cache.c"
	}
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = parent;
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1361 "rygel-media-export-media-cache.c"
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	RygelMediaObject* _tmp8_ = NULL;
	RygelMediaContainer* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = _tmp1_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1394 "rygel-media-export-media-cache.c"
		} else {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1402 "rygel-media-export-media-cache.c"
		}
	}
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = object;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ != NULL) {
#line 1409 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp4_ = NULL;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = object;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 1415 "rygel-media-export-media-cache.c"
	} else {
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = FALSE;
#line 1419 "rygel-media-export-media-cache.c"
	}
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp2_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp5_) {
#line 1425 "rygel-media-export-media-cache.c"
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = container_id;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp6_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp7_;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1442 "rygel-media-export-media-cache.c"
		} else {
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1452 "rygel-media-export-media-cache.c"
		}
	}
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = object;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp8_) : NULL);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp9_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (object);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1465 "rygel-media-export-media-cache.c"
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp4_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1514 "rygel-media-export-media-cache.c"
		} else {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1524 "rygel-media-export-media-cache.c"
		}
	}
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp3_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1533 "rygel-media-export-media-cache.c"
}


guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self) {
	guint32 result = 0U;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 1542 "rygel-media-export-media-cache.c"
	{
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, 0, &_inner_error_);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = _tmp1_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 1552 "rygel-media-export-media-cache.c"
			goto __catch8_g_error;
		}
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint32) _tmp0_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1559 "rygel-media-export-media-cache.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1571 "rygel-media-export-media-cache.c"
	}
	__finally8:
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0U;
#line 1582 "rygel-media-export-media-cache.c"
	}
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (guint32) 0;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1588 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count) {
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	GValue* values = NULL;
	const gchar* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GError * _inner_error_ = NULL;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_object_update_id = (guint32) 0;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_container_update_id = (guint32) 0;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_deleted_child_count = (guint32) 0;
#line 1629 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabase* _tmp3_ = NULL;
		GValue* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		sqlite3_stmt* _tmp7_ = NULL;
		sqlite3_stmt* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		sqlite3_stmt* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = values;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4__length1 = values_length1;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = rygel_media_export_database_exec_cursor (_tmp3_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp4_, _tmp4__length1, &_inner_error_);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp5_;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 1657 "rygel-media-export-media-cache.c"
			goto __catch9_g_error;
		}
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = cursor;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_export_database_cursor_next (_tmp6_, &_inner_error_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		statement = _tmp7_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 1670 "rygel-media-export-media-cache.c"
			goto __catch9_g_error;
		}
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = statement;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = sqlite3_column_int64 (_tmp8_, 0);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_object_update_id = (guint32) _tmp9_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = statement;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 1);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_container_update_id = (guint32) _tmp11_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = statement;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = sqlite3_column_int64 (_tmp12_, 2);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_total_deleted_child_count = (guint32) _tmp13_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (object_update_id) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*object_update_id = _vala_object_update_id;
#line 1699 "rygel-media-export-media-cache.c"
		}
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (container_update_id) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*container_update_id = _vala_container_update_id;
#line 1705 "rygel-media-export-media-cache.c"
		}
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (total_deleted_child_count) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*total_deleted_child_count = _vala_total_deleted_child_count;
#line 1711 "rygel-media-export-media-cache.c"
		}
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1715 "rygel-media-export-media-cache.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _error_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = _tmp14_->message;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:214: Failed to get update ids: %s", _tmp15_);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 1735 "rygel-media-export-media-cache.c"
	}
	__finally9:
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 1748 "rygel-media-export-media-cache.c"
	}
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (object_update_id) {
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*object_update_id = _vala_object_update_id;
#line 1756 "rygel-media-export-media-cache.c"
	}
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (container_update_id) {
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*container_update_id = _vala_container_update_id;
#line 1762 "rygel-media-export-media-cache.c"
	}
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_deleted_child_count) {
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_deleted_child_count = _vala_total_deleted_child_count;
#line 1768 "rygel-media-export-media-cache.c"
	}
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	sqlite3_stmt* statement = NULL;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp24_ = 0LL;
	sqlite3_stmt* _tmp25_ = NULL;
	gint64 _tmp26_ = 0LL;
	sqlite3_stmt* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GError * _inner_error_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp1_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = uri;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = self->priv->exists_cache;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = uri;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_) {
#line 1839 "rygel-media-export-media-cache.c"
		RygelMediaExportExistsCacheEntry* entry = NULL;
		GeeHashMap* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportExistsCacheEntry* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		RygelMediaExportExistsCacheEntry* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->exists_cache;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = uri;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->exists_cache;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = uri;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = entry;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = (*_tmp13_).mtime;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = _tmp14_;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = entry;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = (*_tmp15_).size;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_size = _tmp16_;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_exists_cache_entry_free0 (entry);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (uri);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (timestamp) {
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*timestamp = _vala_timestamp;
#line 1888 "rygel-media-export-media-cache.c"
		}
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (size) {
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*size = _vala_size;
#line 1894 "rygel-media-export-media-cache.c"
		}
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1898 "rygel-media-export-media-cache.c"
	}
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = values;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = values_length1;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp18_;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1920 "rygel-media-export-media-cache.c"
		} else {
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1932 "rygel-media-export-media-cache.c"
		}
	}
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = cursor;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	statement = _tmp20_;
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1955 "rygel-media-export-media-cache.c"
		} else {
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 235 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1969 "rygel-media-export-media-cache.c"
		}
	}
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = statement;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_timestamp = _tmp22_;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = _vala_timestamp;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = G_MAXINT64;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp23_ == _tmp24_) {
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = (gint64) 0;
#line 1986 "rygel-media-export-media-cache.c"
	}
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = statement;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = sqlite3_column_int64 (_tmp25_, 2);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_size = _tmp26_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = statement;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = sqlite3_column_int (_tmp27_, 0);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp28_ == 1;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (uri);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (timestamp) {
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*timestamp = _vala_timestamp;
#line 2010 "rygel-media-export-media-cache.c"
	}
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (size) {
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*size = _vala_size;
#line 2016 "rygel-media-export-media-cache.c"
	}
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2020 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue* values = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	glong _tmp7_ = 0L;
	GValue _tmp8_ = {0};
	GValue* _tmp9_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar* sql = NULL;
	RygelMediaExportSQLFactory* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GValue* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp21_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 252 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp1_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp4_, _tmp3_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = offset;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_LONG);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp8_, _tmp7_);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = g_new0 (GValue, 3);
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[0] = _tmp4_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[1] = _tmp6_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_[2] = _tmp8_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp9_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 3;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = self->priv->sql;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp12_;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = sort_criteria;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp13_, NULL, NULL);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp14_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = self->priv->db;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = sql;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = sort_order;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = values;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20__length1 = values_length1;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = rygel_media_export_database_exec_cursor (_tmp15_, _tmp19_, _tmp20_, _tmp20__length1, &_inner_error_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = _tmp21_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp19_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp22_;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sql);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2154 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp23_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp24_ = NULL;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = cursor;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = rygel_media_export_database_cursor_iterator (_tmp23_);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp24_;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2168 "rygel-media-export-media-cache.c"
			gboolean _tmp25_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp28_ = NULL;
			sqlite3_stmt* _tmp29_ = NULL;
			RygelMediaObjects* _tmp30_ = NULL;
			RygelMediaContainer* _tmp31_ = NULL;
			sqlite3_stmt* _tmp32_ = NULL;
			RygelMediaObject* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_ = NULL;
			RygelMediaObjects* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			RygelMediaObject* _tmp37_ = NULL;
			RygelMediaContainer* _tmp38_ = NULL;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = _statement_it;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = rygel_media_export_database_cursor_iterator_next (_tmp26_, &_inner_error_);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _tmp27_;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2208 "rygel-media-export-media-cache.c"
			}
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp25_) {
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2214 "rygel-media-export-media-cache.c"
			}
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = _statement_it;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = rygel_media_export_database_cursor_iterator_get (_tmp28_, &_inner_error_);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp29_;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2240 "rygel-media-export-media-cache.c"
			}
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = children;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = container;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = statement;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp31_, _tmp32_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = _tmp33_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp34_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp34_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = children;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = gee_list_last ((GeeList*) _tmp35_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = (RygelMediaObject*) _tmp36_;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = container;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp37_, _tmp38_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp37_);
#line 2268 "rygel-media-export-media-cache.c"
		}
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2272 "rygel-media-export-media-cache.c"
	}
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2286 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	guint max_objects = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	glong _tmp11_ = 0L;
	const gchar* _tmp12_ = NULL;
	GValueArray* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	glong _tmp15_ = 0L;
	RygelMediaObjects* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GValueArray* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	RygelMediaObjects* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2341 "rygel-media-export-media-cache.c"
	}
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 2347 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:283: Original search: %s", _tmp7_);
#line 283 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:284: Parsed search expression: %s", _tmp8_);
#line 2366 "rygel-media-export-media-cache.c"
	}
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = max_count;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_media_cache_modify_limit (self, _tmp9_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp10_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = filter;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = args;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = container_id;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp15_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2394 "rygel-media-export-media-cache.c"
	}
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_matches = (guint) _tmp11_;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = filter;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = args;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = container_id;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = sort_criteria;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = offset;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = max_objects;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, (glong) _tmp21_, (glong) _tmp22_, &_inner_error_);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp23_;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2424 "rygel-media-export-media-cache.c"
	}
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp16_;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_matches) {
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_matches = _vala_total_matches;
#line 2436 "rygel-media-export-media-cache.c"
	}
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2440 "rygel-media-export-media-cache.c"
}


static GValue* _g_value_dup (GValue* self) {
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 2447 "rygel-media-export-media-cache.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? _g_value_dup (self) : NULL;
#line 2454 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_free (GValue* self) {
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_unset (self);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 2463 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	glong _tmp29_ = 0L;
	const gchar* _tmp30_ = NULL;
	GValueArray* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	glong _tmp33_ = 0L;
	GError * _inner_error_ = NULL;
#line 300 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 304 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 304 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 305 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2504 "rygel-media-export-media-cache.c"
	}
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 2510 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:308: Original search: %s", _tmp7_);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:309: Parsed search expression: %s", _tmp8_);
#line 2529 "rygel-media-export-media-cache.c"
	}
	{
		gint i = 0;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2535 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp9_ = FALSE;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2542 "rygel-media-export-media-cache.c"
				gboolean _tmp10_ = FALSE;
				gint _tmp12_ = 0;
				GValueArray* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				GValue* _tmp17_ = NULL;
				GValue* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				GValue* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = _tmp9_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp10_) {
#line 2561 "rygel-media-export-media-cache.c"
					gint _tmp11_ = 0;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = i;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp11_ + 1;
#line 2567 "rygel-media-export-media-cache.c"
				}
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = FALSE;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = i;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = args;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = _tmp13_->n_values;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp12_) < _tmp14_)) {
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2581 "rygel-media-export-media-cache.c"
				}
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = args;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = i;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = g_value_array_get_nth (_tmp15_, (guint) _tmp16_);
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = __g_value_dup0 (_tmp17_);
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp18_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = arg;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp21_ = G_VALUE_HOLDS (_tmp20_, G_TYPE_STRING);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp21_) {
#line 2599 "rygel-media-export-media-cache.c"
					GValue* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = arg;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = g_value_get_string (_tmp22_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = g_strdup (_tmp23_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp19_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp19_ = _tmp24_;
#line 2613 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = arg;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = g_strdup_value_contents (_tmp25_);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp19_);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp19_ = _tmp26_;
#line 2625 "rygel-media-export-media-cache.c"
				}
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp27_ = i;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp28_ = _tmp19_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:314: Arg %d: %s", _tmp27_, _tmp28_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp19_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2637 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = filter;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = args;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = container_id;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp30_, _tmp31_, _tmp32_, &_inner_error_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = _tmp33_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2661 "rygel-media-export-media-cache.c"
	}
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp29_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2671 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_ = NULL;
	GValueArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	const gchar* _tmp7_ = NULL;
	RygelMediaExportSQLFactory* _tmp8_ = NULL;
	RygelMediaExportSQLString _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	RygelMediaExportDatabase* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GValueArray* _tmp16_ = NULL;
	GValue* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GError * _inner_error_ = NULL;
#line 324 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 324 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 324 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ != NULL) {
#line 2707 "rygel-media-export-media-cache.c"
		GValue v = {0};
		const gchar* _tmp1_ = NULL;
		GValue _tmp2_ = {0};
		GValueArray* _tmp3_ = NULL;
		GValue _tmp4_ = {0};
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container_id;
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp2_, G_TYPE_STRING);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp2_, _tmp1_);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		v = _tmp2_;
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = args;
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = v;
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_prepend (_tmp3_, &_tmp4_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 2729 "rygel-media-export-media-cache.c"
	}
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = args;
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_->n_values;
#line 334 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:334: Parameters to bind: %u", _tmp6_);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = container_id;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_ != NULL) {
#line 338 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
#line 2743 "rygel-media-export-media-cache.c"
	} else {
#line 340 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
#line 2747 "rygel-media-export-media-cache.c"
	}
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = self->priv->sql;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = string_id;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp8_, _tmp9_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	pattern = _tmp10_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = self->priv->db;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = filter;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = g_strdup_printf (pattern, _tmp13_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = args;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_->values;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = (gint) _tmp16_->n_values;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_database_query_value (_tmp12_, _tmp15_, _tmp17_, _tmp17__length1, &_inner_error_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp15_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp19_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2785 "rygel-media-export-media-cache.c"
	}
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (glong) _tmp11_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2791 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* children = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue v = {0};
	glong _tmp1_ = 0L;
	GValue _tmp2_ = {0};
	GValueArray* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	glong _tmp5_ = 0L;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	RygelMediaContainer* parent = NULL;
	GValueArray* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	const gchar* sql = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* sort_order = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GValueArray* _tmp44_ = NULL;
	GValue* _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp46_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = offset;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_LONG);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp2_, _tmp1_);
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp2_;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = v;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp3_, &_tmp4_);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = max_count;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp6_;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = args;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = v;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp7_, &_tmp8_);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = args;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = _tmp9_->n_values;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:361: Parameters to bind: %u", _tmp10_);
#line 2879 "rygel-media-export-media-cache.c"
	{
		gint i = 0;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2884 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp11_ = FALSE;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = TRUE;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2891 "rygel-media-export-media-cache.c"
				gboolean _tmp12_ = FALSE;
				gint _tmp14_ = 0;
				GValueArray* _tmp15_ = NULL;
				guint _tmp16_ = 0U;
				GValue* arg = NULL;
				GValueArray* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GValue* _tmp19_ = NULL;
				GValue* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GValue* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gint _tmp29_ = 0;
				const gchar* _tmp30_ = NULL;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = _tmp11_;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp12_) {
#line 2910 "rygel-media-export-media-cache.c"
					gint _tmp13_ = 0;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp13_ = i;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp13_ + 1;
#line 2916 "rygel-media-export-media-cache.c"
				}
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = FALSE;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = i;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = args;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = _tmp15_->n_values;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp14_) < _tmp16_)) {
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2930 "rygel-media-export-media-cache.c"
				}
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = args;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = i;
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = g_value_array_get_nth (_tmp17_, (guint) _tmp18_);
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = __g_value_dup0 (_tmp19_);
#line 363 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				arg = _tmp20_;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp22_ = arg;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = G_VALUE_HOLDS (_tmp22_, G_TYPE_STRING);
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp23_) {
#line 2948 "rygel-media-export-media-cache.c"
					GValue* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = arg;
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = g_value_get_string (_tmp24_);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = g_strdup (_tmp25_);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp21_);
#line 365 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = _tmp26_;
#line 2962 "rygel-media-export-media-cache.c"
				} else {
					GValue* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp27_ = arg;
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp28_ = g_strdup_value_contents (_tmp27_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp21_);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = _tmp28_;
#line 2974 "rygel-media-export-media-cache.c"
				}
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp29_ = i;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = _tmp21_;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:364: Arg %d: %s", _tmp29_, _tmp30_);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (_tmp21_);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				__vala_GValue_free0 (arg);
#line 2986 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = container_id;
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp31_ != NULL) {
#line 2994 "rygel-media-export-media-cache.c"
		RygelMediaExportSQLFactory* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = self->priv->sql;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = rygel_media_export_sql_factory_make (_tmp32_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp33_;
#line 3003 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaExportSQLFactory* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = self->priv->sql;
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		sql = _tmp35_;
#line 3013 "rygel-media-export-media-cache.c"
	}
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = sort_criteria;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp36_, NULL, NULL);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sort_order = _tmp37_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = self->priv->db;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = sql;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = filter;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = sort_order;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = g_strdup_printf (_tmp39_, _tmp40_, _tmp41_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp43_ = _tmp42_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = args;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = _tmp44_->values;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45__length1 = (gint) _tmp44_->n_values;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp46_ = rygel_media_export_database_exec_cursor (_tmp38_, _tmp43_, _tmp45_, _tmp45__length1, &_inner_error_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp47_ = _tmp46_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp43_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp47_;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sort_order);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (parent);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 377 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3061 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp48_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp49_ = NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = cursor;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = rygel_media_export_database_cursor_iterator (_tmp48_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp49_;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3075 "rygel-media-export-media-cache.c"
			gboolean _tmp50_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp51_ = NULL;
			gboolean _tmp52_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp53_ = NULL;
			sqlite3_stmt* _tmp54_ = NULL;
			const gchar* parent_id = NULL;
			sqlite3_stmt* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
			RygelMediaContainer* _tmp58_ = NULL;
			gboolean _tmp63_ = FALSE;
			RygelMediaContainer* _tmp68_ = NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = _statement_it;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp52_ = rygel_media_export_database_cursor_iterator_next (_tmp51_, &_inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = _tmp52_;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3113 "rygel-media-export-media-cache.c"
			}
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp50_) {
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3119 "rygel-media-export-media-cache.c"
			}
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp53_ = _statement_it;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp54_ = rygel_media_export_database_cursor_iterator_get (_tmp53_, &_inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp54_;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sort_order);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3145 "rygel-media-export-media-cache.c"
			}
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp55_ = statement;
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
#line 380 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_id = _tmp56_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp58_ = parent;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp58_ == NULL) {
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp57_ = TRUE;
#line 3159 "rygel-media-export-media-cache.c"
			} else {
				const gchar* _tmp59_ = NULL;
				RygelMediaContainer* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp59_ = parent_id;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp60_ = parent;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp61_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp60_);
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp62_ = _tmp61_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp57_ = g_strcmp0 (_tmp59_, _tmp62_) != 0;
#line 3175 "rygel-media-export-media-cache.c"
			}
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp63_ = _tmp57_;
#line 382 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp63_) {
#line 3181 "rygel-media-export-media-cache.c"
				const gchar* _tmp64_ = NULL;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp64_ = parent_id;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp64_ == NULL) {
#line 3187 "rygel-media-export-media-cache.c"
					RygelNullContainer* _tmp65_ = NULL;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp65_ = rygel_null_container_new_root ();
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					parent = (RygelMediaContainer*) _tmp65_;
#line 3195 "rygel-media-export-media-cache.c"
				} else {
					const gchar* _tmp66_ = NULL;
					RygelNullContainer* _tmp67_ = NULL;
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp66_ = parent_id;
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp67_ = rygel_null_container_new (_tmp66_, NULL, "MediaExport");
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 386 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					parent = (RygelMediaContainer*) _tmp67_;
#line 3207 "rygel-media-export-media-cache.c"
				}
			}
#line 390 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp68_ = parent;
#line 390 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp68_ != NULL) {
#line 3214 "rygel-media-export-media-cache.c"
				RygelMediaObjects* _tmp69_ = NULL;
				RygelMediaContainer* _tmp70_ = NULL;
				sqlite3_stmt* _tmp71_ = NULL;
				RygelMediaObject* _tmp72_ = NULL;
				RygelMediaObject* _tmp73_ = NULL;
				RygelMediaObjects* _tmp74_ = NULL;
				gpointer _tmp75_ = NULL;
				RygelMediaObject* _tmp76_ = NULL;
				RygelMediaContainer* _tmp77_ = NULL;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp69_ = children;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp70_ = parent;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp71_ = statement;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp72_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp70_, _tmp71_);
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp73_ = _tmp72_;
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, _tmp73_);
#line 391 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp73_);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp74_ = children;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp75_ = gee_list_last ((GeeList*) _tmp74_);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp76_ = (RygelMediaObject*) _tmp75_;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp77_ = parent;
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_set_parent_ref (_tmp76_, _tmp77_);
#line 393 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp76_);
#line 3250 "rygel-media-export-media-cache.c"
			} else {
				sqlite3_stmt* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp78_ = statement;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp79_ = sqlite3_column_text (_tmp78_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp80_ = parent_id;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp79_, _tmp80_);
#line 3263 "rygel-media-export-media-cache.c"
			}
		}
#line 379 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3268 "rygel-media-export-media-cache.c"
	}
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sort_order);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (parent);
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 402 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3282 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 3290 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:407: Database statistics:");
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 3302 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
		{
			RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
			RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp1_ = cursor;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_statement_it = _tmp2_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 3317 "rygel-media-export-media-cache.c"
				gboolean _tmp3_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				sqlite3_stmt* statement = NULL;
				RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
				sqlite3_stmt* _tmp7_ = NULL;
				sqlite3_stmt* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				sqlite3_stmt* _tmp10_ = NULL;
				gint _tmp11_ = 0;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = _statement_it;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_, &_inner_error_);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp3_ = _tmp5_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 3340 "rygel-media-export-media-cache.c"
					goto __catch10_g_error;
				}
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp3_) {
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 3347 "rygel-media-export-media-cache.c"
				}
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = _statement_it;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				statement = _tmp7_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 3361 "rygel-media-export-media-cache.c"
					goto __catch10_g_error;
				}
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = statement;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = sqlite3_column_text (_tmp8_, 0);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = statement;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = sqlite3_column_int (_tmp10_, 1);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:410: %s: %d", _tmp9_, _tmp11_);
#line 3374 "rygel-media-export-media-cache.c"
			}
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3378 "rygel-media-export-media-cache.c"
		}
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 3382 "rygel-media-export-media-cache.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 3394 "rygel-media-export-media-cache.c"
	}
	__finally10:
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3405 "rygel-media-export-media-cache.c"
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* children = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GValue* values = NULL;
	const gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	GValue* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 417 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 417 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 419 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 419 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container_id;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_STRING);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp2_, _tmp1_);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_[0] = _tmp2_;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp3_;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 420 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp4_, _tmp4__length1, &_inner_error_);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp5_;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 3469 "rygel-media-export-media-cache.c"
		} else {
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 3481 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = cursor;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = rygel_media_export_database_cursor_iterator (_tmp6_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp7_;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3496 "rygel-media-export-media-cache.c"
			gboolean _tmp8_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp11_ = NULL;
			sqlite3_stmt* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_, &_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = _tmp10_;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3528 "rygel-media-export-media-cache.c"
				} else {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3544 "rygel-media-export-media-cache.c"
				}
			}
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp8_) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3551 "rygel-media-export-media-cache.c"
			}
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3575 "rygel-media-export-media-cache.c"
				} else {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 3591 "rygel-media-export-media-cache.c"
				}
			}
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = children;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 3602 "rygel-media-export-media-cache.c"
		}
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3606 "rygel-media-export-media-cache.c"
	}
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3616 "rygel-media-export-media-cache.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 3629 "rygel-media-export-media-cache.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3659 "rygel-media-export-media-cache.c"
				goto __catch11_g_regex_error;
			}
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 3668 "rygel-media-export-media-cache.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 3684 "rygel-media-export-media-cache.c"
				goto __catch11_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 3695 "rygel-media-export-media-cache.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 3703 "rygel-media-export-media-cache.c"
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1246 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 3717 "rygel-media-export-media-cache.c"
	}
	__finally11:
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return NULL;
#line 3728 "rygel-media-export-media-cache.c"
	}
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	GValue v = {0};
	glong _tmp0_ = 0L;
	GValue _tmp1_ = {0};
	GValueArray* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	glong _tmp4_ = 0L;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	gchar* extra_columns = NULL;
	gint column_count = 0;
	GString* builder = NULL;
	GString* _tmp8_ = NULL;
	GeeArrayList* data = NULL;
	GeeArrayList* _tmp9_ = NULL;
	gchar* sql_sort_order = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GString* _tmp27_ = NULL;
	RygelMediaExportSQLFactory* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabase* _tmp34_ = NULL;
	GString* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GValueArray* _tmp37_ = NULL;
	GValue* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = offset;
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_LONG);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp1_, _tmp0_);
#line 439 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp1_;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = v;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp2_, &_tmp3_);
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = max_count;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 441 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp5_;
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = v;
#line 442 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp6_, &_tmp7_);
#line 446 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_string_new ("");
#line 446 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	builder = _tmp8_;
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	data = _tmp9_;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = sort_criteria;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp10_, &_tmp11_, &_tmp12_);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	extra_columns = _tmp11_;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column_count = _tmp12_;
#line 449 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql_sort_order = _tmp13_;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sql_sort_order;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = string_replace (_tmp14_, "o.title", "_column");
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql_sort_order);
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql_sort_order = _tmp15_;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = extra_columns;
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = string_replace (_tmp16_, "o.title", "1");
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 457 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	extra_columns = _tmp17_;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = add_all_container;
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp18_) {
#line 3856 "rygel-media-export-media-cache.c"
		GString* _tmp19_ = NULL;
		GString* _tmp26_ = NULL;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = builder;
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_string_append (_tmp19_, "SELECT 'all_place_holder' AS _column ");
#line 3863 "rygel-media-export-media-cache.c"
		{
			gint i = 0;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			i = 0;
#line 3868 "rygel-media-export-media-cache.c"
			{
				gboolean _tmp20_ = FALSE;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = TRUE;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				while (TRUE) {
#line 3875 "rygel-media-export-media-cache.c"
					gboolean _tmp21_ = FALSE;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					GString* _tmp25_ = NULL;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp21_ = _tmp20_;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (!_tmp21_) {
#line 3884 "rygel-media-export-media-cache.c"
						gint _tmp22_ = 0;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp22_ = i;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						i = _tmp22_ + 1;
#line 3890 "rygel-media-export-media-cache.c"
					}
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = FALSE;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = i;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = column_count;
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (!(_tmp23_ < _tmp24_)) {
#line 461 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						break;
#line 3902 "rygel-media-export-media-cache.c"
					}
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = builder;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp25_, ", 1 ");
#line 3908 "rygel-media-export-media-cache.c"
				}
			}
		}
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = builder;
#line 464 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_string_append (_tmp26_, "UNION ");
#line 3916 "rygel-media-export-media-cache.c"
	}
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = builder;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = self->priv->sql;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = rygel_media_export_sql_factory_make (_tmp28_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = column;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = extra_columns;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = filter;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = sql_sort_order;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_string_append_printf (_tmp27_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = self->priv->db;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = builder;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = _tmp35_->str;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = args;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = _tmp37_->values;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38__length1 = (gint) _tmp37_->n_values;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = rygel_media_export_database_exec_cursor (_tmp34_, _tmp36_, _tmp38_, _tmp38__length1, &_inner_error_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp39_;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (sql_sort_order);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (data);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_string_free0 (builder);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (extra_columns);
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 474 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3966 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp40_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp41_ = NULL;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = cursor;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = rygel_media_export_database_cursor_iterator (_tmp40_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp41_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3980 "rygel-media-export-media-cache.c"
			gboolean _tmp42_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp43_ = NULL;
			gboolean _tmp44_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp45_ = NULL;
			sqlite3_stmt* _tmp46_ = NULL;
			GeeArrayList* _tmp47_ = NULL;
			sqlite3_stmt* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = _statement_it;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = rygel_media_export_database_cursor_iterator_next (_tmp43_, &_inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = _tmp44_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_sort_order);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_string_free0 (builder);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (extra_columns);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 4016 "rygel-media-export-media-cache.c"
			}
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp42_) {
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 4022 "rygel-media-export-media-cache.c"
			}
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = _statement_it;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = rygel_media_export_database_cursor_iterator_get (_tmp45_, &_inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp46_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_sort_order);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_string_free0 (builder);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (extra_columns);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 4050 "rygel-media-export-media-cache.c"
			}
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = data;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = statement;
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp49_ = sqlite3_column_text (_tmp48_, 0);
#line 476 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp49_);
#line 4060 "rygel-media-export-media-cache.c"
		}
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 4064 "rygel-media-export-media-cache.c"
	}
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) data;
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (sql_sort_order);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (builder);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (extra_columns);
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 479 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4080 "rygel-media-export-media-cache.c"
}


/**
     * TODO
     */
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	GValueArray* args = NULL;
	GValueArray* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* column = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	guint max_objects = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	GeeList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GValueArray* _tmp12_ = NULL;
	glong _tmp13_ = 0L;
	const gchar* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	GeeList* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 485 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 485 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 485 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 493 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 493 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "AND", &_inner_error_);
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4138 "rygel-media-export-media-cache.c"
	}
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = filter;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:498: Parsed filter: %s", _tmp4_);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = attribute;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (_tmp5_, NULL, FALSE, &_inner_error_);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp6_;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4160 "rygel-media-export-media-cache.c"
	}
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp8_;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = column;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = filter;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = args;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = offset;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sort_criteria;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = max_objects;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = add_all_container;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, (glong) _tmp15_, _tmp16_, &_inner_error_);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _tmp17_;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (column);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4198 "rygel-media-export-media-cache.c"
	}
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp9_;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4210 "rygel-media-export-media-cache.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../../src/librygel-core/uuid.vapi"
	return result;
#line 4290 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 4299 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* cursor = NULL;
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		sqlite3_stmt* statement = NULL;
		RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
		sqlite3_stmt* _tmp2_ = NULL;
		sqlite3_stmt* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, 0, &_inner_error_);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4317 "rygel-media-export-media-cache.c"
				goto __catch12_rygel_media_export_database_error;
			}
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 4326 "rygel-media-export-media-cache.c"
		}
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = cursor;
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = rygel_media_export_database_cursor_next (_tmp1_, &_inner_error_);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		statement = _tmp2_;
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4340 "rygel-media-export-media-cache.c"
				goto __catch12_rygel_media_export_database_error;
			}
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 4351 "rygel-media-export-media-cache.c"
		}
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = statement;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = sqlite3_column_text (_tmp3_, 0);
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp5_;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4365 "rygel-media-export-media-cache.c"
	}
	goto __finally12;
	__catch12_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_ = NULL;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 519 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:519: Failed to get reset token");
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = uuid_get ();
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp6_;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4386 "rygel-media-export-media-cache.c"
	}
	__finally12:
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_clear_error (&_inner_error_);
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return NULL;
#line 4395 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token) {
	GError * _inner_error_ = NULL;
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (token != NULL);
#line 4405 "rygel-media-export-media-cache.c"
	{
		GValue* args = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		RygelMediaExportDatabase* _tmp3_ = NULL;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = token;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp1_, G_TYPE_STRING);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp1_, _tmp0_);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_new0 (GValue, 1);
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_[0] = _tmp1_;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = _tmp2_;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args_length1 = 1;
#line 527 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_args_size_ = args_length1;
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET reset_token = ?", args, args_length1, &_inner_error_);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4440 "rygel-media-export-media-cache.c"
				goto __catch13_rygel_media_export_database_error;
			}
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4451 "rygel-media-export-media-cache.c"
		}
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 4455 "rygel-media-export-media-cache.c"
	}
	goto __finally13;
	__catch13_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _error_;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _tmp4_->message;
#line 531 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:531: Failed to persist ServiceRese" \
"tToken: %s", _tmp5_);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4475 "rygel-media-export-media-cache.c"
	}
	__finally13:
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 526 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4486 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 4495 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, 0, &_inner_error_);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4506 "rygel-media-export-media-cache.c"
				goto __catch14_rygel_media_export_database_error;
			}
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 537 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4515 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _error_;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp1_->message;
#line 540 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:540: Failed to drop virtual folder" \
"s: %s", _tmp2_);
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4536 "rygel-media-export-media-cache.c"
	}
	__finally14:
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 536 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4547 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint guarded_val = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 544 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 544 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = guarded;
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp1_) {
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = 1;
#line 4568 "rygel-media-export-media-cache.c"
	} else {
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = 0;
#line 4572 "rygel-media-export-media-cache.c"
	}
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp0_;
#line 546 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	guarded_val = _tmp2_;
#line 4578 "rygel-media-export-media-cache.c"
	{
		GValue* values = NULL;
		GValue _tmp3_ = {0};
		RygelMediaObject* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GValue _tmp7_ = {0};
		GValue* _tmp8_ = NULL;
		gint values_length1 = 0;
		gint _values_size_ = 0;
		RygelMediaExportDatabase* _tmp9_ = NULL;
		RygelMediaExportSQLFactory* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp3_, G_TYPE_INT);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp3_, guarded_val);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = object;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = rygel_media_object_get_id (_tmp4_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _tmp5_;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp7_, G_TYPE_STRING);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp7_, _tmp6_);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = g_new0 (GValue, 2);
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_[0] = _tmp3_;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_[1] = _tmp7_;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = _tmp8_;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values_length1 = 2;
#line 549 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_values_size_ = values_length1;
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = self->priv->db;
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = self->priv->sql;
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp9_, _tmp11_, values, values_length1, &_inner_error_);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4632 "rygel-media-export-media-cache.c"
				goto __catch15_rygel_media_export_database_error;
			}
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 552 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4643 "rygel-media-export-media-cache.c"
		}
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 4647 "rygel-media-export-media-cache.c"
	}
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaObject* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = object;
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = rygel_media_object_get_id (_tmp12_);
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = _tmp13_;
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = _error_;
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = _tmp15_->message;
#line 554 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:554: Failed to mark item %s as gua" \
"rded (%d): %s", _tmp14_, guarded_val, _tmp16_);
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 4676 "rygel-media-export-media-cache.c"
	}
	__finally15:
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 548 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4687 "rygel-media-export-media-cache.c"
	}
}


gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp5_ = NULL;
	RygelMediaContainer* _tmp6_ = NULL;
	RygelMediaObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RygelMediaObject* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	RygelMediaObject* _tmp17_ = NULL;
	RygelMediaObject* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 4719 "rygel-media-export-media-cache.c"
		gchar* msg = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = _ ("Cannot create references to containers");
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		msg = _tmp2_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = msg;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp3_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp4_;
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (msg);
#line 566 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4743 "rygel-media-export-media-cache.c"
	}
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = object;
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = parent;
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_parent (_tmp5_, _tmp6_);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = object;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_object_get_ref_id (_tmp7_);
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _tmp8_;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp9_ == NULL) {
#line 4759 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp10_ = NULL;
		RygelMediaObject* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = object;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = object;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_object_get_id (_tmp11_);
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _tmp12_;
#line 574 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_ref_id (_tmp10_, _tmp13_);
#line 4774 "rygel-media-export-media-cache.c"
	}
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = object;
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = uuid_get ();
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_object_set_id (_tmp14_, _tmp16_);
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp16_);
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = object;
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp17_) : NULL, FALSE, &_inner_error_);
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 4796 "rygel-media-export-media-cache.c"
	}
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = object;
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_object_get_id (_tmp18_);
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp21_;
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4810 "rygel-media-export-media-cache.c"
}


static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 584 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 584 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 4821 "rygel-media-export-media-cache.c"
	{
		GValue* id_value = NULL;
		const gchar* _tmp0_ = NULL;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		gint id_value_length1 = 0;
		gint _id_value_size_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = id;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp1_, G_TYPE_STRING);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp1_, _tmp0_);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = g_new0 (GValue, 1);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_[0] = _tmp1_;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value = _tmp2_;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value_length1 = 1;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_id_value_size_ = id_value_length1;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, id_value_length1, &_inner_error_);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = _tmp4_;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 4857 "rygel-media-export-media-cache.c"
				goto __catch16_rygel_media_export_database_error;
			}
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 4868 "rygel-media-export-media-cache.c"
		}
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp3_ == 1;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4876 "rygel-media-export-media-cache.c"
	}
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = id;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _error_;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_->message;
#line 591 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:591: Failed to get whether item %s" \
" is guarded: %s", _tmp5_, _tmp7_);
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = FALSE;
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4903 "rygel-media-export-media-cache.c"
	}
	__finally16:
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_clear_error (&_inner_error_);
#line 585 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return FALSE;
#line 4912 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_ = NULL;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 599 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 600 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 600 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 600 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->exists_cache = _tmp0_;
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp1_;
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4941 "rygel-media-export-media-cache.c"
		} else {
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 601 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 4949 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursorIterator* _statement_it = NULL;
		RygelMediaExportDatabaseCursor* _tmp2_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = cursor;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp3_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 4964 "rygel-media-export-media-cache.c"
			gboolean _tmp4_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			sqlite3_stmt* statement = NULL;
			RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
			sqlite3_stmt* _tmp8_ = NULL;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			sqlite3_stmt* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			GeeHashMap* _tmp13_ = NULL;
			sqlite3_stmt* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp16_ = {0};
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp5_ = _statement_it;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = rygel_media_export_database_cursor_iterator_next (_tmp5_, &_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = _tmp6_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 4998 "rygel-media-export-media-cache.c"
				} else {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5010 "rygel-media-export-media-cache.c"
				}
			}
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp4_) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5017 "rygel-media-export-media-cache.c"
			}
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _statement_it;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = rygel_media_export_database_cursor_iterator_get (_tmp7_, &_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp8_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5037 "rygel-media-export-media-cache.c"
				} else {
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5049 "rygel-media-export-media-cache.c"
				}
			}
#line 603 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = statement;
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sqlite3_column_int64 (_tmp9_, 1);
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.mtime = _tmp10_;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = statement;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = sqlite3_column_int64 (_tmp11_, 0);
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.size = _tmp12_;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = self->priv->exists_cache;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 2);
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = entry;
#line 606 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
#line 5076 "rygel-media-export-media-cache.c"
		}
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 5080 "rygel-media-export-media-cache.c"
	}
#line 599 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 5084 "rygel-media-export-media-cache.c"
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 610 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = max_count;
#line 611 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint) (-1);
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5101 "rygel-media-export-media-cache.c"
	} else {
		guint _tmp1_ = 0U;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = max_count;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 614 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5110 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	RygelMediaExportDatabase* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaExportDatabase* _tmp2_ = NULL;
	gint old_version = 0;
	gint current_version = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 618 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = name;
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_export_database_new (_tmp1_, &_inner_error_);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp2_;
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5139 "rygel-media-export-media-cache.c"
	}
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->db = _tmp0_;
#line 620 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	old_version = -1;
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	current_version = _tmp3_;
#line 5151 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportMediaCacheUpgrader* upgrader = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		RygelMediaExportMediaCacheUpgrader* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		RygelMediaExportMediaCacheUpgrader* _tmp19_ = NULL;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_media_cache_upgrader_new (_tmp4_, _tmp5_);
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		upgrader = _tmp6_;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = upgrader;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp8_, &_tmp9_, &_inner_error_);
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		old_version = _tmp9_;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp10_;
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5184 "rygel-media-export-media-cache.c"
				goto __catch17_rygel_media_export_database_error;
			}
			goto __finally17;
		}
#line 625 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp7_) {
#line 5191 "rygel-media-export-media-cache.c"
			RygelMediaExportMediaCacheUpgrader* _tmp11_ = NULL;
			gint _tmp12_ = 0;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = upgrader;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = old_version;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (_tmp11_, _tmp12_);
#line 5200 "rygel-media-export-media-cache.c"
		} else {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = old_version;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = current_version;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp13_ == _tmp14_) {
#line 5210 "rygel-media-export-media-cache.c"
				RygelMediaExportMediaCacheUpgrader* _tmp15_ = NULL;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = upgrader;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp15_, &_inner_error_);
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5222 "rygel-media-export-media-cache.c"
						goto __catch17_rygel_media_export_database_error;
					}
					goto __finally17;
				}
			} else {
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GError* _tmp18_ = NULL;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = old_version;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = current_version;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp16_, _tmp17_);
#line 634 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 634 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp18_;
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5249 "rygel-media-export-media-cache.c"
					goto __catch17_rygel_media_export_database_error;
				}
				goto __finally17;
			}
		}
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = upgrader;
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp19_);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 5261 "rygel-media-export-media-cache.c"
	}
	goto __finally17;
	__catch17_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:641: %s", "Could not find schema version;" " checking for empty database...");
#line 5273 "rygel-media-export-media-cache.c"
		{
			gint rows = 0;
			RygelMediaExportDatabase* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = self->priv->db;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_database_query_value (_tmp20_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rows = _tmp21_;
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 5289 "rygel-media-export-media-cache.c"
					goto __catch18_rygel_media_export_database_error;
				}
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_clear_error (&_inner_error_);
#line 644 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 5300 "rygel-media-export-media-cache.c"
			}
#line 646 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = rows;
#line 646 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp22_ == 0) {
#line 5306 "rygel-media-export-media-cache.c"
				gboolean _tmp23_ = FALSE;
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:647: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = rygel_media_export_media_cache_create_schema (self);
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp23_) {
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (self->priv->db);
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					self->priv->db = NULL;
#line 652 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 652 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 5322 "rygel-media-export-media-cache.c"
				}
			} else {
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("rygel-media-export-media-cache.vala:655: Incompatible schema... cannot" \
" proceed");
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 656 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 658 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 658 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 5335 "rygel-media-export-media-cache.c"
			}
		}
		goto __finally18;
		__catch18_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_error_ = _inner_error_;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = NULL;
#line 661 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = _error_;
#line 661 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _tmp24_->message;
#line 661 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:661: Something weird going on: %s", _tmp25_);
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (self->priv->db);
#line 662 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			self->priv->db = NULL;
#line 664 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
#line 664 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = _tmp26_;
#line 664 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 5365 "rygel-media-export-media-cache.c"
			goto __finally18;
		}
		__finally18:
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 5373 "rygel-media-export-media-cache.c"
			goto __finally17;
		}
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 5378 "rygel-media-export-media-cache.c"
	}
	__finally17:
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5387 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GValue* values = NULL;
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	RygelMediaContainer* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	RygelMediaContainer* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue* _tmp26_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaExportDatabase* _tmp27_ = NULL;
	RygelMediaExportSQLFactory* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp0_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp0_, 0);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, "inode/directory");
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp2_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp3_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = container;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp4_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_STRING);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp7_, _tmp6_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp8_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp9_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp10_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp11_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp11_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp12_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp12_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp13_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp13_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp14_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp14_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp15_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp15_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp16_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp16_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp17_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp17_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = container;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp18_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_STRING);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp21_, _tmp20_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp22_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp23_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, -1);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp25_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = g_new0 (GValue, 20);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[0] = _tmp0_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[1] = _tmp1_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[2] = _tmp2_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[3] = _tmp3_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[4] = _tmp7_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[5] = _tmp8_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[6] = _tmp9_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[7] = _tmp10_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[8] = _tmp11_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[9] = _tmp12_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[10] = _tmp13_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[11] = _tmp14_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[12] = _tmp15_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[13] = _tmp16_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[14] = _tmp17_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[15] = _tmp21_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[16] = _tmp22_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[17] = _tmp23_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[18] = _tmp24_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_[19] = _tmp25_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp26_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 20;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = self->priv->db;
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = self->priv->sql;
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = rygel_media_export_sql_factory_make (_tmp28_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp27_, _tmp29_, values, values_length1, &_inner_error_);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 692 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 5575 "rygel-media-export-media-cache.c"
	}
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 5579 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	GValue* values = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GValue _tmp3_ = {0};
	RygelMediaItem* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	RygelMediaItem* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	RygelMediaItem* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	RygelMediaItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue _tmp30_ = {0};
	RygelMediaItem* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GValue _tmp36_ = {0};
	RygelMediaItem* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GValue _tmp40_ = {0};
	GValue* _tmp41_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaItem* _tmp42_ = NULL;
	RygelMediaItem* _tmp107_ = NULL;
	RygelMediaItem* _tmp137_ = NULL;
	RygelMediaExportDatabase* _tmp146_ = NULL;
	RygelMediaExportSQLFactory* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GValue* _tmp149_ = NULL;
	gint _tmp149__length1 = 0;
	GError * _inner_error_ = NULL;
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_item_get_size (_tmp0_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT64);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int64 (&_tmp3_, _tmp2_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_item_get_mime_type (_tmp4_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp7_, _tmp6_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp8_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp9_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp9_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp10_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = _tmp11_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp13_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp13_, _tmp12_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp14_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp15_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = rygel_media_item_get_date (_tmp16_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp19_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp19_, _tmp18_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp20_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp21_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp22_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp22_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp23_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp23_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp25_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp25_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp26_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp27_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = _tmp28_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp30_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp30_, _tmp29_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = rygel_media_item_get_dlna_profile (_tmp31_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = _tmp32_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp34_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp34_, _tmp33_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp35_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp36_, G_TYPE_INT);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp36_, -1);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = item;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = rygel_media_item_get_creator (_tmp37_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = _tmp38_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp40_, G_TYPE_STRING);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp40_, _tmp39_);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = g_new0 (GValue, 20);
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[0] = _tmp3_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[1] = _tmp7_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[2] = _tmp8_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[3] = _tmp9_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[4] = _tmp13_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[5] = _tmp14_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[6] = _tmp15_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[7] = _tmp19_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[8] = _tmp20_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[9] = _tmp21_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[10] = _tmp22_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[11] = _tmp23_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[12] = _tmp24_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[13] = _tmp25_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[14] = _tmp26_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[15] = _tmp30_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[16] = _tmp34_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[17] = _tmp35_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[18] = _tmp36_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_[19] = _tmp40_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp41_;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 20;
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 719 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp42_ = item;
#line 719 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 5810 "rygel-media-export-media-cache.c"
		RygelAudioItem* audio_item = NULL;
		RygelMediaItem* _tmp43_ = NULL;
		RygelAudioItem* _tmp44_ = NULL;
		GValue* _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		RygelAudioItem* _tmp46_ = NULL;
		glong _tmp47_ = 0L;
		glong _tmp48_ = 0L;
		GValue _tmp49_ = {0};
		GValue _tmp50_ = {0};
		GValue* _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		RygelAudioItem* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		GValue _tmp55_ = {0};
		GValue _tmp56_ = {0};
		GValue* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		RygelAudioItem* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		GValue _tmp61_ = {0};
		GValue _tmp62_ = {0};
		GValue* _tmp63_ = NULL;
		gint _tmp63__length1 = 0;
		RygelAudioItem* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GValue _tmp67_ = {0};
		GValue _tmp68_ = {0};
		GValue* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		RygelAudioItem* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		GValue _tmp73_ = {0};
		GValue _tmp74_ = {0};
		RygelMediaItem* _tmp75_ = NULL;
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = item;
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp43_) : NULL);
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp44_;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = values;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45__length1 = values_length1;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = audio_item;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = rygel_audio_item_get_duration (_tmp46_);
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = _tmp47_;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp49_, G_TYPE_LONG);
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_long (&_tmp49_, _tmp48_);
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp45_[14]) ? (g_value_unset (&_tmp45_[14]), NULL) : NULL;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_[14] = _tmp49_;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp45_[14];
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = values;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51__length1 = values_length1;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = audio_item;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = rygel_audio_item_get_bitrate (_tmp52_);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = _tmp53_;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp55_, G_TYPE_INT);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp55_, _tmp54_);
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp51_[8]) ? (g_value_unset (&_tmp51_[8]), NULL) : NULL;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_[8] = _tmp55_;
#line 722 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = _tmp51_[8];
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = values;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57__length1 = values_length1;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = audio_item;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = rygel_audio_item_get_sample_freq (_tmp58_);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = _tmp59_;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp61_, G_TYPE_INT);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp61_, _tmp60_);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp57_[9]) ? (g_value_unset (&_tmp57_[9]), NULL) : NULL;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_[9] = _tmp61_;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp62_ = _tmp57_[9];
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = values;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63__length1 = values_length1;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_ = audio_item;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp65_ = rygel_audio_item_get_bits_per_sample (_tmp64_);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp66_ = _tmp65_;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp67_, G_TYPE_INT);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp67_, _tmp66_);
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp63_[10]) ? (g_value_unset (&_tmp63_[10]), NULL) : NULL;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_[10] = _tmp67_;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp68_ = _tmp63_[10];
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69_ = values;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69__length1 = values_length1;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp70_ = audio_item;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp71_ = rygel_audio_item_get_channels (_tmp70_);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp72_ = _tmp71_;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp73_, G_TYPE_INT);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp73_, _tmp72_);
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp69_[11]) ? (g_value_unset (&_tmp69_[11]), NULL) : NULL;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp69_[11] = _tmp73_;
#line 725 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp74_ = _tmp69_[11];
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp75_ = item;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
#line 5960 "rygel-media-export-media-cache.c"
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaItem* _tmp76_ = NULL;
			RygelMediaExportMusicItem* _tmp77_ = NULL;
			GValue* _tmp78_ = NULL;
			gint _tmp78__length1 = 0;
			RygelMediaExportMusicItem* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			GValue _tmp82_ = {0};
			GValue _tmp83_ = {0};
			GValue* _tmp84_ = NULL;
			gint _tmp84__length1 = 0;
			RygelMediaExportMusicItem* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
			const gchar* _tmp87_ = NULL;
			GValue _tmp88_ = {0};
			GValue _tmp89_ = {0};
			GValue* _tmp90_ = NULL;
			gint _tmp90__length1 = 0;
			RygelMediaExportMusicItem* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			GValue _tmp94_ = {0};
			GValue _tmp95_ = {0};
			GValue* _tmp96_ = NULL;
			gint _tmp96__length1 = 0;
			RygelMediaExportMusicItem* _tmp97_ = NULL;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			GValue _tmp100_ = {0};
			GValue _tmp101_ = {0};
			GValue* _tmp102_ = NULL;
			gint _tmp102__length1 = 0;
			RygelMediaExportMusicItem* _tmp103_ = NULL;
			gint _tmp104_ = 0;
			GValue _tmp105_ = {0};
			GValue _tmp106_ = {0};
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76_ = item;
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp76_) : NULL);
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp77_;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_ = values;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78__length1 = values_length1;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp79_ = music_item;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp80_ = rygel_music_item_get_artist ((RygelMusicItem*) _tmp79_);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81_ = _tmp80_;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp82_, G_TYPE_STRING);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp82_, _tmp81_);
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp78_[5]) ? (g_value_unset (&_tmp78_[5]), NULL) : NULL;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_[5] = _tmp82_;
#line 728 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp83_ = _tmp78_[5];
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_ = values;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84__length1 = values_length1;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp85_ = music_item;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp86_ = rygel_music_item_get_album ((RygelMusicItem*) _tmp85_);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp87_ = _tmp86_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp88_, G_TYPE_STRING);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp88_, _tmp87_);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp84_[6]) ? (g_value_unset (&_tmp84_[6]), NULL) : NULL;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp84_[6] = _tmp88_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp89_ = _tmp84_[6];
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90_ = values;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90__length1 = values_length1;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp91_ = music_item;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp92_ = rygel_music_item_get_genre ((RygelMusicItem*) _tmp91_);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp93_ = _tmp92_;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp94_, G_TYPE_STRING);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp94_, _tmp93_);
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp90_[17]) ? (g_value_unset (&_tmp90_[17]), NULL) : NULL;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp90_[17] = _tmp94_;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp95_ = _tmp90_[17];
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96_ = values;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96__length1 = values_length1;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp97_ = music_item;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp98_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp97_);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp99_ = _tmp98_;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp100_, G_TYPE_INT);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp100_, _tmp99_);
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp96_[12]) ? (g_value_unset (&_tmp96_[12]), NULL) : NULL;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp96_[12] = _tmp100_;
#line 731 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp101_ = _tmp96_[12];
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102_ = values;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102__length1 = values_length1;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp103_ = music_item;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp104_ = _tmp103_->disc;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp105_, G_TYPE_INT);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp105_, _tmp104_);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp102_[18]) ? (g_value_unset (&_tmp102_[18]), NULL) : NULL;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp102_[18] = _tmp105_;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp106_ = _tmp102_[18];
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 6104 "rygel-media-export-media-cache.c"
		}
#line 719 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 6108 "rygel-media-export-media-cache.c"
	}
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp107_ = item;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 6114 "rygel-media-export-media-cache.c"
		RygelVisualItem* visual_item = NULL;
		RygelMediaItem* _tmp108_ = NULL;
		RygelVisualItem* _tmp109_ = NULL;
		GValue* _tmp110_ = NULL;
		gint _tmp110__length1 = 0;
		RygelVisualItem* _tmp111_ = NULL;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		GValue _tmp114_ = {0};
		GValue _tmp115_ = {0};
		GValue* _tmp116_ = NULL;
		gint _tmp116__length1 = 0;
		RygelVisualItem* _tmp117_ = NULL;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		GValue _tmp120_ = {0};
		GValue _tmp121_ = {0};
		GValue* _tmp122_ = NULL;
		gint _tmp122__length1 = 0;
		RygelVisualItem* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		GValue _tmp126_ = {0};
		GValue _tmp127_ = {0};
		RygelMediaItem* _tmp128_ = NULL;
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp108_ = item;
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp108_) : NULL);
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp109_;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110_ = values;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110__length1 = values_length1;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp111_ = visual_item;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp112_ = rygel_visual_item_get_width (_tmp111_);
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp113_ = _tmp112_;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp114_, G_TYPE_INT);
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp114_, _tmp113_);
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp110_[2]) ? (g_value_unset (&_tmp110_[2]), NULL) : NULL;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp110_[2] = _tmp114_;
#line 738 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp115_ = _tmp110_[2];
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116_ = values;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116__length1 = values_length1;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp117_ = visual_item;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp118_ = rygel_visual_item_get_height (_tmp117_);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp119_ = _tmp118_;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp120_, G_TYPE_INT);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp120_, _tmp119_);
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp116_[3]) ? (g_value_unset (&_tmp116_[3]), NULL) : NULL;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp116_[3] = _tmp120_;
#line 739 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp121_ = _tmp116_[3];
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122_ = values;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122__length1 = values_length1;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp123_ = visual_item;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp124_ = rygel_visual_item_get_color_depth (_tmp123_);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp125_ = _tmp124_;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp126_, G_TYPE_INT);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp126_, _tmp125_);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp122_[13]) ? (g_value_unset (&_tmp122_[13]), NULL) : NULL;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp122_[13] = _tmp126_;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp127_ = _tmp122_[13];
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp128_ = item;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM)) {
#line 6210 "rygel-media-export-media-cache.c"
			RygelMediaExportVideoItem* video_item = NULL;
			RygelMediaItem* _tmp129_ = NULL;
			RygelMediaExportVideoItem* _tmp130_ = NULL;
			GValue* _tmp131_ = NULL;
			gint _tmp131__length1 = 0;
			RygelMediaExportVideoItem* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			const gchar* _tmp134_ = NULL;
			GValue _tmp135_ = {0};
			GValue _tmp136_ = {0};
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp129_ = item;
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp129_) : NULL);
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp130_;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131_ = values;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131__length1 = values_length1;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp132_ = video_item;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp133_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp132_);
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp134_ = _tmp133_;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp135_, G_TYPE_STRING);
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp135_, _tmp134_);
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp131_[5]) ? (g_value_unset (&_tmp131_[5]), NULL) : NULL;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp131_[5] = _tmp135_;
#line 743 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp136_ = _tmp131_[5];
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 6249 "rygel-media-export-media-cache.c"
		}
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 6253 "rygel-media-export-media-cache.c"
	}
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp137_ = item;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM)) {
#line 6259 "rygel-media-export-media-cache.c"
		RygelMediaExportPlaylistItem* playlist_item = NULL;
		RygelMediaItem* _tmp138_ = NULL;
		RygelMediaExportPlaylistItem* _tmp139_ = NULL;
		GValue* _tmp140_ = NULL;
		gint _tmp140__length1 = 0;
		RygelMediaExportPlaylistItem* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		const gchar* _tmp143_ = NULL;
		GValue _tmp144_ = {0};
		GValue _tmp145_ = {0};
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp138_ = item;
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM) ? ((RygelMediaExportPlaylistItem*) _tmp138_) : NULL);
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		playlist_item = _tmp139_;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140_ = values;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140__length1 = values_length1;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp141_ = playlist_item;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp142_ = rygel_media_item_get_creator ((RygelMediaItem*) _tmp141_);
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp143_ = _tmp142_;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp144_, G_TYPE_STRING);
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp144_, _tmp143_);
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp140_[5]) ? (g_value_unset (&_tmp140_[5]), NULL) : NULL;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp140_[5] = _tmp144_;
#line 750 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp145_ = _tmp140_[5];
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (playlist_item);
#line 6298 "rygel-media-export-media-cache.c"
	}
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp146_ = self->priv->db;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp147_ = self->priv->sql;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp148_ = rygel_media_export_sql_factory_make (_tmp147_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp149_ = values;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp149__length1 = values_length1;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp146_, _tmp148_, _tmp149_, _tmp149__length1, &_inner_error_);
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 6320 "rygel-media-export-media-cache.c"
	}
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 6324 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GValue* values = NULL;
	gint _tmp19_ = 0;
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	RygelMediaObject* _tmp23_ = NULL;
	guint64 _tmp24_ = 0ULL;
	guint64 _tmp25_ = 0ULL;
	GValue _tmp26_ = {0};
	const gchar* _tmp27_ = NULL;
	GValue _tmp28_ = {0};
	RygelMediaObject* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue _tmp34_ = {0};
	RygelMediaObject* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GValue _tmp38_ = {0};
	GValue* _tmp39_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp40_ = NULL;
	RygelMediaExportDatabase* _tmp53_ = NULL;
	RygelMediaExportSQLFactory* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GValue* _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	GError * _inner_error_ = NULL;
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 760 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 760 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 761 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 6383 "rygel-media-export-media-cache.c"
	}
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = object;
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 764 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == NULL) {
#line 6393 "rygel-media-export-media-cache.c"
		GValue _tmp4_ = {0};
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp4_);
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp4_;
#line 6401 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = object;
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _tmp8_;
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 767 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp10_;
#line 6427 "rygel-media-export-media-cache.c"
	}
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = object;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp12_->uris;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp15_) {
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = NULL;
#line 6443 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = object;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _tmp16_->uris;
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 773 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = (gchar*) _tmp18_;
#line 6458 "rygel-media-export-media-cache.c"
	}
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = type;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_INT);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp20_, _tmp19_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = parent;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp21_)) {
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp22_, G_VALUE_TYPE (&_tmp21_));
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp21_, &_tmp22_);
#line 6474 "rygel-media-export-media-cache.c"
	} else {
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = _tmp21_;
#line 6478 "rygel-media-export-media-cache.c"
	}
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = object;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = rygel_media_object_get_modified (_tmp23_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = _tmp24_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp26_, G_TYPE_UINT64);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp26_, _tmp25_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = _tmp11_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp28_, G_TYPE_STRING);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp28_, _tmp27_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = object;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = rygel_media_object_get_object_update_id (_tmp29_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = _tmp30_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp32_, G_TYPE_UINT);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint (&_tmp32_, _tmp31_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp33_, G_TYPE_INT);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp33_, -1);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp34_, G_TYPE_INT);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp34_, -1);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = object;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = rygel_media_object_get_id (_tmp35_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = _tmp36_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp38_, G_TYPE_STRING);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp38_, _tmp37_);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = g_new0 (GValue, 8);
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[0] = _tmp20_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[1] = _tmp22_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[2] = _tmp26_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[3] = _tmp28_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[4] = _tmp32_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[5] = _tmp33_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[6] = _tmp34_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_[7] = _tmp38_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp39_;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 8;
#line 770 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = object;
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 6552 "rygel-media-export-media-cache.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp41_ = NULL;
		RygelMediaContainer* _tmp42_ = NULL;
		GValue* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		RygelMediaContainer* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		GValue _tmp46_ = {0};
		GValue _tmp47_ = {0};
		GValue* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		RygelMediaContainer* _tmp49_ = NULL;
		guint32 _tmp50_ = 0U;
		GValue _tmp51_ = {0};
		GValue _tmp52_ = {0};
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = object;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp41_) : NULL);
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		container = _tmp42_;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = values;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43__length1 = values_length1;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = container;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = _tmp44_->total_deleted_child_count;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp46_, G_TYPE_INT64);
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int64 (&_tmp46_, _tmp45_);
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp43_[6]) ? (g_value_unset (&_tmp43_[6]), NULL) : NULL;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_[6] = _tmp46_;
#line 781 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = _tmp43_[6];
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = values;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48__length1 = values_length1;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = container;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp49_->update_id;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp51_, G_TYPE_UINT);
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_uint (&_tmp51_, _tmp50_);
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp48_[7]) ? (g_value_unset (&_tmp48_[7]), NULL) : NULL;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_[7] = _tmp51_;
#line 782 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = _tmp48_[7];
#line 779 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (container);
#line 6612 "rygel-media-export-media-cache.c"
	}
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp53_ = self->priv->db;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp54_ = self->priv->sql;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_ = rygel_media_export_sql_factory_make (_tmp54_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp56_ = values;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp56__length1 = values_length1;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp53_, _tmp55_, _tmp56_, _tmp56__length1, &_inner_error_);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 785 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 6638 "rygel-media-export-media-cache.c"
	}
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp11_);
#line 756 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 6646 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error) {
	gint type = 0;
	GValue parent = {0};
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gchar* _tmp21_ = NULL;
	RygelMediaObject* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GValue* values = NULL;
	RygelMediaObject* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GValue _tmp30_ = {0};
	RygelMediaObject* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GValue _tmp34_ = {0};
	gint _tmp35_ = 0;
	GValue _tmp36_ = {0};
	GValue _tmp37_ = {0};
	GValue _tmp38_ = {0};
	RygelMediaObject* _tmp39_ = NULL;
	guint64 _tmp40_ = 0ULL;
	guint64 _tmp41_ = 0ULL;
	GValue _tmp42_ = {0};
	const gchar* _tmp43_ = NULL;
	GValue _tmp44_ = {0};
	RygelMediaObject* _tmp45_ = NULL;
	guint _tmp46_ = 0U;
	guint _tmp47_ = 0U;
	GValue _tmp48_ = {0};
	GValue _tmp49_ = {0};
	GValue _tmp50_ = {0};
	gint _tmp51_ = 0;
	GValue _tmp52_ = {0};
	const gchar* _tmp53_ = NULL;
	GValue _tmp54_ = {0};
	GValue* _tmp55_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	RygelMediaObject* _tmp56_ = NULL;
	RygelMediaExportDatabase* _tmp69_ = NULL;
	RygelMediaExportSQLFactory* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GValue* _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	GError * _inner_error_ = NULL;
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 790 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 793 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 793 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 794 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 6721 "rygel-media-export-media-cache.c"
	}
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = object;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = _tmp2_;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == NULL) {
#line 6731 "rygel-media-export-media-cache.c"
		GValue _tmp4_ = {0};
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp4_);
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 798 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp4_;
#line 6739 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp5_ = NULL;
		RygelMediaContainer* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GValue _tmp10_ = {0};
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = object;
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = _tmp8_;
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp10_, G_TYPE_STRING);
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp10_, _tmp9_);
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 800 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp10_;
#line 6765 "rygel-media-export-media-cache.c"
	}
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = object;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp12_->uris;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp15_) {
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = NULL;
#line 6781 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp16_ = NULL;
		GeeArrayList* _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = object;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _tmp16_->uris;
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 808 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = (gchar*) _tmp18_;
#line 6796 "rygel-media-export-media-cache.c"
	}
#line 812 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = is_guarded;
#line 812 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp20_) {
#line 812 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = 1;
#line 6804 "rygel-media-export-media-cache.c"
	} else {
#line 812 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = 0;
#line 6808 "rygel-media-export-media-cache.c"
	}
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = object;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = rygel_media_object_get_ref_id (_tmp22_);
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = _tmp23_;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = _tmp25_;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = _tmp21_;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp26_ == NULL) {
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp21_);
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = NULL;
#line 6828 "rygel-media-export-media-cache.c"
	}
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = object;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = rygel_media_object_get_id (_tmp27_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = _tmp28_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp30_, G_TYPE_STRING);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp30_, _tmp29_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = object;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = rygel_media_object_get_title (_tmp31_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = _tmp32_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp34_, G_TYPE_STRING);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp34_, _tmp33_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = type;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp36_, G_TYPE_INT);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp36_, _tmp35_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp37_ = parent;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp37_)) {
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp38_, G_VALUE_TYPE (&_tmp37_));
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp37_, &_tmp38_);
#line 6864 "rygel-media-export-media-cache.c"
	} else {
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_ = _tmp37_;
#line 6868 "rygel-media-export-media-cache.c"
	}
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp39_ = object;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = rygel_media_object_get_modified (_tmp39_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp41_ = _tmp40_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp42_, G_TYPE_UINT64);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp42_, _tmp41_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp43_ = _tmp11_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp44_, G_TYPE_STRING);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp44_, _tmp43_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = object;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp46_ = rygel_media_object_get_object_update_id (_tmp45_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp47_ = _tmp46_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp48_, G_TYPE_UINT);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint (&_tmp48_, _tmp47_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp49_, G_TYPE_INT);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp49_, -1);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp50_, G_TYPE_INT);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp50_, -1);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp51_ = _tmp19_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp52_, G_TYPE_INT);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp52_, _tmp51_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp53_ = _tmp21_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp54_, G_TYPE_STRING);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp54_, _tmp53_);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_ = g_new0 (GValue, 11);
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[0] = _tmp30_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[1] = _tmp34_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[2] = _tmp36_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[3] = _tmp38_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[4] = _tmp42_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[5] = _tmp44_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[6] = _tmp48_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[7] = _tmp49_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[8] = _tmp50_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[9] = _tmp52_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp55_[10] = _tmp54_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp55_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 11;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp56_ = object;
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 6950 "rygel-media-export-media-cache.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp57_ = NULL;
		RygelMediaContainer* _tmp58_ = NULL;
		GValue* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		RygelMediaContainer* _tmp60_ = NULL;
		gint64 _tmp61_ = 0LL;
		GValue _tmp62_ = {0};
		GValue _tmp63_ = {0};
		GValue* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		RygelMediaContainer* _tmp65_ = NULL;
		guint32 _tmp66_ = 0U;
		GValue _tmp67_ = {0};
		GValue _tmp68_ = {0};
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = object;
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp57_) : NULL);
#line 816 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		container = _tmp58_;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = values;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59__length1 = values_length1;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = container;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp61_ = _tmp60_->total_deleted_child_count;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp62_, G_TYPE_INT64);
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int64 (&_tmp62_, _tmp61_);
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp59_[7]) ? (g_value_unset (&_tmp59_[7]), NULL) : NULL;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_[7] = _tmp62_;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = _tmp59_[7];
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_ = values;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64__length1 = values_length1;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp65_ = container;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp66_ = _tmp65_->update_id;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp67_, G_TYPE_UINT);
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_uint (&_tmp67_, _tmp66_);
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp64_[8]) ? (g_value_unset (&_tmp64_[8]), NULL) : NULL;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_[8] = _tmp67_;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp68_ = _tmp64_[8];
#line 815 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (container);
#line 7010 "rygel-media-export-media-cache.c"
	}
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp69_ = self->priv->db;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp70_ = self->priv->sql;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp71_ = rygel_media_export_sql_factory_make (_tmp70_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp72_ = values;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp72__length1 = values_length1;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp69_, _tmp71_, _tmp72_, _tmp72__length1, &_inner_error_);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp21_);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp11_);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 7038 "rygel-media-export-media-cache.c"
	}
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp21_);
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp11_);
#line 788 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 7048 "rygel-media-export-media-cache.c"
}


/**
     * Add the container or item to the cache.
     */
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error) {
	gboolean is_guarded = FALSE;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 829 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 829 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 829 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 829 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_is_object_guarded (self, _tmp2_);
#line 829 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	is_guarded = _tmp3_;
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = override_guarded;
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (!_tmp5_) {
#line 7083 "rygel-media-export-media-cache.c"
		gboolean _tmp6_ = FALSE;
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = is_guarded;
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _tmp6_;
#line 7089 "rygel-media-export-media-cache.c"
	} else {
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = FALSE;
#line 7093 "rygel-media-export-media-cache.c"
	}
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = _tmp4_;
#line 831 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_) {
#line 7099 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp8_ = NULL;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = object;
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_update_guarded_object (self, _tmp8_, &_inner_error_);
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 832 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 7111 "rygel-media-export-media-cache.c"
		}
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		RygelMediaObject* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = is_guarded;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp10_) {
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 7124 "rygel-media-export-media-cache.c"
		} else {
			gboolean _tmp11_ = FALSE;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = override_guarded;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _tmp11_;
#line 7131 "rygel-media-export-media-cache.c"
		}
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = object;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = _tmp9_;
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_normal_object (self, _tmp12_, _tmp13_, &_inner_error_);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 834 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 7145 "rygel-media-export-media-cache.c"
		}
	}
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 846 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 7164 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_ = NULL;
		RygelMediaExportDatabase* _tmp1_ = NULL;
		RygelMediaExportSQLFactory* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_ = NULL;
		RygelMediaExportSQLFactory* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_ = NULL;
		RygelMediaExportSQLFactory* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_ = NULL;
		RygelMediaExportSQLFactory* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_ = NULL;
		RygelMediaExportSQLFactory* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_ = NULL;
		RygelMediaExportSQLFactory* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		RygelMediaExportDatabase* _tmp19_ = NULL;
		RygelMediaExportDatabase* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 848 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7195 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = self->priv->db;
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->sql;
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
#line 849 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7208 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
#line 850 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7221 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = self->priv->db;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->sql;
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
#line 851 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7234 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = self->priv->db;
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->sql;
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
#line 852 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7247 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = self->priv->db;
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = self->priv->sql;
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
#line 853 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7260 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = self->priv->db;
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = self->priv->sql;
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
#line 854 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7273 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = self->priv->db;
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp19_, &_inner_error_);
#line 855 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 7282 "rygel-media-export-media-cache.c"
			goto __catch19_g_error;
		}
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = self->priv->db;
#line 856 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (_tmp20_);
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = uuid_get ();
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = _tmp21_;
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
#line 857 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp22_);
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 859 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 7301 "rygel-media-export-media-cache.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		RygelMediaExportDatabase* _tmp25_ = NULL;
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		err = _inner_error_;
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 861 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = err;
#line 861 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = _tmp23_->message;
#line 861 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:861: Failed to create schema: %s", _tmp24_);
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = self->priv->db;
#line 862 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp25_);
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (err);
#line 7326 "rygel-media-export-media-cache.c"
	}
	__finally19:
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 847 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return FALSE;
#line 7337 "rygel-media-export-media-cache.c"
	}
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = FALSE;
#line 865 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7343 "rygel-media-export-media-cache.c"
}


/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object = NULL;
	const gchar* title = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* object_id = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* uri = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp38_ = NULL;
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 877 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 879 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = NULL;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = statement;
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
#line 880 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	title = _tmp1_;
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = statement;
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 881 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object_id = _tmp3_;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
#line 882 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp5_;
#line 884 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = statement;
#line 884 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
#line 884 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (_tmp7_) {
#line 884 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 0:
#line 7403 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportObjectFactory* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaContainer* container = NULL;
			RygelMediaObject* _tmp13_ = NULL;
			RygelMediaContainer* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			RygelMediaContainer* _tmp22_ = NULL;
			sqlite3_stmt* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = self->priv->factory;
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = object_id;
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = title;
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = uri;
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 887 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp12_;
#line 889 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = object;
#line 889 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
#line 889 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			container = _tmp14_;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = uri;
#line 890 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp15_ != NULL) {
#line 7444 "rygel-media-export-media-cache.c"
				RygelMediaContainer* _tmp16_ = NULL;
				GeeArrayList* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = container;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = ((RygelMediaObject*) _tmp16_)->uris;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = uri;
#line 891 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 7456 "rygel-media-export-media-cache.c"
			}
#line 893 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = container;
#line 893 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = statement;
#line 893 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = sqlite3_column_int64 (_tmp20_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT);
#line 893 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_->total_deleted_child_count = (gint64) ((guint32) _tmp21_);
#line 895 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = container;
#line 895 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = statement;
#line 895 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = sqlite3_column_int64 (_tmp23_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID);
#line 895 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_->update_id = (guint32) ((guint) _tmp24_);
#line 897 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (container);
#line 897 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 7478 "rygel-media-export-media-cache.c"
		}
#line 884 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 1:
#line 7482 "rygel-media-export-media-cache.c"
		{
			const gchar* upnp_class = NULL;
			sqlite3_stmt* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			RygelMediaExportObjectFactory* _tmp27_ = NULL;
			RygelMediaContainer* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			RygelMediaItem* _tmp32_ = NULL;
			sqlite3_stmt* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
#line 900 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = statement;
#line 900 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = sqlite3_column_text (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
#line 900 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			upnp_class = _tmp26_;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = self->priv->factory;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = parent;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = object_id;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = title;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = upnp_class;
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = rygel_media_export_object_factory_get_item (_tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 902 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp32_;
#line 906 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = statement;
#line 906 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = object;
#line 906 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, _tmp33_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp34_) : NULL);
#line 908 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = uri;
#line 908 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp35_ != NULL) {
#line 7528 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
#line 909 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp36_ = object;
#line 909 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp37_ = uri;
#line 909 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_item_add_uri (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp36_) : NULL, _tmp37_);
#line 7537 "rygel-media-export-media-cache.c"
			}
#line 911 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 7541 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 913 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 7547 "rygel-media-export-media-cache.c"
		}
	}
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp38_ = object;
#line 916 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp38_ != NULL) {
#line 7554 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp39_ = NULL;
		sqlite3_stmt* _tmp40_ = NULL;
		gint64 _tmp41_ = 0LL;
		gboolean _tmp42_ = FALSE;
		RygelMediaObject* _tmp43_ = NULL;
		guint64 _tmp44_ = 0ULL;
		guint64 _tmp45_ = 0ULL;
		gint64 _tmp46_ = 0LL;
		gboolean _tmp48_ = FALSE;
		RygelMediaObject* _tmp51_ = NULL;
		sqlite3_stmt* _tmp52_ = NULL;
		gint64 _tmp53_ = 0LL;
		RygelMediaObject* _tmp54_ = NULL;
		sqlite3_stmt* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp39_ = object;
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = statement;
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = sqlite3_column_int64 (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
#line 917 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_modified (_tmp39_, (guint64) _tmp41_);
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = object;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = rygel_media_object_get_modified (_tmp43_);
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = _tmp44_;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp46_ = G_MAXINT64;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp45_ == ((guint64) _tmp46_)) {
#line 7588 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp47_ = NULL;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = object;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, RYGEL_TYPE_MEDIA_ITEM);
#line 7594 "rygel-media-export-media-cache.c"
		} else {
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = FALSE;
#line 7598 "rygel-media-export-media-cache.c"
		}
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = _tmp42_;
#line 918 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp48_) {
#line 7604 "rygel-media-export-media-cache.c"
			RygelMediaObject* _tmp49_ = NULL;
			RygelMediaObject* _tmp50_ = NULL;
#line 919 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp49_ = object;
#line 919 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_modified (_tmp49_, (guint64) 0);
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = object;
#line 920 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp50_) : NULL, TRUE);
#line 7615 "rygel-media-export-media-cache.c"
		}
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = object;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = statement;
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = sqlite3_column_int64 (_tmp52_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID);
#line 922 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_object_update_id (_tmp51_, (guint) _tmp53_);
#line 924 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = object;
#line 924 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = statement;
#line 924 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
#line 924 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_object_set_ref_id (_tmp54_, _tmp56_);
#line 7633 "rygel-media-export-media-cache.c"
	}
#line 927 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = object;
#line 927 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7639 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaItem* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaItem* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelMediaItem* _tmp9_ = NULL;
	sqlite3_stmt* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	RygelMediaItem* _tmp12_ = NULL;
	sqlite3_stmt* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelMediaItem* _tmp15_ = NULL;
	RygelMediaItem* _tmp49_ = NULL;
#line 930 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 930 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 930 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 932 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 932 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = statement;
#line 932 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
#line 932 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_date (_tmp0_, _tmp2_);
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = item;
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
#line 933 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_mime_type (_tmp3_, _tmp5_);
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = item;
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = statement;
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = sqlite3_column_text (_tmp7_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
#line 934 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_dlna_profile (_tmp6_, _tmp8_);
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = item;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = statement;
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = sqlite3_column_int64 (_tmp10_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
#line 935 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_size (_tmp9_, _tmp11_);
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = item;
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = statement;
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sqlite3_column_text (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
#line 936 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_creator (_tmp12_, _tmp14_);
#line 938 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = item;
#line 938 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 7711 "rygel-media-export-media-cache.c"
		RygelAudioItem* audio_item = NULL;
		RygelMediaItem* _tmp16_ = NULL;
		RygelAudioItem* _tmp17_ = NULL;
		RygelAudioItem* _tmp18_ = NULL;
		sqlite3_stmt* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_ = NULL;
		sqlite3_stmt* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_ = NULL;
		sqlite3_stmt* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_ = NULL;
		sqlite3_stmt* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_ = NULL;
		sqlite3_stmt* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		RygelMediaItem* _tmp33_ = NULL;
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = item;
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp16_) : NULL);
#line 939 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp17_;
#line 940 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = audio_item;
#line 940 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = statement;
#line 940 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
#line 940 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_duration (_tmp18_, (glong) _tmp20_);
#line 942 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = audio_item;
#line 942 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = statement;
#line 942 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
#line 942 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_bitrate (_tmp21_, _tmp23_);
#line 943 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = audio_item;
#line 943 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = statement;
#line 943 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
#line 943 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_sample_freq (_tmp24_, _tmp26_);
#line 945 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = audio_item;
#line 945 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp28_ = statement;
#line 945 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
#line 945 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_bits_per_sample (_tmp27_, _tmp29_);
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_ = audio_item;
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp31_ = statement;
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
#line 947 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_audio_item_set_channels (_tmp30_, _tmp32_);
#line 948 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = item;
#line 948 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
#line 7781 "rygel-media-export-media-cache.c"
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaItem* _tmp34_ = NULL;
			RygelMediaExportMusicItem* _tmp35_ = NULL;
			RygelMediaExportMusicItem* _tmp36_ = NULL;
			sqlite3_stmt* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			RygelMediaExportMusicItem* _tmp39_ = NULL;
			sqlite3_stmt* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			RygelMediaExportMusicItem* _tmp42_ = NULL;
			sqlite3_stmt* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			RygelMediaExportMusicItem* _tmp45_ = NULL;
			sqlite3_stmt* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			RygelMediaExportMusicItem* _tmp48_ = NULL;
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = item;
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp34_) : NULL);
#line 949 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp35_;
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = music_item;
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = statement;
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 950 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_set_artist ((RygelMusicItem*) _tmp36_, _tmp38_);
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = music_item;
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = statement;
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = sqlite3_column_text (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
#line 951 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_set_album ((RygelMusicItem*) _tmp39_, _tmp41_);
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = music_item;
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = statement;
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = sqlite3_column_text (_tmp43_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
#line 952 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_set_genre ((RygelMusicItem*) _tmp42_, _tmp44_);
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = music_item;
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = statement;
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = sqlite3_column_int (_tmp46_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
#line 953 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp45_, _tmp47_);
#line 955 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = music_item;
#line 955 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp48_);
#line 948 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 7842 "rygel-media-export-media-cache.c"
		}
#line 938 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 7846 "rygel-media-export-media-cache.c"
	}
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp49_ = item;
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 7852 "rygel-media-export-media-cache.c"
		RygelVisualItem* visual_item = NULL;
		RygelMediaItem* _tmp50_ = NULL;
		RygelVisualItem* _tmp51_ = NULL;
		RygelVisualItem* _tmp52_ = NULL;
		sqlite3_stmt* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		RygelVisualItem* _tmp55_ = NULL;
		sqlite3_stmt* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_ = NULL;
		sqlite3_stmt* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = item;
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp50_) : NULL);
#line 960 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp51_;
#line 961 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = visual_item;
#line 961 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = statement;
#line 961 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = sqlite3_column_int (_tmp53_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
#line 961 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_width (_tmp52_, _tmp54_);
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = visual_item;
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = statement;
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
#line 962 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_height (_tmp55_, _tmp57_);
#line 963 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = visual_item;
#line 963 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = statement;
#line 963 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
#line 963 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_color_depth (_tmp58_, _tmp60_);
#line 959 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 7897 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	gchar* filter = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GValueArray* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 968 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 973 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 973 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 7921 "rygel-media-export-media-cache.c"
		gchar* _tmp1_ = NULL;
#line 974 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 974 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 974 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 7929 "rygel-media-export-media-cache.c"
	}
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (_tmp2_, _tmp3_, &_inner_error_);
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp4_;
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 977 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 7945 "rygel-media-export-media-cache.c"
	}
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = prefix;
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = filter;
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp7_;
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 979 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 7959 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 982 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 986 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 986 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 7974 "rygel-media-export-media-cache.c"
		gchar* _tmp1_ = NULL;
#line 987 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 987 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 987 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 7982 "rygel-media-export-media-cache.c"
	}
#line 990 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 990 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
#line 7988 "rygel-media-export-media-cache.c"
		gchar* _tmp3_ = NULL;
		RygelSearchExpression* _tmp4_ = NULL;
		GValueArray* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = expression;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = args;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp4_) : NULL, _tmp5_, &_inner_error_);
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = _tmp6_;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8007 "rygel-media-export-media-cache.c"
		}
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp3_;
#line 991 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8013 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp7_ = NULL;
		RygelSearchExpression* _tmp8_ = NULL;
		GValueArray* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = expression;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = args;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp8_) : NULL, _tmp9_, &_inner_error_);
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp10_;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8033 "rygel-media-export-media-cache.c"
		}
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp7_;
#line 994 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 8039 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	gchar* left_sql_string = NULL;
	RygelLogicalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GValueArray* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* right_sql_string = NULL;
	RygelLogicalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValueArray* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* operator_sql_string = NULL;
	RygelLogicalExpression* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 1000 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 1000 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	left_sql_string = _tmp3_;
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1004 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8084 "rygel-media-export-media-cache.c"
	}
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	right_sql_string = _tmp7_;
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (left_sql_string);
#line 1007 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8104 "rygel-media-export-media-cache.c"
	}
#line 1010 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	operator_sql_string = "OR";
#line 1012 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = expression;
#line 1012 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = ((RygelSearchExpression*) _tmp8_)->op;
#line 1012 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (((RygelLogicalOperator) ((gintptr) _tmp9_)) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 1013 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		operator_sql_string = "AND";
#line 8116 "rygel-media-export-media-cache.c"
	}
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = left_sql_string;
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = operator_sql_string;
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = right_sql_string;
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = g_strdup_printf ("(%s %s %s)", _tmp10_, _tmp11_, _tmp12_);
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp13_;
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (right_sql_string);
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (left_sql_string);
#line 1016 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8134 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column = NULL;
	gboolean use_collation = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label0 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label1 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label2 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label3 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label4 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label5 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label6 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label7 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label8 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label9 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label10 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label11 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label12 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label13 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label14 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label15 = 0;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label16 = 0;
#line 8180 "rygel-media-export-media-cache.c"
	gboolean _tmp25_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1021 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 1025 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = NULL;
#line 1026 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	use_collation = FALSE;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = operand;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_;
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8199 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp4_ = NULL;
#line 1030 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = g_strdup ("o.uri");
#line 1030 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1030 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp4_;
#line 1031 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8211 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8217 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp5_ = NULL;
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = g_strdup ("m.duration");
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1033 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp5_;
#line 1034 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8229 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@id")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8235 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp6_ = NULL;
#line 1036 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = g_strdup ("o.upnp_id");
#line 1036 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1036 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp6_;
#line 1037 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8247 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@parentID")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8253 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp7_ = NULL;
#line 1039 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = g_strdup ("o.parent");
#line 1039 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1039 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp7_;
#line 1040 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8265 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("upnp:class")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8271 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp8_ = NULL;
#line 1042 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("m.class");
#line 1042 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1042 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp8_;
#line 1043 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8283 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("dc:title")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8289 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp9_ = NULL;
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("o.title");
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1045 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp9_;
#line 1046 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1047 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8303 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:author"))))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8309 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp10_ = NULL;
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = g_strdup ("m.author");
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1050 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp10_;
#line 1051 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1052 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8323 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8329 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp11_ = NULL;
#line 1054 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = g_strdup ("m.creator");
#line 1054 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1054 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp11_;
#line 1055 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1056 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8343 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:date")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8349 "rygel-media-export-media-cache.c"
			default:
			{
				gboolean _tmp12_ = FALSE;
#line 1058 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = for_sort;
#line 1058 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_tmp12_) {
#line 8357 "rygel-media-export-media-cache.c"
					gchar* _tmp13_ = NULL;
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp13_ = g_strdup ("m.date");
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 1059 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp13_;
#line 8365 "rygel-media-export-media-cache.c"
				} else {
					gchar* _tmp14_ = NULL;
#line 1061 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp14_ = g_strdup ("strftime(\"%Y\", m.date)");
#line 1061 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 1061 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp14_;
#line 8374 "rygel-media-export-media-cache.c"
				}
#line 1063 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8378 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8384 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp15_ = NULL;
#line 1065 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = g_strdup ("m.album");
#line 1065 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1065 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp15_;
#line 1066 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1067 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8398 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("dc:genre"))))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8404 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp16_ = NULL;
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = g_strdup ("m.genre");
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1071 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp16_;
#line 1072 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 1073 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8418 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8424 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp17_ = NULL;
#line 1075 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = g_strdup ("m.track");
#line 1075 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1075 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp17_;
#line 1076 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8436 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8442 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp18_ = NULL;
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_strdup ("m.disc");
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1078 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp18_;
#line 1079 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8454 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8460 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp19_ = NULL;
#line 1081 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = g_strdup ("o.object_update_id");
#line 1081 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1081 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp19_;
#line 1082 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8472 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8478 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp20_ = NULL;
#line 1084 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = g_strdup ("o.container_update_id");
#line 1084 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1084 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp20_;
#line 1085 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 8490 "rygel-media-export-media-cache.c"
			}
		}
	} else {
#line 1028 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 8496 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* message = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GError* _tmp24_ = NULL;
#line 1087 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp21_ = operand;
#line 1087 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp22_ = g_strdup_printf ("Unsupported column %s", _tmp21_);
#line 1087 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				message = _tmp22_;
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = message;
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp24_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp23_);
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp24_;
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (message);
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 1089 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 8524 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 1092 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = use_collation;
#line 1092 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp25_) {
#line 8532 "rygel-media-export-media-cache.c"
		gchar* _tmp26_ = NULL;
#line 1093 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = g_strdup ("COLLATE CASEFOLD");
#line 1093 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 1093 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp26_;
#line 8540 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp27_ = NULL;
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = g_strdup ("");
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 1095 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp27_;
#line 8549 "rygel-media-export-media-cache.c"
	}
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = column;
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (collate) {
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*collate = _vala_collate;
#line 8557 "rygel-media-export-media-cache.c"
	} else {
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 8561 "rygel-media-export-media-cache.c"
	}
#line 1098 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8565 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v = NULL;
	gchar* collate = NULL;
	gchar* column = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GValue* _tmp40_ = NULL;
	RygelMediaExportSqlOperator* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 1101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (exp != NULL, NULL);
#line 1101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 1105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = NULL;
#line 1106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = NULL;
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = exp;
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp1_, &_tmp2_, FALSE, &_inner_error_);
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = _tmp2_;
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp3_;
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (collate);
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		__vala_GValue_free0 (v);
#line 1108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 8615 "rygel-media-export-media-cache.c"
	}
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = exp;
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 8625 "rygel-media-export-media-cache.c"
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = exp;
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
#line 1115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
#line 8640 "rygel-media-export-media-cache.c"
				gchar* _tmp8_ = NULL;
#line 1116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
#line 1116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 1116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp8_;
#line 8648 "rygel-media-export-media-cache.c"
			} else {
				gchar* _tmp9_ = NULL;
#line 1118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
#line 1118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 1118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp9_;
#line 8657 "rygel-media-export-media-cache.c"
			}
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sql_function;
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = column;
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = column;
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = _tmp13_;
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (sql_function);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 8681 "rygel-media-export-media-cache.c"
		}
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 8695 "rygel-media-export-media-cache.c"
		{
			RygelRelationalExpression* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_ = NULL;
			gconstpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportSqlOperator* _tmp21_ = NULL;
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = exp;
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = g_new0 (GValue, 1);
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp16_, G_TYPE_STRING);
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp16_;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = exp;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = column;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = collate;
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_), _tmp19_, _tmp20_);
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp21_;
#line 1131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8735 "rygel-media-export-media-cache.c"
		}
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 8739 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp22_ = NULL;
			RygelMediaExportSqlFunction* _tmp23_ = NULL;
			RygelRelationalExpression* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			GValue* _tmp26_ = NULL;
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = column;
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = rygel_media_export_sql_function_new ("contains", _tmp22_);
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp23_;
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = exp;
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_new0 (GValue, 1);
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp26_, G_TYPE_STRING);
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp26_;
#line 1135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8770 "rygel-media-export-media-cache.c"
		}
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
#line 8774 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp27_ = NULL;
			RygelMediaExportSqlFunction* _tmp28_ = NULL;
			RygelRelationalExpression* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			GValue* _tmp31_ = NULL;
#line 1137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = column;
#line 1137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = rygel_media_export_sql_function_new ("NOT contains", _tmp27_);
#line 1137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp28_;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = exp;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = g_new0 (GValue, 1);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp31_, G_TYPE_STRING);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp31_;
#line 1139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8805 "rygel-media-export-media-cache.c"
		}
#line 1112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 8809 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp32_ = NULL;
			RygelMediaExportSqlOperator* _tmp33_ = NULL;
			RygelRelationalExpression* _tmp34_ = NULL;
			gconstpointer _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
#line 1141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = column;
#line 1141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_sql_operator_new ("LIKE", _tmp32_, "");
#line 1141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp33_;
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = exp;
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = g_new0 (GValue, 1);
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp37_, G_TYPE_STRING);
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_take_string (_tmp37_, _tmp36_);
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp37_;
#line 1143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 8843 "rygel-media-export-media-cache.c"
		}
		default:
		{
			RygelRelationalExpression* _tmp38_ = NULL;
			gconstpointer _tmp39_ = NULL;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = exp;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
#line 1145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:1145: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp39_)));
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = NULL;
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 1146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 8867 "rygel-media-export-media-cache.c"
		}
	}
#line 1149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = v;
#line 1149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp40_ != NULL) {
#line 8874 "rygel-media-export-media-cache.c"
		GValueArray* _tmp41_ = NULL;
		GValue* _tmp42_ = NULL;
		GValue _tmp43_ = {0};
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = args;
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = v;
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = *_tmp42_;
#line 1150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_append (_tmp41_, &_tmp43_);
#line 8886 "rygel-media-export-media-cache.c"
	}
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = operator;
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = rygel_media_export_sql_operator_to_string (_tmp44_);
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp45_;
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (operator);
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	__vala_GValue_free0 (v);
#line 1153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8904 "rygel-media-export-media-cache.c"
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 1156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->db;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = self->priv->sql;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = id;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_exec_cursor (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp6_;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8945 "rygel-media-export-media-cache.c"
		} else {
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 8953 "rygel-media-export-media-cache.c"
		}
	}
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp0_;
#line 1159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 8960 "rygel-media-export-media-cache.c"
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	gint _tmp0_ = 0;
	RygelMediaExportDatabase* _tmp1_ = NULL;
	RygelMediaExportSQLFactory* _tmp2_ = NULL;
	RygelMediaExportSQLString _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	GValue* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 1162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->db;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = self->priv->sql;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = id;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_sql_factory_make (_tmp2_, _tmp3_);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_query_value (_tmp1_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = _tmp6_;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 9001 "rygel-media-export-media-cache.c"
		} else {
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 9009 "rygel-media-export-media-cache.c"
		}
	}
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp0_;
#line 1165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9016 "rygel-media-export-media-cache.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 9051 "rygel-media-export-media-cache.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 9060 "rygel-media-export-media-cache.c"
	}
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 9066 "rygel-media-export-media-cache.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 9075 "rygel-media-export-media-cache.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 9081 "rygel-media-export-media-cache.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 9090 "rygel-media-export-media-cache.c"
	} else {
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 9094 "rygel-media-export-media-cache.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 9104 "rygel-media-export-media-cache.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 9113 "rygel-media-export-media-cache.c"
	} else {
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 9117 "rygel-media-export-media-cache.c"
	}
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 9141 "rygel-media-export-media-cache.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 9159 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count) {
	gchar* _vala_extra_columns = NULL;
	gint _vala_column_count = 0;
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* column_builder = NULL;
	GString* _tmp1_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GString* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GString* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
#line 1168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (sort_criteria != NULL, NULL);
#line 1173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_string_new ("ORDER BY ");
#line 1173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	builder = _tmp0_;
#line 1174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_string_new ("");
#line 1174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column_builder = _tmp1_;
#line 1175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sort_criteria;
#line 1175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
#line 1175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = _tmp4_;
#line 1175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields_length1 = _vala_array_length (_tmp3_);
#line 1175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_fields_size_ = fields_length1;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = fields;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = fields_length1;
#line 1176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_column_count = _tmp5__length1;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = fields;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6__length1 = fields_length1;
#line 9219 "rygel-media-export-media-cache.c"
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection = _tmp6_;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		field_collection_length1 = _tmp6__length1;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (field_it = 0; field_it < _tmp6__length1; field_it = field_it + 1) {
#line 9231 "rygel-media-export-media-cache.c"
			const gchar* field = NULL;
#line 1177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			field = field_collection[field_it];
#line 9235 "rygel-media-export-media-cache.c"
			{
				{
					gchar* column = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					GString* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar _tmp23_ = '\0';
					GString* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					GString* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp7_ = field;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp8_ = field;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp9_ = strlen (_tmp8_);
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp10_ = _tmp9_;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = string_slice (_tmp7_, (glong) 1, (glong) _tmp10_);
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp12_ = _tmp11_;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp14_ = rygel_media_export_media_cache_map_operand_to_column (_tmp12_, &_tmp13_, TRUE, &_inner_error_);
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					collate = _tmp13_;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp15_ = _tmp14_;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (_tmp12_);
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					column = _tmp15_;
#line 1179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_ != NULL) {
#line 9288 "rygel-media-export-media-cache.c"
						goto __catch20_g_error;
					}
#line 1183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp16_ = field;
#line 1183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp17_ = fields;
#line 1183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp17__length1 = fields_length1;
#line 1183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp18_ = _tmp17_[0];
#line 1183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
#line 9301 "rygel-media-export-media-cache.c"
						GString* _tmp19_ = NULL;
#line 1184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp19_ = builder;
#line 1184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						g_string_append (_tmp19_, ",");
#line 9307 "rygel-media-export-media-cache.c"
					}
#line 1186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp20_ = column_builder;
#line 1186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp20_, ",");
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp22_ = field;
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp23_ = string_get (_tmp22_, (glong) 0);
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_tmp23_ == '-') {
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp21_ = "DESC";
#line 9321 "rygel-media-export-media-cache.c"
					} else {
#line 1190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
						_tmp21_ = "ASC";
#line 9325 "rygel-media-export-media-cache.c"
					}
#line 1187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp24_ = builder;
#line 1187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp25_ = column;
#line 1187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp26_ = collate;
#line 1187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp27_ = _tmp21_;
#line 1187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append_printf (_tmp24_, "%s %s %s ", _tmp25_, _tmp26_, _tmp27_);
#line 1191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp28_ = column_builder;
#line 1191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp29_ = column;
#line 1191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_string_append (_tmp28_, _tmp29_);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (column);
#line 9345 "rygel-media-export-media-cache.c"
				}
				goto __finally20;
				__catch20_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp30_ = NULL;
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_error_ = _inner_error_;
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_inner_error_ = NULL;
#line 1193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp30_ = field;
#line 1193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_warning ("rygel-media-export-media-cache.vala:1193: Skipping unsupported field: " \
"%s", _tmp30_);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 9362 "rygel-media-export-media-cache.c"
				}
				__finally20:
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_string_free0 (column_builder);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_string_free0 (builder);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_free0 (collate);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 1178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 9381 "rygel-media-export-media-cache.c"
				}
			}
		}
	}
#line 1197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = column_builder;
#line 1197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = _tmp31_->str;
#line 1197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = g_strdup (_tmp32_);
#line 1197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_vala_extra_columns);
#line 1197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_extra_columns = _tmp33_;
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = builder;
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = _tmp34_->str;
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = g_strdup (_tmp35_);
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp36_;
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (column_builder);
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_string_free0 (builder);
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (extra_columns) {
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*extra_columns = _vala_extra_columns;
#line 9416 "rygel-media-export-media-cache.c"
	} else {
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_extra_columns);
#line 9420 "rygel-media-export-media-cache.c"
	}
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (column_count) {
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*column_count = _vala_column_count;
#line 9426 "rygel-media-export-media-cache.c"
	}
#line 1199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 9430 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
#line 9441 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
#line 9448 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
#line 9466 "rygel-media-export-media-cache.c"
}


/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



