/* rygel-gst-transcoder.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-gst-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE
} RygelGstTranscoderError;
#define RYGEL_GST_TRANSCODER_ERROR rygel_gst_transcoder_error_quark ()
struct _RygelGstTranscoder {
	RygelTranscoder parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	RygelTranscoderClass parent_class;
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self);
};

struct _RygelGstTranscoderPrivate {
	gchar* _preset;
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
};

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};


static gpointer rygel_gst_transcoder_parent_class = NULL;

GQuark rygel_gst_transcoder_error_quark (void);
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderPrivate))
enum  {
	RYGEL_GST_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_GST_TRANSCODER_PRESET
};
#define RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#define RYGEL_GST_TRANSCODER_DECODE_BIN "decodebin"
#define RYGEL_GST_TRANSCODER_ENCODE_BIN "encodebin"
#define RYGEL_GST_TRANSCODER_DESCRIPTION "Encoder and decoder are not " "compatible"
RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension);
static void rygel_gst_transcoder_real_constructed (GObject* base);
static RygelDataSource* rygel_gst_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, RygelDataSource* src, GError** error);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self);
static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value);
static inline GstElement* _dynamic_get_profile3 (GstElement* obj);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile, gint indent);
static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj);
static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad);
static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_gst_transcoder_on_autoplug_continue (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps);
static gboolean _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
gulong _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin);
static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value);
static void rygel_gst_transcoder_finalize (GObject* obj);
static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_gst_transcoder_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_transcoder_error-quark");
}


RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* extension) {
	RygelGstTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (dlna_profile != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = mime_type;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = dlna_profile;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = extension;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = (RygelGstTranscoder*) g_object_new (object_type, "mime-type", _tmp0_, "dlna-profile", _tmp1_, "extension", _tmp2_, NULL);
#line 52 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self;
#line 177 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_real_constructed (GObject* base) {
	RygelGstTranscoder * self;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = (RygelGstTranscoder*) base;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_TRANSCODER, RygelTranscoder));
#line 63 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->link_failed = TRUE;
#line 189 "rygel-gst-transcoder.c"
}


/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 204 "rygel-gst-transcoder.c"
}


static inline void _dynamic_set_profile2 (GstElement* obj, GstEncodingProfile* value) {
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_set (obj, "profile", value, NULL);
#line 211 "rygel-gst-transcoder.c"
}


static inline GstElement* _dynamic_get_profile3 (GstElement* obj) {
	GstElement* result;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_get (obj, "profile", &result, NULL);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 221 "rygel-gst-transcoder.c"
}


static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj) {
	GstEncodingProfile* result;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_get (obj, "profile", &result, NULL);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 231 "rygel-gst-transcoder.c"
}


static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_on_decoder_pad_added (self, _sender, pad);
#line 238 "rygel-gst-transcoder.c"
}


static gboolean _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_ (GstElement* _sender, GstPad* new_pad, GstCaps* caps, gpointer self) {
	gboolean result;
	result = rygel_gst_transcoder_on_autoplug_continue (self, _sender, new_pad, caps);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 247 "rygel-gst-transcoder.c"
}


static void g_cclosure_user_marshal_BOOLEAN__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (return_value != NULL);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (n_param_values == 3);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data1 = closure->data;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data2 = param_values->data[0].v_pointer;
#line 269 "rygel-gst-transcoder.c"
	} else {
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data1 = param_values->data[0].v_pointer;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		data2 = closure->data;
#line 275 "rygel-gst-transcoder.c"
	}
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	callback = (GMarshalFunc_BOOLEAN__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	v_return = callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_value_set_boolean (return_value, v_return);
#line 283 "rygel-gst-transcoder.c"
}


gulong _dynamic_autoplug_continue1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return g_signal_connect_object (obj, signal_name, handler, data, 0);
#line 290 "rygel-gst-transcoder.c"
}


static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender, gpointer self) {
#line 104 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_on_no_more_pads (self, _sender);
#line 297 "rygel-gst-transcoder.c"
}


static RygelDataSource* rygel_gst_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, RygelDataSource* src, GError** error) {
	RygelGstTranscoder * self;
	RygelDataSource* result = NULL;
	RygelDataSource* _tmp0_ = NULL;
	RygelGstDataSource* orig_source = NULL;
	RygelDataSource* _tmp1_ = NULL;
	RygelGstDataSource* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	GstEncodingProfile* _tmp8_ = NULL;
	GstEncodingProfile* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	GstElement* _tmp11_ = NULL;
	GstElement* _tmp12_ = NULL;
	GObjectClass* _tmp17_ = NULL;
	GType _tmp18_ = 0UL;
	const gchar* _tmp19_ = NULL;
	GstElement* _tmp20_ = NULL;
	GstEncodingProfile* _tmp21_ = NULL;
	GstEncodingProfile* _tmp22_ = NULL;
	GstBin* bin = NULL;
	GstBin* _tmp23_ = NULL;
	GstBin* _tmp24_ = NULL;
	RygelGstDataSource* _tmp25_ = NULL;
	GstElement* _tmp26_ = NULL;
	GstElement* _tmp27_ = NULL;
	GstElement* _tmp28_ = NULL;
	GstElement* _tmp29_ = NULL;
	RygelGstDataSource* _tmp30_ = NULL;
	GstElement* _tmp31_ = NULL;
	GstElement* _tmp32_ = NULL;
	GstElement* _tmp33_ = NULL;
	GstElement* _tmp34_ = NULL;
	GstElement* _tmp35_ = NULL;
	GstPad* pad = NULL;
	GstElement* _tmp36_ = NULL;
	GstPad* _tmp37_ = NULL;
	GstGhostPad* ghost = NULL;
	GstPad* _tmp38_ = NULL;
	GstGhostPad* _tmp39_ = NULL;
	GstBin* _tmp40_ = NULL;
	GstGhostPad* _tmp41_ = NULL;
	GstPad* _tmp42_ = NULL;
	GstBin* _tmp43_ = NULL;
	RygelGstDataSource* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = (RygelGstTranscoder*) base;
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = src;
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_GST_DATA_SOURCE), "src is GstDataSource");
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = src;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_GST_DATA_SOURCE) ? ((RygelGstDataSource*) _tmp1_) : NULL);
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	orig_source = _tmp2_;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp4_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_DECODE_BIN, RYGEL_GST_TRANSCODER_DECODE_BIN, &_inner_error_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = _tmp4_;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 378 "rygel-gst-transcoder.c"
	}
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->decoder);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->decoder = _tmp3_;
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp6_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_ENCODE_BIN, RYGEL_GST_TRANSCODER_ENCODE_BIN, &_inner_error_);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp5_ = _tmp6_;
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 396 "rygel-gst-transcoder.c"
	}
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->encoder);
#line 83 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->encoder = _tmp5_;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp7_ = self->priv->encoder;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp8_ = rygel_gst_transcoder_get_encoding_profile (self);
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp9_ = _tmp8_;
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_dynamic_set_profile2 (_tmp7_, _tmp9_);
#line 86 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (_tmp9_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp10_ = self->priv->encoder;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp11_ = _dynamic_get_profile3 (_tmp10_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp12_ = _tmp11_;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp12_ == NULL) {
#line 420 "rygel-gst-transcoder.c"
		gchar* message = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp13_ = _ ("Could not create a transcoder configuration. Your GStreamer installati" \
"on might be missing a plug-in");
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 88 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		message = _tmp14_;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp15_ = message;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp16_ = g_error_new_literal (RYGEL_GST_TRANSCODER_ERROR, RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, _tmp15_);
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_inner_error_ = _tmp16_;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (message);
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (orig_source);
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return NULL;
#line 446 "rygel-gst-transcoder.c"
	}
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp17_ = G_OBJECT_GET_CLASS ((GObject*) self);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp18_ = G_TYPE_FROM_CLASS ((GTypeClass*) _tmp17_);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp19_ = g_type_name (_tmp18_);
#line 93 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_debug ("rygel-gst-transcoder.vala:93: %s using the following encoding profile:", _tmp19_);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp20_ = self->priv->encoder;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp21_ = _dynamic_get_profile4 (_tmp20_);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp22_ = _tmp21_;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_utils_dump_encoding_profile (_tmp22_, 2);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp23_ = (GstBin*) gst_bin_new ("transcoder-source");
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_ref_sink (_tmp23_);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	bin = _tmp23_;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp24_ = bin;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp25_ = orig_source;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp26_ = _tmp25_->src;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp27_ = _g_object_ref0 (_tmp26_);
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp28_ = self->priv->decoder;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp29_ = self->priv->encoder;
#line 98 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_bin_add_many (_tmp24_, _tmp27_, _tmp28_, _tmp29_, NULL);
#line 100 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp30_ = orig_source;
#line 100 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp31_ = _tmp30_->src;
#line 100 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp32_ = self->priv->decoder;
#line 100 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_element_link (_tmp31_, _tmp32_);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp33_ = self->priv->decoder;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_connect_object (_tmp33_, "pad-added", (GCallback) _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp34_ = self->priv->decoder;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_dynamic_autoplug_continue1_connect (_tmp34_, "autoplug_continue", (GCallback) _rygel_gst_transcoder_on_autoplug_continue_dynamic_autoplug_continue0_, self);
#line 104 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp35_ = self->priv->decoder;
#line 104 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_connect_object (_tmp35_, "no-more-pads", (GCallback) _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads, self, 0);
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp36_ = self->priv->encoder;
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp37_ = gst_element_get_static_pad (_tmp36_, "src");
#line 106 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	pad = _tmp37_;
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp38_ = pad;
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp39_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp38_);
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_ref_sink (_tmp39_);
#line 107 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	ghost = _tmp39_;
#line 108 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp40_ = bin;
#line 108 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp41_ = ghost;
#line 108 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp42_ = _g_object_ref0 ((GstPad*) _tmp41_);
#line 108 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp40_, _tmp42_);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp43_ = bin;
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp44_ = rygel_gst_data_source_new_from_element ((GstElement*) _tmp43_);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = (RygelDataSource*) _tmp44_;
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (ghost);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (pad);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (bin);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (orig_source);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 542 "rygel-gst-transcoder.c"
}


/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self) {
#line 118 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 118 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return NULL;
#line 556 "rygel-gst-transcoder.c"
}


GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self) {
#line 118 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self);
#line 565 "rygel-gst-transcoder.c"
}


static gboolean rygel_gst_transcoder_on_autoplug_continue (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad, GstCaps* caps) {
	gboolean result = FALSE;
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_ = NULL;
	GstCaps* _tmp1_ = NULL;
	GstPad* _tmp2_ = NULL;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (decodebin != NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (new_pad != NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (caps != NULL, FALSE);
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	sinkpad = NULL;
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->encoder;
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = caps;
#line 125 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_signal_emit_by_name (_tmp0_, "request-pad", _tmp1_, &sinkpad, NULL);
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = sinkpad;
#line 126 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp2_ == NULL) {
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		result = TRUE;
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (sinkpad);
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return result;
#line 601 "rygel-gst-transcoder.c"
	}
#line 130 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = FALSE;
#line 130 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 130 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 609 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self, GstElement* decodebin, GstPad* new_pad) {
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_ = NULL;
	GstPad* _tmp1_ = NULL;
	GstPad* _tmp2_ = NULL;
	GstPad* _tmp3_ = NULL;
	GstPad* _tmp8_ = NULL;
	gboolean pad_link_ok = FALSE;
	GstPad* _tmp13_ = NULL;
	GstPad* _tmp14_ = NULL;
	GstPadLinkReturn _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 133 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (new_pad != NULL);
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->encoder;
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = new_pad;
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp2_ = gst_element_get_compatible_pad (_tmp0_, _tmp1_, NULL);
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 136 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	sinkpad = _tmp2_;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp3_ = sinkpad;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp3_ == NULL) {
#line 645 "rygel-gst-transcoder.c"
		GstCaps* caps = NULL;
		GstPad* _tmp4_ = NULL;
		GstCaps* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		GstCaps* _tmp7_ = NULL;
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp4_ = new_pad;
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp5_ = gst_pad_query_caps (_tmp4_, NULL);
#line 139 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		caps = _tmp5_;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp6_ = self->priv->encoder;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp7_ = caps;
#line 140 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_signal_emit_by_name (_tmp6_, "request-pad", _tmp7_, &sinkpad, NULL);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_gst_caps_unref0 (caps);
#line 665 "rygel-gst-transcoder.c"
	}
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp8_ = sinkpad;
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp8_ == NULL) {
#line 671 "rygel-gst-transcoder.c"
		GstPad* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp9_ = new_pad;
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp9_, "name", &_tmp10_, NULL);
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp11_ = _tmp10_;
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp12_ = _tmp11_;
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_debug ("rygel-gst-transcoder.vala:144: No compatible encodebin pad found for p" \
"ad '%s', ignoring..", _tmp12_);
#line 144 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp12_);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (sinkpad);
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		return;
#line 692 "rygel-gst-transcoder.c"
	}
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp13_ = new_pad;
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp14_ = sinkpad;
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp15_ = gst_pad_link_full (_tmp13_, _tmp14_, GST_PAD_LINK_CHECK_DEFAULT);
#line 150 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	pad_link_ok = _tmp15_ == GST_PAD_LINK_OK;
#line 151 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp16_ = pad_link_ok;
#line 151 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (!_tmp16_) {
#line 706 "rygel-gst-transcoder.c"
		GstPad* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GstPad* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp17_ = new_pad;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp17_, "name", &_tmp18_, NULL);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp19_ = _tmp18_;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp20_ = _tmp19_;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp21_ = sinkpad;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_object_get ((GstObject*) _tmp21_, "name", &_tmp22_, NULL);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp23_ = _tmp22_;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp24_ = _tmp23_;
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_warning ("rygel-gst-transcoder.vala:152: Failed to link pad '%s' to '%s'", _tmp20_, _tmp24_);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp24_);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_free0 (_tmp20_);
#line 737 "rygel-gst-transcoder.c"
	} else {
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		self->priv->link_failed = FALSE;
#line 741 "rygel-gst-transcoder.c"
	}
#line 159 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (sinkpad);
#line 159 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return;
#line 747 "rygel-gst-transcoder.c"
}


static gpointer _gst_message_ref0 (gpointer self) {
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return self ? gst_message_ref (self) : NULL;
#line 754 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self, GstElement* decodebin) {
	gboolean _tmp0_ = FALSE;
#line 165 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (decodebin != NULL);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->link_failed;
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	if (_tmp0_) {
#line 768 "rygel-gst-transcoder.c"
		GstBin* bin = NULL;
		GstElement* _tmp1_ = NULL;
		GstObject* _tmp2_ = NULL;
		GstBin* _tmp3_ = NULL;
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		GstMessage* message = NULL;
		GstBin* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		GstMessage* _tmp7_ = NULL;
		GstBus* bus = NULL;
		GstBin* _tmp8_ = NULL;
		GstBus* _tmp9_ = NULL;
		GstBus* _tmp10_ = NULL;
		GstMessage* _tmp11_ = NULL;
		GstMessage* _tmp12_ = NULL;
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp1_ = self->priv->encoder;
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp2_ = gst_object_get_parent ((GstObject*) _tmp1_);
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gst_bin_get_type ()) ? ((GstBin*) _tmp2_) : NULL;
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		if (_tmp3_ == NULL) {
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
			_g_object_unref0 (_tmp2_);
#line 795 "rygel-gst-transcoder.c"
		}
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		bin = _tmp3_;
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_error_ = _tmp4_;
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp5_ = bin;
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp6_ = _error_;
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp7_ = gst_message_new_error ((GstObject*) _tmp5_, _tmp6_, RYGEL_GST_TRANSCODER_DESCRIPTION);
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		message = _tmp7_;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp8_ = bin;
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp9_ = gst_element_get_bus ((GstElement*) _tmp8_);
#line 176 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		bus = _tmp9_;
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp10_ = bus;
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp11_ = message;
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_tmp12_ = _gst_message_ref0 (_tmp11_);
#line 177 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		gst_bus_post (_tmp10_, _tmp12_);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (bus);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_gst_message_unref0 (message);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_error_free0 (_error_);
#line 167 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		_g_object_unref0 (bin);
#line 833 "rygel-gst-transcoder.c"
	}
}


const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = self->priv->_preset;
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	result = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	return result;
#line 849 "rygel-gst-transcoder.c"
}


void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_preset = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_notify ((GObject *) self, "preset");
#line 868 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_class_init (RygelGstTranscoderClass * klass) {
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	rygel_gst_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelGstTranscoderPrivate));
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_gst_transcoder_real_constructed;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_gst_transcoder_real_create_source;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	RYGEL_GST_TRANSCODER_CLASS (klass)->get_encoding_profile = rygel_gst_transcoder_real_get_encoding_profile;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_gst_transcoder_get_property;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_gst_transcoder_set_property;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_transcoder_finalize;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_PRESET, g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 891 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_instance_init (RygelGstTranscoder * self) {
	gchar* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv = RYGEL_GST_TRANSCODER_GET_PRIVATE (self);
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_tmp0_ = g_strdup (RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET);
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self->priv->_preset = _tmp0_;
#line 903 "rygel-gst-transcoder.c"
}


static void rygel_gst_transcoder_finalize (GObject* obj) {
	RygelGstTranscoder * self;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_free0 (self->priv->_preset);
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->decoder);
#line 48 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	_g_object_unref0 (self->priv->encoder);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->finalize (obj);
#line 919 "rygel-gst-transcoder.c"
}


/**
 * The base Transcoder class. Each implementation derives from it and must
 * implement get_distance and get_encoding_profile methods.
 */
GType rygel_gst_transcoder_get_type (void) {
	static volatile gsize rygel_gst_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstTranscoder), 0, (GInstanceInitFunc) rygel_gst_transcoder_instance_init, NULL };
		GType rygel_gst_transcoder_type_id;
		rygel_gst_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelGstTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_gst_transcoder_type_id__volatile, rygel_gst_transcoder_type_id);
	}
	return rygel_gst_transcoder_type_id__volatile;
}


static void _vala_rygel_gst_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_PRESET:
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		g_value_set_string (value, rygel_gst_transcoder_get_preset (self));
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 950 "rygel-gst-transcoder.c"
		default:
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 956 "rygel-gst-transcoder.c"
	}
}


static void _vala_rygel_gst_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		case RYGEL_GST_TRANSCODER_PRESET:
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		rygel_gst_transcoder_set_preset (self, g_value_get_string (value));
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 972 "rygel-gst-transcoder.c"
		default:
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-transcoder.vala"
		break;
#line 978 "rygel-gst-transcoder.c"
	}
}



