/* rygel-simple-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-simple-container.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SIMPLE_CONTAINER (rygel_simple_container_get_type ())
#define RYGEL_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer))
#define RYGEL_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))
#define RYGEL_IS_SIMPLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_IS_SIMPLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_CONTAINER))
#define RYGEL_SIMPLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerClass))

typedef struct _RygelSimpleContainer RygelSimpleContainer;
typedef struct _RygelSimpleContainerClass RygelSimpleContainerClass;
typedef struct _RygelSimpleContainerPrivate RygelSimpleContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSimpleContainerGetChildrenData RygelSimpleContainerGetChildrenData;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _RygelSimpleContainerFindObjectData RygelSimpleContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelSimpleContainerSearchData RygelSimpleContainerSearchData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSimpleContainer {
	RygelMediaContainer parent_instance;
	RygelSimpleContainerPrivate * priv;
	RygelMediaObjects* children;
};

struct _RygelSimpleContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelSimpleContainerPrivate {
	RygelMediaObjects* empty_children;
	GeeArrayList* _search_classes;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelSimpleContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint stop;
	guint _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* unsorted_children;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	guint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	guint _tmp12_;
	RygelMediaObjects* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeList* _tmp16_;
	RygelMediaObjects* _tmp17_;
	RygelMediaObjects* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObjects* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GeeList* _tmp23_;
	RygelMediaObjects* _tmp24_;
};

struct _Block2Data {
	int _ref_count_;
	RygelSimpleContainer * self;
	gint restart_count;
	gboolean restart;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gulong updated_id;
};

struct _RygelSimpleContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelMediaObject* media_object;
	gint max_count;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	RygelMediaObjects* children_to_search;
	gint _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObjects* _tmp8_;
	gboolean _tmp9_;
	Block3Data* _data3_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp15_;
	RygelMediaObjects* _tmp16_;
	gint _child_size;
	RygelMediaObjects* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _child_index;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	RygelMediaObject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaObject* _tmp31_;
	RygelMediaObject* _tmp32_;
	gulong _tmp33_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp34_;
	RygelMediaContainer* _tmp35_;
	RygelMediaObject* _tmp36_;
	RygelMediaContainer* _tmp37_;
	const gchar* _tmp38_;
	GCancellable* _tmp39_;
	RygelMediaObject* _tmp40_;
	gulong _tmp41_;
	gulong _tmp42_;
	RygelMediaObject* _tmp43_;
	gboolean _tmp44_;
	GError * _inner_error_;
};

struct _RygelSimpleContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSimpleContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	GError * _inner_error_;
};


static gpointer rygel_simple_container_parent_class = NULL;
static RygelSearchableContainerIface* rygel_simple_container_rygel_searchable_container_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_simple_container_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainerPrivate))
enum  {
	RYGEL_SIMPLE_CONTAINER_DUMMY_PROPERTY,
	RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES
};
RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
static void rygel_simple_container_real_constructed (GObject* base);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);
RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title);
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child);
static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child);
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self);
void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
gint rygel_media_container_get_empty_child_count (RygelMediaContainer* self);
void rygel_media_container_set_empty_child_count (RygelMediaContainer* self, gint value);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child);
void rygel_media_container_set_child_count (RygelMediaContainer* self, gint value);
void rygel_simple_container_clear (RygelSimpleContainer* self);
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id);
static void rygel_simple_container_real_get_children_data_free (gpointer _data);
static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const gchar* sort_criteria);
static void rygel_simple_container_real_find_object_data_free (gpointer _data);
static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ________lambda19_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaObject* updated);
static void _________lambda19__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_simple_container_real_search_data_free (gpointer _data);
static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_updated (RygelMediaContainer* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_simple_container_finalize (GObject* obj);
static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Creates a child RygelSimpleContainer.
     *
     * @param id The ID of the item. This should be unique in the server.
     * @param parent The parent of the container.
     * @param title The title of the container.
     */
RygelSimpleContainer* rygel_simple_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = id;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = parent;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = title;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", 0, NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self;
#line 463 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return rygel_simple_container_construct (RYGEL_TYPE_SIMPLE_CONTAINER, id, parent, title);
#line 470 "rygel-simple-container.c"
}


static void rygel_simple_container_real_constructed (GObject* base) {
	RygelSimpleContainer * self;
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObjects* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer));
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->children = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = rygel_media_objects_new ();
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv->empty_children = _tmp1_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = _tmp2_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp3_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_tmp3_);
#line 504 "rygel-simple-container.c"
}


/**
     * Creates a RygelSimpleContainer as a root container.
     *
     * @param title The title of the container.
     */
RygelSimpleContainer* rygel_simple_container_construct_root (GType object_type, const gchar* title) {
	RygelSimpleContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = title;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) g_object_new (object_type, "id", "0", "parent", NULL, "title", _tmp0_, "child-count", 0, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self;
#line 524 "rygel-simple-container.c"
}


RygelSimpleContainer* rygel_simple_container_new_root (const gchar* title) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return rygel_simple_container_construct_root (RYGEL_TYPE_SIMPLE_CONTAINER, title);
#line 531 "rygel-simple-container.c"
}


/**
     * Adds an item to the container.
     *
     * @param child The child item to add to the container.
     */
void rygel_simple_container_add_child_item (RygelSimpleContainer* self, RygelMediaItem* child) {
	RygelMediaItem* _tmp0_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = child;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp0_);
#line 550 "rygel-simple-container.c"
}


/**
     * Get all children, including the empty children.
     *
     * This is useful when all children are empty,
     * so get_children() would return no objects,
     * but when you need to add items to the empty
     * items.
     *
     * This is useful only when implementing derived classes.
     */
RygelMediaObjects* rygel_simple_container_get_all_children (RygelSimpleContainer* self) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* all = NULL;
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObjects* _tmp1_ = NULL;
	RygelMediaObjects* _tmp2_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	all = _tmp0_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = self->children;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp1_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = self->priv->empty_children;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_array_list_add_all ((GeeArrayList*) all, (GeeCollection*) _tmp2_);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = all;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 588 "rygel-simple-container.c"
}


/**
     * Adds a child container to this container.
     *
     * The child container will only be added to the hierarchy if, or when,
     * it contains some children.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 601 "rygel-simple-container.c"
}


static void _rygel_simple_container_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
#line 608 "rygel-simple-container.c"
}


void rygel_simple_container_add_child_container (RygelSimpleContainer* self, RygelMediaContainer* child) {
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = child;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 625 "rygel-simple-container.c"
		GeeArrayList* search_classes = NULL;
		RygelMediaContainer* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = child;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = rygel_searchable_container_get_search_classes (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _tmp1_) : NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = _tmp2_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		search_classes = _tmp4_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp5_ = rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp6_ = _tmp5_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp7_ = search_classes;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_array_list_add_all (_tmp6_, (GeeCollection*) _tmp7_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (search_classes);
#line 654 "rygel-simple-container.c"
	}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp8_ = child;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp9_ = rygel_media_container_get_child_count (_tmp8_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp10_ = _tmp9_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp10_ > 0) {
#line 664 "rygel-simple-container.c"
		RygelMediaContainer* _tmp11_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp11_ = child;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp11_);
#line 670 "rygel-simple-container.c"
	} else {
		RygelMediaContainer* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		RygelMediaObjects* _tmp15_ = NULL;
		RygelMediaContainer* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		RygelMediaContainer* _tmp19_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp12_ = child;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp12_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp14_ = _tmp13_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("Container '%s' empty, refusing to add to hierarchy " "until it has any children to offer.", _tmp14_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp15_ = self->priv->empty_children;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp16_ = child;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (RygelMediaObject*) _tmp16_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp17_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp18_ = _tmp17_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp18_ + 1);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp19_ = child;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_signal_connect_object (_tmp19_, "container-updated", (GCallback) _rygel_simple_container_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 704 "rygel-simple-container.c"
	}
}


/**
     * Removes the item from the container.
     */
void rygel_simple_container_remove_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = child;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = _tmp2_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp3_ - 1);
#line 733 "rygel-simple-container.c"
}


/**
     * Removes all child items and child containers
     * from the container.
     */
void rygel_simple_container_clear (RygelSimpleContainer* self) {
	RygelMediaObjects* _tmp0_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, 0);
#line 751 "rygel-simple-container.c"
}


/**
     * Check that the ID is unique within this container.
     *
     * This is useful only when implementing derived classes.
     *
     * @param child_id The ID to check for uniqueness.
     * @return true if the child ID is unique within this container.
     */
gboolean rygel_simple_container_is_child_id_unique (RygelSimpleContainer* self, const gchar* child_id) {
	gboolean result = FALSE;
	gboolean unique = FALSE;
	gboolean _tmp15_ = FALSE;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_val_if_fail (child_id != NULL, FALSE);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	unique = TRUE;
#line 773 "rygel-simple-container.c"
	{
		RygelMediaObjects* _child_list = NULL;
		RygelMediaObjects* _tmp0_ = NULL;
		RygelMediaObjects* _tmp1_ = NULL;
		gint _child_size = 0;
		RygelMediaObjects* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _child_index = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp0_ = self->children;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_list = _tmp1_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = _child_list;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = _tmp3_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_size = _tmp4_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_child_index = -1;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		while (TRUE) {
#line 801 "rygel-simple-container.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			RygelMediaObject* child = NULL;
			RygelMediaObjects* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp5_ = _child_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_index = _tmp5_ + 1;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp6_ = _child_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp7_ = _child_size;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				break;
#line 825 "rygel-simple-container.c"
			}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp8_ = _child_list;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp9_ = _child_index;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			child = (RygelMediaObject*) _tmp10_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp11_ = child;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp12_ = rygel_media_object_get_id (_tmp11_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp13_ = _tmp12_;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp14_ = child_id;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				unique = FALSE;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				break;
#line 851 "rygel-simple-container.c"
			}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_g_object_unref0 (child);
#line 855 "rygel-simple-container.c"
		}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_child_list);
#line 859 "rygel-simple-container.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp15_ = unique;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp15_) {
#line 865 "rygel-simple-container.c"
		{
			RygelMediaObjects* _child_list = NULL;
			RygelMediaObjects* _tmp16_ = NULL;
			RygelMediaObjects* _tmp17_ = NULL;
			gint _child_size = 0;
			RygelMediaObjects* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _child_index = 0;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp16_ = self->priv->empty_children;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp17_ = _g_object_ref0 (_tmp16_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_list = _tmp17_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp18_ = _child_list;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_tmp20_ = _tmp19_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_size = _tmp20_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_child_index = -1;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			while (TRUE) {
#line 893 "rygel-simple-container.c"
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				RygelMediaObject* child = NULL;
				RygelMediaObjects* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gpointer _tmp26_ = NULL;
				RygelMediaObject* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp21_ = _child_index;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_child_index = _tmp21_ + 1;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp22_ = _child_index;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp23_ = _child_size;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (!(_tmp22_ < _tmp23_)) {
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 917 "rygel-simple-container.c"
				}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp24_ = _child_list;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp25_ = _child_index;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp25_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				child = (RygelMediaObject*) _tmp26_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp27_ = child;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp28_ = rygel_media_object_get_id (_tmp27_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp29_ = _tmp28_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_tmp30_ = child_id;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					unique = FALSE;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_g_object_unref0 (child);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 943 "rygel-simple-container.c"
				}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (child);
#line 947 "rygel-simple-container.c"
			}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_g_object_unref0 (_child_list);
#line 951 "rygel-simple-container.c"
		}
	}
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = unique;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 958 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children_data_free (gpointer _data) {
	RygelSimpleContainerGetChildrenData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerGetChildrenData, _data_);
#line 975 "rygel-simple-container.c"
}


static void rygel_simple_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerGetChildrenData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerGetChildrenData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_get_children);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_get_children_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = offset;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->offset = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = max_count;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->max_count = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->sort_criteria = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp5_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_get_children_co (_data_);
#line 1027 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerGetChildrenData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 1038 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 1048 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_get_children_co (RygelSimpleContainerGetChildrenData* _data_) {
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 1057 "rygel-simple-container.c"
		goto _state_0;
		default:
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1062 "rygel-simple-container.c"
	}
	_state_0:
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = 0U;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->offset;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = 0U;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->max_count;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->stop = _data_->_tmp0_ + _data_->_tmp1_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = FALSE;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = FALSE;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_tmp3_) {
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp4_ = 0U;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp4_ = _data_->stop;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp5_ = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp5_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp6_ = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp7_ = 0U;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp7_ = CLAMP (_data_->_tmp4_, (guint) 0, (guint) _data_->_tmp6_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->stop = _data_->_tmp7_;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp8_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp8_ = rygel_simple_container_get_all_children (_data_->self);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_data_->unsorted_children);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->unsorted_children = _data_->_tmp8_;
#line 1111 "rygel-simple-container.c"
	} else {
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp9_ = 0U;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp9_ = _data_->stop;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp10_ = 0;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp10_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp11_ = 0;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp12_ = 0U;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp12_ = CLAMP (_data_->_tmp9_, (guint) 0, (guint) _data_->_tmp11_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->stop = _data_->_tmp12_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp13_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp13_ = _data_->self->children;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp14_ = 0;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp14_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp15_ = 0;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp16_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp16_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp13_, 0, _data_->_tmp15_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp17_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp16_) : NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (_data_->_tmp17_ == NULL) {
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_g_object_unref0 (_data_->_tmp16_);
#line 1155 "rygel-simple-container.c"
		}
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_data_->unsorted_children);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->unsorted_children = _data_->_tmp17_;
#line 1161 "rygel-simple-container.c"
	}
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp18_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp18_ = _data_->unsorted_children;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp19_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp19_ = _data_->sort_criteria;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_objects_sort_by_criteria (_data_->_tmp18_, _data_->_tmp19_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp20_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp20_ = _data_->unsorted_children;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp21_ = 0U;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp21_ = _data_->offset;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp22_ = 0U;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp22_ = _data_->stop;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp23_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp23_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp20_, (gint) _data_->_tmp21_, (gint) _data_->_tmp22_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp24_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp23_) : NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_tmp24_ == NULL) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_data_->_tmp23_);
#line 1197 "rygel-simple-container.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = _data_->_tmp24_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->unsorted_children);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1207 "rygel-simple-container.c"
	} else {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1211 "rygel-simple-container.c"
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->unsorted_children);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1223 "rygel-simple-container.c"
	} else {
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1227 "rygel-simple-container.c"
	}
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1233 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object_data_free (gpointer _data) {
	RygelSimpleContainerFindObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerFindObjectData, _data_);
#line 1250 "rygel-simple-container.c"
}


static void rygel_simple_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerFindObjectData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerFindObjectData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_find_object);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_find_object_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = id;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->id);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->id = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1292 "rygel-simple-container.c"
}


static RygelMediaObject* rygel_simple_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSimpleContainerFindObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 1303 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 1313 "rygel-simple-container.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return _data2_;
#line 1322 "rygel-simple-container.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1331 "rygel-simple-container.c"
		RygelSimpleContainer * self;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		self = _data2_->self;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (self);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_slice_free (Block2Data, _data2_);
#line 1339 "rygel-simple-container.c"
	}
}


static void rygel_simple_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerFindObjectData* _data_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_find_object_co (_data_);
#line 1354 "rygel-simple-container.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return _data3_;
#line 1363 "rygel-simple-container.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1372 "rygel-simple-container.c"
		RygelSimpleContainer * self;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		self = _data3_->_data2_->self;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		block2_data_unref (_data3_->_data2_);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data3_->_data2_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_slice_free (Block3Data, _data3_);
#line 1382 "rygel-simple-container.c"
	}
}


static void ________lambda19_ (Block3Data* _data3_, RygelMediaContainer* _, RygelMediaObject* updated) {
	Block2Data* _data2_;
	RygelSimpleContainer * self;
	RygelMediaObject* _tmp0_ = NULL;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data2_ = _data3_->_data2_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = _data2_->self;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (_ != NULL);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject)) {
#line 1403 "rygel-simple-container.c"
		gint _tmp1_ = 0;
		gulong _tmp2_ = 0UL;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data2_->restart = TRUE;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp1_ = _data2_->restart_count;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data2_->restart_count = _tmp1_ + 1;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp2_ = _data3_->updated_id;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_signal_handler_disconnect ((GObject*) self, _tmp2_);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data3_->updated_id = (gulong) 0;
#line 1418 "rygel-simple-container.c"
	}
}


static void _________lambda19__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	________lambda19_ (self, container, object);
#line 1426 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_find_object_co (RygelSimpleContainerFindObjectData* _data_) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 1435 "rygel-simple-container.c"
		goto _state_0;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 1:
#line 1439 "rygel-simple-container.c"
		goto _state_1;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 2:
#line 1443 "rygel-simple-container.c"
		goto _state_2;
		default:
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 1448 "rygel-simple-container.c"
	}
	_state_0:
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->media_object = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->max_count = 0;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->restart_count = 0;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_->restart = FALSE;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = FALSE;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = FALSE;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_tmp1_) {
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp2_ = 0;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp2_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp3_ = 0;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->max_count = _data_->_tmp3_;
#line 1487 "rygel-simple-container.c"
	} else {
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp4_ = 0;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp4_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp5_ = 0;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->max_count = _data_->_tmp5_;
#line 1499 "rygel-simple-container.c"
	}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = 0;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = _data_->max_count;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_state_ = 1;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp6_, "", _data_->_tmp7_, rygel_simple_container_find_object_ready, _data_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1515 "rygel-simple-container.c"
	_state_1:
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp8_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp8_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->children_to_search = _data_->_tmp8_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_error_free (_data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_g_object_unref0 (_data_->media_object);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		block2_data_unref (_data_->_data2_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_data2_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (_data_->_state_ == 0) {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1539 "rygel-simple-container.c"
		} else {
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1543 "rygel-simple-container.c"
		}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_object_unref (_data_->_async_result);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return FALSE;
#line 1549 "rygel-simple-container.c"
	}
	{
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_data_->_tmp9_ = TRUE;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		while (TRUE) {
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_ = g_slice_new0 (Block3Data);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->_ref_count_ = 1;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_tmp10_ = FALSE;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			if (!_data_->_tmp10_) {
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp12_ = FALSE;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp12_ = _data_->_data2_->restart;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (_data_->_tmp12_) {
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp13_ = 0;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp13_ = _data_->_data2_->restart_count;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp11_ = _data_->_tmp13_ < 10;
#line 1580 "rygel-simple-container.c"
				} else {
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp11_ = FALSE;
#line 1584 "rygel-simple-container.c"
				}
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp14_ = FALSE;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp14_ = _data_->_tmp11_;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				if (!_data_->_tmp14_) {
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					block3_data_unref (_data_->_data3_);
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_data3_ = NULL;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					break;
#line 1598 "rygel-simple-container.c"
				}
			}
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_tmp9_ = FALSE;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data2_->restart = FALSE;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_->updated_id = (gulong) 0;
#line 1607 "rygel-simple-container.c"
			{
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp15_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp15_ = _data_->children_to_search;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp16_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_list = _data_->_tmp16_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp17_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp17_ = _data_->_child_list;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp18_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp17_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp19_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_tmp19_ = _data_->_tmp18_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_size = _data_->_tmp19_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_data_->_child_index = -1;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				while (TRUE) {
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp20_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp20_ = _data_->_child_index;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_child_index = _data_->_tmp20_ + 1;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp21_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp21_ = _data_->_child_index;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp22_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp22_ = _data_->_child_size;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						break;
#line 1655 "rygel-simple-container.c"
					}
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp23_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp23_ = _data_->_child_list;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp24_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp24_ = _data_->_child_index;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp25_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp23_, _data_->_tmp24_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->child = (RygelMediaObject*) _data_->_tmp25_;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp26_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp26_ = _data_->child;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp27_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp27_ = rygel_media_object_get_id (_data_->_tmp26_);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp28_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp28_ = _data_->_tmp27_;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp29_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_data_->_tmp29_ = _data_->id;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					if (g_strcmp0 (_data_->_tmp28_, _data_->_tmp29_) == 0) {
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp30_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp30_ = _data_->child;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp31_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_g_object_unref0 (_data_->media_object);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->media_object = _data_->_tmp31_;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_g_object_unref0 (_data_->child);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						break;
#line 1705 "rygel-simple-container.c"
					} else {
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp32_ = NULL;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						_data_->_tmp32_ = _data_->child;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp32_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp33_ = 0UL;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp33_ = g_signal_connect_data ((RygelMediaContainer*) _data_->self, "container-updated", (GCallback) _________lambda19__rygel_media_container_container_updated, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_data3_->updated_id = _data_->_tmp33_;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp34_ = NULL;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp34_ = _data_->child;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp35_ = NULL;
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp34_) : NULL);
#line 241 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->container = _data_->_tmp35_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp37_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp37_ = _data_->container;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp38_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp38_ = _data_->id;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp39_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp39_ = _data_->cancellable;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_state_ = 2;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							rygel_media_container_find_object (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, rygel_simple_container_find_object_ready, _data_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							return FALSE;
#line 1747 "rygel-simple-container.c"
							_state_2:
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp40_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp40_ = rygel_media_container_find_object_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp36_ = _data_->_tmp40_;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_inner_error_ != NULL) {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_error_free (_data_->_inner_error_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->_child_list);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								block3_data_unref (_data_->_data3_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data3_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->children_to_search);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->media_object);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								block2_data_unref (_data_->_data2_);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data2_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								if (_data_->_state_ == 0) {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
									g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1783 "rygel-simple-container.c"
								} else {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
									g_simple_async_result_complete (_data_->_async_result);
#line 1787 "rygel-simple-container.c"
								}
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_object_unref (_data_->_async_result);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								return FALSE;
#line 1793 "rygel-simple-container.c"
							}
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_g_object_unref0 (_data_->media_object);
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->media_object = _data_->_tmp36_;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp41_ = 0UL;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp41_ = _data_->_data3_->updated_id;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp41_ != ((gulong) 0)) {
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_tmp42_ = 0UL;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_tmp42_ = _data_->_data3_->updated_id;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp42_);
#line 1811 "rygel-simple-container.c"
							}
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp43_ = NULL;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp43_ = _data_->media_object;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp43_ != NULL) {
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_data_->_data2_->restart = FALSE;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								break;
#line 1827 "rygel-simple-container.c"
							}
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp44_ = FALSE;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_data_->_tmp44_ = _data_->_data2_->restart;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							if (_data_->_tmp44_) {
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->container);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								_g_object_unref0 (_data_->child);
#line 257 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
								break;
#line 1841 "rygel-simple-container.c"
							}
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
							_g_object_unref0 (_data_->container);
#line 1845 "rygel-simple-container.c"
						}
					}
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
					_g_object_unref0 (_data_->child);
#line 1850 "rygel-simple-container.c"
				}
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
				_g_object_unref0 (_data_->_child_list);
#line 1854 "rygel-simple-container.c"
			}
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			block3_data_unref (_data_->_data3_);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			_data_->_data3_ = NULL;
#line 1860 "rygel-simple-container.c"
		}
	}
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = _data_->media_object;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->children_to_search);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	block2_data_unref (_data_->_data2_);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = NULL;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1875 "rygel-simple-container.c"
	} else {
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1879 "rygel-simple-container.c"
	}
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->children_to_search);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->media_object);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	block2_data_unref (_data_->_data2_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_data2_ = NULL;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1897 "rygel-simple-container.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1901 "rygel-simple-container.c"
	}
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 1907 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search_data_free (gpointer _data) {
	RygelSimpleContainerSearchData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_slice_free (RygelSimpleContainerSearchData, _data_);
#line 1926 "rygel-simple-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1933 "rygel-simple-container.c"
}


static void rygel_simple_container_real_search (RygelSearchableContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSimpleContainer * self;
	RygelSimpleContainerSearchData* _data_;
	RygelSimpleContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_slice_new0 (RygelSimpleContainerSearchData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_simple_container_real_search);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_simple_container_real_search_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = expression;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->expression = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = offset;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->offset = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp4_ = max_count;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->max_count = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp5_ = sort_criteria;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp7_ = cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->cancellable = _tmp8_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 1995 "rygel-simple-container.c"
}


static RygelMediaObjects* rygel_simple_container_real_search_finish (RygelSearchableContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSimpleContainerSearchData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return NULL;
#line 2006 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (total_matches) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		*total_matches = _data_->total_matches;
#line 2014 "rygel-simple-container.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 2022 "rygel-simple-container.c"
}


static void rygel_simple_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSimpleContainerSearchData* _data_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_ = _user_data_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_source_object_ = source_object;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_res_ = _res_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_real_search_co (_data_);
#line 2036 "rygel-simple-container.c"
}


static gboolean rygel_simple_container_real_search_co (RygelSimpleContainerSearchData* _data_) {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (_data_->_state_) {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 0:
#line 2045 "rygel-simple-container.c"
		goto _state_0;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case 1:
#line 2049 "rygel-simple-container.c"
		goto _state_1;
		default:
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_assert_not_reached ();
#line 2054 "rygel-simple-container.c"
	}
	_state_0:
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = NULL;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp1_ = _data_->expression;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = 0U;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp2_ = _data_->offset;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = 0U;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp3_ = _data_->max_count;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp4_ = NULL;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp4_ = _data_->sort_criteria;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp5_ = NULL;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp6_ = 0U;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_state_ = 1;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, rygel_simple_container_search_ready, _data_);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 2085 "rygel-simple-container.c"
	_state_1:
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = NULL;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp7_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->_tmp0_ = _data_->_tmp7_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_error_free (_data_->_inner_error_);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (_data_->_state_ == 0) {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2105 "rygel-simple-container.c"
		} else {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2109 "rygel-simple-container.c"
		}
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_object_unref (_data_->_async_result);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		return FALSE;
#line 2115 "rygel-simple-container.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_data_->result = _data_->_tmp0_;
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2123 "rygel-simple-container.c"
	} else {
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2127 "rygel-simple-container.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 273 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_data_->_state_ == 0) {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2137 "rygel-simple-container.c"
	} else {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2141 "rygel-simple-container.c"
	}
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_unref (_data_->_async_result);
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return FALSE;
#line 2147 "rygel-simple-container.c"
}


static void rygel_simple_container_add_child (RygelSimpleContainer* self, RygelMediaObject* child) {
	RygelMediaObjects* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (child != NULL);
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->children;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = child;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = rygel_media_container_get_child_count ((RygelMediaContainer*) self);
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp3_ = _tmp2_;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_media_container_set_child_count ((RygelMediaContainer*) self, _tmp3_ + 1);
#line 2172 "rygel-simple-container.c"
}


static void rygel_simple_container_on_container_updated (RygelSimpleContainer* self, RygelMediaContainer* source, RygelMediaContainer* updated, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (self != NULL);
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (source != NULL);
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (updated != NULL);
#line 287 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_return_if_fail (object != NULL);
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = updated;
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = rygel_media_container_get_child_count (_tmp0_);
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp2_ = _tmp1_;
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	if (_tmp2_ > 0) {
#line 2196 "rygel-simple-container.c"
		RygelMediaObjects* _tmp3_ = NULL;
		RygelMediaContainer* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		RygelMediaObjects* _tmp6_ = NULL;
		RygelMediaContainer* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		RygelMediaContainer* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp3_ = self->priv->empty_children;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp4_ = updated;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, (RygelMediaObject*) _tmp4_);
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (!_tmp5_) {
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			return;
#line 2218 "rygel-simple-container.c"
		}
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp6_ = self->priv->empty_children;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp7_ = updated;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, (RygelMediaObject*) _tmp7_);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp8_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp9_ = _tmp8_;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp9_ - 1);
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp10_ = updated;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_add_child (self, (RygelMediaObject*) _tmp10_);
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp11_ = updated;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp11_);
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp13_ = _tmp12_;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:304: Container '%s' now non-empty, added i" \
"t to hierarchy now.", _tmp13_);
#line 2246 "rygel-simple-container.c"
	} else {
		RygelMediaObjects* _tmp14_ = NULL;
		RygelMediaContainer* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		RygelMediaContainer* _tmp17_ = NULL;
		RygelMediaObjects* _tmp18_ = NULL;
		RygelMediaContainer* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		RygelMediaContainer* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp14_ = self->children;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp15_ = updated;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp14_, (RygelMediaObject*) _tmp15_);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		if (!_tmp16_) {
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
			return;
#line 2269 "rygel-simple-container.c"
		}
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp17_ = updated;
#line 311 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_simple_container_remove_child (self, (RygelMediaObject*) _tmp17_);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp18_ = self->priv->empty_children;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp19_ = updated;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (RygelMediaObject*) _tmp19_);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp20_ = rygel_media_container_get_empty_child_count ((RygelMediaContainer*) self);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp21_ = _tmp20_;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_set_empty_child_count ((RygelMediaContainer*) self, _tmp21_ + 1);
#line 315 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_media_container_updated ((RygelMediaContainer*) self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp22_ = updated;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp23_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp22_);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		_tmp24_ = _tmp23_;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_debug ("rygel-simple-container.vala:317: Container '%s' now empty, removing it" \
" from hierarchy now.", _tmp24_);
#line 2297 "rygel-simple-container.c"
	}
}


static GeeArrayList* rygel_simple_container_real_get_search_classes (RygelSearchableContainer* base) {
	GeeArrayList* result;
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = self->priv->_search_classes;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	return result;
#line 2314 "rygel-simple-container.c"
}


static void rygel_simple_container_real_set_search_classes (RygelSearchableContainer* base, GeeArrayList* value) {
	RygelSimpleContainer* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = (RygelSimpleContainer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv->_search_classes = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_notify ((GObject *) self, "search-classes");
#line 2334 "rygel-simple-container.c"
}


static void rygel_simple_container_class_init (RygelSimpleContainerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_type_class_add_private (klass, sizeof (RygelSimpleContainerPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_simple_container_real_constructed;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_simple_container_real_get_children;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_simple_container_real_get_children_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_simple_container_real_find_object;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_simple_container_real_find_object_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_simple_container_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_simple_container_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_container_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2361 "rygel-simple-container.c"
}


static void rygel_simple_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	rygel_simple_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->search = (RygelMediaObjects* (*)(RygelSearchableContainer*, RygelSearchExpression*, guint, guint, guint*, const gchar*, GCancellable*, GError**)) rygel_simple_container_real_search;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->search_finish = rygel_simple_container_real_search_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->get_search_classes = rygel_simple_container_real_get_search_classes;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	iface->set_search_classes = rygel_simple_container_real_set_search_classes;
#line 2376 "rygel-simple-container.c"
}


static void rygel_simple_container_instance_init (RygelSimpleContainer * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self->priv = RYGEL_SIMPLE_CONTAINER_GET_PRIVATE (self);
#line 2383 "rygel-simple-container.c"
}


static void rygel_simple_container_finalize (GObject* obj) {
	RygelSimpleContainer * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->children);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->empty_children);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	_g_object_unref0 (self->priv->_search_classes);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	G_OBJECT_CLASS (rygel_simple_container_parent_class)->finalize (obj);
#line 2399 "rygel-simple-container.c"
}


/**
 * A simple implementation of RygelMediaContainer that keeps all RygelMediaObjects
 * in memory. You should add children via rygel_simple_container_add_child_item().
 */
GType rygel_simple_container_get_type (void) {
	static volatile gsize rygel_simple_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleContainer), 0, (GInstanceInitFunc) rygel_simple_container_instance_init, NULL };
		static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_simple_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_container_type_id;
		rygel_simple_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSimpleContainer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
		g_once_init_leave (&rygel_simple_container_type_id__volatile, rygel_simple_container_type_id);
	}
	return rygel_simple_container_type_id__volatile;
}


static void _vala_rygel_simple_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2432 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2438 "rygel-simple-container.c"
	}
}


static void _vala_rygel_simple_container_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSimpleContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		case RYGEL_SIMPLE_CONTAINER_SEARCH_CLASSES:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2454 "rygel-simple-container.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-simple-container.vala"
		break;
#line 2460 "rygel-simple-container.c"
	}
}



