/* rygel-reference-creator.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-reference-creator.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_REFERENCE_CREATOR (rygel_reference_creator_get_type ())
#define RYGEL_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator))
#define RYGEL_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))
#define RYGEL_IS_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_IS_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_REFERENCE_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))

typedef struct _RygelReferenceCreator RygelReferenceCreator;
typedef struct _RygelReferenceCreatorClass RygelReferenceCreatorClass;
typedef struct _RygelReferenceCreatorPrivate RygelReferenceCreatorPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelReferenceCreatorRunData RygelReferenceCreatorRunData;
typedef struct _RygelReferenceCreatorFetchContainerData RygelReferenceCreatorFetchContainerData;

struct _RygelReferenceCreator {
	GObject parent_instance;
	RygelReferenceCreatorPrivate * priv;
	gchar* container_id;
	gchar* object_id;
};

struct _RygelReferenceCreatorClass {
	GObjectClass parent_class;
};

struct _RygelReferenceCreatorPrivate {
	RygelContentDirectory* content_directory;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelReferenceCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelReferenceCreator* self;
	RygelWritableContainer* container;
	RygelWritableContainer* _tmp0_;
	RygelMediaContainer* root_container;
	RygelContentDirectory* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	RygelMediaObject* object;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelMediaObject* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	gchar* new_id;
	RygelWritableContainer* _tmp12_;
	RygelMediaObject* _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	gchar* _tmp16_;
	GUPnPServiceAction* _tmp17_;
	const gchar* _tmp18_;
	GUPnPServiceAction* _tmp19_;
	GError* _error_;
	GError* _tmp20_;
	GUPnPServiceAction* _tmp21_;
	GError* _tmp22_;
	gint _tmp23_;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GUPnPServiceAction* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError * _inner_error_;
};

struct _RygelReferenceCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelReferenceCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	RygelMediaContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	gboolean _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	RygelMediaObject* _tmp21_;
	RygelWritableContainer* _tmp22_;
	GError * _inner_error_;
};


static gpointer rygel_reference_creator_parent_class = NULL;
static RygelStateMachineIface* rygel_reference_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_reference_creator_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_REFERENCE_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorPrivate))
enum  {
	RYGEL_REFERENCE_CREATOR_DUMMY_PROPERTY,
	RYGEL_REFERENCE_CREATOR_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelReferenceCreator* rygel_reference_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_reference_creator_parse_arguments (RygelReferenceCreator* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_reference_creator_real_run_data_free (gpointer _data);
static void rygel_reference_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_reference_creator_real_run_co (RygelReferenceCreatorRunData* _data_);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static void rygel_reference_creator_fetch_container (RygelReferenceCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelWritableContainer* rygel_reference_creator_fetch_container_finish (RygelReferenceCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_reference_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_reference (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* rygel_writable_container_add_reference_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_reference_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_reference_creator_fetch_container_co (RygelReferenceCreatorFetchContainerData* _data_);
static void rygel_reference_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static void rygel_reference_creator_finalize (GObject* obj);
static void _vala_rygel_reference_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_reference_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 317 "rygel-reference-creator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 324 "rygel-reference-creator.c"
}


RygelReferenceCreator* rygel_reference_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelReferenceCreator * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self = (RygelReferenceCreator*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = content_dir;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (self->priv->content_directory);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self->priv->content_directory = _tmp1_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp2_ = content_dir;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp4_ = action;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	action = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self->priv->action = _tmp4_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return self;
#line 367 "rygel-reference-creator.c"
}


RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return rygel_reference_creator_construct (RYGEL_TYPE_REFERENCE_CREATOR, content_dir, action);
#line 374 "rygel-reference-creator.c"
}


void rygel_reference_creator_parse_arguments (RygelReferenceCreator* self, GError** error) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = self->priv->action;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	gupnp_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &self->container_id, "ObjectID", G_TYPE_STRING, &self->object_id, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp1_ = self->container_id;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_tmp1_ == NULL) {
#line 393 "rygel-reference-creator.c"
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_tmp2_ = _ ("'ContainerID' agument missing.");
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp2_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_inner_error_ = _tmp3_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return;
#line 406 "rygel-reference-creator.c"
	}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp4_ = self->object_id;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_tmp4_ == NULL) {
#line 412 "rygel-reference-creator.c"
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_tmp5_ = _ ("'ObjectID' argument missing.");
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp5_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_inner_error_ = _tmp6_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return;
#line 425 "rygel-reference-creator.c"
	}
}


static void rygel_reference_creator_real_run_data_free (gpointer _data) {
	RygelReferenceCreatorRunData* _data_;
	_data_ = _data;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_slice_free (RygelReferenceCreatorRunData, _data_);
#line 437 "rygel-reference-creator.c"
}


static void rygel_reference_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelReferenceCreator * self;
	RygelReferenceCreatorRunData* _data_;
	RygelReferenceCreator* _tmp0_ = NULL;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self = (RygelReferenceCreator*) base;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = g_slice_new0 (RygelReferenceCreatorRunData);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_reference_creator_real_run);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_reference_creator_real_run_data_free);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_real_run_co (_data_);
#line 459 "rygel-reference-creator.c"
}


static void rygel_reference_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelReferenceCreatorRunData* _data_;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 467 "rygel-reference-creator.c"
}


static void rygel_reference_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelReferenceCreatorRunData* _data_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = _user_data_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_source_object_ = source_object;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_res_ = _res_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_real_run_co (_data_);
#line 481 "rygel-reference-creator.c"
}


static gboolean rygel_reference_creator_real_run_co (RygelReferenceCreatorRunData* _data_) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	switch (_data_->_state_) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 0:
#line 490 "rygel-reference-creator.c"
		goto _state_0;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 1:
#line 494 "rygel-reference-creator.c"
		goto _state_1;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 2:
#line 498 "rygel-reference-creator.c"
		goto _state_2;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 3:
#line 502 "rygel-reference-creator.c"
		goto _state_3;
		default:
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_assert_not_reached ();
#line 507 "rygel-reference-creator.c"
	}
	_state_0:
	{
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		rygel_reference_creator_parse_arguments (_data_->self, &_data_->_inner_error_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 515 "rygel-reference-creator.c"
			goto __catch59_g_error;
		}
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_state_ = 1;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		rygel_reference_creator_fetch_container (_data_->self, rygel_reference_creator_run_ready, _data_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 524 "rygel-reference-creator.c"
		_state_1:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp0_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp0_ = rygel_reference_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->container = _data_->_tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 534 "rygel-reference-creator.c"
			goto __catch59_g_error;
		}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp1_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp1_ = _data_->self->priv->content_directory;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp2_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp2_ = _data_->_tmp1_->root_container;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp3_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->root_container = _data_->_tmp3_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp4_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp4_ = _data_->root_container;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp5_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp5_ = _data_->self->object_id;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp6_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp7_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_state_ = 2;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		rygel_media_container_find_object (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_reference_creator_run_ready, _data_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 573 "rygel-reference-creator.c"
		_state_2:
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp8_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->object = _data_->_tmp8_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->container);
#line 587 "rygel-reference-creator.c"
			goto __catch59_g_error;
		}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp9_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp9_ = _data_->object;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_tmp9_ == NULL) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp10_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp10_ = _ ("No such object");
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp11_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp10_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->object);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->container);
#line 612 "rygel-reference-creator.c"
			goto __catch59_g_error;
		}
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp12_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp12_ = _data_->container;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp13_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp13_ = _data_->object;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp14_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp14_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp15_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_state_ = 3;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		rygel_writable_container_add_reference (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_, rygel_reference_creator_run_ready, _data_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 637 "rygel-reference-creator.c"
		_state_3:
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp16_ = NULL;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp16_ = rygel_writable_container_add_reference_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->new_id = _data_->_tmp16_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->object);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->container);
#line 653 "rygel-reference-creator.c"
			goto __catch59_g_error;
		}
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp17_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp17_ = _data_->self->priv->action;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp18_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp18_ = _data_->new_id;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		gupnp_service_action_set (_data_->_tmp17_, "NewID", G_TYPE_STRING, _data_->_tmp18_, NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp19_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp19_ = _data_->self->priv->action;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		gupnp_service_action_return (_data_->_tmp19_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_free0 (_data_->new_id);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->object);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->container);
#line 682 "rygel-reference-creator.c"
	}
	goto __finally59;
	__catch59_g_error:
	{
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_inner_error_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp20_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp20_ = _data_->_error_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_tmp20_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp21_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp21_ = _data_->self->priv->action;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp22_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp22_ = _data_->_error_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp23_ = 0;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp23_ = _data_->_tmp22_->code;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp24_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp24_ = _data_->_error_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp25_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp25_ = _data_->_tmp24_->message;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			gupnp_service_action_return_error (_data_->_tmp21_, (guint) _data_->_tmp23_, _data_->_tmp25_);
#line 719 "rygel-reference-creator.c"
		} else {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp26_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp26_ = _data_->self->priv->action;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp27_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp27_ = _data_->_error_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp28_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp28_ = _data_->_tmp27_->message;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			gupnp_service_action_return_error (_data_->_tmp26_, (guint) 402, _data_->_tmp28_);
#line 735 "rygel-reference-creator.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp29_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp29_ = _ ("Failed to create object under '%s': %s");
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp30_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp30_ = _data_->self->container_id;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp31_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp31_ = _data_->_error_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp32_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp32_ = _data_->_tmp31_->message;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_warning (_data_->_tmp29_, _data_->_tmp30_, _data_->_tmp32_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_error_free0 (_data_->_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_state_ == 0) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 763 "rygel-reference-creator.c"
		} else {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 767 "rygel-reference-creator.c"
		}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_object_unref (_data_->_async_result);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 773 "rygel-reference-creator.c"
	}
	__finally59:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 784 "rygel-reference-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 790 "rygel-reference-creator.c"
	} else {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 794 "rygel-reference-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return FALSE;
#line 800 "rygel-reference-creator.c"
}


static void rygel_reference_creator_fetch_container_data_free (gpointer _data) {
	RygelReferenceCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->result);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_slice_free (RygelReferenceCreatorFetchContainerData, _data_);
#line 813 "rygel-reference-creator.c"
}


static void rygel_reference_creator_fetch_container (RygelReferenceCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelReferenceCreatorFetchContainerData* _data_;
	RygelReferenceCreator* _tmp0_ = NULL;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = g_slice_new0 (RygelReferenceCreatorFetchContainerData);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_reference_creator_fetch_container);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_reference_creator_fetch_container_data_free);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_fetch_container_co (_data_);
#line 832 "rygel-reference-creator.c"
}


static RygelWritableContainer* rygel_reference_creator_fetch_container_finish (RygelReferenceCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelReferenceCreatorFetchContainerData* _data_;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return NULL;
#line 843 "rygel-reference-creator.c"
	}
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	result = _data_->result;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->result = NULL;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return result;
#line 853 "rygel-reference-creator.c"
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_reference_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelReferenceCreatorFetchContainerData* _data_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_ = _user_data_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_source_object_ = source_object;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_res_ = _res_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_fetch_container_co (_data_);
#line 877 "rygel-reference-creator.c"
}


static gboolean rygel_reference_creator_fetch_container_co (RygelReferenceCreatorFetchContainerData* _data_) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	switch (_data_->_state_) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 0:
#line 886 "rygel-reference-creator.c"
		goto _state_0;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case 1:
#line 890 "rygel-reference-creator.c"
		goto _state_1;
		default:
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_assert_not_reached ();
#line 895 "rygel-reference-creator.c"
	}
	_state_0:
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->media_object = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp0_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->content_directory;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp1_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp2_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->root_container = _data_->_tmp2_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp4_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp4_ = _data_->root_container;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp5_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp5_ = _data_->self->container_id;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp6_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp7_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_state_ = 1;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_media_container_find_object (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_reference_creator_fetch_container_ready, _data_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return FALSE;
#line 936 "rygel-reference-creator.c"
	_state_1:
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp8_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp8_ = rygel_media_container_find_object_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp3_ = _data_->_tmp8_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_state_ == 0) {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 958 "rygel-reference-creator.c"
		} else {
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 962 "rygel-reference-creator.c"
		}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_object_unref (_data_->_async_result);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 968 "rygel-reference-creator.c"
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->media_object = _data_->_tmp3_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp10_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp10_ = _data_->media_object;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_tmp10_ == NULL) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp9_ = TRUE;
#line 982 "rygel-reference-creator.c"
	} else {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp11_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp11_ = _data_->media_object;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp9_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp11_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 990 "rygel-reference-creator.c"
	}
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp12_ = FALSE;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp12_ = _data_->_tmp9_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_tmp12_) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp13_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp13_ = _ ("No such object");
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp14_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp14_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _data_->_tmp13_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_inner_error_ = _data_->_tmp14_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (_data_->_state_ == 0) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1020 "rygel-reference-creator.c"
		} else {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1024 "rygel-reference-creator.c"
		}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_object_unref (_data_->_async_result);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		return FALSE;
#line 1030 "rygel-reference-creator.c"
	} else {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp15_ = NULL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		_data_->_tmp15_ = _data_->media_object;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp16_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp16_ = _ ("Object creation in %s not allowed");
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp17_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp17_ = _data_->media_object;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp18_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp18_ = rygel_media_object_get_id (_data_->_tmp17_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp19_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp20_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_tmp20_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp16_, _data_->_tmp19_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_data_->_inner_error_ = _data_->_tmp20_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			if (_data_->_state_ == 0) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1072 "rygel-reference-creator.c"
			} else {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1076 "rygel-reference-creator.c"
			}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			g_object_unref (_data_->_async_result);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
			return FALSE;
#line 1082 "rygel-reference-creator.c"
		}
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp21_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp21_ = _data_->media_object;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp22_ = NULL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp21_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp21_) : NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_data_->result = _data_->_tmp22_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_state_ == 0) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1103 "rygel-reference-creator.c"
	} else {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1107 "rygel-reference-creator.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_object_unref (_data_->_async_result);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return FALSE;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	if (_data_->_state_ == 0) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1121 "rygel-reference-creator.c"
	} else {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1125 "rygel-reference-creator.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_object_unref (_data_->_async_result);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return FALSE;
#line 1131 "rygel-reference-creator.c"
}


static GCancellable* rygel_reference_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelReferenceCreator* self;
	GCancellable* _tmp0_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self = (RygelReferenceCreator*) base;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	return result;
#line 1147 "rygel-reference-creator.c"
}


static void rygel_reference_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelReferenceCreator* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self = (RygelReferenceCreator*) base;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp0_ = value;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1167 "rygel-reference-creator.c"
}


static void rygel_reference_creator_class_init (RygelReferenceCreatorClass * klass) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelReferenceCreatorPrivate));
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_reference_creator_get_property;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_reference_creator_set_property;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_reference_creator_finalize;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_REFERENCE_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1184 "rygel-reference-creator.c"
}


static void rygel_reference_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	rygel_reference_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_reference_creator_real_run;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	iface->run_finish = rygel_reference_creator_real_run_finish;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	iface->get_cancellable = rygel_reference_creator_real_get_cancellable;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	iface->set_cancellable = rygel_reference_creator_real_set_cancellable;
#line 1199 "rygel-reference-creator.c"
}


static void rygel_reference_creator_instance_init (RygelReferenceCreator * self) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self->priv = RYGEL_REFERENCE_CREATOR_GET_PRIVATE (self);
#line 1206 "rygel-reference-creator.c"
}


static void rygel_reference_creator_finalize (GObject* obj) {
	RygelReferenceCreator * self;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
#line 26 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (self->priv->content_directory);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_free0 (self->container_id);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	_g_free0 (self->object_id);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	G_OBJECT_CLASS (rygel_reference_creator_parent_class)->finalize (obj);
#line 1226 "rygel-reference-creator.c"
}


GType rygel_reference_creator_get_type (void) {
	static volatile gsize rygel_reference_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_reference_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelReferenceCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_reference_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelReferenceCreator), 0, (GInstanceInitFunc) rygel_reference_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_reference_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_reference_creator_type_id;
		rygel_reference_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelReferenceCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_reference_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_reference_creator_type_id__volatile, rygel_reference_creator_type_id);
	}
	return rygel_reference_creator_type_id__volatile;
}


static void _vala_rygel_reference_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelReferenceCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case RYGEL_REFERENCE_CREATOR_CANCELLABLE:
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		break;
#line 1255 "rygel-reference-creator.c"
		default:
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		break;
#line 1261 "rygel-reference-creator.c"
	}
}


static void _vala_rygel_reference_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelReferenceCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		case RYGEL_REFERENCE_CREATOR_CANCELLABLE:
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		break;
#line 1277 "rygel-reference-creator.c"
		default:
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-reference-creator.vala"
		break;
#line 1283 "rygel-reference-creator.c"
	}
}



