/* rygel-music-item.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	RygelDataSource* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMusicItemPrivate {
	gchar* _artist;
	gchar* _album;
	gchar* _genre;
	gint _track_number;
	RygelThumbnail* _album_art;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_music_item_parent_class = NULL;
extern GRegex* rygel_media_item_address_regex;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_MUSIC_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemPrivate))
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY,
	RYGEL_MUSIC_ITEM_ARTIST,
	RYGEL_MUSIC_ITEM_ALBUM,
	RYGEL_MUSIC_ITEM_GENRE,
	RYGEL_MUSIC_ITEM_TRACK_NUMBER,
	RYGEL_MUSIC_ITEM_ALBUM_ART
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value);
static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_music_item_get_artist (RygelMusicItem* self);
const gchar* rygel_music_item_get_album (RygelMusicItem* self);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
gint rygel_music_item_get_track_number (RygelMusicItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static gchar* rygel_music_item_get_first (RygelMusicItem* self, GList* contributors);
void rygel_music_item_set_artist (RygelMusicItem* self, const gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_music_item_set_track_number (RygelMusicItem* self, gint value);
void rygel_music_item_set_album (RygelMusicItem* self, const gchar* value);
void rygel_music_item_set_genre (RygelMusicItem* self, const gchar* value);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_music_item_get_genre (RygelMusicItem* self);
static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
static void rygel_music_item_finalize (GObject* obj);
static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = id;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = parent;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = title;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = upnp_class;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self;
#line 351 "rygel-music-item.c"
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
#line 358 "rygel-music-item.c"
}


void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelMediaArtStore* media_art_store = NULL;
	RygelMediaArtStore* _tmp1_ = NULL;
	RygelMediaArtStore* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_album_art;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_vala_assert (_tmp0_ == NULL, "this.album_art == null");
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = rygel_media_art_store_get_default ();
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	media_art_store = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = media_art_store;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp2_ == NULL) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 386 "rygel-music-item.c"
	}
	{
		RygelThumbnail* _tmp3_ = NULL;
		RygelMediaArtStore* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_ = NULL;
		RygelThumbnail* _tmp6_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = media_art_store;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = rygel_media_art_store_find_media_art_any (_tmp4_, self, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = _tmp5_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 401 "rygel-music-item.c"
			goto __catch3_g_error;
		}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = _tmp3_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_album_art (self, _tmp6_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_rygel_icon_info_unref0 (_tmp6_);
#line 410 "rygel-music-item.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		err = _inner_error_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_error_free0 (err);
#line 422 "rygel-music-item.c"
	}
	__finally3:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 435 "rygel-music-item.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (media_art_store);
#line 439 "rygel-music-item.c"
}


static void rygel_music_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelThumbnail* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = didl_item;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = allow_internal;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 465 "rygel-music-item.c"
	}
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = self->priv->_album_art;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp2_ != NULL) {
#line 471 "rygel-music-item.c"
		gchar* protocol = NULL;
		RygelThumbnail* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = self->priv->_album_art;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp4_, &_inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		protocol = _tmp5_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			g_propagate_error (error, _inner_error_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			return;
#line 493 "rygel-music-item.c"
		}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp7_ = allow_internal;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp7_) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp6_ = TRUE;
#line 501 "rygel-music-item.c"
		} else {
			const gchar* _tmp8_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp8_ = protocol;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp6_ = g_strcmp0 (_tmp8_, "internal") != 0;
#line 508 "rygel-music-item.c"
		}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = _tmp6_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp9_) {
#line 514 "rygel-music-item.c"
			GUPnPDIDLLiteItem* _tmp10_ = NULL;
			RygelThumbnail* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp10_ = didl_item;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp11_ = self->priv->_album_art;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp12_ = ((RygelIconInfo*) _tmp11_)->uri;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp10_, _tmp12_);
#line 526 "rygel-music-item.c"
		}
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (protocol);
#line 530 "rygel-music-item.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 538 "rygel-music-item.c"
}


static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMusicItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMusicItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label1 = 0;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label2 = 0;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = media_object;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		result = 1;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return result;
#line 572 "rygel-music-item.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = media_object;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp1_) : NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	item = _tmp2_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = property;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = _tmp3_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:artist")))) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 590 "rygel-music-item.c"
			default:
			{
				const gchar* _tmp7_ = NULL;
				RygelMusicItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp7_ = self->priv->_artist;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp8_ = item;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp9_ = _tmp8_->priv->_artist;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp10_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 611 "rygel-music-item.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("upnp:album")))) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 617 "rygel-music-item.c"
			default:
			{
				const gchar* _tmp11_ = NULL;
				RygelMusicItem* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gint _tmp14_ = 0;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp11_ = self->priv->_album;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp12_ = item;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp13_ = _tmp12_->priv->_album;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp14_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp11_, _tmp13_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp14_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 638 "rygel-music-item.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 644 "rygel-music-item.c"
			default:
			{
				gint _tmp15_ = 0;
				RygelMusicItem* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp15_ = self->priv->_track_number;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp16_ = item;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp17_ = _tmp16_->priv->_track_number;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp18_ = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp15_, _tmp17_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp18_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 665 "rygel-music-item.c"
			}
		}
	} else {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 671 "rygel-music-item.c"
			default:
			{
				RygelMusicItem* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp19_ = item;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp20_ = property;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp21_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp19_, _tmp20_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp21_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 689 "rygel-music-item.c"
			}
		}
	}
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (item);
#line 695 "rygel-music-item.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 702 "rygel-music-item.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_list_free (self);
#line 711 "rygel-music-item.c"
}


static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GUPnPDIDLLiteObject* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GUPnPDIDLLiteObject* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GUPnPDIDLLiteObject* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = didl_object;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = didl_object;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_artists (_tmp1_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = _tmp2_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = rygel_music_item_get_first (self, _tmp3_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp5_ = _tmp4_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_set_artist (self, _tmp5_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (_tmp5_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	__g_list_free__g_object_unref0_0 (_tmp3_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = didl_object;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp7_ = gupnp_didl_lite_object_get_track_number (_tmp6_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp8_ = _tmp7_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_set_track_number (self, _tmp8_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp9_ = didl_object;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp10_ = gupnp_didl_lite_object_get_album (_tmp9_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp11_ = _tmp10_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_set_album (self, _tmp11_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp12_ = didl_object;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp13_ = gupnp_didl_lite_object_get_genre (_tmp12_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp14_ = _tmp13_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_set_genre (self, _tmp14_);
#line 780 "rygel-music-item.c"
}


static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint _tmp11_ = 0;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp23_ = FALSE;
	GUPnPDIDLLiteObject* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = serializer;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = http_server;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	didl_item = _tmp2_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return NULL;
#line 825 "rygel-music-item.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = self->priv->_artist;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp4_ != NULL) {
#line 831 "rygel-music-item.c"
		const gchar* _tmp5_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = self->priv->_artist;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 837 "rygel-music-item.c"
	} else {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = FALSE;
#line 841 "rygel-music-item.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = _tmp3_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_) {
#line 847 "rygel-music-item.c"
		GUPnPDIDLLiteContributor* contributor = NULL;
		GUPnPDIDLLiteObject* _tmp7_ = NULL;
		GUPnPDIDLLiteContributor* _tmp8_ = NULL;
		GUPnPDIDLLiteContributor* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp7_ = didl_item;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp8_ = gupnp_didl_lite_object_add_artist (_tmp7_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		contributor = _tmp8_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = contributor;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp10_ = self->priv->_artist;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_contributor_set_name (_tmp9_, _tmp10_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (contributor);
#line 867 "rygel-music-item.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp11_ = self->priv->_track_number;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp11_ >= 0) {
#line 873 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp12_ = didl_item;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp13_ = self->priv->_track_number;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_track_number (_tmp12_, _tmp13_);
#line 882 "rygel-music-item.c"
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp15_ = self->priv->_album;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp15_ != NULL) {
#line 888 "rygel-music-item.c"
		const gchar* _tmp16_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp16_ = self->priv->_album;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
#line 894 "rygel-music-item.c"
	} else {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = FALSE;
#line 898 "rygel-music-item.c"
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp17_ = _tmp14_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp17_) {
#line 904 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp18_ = didl_item;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp19_ = self->priv->_album;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album (_tmp18_, _tmp19_);
#line 913 "rygel-music-item.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp21_ = self->priv->_genre;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp21_ != NULL) {
#line 919 "rygel-music-item.c"
		const gchar* _tmp22_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp22_ = self->priv->_genre;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp20_ = g_strcmp0 (_tmp22_, "") != 0;
#line 925 "rygel-music-item.c"
	} else {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp20_ = FALSE;
#line 929 "rygel-music-item.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp23_ = _tmp20_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp23_) {
#line 935 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp24_ = didl_item;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp25_ = self->priv->_genre;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_genre (_tmp24_, _tmp25_);
#line 944 "rygel-music-item.c"
	}
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp26_ = didl_item;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp27_ = gupnp_didl_lite_object_get_album_art (_tmp26_);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp28_ = _tmp27_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp28_ != NULL) {
#line 954 "rygel-music-item.c"
		gchar* _tmp29_ = NULL;
		GRegex* _tmp30_ = NULL;
		GUPnPDIDLLiteObject* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		RygelHTTPServer* _tmp34_ = NULL;
		GUPnPContext* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GUPnPDIDLLiteObject* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp30_ = rygel_media_item_address_regex;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp31_ = didl_item;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp32_ = gupnp_didl_lite_object_get_album_art (_tmp31_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp33_ = _tmp32_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp34_ = http_server;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp35_ = _tmp34_->context;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp36_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp35_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp37_ = _tmp36_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp38_ = g_regex_replace_literal (_tmp30_, _tmp33_, (gssize) (-1), 0, _tmp37_, 0, &_inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp29_ = _tmp38_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_inner_error_ != NULL) {
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			g_propagate_error (error, _inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_g_object_unref0 (didl_item);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			return NULL;
#line 995 "rygel-music-item.c"
		}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp39_ = didl_item;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp40_ = _tmp29_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album_art (_tmp39_, _tmp40_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (_tmp40_);
#line 1005 "rygel-music-item.c"
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = didl_item;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1011 "rygel-music-item.c"
}


static void rygel_music_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelMusicItem * self;
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (server != NULL);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = server;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = didl_item;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_music_item_parent_class)->add_proxy_resources ((RygelMediaItem*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_inner_error_ != NULL) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 1044 "rygel-music-item.c"
	}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp5_ = _tmp4_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!_tmp5_) {
#line 1052 "rygel-music-item.c"
		RygelThumbnail* _tmp6_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = self->priv->_album_art;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 1058 "rygel-music-item.c"
	} else {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = FALSE;
#line 1062 "rygel-music-item.c"
	}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp7_ = _tmp3_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp7_) {
#line 1068 "rygel-music-item.c"
		RygelHTTPServer* _tmp8_ = NULL;
		RygelThumbnail* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp8_ = server;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = self->priv->_album_art;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp10_ = ((RygelIconInfo*) _tmp9_)->uri;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp11_ = rygel_http_server_need_proxy (_tmp8_, _tmp10_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp2_ = _tmp11_;
#line 1083 "rygel-music-item.c"
	} else {
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp2_ = FALSE;
#line 1087 "rygel-music-item.c"
	}
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp12_ = _tmp2_;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp12_) {
#line 1093 "rygel-music-item.c"
		GUPnPDIDLLiteItem* _tmp13_ = NULL;
		RygelHTTPServer* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp13_ = didl_item;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = server;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp15_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp14_, (RygelMediaItem*) self, 0, -1, NULL, NULL);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp16_ = _tmp15_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_album_art ((GUPnPDIDLLiteObject*) _tmp13_, _tmp16_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (_tmp16_);
#line 1110 "rygel-music-item.c"
	}
}


static gchar* rygel_music_item_get_first (RygelMusicItem* self, GList* contributors) {
	gchar* result = NULL;
	GList* _tmp0_ = NULL;
	gchar* _tmp6_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = contributors;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp0_ != NULL) {
#line 1125 "rygel-music-item.c"
		GList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp1_ = contributors;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp2_ = _tmp1_->data;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp2_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = _tmp3_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		result = _tmp5_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return result;
#line 1145 "rygel-music-item.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = g_strdup ("");
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp6_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1153 "rygel-music-item.c"
}


const gchar* rygel_music_item_get_artist (RygelMusicItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_artist;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1168 "rygel-music-item.c"
}


void rygel_music_item_set_artist (RygelMusicItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_artist);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_artist = _tmp1_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "artist");
#line 1187 "rygel-music-item.c"
}


const gchar* rygel_music_item_get_album (RygelMusicItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_album;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1202 "rygel-music-item.c"
}


void rygel_music_item_set_album (RygelMusicItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_album);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_album = _tmp1_;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "album");
#line 1221 "rygel-music-item.c"
}


const gchar* rygel_music_item_get_genre (RygelMusicItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_genre;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1236 "rygel-music-item.c"
}


void rygel_music_item_set_genre (RygelMusicItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_genre);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_genre = _tmp1_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "genre");
#line 1255 "rygel-music-item.c"
}


gint rygel_music_item_get_track_number (RygelMusicItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_track_number;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1270 "rygel-music-item.c"
}


void rygel_music_item_set_track_number (RygelMusicItem* self, gint value) {
	gint _tmp0_ = 0;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_track_number = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "track-number");
#line 1284 "rygel-music-item.c"
}


RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self) {
	RygelThumbnail* result;
	RygelThumbnail* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_album_art;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 1299 "rygel-music-item.c"
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self ? rygel_icon_info_ref (self) : NULL;
#line 1306 "rygel-music-item.c"
}


void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = _rygel_icon_info_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_rygel_icon_info_unref0 (self->priv->_album_art);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_album_art = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "album-art");
#line 1325 "rygel-music-item.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_type_class_add_private (klass, sizeof (RygelMusicItemPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_music_item_real_add_resources;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_music_item_real_compare_by_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->apply_didl_lite = rygel_music_item_real_apply_didl_lite;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_music_item_real_serialize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_music_item_real_add_proxy_resources;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_music_item_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_music_item_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ARTIST, g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ALBUM, g_param_spec_string ("album", "album", "album", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_GENRE, g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_TRACK_NUMBER, g_param_spec_int ("track-number", "track-number", "track-number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ALBUM_ART, rygel_param_spec_icon_info ("album-art", "album-art", "album-art", RYGEL_TYPE_THUMBNAIL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1360 "rygel-music-item.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv = RYGEL_MUSIC_ITEM_GET_PRIVATE (self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_track_number = -1;
#line 1369 "rygel-music-item.c"
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_artist);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_album);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_free0 (self->priv->_genre);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_rygel_icon_info_unref0 (self->priv->_album_art);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 1387 "rygel-music-item.c"
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ARTIST:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_value_set_string (value, rygel_music_item_get_artist (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_value_set_string (value, rygel_music_item_get_album (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_GENRE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_value_set_string (value, rygel_music_item_get_genre (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_value_set_int (value, rygel_music_item_get_track_number (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_value_set_icon_info (value, rygel_music_item_get_album_art (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 1441 "rygel-music-item.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 1447 "rygel-music-item.c"
	}
}


static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ARTIST:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_artist (self, g_value_get_string (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_album (self, g_value_get_string (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_GENRE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_genre (self, g_value_get_string (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_track_number (self, g_value_get_int (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_album_art (self, rygel_value_get_icon_info (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 1487 "rygel-music-item.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 1493 "rygel-music-item.c"
	}
}



