/* rygel-media-server.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-server.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define TYPE_PLUGIN (plugin_get_type ())
#define PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN, Plugin))
#define PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN, PluginClass))
#define IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN))
#define IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN))
#define PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN, PluginClass))

typedef struct _Plugin Plugin;
typedef struct _PluginClass PluginClass;
typedef struct _PluginPrivate PluginPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_SERVER (rygel_media_server_get_type ())
#define RYGEL_MEDIA_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServer))
#define RYGEL_MEDIA_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServerClass))
#define RYGEL_IS_MEDIA_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER))
#define RYGEL_IS_MEDIA_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER))
#define RYGEL_MEDIA_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServerClass))

typedef struct _RygelMediaServer RygelMediaServer;
typedef struct _RygelMediaServerClass RygelMediaServerClass;
typedef struct _RygelMediaServerPrivate RygelMediaServerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
};

struct _Plugin {
	RygelMediaServerPlugin parent_instance;
	PluginPrivate * priv;
};

struct _PluginClass {
	RygelMediaServerPluginClass parent_class;
};

struct _RygelMediaServer {
	RygelMediaDevice parent_instance;
	RygelMediaServerPrivate * priv;
};

struct _RygelMediaServerClass {
	RygelMediaDeviceClass parent_class;
};

struct _RygelMediaServerPrivate {
	RygelMediaContainer* _root_container;
};


static gpointer plugin_parent_class = NULL;
static gpointer rygel_media_server_parent_class = NULL;

GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GType plugin_get_type (void) G_GNUC_CONST;
enum  {
	PLUGIN_DUMMY_PROPERTY
};
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
Plugin* plugin_new (RygelMediaContainer* root_container, RygelPluginCapabilities capabilities);
Plugin* plugin_construct (GType object_type, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities);
RygelMediaServerPlugin* rygel_media_server_plugin_construct (GType object_type, RygelMediaContainer* root_container, const gchar* name, const gchar* description, RygelPluginCapabilities capabilities);
GType rygel_media_server_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServerPrivate))
enum  {
	RYGEL_MEDIA_SERVER_DUMMY_PROPERTY,
	RYGEL_MEDIA_SERVER_ROOT_CONTAINER
};
RygelMediaServer* rygel_media_server_new (const gchar* title, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities);
RygelMediaServer* rygel_media_server_construct (GType object_type, const gchar* title, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities);
static void rygel_media_server_real_constructed (GObject* base);
static RygelMediaContainer* rygel_media_server_get_root_container (RygelMediaServer* self);
static void rygel_media_server_set_root_container (RygelMediaServer* self, RygelMediaContainer* value);
static void rygel_media_server_finalize (GObject* obj);
static void _vala_rygel_media_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


Plugin* plugin_construct (GType object_type, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities) {
	Plugin * self = NULL;
	RygelMediaContainer* _tmp0_ = NULL;
	RygelPluginCapabilities _tmp1_ = 0;
#line 23 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_return_val_if_fail (root_container != NULL, NULL);
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp0_ = root_container;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp1_ = capabilities;
#line 25 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self = (Plugin*) rygel_media_server_plugin_construct (object_type, _tmp0_, "LibRygelServer", NULL, _tmp1_);
#line 23 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	return self;
#line 162 "rygel-media-server.c"
}


Plugin* plugin_new (RygelMediaContainer* root_container, RygelPluginCapabilities capabilities) {
#line 23 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	return plugin_construct (TYPE_PLUGIN, root_container, capabilities);
#line 169 "rygel-media-server.c"
}


static void plugin_class_init (PluginClass * klass) {
#line 22 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	plugin_parent_class = g_type_class_peek_parent (klass);
#line 176 "rygel-media-server.c"
}


static void plugin_instance_init (Plugin * self) {
}


GType plugin_get_type (void) {
	static volatile gsize plugin_type_id__volatile = 0;
	if (g_once_init_enter (&plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Plugin), 0, (GInstanceInitFunc) plugin_instance_init, NULL };
		GType plugin_type_id;
		plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_SERVER_PLUGIN, "Plugin", &g_define_type_info, 0);
		g_once_init_leave (&plugin_type_id__volatile, plugin_type_id);
	}
	return plugin_type_id__volatile;
}


/**
     * Create a MediaServer to serve the media in the RygelMediaContainer.
     * For instance, you might use a RygelSimpleContainer. Alternatively,
     * you might use your own RygelMediaContainer implementation.
     *
     * Assuming that the RygelMediaContainer is correctly implemented,
     * the RygelMediaServer will respond appropriately to changes in the
     * RygelMediaContainer. 
     */
RygelMediaServer* rygel_media_server_construct (GType object_type, const gchar* title, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities) {
	RygelMediaServer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelPluginCapabilities _tmp2_ = 0;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_return_val_if_fail (root_container != NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp0_ = title;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp1_ = root_container;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp2_ = capabilities;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self = (RygelMediaServer*) g_object_new (object_type, "title", _tmp0_, "root-container", _tmp1_, "capabilities", _tmp2_, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	return self;
#line 224 "rygel-media-server.c"
}


RygelMediaServer* rygel_media_server_new (const gchar* title, RygelMediaContainer* root_container, RygelPluginCapabilities capabilities) {
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	return rygel_media_server_construct (RYGEL_TYPE_MEDIA_SERVER, title, root_container, capabilities);
#line 231 "rygel-media-server.c"
}


static void rygel_media_server_real_constructed (GObject* base) {
	RygelMediaServer * self;
	RygelPlugin* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	RygelPlugin* _tmp7_ = NULL;
	RygelPlugin* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self = (RygelMediaServer*) base;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (rygel_media_server_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice));
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp0_ = rygel_media_device_get_plugin ((RygelMediaDevice*) self);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp1_ = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	if (_tmp1_ == NULL) {
#line 253 "rygel-media-server.c"
		RygelMediaContainer* _tmp2_ = NULL;
		RygelPluginCapabilities _tmp3_ = 0;
		RygelPluginCapabilities _tmp4_ = 0;
		Plugin* _tmp5_ = NULL;
		Plugin* _tmp6_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_tmp2_ = self->priv->_root_container;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_tmp3_ = rygel_media_device_get_capabilities ((RygelMediaDevice*) self);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_tmp4_ = _tmp3_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_tmp5_ = plugin_new (_tmp2_, _tmp4_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_tmp6_ = _tmp5_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		rygel_media_device_set_plugin ((RygelMediaDevice*) self, (RygelPlugin*) _tmp6_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		_g_object_unref0 (_tmp6_);
#line 273 "rygel-media-server.c"
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp7_ = rygel_media_device_get_plugin ((RygelMediaDevice*) self);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp8_ = _tmp7_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp9_ = rygel_media_device_get_title ((RygelMediaDevice*) self);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp10_ = _tmp9_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	rygel_plugin_set_title (_tmp8_, _tmp10_);
#line 285 "rygel-media-server.c"
}


static RygelMediaContainer* rygel_media_server_get_root_container (RygelMediaServer* self) {
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp0_ = self->priv->_root_container;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	result = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	return result;
#line 300 "rygel-media-server.c"
}


static void rygel_media_server_set_root_container (RygelMediaServer* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	_tmp0_ = value;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self->priv->_root_container = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_object_notify ((GObject *) self, "root-container");
#line 314 "rygel-media-server.c"
}


static void rygel_media_server_class_init (RygelMediaServerClass * klass) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	rygel_media_server_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaServerPrivate));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_media_server_real_constructed;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_server_get_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_server_set_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_server_finalize;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_SERVER_ROOT_CONTAINER, g_param_spec_object ("root-container", "root-container", "root-container", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 333 "rygel-media-server.c"
}


static void rygel_media_server_instance_init (RygelMediaServer * self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self->priv = RYGEL_MEDIA_SERVER_GET_PRIVATE (self);
#line 340 "rygel-media-server.c"
}


static void rygel_media_server_finalize (GObject* obj) {
	RygelMediaServer * self;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_SERVER, RygelMediaServer);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	G_OBJECT_CLASS (rygel_media_server_parent_class)->finalize (obj);
#line 350 "rygel-media-server.c"
}


/**
 * This class may be used to implement in-process UPnP-AV media servers.
 *
 * Call rygel_media_device_add_interface() on the RygelMediaServer to allow it
 * to serve media via that network interface.
 *
 * See the
 * <link linkend="implementing-servers">Implementing Servers</link> section.
 */
GType rygel_media_server_get_type (void) {
	static volatile gsize rygel_media_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaServer), 0, (GInstanceInitFunc) rygel_media_server_instance_init, NULL };
		GType rygel_media_server_type_id;
		rygel_media_server_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_DEVICE, "RygelMediaServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_server_type_id__volatile, rygel_media_server_type_id);
	}
	return rygel_media_server_type_id__volatile;
}


static void _vala_rygel_media_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER, RygelMediaServer);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		case RYGEL_MEDIA_SERVER_ROOT_CONTAINER:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		g_value_set_object (value, rygel_media_server_get_root_container (self));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		break;
#line 386 "rygel-media-server.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		break;
#line 392 "rygel-media-server.c"
	}
}


static void _vala_rygel_media_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_SERVER, RygelMediaServer);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		case RYGEL_MEDIA_SERVER_ROOT_CONTAINER:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		rygel_media_server_set_root_container (self, g_value_get_object (value));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		break;
#line 408 "rygel-media-server.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-media-server.vala"
		break;
#line 414 "rygel-media-server.c"
	}
}



