/* rygel-http-time-seek.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-time-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};


static gpointer rygel_http_time_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
glong rygel_audio_item_get_duration (RygelAudioItem* self);
static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value);
static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 337 "rygel-http-time-seek.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 345 "rygel-http-time-seek.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 357 "rygel-http-time-seek.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 382 "rygel-http-time-seek.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 388 "rygel-http-time-seek.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 392 "rygel-http-time-seek.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 398 "rygel-http-time-seek.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 410 "rygel-http-time-seek.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 420 "rygel-http-time-seek.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 426 "rygel-http-time-seek.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 440 "rygel-http-time-seek.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 450 "rygel-http-time-seek.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 456 "rygel-http-time-seek.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 465 "rygel-http-time-seek.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 485 "rygel-http-time-seek.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 898 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 899 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 901 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 512 "rygel-http-time-seek.c"
		gchar* _tmp4_ = NULL;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 902 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 520 "rygel-http-time-seek.c"
	} else {
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 904 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 526 "rygel-http-time-seek.c"
	}
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPTimeSeek * self = NULL;
	gchar* range = NULL;
	gchar** range_tokens = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gint64 duration = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	glong _tmp2_ = 0L;
	glong _tmp3_ = 0L;
	gint64 stop = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 parsed_value = 0LL;
	gboolean parsing_start = FALSE;
	RygelHTTPGet* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	SoupMessageHeaders* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	RygelHTTPGet* _tmp56_ = NULL;
	SoupMessage* _tmp57_ = NULL;
	gint64 _tmp58_ = 0LL;
	gint64 _tmp59_ = 0LL;
	gint64 _tmp60_ = 0LL;
	GError * _inner_error_ = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	start = (gint64) 0;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp0_ = request;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->object;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp2_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp1_) : NULL);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp3_ = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	duration = (gint64) (_tmp3_ * G_TIME_SPAN_SECOND);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp4_ = duration;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	stop = _tmp4_ - G_TIME_SPAN_MILLISECOND;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	parsed_value = (gint64) 0;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	parsing_start = TRUE;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp5_ = request;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->msg;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp7_ = _tmp6_->request_headers;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp8_ = soup_message_headers_get_one (_tmp7_, "TimeSeekRange.dlna.org");
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	range = _tmp9_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp10_ = range;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp10_ != NULL) {
#line 599 "rygel-http-time-seek.c"
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gchar** _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gchar** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gint64 _tmp51_ = 0LL;
		gint64 _tmp52_ = 0LL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp11_ = range;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp12_ = g_str_has_prefix (_tmp11_, "npt=");
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (!_tmp12_) {
#line 624 "rygel-http-time-seek.c"
			const gchar* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp13_ = range;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp14_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, "Invalid Range '%s'", _tmp13_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_inner_error_ = _tmp14_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 645 "rygel-http-time-seek.c"
			} else {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 657 "rygel-http-time-seek.c"
			}
		}
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp15_ = range;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp16_ = string_substring (_tmp15_, (glong) 4, (glong) (-1));
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp17_ = _tmp16_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "-", 2);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		range_tokens = _tmp19_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		range_tokens_length1 = _vala_array_length (_tmp18_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_range_tokens_size_ = range_tokens_length1;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_g_free0 (_tmp17_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp22_ = range_tokens;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp22__length1 = range_tokens_length1;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp23_ = _tmp22_[0];
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_tmp23_ == NULL) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp21_ = TRUE;
#line 688 "rygel-http-time-seek.c"
		} else {
			gchar** _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			const gchar* _tmp25_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp24_ = range_tokens;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp24__length1 = range_tokens_length1;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp25_ = _tmp24_[0];
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp21_ = g_strcmp0 (_tmp25_, "") == 0;
#line 701 "rygel-http-time-seek.c"
		}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp26_ = _tmp21_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_tmp26_) {
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp20_ = TRUE;
#line 709 "rygel-http-time-seek.c"
		} else {
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			const gchar* _tmp28_ = NULL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp27_ = range_tokens;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp27__length1 = range_tokens_length1;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp28_ = _tmp27_[1];
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp20_ = _tmp28_ == NULL;
#line 722 "rygel-http-time-seek.c"
		}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp29_ = _tmp20_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_tmp29_) {
#line 728 "rygel-http-time-seek.c"
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			GError* _tmp32_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp30_ = _ ("Invalid Range '%s'");
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp31_ = range;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp32_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp30_, _tmp31_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_inner_error_ = _tmp32_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 752 "rygel-http-time-seek.c"
			} else {
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 764 "rygel-http-time-seek.c"
			}
		}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp33_ = range_tokens;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp33__length1 = range_tokens_length1;
#line 771 "rygel-http-time-seek.c"
		{
			gchar** range_token_collection = NULL;
			gint range_token_collection_length1 = 0;
			gint _range_token_collection_size_ = 0;
			gint range_token_it = 0;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			range_token_collection = _tmp33_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			range_token_collection_length1 = _tmp33__length1;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			for (range_token_it = 0; range_token_it < _tmp33__length1; range_token_it = range_token_it + 1) {
#line 783 "rygel-http-time-seek.c"
				gchar* _tmp34_ = NULL;
				gchar* range_token = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp34_ = g_strdup (range_token_collection[range_token_it]);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_token = _tmp34_;
#line 790 "rygel-http-time-seek.c"
				{
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gboolean _tmp48_ = FALSE;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp35_ = range_token;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					if (g_strcmp0 (_tmp35_, "") == 0) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_g_free0 (range_token);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						continue;
#line 804 "rygel-http-time-seek.c"
					}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp36_ = range_token;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp37_ = string_index_of (_tmp36_, ":", 0);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					if (_tmp37_ == (-1)) {
#line 812 "rygel-http-time-seek.c"
						const gchar* _tmp38_ = NULL;
						gboolean _tmp39_ = FALSE;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp38_ = range_token;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp39_ = rygel_http_time_seek_parse_seconds (_tmp38_, &parsed_value);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						if (!_tmp39_) {
#line 821 "rygel-http-time-seek.c"
							const gchar* _tmp40_ = NULL;
							const gchar* _tmp41_ = NULL;
							GError* _tmp42_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp40_ = _ ("Invalid Range '%s'");
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp41_ = range;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp42_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp40_, _tmp41_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_inner_error_ = _tmp42_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_object_unref0 (self);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								return NULL;
#line 847 "rygel-http-time-seek.c"
							} else {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								return NULL;
#line 861 "rygel-http-time-seek.c"
							}
						}
					} else {
						const gchar* _tmp43_ = NULL;
						gboolean _tmp44_ = FALSE;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp43_ = range_token;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp44_ = rygel_http_time_seek_parse_time (_tmp43_, &parsed_value);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						if (!_tmp44_) {
#line 873 "rygel-http-time-seek.c"
							const gchar* _tmp45_ = NULL;
							const gchar* _tmp46_ = NULL;
							GError* _tmp47_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp45_ = _ ("Invalid Range '%s'");
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp46_ = range;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_tmp47_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp45_, _tmp46_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							_inner_error_ = _tmp47_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
							if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_object_unref0 (self);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								return NULL;
#line 899 "rygel-http-time-seek.c"
							} else {
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range_token);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								_g_free0 (range);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								g_clear_error (&_inner_error_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
								return NULL;
#line 913 "rygel-http-time-seek.c"
							}
						}
					}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp48_ = parsing_start;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					if (_tmp48_) {
#line 921 "rygel-http-time-seek.c"
						gint64 _tmp49_ = 0LL;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						parsing_start = FALSE;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp49_ = parsed_value;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						start = _tmp49_;
#line 929 "rygel-http-time-seek.c"
					} else {
						gint64 _tmp50_ = 0LL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						_tmp50_ = parsed_value;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
						stop = _tmp50_;
#line 936 "rygel-http-time-seek.c"
					}
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_g_free0 (range_token);
#line 940 "rygel-http-time-seek.c"
				}
			}
		}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp51_ = start;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp52_ = stop;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_tmp51_ > _tmp52_) {
#line 950 "rygel-http-time-seek.c"
			const gchar* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			GError* _tmp55_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp53_ = _ ("Invalid Range '%s'");
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp54_ = range;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp55_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp53_, _tmp54_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_inner_error_ = _tmp55_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_propagate_error (error, _inner_error_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_object_unref0 (self);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 974 "rygel-http-time-seek.c"
			} else {
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (range);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				g_clear_error (&_inner_error_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				return NULL;
#line 986 "rygel-http-time-seek.c"
			}
		}
	}
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp56_ = request;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp57_ = ((RygelHTTPRequest*) _tmp56_)->msg;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp58_ = start;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp59_ = stop;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp60_ = duration;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, _tmp57_, _tmp58_, _tmp59_ - 1, (gint64) G_TIME_SPAN_MILLISECOND, _tmp60_, &_inner_error_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_inner_error_ != NULL) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_g_object_unref0 (self);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			return NULL;
#line 1016 "rygel-http-time-seek.c"
		} else {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_g_free0 (range);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			g_clear_error (&_inner_error_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			return NULL;
#line 1028 "rygel-http-time-seek.c"
		}
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_TIME);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return self;
#line 1039 "rygel-http-time-seek.c"
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error) {
#line 27 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, request, error);
#line 1046 "rygel-http-time-seek.c"
}


gboolean rygel_http_time_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	force_seek = FALSE;
#line 1061 "rygel-http-time-seek.c"
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp0_ = request;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		hack = _tmp2_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_inner_error_ != NULL) {
#line 1078 "rygel-http-time-seek.c"
			goto __catch46_g_error;
		}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp3_ = rygel_client_hacks_force_seek (hack);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		force_seek = _tmp3_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_g_object_unref0 (hack);
#line 1087 "rygel-http-time-seek.c"
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* _error_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_error_ = _inner_error_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_inner_error_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_g_error_free0 (_error_);
#line 1099 "rygel-http-time-seek.c"
	}
	__finally46:
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		return FALSE;
#line 1110 "rygel-http-time-seek.c"
	}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp5_ = force_seek;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp5_) {
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp4_ = TRUE;
#line 1118 "rygel-http-time-seek.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		RygelHTTPGet* _tmp8_ = NULL;
		RygelMediaObject* _tmp9_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp30_ = FALSE;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp8_ = request;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp9_ = ((RygelHTTPRequest*) _tmp8_)->object;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 1132 "rygel-http-time-seek.c"
			RygelHTTPGet* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			glong _tmp12_ = 0L;
			glong _tmp13_ = 0L;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp10_ = request;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->object;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp12_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp11_) : NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp13_ = _tmp12_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp7_ = _tmp13_ > ((glong) 0);
#line 1147 "rygel-http-time-seek.c"
		} else {
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp7_ = FALSE;
#line 1151 "rygel-http-time-seek.c"
		}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp14_ = _tmp7_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		if (_tmp14_) {
#line 1157 "rygel-http-time-seek.c"
			gboolean _tmp15_ = FALSE;
			RygelHTTPGet* _tmp16_ = NULL;
			RygelHTTPGetHandler* _tmp17_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp16_ = request;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp17_ = _tmp16_->handler;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp15_ = TRUE;
#line 1170 "rygel-http-time-seek.c"
			} else {
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				RygelHTTPGet* _tmp20_ = NULL;
				RygelThumbnail* _tmp21_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp28_ = FALSE;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp20_ = request;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp21_ = _tmp20_->thumbnail;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				if (_tmp21_ == NULL) {
#line 1184 "rygel-http-time-seek.c"
					RygelHTTPGet* _tmp22_ = NULL;
					RygelSubtitle* _tmp23_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp22_ = request;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp23_ = _tmp22_->subtitle;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp19_ = _tmp23_ == NULL;
#line 1193 "rygel-http-time-seek.c"
				} else {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp19_ = FALSE;
#line 1197 "rygel-http-time-seek.c"
				}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp24_ = _tmp19_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				if (_tmp24_) {
#line 1203 "rygel-http-time-seek.c"
					RygelHTTPGet* _tmp25_ = NULL;
					RygelMediaObject* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp25_ = request;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp26_ = ((RygelHTTPRequest*) _tmp25_)->object;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp27_ = rygel_media_item_is_live_stream (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp26_) : NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp18_ = _tmp27_;
#line 1215 "rygel-http-time-seek.c"
				} else {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp18_ = FALSE;
#line 1219 "rygel-http-time-seek.c"
				}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp28_ = _tmp18_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp15_ = _tmp28_;
#line 1225 "rygel-http-time-seek.c"
			}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp29_ = _tmp15_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp6_ = _tmp29_;
#line 1231 "rygel-http-time-seek.c"
		} else {
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp6_ = FALSE;
#line 1235 "rygel-http-time-seek.c"
		}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp30_ = _tmp6_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp4_ = _tmp30_;
#line 1241 "rygel-http-time-seek.c"
	}
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp31_ = _tmp4_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	result = _tmp31_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return result;
#line 1249 "rygel-http-time-seek.c"
}


gboolean rygel_http_time_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp0_ = request;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "TimeSeekRange.dlna.org");
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	result = _tmp3_ != NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return result;
#line 1273 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPTimeSeek * self;
	gdouble start = 0.0;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gdouble stop = 0.0;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gdouble total = 0.0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* start_str = NULL;
	gchar* _tmp6_ = NULL;
	gint start_str_length1 = 0;
	gint _start_str_size_ = 0;
	gchar* stop_str = NULL;
	gchar* _tmp7_ = NULL;
	gint stop_str_length1 = 0;
	gint _stop_str_size_ = 0;
	gchar* total_str = NULL;
	gchar* _tmp8_ = NULL;
	gint total_str_length1 = 0;
	gint _total_str_size_ = 0;
	gchar* range = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	SoupMessage* _tmp22_ = NULL;
	SoupMessage* _tmp23_ = NULL;
	SoupMessageHeaders* _tmp24_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	self = (RygelHTTPTimeSeek*) base;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp0_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp1_ = _tmp0_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	start = ((gdouble) _tmp1_) / G_TIME_SPAN_SECOND;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp2_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp3_ = _tmp2_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	stop = ((gdouble) _tmp3_) / G_TIME_SPAN_SECOND;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp4_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp5_ = _tmp4_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	total = ((gdouble) _tmp5_) / G_TIME_SPAN_SECOND;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp6_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	start_str = _tmp6_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	start_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_start_str_size_ = start_str_length1;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp7_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	stop_str = _tmp7_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	stop_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_stop_str_size_ = stop_str_length1;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp8_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	total_str = _tmp8_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	total_str_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_total_str_size_ = total_str_length1;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp9_ = g_ascii_formatd (start_str, start_str_length1, "%.3f", start);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp10_ = g_strconcat ("npt=", _tmp9_, NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp11_ = _tmp10_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp13_ = _tmp12_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp14_ = g_ascii_formatd (stop_str, stop_str_length1, "%.3f", stop);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp16_ = _tmp15_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp18_ = _tmp17_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp19_ = g_ascii_formatd (total_str, total_str_length1, "%.3f", total);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp21_ = _tmp20_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (_tmp18_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (_tmp16_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (_tmp13_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (_tmp11_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	range = _tmp21_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp22_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp23_ = _tmp22_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp24_ = _tmp23_->response_headers;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	soup_message_headers_append (_tmp24_, "TimeSeekRange.dlna.org", range);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_g_free0 (range);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	total_str = (g_free (total_str), NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	stop_str = (g_free (stop_str), NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	start_str = (g_free (start_str), NULL);
#line 1413 "rygel-http-time-seek.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1431 "rygel-http-time-seek.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 787 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 788 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1449 "rygel-http-time-seek.c"
}


static gboolean rygel_http_time_seek_parse_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp0_ = range_token;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp2_ = g_ascii_isdigit (_tmp1_);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp2_) {
#line 1468 "rygel-http-time-seek.c"
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp3_ = range_token;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp4_ = double_parse (_tmp3_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
#line 1477 "rygel-http-time-seek.c"
	} else {
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		result = FALSE;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		return result;
#line 1483 "rygel-http-time-seek.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	result = TRUE;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return result;
#line 1489 "rygel-http-time-seek.c"
}


static gboolean rygel_http_time_seek_parse_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint64 _tmp23_ = 0LL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	seconds_sum = (gint64) 0;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_factor = 0;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	seconds_sum = (gint64) 0;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_factor = 3600;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp0_ = range_token;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 3);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_tokens = _tmp2_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_tokens_length1 = _vala_array_length (_tmp1_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_time_tokens_size_ = time_tokens_length1;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp5_ = time_tokens;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp5__length1 = time_tokens_length1;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp6_ = _tmp5_[0];
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp6_ == NULL) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp4_ = TRUE;
#line 1545 "rygel-http-time-seek.c"
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp7_ = time_tokens;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp7__length1 = time_tokens_length1;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp8_ = _tmp7_[1];
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp4_ = _tmp8_ == NULL;
#line 1558 "rygel-http-time-seek.c"
	}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp9_ = _tmp4_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp9_) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp3_ = TRUE;
#line 1566 "rygel-http-time-seek.c"
	} else {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp10_ = time_tokens;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp10__length1 = time_tokens_length1;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp11_ = _tmp10_[2];
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		_tmp3_ = _tmp11_ == NULL;
#line 1579 "rygel-http-time-seek.c"
	}
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp12_ = _tmp3_;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	if (_tmp12_) {
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		result = FALSE;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		return result;
#line 1591 "rygel-http-time-seek.c"
	}
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp13_ = time_tokens;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp13__length1 = time_tokens_length1;
#line 1597 "rygel-http-time-seek.c"
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		time_collection = _tmp13_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		time_collection_length1 = _tmp13__length1;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
		for (time_it = 0; time_it < _tmp13__length1; time_it = time_it + 1) {
#line 1609 "rygel-http-time-seek.c"
			gchar* _tmp14_ = NULL;
			gchar* time = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			_tmp14_ = g_strdup (time_collection[time_it]);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
			time = _tmp14_;
#line 1616 "rygel-http-time-seek.c"
			{
				const gchar* _tmp15_ = NULL;
				gchar _tmp16_ = '\0';
				gboolean _tmp17_ = FALSE;
				gint _tmp22_ = 0;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp15_ = time;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp16_ = string_get (_tmp15_, (glong) 0);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp17_ = g_ascii_isdigit (_tmp16_);
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				if (_tmp17_) {
#line 1630 "rygel-http-time-seek.c"
					gint64 _tmp18_ = 0LL;
					const gchar* _tmp19_ = NULL;
					gdouble _tmp20_ = 0.0;
					gint _tmp21_ = 0;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp18_ = seconds_sum;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp19_ = time;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp20_ = double_parse (_tmp19_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_tmp21_ = time_factor;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					seconds_sum = _tmp18_ + ((gint64) ((_tmp20_ * G_TIME_SPAN_SECOND) * _tmp21_));
#line 1645 "rygel-http-time-seek.c"
				} else {
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					result = FALSE;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					_g_free0 (time);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
					return result;
#line 1655 "rygel-http-time-seek.c"
				}
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_tmp22_ = time_factor;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				time_factor = _tmp22_ / 60;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
				_g_free0 (time);
#line 1663 "rygel-http-time-seek.c"
			}
		}
	}
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	_tmp23_ = seconds_sum;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	*value = _tmp23_;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	result = TRUE;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	return result;
#line 1677 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
#line 26 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek.vala"
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_time_seek_real_add_response_headers;
#line 1686 "rygel-http-time-seek.c"
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



