/* rygel-recursive-module-loader.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-recursive-module-loader.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gmodule.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_RECURSIVE_MODULE_LOADER (rygel_recursive_module_loader_get_type ())
#define RYGEL_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader))
#define RYGEL_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_IS_RECURSIVE_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RECURSIVE_MODULE_LOADER))
#define RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderClass))

typedef struct _RygelRecursiveModuleLoader RygelRecursiveModuleLoader;
typedef struct _RygelRecursiveModuleLoaderClass RygelRecursiveModuleLoaderClass;
typedef struct _RygelRecursiveModuleLoaderPrivate RygelRecursiveModuleLoaderPrivate;

#define RYGEL_TYPE_PLUGIN_INFORMATION (rygel_plugin_information_get_type ())
#define RYGEL_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformation))
#define RYGEL_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))
#define RYGEL_IS_PLUGIN_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_IS_PLUGIN_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_INFORMATION))
#define RYGEL_PLUGIN_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_INFORMATION, RygelPluginInformationClass))

typedef struct _RygelPluginInformation RygelPluginInformation;
typedef struct _RygelPluginInformationClass RygelPluginInformationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelRecursiveModuleLoaderLoadModulesFromFolderData RygelRecursiveModuleLoaderLoadModulesFromFolderData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelRecursiveModuleLoader {
	GObject parent_instance;
	RygelRecursiveModuleLoaderPrivate * priv;
};

struct _RygelRecursiveModuleLoaderClass {
	GObjectClass parent_class;
	gboolean (*load_module_from_file) (RygelRecursiveModuleLoader* self, GFile* file);
	gboolean (*load_module_from_info) (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
};

struct _RygelRecursiveModuleLoaderPrivate {
	gboolean done;
	gchar* _base_path;
};

struct _Block1Data {
	int _ref_count_;
	RygelRecursiveModuleLoader * self;
	GQueue* queue;
};

typedef void (*RygelRecursiveModuleLoaderFolderHandler) (GFile* folder, void* user_data);
struct _RygelRecursiveModuleLoaderLoadModulesFromFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelRecursiveModuleLoader* self;
	GFile* folder;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GList* infos;
	GFileEnumerator* enumerator;
	GFile* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileEnumerator* _tmp5_;
	GFileEnumerator* _tmp6_;
	gint _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	GError* _error_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GList* _tmp16_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp17_;
	GFileInfo* info;
	gboolean _tmp18_;
	GFile* _tmp19_;
	GFileInfo* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError * _inner_error_;
};


static gpointer rygel_recursive_module_loader_parent_class = NULL;

GType rygel_recursive_module_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_information_get_type (void) G_GNUC_CONST;
#define RYGEL_RECURSIVE_MODULE_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoaderPrivate))
enum  {
	RYGEL_RECURSIVE_MODULE_LOADER_DUMMY_PROPERTY,
	RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH
};
#define RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE
RygelRecursiveModuleLoader* rygel_recursive_module_loader_construct (GType object_type, const gchar* path);
static void rygel_recursive_module_loader_real_constructed (GObject* base);
void rygel_recursive_module_loader_load_modules (RygelRecursiveModuleLoader* self);
const gchar* rygel_recursive_module_loader_get_base_path (RygelRecursiveModuleLoader* self);
static gboolean rygel_recursive_module_loader_is_folder (RygelRecursiveModuleLoader* self, GFile* file);
static void rygel_recursive_module_loader_load_modules_from_folder (RygelRecursiveModuleLoader* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_recursive_module_loader_load_modules_from_folder_finish (RygelRecursiveModuleLoader* self, GAsyncResult* _res_);
void rygel_recursive_module_loader_load_modules_sync (RygelRecursiveModuleLoader* self, GCancellable* cancellable);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
static void block1_data_unref (void * _userdata_);
static void rygel_recursive_module_loader_handle_file_info (RygelRecursiveModuleLoader* self, GFile* folder, GFileInfo* info, RygelRecursiveModuleLoaderFolderHandler handler, void* handler_target);
static void _____lambda3_ (Block1Data* _data1_, GFile* subfolder);
static void ______lambda3__rygel_recursive_module_loader_folder_handler (GFile* folder, gpointer self);
gboolean rygel_recursive_module_loader_load_module_from_file (RygelRecursiveModuleLoader* self, GFile* file);
static gboolean rygel_recursive_module_loader_real_load_module_from_file (RygelRecursiveModuleLoader* self, GFile* file);
gboolean rygel_recursive_module_loader_load_module_from_info (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
static gboolean rygel_recursive_module_loader_real_load_module_from_info (RygelRecursiveModuleLoader* self, RygelPluginInformation* info);
static void rygel_recursive_module_loader_load_modules_from_folder_data_free (gpointer _data);
static gboolean rygel_recursive_module_loader_load_modules_from_folder_co (RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_);
static void rygel_recursive_module_loader_load_modules_from_folder_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda2_ (RygelRecursiveModuleLoader* self, GFile* subfolder);
static void _____lambda2__rygel_recursive_module_loader_folder_handler (GFile* folder, gpointer self);
static gboolean rygel_recursive_module_loader_is_folder_eligible (RygelRecursiveModuleLoader* self, GFileInfo* file_info);
RygelPluginInformation* rygel_plugin_information_new_from_file (GFile* file, GError** error);
void rygel_recursive_module_loader_set_base_path (RygelRecursiveModuleLoader* self, const gchar* value);
static void rygel_recursive_module_loader_finalize (GObject* obj);
static void _vala_rygel_recursive_module_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_recursive_module_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a recursive module loader for a given path.
     *
     * Either call load_modules() or load_modules_sync() to start descending
     * into the folder hierarchy and load the modules.
     *
     * @param path base path of the loader.
     */
RygelRecursiveModuleLoader* rygel_recursive_module_loader_construct (GType object_type, const gchar* path) {
	RygelRecursiveModuleLoader * self = NULL;
	const gchar* _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = path;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self = (RygelRecursiveModuleLoader*) g_object_new (object_type, "base-path", _tmp0_, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return self;
#line 191 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_real_constructed (GObject* base) {
	RygelRecursiveModuleLoader * self;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self = (RygelRecursiveModuleLoader*) base;
#line 56 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (rygel_recursive_module_loader_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self->priv->done = FALSE;
#line 203 "rygel-recursive-module-loader.c"
}


/**
     * Walk asynchronously through the tree and load modules.
     */
void rygel_recursive_module_loader_load_modules (RygelRecursiveModuleLoader* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* folder;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	gboolean _tmp7_;
	GFile* _tmp8_;
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = g_module_supported ();
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_vala_assert (_tmp0_, "Module.supported()");
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = self->priv->_base_path;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	folder = _tmp2_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp4_ = folder;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (_tmp4_ != NULL) {
#line 235 "rygel-recursive-module-loader.c"
		GFile* _tmp5_;
		gboolean _tmp6_ = FALSE;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp5_ = folder;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6_ = rygel_recursive_module_loader_is_folder (self, _tmp5_);
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp3_ = _tmp6_;
#line 244 "rygel-recursive-module-loader.c"
	} else {
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp3_ = FALSE;
#line 248 "rygel-recursive-module-loader.c"
	}
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp7_ = _tmp3_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_vala_assert (_tmp7_, "folder != null && this.is_folder (folder)");
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp8_ = folder;
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	rygel_recursive_module_loader_load_modules_from_folder (self, _tmp8_, NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (folder);
#line 260 "rygel-recursive-module-loader.c"
}


/**
     * Walk synchronously through the tree and load modules.
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return _data1_;
#line 272 "rygel-recursive-module-loader.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 279 "rygel-recursive-module-loader.c"
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_queue_free (self);
#line 288 "rygel-recursive-module-loader.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 297 "rygel-recursive-module-loader.c"
		RygelRecursiveModuleLoader * self;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		self = _data1_->self;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		__g_queue_free__g_object_unref0_0 (_data1_->queue);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (self);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_slice_free (Block1Data, _data1_);
#line 307 "rygel-recursive-module-loader.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return self ? g_object_ref (self) : NULL;
#line 315 "rygel-recursive-module-loader.c"
}


static void _____lambda3_ (Block1Data* _data1_, GFile* subfolder) {
	RygelRecursiveModuleLoader * self;
	GQueue* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self = _data1_->self;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (subfolder != NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = _data1_->queue;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = subfolder;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_queue_push_head (_tmp0_, _tmp2_);
#line 336 "rygel-recursive-module-loader.c"
}


static void ______lambda3__rygel_recursive_module_loader_folder_handler (GFile* folder, gpointer self) {
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_____lambda3_ (self, folder);
#line 343 "rygel-recursive-module-loader.c"
}


void rygel_recursive_module_loader_load_modules_sync (RygelRecursiveModuleLoader* self, GCancellable* cancellable) {
	Block1Data* _data1_;
	const gchar* _tmp0_;
	GQueue* _tmp1_;
	GQueue* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data1_->_ref_count_ = 1;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data1_->self = g_object_ref (self);
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = self->priv->_base_path;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_debug ("rygel-recursive-module-loader.vala:78: Searching for modules in folder" \
" '%s'", _tmp0_);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = g_queue_new ();
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data1_->queue = _tmp1_;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = _data1_->queue;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp3_ = self->priv->_base_path;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_queue_push_head (_tmp2_, _tmp4_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	while (TRUE) {
#line 381 "rygel-recursive-module-loader.c"
		GQueue* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		GCancellable* _tmp8_;
		gboolean _tmp11_;
		GQueue* _tmp12_;
		gpointer _tmp13_ = NULL;
		GFile* folder;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp5_ = _data1_->queue;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6_ = g_queue_is_empty (_tmp5_);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (!(!_tmp6_)) {
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			break;
#line 398 "rygel-recursive-module-loader.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp8_ = cancellable;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_tmp8_ != NULL) {
#line 404 "rygel-recursive-module-loader.c"
			GCancellable* _tmp9_;
			gboolean _tmp10_ = FALSE;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp9_ = cancellable;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp10_ = g_cancellable_is_cancelled (_tmp9_);
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp7_ = _tmp10_;
#line 413 "rygel-recursive-module-loader.c"
		} else {
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp7_ = FALSE;
#line 417 "rygel-recursive-module-loader.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp11_ = _tmp7_;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_tmp11_) {
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			break;
#line 425 "rygel-recursive-module-loader.c"
		}
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp12_ = _data1_->queue;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp13_ = g_queue_pop_head (_tmp12_);
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		folder = (GFile*) _tmp13_;
#line 433 "rygel-recursive-module-loader.c"
		{
			GFile* _tmp14_;
			GCancellable* _tmp15_;
			GFileEnumerator* _tmp16_ = NULL;
			GFileEnumerator* enumerator;
			GFileEnumerator* _tmp17_;
			GCancellable* _tmp18_;
			GFileInfo* _tmp19_ = NULL;
			GFileInfo* info;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp14_ = folder;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp15_ = cancellable;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp16_ = g_file_enumerate_children (_tmp14_, RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, _tmp15_, &_inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			enumerator = _tmp16_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			if (_inner_error_ != NULL) {
#line 453 "rygel-recursive-module-loader.c"
				goto __catch32_g_error;
			}
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp17_ = enumerator;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp18_ = cancellable;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp19_ = g_file_enumerator_next_file (_tmp17_, _tmp18_, &_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			info = _tmp19_;
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_object_unref0 (enumerator);
#line 468 "rygel-recursive-module-loader.c"
				goto __catch32_g_error;
			}
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			while (TRUE) {
#line 473 "rygel-recursive-module-loader.c"
				GFileInfo* _tmp20_;
				GFile* _tmp21_;
				GFileInfo* _tmp22_;
				GFileEnumerator* _tmp23_;
				GCancellable* _tmp24_;
				GFileInfo* _tmp25_ = NULL;
				GFileInfo* _tmp26_;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp20_ = info;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				if (!(_tmp20_ != NULL)) {
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					break;
#line 487 "rygel-recursive-module-loader.c"
				}
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp21_ = folder;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp22_ = info;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				rygel_recursive_module_loader_handle_file_info (self, _tmp21_, _tmp22_, ______lambda3__rygel_recursive_module_loader_folder_handler, _data1_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp23_ = enumerator;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp24_ = cancellable;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp25_ = g_file_enumerator_next_file (_tmp23_, _tmp24_, &_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp26_ = _tmp25_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					_g_object_unref0 (info);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					_g_object_unref0 (enumerator);
#line 509 "rygel-recursive-module-loader.c"
					goto __catch32_g_error;
				}
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_object_unref0 (info);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				info = _tmp26_;
#line 516 "rygel-recursive-module-loader.c"
			}
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_g_object_unref0 (info);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_g_object_unref0 (enumerator);
#line 522 "rygel-recursive-module-loader.c"
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError* _error_ = NULL;
			GFile* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			GError* _tmp30_;
			const gchar* _tmp31_;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_error_ = _inner_error_;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_inner_error_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp27_ = folder;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp28_ = g_file_get_path (_tmp27_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp29_ = _tmp28_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp30_ = _error_;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp31_ = _tmp30_->message;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			g_debug ("rygel-recursive-module-loader.vala:102: Failed to enumerate folder %s:" \
" %s", _tmp29_, _tmp31_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_g_free0 (_tmp29_);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_g_error_free0 (_error_);
#line 553 "rygel-recursive-module-loader.c"
		}
		__finally32:
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_g_object_unref0 (folder);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			block1_data_unref (_data1_);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_data1_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			g_clear_error (&_inner_error_);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			return;
#line 570 "rygel-recursive-module-loader.c"
		}
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (folder);
#line 574 "rygel-recursive-module-loader.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	block1_data_unref (_data1_);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data1_ = NULL;
#line 580 "rygel-recursive-module-loader.c"
}


/**
     * Load module from file.
     * @param file File to load the module from
     * @return The implementation should return true if the class should
     * continue to search for modules, false otherwise.
     */
static gboolean rygel_recursive_module_loader_real_load_module_from_file (RygelRecursiveModuleLoader* self, GFile* file) {
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_recursive_module_loader_load_module_from_file'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return FALSE;
#line 595 "rygel-recursive-module-loader.c"
}


gboolean rygel_recursive_module_loader_load_module_from_file (RygelRecursiveModuleLoader* self, GFile* file) {
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS (self)->load_module_from_file (self, file);
#line 604 "rygel-recursive-module-loader.c"
}


static gboolean rygel_recursive_module_loader_real_load_module_from_info (RygelRecursiveModuleLoader* self, RygelPluginInformation* info) {
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_recursive_module_loader_load_module_from_info'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return FALSE;
#line 613 "rygel-recursive-module-loader.c"
}


gboolean rygel_recursive_module_loader_load_module_from_info (RygelRecursiveModuleLoader* self, RygelPluginInformation* info) {
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return RYGEL_RECURSIVE_MODULE_LOADER_GET_CLASS (self)->load_module_from_info (self, info);
#line 622 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_load_modules_from_folder_data_free (gpointer _data) {
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (_data_->folder);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_slice_free (RygelRecursiveModuleLoaderLoadModulesFromFolderData, _data_);
#line 635 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_load_modules_from_folder (RygelRecursiveModuleLoader* self, GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
	RygelRecursiveModuleLoader* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_ = g_slice_new0 (RygelRecursiveModuleLoaderLoadModulesFromFolderData);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_recursive_module_loader_load_modules_from_folder);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_recursive_module_loader_load_modules_from_folder_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = folder;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (_data_->folder);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->folder = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	rygel_recursive_module_loader_load_modules_from_folder_co (_data_);
#line 664 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_load_modules_from_folder_finish (RygelRecursiveModuleLoader* self, GAsyncResult* _res_) {
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 672 "rygel-recursive-module-loader.c"
}


/**
     * Process children of a folder.
     *
     * Recurse into folders or call load_module_from_file() if it looks
     * like a shared library.
     *
     * @param folder the folder
     */
static void rygel_recursive_module_loader_load_modules_from_folder_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_ = _user_data_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_source_object_ = source_object;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_res_ = _res_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	rygel_recursive_module_loader_load_modules_from_folder_co (_data_);
#line 694 "rygel-recursive-module-loader.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_list_free (self);
#line 703 "rygel-recursive-module-loader.c"
}


static void ____lambda2_ (RygelRecursiveModuleLoader* self, GFile* subfolder) {
	GFile* _tmp0_;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (subfolder != NULL);
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = subfolder;
#line 157 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	rygel_recursive_module_loader_load_modules_from_folder (self, _tmp0_, NULL, NULL);
#line 715 "rygel-recursive-module-loader.c"
}


static void _____lambda2__rygel_recursive_module_loader_folder_handler (GFile* folder, gpointer self) {
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	____lambda2_ (self, folder);
#line 722 "rygel-recursive-module-loader.c"
}


static gboolean rygel_recursive_module_loader_load_modules_from_folder_co (RygelRecursiveModuleLoaderLoadModulesFromFolderData* _data_) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	switch (_data_->_state_) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		case 0:
#line 731 "rygel-recursive-module-loader.c"
		goto _state_0;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		case 1:
#line 735 "rygel-recursive-module-loader.c"
		goto _state_1;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		case 2:
#line 739 "rygel-recursive-module-loader.c"
		goto _state_2;
		default:
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_assert_not_reached ();
#line 744 "rygel-recursive-module-loader.c"
	}
	_state_0:
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp0_ = _data_->folder;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp1_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp1_ = g_file_get_path (_data_->_tmp0_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_debug ("rygel-recursive-module-loader.vala:128: Searching for modules in folde" \
"r '%s'.", _data_->_tmp2_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_free0 (_data_->_tmp2_);
#line 759 "rygel-recursive-module-loader.c"
	{
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp3_ = _data_->folder;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_state_ = 1;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_file_enumerate_children_async (_data_->_tmp3_, RYGEL_RECURSIVE_MODULE_LOADER_LOADER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_recursive_module_loader_load_modules_from_folder_ready, _data_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return FALSE;
#line 769 "rygel-recursive-module-loader.c"
		_state_1:
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp4_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp4_ = g_file_enumerate_children_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 779 "rygel-recursive-module-loader.c"
			goto __catch33_g_error;
		}
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->enumerator = _data_->_tmp5_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp6_ = _data_->enumerator;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp7_ = G_MAXINT;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_state_ = 2;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_file_enumerator_next_files_async (_data_->_tmp6_, _data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, rygel_recursive_module_loader_load_modules_from_folder_ready, _data_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return FALSE;
#line 796 "rygel-recursive-module-loader.c"
		_state_2:
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp8_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp8_ = g_file_enumerator_next_files_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 806 "rygel-recursive-module-loader.c"
			goto __catch33_g_error;
		}
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->infos = _data_->_tmp9_;
#line 813 "rygel-recursive-module-loader.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_inner_error_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp10_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp10_ = _ ("Error listing contents of folder '%s': %s");
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp11_ = _data_->folder;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp12_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp12_ = g_file_get_path (_data_->_tmp11_);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp14_ = _data_->_error_;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->_tmp15_ = _data_->_tmp14_->message;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_critical (_data_->_tmp10_, _data_->_tmp13_, _data_->_tmp15_);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_free0 (_data_->_tmp13_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_error_free0 (_data_->_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_data_->_state_ == 0) {
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 852 "rygel-recursive-module-loader.c"
		} else {
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 856 "rygel-recursive-module-loader.c"
		}
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_object_unref (_data_->_async_result);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return FALSE;
#line 862 "rygel-recursive-module-loader.c"
	}
	__finally33:
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (_data_->_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_clear_error (&_data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return FALSE;
#line 877 "rygel-recursive-module-loader.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp16_ = _data_->infos;
#line 881 "rygel-recursive-module-loader.c"
	{
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_data_->info_collection = _data_->_tmp16_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_data_->_tmp17_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_data_->info = _data_->_tmp17_;
#line 891 "rygel-recursive-module-loader.c"
			{
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_data_->_tmp18_ = _data_->self->priv->done;
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				if (_data_->_tmp18_) {
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					_g_object_unref0 (_data_->info);
#line 153 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					break;
#line 901 "rygel-recursive-module-loader.c"
				}
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_data_->_tmp19_ = _data_->folder;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_data_->_tmp20_ = _data_->info;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				rygel_recursive_module_loader_handle_file_info (_data_->self, _data_->_tmp19_, _data_->_tmp20_, _____lambda2__rygel_recursive_module_loader_folder_handler, _data_->self);
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_object_unref0 (_data_->info);
#line 911 "rygel-recursive-module-loader.c"
			}
		}
	}
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp21_ = _data_->folder;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp22_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp22_ = g_file_get_path (_data_->_tmp21_);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_debug ("rygel-recursive-module-loader.vala:161: Finished searching for modules" \
" in folder '%s'", _data_->_tmp23_);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_free0 (_data_->_tmp23_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (_data_->enumerator);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	__g_list_free__g_object_unref0_0 (_data_->infos);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 935 "rygel-recursive-module-loader.c"
	} else {
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 939 "rygel-recursive-module-loader.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return FALSE;
#line 945 "rygel-recursive-module-loader.c"
}


/**
     * Process a file info.
     *
     * Utility method used by sync and async tree walk.
     * @param folder parent folder
     * @param info the FileInfo of the file to process
     * @param handler a call-back if the FileInfo represents a folder.
     */
static void rygel_recursive_module_loader_handle_file_info (RygelRecursiveModuleLoader* self, GFile* folder, GFileInfo* info, RygelRecursiveModuleLoaderFolderHandler handler, void* handler_target) {
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GFileInfo* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (folder != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (info != NULL);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = folder;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = info;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = g_file_info_get_name (_tmp1_);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp3_ = g_file_get_child (_tmp0_, _tmp2_);
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	file = _tmp3_;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp4_ = info;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp5_ = rygel_recursive_module_loader_is_folder_eligible (self, _tmp4_);
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (_tmp5_) {
#line 988 "rygel-recursive-module-loader.c"
		RygelRecursiveModuleLoaderFolderHandler _tmp6_;
		void* _tmp6__target;
		GFile* _tmp7_;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6_ = handler;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6__target = handler_target;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp7_ = file;
#line 179 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6_ (_tmp7_, _tmp6__target);
#line 1000 "rygel-recursive-module-loader.c"
	} else {
		GFileInfo* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp8_ = info;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp9_ = g_file_info_get_name (_tmp8_);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp10_ = g_str_has_suffix (_tmp9_, ".plugin");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_tmp10_) {
#line 1013 "rygel-recursive-module-loader.c"
			{
				GFile* _tmp11_;
				RygelPluginInformation* _tmp12_ = NULL;
				RygelPluginInformation* plugin_info;
				RygelPluginInformation* _tmp13_;
				gboolean _tmp14_ = FALSE;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp11_ = file;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp12_ = rygel_plugin_information_new_from_file (_tmp11_, &_inner_error_);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				plugin_info = _tmp12_;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				if (_inner_error_ != NULL) {
#line 1028 "rygel-recursive-module-loader.c"
					goto __catch34_g_error;
				}
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp13_ = plugin_info;
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp14_ = rygel_recursive_module_loader_load_module_from_info (self, _tmp13_);
#line 184 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				if (!_tmp14_) {
#line 185 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
					self->priv->done = TRUE;
#line 1039 "rygel-recursive-module-loader.c"
				}
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_object_unref0 (plugin_info);
#line 1043 "rygel-recursive-module-loader.c"
			}
			goto __finally34;
			__catch34_g_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp15_ = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_error_ = _inner_error_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_inner_error_ = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp15_ = _ ("Could not load plugin: %s");
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp16_ = _error_;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_tmp17_ = _tmp16_->message;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				g_warning (_tmp15_, _tmp17_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_error_free0 (_error_);
#line 1066 "rygel-recursive-module-loader.c"
			}
			__finally34:
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			if (_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				_g_object_unref0 (file);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				g_clear_error (&_inner_error_);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
				return;
#line 1079 "rygel-recursive-module-loader.c"
			}
		}
	}
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_object_unref0 (file);
#line 1085 "rygel-recursive-module-loader.c"
}


static gboolean rygel_recursive_module_loader_is_folder_eligible (RygelRecursiveModuleLoader* self, GFileInfo* file_info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GFileInfo* _tmp1_;
	GFileType _tmp2_ = 0;
	gboolean _tmp9_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (file_info != NULL, FALSE);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = file_info;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp2_ = g_file_info_get_file_type (_tmp1_);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	if (_tmp2_ == G_FILE_TYPE_DIRECTORY) {
#line 1105 "rygel-recursive-module-loader.c"
		gboolean _tmp3_ = FALSE;
		GFileInfo* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp8_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp4_ = file_info;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp5_ = g_file_info_get_name (_tmp4_);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (g_strcmp0 (_tmp5_, ".libs") == 0) {
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp3_ = TRUE;
#line 1118 "rygel-recursive-module-loader.c"
		} else {
			GFileInfo* _tmp6_;
			gboolean _tmp7_ = FALSE;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp6_ = file_info;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp7_ = g_file_info_get_is_hidden (_tmp6_);
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
			_tmp3_ = !_tmp7_;
#line 1128 "rygel-recursive-module-loader.c"
		}
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp8_ = _tmp3_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp0_ = _tmp8_;
#line 1134 "rygel-recursive-module-loader.c"
	} else {
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp0_ = FALSE;
#line 1138 "rygel-recursive-module-loader.c"
	}
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp9_ = _tmp0_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	result = _tmp9_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return result;
#line 1146 "rygel-recursive-module-loader.c"
}


/**
     * Check if a File is a folder.
     *
     * @param file the File to check
     * @return true, if file is folder, false otherwise.
     */
static gboolean rygel_recursive_module_loader_is_folder (RygelRecursiveModuleLoader* self, GFile* file) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 1163 "rygel-recursive-module-loader.c"
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* file_info;
		gboolean _tmp2_ = FALSE;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp0_ = file;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		file_info = _tmp1_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		if (_inner_error_ != NULL) {
#line 1177 "rygel-recursive-module-loader.c"
			goto __catch35_g_error;
		}
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp2_ = rygel_recursive_module_loader_is_folder_eligible (self, file_info);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		result = _tmp2_;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_object_unref0 (file_info);
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return result;
#line 1188 "rygel-recursive-module-loader.c"
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_error_ = _inner_error_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_inner_error_ = NULL;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp3_ = _ ("Failed to query content type for '%s'");
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp4_ = file;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_tmp6_ = _tmp5_;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_critical (_tmp3_, _tmp6_);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_free0 (_tmp6_);
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		result = FALSE;
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		_g_error_free0 (_error_);
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		return result;
#line 1220 "rygel-recursive-module-loader.c"
	}
	__finally35:
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_clear_error (&_inner_error_);
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return FALSE;
#line 1229 "rygel-recursive-module-loader.c"
}


const gchar* rygel_recursive_module_loader_get_base_path (RygelRecursiveModuleLoader* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = self->priv->_base_path;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	return result;
#line 1244 "rygel-recursive-module-loader.c"
}


void rygel_recursive_module_loader_set_base_path (RygelRecursiveModuleLoader* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_free0 (self->priv->_base_path);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self->priv->_base_path = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_object_notify ((GObject *) self, "base-path");
#line 1263 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_class_init (RygelRecursiveModuleLoaderClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	rygel_recursive_module_loader_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_type_class_add_private (klass, sizeof (RygelRecursiveModuleLoaderPrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_recursive_module_loader_real_constructed;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	RYGEL_RECURSIVE_MODULE_LOADER_CLASS (klass)->load_module_from_file = rygel_recursive_module_loader_real_load_module_from_file;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	RYGEL_RECURSIVE_MODULE_LOADER_CLASS (klass)->load_module_from_info = rygel_recursive_module_loader_real_load_module_from_info;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_recursive_module_loader_get_property;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_recursive_module_loader_set_property;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_recursive_module_loader_finalize;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH, g_param_spec_string ("base-path", "base-path", "base-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1286 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_instance_init (RygelRecursiveModuleLoader * self) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self->priv = RYGEL_RECURSIVE_MODULE_LOADER_GET_PRIVATE (self);
#line 1293 "rygel-recursive-module-loader.c"
}


static void rygel_recursive_module_loader_finalize (GObject* obj) {
	RygelRecursiveModuleLoader * self;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
#line 41 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	_g_free0 (self->priv->_base_path);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	G_OBJECT_CLASS (rygel_recursive_module_loader_parent_class)->finalize (obj);
#line 1305 "rygel-recursive-module-loader.c"
}


/**
 * Recursively walk a folder looking for shared libraries.
 *
 * The folder can either be walked synchronously or asynchronously.
 * Implementing classes need to implement the abstract method
 * load_module_from_file() which is called when the walker encounters a
 * dynamic module file.
 */
GType rygel_recursive_module_loader_get_type (void) {
	static volatile gsize rygel_recursive_module_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_recursive_module_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRecursiveModuleLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_recursive_module_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRecursiveModuleLoader), 0, (GInstanceInitFunc) rygel_recursive_module_loader_instance_init, NULL };
		GType rygel_recursive_module_loader_type_id;
		rygel_recursive_module_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRecursiveModuleLoader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_recursive_module_loader_type_id__volatile, rygel_recursive_module_loader_type_id);
	}
	return rygel_recursive_module_loader_type_id__volatile;
}


static void _vala_rygel_recursive_module_loader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelRecursiveModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		case RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		g_value_set_string (value, rygel_recursive_module_loader_get_base_path (self));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		break;
#line 1340 "rygel-recursive-module-loader.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		break;
#line 1346 "rygel-recursive-module-loader.c"
	}
}


static void _vala_rygel_recursive_module_loader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelRecursiveModuleLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_RECURSIVE_MODULE_LOADER, RygelRecursiveModuleLoader);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		case RYGEL_RECURSIVE_MODULE_LOADER_BASE_PATH:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		rygel_recursive_module_loader_set_base_path (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		break;
#line 1362 "rygel-recursive-module-loader.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-recursive-module-loader.vala"
		break;
#line 1368 "rygel-recursive-module-loader.c"
	}
}



