/* rygel-description-file.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;
typedef struct _RygelDescriptionFilePrivate RygelDescriptionFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDescriptionFile {
	GObject parent_instance;
	RygelDescriptionFilePrivate * priv;
};

struct _RygelDescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelDescriptionFilePrivate {
	gchar** device_elements;
	gint device_elements_length1;
	gint _device_elements_size_;
	GUPnPXMLDoc* doc;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4
} RygelPluginCapabilities;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_description_file_parent_class = NULL;

GType rygel_description_file_get_type (void) G_GNUC_CONST;
#define RYGEL_DESCRIPTION_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFilePrivate))
enum  {
	RYGEL_DESCRIPTION_FILE_DUMMY_PROPERTY
};
#define RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type);
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name);
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element);
static void rygel_description_file_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Constructor to load a description file from disk
     *
     * @param template_file the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error) {
	RygelDescriptionFile * self = NULL;
	const gchar* _tmp0_;
	GUPnPXMLDoc* _tmp1_;
	GUPnPXMLDoc* _tmp2_;
	GError * _inner_error_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (template_file != NULL, NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = template_file;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = gupnp_xml_doc_new_from_path (_tmp0_, &_inner_error_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = _tmp1_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_inner_error_ != NULL) {
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_object_unref0 (self);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return NULL;
#line 281 "rygel-description-file.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp2_;
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 289 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error) {
#line 67 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return rygel_description_file_construct (RYGEL_TYPE_DESCRIPTION_FILE, template_file, error);
#line 296 "rygel-description-file.c"
}


/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self ? g_object_ref (self) : NULL;
#line 308 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_;
	GUPnPXMLDoc* _tmp1_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = doc;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp1_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 330 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc) {
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return rygel_description_file_construct_from_xml_document (RYGEL_TYPE_DESCRIPTION_FILE, doc);
#line 337 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type) {
	const gchar* _tmp0_;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_type != NULL);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = device_type;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "deviceType", _tmp0_, NULL);
#line 359 "rygel-description-file.c"
}


/**
     * Modify the model description.
     *
     * A longer user friendly description of the device.
     *
     * @param model_description is the new model description.
     */
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description) {
	const gchar* _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_description != NULL);
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_description;
#line 100 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelDescription", _tmp0_, NULL);
#line 380 "rygel-description-file.c"
}


/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name) {
	const gchar* _tmp0_;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_name != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_name;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelName", _tmp0_, NULL);
#line 401 "rygel-description-file.c"
}


/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number) {
	const gchar* _tmp0_;
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_number != NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_number;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelNumber", _tmp0_, NULL);
#line 422 "rygel-description-file.c"
}


/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name) {
	const gchar* _tmp0_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (friendly_name != NULL);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = friendly_name;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "friendlyName", _tmp0_, NULL);
#line 444 "rygel-description-file.c"
}


/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self) {
	gchar* result = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* element;
	gchar* _tmp3_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	element = _tmp2_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (element != NULL, "element != null");
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = xmlNodeGetContent (element);
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp3_;
#line 149 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 478 "rygel-description-file.c"
}


/**
     * Set the Unique Device Name of the device.
     *
     * Unique Device Name is the UUID of this particular device instance.
     *
     * @param udn is the Unique Device Name of the device.
     */
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn) {
	const gchar* _tmp0_;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (udn != NULL);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = udn;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "UDN", _tmp0_, NULL);
#line 499 "rygel-description-file.c"
}


/**
     * Get the current UDN of the device.
     *
     * @return The currenly set UDN.
     */
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self) {
	gchar* result = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* element;
	xmlNode* _tmp3_;
	xmlNode* _tmp4_;
	gchar* _tmp5_ = NULL;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "UDN", NULL);
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	element = _tmp2_;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = element;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		result = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return result;
#line 535 "rygel-description-file.c"
	}
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = element;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = xmlNodeGetContent (_tmp4_);
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp5_;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 545 "rygel-description-file.c"
}


/**
     * Set the DLNA caps of this root device and while taking the
     * capabilities of the plugin into account.
     *
     * @param capabilities RygelPluginCapabilities flags
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 562 "rygel-description-file.c"
	}
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 568 "rygel-description-file.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 579 "rygel-description-file.c"
	}
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 585 "rygel-description-file.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 596 "rygel-description-file.c"
	}
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 602 "rygel-description-file.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 613 "rygel-description-file.c"
	}
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 619 "rygel-description-file.c"
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 630 "rygel-description-file.c"
	}
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 636 "rygel-description-file.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 647 "rygel-description-file.c"
	}
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 653 "rygel-description-file.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 664 "rygel-description-file.c"
	}
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 670 "rygel-description-file.c"
}


void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities) {
	gchar** _tmp0_ = NULL;
	gchar** flags;
	gint flags_length1;
	gint _flags_size_;
	RygelPluginCapabilities _tmp1_;
	RygelPluginCapabilities _tmp22_;
	gboolean _tmp27_ = FALSE;
	RygelPluginCapabilities _tmp28_;
	gboolean _tmp30_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GError * _inner_error_ = NULL;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags = _tmp0_;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags_length1 = 0;
#line 187 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_flags_size_ = flags_length1;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = capabilities;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((RYGEL_PLUGIN_CAPABILITIES_UPLOAD & _tmp1_) != 0) {
#line 701 "rygel-description-file.c"
		gboolean allow_upload;
		gboolean allow_delete;
		gboolean _tmp9_;
		gboolean _tmp19_;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		allow_upload = TRUE;
#line 194 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		allow_delete = FALSE;
#line 710 "rygel-description-file.c"
		{
			RygelMetaConfig* _tmp2_ = NULL;
			RygelMetaConfig* config;
			RygelMetaConfig* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_;
			RygelMetaConfig* _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp2_ = rygel_meta_config_get_default ();
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			config = _tmp2_;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp3_ = config;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp4_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp3_, &_inner_error_);
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp5_ = _tmp4_;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_inner_error_ != NULL) {
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_object_unref0 (config);
#line 734 "rygel-description-file.c"
				goto __catch0_g_error;
			}
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			allow_upload = _tmp5_;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp6_ = config;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp7_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp6_, &_inner_error_);
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp8_ = _tmp7_;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_inner_error_ != NULL) {
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_object_unref0 (config);
#line 749 "rygel-description-file.c"
				goto __catch0_g_error;
			}
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			allow_delete = _tmp8_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_g_object_unref0 (config);
#line 756 "rygel-description-file.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_error_ = _inner_error_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_inner_error_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_g_error_free0 (_error_);
#line 768 "rygel-description-file.c"
		}
		__finally0:
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_inner_error_ != NULL) {
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			g_clear_error (&_inner_error_);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			return;
#line 781 "rygel-description-file.c"
		}
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp9_ = allow_upload;
#line 202 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_tmp9_) {
#line 787 "rygel-description-file.c"
			RygelPluginCapabilities _tmp10_;
			RygelPluginCapabilities _tmp13_;
			RygelPluginCapabilities _tmp16_;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp10_ = capabilities;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp10_ & RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) {
#line 795 "rygel-description-file.c"
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11_ = flags;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11__length1 = flags_length1;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp12_ = g_strdup ("image-upload");
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp12_);
#line 807 "rygel-description-file.c"
			}
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp13_ = capabilities;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp13_ & RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) {
#line 813 "rygel-description-file.c"
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar* _tmp15_;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14_ = flags;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14__length1 = flags_length1;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp15_ = g_strdup ("av-upload");
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp15_);
#line 825 "rygel-description-file.c"
			}
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp16_ = capabilities;
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp16_ & RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) {
#line 831 "rygel-description-file.c"
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp17_ = flags;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp17__length1 = flags_length1;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp18_ = g_strdup ("audio-upload");
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp18_);
#line 843 "rygel-description-file.c"
			}
		}
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp19_ = allow_delete;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_tmp19_) {
#line 850 "rygel-description-file.c"
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar* _tmp21_;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp20_ = flags;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp20__length1 = flags_length1;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp21_ = g_strdup ("create-item-with-OCM-destroy-item");
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp21_);
#line 862 "rygel-description-file.c"
		}
	}
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp22_ = capabilities;
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp22_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 869 "rygel-description-file.c"
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gchar* _tmp26_;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp23_ = flags;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp23__length1 = flags_length1;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp24_ = g_strdup ("content-synchronization");
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp24_);
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp25_ = flags;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp25__length1 = flags_length1;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp26_ = g_strdup ("create-child-container");
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp26_);
#line 892 "rygel-description-file.c"
	}
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp28_ = capabilities;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp28_ & RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) == RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) {
#line 898 "rygel-description-file.c"
		RygelPluginCapabilities _tmp29_;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp29_ = capabilities;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp27_ = !((_tmp29_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES);
#line 904 "rygel-description-file.c"
	} else {
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp27_ = FALSE;
#line 908 "rygel-description-file.c"
	}
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp30_ = _tmp27_;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp30_) {
#line 914 "rygel-description-file.c"
		gchar** _tmp31_;
		gint _tmp31__length1;
		gchar* _tmp32_;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp31_ = flags;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp31__length1 = flags_length1;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp32_ = g_strdup ("create-child-container");
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp32_);
#line 926 "rygel-description-file.c"
	}
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp33_ = flags;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp33__length1 = flags_length1;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp33__length1 > 0) {
#line 934 "rygel-description-file.c"
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_ = NULL;
		gchar* content;
		const gchar* _tmp36_;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp34_ = flags;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp34__length1 = flags_length1;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp35_ = g_strjoinv (",", _tmp34_);
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		content = _tmp35_;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp36_ = content;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_set_device_element (self, "X_DLNACAP", _tmp36_, "dlna");
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (content);
#line 954 "rygel-description-file.c"
	} else {
#line 240 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_remove_device_element (self, "X_DLNACAP");
#line 958 "rygel-description-file.c"
	}
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
#line 962 "rygel-description-file.c"
}


void rygel_description_file_clear_service_list (RygelDescriptionFile* self) {
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_remove_device_element (self, "serviceList");
#line 971 "rygel-description-file.c"
}


void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* list;
	xmlNode* _tmp3_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_ = NULL;
	xmlNode* service_node;
	RygelResourceInfo* _tmp7_;
	const gchar* _tmp8_;
	RygelResourceInfo* _tmp9_;
	const gchar* _tmp10_;
	RygelResourceInfo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* url;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RygelResourceInfo* _tmp20_;
	GType _tmp21_;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	RygelResourceInfo* _tmp30_;
	GType _tmp31_;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
#line 248 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 248 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_name != NULL);
#line 248 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (resource_info != NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "serviceList", NULL);
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	list = _tmp2_;
#line 254 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = list;
#line 254 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 1031 "rygel-description-file.c"
		xmlNode* _tmp4_ = NULL;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp4_ = rygel_description_file_set_device_element (self, "serviceList", NULL, NULL);
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		list = _tmp4_;
#line 1037 "rygel-description-file.c"
	}
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = list;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xmlNewChild (_tmp5_, NULL, "service", NULL);
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	service_node = _tmp6_;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = resource_info;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = _tmp7_->upnp_type;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, "serviceType", _tmp8_);
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = resource_info;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = _tmp9_->upnp_id;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, "serviceId", _tmp10_);
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = resource_info;
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = _tmp11_->description_path;
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp13_;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = url;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, "SCPDURL", _tmp14_);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = device_name;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp16_ = g_strconcat ("/Control/", _tmp15_, NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = _tmp16_;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = _tmp18_;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = resource_info;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = _tmp20_->type;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp22_ = g_type_name (_tmp21_);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp23_;
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp19_);
#line 267 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp17_);
#line 268 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp24_ = url;
#line 268 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, "controlURL", _tmp24_);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp25_ = device_name;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp26_ = g_strconcat ("/Event/", _tmp25_, NULL);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp27_ = _tmp26_;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp28_ = g_strconcat (_tmp27_, "/", NULL);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp29_ = _tmp28_;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp30_ = resource_info;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp31_ = _tmp30_->type;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp32_ = g_type_name (_tmp31_);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp33_;
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp29_);
#line 270 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp27_);
#line 271 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp34_ = url;
#line 271 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, "eventSubURL", _tmp34_);
#line 248 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 1131 "rygel-description-file.c"
}


void rygel_description_file_clear_icon_list (RygelDescriptionFile* self) {
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_remove_device_element (self, "iconList");
#line 1140 "rygel-description-file.c"
}


void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlNode* _tmp2_ = NULL;
	xmlNode* list;
	xmlNode* _tmp3_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_ = NULL;
	xmlNode* icon_node;
	RygelIconInfo* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* width;
	RygelIconInfo* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* height;
	RygelIconInfo* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* depth;
	RygelIconInfo* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_name != NULL);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (icon_info != NULL);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (url != NULL);
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "iconList", NULL);
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	list = _tmp2_;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = list;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 1188 "rygel-description-file.c"
		xmlNode* _tmp4_ = NULL;
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp4_ = rygel_description_file_set_device_element (self, "iconList", NULL, NULL);
#line 287 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		list = _tmp4_;
#line 1194 "rygel-description-file.c"
	}
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = list;
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xmlNewChild (_tmp5_, NULL, "icon", NULL);
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	icon_node = _tmp6_;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = icon_info;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = _tmp7_->width;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	width = _tmp9_;
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = icon_info;
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = _tmp10_->height;
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	height = _tmp12_;
#line 294 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = icon_info;
#line 294 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = _tmp13_->depth;
#line 294 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 294 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	depth = _tmp15_;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp16_ = icon_info;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = _tmp16_->mime_type;
#line 296 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, "mimetype", _tmp17_);
#line 297 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, "width", width);
#line 298 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, "height", height);
#line 299 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, "depth", depth);
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = url;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, "url", _tmp18_);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (depth);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (height);
#line 278 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (width);
#line 1248 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	xmlXPathContext* _tmp2_;
	xmlXPathContext* context;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* xpath;
	xmlXPathObject* _tmp5_ = NULL;
	xmlXPathObject* xpath_object;
	xmlXPathObjectType _tmp6_;
	xmlNodeSet* _tmp7_;
	gboolean _tmp8_ = FALSE;
	xmlNodeSet* _tmp9_;
	xmlNode* _tmp10_ = NULL;
	const gchar* _tmp11_;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (old_type != NULL);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (new_type != NULL);
#line 314 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 314 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 314 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = xmlXPathNewContext (_tmp1_);
#line 314 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	context = _tmp2_;
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = old_type;
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = g_strdup_printf (RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, _tmp3_);
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath = _tmp4_;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = xmlXPathEvalExpression (xpath, context);
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath_object = _tmp5_;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (xpath_object != NULL, "xpath_object != null");
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xpath_object->type;
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (_tmp6_ == XPATH_NODESET, "xpath_object->type == XPath.ObjectType.NODESET");
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = xpath_object->nodesetval;
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = xmlXPathNodeSetIsEmpty (_tmp7_);
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (!_tmp8_, "!xpath_object->nodesetval->is_empty ()");
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = xpath_object->nodesetval;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = xmlXPathNodeSetItem (_tmp9_, 0);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = new_type;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNodeSetContent (_tmp10_, _tmp11_);
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlXPathFreeObject (xpath_object);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (xpath);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_xmlXPathFreeContext0 (context);
#line 1327 "rygel-description-file.c"
}


/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1351 "rygel-description-file.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1381 "rygel-description-file.c"
				goto __catch1_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 1390 "rygel-description-file.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1406 "rygel-description-file.c"
				goto __catch1_g_regex_error;
			}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 1417 "rygel-description-file.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1425 "rygel-description-file.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1439 "rygel-description-file.c"
	}
	__finally1:
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return NULL;
#line 1450 "rygel-description-file.c"
	}
}


void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* file;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* message;
	FILE* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gchar* mem;
	gint len;
	GUPnPXMLDoc* _tmp9_;
	xmlDoc* _tmp10_;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	FILE* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (path != NULL);
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = path;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = g_fopen (_tmp0_, "w+");
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	file = _tmp1_;
#line 339 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = _ ("Failed to write modified description to %s");
#line 339 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 339 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	message = _tmp3_;
#line 341 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = file;
#line 341 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = G_UNLIKELY (_tmp4_ == NULL);
#line 341 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp5_) {
#line 1499 "rygel-description-file.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = message;
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = path;
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp6_, _tmp7_);
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp8_;
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 342 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 1519 "rygel-description-file.c"
	}
#line 345 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = NULL;
#line 346 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = -1;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = self->priv->doc;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = _tmp9_->doc;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlDocDumpMemoryEnc (_tmp10_, &_tmp11_, &_tmp12_, "UTF-8");
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = _tmp11_;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = _tmp12_;
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = len;
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = G_UNLIKELY (_tmp13_ <= 0);
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp14_) {
#line 1543 "rygel-description-file.c"
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp15_ = message;
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp16_ = path;
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp17_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp15_, _tmp16_);
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp17_;
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (mem);
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 350 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 1565 "rygel-description-file.c"
	}
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = file;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = mem;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = string_replace (_tmp19_, "\n", "");
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = _tmp20_;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	fputs (_tmp21_, _tmp18_);
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp21_);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (message);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_fclose0 (file);
#line 1585 "rygel-description-file.c"
}


static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element) {
	gint result = 0;
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (element != NULL, 0);
#line 1595 "rygel-description-file.c"
	{
		gint i;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		i = 0;
#line 1600 "rygel-description-file.c"
		{
			gboolean _tmp0_;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp0_ = TRUE;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 1607 "rygel-description-file.c"
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp1_ = _tmp0_;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp1_) {
#line 1621 "rygel-description-file.c"
					gint _tmp2_;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp2_ = i;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					i = _tmp2_ + 1;
#line 1627 "rygel-description-file.c"
				}
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp0_ = FALSE;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp3_ = i;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp4_ = self->priv->device_elements;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp4__length1 = self->priv->device_elements_length1;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp3_ < _tmp4__length1)) {
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 1641 "rygel-description-file.c"
				}
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp5_ = self->priv->device_elements;
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp5__length1 = self->priv->device_elements_length1;
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp6_ = i;
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp8_ = element;
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					result = i;
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					return result;
#line 1659 "rygel-description-file.c"
				}
			}
		}
	}
#line 364 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = -1;
#line 364 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 1668 "rygel-description-file.c"
}


/**
     * Internal helper function to set an element to a new value,
     * creating it if needed.
     *
     * @param element below /root/device to be set.
     * @param new_value is the new content of that element.
     *
     * @returns the element that was modified (or created) or null
     */
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns) {
	xmlNode* result = NULL;
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	const gchar* _tmp2_;
	xmlNode* _tmp3_ = NULL;
	xmlNode* xml_element;
	xmlNode* _tmp4_;
	GUPnPXMLDoc* _tmp8_;
	xmlDoc* _tmp9_;
	xmlNode* _tmp10_ = NULL;
	xmlNode* device_element;
	xmlNs* xml_ns;
	const gchar* _tmp11_;
	xmlNode* _tmp17_;
	xmlNs* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	xmlNode* _tmp21_ = NULL;
	const gchar* _tmp22_;
	gint _tmp23_ = 0;
	gint index;
	gint _tmp24_;
	xmlNode* _tmp47_;
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (element != NULL, NULL);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = element;
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
#line 379 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp3_;
#line 384 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = xml_element;
#line 384 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp4_ != NULL) {
#line 1723 "rygel-description-file.c"
		xmlNode* _tmp5_;
		const gchar* _tmp6_;
		xmlNode* _tmp7_;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp5_ = xml_element;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = new_value;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlNodeSetContent (_tmp5_, _tmp6_);
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = xml_element;
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		result = _tmp7_;
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return result;
#line 1739 "rygel-description-file.c"
	}
#line 390 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = self->priv->doc;
#line 390 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = _tmp8_->doc;
#line 390 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = rygel_xml_utils_get_element ((xmlNode*) _tmp9_, "root", "device", NULL);
#line 390 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	device_element = _tmp10_;
#line 395 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_ns = NULL;
#line 396 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = ns;
#line 396 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp11_ != NULL) {
#line 1755 "rygel-description-file.c"
		GUPnPXMLDoc* _tmp12_;
		xmlDoc* _tmp13_;
		xmlNode* _tmp14_;
		const gchar* _tmp15_;
		xmlNs* _tmp16_ = NULL;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp12_ = self->priv->doc;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp13_ = _tmp12_->doc;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp14_ = device_element;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp15_ = ns;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp16_ = xmlSearchNs (_tmp13_, _tmp14_, _tmp15_);
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xml_ns = _tmp16_;
#line 1773 "rygel-description-file.c"
	}
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = device_element;
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = xml_ns;
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = element;
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = new_value;
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = xmlNewChild (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 400 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp21_;
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp22_ = element;
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp23_ = rygel_description_file_index_of_device_element (self, _tmp22_);
#line 403 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	index = _tmp23_;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp24_ = index;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp24_ > (-1)) {
#line 1797 "rygel-description-file.c"
		xmlNode* sibling;
		xmlNode* _tmp40_;
#line 406 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		sibling = NULL;
#line 1802 "rygel-description-file.c"
		{
			gint _tmp25_;
			gboolean _tmp26_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp25_ = index;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			index = _tmp25_ - 1;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp26_ = TRUE;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 1814 "rygel-description-file.c"
				gboolean _tmp27_;
				gint _tmp29_;
				GUPnPXMLDoc* _tmp30_;
				xmlDoc* _tmp31_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				const gchar* _tmp34_;
				xmlNode* _tmp35_ = NULL;
				xmlNode* _tmp36_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp27_ = _tmp26_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp27_) {
#line 1829 "rygel-description-file.c"
					gint _tmp28_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp28_ = index;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					index = _tmp28_ - 1;
#line 1835 "rygel-description-file.c"
				}
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp26_ = FALSE;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp29_ = index;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp29_ > 0)) {
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 1845 "rygel-description-file.c"
				}
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp30_ = self->priv->doc;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp31_ = _tmp30_->doc;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp32_ = self->priv->device_elements;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp32__length1 = self->priv->device_elements_length1;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp33_ = index;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp34_ = _tmp32_[_tmp33_];
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp35_ = rygel_xml_utils_get_element ((xmlNode*) _tmp31_, "root", "device", _tmp34_, NULL);
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				sibling = _tmp35_;
#line 413 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp36_ = sibling;
#line 413 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (_tmp36_ != NULL) {
#line 1867 "rygel-description-file.c"
					xmlNode* _tmp37_;
					xmlNode* _tmp38_;
					xmlNode* _tmp39_ = NULL;
#line 414 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp37_ = sibling;
#line 414 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp38_ = xml_element;
#line 414 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp39_ = xmlAddNextSibling (_tmp37_, _tmp38_);
#line 414 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					xml_element = _tmp39_;
#line 416 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 1881 "rygel-description-file.c"
				}
			}
		}
#line 420 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp40_ = sibling;
#line 420 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_tmp40_ == NULL) {
#line 1889 "rygel-description-file.c"
			xmlNode* _tmp41_;
			xmlNode* _tmp42_ = NULL;
			xmlNode* _tmp43_;
#line 422 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp41_ = device_element;
#line 422 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp42_ = xmlFirstElementChild (_tmp41_);
#line 422 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			sibling = _tmp42_;
#line 423 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp43_ = sibling;
#line 423 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_tmp43_ != NULL) {
#line 1903 "rygel-description-file.c"
				xmlNode* _tmp44_;
				xmlNode* _tmp45_;
				xmlNode* _tmp46_ = NULL;
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp44_ = sibling;
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp45_ = xml_element;
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp46_ = xmlAddPrevSibling (_tmp44_, _tmp45_);
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xml_element = _tmp46_;
#line 1915 "rygel-description-file.c"
			}
		}
	}
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp47_ = xml_element;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp47_;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 1925 "rygel-description-file.c"
}


/**
     * Internal helper function to remove an element (if it exists).
     *
     * @param element below /root/device to be removed.
     */
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element) {
	GUPnPXMLDoc* _tmp0_;
	xmlDoc* _tmp1_;
	const gchar* _tmp2_;
	xmlNode* _tmp3_ = NULL;
	xmlNode* xml_element;
	xmlNode* _tmp4_;
#line 437 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 437 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (element != NULL);
#line 438 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 438 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 438 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = element;
#line 438 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
#line 438 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp3_;
#line 443 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = xml_element;
#line 443 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp4_ != NULL) {
#line 1959 "rygel-description-file.c"
		xmlNode* _tmp5_;
		xmlNode* _tmp6_;
#line 444 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp5_ = xml_element;
#line 444 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlUnlinkNode (_tmp5_);
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = xml_element;
#line 445 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlFreeNode (_tmp6_);
#line 1970 "rygel-description-file.c"
	}
}


static void rygel_description_file_class_init (RygelDescriptionFileClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_type_class_add_private (klass, sizeof (RygelDescriptionFilePrivate));
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_description_file_finalize;
#line 1982 "rygel-description-file.c"
}


static void rygel_description_file_instance_init (RygelDescriptionFile * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_ = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv = RYGEL_DESCRIPTION_FILE_GET_PRIVATE (self);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = g_strdup ("deviceType");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = g_strdup ("friendlyName");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = g_strdup ("manufacturer");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = g_strdup ("manufacturerURL");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = g_strdup ("modelDescription");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = g_strdup ("modelName");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = g_strdup ("modelNumber");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = g_strdup ("modelURL");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = g_strdup ("serialNumber");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = g_strdup ("UDN");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = g_strdup ("UPC");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = g_strdup ("iconList");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = g_strdup ("serviceList");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = g_strdup ("deviceList");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = g_strdup ("presentationURL");
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = g_new0 (gchar*, 15 + 1);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[0] = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[1] = _tmp1_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[2] = _tmp2_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[3] = _tmp3_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[4] = _tmp4_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[5] = _tmp5_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[6] = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[7] = _tmp7_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[8] = _tmp8_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[9] = _tmp9_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[10] = _tmp10_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[11] = _tmp11_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[12] = _tmp12_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[13] = _tmp13_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[14] = _tmp14_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements = _tmp15_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements_length1 = 15;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->_device_elements_size_ = self->priv->device_elements_length1;
#line 2073 "rygel-description-file.c"
}


static void rygel_description_file_finalize (GObject* obj) {
	RygelDescriptionFile * self;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements = (_vala_array_free (self->priv->device_elements, self->priv->device_elements_length1, (GDestroyNotify) g_free), NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (rygel_description_file_parent_class)->finalize (obj);
#line 2087 "rygel-description-file.c"
}


/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType rygel_description_file_get_type (void) {
	static volatile gsize rygel_description_file_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDescriptionFile), 0, (GInstanceInitFunc) rygel_description_file_instance_init, NULL };
		GType rygel_description_file_type_id;
		rygel_description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDescriptionFile", &g_define_type_info, 0);
		g_once_init_leave (&rygel_description_file_type_id__volatile, rygel_description_file_type_id);
	}
	return rygel_description_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



