/* rygel-xbox-hacks.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdio.h>


#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelXBoxHacks {
	GObject parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	GObjectClass parent_class;
};

struct _RygelXBoxHacksPrivate {
	const gchar* _object_id;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gboolean _tmp7_;
	guint _tmp8_;
	RygelSearchExpression* _tmp9_;
	gboolean _tmp10_;
	RygelSearchExpression* _tmp11_;
	RygelRelationalExpression* _tmp12_;
	RygelRelationalExpression* rel_expression;
	gboolean _tmp13_;
	RygelRelationalExpression* _tmp14_;
	gconstpointer _tmp15_;
	gboolean _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gconstpointer _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GError * _inner_error_;
};


static gpointer rygel_xbox_hacks_parent_class = NULL;
static gchar* rygel_xbox_hacks_AGENT;
static gchar* rygel_xbox_hacks_AGENT = NULL;
static gchar* rygel_xbox_hacks_DMS;
static gchar* rygel_xbox_hacks_DMS = NULL;
static gchar* rygel_xbox_hacks_DMS_V1;
static gchar* rygel_xbox_hacks_DMS_V1 = NULL;
static gchar* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX;
static gchar* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = NULL;
static gchar* rygel_xbox_hacks_MODEL_NAME;
static gchar* rygel_xbox_hacks_MODEL_NAME = NULL;
static gchar* rygel_xbox_hacks_MODEL_VERSION;
static gchar* rygel_xbox_hacks_MODEL_VERSION = NULL;
static gchar* rygel_xbox_hacks_CONTAINER_ID;
static gchar* rygel_xbox_hacks_CONTAINER_ID = NULL;
static gchar* rygel_xbox_hacks_OBJECT_ID;
static gchar* rygel_xbox_hacks_OBJECT_ID = NULL;

GQuark rygel_xbox_hacks_error_quark (void);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_XBOX_HACKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksPrivate))
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY,
	RYGEL_XBOX_HACKS_OBJECT_ID
};
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
static void rygel_xbox_hacks_check_headers (RygelXBoxHacks* self, SoupMessageHeaders* headers, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_new_for_headers (SoupMessageHeaders* headers, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_headers (GType object_type, SoupMessageHeaders* headers, GError** error);
static void rygel_xbox_hacks_set_object_id (RygelXBoxHacks* self, const gchar* value);
gboolean rygel_xbox_hacks_is_album_art_request (RygelXBoxHacks* self, SoupMessage* message);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc);
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_search_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* _data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_xbox_hacks_modify_service_list (RygelXBoxHacks* self, xmlNode* doc_node);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1"
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
const gchar* rygel_xbox_hacks_get_object_id (RygelXBoxHacks* self);
static void rygel_xbox_hacks_finalize (GObject* obj);
static void _vala_rygel_xbox_hacks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_xbox_hacks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_xbox_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_xbox_hacks_error-quark");
}


RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error) {
	RygelXBoxHacks * self = NULL;
	GUPnPServiceAction* _tmp0_;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* _tmp4_;
	SoupMessageHeaders* headers;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = action;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = gupnp_service_action_get_message (_tmp0_);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = _tmp2_->request_headers;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = _tmp3_;
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_tmp2_);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	headers = _tmp4_;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_check_headers (self, headers, &_inner_error_);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_propagate_error (error, _inner_error_);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_g_object_unref0 (self);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return NULL;
#line 435 "rygel-xbox-hacks.c"
		} else {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_clear_error (&_inner_error_);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return NULL;
#line 443 "rygel-xbox-hacks.c"
		}
	}
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return self;
#line 448 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error) {
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct_for_action (RYGEL_TYPE_XBOX_HACKS, action, error);
#line 455 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_construct_for_headers (GType object_type, SoupMessageHeaders* headers, GError** error) {
	RygelXBoxHacks * self = NULL;
	SoupMessageHeaders* _tmp0_;
	GError * _inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_val_if_fail (headers != NULL, NULL);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = headers;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_check_headers (self, _tmp0_, &_inner_error_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_propagate_error (error, _inner_error_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_g_object_unref0 (self);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return NULL;
#line 481 "rygel-xbox-hacks.c"
		} else {
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_clear_error (&_inner_error_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return NULL;
#line 489 "rygel-xbox-hacks.c"
		}
	}
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return self;
#line 494 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_new_for_headers (SoupMessageHeaders* headers, GError** error) {
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct_for_headers (RYGEL_TYPE_XBOX_HACKS, headers, error);
#line 501 "rygel-xbox-hacks.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 521 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_check_headers (RygelXBoxHacks* self, SoupMessageHeaders* headers, GError** error) {
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* agent;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp15_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (headers != NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = headers;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = soup_message_headers_get_one (_tmp0_, "User-Agent");
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	agent = _tmp2_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = agent;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp4_ == NULL) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp3_ = TRUE;
#line 554 "rygel-xbox-hacks.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp14_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp7_ = agent;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp8_ = string_contains (_tmp7_, "Xbox");
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (!_tmp8_) {
#line 568 "rygel-xbox-hacks.c"
			const gchar* _tmp9_;
			gboolean _tmp10_ = FALSE;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp9_ = agent;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp10_ = string_contains (_tmp9_, "Allegro-Software-WebClient");
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_ = !_tmp10_;
#line 577 "rygel-xbox-hacks.c"
		} else {
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_ = FALSE;
#line 581 "rygel-xbox-hacks.c"
		}
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp11_ = _tmp6_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp11_) {
#line 587 "rygel-xbox-hacks.c"
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp12_ = agent;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp13_ = string_contains (_tmp12_, "SEC_HHP_Galaxy S/1.0");
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp5_ = !_tmp13_;
#line 596 "rygel-xbox-hacks.c"
		} else {
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp5_ = FALSE;
#line 600 "rygel-xbox-hacks.c"
		}
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp14_ = _tmp5_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp3_ = _tmp14_;
#line 606 "rygel-xbox-hacks.c"
	}
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp15_ = _tmp3_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp15_) {
#line 612 "rygel-xbox-hacks.c"
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp16_ = _ ("Not Applicable");
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp17_ = g_error_new_literal (RYGEL_XBOX_HACKS_ERROR, RYGEL_XBOX_HACKS_ERROR_NA, _tmp16_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_inner_error_ = _tmp17_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_g_free0 (agent);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return;
#line 629 "rygel-xbox-hacks.c"
		} else {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_g_free0 (agent);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			return;
#line 639 "rygel-xbox-hacks.c"
		}
	}
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp18_ = agent;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp19_ = string_contains (_tmp18_, "Xbox");
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp19_) {
#line 648 "rygel-xbox-hacks.c"
		const gchar* _tmp20_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp20_ = rygel_xbox_hacks_CONTAINER_ID;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		rygel_xbox_hacks_set_object_id (self, _tmp20_);
#line 654 "rygel-xbox-hacks.c"
	} else {
		const gchar* _tmp21_;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp21_ = rygel_xbox_hacks_OBJECT_ID;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		rygel_xbox_hacks_set_object_id (self, _tmp21_);
#line 661 "rygel-xbox-hacks.c"
	}
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_free0 (agent);
#line 665 "rygel-xbox-hacks.c"
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 44 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 45 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 45 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (g_strcmp0 (_tmp0_, "true") == 0) {
#line 46 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = TRUE;
#line 46 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 682 "rygel-xbox-hacks.c"
	} else {
#line 48 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = FALSE;
#line 48 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 688 "rygel-xbox-hacks.c"
	}
}


gboolean rygel_xbox_hacks_is_album_art_request (RygelXBoxHacks* self, SoupMessage* message) {
	gboolean result = FALSE;
	SoupMessage* _tmp0_;
	SoupURI* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* query;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GHashTable* _tmp5_ = NULL;
	GHashTable* params;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* album_art;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp13_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = message;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = soup_message_get_uri (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = _tmp1_->query;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	query = _tmp2_;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = query;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp3_ == NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		result = FALSE;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return result;
#line 730 "rygel-xbox-hacks.c"
	}
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = query;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp5_ = soup_form_decode (_tmp4_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	params = _tmp5_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = params;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp7_ = g_hash_table_lookup (_tmp6_, "albumArt");
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	album_art = _tmp8_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp10_ = album_art;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp10_ != NULL) {
#line 750 "rygel-xbox-hacks.c"
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp11_ = album_art;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp12_ = bool_parse (_tmp11_);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp9_ = _tmp12_;
#line 759 "rygel-xbox-hacks.c"
	} else {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp9_ = FALSE;
#line 763 "rygel-xbox-hacks.c"
	}
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp13_ = _tmp9_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	result = _tmp13_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_free0 (album_art);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_hash_table_unref0 (params);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return result;
#line 775 "rygel-xbox-hacks.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1382 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 788 "rygel-xbox-hacks.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 818 "rygel-xbox-hacks.c"
				goto __catch64_g_regex_error;
			}
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1384 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 827 "rygel-xbox-hacks.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 843 "rygel-xbox-hacks.c"
				goto __catch64_g_regex_error;
			}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
			return NULL;
#line 854 "rygel-xbox-hacks.c"
		}
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1385 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return result;
#line 862 "rygel-xbox-hacks.c"
	}
	goto __finally64;
	__catch64_g_regex_error:
	{
		GError* e = NULL;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1387 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 876 "rygel-xbox-hacks.c"
	}
	__finally64:
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1383 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
		return NULL;
#line 887 "rygel-xbox-hacks.c"
	}
}


void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GUPnPXMLDoc* _tmp5_;
	GUPnPXMLDoc* doc;
	GUPnPXMLDoc* _tmp6_;
	xmlDoc* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* desc_path;
	GUPnPXMLDoc* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GRegex* _tmp13_;
	GRegex* regex;
	RygelRootDevice* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* server_path;
	RygelRootDevice* _tmp17_;
	GUPnPContext* _tmp18_;
	GUPnPContext* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GRegex* _tmp22_;
	GError * _inner_error_ = NULL;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (device != NULL);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (template_path != NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = device;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = rygel_xbox_hacks_DMS;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = g_str_has_prefix (_tmp1_, _tmp2_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (!_tmp3_) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return;
#line 939 "rygel-xbox-hacks.c"
	}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = template_path;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp5_ = gupnp_xml_doc_new_from_path (_tmp4_, &_inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	doc = _tmp5_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return;
#line 953 "rygel-xbox-hacks.c"
	}
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = doc;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp7_ = _tmp6_->doc;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_modify_dms_desc (self, _tmp7_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = template_path;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp9_ = string_replace (_tmp8_, ".xml", "-xbox.xml");
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	desc_path = _tmp9_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp10_ = doc;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp11_ = desc_path;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_save_modified_desc (self, _tmp10_, _tmp11_, &_inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_free0 (desc_path);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_object_unref0 (doc);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return;
#line 983 "rygel-xbox-hacks.c"
	}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp12_ = rygel_xbox_hacks_AGENT;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp13_ = g_regex_new (_tmp12_, G_REGEX_CASELESS, 0, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	regex = _tmp13_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_free0 (desc_path);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_object_unref0 (doc);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return;
#line 1001 "rygel-xbox-hacks.c"
	}
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp14_ = device;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp15_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp14_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp16_ = g_strconcat ("/", _tmp15_, NULL);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	server_path = _tmp16_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp17_ = device;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp18_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp17_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp19_ = _tmp18_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp20_ = desc_path;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp21_ = server_path;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp22_ = regex;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	gupnp_context_host_path_for_agent (_tmp19_, _tmp20_, _tmp21_, _tmp22_);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_free0 (server_path);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_regex_unref0 (regex);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_free0 (desc_path);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (doc);
#line 1033 "rygel-xbox-hacks.c"
}


void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelMediaQueryAction* _tmp2_;
	gboolean _tmp19_;
	gboolean _tmp30_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (action != NULL);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (container_id != NULL);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = action;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (RYGEL_IS_SEARCH (_tmp2_)) {
#line 1053 "rygel-xbox-hacks.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp10_;
		gboolean _tmp12_;
		gboolean _tmp14_;
		gboolean _tmp16_;
		gboolean _tmp18_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp8_ = *container_id;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (g_strcmp0 (_tmp8_, "1") == 0) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp7_ = TRUE;
#line 1071 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp9_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp9_ = *container_id;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "4") == 0;
#line 1078 "rygel-xbox-hacks.c"
		}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp10_ = _tmp7_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp10_) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_ = TRUE;
#line 1086 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp11_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp11_ = *container_id;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_ = g_strcmp0 (_tmp11_, "5") == 0;
#line 1093 "rygel-xbox-hacks.c"
		}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp12_ = _tmp6_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp12_) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp5_ = TRUE;
#line 1101 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp13_;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp13_ = *container_id;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp5_ = g_strcmp0 (_tmp13_, "6") == 0;
#line 1108 "rygel-xbox-hacks.c"
		}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp14_ = _tmp5_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp14_) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp4_ = TRUE;
#line 1116 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp15_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp15_ = *container_id;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp4_ = g_strcmp0 (_tmp15_, "7") == 0;
#line 1123 "rygel-xbox-hacks.c"
		}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp16_ = _tmp4_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp16_) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp3_ = TRUE;
#line 1131 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp17_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp17_ = *container_id;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp3_ = g_strcmp0 (_tmp17_, "F") == 0;
#line 1138 "rygel-xbox-hacks.c"
		}
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp18_ = _tmp3_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp1_ = _tmp18_;
#line 1144 "rygel-xbox-hacks.c"
	} else {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp1_ = FALSE;
#line 1148 "rygel-xbox-hacks.c"
	}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp19_ = _tmp1_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp19_) {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 1156 "rygel-xbox-hacks.c"
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		RygelMediaQueryAction* _tmp23_;
		gboolean _tmp25_;
		gboolean _tmp27_;
		gboolean _tmp29_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp23_ = action;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (RYGEL_IS_BROWSE (_tmp23_)) {
#line 1169 "rygel-xbox-hacks.c"
			const gchar* _tmp24_;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp24_ = *container_id;
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp22_ = g_strcmp0 (_tmp24_, "15") == 0;
#line 1175 "rygel-xbox-hacks.c"
		} else {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp22_ = FALSE;
#line 1179 "rygel-xbox-hacks.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp25_ = _tmp22_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp25_) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp21_ = TRUE;
#line 1187 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp26_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp26_ = *container_id;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp21_ = g_strcmp0 (_tmp26_, "14") == 0;
#line 1194 "rygel-xbox-hacks.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp27_ = _tmp21_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_tmp27_) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp20_ = TRUE;
#line 1202 "rygel-xbox-hacks.c"
		} else {
			const gchar* _tmp28_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp28_ = *container_id;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp20_ = g_strcmp0 (_tmp28_, "16") == 0;
#line 1209 "rygel-xbox-hacks.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp29_ = _tmp20_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp0_ = _tmp29_;
#line 1215 "rygel-xbox-hacks.c"
	}
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp30_ = _tmp0_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp30_) {
#line 1221 "rygel-xbox-hacks.c"
		gchar* _tmp31_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp31_ = g_strdup ("0");
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_free0 (*container_id);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		*container_id = _tmp31_;
#line 1229 "rygel-xbox-hacks.c"
	}
}


void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (item != NULL);
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = item;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = _tmp0_->mime_type;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (g_strcmp0 (_tmp1_, "video/x-msvideo") == 0) {
#line 1247 "rygel-xbox-hacks.c"
		RygelMediaItem* _tmp2_;
		gchar* _tmp3_;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp2_ = item;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp3_ = g_strdup ("video/avi");
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_free0 (_tmp2_->mime_type);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp2_->mime_type = _tmp3_;
#line 1258 "rygel-xbox-hacks.c"
	} else {
		RygelMediaItem* _tmp4_;
		const gchar* _tmp5_;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp4_ = item;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp5_ = _tmp4_->mime_type;
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (g_strcmp0 (_tmp5_, "video/mpeg") == 0) {
#line 1268 "rygel-xbox-hacks.c"
			RygelMediaItem* _tmp6_;
			gchar* _tmp7_;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_ = item;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp7_ = g_strdup ("invalid/content");
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_g_free0 (_tmp6_->mime_type);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp6_->mime_type = _tmp7_;
#line 1279 "rygel-xbox-hacks.c"
		}
	}
}


static void rygel_xbox_hacks_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->container);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_slice_free (RygelXboxHacksSearchData, _data_);
#line 1300 "rygel-xbox-hacks.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return self ? g_object_ref (self) : NULL;
#line 1307 "rygel-xbox-hacks.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 1314 "rygel-xbox-hacks.c"
}


void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
	RygelXBoxHacks* _tmp0_;
	RygelSearchableContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchExpression* _tmp3_;
	RygelSearchExpression* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_search);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_search_data_free);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = container;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->container = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = expression;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = _rygel_search_expression_ref0 (_tmp3_);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->expression = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp5_ = offset;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->offset = _tmp5_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = max_count;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->max_count = _tmp6_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp7_ = cancellable;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->cancellable = _tmp8_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_search_co (_data_);
#line 1367 "rygel-xbox-hacks.c"
}


RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return NULL;
#line 1378 "rygel-xbox-hacks.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (total_matches) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		*total_matches = _data_->total_matches;
#line 1386 "rygel-xbox-hacks.c"
	}
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return result;
#line 1394 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_ = _user_data_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_source_object_ = source_object;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_res_ = _res_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_search_co (_data_);
#line 1408 "rygel-xbox-hacks.c"
}


static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* _data_) {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	switch (_data_->_state_) {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		case 0:
#line 1417 "rygel-xbox-hacks.c"
		goto _state_0;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		case 1:
#line 1421 "rygel-xbox-hacks.c"
		goto _state_1;
		default:
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_assert_not_reached ();
#line 1426 "rygel-xbox-hacks.c"
	}
	_state_0:
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp0_ = _data_->container;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp1_ = _data_->expression;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp2_ = _data_->offset;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp3_ = _data_->max_count;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp5_ = 0U;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_state_ = 1;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_searchable_container_search (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, rygel_xbox_hacks_search_ready, _data_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return FALSE;
#line 1447 "rygel-xbox-hacks.c"
	_state_1:
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp6_ = NULL;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->total_matches = _data_->_tmp5_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->results = _data_->_tmp6_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_data_->_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_error_free (_data_->_inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_data_->_state_ == 0) {
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1467 "rygel-xbox-hacks.c"
		} else {
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1471 "rygel-xbox-hacks.c"
		}
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_object_unref (_data_->_async_result);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return FALSE;
#line 1477 "rygel-xbox-hacks.c"
	}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp8_ = _data_->total_matches;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_data_->_tmp8_ == ((guint) 0)) {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp9_ = _data_->expression;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp7_ = RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp9_);
#line 1487 "rygel-xbox-hacks.c"
	} else {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp7_ = FALSE;
#line 1491 "rygel-xbox-hacks.c"
	}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->_tmp10_ = _data_->_tmp7_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_data_->_tmp10_) {
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp11_ = _data_->expression;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp12_ = _rygel_search_expression_ref0 (RYGEL_IS_RELATIONAL_EXPRESSION (_data_->_tmp11_) ? ((RygelRelationalExpression*) _data_->_tmp11_) : NULL);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->rel_expression = _data_->_tmp12_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp14_ = _data_->rel_expression;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp15_ = ((RygelSearchExpression*) _data_->_tmp14_)->operand1;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp16_ = FALSE;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp16_ = G_LIKELY (((const gchar*) _data_->_tmp15_) != NULL);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_data_->_tmp16_) {
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp17_ = _data_->rel_expression;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp18_ = ((RygelSearchExpression*) _data_->_tmp17_)->operand1;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp13_ = g_strcmp0 ((const gchar*) _data_->_tmp18_, "upnp:class") == 0;
#line 1519 "rygel-xbox-hacks.c"
		} else {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp13_ = FALSE;
#line 1523 "rygel-xbox-hacks.c"
		}
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_data_->_tmp19_ = _data_->_tmp13_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		if (_data_->_tmp19_) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp20_ = gee_collection_get_size ((GeeCollection*) _data_->results);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->_tmp21_ = _data_->_tmp20_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_data_->total_matches = (guint) _data_->_tmp21_;
#line 1535 "rygel-xbox-hacks.c"
		}
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_rygel_search_expression_unref0 (_data_->rel_expression);
#line 1539 "rygel-xbox-hacks.c"
	}
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_data_->result = _data_->results;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_data_->_state_ == 0) {
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1547 "rygel-xbox-hacks.c"
	} else {
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1551 "rygel-xbox-hacks.c"
	}
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_object_unref (_data_->_async_result);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return FALSE;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_g_object_unref0 (_data_->results);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_data_->_state_ == 0) {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1563 "rygel-xbox-hacks.c"
	} else {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1567 "rygel-xbox-hacks.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_object_unref (_data_->_async_result);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return FALSE;
#line 1573 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc) {
	xmlDoc* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	const gchar* _tmp4_;
	xmlDoc* _tmp5_;
	xmlNode* _tmp6_ = NULL;
	xmlNode* _tmp7_;
	xmlNode* _tmp8_;
	const gchar* _tmp9_;
	xmlDoc* _tmp10_;
	xmlNode* _tmp11_ = NULL;
	xmlNode* _tmp12_;
	xmlNode* _tmp13_;
	const gchar* _tmp14_;
	xmlDoc* _tmp15_;
	xmlNode* _tmp16_ = NULL;
	xmlNode* _tmp17_;
	xmlNode* _tmp18_;
	const gchar* _tmp19_;
	xmlDoc* _tmp20_;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = doc;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = rygel_xml_utils_get_element ((xmlNode*) _tmp0_, "root", "device", "deviceType", NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	element = _tmp1_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = element;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_assert (_tmp2_ != NULL);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = element;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = rygel_xbox_hacks_DMS_V1;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	xmlNodeSetContent (_tmp3_, _tmp4_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp5_ = doc;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = rygel_xml_utils_get_element ((xmlNode*) _tmp5_, "root", "device", "modelName", NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	element = _tmp6_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp7_ = element;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_assert (_tmp7_ != NULL);
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = element;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp9_ = rygel_xbox_hacks_MODEL_NAME;
#line 163 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	xmlNodeSetContent (_tmp8_, _tmp9_);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp10_ = doc;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp11_ = rygel_xml_utils_get_element ((xmlNode*) _tmp10_, "root", "device", "modelNumber", NULL);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	element = _tmp11_;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp12_ = element;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_assert (_tmp12_ != NULL);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp13_ = element;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp14_ = rygel_xbox_hacks_MODEL_VERSION;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	xmlNodeSetContent (_tmp13_, _tmp14_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp15_ = doc;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp16_ = rygel_xml_utils_get_element ((xmlNode*) _tmp15_, "root", "device", "friendlyName", NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	element = _tmp16_;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp17_ = element;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_assert (_tmp17_ != NULL);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp18_ = element;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp19_ = rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	xmlNodeAddContent (_tmp18_, _tmp19_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp20_ = doc;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_modify_service_list (self, _tmp20_);
#line 1672 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_modify_service_list (RygelXBoxHacks* self, xmlNode* doc_node) {
	xmlNode* _tmp0_;
	xmlNode* _tmp1_ = NULL;
	xmlNode* element;
	gboolean _tmp2_ = FALSE;
	xmlNode* _tmp3_;
	gboolean _tmp6_;
#line 183 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = doc_node;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = rygel_xml_utils_get_element (_tmp0_, "root", "device", "serviceList", NULL);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	element = _tmp1_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = element;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp3_ != NULL) {
#line 1695 "rygel-xbox-hacks.c"
		xmlNode* _tmp4_;
		xmlNode* _tmp5_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp4_ = element;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp5_ = _tmp4_->children;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp2_ = _tmp5_ != NULL;
#line 1704 "rygel-xbox-hacks.c"
	} else {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp2_ = FALSE;
#line 1708 "rygel-xbox-hacks.c"
	}
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = _tmp2_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_assert (_tmp6_);
#line 1714 "rygel-xbox-hacks.c"
	{
		xmlNode* _tmp7_;
		xmlNode* _tmp8_;
		xmlNode* service_node;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp7_ = element;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp8_ = _tmp7_->children;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		service_node = _tmp8_;
#line 1725 "rygel-xbox-hacks.c"
		{
			gboolean _tmp9_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			_tmp9_ = TRUE;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
			while (TRUE) {
#line 1732 "rygel-xbox-hacks.c"
				gboolean _tmp10_;
				xmlNode* _tmp13_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
				_tmp10_ = _tmp9_;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
				if (!_tmp10_) {
#line 1739 "rygel-xbox-hacks.c"
					xmlNode* _tmp11_;
					xmlNode* _tmp12_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					_tmp11_ = service_node;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					_tmp12_ = _tmp11_->next;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					service_node = _tmp12_;
#line 1748 "rygel-xbox-hacks.c"
				}
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
				_tmp9_ = FALSE;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
				_tmp13_ = service_node;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
				if (!(_tmp13_ != NULL)) {
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					break;
#line 1758 "rygel-xbox-hacks.c"
				}
				{
					xmlNode* _tmp14_;
					xmlNode* _tmp15_;
					xmlNode* type_node;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					_tmp14_ = service_node;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					_tmp15_ = _tmp14_->children;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
					type_node = _tmp15_;
#line 1770 "rygel-xbox-hacks.c"
					{
						gboolean _tmp16_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
						_tmp16_ = TRUE;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
						while (TRUE) {
#line 1777 "rygel-xbox-hacks.c"
							gboolean _tmp17_;
							xmlNode* _tmp20_;
							xmlNode* _tmp21_;
							const gchar* _tmp22_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							_tmp17_ = _tmp16_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							if (!_tmp17_) {
#line 1786 "rygel-xbox-hacks.c"
								xmlNode* _tmp18_;
								xmlNode* _tmp19_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp18_ = type_node;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp19_ = _tmp18_->next;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								type_node = _tmp19_;
#line 1795 "rygel-xbox-hacks.c"
							}
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							_tmp16_ = FALSE;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							_tmp20_ = type_node;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							if (!(_tmp20_ != NULL)) {
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								break;
#line 1805 "rygel-xbox-hacks.c"
							}
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							_tmp21_ = type_node;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							_tmp22_ = _tmp21_->name;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
							if (g_strcmp0 (_tmp22_, "serviceType") == 0) {
#line 1813 "rygel-xbox-hacks.c"
								xmlNode* _tmp23_;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_;
								GQuark _tmp27_ = 0U;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp23_ = type_node;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp24_ = xmlNodeGetContent (_tmp23_);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp25_ = _tmp24_;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								g_free (_tmp25_);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
								if (_tmp27_ == g_quark_from_string (RYGEL_CONTENT_DIRECTORY_UPNP_TYPE)) {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
									switch (0) {
#line 1832 "rygel-xbox-hacks.c"
										default:
										{
											xmlNode* _tmp28_;
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											_tmp28_ = type_node;
#line 199 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											xmlNodeSetContent (_tmp28_, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											break;
#line 1842 "rygel-xbox-hacks.c"
										}
									}
								} else if (_tmp27_ == g_quark_from_string (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE)) {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
									switch (0) {
#line 1848 "rygel-xbox-hacks.c"
										default:
										{
											xmlNode* _tmp29_;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											_tmp29_ = type_node;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											xmlNodeSetContent (_tmp29_, RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											break;
#line 1858 "rygel-xbox-hacks.c"
										}
									}
								} else {
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
									switch (0) {
#line 1864 "rygel-xbox-hacks.c"
										default:
										{
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
											break;
#line 1869 "rygel-xbox-hacks.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* f;
	gint res;
	FILE* _tmp2_;
	gboolean _tmp7_ = FALSE;
	FILE* _tmp8_;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (desc_path != NULL);
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = desc_path;
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = fopen (_tmp0_, "w+");
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	f = _tmp1_;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	res = -1;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = f;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp2_ != NULL) {
#line 1911 "rygel-xbox-hacks.c"
		GUPnPXMLDoc* _tmp3_;
		xmlDoc* _tmp4_;
		FILE* _tmp5_;
		gint _tmp6_ = 0;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp3_ = doc;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp4_ = _tmp3_->doc;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp5_ = f;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp6_ = xmlDocDump (_tmp5_, _tmp4_);
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		res = _tmp6_;
#line 1926 "rygel-xbox-hacks.c"
	}
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = f;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp8_ == NULL) {
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp7_ = TRUE;
#line 1934 "rygel-xbox-hacks.c"
	} else {
		gint _tmp9_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp9_ = res;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp7_ = _tmp9_ == (-1);
#line 1941 "rygel-xbox-hacks.c"
	}
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp10_ = _tmp7_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	if (_tmp10_) {
#line 1947 "rygel-xbox-hacks.c"
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* message;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp11_ = _ ("Failed to write modified description to %s.");
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		message = _tmp12_;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp13_ = message;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp14_ = desc_path;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_tmp15_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp13_, _tmp14_);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_inner_error_ = _tmp15_;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_g_free0 (message);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		_fclose0 (f);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		return;
#line 1976 "rygel-xbox-hacks.c"
	}
#line 214 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_fclose0 (f);
#line 1980 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type) {
	RygelXBoxHacks * self = NULL;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return self;
#line 1990 "rygel-xbox-hacks.c"
}


RygelXBoxHacks* rygel_xbox_hacks_new (void) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS);
#line 1997 "rygel-xbox-hacks.c"
}


const gchar* rygel_xbox_hacks_get_object_id (RygelXBoxHacks* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = self->priv->_object_id;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	return result;
#line 2012 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_set_object_id (RygelXBoxHacks* self, const gchar* value) {
	const gchar* _tmp0_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self->priv->_object_id = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_object_notify ((GObject *) self, "object-id");
#line 2026 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_type_class_add_private (klass, sizeof (RygelXBoxHacksPrivate));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_xbox_hacks_get_property;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_xbox_hacks_set_property;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_xbox_hacks_finalize;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_XBOX_HACKS_OBJECT_ID, g_param_spec_string ("object-id", "object-id", "object-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp0_ = g_strdup (".*Xbox.*|.*Allegro-Software-WebClient.*|.*SEC_HHP_Galaxy S/1\\.0.*");
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_AGENT = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp1_ = g_strdup ("urn:schemas-upnp-org:device:MediaServer");
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_DMS = _tmp1_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp2_ = rygel_xbox_hacks_DMS;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp3_ = g_strconcat (_tmp2_, ":1", NULL);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_DMS_V1 = _tmp3_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp4_ = g_strdup (":");
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = _tmp4_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp5_ = g_strdup ("Windows Media Player Sharing");
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_MODEL_NAME = _tmp5_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp6_ = g_strdup ("11");
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_MODEL_VERSION = _tmp6_;
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp7_ = g_strdup ("ContainerID");
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_CONTAINER_ID = _tmp7_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	_tmp8_ = g_strdup ("ObjectID");
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	rygel_xbox_hacks_OBJECT_ID = _tmp8_;
#line 2086 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self->priv = RYGEL_XBOX_HACKS_GET_PRIVATE (self);
#line 2093 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_finalize (GObject* obj) {
	RygelXBoxHacks * self;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	self = RYGEL_XBOX_HACKS (obj);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	G_OBJECT_CLASS (rygel_xbox_hacks_parent_class)->finalize (obj);
#line 2103 "rygel-xbox-hacks.c"
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}


static void _vala_rygel_xbox_hacks_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelXBoxHacks * self;
	self = RYGEL_XBOX_HACKS (object);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		case RYGEL_XBOX_HACKS_OBJECT_ID:
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		g_value_set_string (value, rygel_xbox_hacks_get_object_id (self));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		break;
#line 2130 "rygel-xbox-hacks.c"
		default:
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		break;
#line 2136 "rygel-xbox-hacks.c"
	}
}


static void _vala_rygel_xbox_hacks_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelXBoxHacks * self;
	self = RYGEL_XBOX_HACKS (object);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		case RYGEL_XBOX_HACKS_OBJECT_ID:
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		rygel_xbox_hacks_set_object_id (self, g_value_get_string (value));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		break;
#line 2152 "rygel-xbox-hacks.c"
		default:
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-xbox-hacks.vala"
		break;
#line 2158 "rygel-xbox-hacks.c"
	}
}



