/* rygel-relational-expression.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <gst/gst.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;
typedef struct _RygelPhotoItemPrivate RygelPhotoItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelImageItem {
	RygelMediaItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelPhotoItem {
	RygelImageItem parent_instance;
	RygelPhotoItemPrivate * priv;
	gchar* creator;
};

struct _RygelPhotoItemClass {
	RygelImageItemClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	gchar* artist;
	gchar* album;
	gchar* genre;
	gint track_number;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 406 "rygel-relational-expression.c"
}


static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label0 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label1 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label2 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label3 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label4 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label5 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label6 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label7 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label8 = 0;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	static GQuark _tmp2_label9 = 0;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) base;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	g_return_val_if_fail (media_object != NULL, FALSE);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp1_ = (const gchar*) _tmp0_;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 450 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp4_;
				const gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp4_ = media_object;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp5_ = _tmp4_->id;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp6_ = rygel_relational_expression_compare_string (self, _tmp5_);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp6_;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 466 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@refID")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 472 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp7_;
				const gchar* _tmp8_;
				gboolean _tmp9_ = FALSE;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp7_ = media_object;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp8_ = _tmp7_->ref_id;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp9_ = rygel_relational_expression_compare_string (self, _tmp8_);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp9_;
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 488 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@parentID")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 494 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp10_;
				RygelMediaContainer* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp10_ = media_object;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp11_ = _tmp10_->parent;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp12_ = ((RygelMediaObject*) _tmp11_)->id;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp13_ = rygel_relational_expression_compare_string (self, _tmp12_);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp13_;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 513 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 519 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp14_ = media_object;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp15_ = _tmp14_->upnp_class;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp16_ = rygel_relational_expression_compare_string (self, _tmp15_);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp16_;
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 535 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:title")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 541 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gboolean _tmp20_ = FALSE;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp17_ = media_object;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp18_ = rygel_media_object_get_title (_tmp17_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp19_ = _tmp18_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp20_ = rygel_relational_expression_compare_string (self, _tmp19_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp20_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 560 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:createClass")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 566 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp21_;
				RygelMediaObject* _tmp22_;
				gboolean _tmp23_ = FALSE;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp21_ = media_object;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				if (!RYGEL_IS_WRITABLE_CONTAINER (_tmp21_)) {
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					result = FALSE;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					return result;
#line 580 "rygel-relational-expression.c"
				}
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp22_ = media_object;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp23_ = rygel_relational_expression_compare_create_class (self, RYGEL_IS_WRITABLE_CONTAINER (_tmp22_) ? ((RygelWritableContainer*) _tmp22_) : NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp23_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 590 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:creator")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 596 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp24_;
				RygelMediaObject* _tmp25_;
				const gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp24_ = media_object;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				if (!RYGEL_IS_PHOTO_ITEM (_tmp24_)) {
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					result = FALSE;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					return result;
#line 611 "rygel-relational-expression.c"
				}
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp25_ = media_object;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp26_ = (RYGEL_IS_PHOTO_ITEM (_tmp25_) ? ((RygelPhotoItem*) _tmp25_) : NULL)->creator;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp27_ = rygel_relational_expression_compare_string (self, _tmp26_);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp27_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 623 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:artist")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 629 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp28_;
				RygelMediaObject* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_ = FALSE;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp28_ = media_object;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				if (!RYGEL_IS_MUSIC_ITEM (_tmp28_)) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					result = FALSE;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					return result;
#line 644 "rygel-relational-expression.c"
				}
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp29_ = media_object;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp30_ = (RYGEL_IS_MUSIC_ITEM (_tmp29_) ? ((RygelMusicItem*) _tmp29_) : NULL)->artist;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp31_ = rygel_relational_expression_compare_string (self, _tmp30_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp31_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 656 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("upnp:album")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 662 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp32_;
				RygelMediaObject* _tmp33_;
				const gchar* _tmp34_;
				gboolean _tmp35_ = FALSE;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp32_ = media_object;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				if (!RYGEL_IS_MUSIC_ITEM (_tmp32_)) {
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					result = FALSE;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					return result;
#line 677 "rygel-relational-expression.c"
				}
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp33_ = media_object;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp34_ = (RYGEL_IS_MUSIC_ITEM (_tmp33_) ? ((RygelMusicItem*) _tmp33_) : NULL)->album;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp35_ = rygel_relational_expression_compare_string (self, _tmp34_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp35_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 689 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("@childCount")))) {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 695 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp36_;
				RygelMediaObject* _tmp37_;
				RygelMediaContainer* _tmp38_;
				RygelMediaContainer* container;
				RygelMediaContainer* _tmp39_;
				gint _tmp40_;
				gboolean _tmp41_ = FALSE;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp36_ = media_object;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				if (!RYGEL_IS_MEDIA_CONTAINER (_tmp36_)) {
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					result = FALSE;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
					return result;
#line 713 "rygel-relational-expression.c"
				}
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp37_ = media_object;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp38_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp37_) ? ((RygelMediaContainer*) _tmp37_) : NULL);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				container = _tmp38_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp39_ = container;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp40_ = _tmp39_->child_count;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp41_ = rygel_relational_expression_compare_int (self, _tmp40_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp41_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_object_unref0 (container);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 733 "rygel-relational-expression.c"
			}
		}
	} else {
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		switch (0) {
#line 739 "rygel-relational-expression.c"
			default:
			{
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = FALSE;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 746 "rygel-relational-expression.c"
			}
		}
	}
}


static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
	RygelRelationalExpression * self;
	gchar* result = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_ = NULL;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) base;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp1_ = ((RygelSearchExpression*) self)->op;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp2_ = ((RygelSearchExpression*) self)->operand2;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp3_ = g_strdup_printf ("%s %d %s", (const gchar*) _tmp0_, (gint) GPOINTER_TO_INT (_tmp1_), (const gchar*) _tmp2_);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	result = _tmp3_;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	return result;
#line 774 "rygel-relational-expression.c"
}


static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	gboolean ret;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	g_return_val_if_fail (container != NULL, FALSE);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	ret = FALSE;
#line 787 "rygel-relational-expression.c"
	{
		RygelWritableContainer* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _create_class_list;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _create_class_size;
		gint _create_class_index;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp0_ = container;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp1_ = rygel_writable_container_get_create_classes (_tmp0_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp2_ = _tmp1_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_create_class_list = _tmp3_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp4_ = _create_class_list;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp6_ = _tmp5_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_create_class_size = _tmp6_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_create_class_index = -1;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		while (TRUE) {
#line 821 "rygel-relational-expression.c"
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			gchar* create_class;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp7_ = _create_class_index;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_create_class_index = _tmp7_ + 1;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp8_ = _create_class_index;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp9_ = _create_class_size;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				break;
#line 843 "rygel-relational-expression.c"
			}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp10_ = _create_class_list;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp11_ = _create_class_index;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			create_class = (gchar*) _tmp12_;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp13_ = create_class;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp14_ = rygel_relational_expression_compare_string (self, _tmp13_);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			if (_tmp14_) {
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				ret = TRUE;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_free0 (create_class);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				break;
#line 865 "rygel-relational-expression.c"
			}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (create_class);
#line 869 "rygel-relational-expression.c"
		}
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_g_object_unref0 (_create_class_list);
#line 873 "rygel-relational-expression.c"
	}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	result = ret;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	return result;
#line 879 "rygel-relational-expression.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1378 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1379 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 899 "rygel-relational-expression.c"
}


gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str) {
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* up_operand2;
	gchar* up_str = NULL;
	const gchar* _tmp2_;
	gconstpointer _tmp5_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp1_ = g_utf8_strup ((const gchar*) _tmp0_, (gssize) (-1));
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	up_operand2 = _tmp1_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp2_ = str;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	if (_tmp2_ != NULL) {
#line 923 "rygel-relational-expression.c"
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp3_ = str;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_tmp4_ = g_utf8_strup (_tmp3_, (gssize) (-1));
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_g_free0 (up_str);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		up_str = _tmp4_;
#line 934 "rygel-relational-expression.c"
	} else {
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		_g_free0 (up_str);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		up_str = NULL;
#line 940 "rygel-relational-expression.c"
	}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp5_ = ((RygelSearchExpression*) self)->op;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	switch (GPOINTER_TO_INT (_tmp5_)) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 948 "rygel-relational-expression.c"
		{
			gconstpointer _tmp6_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp6_ = ((RygelSearchExpression*) self)->operand2;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			if (g_strcmp0 ((const gchar*) _tmp6_, "true") == 0) {
#line 955 "rygel-relational-expression.c"
				const gchar* _tmp7_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp7_ = up_str;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp7_ != NULL;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_free0 (up_str);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_free0 (up_operand2);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 967 "rygel-relational-expression.c"
			} else {
				const gchar* _tmp8_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_tmp8_ = up_str;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				result = _tmp8_ == NULL;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_free0 (up_str);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				_g_free0 (up_operand2);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
				return result;
#line 980 "rygel-relational-expression.c"
			}
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 985 "rygel-relational-expression.c"
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp9_ = up_operand2;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp10_ = up_str;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = g_strcmp0 (_tmp9_, _tmp10_) == 0;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1001 "rygel-relational-expression.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1005 "rygel-relational-expression.c"
		{
			const gchar* _tmp11_;
			const gchar* _tmp12_;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp11_ = up_operand2;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp12_ = up_str;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = g_strcmp0 (_tmp11_, _tmp12_) != 0;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1021 "rygel-relational-expression.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 1025 "rygel-relational-expression.c"
		{
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gboolean _tmp15_ = FALSE;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp13_ = up_str;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp14_ = up_operand2;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp15_ = string_contains (_tmp13_, _tmp14_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp15_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1044 "rygel-relational-expression.c"
		}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 1048 "rygel-relational-expression.c"
		{
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp16_ = up_str;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp17_ = up_operand2;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp18_ = g_str_has_prefix (_tmp16_, _tmp17_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp18_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1067 "rygel-relational-expression.c"
		}
		default:
		{
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = FALSE;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1079 "rygel-relational-expression.c"
		}
	}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_g_free0 (up_str);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_g_free0 (up_operand2);
#line 1086 "rygel-relational-expression.c"
}


gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer) {
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gint _tmp1_ = 0;
	gint operand2;
	gconstpointer _tmp2_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp1_ = atoi ((const gchar*) _tmp0_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	operand2 = _tmp1_;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	_tmp2_ = ((RygelSearchExpression*) self)->op;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	switch (GPOINTER_TO_INT (_tmp2_)) {
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1110 "rygel-relational-expression.c"
		{
			gint _tmp3_;
			gint _tmp4_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp3_ = integer;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp4_ = operand2;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp3_ == _tmp4_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1122 "rygel-relational-expression.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1126 "rygel-relational-expression.c"
		{
			gint _tmp5_;
			gint _tmp6_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp5_ = integer;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp6_ = operand2;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp5_ != _tmp6_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1138 "rygel-relational-expression.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 1142 "rygel-relational-expression.c"
		{
			gint _tmp7_;
			gint _tmp8_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp7_ = integer;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp8_ = operand2;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp7_ < _tmp8_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1154 "rygel-relational-expression.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 1158 "rygel-relational-expression.c"
		{
			gint _tmp9_;
			gint _tmp10_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp9_ = integer;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp10_ = operand2;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp9_ <= _tmp10_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1170 "rygel-relational-expression.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 1174 "rygel-relational-expression.c"
		{
			gint _tmp11_;
			gint _tmp12_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp11_ = integer;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp12_ = operand2;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp11_ > _tmp12_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1186 "rygel-relational-expression.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 1190 "rygel-relational-expression.c"
		{
			gint _tmp13_;
			gint _tmp14_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp13_ = integer;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			_tmp14_ = operand2;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = _tmp13_ >= _tmp14_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1202 "rygel-relational-expression.c"
		}
		default:
		{
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			result = FALSE;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
			return result;
#line 1210 "rygel-relational-expression.c"
		}
	}
}


RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
	RygelRelationalExpression* self = NULL;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, GUPNP_TYPE_SEARCH_CRITERIA_OP, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	return self;
#line 1222 "rygel-relational-expression.c"
}


RygelRelationalExpression* rygel_relational_expression_new (void) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
#line 1229 "rygel-relational-expression.c"
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-relational-expression.vala"
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_relational_expression_real_to_string;
#line 1240 "rygel-relational-expression.c"
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}



