/* rygel-media-export-sqlite-wrapper.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-media-export-sqlite-wrapper.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;
typedef struct _RygelMediaExportSqliteWrapperPrivate RygelMediaExportSqliteWrapperPrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelMediaExportSqliteWrapper {
	GObject parent_instance;
	RygelMediaExportSqliteWrapperPrivate * priv;
};

struct _RygelMediaExportSqliteWrapperClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportSqliteWrapperPrivate {
	sqlite3* database;
	sqlite3* reference;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()

static gpointer rygel_media_export_sqlite_wrapper_parent_class = NULL;

GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_DB
};
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_new_wrap (sqlite3* db);
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_construct_wrap (GType object_type, sqlite3* db);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_new (const gchar* path, GError** error);
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_construct (GType object_type, const gchar* path, GError** error);
void rygel_media_export_sqlite_wrapper_throw_if_db_has_error (RygelMediaExportSqliteWrapper* self, GError** error);
void rygel_media_export_sqlite_wrapper_throw_if_code_is_error (RygelMediaExportSqliteWrapper* self, gint sqlite_error, GError** error);
sqlite3* rygel_media_export_sqlite_wrapper_get_db (RygelMediaExportSqliteWrapper* self);
static void rygel_media_export_sqlite_wrapper_finalize (GObject* obj);
static void _vala_rygel_media_export_sqlite_wrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
     * Wrap an existing SQLite Database object.
     *
     * The SqliteWrapper doesn't take ownership of the passed db
     */
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_construct_wrap (GType object_type, sqlite3* db) {
	RygelMediaExportSqliteWrapper * self = NULL;
	sqlite3* _tmp0_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_return_val_if_fail (db != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self = (RygelMediaExportSqliteWrapper*) g_object_new (object_type, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp0_ = db;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv->reference = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	return self;
#line 105 "rygel-media-export-sqlite-wrapper.c"
}


RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_new_wrap (sqlite3* db) {
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	return rygel_media_export_sqlite_wrapper_construct_wrap (RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, db);
#line 112 "rygel-media-export-sqlite-wrapper.c"
}


/**
     * Create or open a new SQLite database in path.
     *
     * @note: Path may also be ":memory:" for temporary databases
     */
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_construct (GType object_type, const gchar* path, GError** error) {
	RygelMediaExportSqliteWrapper * self = NULL;
	const gchar* _tmp0_;
	sqlite3* _tmp1_ = NULL;
	sqlite3* _tmp2_;
	GError * _inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self = (RygelMediaExportSqliteWrapper*) g_object_new (object_type, NULL);
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp0_ = path;
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	sqlite3_open (_tmp0_, &_tmp1_);
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_sqlite3_close0 (self->priv->database);
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv->database = _tmp1_;
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp2_ = self->priv->database;
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv->reference = _tmp2_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	rygel_media_export_sqlite_wrapper_throw_if_db_has_error (self, &_inner_error_);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	if (_inner_error_ != NULL) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_propagate_error (error, _inner_error_);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_g_object_unref0 (self);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			return NULL;
#line 155 "rygel-media-export-sqlite-wrapper.c"
		} else {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_clear_error (&_inner_error_);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			return NULL;
#line 163 "rygel-media-export-sqlite-wrapper.c"
		}
	}
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	return self;
#line 168 "rygel-media-export-sqlite-wrapper.c"
}


RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_new (const gchar* path, GError** error) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	return rygel_media_export_sqlite_wrapper_construct (RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, path, error);
#line 175 "rygel-media-export-sqlite-wrapper.c"
}


/**
     * Convert a SQLite return code to a DatabaseError
     */
void rygel_media_export_sqlite_wrapper_throw_if_code_is_error (RygelMediaExportSqliteWrapper* self, gint sqlite_error, GError** error) {
	gint _tmp0_;
	GError * _inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp0_ = sqlite_error;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	switch (_tmp0_) {
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		case SQLITE_OK:
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		case SQLITE_DONE:
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		case SQLITE_ROW:
#line 197 "rygel-media-export-sqlite-wrapper.c"
		{
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			return;
#line 201 "rygel-media-export-sqlite-wrapper.c"
		}
		default:
		{
			gint _tmp1_;
			sqlite3* _tmp2_;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_tmp1_ = sqlite_error;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_tmp2_ = self->priv->reference;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_tmp4_ = g_error_new (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, "SQLite error %d: %s", _tmp1_, _tmp3_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			_inner_error_ = _tmp4_;
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
				g_propagate_error (error, _inner_error_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
				return;
#line 225 "rygel-media-export-sqlite-wrapper.c"
			} else {
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
				g_clear_error (&_inner_error_);
#line 67 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
				return;
#line 233 "rygel-media-export-sqlite-wrapper.c"
			}
		}
	}
}


/**
     * Check if the last operation on the database was an error
     */
void rygel_media_export_sqlite_wrapper_throw_if_db_has_error (RygelMediaExportSqliteWrapper* self, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp0_ = self->priv->reference;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp1_ = sqlite3_errcode (_tmp0_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	rygel_media_export_sqlite_wrapper_throw_if_code_is_error (self, _tmp1_, &_inner_error_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			return;
#line 263 "rygel-media-export-sqlite-wrapper.c"
		} else {
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			g_clear_error (&_inner_error_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
			return;
#line 271 "rygel-media-export-sqlite-wrapper.c"
		}
	}
}


sqlite3* rygel_media_export_sqlite_wrapper_get_db (RygelMediaExportSqliteWrapper* self) {
	sqlite3* result;
	sqlite3* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_tmp0_ = self->priv->reference;
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	return result;
#line 288 "rygel-media-export-sqlite-wrapper.c"
}


static void rygel_media_export_sqlite_wrapper_class_init (RygelMediaExportSqliteWrapperClass * klass) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	rygel_media_export_sqlite_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportSqliteWrapperPrivate));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_sqlite_wrapper_get_property;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_sqlite_wrapper_finalize;
#line 301 "rygel-media-export-sqlite-wrapper.c"
	/**
	     * Property to access the wrapped database
	     */
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_DB, g_param_spec_pointer ("db", "db", "db", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 307 "rygel-media-export-sqlite-wrapper.c"
}


static void rygel_media_export_sqlite_wrapper_instance_init (RygelMediaExportSqliteWrapper * self) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv = RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_PRIVATE (self);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv->database = NULL;
#line 27 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self->priv->reference = NULL;
#line 318 "rygel-media-export-sqlite-wrapper.c"
}


static void rygel_media_export_sqlite_wrapper_finalize (GObject* obj) {
	RygelMediaExportSqliteWrapper * self;
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	self = RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER (obj);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	_sqlite3_close0 (self->priv->database);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	G_OBJECT_CLASS (rygel_media_export_sqlite_wrapper_parent_class)->finalize (obj);
#line 330 "rygel-media-export-sqlite-wrapper.c"
}


GType rygel_media_export_sqlite_wrapper_get_type (void) {
	static volatile gsize rygel_media_export_sqlite_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_sqlite_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportSqliteWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_sqlite_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportSqliteWrapper), 0, (GInstanceInitFunc) rygel_media_export_sqlite_wrapper_instance_init, NULL };
		GType rygel_media_export_sqlite_wrapper_type_id;
		rygel_media_export_sqlite_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportSqliteWrapper", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_sqlite_wrapper_type_id__volatile, rygel_media_export_sqlite_wrapper_type_id);
	}
	return rygel_media_export_sqlite_wrapper_type_id__volatile;
}


static void _vala_rygel_media_export_sqlite_wrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportSqliteWrapper * self;
	self = RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER (object);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
	switch (property_id) {
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		case RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_DB:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		g_value_set_pointer (value, rygel_media_export_sqlite_wrapper_get_db (self));
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		break;
#line 357 "rygel-media-export-sqlite-wrapper.c"
		default:
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-sqlite-wrapper.vala"
		break;
#line 363 "rygel-media-export-sqlite-wrapper.c"
	}
}



