/* rygel-http-item-uri-test.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-http-item-uri-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI_TEST (rygel_http_item_uri_test_get_type ())
#define RYGEL_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITest))
#define RYGEL_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))
#define RYGEL_IS_HTTP_ITEM_URI_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_IS_HTTP_ITEM_URI_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI_TEST))
#define RYGEL_HTTP_ITEM_URI_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestClass))

typedef struct _RygelHTTPItemURITest RygelHTTPItemURITest;
typedef struct _RygelHTTPItemURITestClass RygelHTTPItemURITestClass;
typedef struct _RygelHTTPItemURITestPrivate RygelHTTPItemURITestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
};

struct _RygelHTTPItemURITest {
	GObject parent_instance;
	RygelHTTPItemURITestPrivate * priv;
};

struct _RygelHTTPItemURITestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURITestPrivate {
	RygelHTTPServer* server;
};


static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_item_uri_test_parent_class = NULL;

GQuark rygel_http_request_error_quark (void);
GQuark rygel_test_error_quark (void);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/Test"
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_http_item_uri_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI_TEST, RygelHTTPItemURITestPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID "HELLO"
#define RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX 1
#define RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET "MP3"
gint rygel_http_item_uri_test_main (gchar** args, int args_length1);
static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error);
static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error);
void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self);
static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri);
static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_item_uri_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPContext* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GError * _inner_error_ = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_set_path_root (self, RYGEL_HTTP_SERVER_SERVER_PATH);
#line 183 "rygel-http-item-uri-test.c"
	{
		GUPnPContext* _tmp0_;
		GUPnPContext* _tmp1_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = _tmp0_;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 193 "rygel-http-item-uri-test.c"
			goto __catch0_g_error;
		}
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (self->context);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		self->context = _tmp1_;
#line 200 "rygel-http-item-uri-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = _tmp2_;
#line 47 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 217 "rygel-http-item-uri-test.c"
		goto __finally0;
	}
	__finally0:
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 231 "rygel-http-item-uri-test.c"
		} else {
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 239 "rygel-http-item-uri-test.c"
		}
	}
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = self->context;
#line 50 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp3_ != NULL);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = self->context;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp4_);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp6_ = _tmp5_;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp6_ != NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp7_ = self->context;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp8_ = gupnp_context_get_port (_tmp7_);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp9_ = _tmp8_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (_tmp9_ > ((guint) 0));
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 264 "rygel-http-item-uri-test.c"
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
#line 41 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
#line 271 "rygel-http-item-uri-test.c"
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->_path_root;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 286 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->_path_root = _tmp1_;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_notify ((GObject *) self, "path-root");
#line 305 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 322 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
#line 329 "rygel-http-item-uri-test.c"
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_HTTP_SERVER (obj);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (self->priv->_path_root);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->context);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
#line 343 "rygel-http-item-uri-test.c"
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_value_set_string (value, rygel_http_server_get_path_root (self));
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 370 "rygel-http-item-uri-test.c"
		default:
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 376 "rygel-http-item-uri-test.c"
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	switch (property_id) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		case RYGEL_HTTP_SERVER_PATH_ROOT:
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_server_set_path_root (self, g_value_get_string (value));
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 392 "rygel-http-item-uri-test.c"
		default:
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		break;
#line 398 "rygel-http-item-uri-test.c"
	}
}


gint rygel_http_item_uri_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPItemURITest* _tmp0_;
		RygelHTTPItemURITest* test;
		RygelHTTPItemURITest* _tmp1_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp0_ = rygel_http_item_uri_test_new (&_inner_error_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		test = _tmp0_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 418 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp1_ = test;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		rygel_http_item_uri_test_run (_tmp1_, &_inner_error_);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_ != NULL) {
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (test);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 433 "rygel-http-item-uri-test.c"
				goto __catch1_rygel_test_error_skip;
			}
			goto __catch1_g_error;
		}
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_object_unref0 (test);
#line 440 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = 77;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 456 "rygel-http-item-uri-test.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_error_ = _inner_error_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp2_ = _error_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_tmp3_ = _tmp2_->message;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("rygel-http-item-uri-test.vala:72: %s", _tmp3_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		result = -1;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		_g_error_free0 (_error_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return result;
#line 480 "rygel-http-item-uri-test.c"
	}
	__finally1:
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return 0;
#line 491 "rygel-http-item-uri-test.c"
	}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = 0;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 497 "rygel-http-item-uri-test.c"
}


int main (int argc, char ** argv) {
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_thread_init (NULL);
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_init ();
#line 64 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_main (argv, argc);
#line 508 "rygel-http-item-uri-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 515 "rygel-http-item-uri-test.c"
}


void rygel_http_item_uri_test_run (RygelHTTPItemURITest* self, GError** error) {
	RygelHTTPItemURI* _tmp0_ = NULL;
	RygelHTTPItemURI* _tmp1_ = NULL;
	RygelHTTPItemURI* _tmp2_ = NULL;
	RygelHTTPItemURI* _tmp3_ = NULL;
	RygelHTTPItemURI** _tmp4_ = NULL;
	RygelHTTPItemURI** uris;
	gint uris_length1;
	gint _uris_size_;
	RygelHTTPItemURI** _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_http_item_uri_test_test_construction (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_test_test_construction_with_thumbnail (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_test_test_construction_with_subtitle (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = rygel_http_item_uri_test_test_construction_with_transcoder (self);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = g_new0 (RygelHTTPItemURI*, 4 + 1);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_[0] = _tmp0_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_[1] = _tmp1_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_[2] = _tmp2_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_[3] = _tmp3_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = _tmp4_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris_length1 = 4;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_uris_size_ = uris_length1;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = uris;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5__length1 = uris_length1;
#line 561 "rygel-http-item-uri-test.c"
	{
		RygelHTTPItemURI** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection = _tmp5_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		uri_collection_length1 = _tmp5__length1;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		for (uri_it = 0; uri_it < _tmp5__length1; uri_it = uri_it + 1) {
#line 573 "rygel-http-item-uri-test.c"
			RygelHTTPItemURI* _tmp6_;
			RygelHTTPItemURI* uri = NULL;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_tmp6_ = _g_object_ref0 (uri_collection[uri_it]);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			uri = _tmp6_;
#line 580 "rygel-http-item-uri-test.c"
			{
				RygelHTTPItemURI* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* str;
				const gchar* _tmp9_;
				RygelHTTPItemURI* _tmp10_ = NULL;
				RygelHTTPItemURI* _tmp11_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp7_ = uri;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp8_ = rygel_http_item_uri_test_test_to_string (self, _tmp7_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				str = _tmp8_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp9_ = str;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp10_ = rygel_http_item_uri_test_test_construction_from_string (self, _tmp9_, &_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_tmp11_ = _tmp10_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (_tmp11_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				if (_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_free0 (str);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					_g_object_unref0 (uri);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
					return;
#line 614 "rygel-http-item-uri-test.c"
				}
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_free0 (str);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
				_g_object_unref0 (uri);
#line 620 "rygel-http-item-uri-test.c"
			}
		}
	}
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_object_unref), NULL);
#line 626 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_construct (GType object_type, GError** error) {
	RygelHTTPItemURITest * self = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GError * _inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = (RygelHTTPItemURITest*) g_object_new (object_type, NULL);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = rygel_http_server_new (&_inner_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = _tmp0_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			_g_object_unref0 (self);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 651 "rygel-http-item-uri-test.c"
		} else {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
			return NULL;
#line 659 "rygel-http-item-uri-test.c"
		}
	}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv->server = _tmp1_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return self;
#line 668 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURITest* rygel_http_item_uri_test_new (GError** error) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return rygel_http_item_uri_test_construct (RYGEL_TYPE_HTTP_ITEM_URI_TEST, error);
#line 675 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* uri;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->server;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, _tmp0_, -1, -1, NULL);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp1_;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 698 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_subtitle (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* uri;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->server;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, _tmp0_, RYGEL_HTTP_ITEM_URI_TEST_SUBTITLE_INDEX, -1, NULL);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp1_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 721 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_thumbnail (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* uri;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->server;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, _tmp0_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, NULL);
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp1_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 744 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_with_transcoder (RygelHTTPItemURITest* self) {
	RygelHTTPItemURI* result = NULL;
	RygelHTTPServer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	RygelHTTPItemURI* uri;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = self->priv->server;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_new (RYGEL_HTTP_ITEM_URI_TEST_ITEM_ID, _tmp0_, RYGEL_HTTP_ITEM_URI_TEST_THUMBNAIL_INDEX, -1, RYGEL_HTTP_ITEM_URI_TEST_TRANSCODE_TARGET);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp1_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 767 "rygel-http-item-uri-test.c"
}


static RygelHTTPItemURI* rygel_http_item_uri_test_test_construction_from_string (RygelHTTPItemURITest* self, const gchar* str, GError** error) {
	RygelHTTPItemURI* result = NULL;
	const gchar* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	RygelHTTPItemURI* uri;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = str;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = self->priv->server;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp2_ = rygel_http_item_uri_new_from_string (_tmp0_, _tmp1_, &_inner_error_);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	uri = _tmp2_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	if (_inner_error_ != NULL) {
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
		return NULL;
#line 799 "rygel-http-item-uri-test.c"
	}
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (uri != NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp3_ = rygel_http_item_uri_to_string (uri);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp4_ = _tmp3_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp5_ = str;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (g_strcmp0 (_tmp4_, _tmp5_) == 0);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_free0 (_tmp4_);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = uri;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 817 "rygel-http-item-uri-test.c"
}


static gchar* rygel_http_item_uri_test_test_to_string (RygelHTTPItemURITest* self, RygelHTTPItemURI* uri) {
	gchar* result = NULL;
	RygelHTTPItemURI* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp0_ = uri;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_tmp1_ = rygel_http_item_uri_to_string (_tmp0_);
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	str = _tmp1_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_assert (str != NULL);
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	result = str;
#line 146 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	return result;
#line 842 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_class_init (RygelHTTPItemURITestClass * klass) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	rygel_http_item_uri_test_parent_class = g_type_class_peek_parent (klass);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURITestPrivate));
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_test_finalize;
#line 853 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_instance_init (RygelHTTPItemURITest * self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_TEST_GET_PRIVATE (self);
#line 860 "rygel-http-item-uri-test.c"
}


static void rygel_http_item_uri_test_finalize (GObject* obj) {
	RygelHTTPItemURITest * self;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	self = RYGEL_HTTP_ITEM_URI_TEST (obj);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	_g_object_unref0 (self->priv->server);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri-test.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_test_parent_class)->finalize (obj);
#line 872 "rygel-http-item-uri-test.c"
}


GType rygel_http_item_uri_test_get_type (void) {
	static volatile gsize rygel_http_item_uri_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURITestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURITest), 0, (GInstanceInitFunc) rygel_http_item_uri_test_instance_init, NULL };
		GType rygel_http_item_uri_test_type_id;
		rygel_http_item_uri_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURITest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_test_type_id__volatile, rygel_http_item_uri_test_type_id);
	}
	return rygel_http_item_uri_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



