/* contacts-store.c generated by valac 0.13.3.3-f2a8a, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <gio/gio.h>


#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsContactPrivate ContactsContactPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ContactsStoreCheckCallCapabilitiesData ContactsStoreCheckCallCapabilitiesData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsStoreCheckAccountCapsData ContactsStoreCheckAccountCapsData;

struct _ContactsStore {
	GObject parent_instance;
	ContactsStorePrivate * priv;
	GeeHashMap* calling_accounts;
};

struct _ContactsStoreClass {
	GObjectClass parent_class;
};

struct _ContactsStorePrivate {
	FolksIndividualAggregator* _aggregator;
	GeeArrayList* contacts;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	gboolean is_new;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _ContactsStoreCheckCallCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsStore* self;
	GeeHashMap* _tmp0_;
	TpAccountManager* _tmp1_;
	TpAccountManager* account_manager;
	GList* _tmp2_;
	GList* account_collection;
	GList* account_it;
	TpAccount* account;
	TpAccount* _tmp3_;
	GError * _inner_error_;
};

struct _ContactsStoreCheckAccountCapsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsStore* self;
	TpAccount* account;
	GQuark _tmp0_;
	GQuark addressing;
	TpAccount* _tmp1_;
	GQuark _tmp2_;
	gboolean _tmp3_;
	GQuark _tmp4_;
	GQuark* _tmp5_;
	GQuark* features;
	gint features_length1;
	gint _features_size_;
	TpAccount* _tmp6_;
	GQuark* _tmp7_;
	gint _tmp7__length1;
	TpAccount* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* k;
	gboolean _tmp11_;
	TpAccount* _tmp12_;
	gboolean _tmp13_;
	TpAccount* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	TpAccount* _tmp19_;
	GeeHashMap* _tmp20_;
	const gchar* _tmp21_;
	GError * _inner_error_;
};


static gpointer contacts_store_parent_class = NULL;

GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
#define CONTACTS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_STORE, ContactsStorePrivate))
enum  {
	CONTACTS_STORE_DUMMY_PROPERTY,
	CONTACTS_STORE_AGGREGATOR,
	CONTACTS_STORE_CAN_CALL
};
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void __lambda6_ (ContactsStore* self, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
void contacts_contact_replace_individual (ContactsContact* self, FolksIndividual* new_individual);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
static void contacts_store_add (ContactsStore* self, ContactsContact* c);
static void contacts_store_remove (ContactsStore* self, ContactsContact* c);
static void ___lambda6__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_);
static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c);
ContactsContact* contacts_store_find_contact_with_id (ContactsStore* self, const gchar* individual_id);
ContactsContact* contacts_store_find_contact_with_email (ContactsStore* self, const gchar* email_address);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona);
GeeCollection* contacts_store_get_contacts (ContactsStore* self);
gboolean contacts_store_is_empty (ContactsStore* self);
gboolean contacts_contact_is_hidden (ContactsContact* self);
static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void contacts_store_check_call_capabilities_data_free (gpointer _data);
static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_);
static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_);
static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void contacts_store_check_account_caps_data_free (gpointer _data);
static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_);
static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean contacts_store_get_can_call (ContactsStore* self);
static void contacts_store_finalize (GObject* obj);
static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda6_ (ContactsStore* self, GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r) {
	GeeHashMap* _tmp0_;
	GeeHashMap* old_individuals;
	GeeHashSet* _tmp1_;
	GeeHashSet* replaced_individuals;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	old_individuals = _tmp0_;
	_tmp1_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	replaced_individuals = _tmp1_;
	{
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _i_it;
		_tmp2_ = removed;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_i_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			FolksIndividual* i;
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _i_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			i = (FolksIndividual*) _tmp7_;
			{
				FolksIndividual* _tmp8_;
				GeeSet* _tmp9_;
				GeeSet* _tmp10_;
				GeeIterator* _tmp11_ = NULL;
				GeeIterator* _p_it;
				_tmp8_ = i;
				_tmp9_ = folks_individual_get_personas (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
				_p_it = _tmp11_;
				while (TRUE) {
					GeeIterator* _tmp12_;
					gboolean _tmp13_ = FALSE;
					GeeIterator* _tmp14_;
					gpointer _tmp15_ = NULL;
					FolksPersona* p;
					GeeHashMap* _tmp16_;
					FolksPersona* _tmp17_;
					FolksIndividual* _tmp18_;
					_tmp12_ = _p_it;
					_tmp13_ = gee_iterator_next (_tmp12_);
					if (!_tmp13_) {
						break;
					}
					_tmp14_ = _p_it;
					_tmp15_ = gee_iterator_get (_tmp14_);
					p = (FolksPersona*) _tmp15_;
					_tmp16_ = old_individuals;
					_tmp17_ = p;
					_tmp18_ = i;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp18_);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp19_;
		GeeIterator* _tmp20_ = NULL;
		GeeIterator* _i_it;
		_tmp19_ = added;
		_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
		_i_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			FolksIndividual* i;
			FolksIndividual* old_individual;
			gboolean _tmp42_ = FALSE;
			FolksIndividual* _tmp43_;
			gboolean _tmp47_;
			_tmp21_ = _i_it;
			_tmp22_ = gee_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _i_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			i = (FolksIndividual*) _tmp24_;
			old_individual = NULL;
			{
				FolksIndividual* _tmp25_;
				GeeSet* _tmp26_;
				GeeSet* _tmp27_;
				GeeIterator* _tmp28_ = NULL;
				GeeIterator* _p_it;
				_tmp25_ = i;
				_tmp26_ = folks_individual_get_personas (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
				_p_it = _tmp28_;
				while (TRUE) {
					GeeIterator* _tmp29_;
					gboolean _tmp30_ = FALSE;
					GeeIterator* _tmp31_;
					gpointer _tmp32_ = NULL;
					FolksPersona* p;
					GeeHashMap* _tmp33_;
					FolksPersona* _tmp34_;
					gpointer _tmp35_ = NULL;
					FolksIndividual* o_i;
					FolksIndividual* _tmp36_;
					_tmp29_ = _p_it;
					_tmp30_ = gee_iterator_next (_tmp29_);
					if (!_tmp30_) {
						break;
					}
					_tmp31_ = _p_it;
					_tmp32_ = gee_iterator_get (_tmp31_);
					p = (FolksPersona*) _tmp32_;
					_tmp33_ = old_individuals;
					_tmp34_ = p;
					_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
					o_i = (FolksIndividual*) _tmp35_;
					_tmp36_ = o_i;
					if (_tmp36_ != NULL) {
						FolksIndividual* _tmp37_;
						_tmp37_ = old_individual;
						if (_tmp37_ == NULL) {
							FolksIndividual* _tmp38_;
							FolksIndividual* _tmp39_;
							_tmp38_ = o_i;
							_tmp39_ = _g_object_ref0 (_tmp38_);
							_g_object_unref0 (old_individual);
							old_individual = _tmp39_;
						} else {
							FolksIndividual* _tmp40_;
							FolksIndividual* _tmp41_;
							_tmp40_ = o_i;
							_tmp41_ = old_individual;
							if (_tmp40_ != _tmp41_) {
								_g_object_unref0 (old_individual);
								old_individual = NULL;
								_g_object_unref0 (o_i);
								_g_object_unref0 (p);
								break;
							}
						}
					}
					_g_object_unref0 (o_i);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			_tmp43_ = old_individual;
			if (_tmp43_ != NULL) {
				GeeHashSet* _tmp44_;
				FolksIndividual* _tmp45_;
				gboolean _tmp46_ = FALSE;
				_tmp44_ = replaced_individuals;
				_tmp45_ = old_individual;
				_tmp46_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
				_tmp42_ = !_tmp46_;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp47_ = _tmp42_;
			if (_tmp47_) {
				GeeHashSet* _tmp48_;
				FolksIndividual* _tmp49_;
				FolksIndividual* _tmp50_;
				ContactsContact* _tmp51_ = NULL;
				ContactsContact* c;
				ContactsContact* _tmp52_;
				FolksIndividual* _tmp53_;
				_tmp48_ = replaced_individuals;
				_tmp49_ = old_individual;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
				_tmp50_ = old_individual;
				_tmp51_ = contacts_contact_from_individual (_tmp50_);
				c = _tmp51_;
				_tmp52_ = c;
				_tmp53_ = i;
				contacts_contact_replace_individual (_tmp52_, _tmp53_);
				_g_object_unref0 (c);
			} else {
				FolksIndividual* _tmp54_;
				ContactsContact* _tmp55_;
				ContactsContact* c;
				ContactsContact* _tmp56_;
				_tmp54_ = i;
				_tmp55_ = contacts_contact_new (self, _tmp54_);
				c = _tmp55_;
				_tmp56_ = c;
				contacts_store_add (self, _tmp56_);
				_g_object_unref0 (c);
			}
			_g_object_unref0 (old_individual);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp57_;
		GeeIterator* _tmp58_ = NULL;
		GeeIterator* _i_it;
		_tmp57_ = removed;
		_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
		_i_it = _tmp58_;
		while (TRUE) {
			GeeIterator* _tmp59_;
			gboolean _tmp60_ = FALSE;
			GeeIterator* _tmp61_;
			gpointer _tmp62_ = NULL;
			FolksIndividual* i;
			GeeHashSet* _tmp63_;
			FolksIndividual* _tmp64_;
			gboolean _tmp65_ = FALSE;
			_tmp59_ = _i_it;
			_tmp60_ = gee_iterator_next (_tmp59_);
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = _i_it;
			_tmp62_ = gee_iterator_get (_tmp61_);
			i = (FolksIndividual*) _tmp62_;
			_tmp63_ = replaced_individuals;
			_tmp64_ = i;
			_tmp65_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp63_, _tmp64_);
			if (!_tmp65_) {
				FolksIndividual* _tmp66_;
				ContactsContact* _tmp67_ = NULL;
				ContactsContact* _tmp68_;
				_tmp66_ = i;
				_tmp67_ = contacts_contact_from_individual (_tmp66_);
				_tmp68_ = _tmp67_;
				contacts_store_remove (self, _tmp68_);
				_g_object_unref0 (_tmp68_);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (replaced_individuals);
	_g_object_unref0 (old_individuals);
}


static void ___lambda6__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	__lambda6_ (self, added, removed, message, actor, reason);
}


ContactsStore* contacts_store_construct (GType object_type) {
	ContactsStore * self = NULL;
	GeeArrayList* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	self = (ContactsStore*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp0_;
	_tmp1_ = folks_individual_aggregator_new ();
	_tmp2_ = _tmp1_;
	contacts_store_set_aggregator (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_aggregator;
	g_signal_connect_object (_tmp3_, "individuals-changed", (GCallback) ___lambda6__folks_individual_aggregator_individuals_changed, self, 0);
	_tmp4_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp4_, NULL, NULL);
	contacts_store_check_call_capabilities (self, NULL, NULL);
	return self;
}


ContactsStore* contacts_store_new (void) {
	return contacts_store_construct (CONTACTS_TYPE_STORE);
}


static void contacts_store_contact_changed_cb (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_emit_by_name (self, "changed", _tmp0_);
}


ContactsContact* contacts_store_find_contact_with_id (ContactsStore* self, const gchar* individual_id) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (individual_id != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _contact_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_size;
		gint _contact_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsContact* contact;
			ContactsContact* _tmp11_;
			FolksIndividual* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = _tmp11_->individual;
			_tmp13_ = folks_individual_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = individual_id;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				result = contact;
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = NULL;
	return result;
}


ContactsContact* contacts_store_find_contact_with_email (ContactsStore* self, const gchar* email_address) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (email_address != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _contact_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_size;
		gint _contact_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsContact* contact;
			ContactsContact* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = email_address;
			_tmp13_ = contacts_contact_has_email (_tmp11_, _tmp12_);
			if (_tmp13_) {
				result = contact;
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = NULL;
	return result;
}


ContactsContact* contacts_store_find_contact_with_persona (ContactsStore* self, FolksPersona* persona) {
	ContactsContact* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _contact_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_size;
		gint _contact_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsContact* contact;
			ContactsContact* _tmp11_;
			FolksIndividual* _tmp12_;
			GeeSet* _tmp13_;
			GeeSet* _tmp14_;
			FolksPersona* _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = _tmp11_->individual;
			_tmp13_ = folks_individual_get_personas (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = persona;
			_tmp16_ = gee_collection_contains ((GeeCollection*) _tmp14_, _tmp15_);
			if (_tmp16_) {
				result = contact;
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = NULL;
	return result;
}


GeeCollection* contacts_store_get_contacts (ContactsStore* self) {
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = gee_abstract_list_get_read_only_view ((GeeAbstractList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeCollection*) _tmp2_;
	return result;
}


gboolean contacts_store_is_empty (ContactsStore* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _contact_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _contact_size;
		gint _contact_index;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_contact_list = _tmp1_;
		_tmp2_ = _contact_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_contact_size = _tmp4_;
		_contact_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ContactsContact* contact;
			ContactsContact* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = _contact_index;
			_contact_index = _tmp5_ + 1;
			_tmp6_ = _contact_index;
			_tmp7_ = _contact_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contact_list;
			_tmp9_ = _contact_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			contact = (ContactsContact*) _tmp10_;
			_tmp11_ = contact;
			_tmp12_ = contacts_contact_is_hidden (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_g_object_unref0 (contact);
				_g_object_unref0 (_contact_list);
				return result;
			}
			_g_object_unref0 (contact);
		}
		_g_object_unref0 (_contact_list);
	}
	result = TRUE;
	return result;
}


static void _contacts_store_contact_changed_cb_contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	contacts_store_contact_changed_cb (self, _sender);
}


static void contacts_store_add (ContactsStore* self, ContactsContact* c) {
	GeeArrayList* _tmp0_;
	ContactsContact* _tmp1_;
	ContactsContact* _tmp2_;
	ContactsContact* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = c;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = c;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self, 0);
	_tmp3_ = c;
	g_signal_emit_by_name (self, "added", _tmp3_);
}


static void contacts_store_remove (ContactsStore* self, ContactsContact* c) {
	ContactsContact* _tmp0_;
	guint _tmp1_ = 0U;
	GeeArrayList* _tmp2_;
	ContactsContact* _tmp3_;
	gint _tmp4_ = 0;
	gint i;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_ = NULL;
	ContactsContact* _tmp22_;
	ContactsContact* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	g_signal_parse_name ("changed", CONTACTS_TYPE_CONTACT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _contacts_store_contact_changed_cb_contacts_contact_changed, self);
	_tmp2_ = self->priv->contacts;
	_tmp3_ = c;
	_tmp4_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp2_, _tmp3_);
	i = _tmp4_;
	_tmp5_ = i;
	_tmp6_ = self->priv->contacts;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp5_ != (_tmp8_ - 1)) {
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gpointer _tmp15_ = NULL;
		ContactsContact* _tmp16_;
		_tmp9_ = self->priv->contacts;
		_tmp10_ = i;
		_tmp11_ = self->priv->contacts;
		_tmp12_ = self->priv->contacts;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp14_ - 1);
		_tmp16_ = (ContactsContact*) _tmp15_;
		gee_abstract_list_set ((GeeAbstractList*) _tmp9_, _tmp10_, _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->contacts;
	_tmp18_ = self->priv->contacts;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp17_, _tmp20_ - 1);
	_tmp22_ = (ContactsContact*) _tmp21_;
	_g_object_unref0 (_tmp22_);
	_tmp23_ = c;
	g_signal_emit_by_name (self, "removed", _tmp23_);
}


static void contacts_store_check_call_capabilities_data_free (gpointer _data) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckCallCapabilitiesData, _data_);
}


static void contacts_store_check_call_capabilities (ContactsStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	ContactsStore* _tmp0_;
	_data_ = g_slice_new0 (ContactsStoreCheckCallCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_store_check_call_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_store_check_call_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void contacts_store_check_call_capabilities_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void contacts_store_check_call_capabilities_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckCallCapabilitiesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_call_capabilities_co (_data_);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_enabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps (self, account, NULL, NULL);
}


static void _contacts_store_check_account_caps_tp_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	contacts_store_check_account_caps (self, account, NULL, NULL);
}


static gboolean contacts_store_check_call_capabilities_co (ContactsStoreCheckCallCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_account_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->calling_accounts);
	_data_->self->calling_accounts = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_account_manager_dup ();
	_data_->account_manager = _data_->_tmp1_;
	_data_->_state_ = 1;
	tp_proxy_prepare_async ((TpProxy*) _data_->account_manager, NULL, contacts_store_check_call_capabilities_ready, _data_);
	return FALSE;
	_state_1:
	tp_proxy_prepare_finish ((TpProxy*) _data_->account_manager, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->account_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_signal_connect_object (_data_->account_manager, "account-enabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_enabled, _data_->self, 0);
	g_signal_connect_object (_data_->account_manager, "account-disabled", (GCallback) _contacts_store_check_account_caps_tp_account_manager_account_disabled, _data_->self, 0);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = tp_account_manager_get_valid_accounts (_data_->account_manager);
	{
		_data_->account_collection = _data_->_tmp2_;
		_data_->account_it = NULL;
		for (_data_->account_it = _data_->account_collection; _data_->account_it != NULL; _data_->account_it = _data_->account_it->next) {
			_data_->account = (TpAccount*) _data_->account_it->data;
			{
				_data_->_tmp3_ = _data_->account;
				_data_->_state_ = 2;
				contacts_store_check_account_caps (_data_->self, _data_->_tmp3_, contacts_store_check_call_capabilities_ready, _data_);
				return FALSE;
				_state_2:
				contacts_store_check_account_caps_finish (_data_->self, _data_->_res_);
			}
		}
		_g_list_free0 (_data_->account_collection);
	}
	_g_object_unref0 (_data_->account_manager);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_store_check_account_caps_data_free (gpointer _data) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreCheckAccountCapsData, _data_);
}


static void contacts_store_check_account_caps (ContactsStore* self, TpAccount* account, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	ContactsStore* _tmp0_;
	TpAccount* _tmp1_;
	TpAccount* _tmp2_;
	_data_ = g_slice_new0 (ContactsStoreCheckAccountCapsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_store_check_account_caps);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_store_check_account_caps_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->account = _tmp2_;
	contacts_store_check_account_caps_co (_data_);
}


static void contacts_store_check_account_caps_finish (ContactsStore* self, GAsyncResult* _res_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void contacts_store_check_account_caps_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsStoreCheckAccountCapsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_store_check_account_caps_co (_data_);
}


static gboolean contacts_store_check_account_caps_co (ContactsStoreCheckAccountCapsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0U;
	_data_->_tmp0_ = tp_account_get_feature_quark_addressing ();
	_data_->addressing = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->account;
	_data_->_tmp2_ = _data_->addressing;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = tp_proxy_is_prepared ((TpProxy*) _data_->_tmp1_, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->_tmp4_ = _data_->addressing;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_new0 (GQuark, 1);
		_data_->_tmp5_[0] = _data_->_tmp4_;
		_data_->features = _data_->_tmp5_;
		_data_->features_length1 = 1;
		_data_->_features_size_ = _data_->features_length1;
		_data_->_tmp6_ = _data_->account;
		_data_->_tmp7_ = _data_->features;
		_data_->_tmp7__length1 = _data_->features_length1;
		_data_->_state_ = 1;
		tp_proxy_prepare_async ((TpProxy*) _data_->_tmp6_, _data_->_tmp7_, contacts_store_check_account_caps_ready, _data_);
		return FALSE;
		_state_1:
		tp_proxy_prepare_finish ((TpProxy*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_data_->features = (g_free (_data_->features), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->features = (g_free (_data_->features), NULL);
	}
	_data_->_tmp8_ = _data_->account;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = tp_proxy_get_object_path ((TpProxy*) _data_->_tmp8_);
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_data_->k = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->account;
	_data_->_tmp13_ = FALSE;
	_data_->_tmp13_ = tp_account_is_enabled (_data_->_tmp12_);
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = _data_->account;
		_data_->_tmp15_ = FALSE;
		_data_->_tmp15_ = tp_account_associated_with_uri_scheme (_data_->_tmp14_, "tel");
		_data_->_tmp11_ = _data_->_tmp15_;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	_data_->_tmp16_ = _data_->_tmp11_;
	if (_data_->_tmp16_) {
		_data_->_tmp17_ = _data_->self->calling_accounts;
		_data_->_tmp18_ = _data_->k;
		_data_->_tmp19_ = _data_->account;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_);
	} else {
		_data_->_tmp20_ = _data_->self->calling_accounts;
		_data_->_tmp21_ = _data_->k;
		gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp20_, _data_->_tmp21_, NULL);
	}
	_g_free0 (_data_->k);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self) {
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}


static void contacts_store_set_aggregator (ContactsStore* self, FolksIndividualAggregator* value) {
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregator);
	self->priv->_aggregator = _tmp1_;
	g_object_notify ((GObject *) self, "aggregator");
}


gboolean contacts_store_get_can_call (ContactsStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->calling_accounts;
	_tmp2_ = gee_map_get_size ((GeeMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


static void contacts_store_class_init (ContactsStoreClass * klass) {
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_AGGREGATOR, g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_CAN_CALL, g_param_spec_boolean ("can-call", "can-call", "can-call", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("changed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("added", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("removed", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
}


static void contacts_store_instance_init (ContactsStore * self) {
	self->priv = CONTACTS_STORE_GET_PRIVATE (self);
}


static void contacts_store_finalize (GObject* obj) {
	ContactsStore * self;
	self = CONTACTS_STORE (obj);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->contacts);
	_g_object_unref0 (self->calling_accounts);
	G_OBJECT_CLASS (contacts_store_parent_class)->finalize (obj);
}


GType contacts_store_get_type (void) {
	static volatile gsize contacts_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, NULL };
		GType contacts_store_type_id;
		contacts_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsStore", &g_define_type_info, 0);
		g_once_init_leave (&contacts_store_type_id__volatile, contacts_store_type_id);
	}
	return contacts_store_type_id__volatile;
}


static void _vala_contacts_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = CONTACTS_STORE (object);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		g_value_set_object (value, contacts_store_get_aggregator (self));
		break;
		case CONTACTS_STORE_CAN_CALL:
		g_value_set_boolean (value, contacts_store_get_can_call (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsStore * self;
	self = CONTACTS_STORE (object);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR:
		contacts_store_set_aggregator (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



