/* contacts-list-pane.c generated by valac 0.13.1.211-6e21, the Vala compiler
 * generated from contacts-list-pane.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>


#define CONTACTS_TYPE_CELL_RENDERER_SHAPE (contacts_cell_renderer_shape_get_type ())
#define CONTACTS_CELL_RENDERER_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShape))
#define CONTACTS_CELL_RENDERER_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapeClass))
#define CONTACTS_IS_CELL_RENDERER_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE))
#define CONTACTS_IS_CELL_RENDERER_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CELL_RENDERER_SHAPE))
#define CONTACTS_CELL_RENDERER_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapeClass))

typedef struct _ContactsCellRendererShape ContactsCellRendererShape;
typedef struct _ContactsCellRendererShapeClass ContactsCellRendererShapeClass;
typedef struct _ContactsCellRendererShapePrivate ContactsCellRendererShapePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _contacts_store_unref0(var) ((var == NULL) ? NULL : (var = (contacts_store_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _ContactsCellRendererShape {
	GtkCellRenderer parent_instance;
	ContactsCellRendererShapePrivate * priv;
};

struct _ContactsCellRendererShapeClass {
	GtkCellRendererClass parent_class;
};

struct _ContactsCellRendererShapePrivate {
	GtkWidget* current_widget;
	gchar* _name;
	FolksPresenceType _presence;
	gchar* _message;
	gboolean _is_phone;
	gint _wrap_width;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkEntry* filter_entry;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _ContactsListPanePrivate {
	ContactsStore* contacts_store;
	GtkTreeView* contacts_tree_view;
	guint filter_entry_changed_id;
	ContactsCellRendererShape* shape;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};


static gpointer contacts_cell_renderer_shape_parent_class = NULL;
static gpointer contacts_list_pane_parent_class = NULL;

GType contacts_cell_renderer_shape_get_type (void) G_GNUC_CONST;
#define CONTACTS_CELL_RENDERER_SHAPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CELL_RENDERER_SHAPE, ContactsCellRendererShapePrivate))
enum  {
	CONTACTS_CELL_RENDERER_SHAPE_DUMMY_PROPERTY,
	CONTACTS_CELL_RENDERER_SHAPE_NAME,
	CONTACTS_CELL_RENDERER_SHAPE_PRESENCE,
	CONTACTS_CELL_RENDERER_SHAPE_MESSAGE,
	CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE,
	CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH
};
#define CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE 14
static GdkPixbuf* contacts_cell_renderer_shape_create_symbolic_pixbuf (ContactsCellRendererShape* self, GtkWidget* widget, const gchar* icon_name, gint size);
gchar* contacts_contact_presence_to_class (FolksPresenceType presence);
FolksPresenceType contacts_cell_renderer_shape_get_presence (ContactsCellRendererShape* self);
static PangoLayout* contacts_cell_renderer_shape_get_layout (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* contacts_cell_renderer_shape_get_name (ContactsCellRendererShape* self);
gchar* contacts_contact_presence_to_icon (FolksPresenceType presence);
static gpointer _g_strdup_pango_attr_data_copy_func (gconstpointer data);
static void _g_free0_ (gpointer var);
const gchar* contacts_cell_renderer_shape_get_message (ContactsCellRendererShape* self);
gchar* contacts_contact_presence_to_string (FolksPresenceType presence);
gboolean contacts_cell_renderer_shape_get_is_phone (ContactsCellRendererShape* self);
gint contacts_cell_renderer_shape_get_wrap_width (ContactsCellRendererShape* self);
static void contacts_cell_renderer_shape_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void contacts_cell_renderer_shape_do_get_size (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* _layout, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void contacts_cell_renderer_shape_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
static void contacts_cell_renderer_shape_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width);
static void contacts_cell_renderer_shape_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height);
static void contacts_cell_renderer_shape_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size);
void contacts_cell_renderer_shape_render_shape (ContactsCellRendererShape* self, cairo_t* cr, PangoAttrShape* attr, gboolean do_path);
ContactsCellRendererShape* contacts_cell_renderer_shape_new (void);
ContactsCellRendererShape* contacts_cell_renderer_shape_construct (GType object_type);
void contacts_cell_renderer_shape_set_name (ContactsCellRendererShape* self, const gchar* value);
void contacts_cell_renderer_shape_set_presence (ContactsCellRendererShape* self, FolksPresenceType value);
void contacts_cell_renderer_shape_set_message (ContactsCellRendererShape* self, const gchar* value);
void contacts_cell_renderer_shape_set_is_phone (ContactsCellRendererShape* self, gboolean value);
void contacts_cell_renderer_shape_set_wrap_width (ContactsCellRendererShape* self, gint value);
static void contacts_cell_renderer_shape_finalize (GObject* obj);
static void _vala_contacts_cell_renderer_shape_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_cell_renderer_shape_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
gpointer contacts_store_ref (gpointer instance);
void contacts_store_unref (gpointer instance);
GParamSpec* contacts_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_store (GValue* value, gpointer v_object);
void contacts_value_take_store (GValue* value, gpointer v_object);
gpointer contacts_value_get_store (const GValue* value);
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_LIST_PANE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_LIST_PANE, ContactsListPanePrivate))
enum  {
	CONTACTS_LIST_PANE_DUMMY_PROPERTY
};
static void contacts_list_pane_setup_contacts_view (ContactsListPane* self, GtkTreeView* tree_view);
static void contacts_list_pane_contacts_selection_changed (ContactsListPane* self, GtkTreeSelection* selection);
static void _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda8_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
GType contacts_contact_get_type (void) G_GNUC_CONST;
gboolean contacts_store_is_first (ContactsStore* self, GtkTreeIter* iter);
gunichar contacts_contact_get_initial_letter (ContactsContact* self);
static void ___lambda8__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void __lambda9_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
GdkPixbuf* contacts_contact_get_avatar (ContactsContact* self);
static void ___lambda9__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func (cairo_t* cr, PangoAttrShape* attr, gboolean do_path, gpointer self);
static void __lambda10_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void ___lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void contacts_list_pane_refilter (ContactsListPane* self);
void contacts_store_set_filter_values (ContactsStore* self, gchar** values, int values_length1);
static gboolean contacts_list_pane_filter_entry_changed_timeout (ContactsListPane* self);
static void contacts_list_pane_filter_entry_changed (ContactsListPane* self, GtkEditable* editable);
static gboolean _contacts_list_pane_filter_entry_changed_timeout_gsource_func (gpointer self);
static void contacts_list_pane_filter_entry_clear (ContactsListPane* self, GtkEntryIconPosition position);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void _contacts_list_pane_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void __lambda11_ (ContactsListPane* self, GtkToolButton* button);
static void ___lambda11__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GtkTreeModel* contacts_store_get_model (ContactsStore* self);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact);
gboolean contacts_store_lookup_iter (ContactsStore* self, ContactsContact* c, GtkTreeIter* iter);
static void contacts_list_pane_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_cell_renderer_shape_create_symbolic_pixbuf (ContactsCellRendererShape* self, GtkWidget* widget, const gchar* icon_name, gint size) {
	GdkPixbuf* result = NULL;
	GtkWidget* _tmp0_;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* screen;
	GdkScreen* _tmp3_;
	GtkIconTheme* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_;
	GtkIconTheme* icon_theme;
	GtkIconTheme* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	GtkIconInfo* _tmp9_ = NULL;
	GtkIconInfo* info;
	GtkIconInfo* _tmp10_;
	GtkWidget* _tmp11_;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* context;
	GtkStyleContext* _tmp14_;
	gboolean is_symbolic = FALSE;
	GtkStyleContext* _tmp15_;
	FolksPresenceType _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	GdkPixbuf* pixbuf;
	GtkStyleContext* _tmp24_;
	gboolean _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_screen (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	_tmp3_ = screen;
	_tmp4_ = gtk_icon_theme_get_for_screen (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	icon_theme = _tmp5_;
	_tmp6_ = icon_theme;
	_tmp7_ = icon_name;
	_tmp8_ = size;
	_tmp9_ = gtk_icon_theme_lookup_icon (_tmp6_, _tmp7_, _tmp8_, GTK_ICON_LOOKUP_USE_BUILTIN);
	info = _tmp9_;
	_tmp10_ = info;
	if (_tmp10_ == NULL) {
		result = NULL;
		_gtk_icon_info_free0 (info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (screen);
		return result;
	}
	_tmp11_ = widget;
	_tmp12_ = gtk_widget_get_style_context (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	context = _tmp13_;
	_tmp14_ = context;
	gtk_style_context_save (_tmp14_);
	_tmp15_ = context;
	_tmp16_ = self->priv->_presence;
	_tmp17_ = contacts_contact_presence_to_class (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_style_context_add_class (_tmp15_, _tmp18_);
	_g_free0 (_tmp18_);
	pixbuf = NULL;
	{
		GtkIconInfo* _tmp19_;
		GtkStyleContext* _tmp20_;
		gboolean _tmp21_ = FALSE;
		GdkPixbuf* _tmp22_ = NULL;
		GdkPixbuf* _tmp23_;
		_tmp19_ = info;
		_tmp20_ = context;
		_tmp22_ = gtk_icon_info_load_symbolic_for_context (_tmp19_, _tmp20_, &_tmp21_, &_inner_error_);
		is_symbolic = _tmp21_;
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp23_;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (context);
		_gtk_icon_info_free0 (info);
		_g_object_unref0 (icon_theme);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp24_ = context;
	gtk_style_context_restore (_tmp24_);
	_tmp25_ = is_symbolic;
	if (!_tmp25_) {
		_g_object_unref0 (pixbuf);
		pixbuf = NULL;
	}
	result = pixbuf;
	_g_object_unref0 (context);
	_gtk_icon_info_free0 (info);
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (screen);
	return result;
}


static gpointer _g_strdup_pango_attr_data_copy_func (gconstpointer data) {
	gpointer result;
	result = g_strdup (data);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static PangoLayout* contacts_cell_renderer_shape_get_layout (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags) {
	PangoLayout* result = NULL;
	PangoLayout* layout = NULL;
	gint xpad = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* str;
	PangoAttrList* _tmp2_;
	PangoAttrList* attr_list;
	PangoAttribute* _tmp3_ = NULL;
	PangoAttribute* a;
	PangoAttribute* _tmp4_;
	PangoAttribute* _tmp5_;
	PangoAttribute* _tmp6_;
	guint _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	PangoAttrList* _tmp11_;
	PangoAttribute* _tmp12_;
	FolksPresenceType _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* iconname;
	const gchar* _tmp15_;
	GtkWidget* _tmp62_;
	const gchar* _tmp63_;
	PangoLayout* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	PangoLayout* _tmp66_;
	PangoAttrList* _tmp67_;
	PangoLayout* _tmp68_;
	gint _tmp69_;
	PangoLayout* _tmp85_;
	PangoLayout* _tmp86_;
	PangoAlignment align = 0;
	GtkWidget* _tmp87_;
	GtkTextDirection _tmp88_ = 0;
	PangoLayout* _tmp89_;
	PangoAlignment _tmp90_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = pango_attr_list_new ();
	attr_list = _tmp2_;
	_tmp3_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	a = _tmp3_;
	_tmp4_ = a;
	_tmp4_->start_index = (guint) 0;
	_tmp5_ = a;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->start_index;
	_tmp8_ = str;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp5_->end_index = _tmp7_ + _tmp10_;
	_tmp11_ = attr_list;
	_tmp12_ = a;
	a = NULL;
	pango_attr_list_insert (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->_presence;
	_tmp14_ = contacts_contact_presence_to_icon (_tmp13_);
	iconname = _tmp14_;
	_tmp15_ = iconname;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		PangoRectangle _tmp18_ = {0};
		PangoRectangle r;
		PangoRectangle _tmp19_;
		PangoRectangle _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		PangoAttrShape* _tmp23_;
		PangoAttribute* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		PangoAttribute* _tmp28_;
		PangoAttribute* _tmp29_;
		guint _tmp30_;
		PangoAttrList* _tmp31_;
		PangoAttribute* _tmp32_;
		const gchar* _tmp33_;
		_tmp16_ = str;
		_tmp17_ = g_strconcat (_tmp16_, "\xE2\x80\xA8*", NULL);
		_g_free0 (str);
		str = _tmp17_;
		_tmp18_.x = 0;
		_tmp18_.y = (((-CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE) * 1024) * 9) / 10;
		_tmp18_.width = CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 1024;
		_tmp18_.height = CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 1024;
		r = _tmp18_;
		_tmp19_ = r;
		_tmp20_ = r;
		_tmp21_ = iconname;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = (PangoAttrShape*) pango_attr_shape_new_with_data (&_tmp19_, &_tmp20_, _tmp22_, _g_strdup_pango_attr_data_copy_func, _g_free0_);
		_pango_attribute_destroy0 (a);
		a = (PangoAttribute*) _tmp23_;
		_tmp24_ = a;
		_tmp25_ = str;
		_tmp26_ = strlen (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp24_->start_index = (guint) (_tmp27_ - 1);
		_tmp28_ = a;
		_tmp29_ = a;
		_tmp30_ = _tmp29_->start_index;
		_tmp28_->end_index = _tmp30_ + 1;
		_tmp31_ = attr_list;
		_tmp32_ = a;
		a = NULL;
		pango_attr_list_insert (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->_message;
		if (_tmp33_ != NULL) {
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* m;
			const gchar* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gboolean _tmp46_;
			_tmp34_ = self->priv->_message;
			_tmp35_ = g_strdup (_tmp34_);
			m = _tmp35_;
			_tmp36_ = m;
			_tmp37_ = strlen (_tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_ == 0) {
				FolksPresenceType _tmp39_;
				gchar* _tmp40_ = NULL;
				_tmp39_ = self->priv->_presence;
				_tmp40_ = contacts_contact_presence_to_string (_tmp39_);
				_g_free0 (m);
				m = _tmp40_;
			}
			_tmp41_ = str;
			_tmp42_ = m;
			_tmp43_ = g_strconcat (" ", _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp41_, _tmp44_, NULL);
			_g_free0 (str);
			str = _tmp45_;
			_g_free0 (_tmp44_);
			_tmp46_ = self->priv->_is_phone;
			if (_tmp46_) {
				GtkCellRendererState _tmp47_;
				PangoAttribute* _tmp50_;
				const gchar* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				PangoAttribute* _tmp56_;
				const gchar* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				PangoAttrList* _tmp60_;
				PangoAttribute* _tmp61_;
				_tmp47_ = flags;
				if ((_tmp47_ & GTK_CELL_RENDERER_SELECTED) != 0) {
					PangoAttribute* _tmp48_ = NULL;
					_tmp48_ = pango_attr_foreground_new ((guint16) (0xffff - 0x8e8e), (guint16) (0xffff - 0x9191), (guint16) (0xffff - 0x9292));
					_pango_attribute_destroy0 (a);
					a = _tmp48_;
				} else {
					PangoAttribute* _tmp49_ = NULL;
					_tmp49_ = pango_attr_foreground_new ((guint16) 0x8e8e, (guint16) 0x9191, (guint16) 0x9292);
					_pango_attribute_destroy0 (a);
					a = _tmp49_;
				}
				_tmp50_ = a;
				_tmp51_ = str;
				_tmp52_ = strlen (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp50_->start_index = (guint) _tmp53_;
				_tmp54_ = str;
				_tmp55_ = g_strconcat (_tmp54_, " (via phone)", NULL);
				_g_free0 (str);
				str = _tmp55_;
				_tmp56_ = a;
				_tmp57_ = str;
				_tmp58_ = strlen (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp56_->end_index = (guint) _tmp59_;
				_tmp60_ = attr_list;
				_tmp61_ = a;
				a = NULL;
				pango_attr_list_insert (_tmp60_, _tmp61_);
			}
			_g_free0 (m);
		}
	}
	_tmp62_ = widget;
	_tmp63_ = str;
	_tmp64_ = gtk_widget_create_pango_layout (_tmp62_, _tmp63_);
	_g_object_unref0 (layout);
	layout = _tmp64_;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp65_, NULL);
	xpad = _tmp65_;
	_tmp66_ = layout;
	_tmp67_ = attr_list;
	pango_layout_set_attributes (_tmp66_, _tmp67_);
	_tmp68_ = layout;
	pango_layout_set_ellipsize (_tmp68_, PANGO_ELLIPSIZE_END);
	_tmp69_ = self->priv->_wrap_width;
	if (_tmp69_ != (-1)) {
		PangoRectangle rect = {0};
		gint width = 0;
		gint text_width = 0;
		PangoLayout* _tmp70_;
		PangoRectangle _tmp71_ = {0};
		PangoRectangle _tmp72_;
		gint _tmp73_;
		GdkRectangle* _tmp74_;
		gint _tmp79_;
		gint _tmp80_;
		gint _tmp81_ = 0;
		PangoLayout* _tmp82_;
		gint _tmp83_;
		_tmp70_ = layout;
		pango_layout_get_extents (_tmp70_, NULL, &_tmp71_);
		rect = _tmp71_;
		_tmp72_ = rect;
		_tmp73_ = _tmp72_.width;
		text_width = _tmp73_;
		_tmp74_ = cell_area;
		if (_tmp74_ != NULL) {
			GdkRectangle* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			_tmp75_ = cell_area;
			_tmp76_ = (*_tmp75_).width;
			_tmp77_ = xpad;
			width = (_tmp76_ - (_tmp77_ * 2)) * PANGO_SCALE;
		} else {
			gint _tmp78_;
			_tmp78_ = self->priv->_wrap_width;
			width = _tmp78_ * PANGO_SCALE;
		}
		_tmp79_ = width;
		_tmp80_ = text_width;
		_tmp81_ = MIN (_tmp79_, _tmp80_);
		width = _tmp81_;
		_tmp82_ = layout;
		_tmp83_ = width;
		pango_layout_set_width (_tmp82_, _tmp83_);
	} else {
		PangoLayout* _tmp84_;
		_tmp84_ = layout;
		pango_layout_set_width (_tmp84_, -1);
	}
	_tmp85_ = layout;
	pango_layout_set_wrap (_tmp85_, PANGO_WRAP_CHAR);
	_tmp86_ = layout;
	pango_layout_set_height (_tmp86_, -2);
	_tmp87_ = widget;
	_tmp88_ = gtk_widget_get_direction (_tmp87_);
	if (_tmp88_ == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	_tmp89_ = layout;
	_tmp90_ = align;
	pango_layout_set_alignment (_tmp89_, _tmp90_);
	result = layout;
	_g_free0 (iconname);
	_pango_attribute_destroy0 (a);
	_pango_attr_list_unref0 (attr_list);
	_g_free0 (str);
	return result;
}


static void contacts_cell_renderer_shape_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	ContactsCellRendererShape * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void contacts_cell_renderer_shape_do_get_size (ContactsCellRendererShape* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* _layout, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoLayout* _tmp7_;
	PangoRectangle _tmp8_ = {0};
	GdkRectangle* _tmp9_;
	gint _tmp31_;
	PangoRectangle _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	PangoRectangle _tmp35_;
	gint _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	_tmp2_ = _layout;
	if (_tmp2_ == NULL) {
		GtkWidget* _tmp3_;
		PangoLayout* _tmp4_ = NULL;
		_tmp3_ = widget;
		_tmp4_ = contacts_cell_renderer_shape_get_layout (self, _tmp3_, NULL, 0);
		_g_object_unref0 (layout);
		layout = _tmp4_;
	} else {
		PangoLayout* _tmp5_;
		PangoLayout* _tmp6_;
		_tmp5_ = _layout;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (layout);
		layout = _tmp6_;
	}
	_tmp7_ = layout;
	pango_layout_get_pixel_extents (_tmp7_, NULL, &_tmp8_);
	rect = _tmp8_;
	_tmp9_ = cell_area;
	if (_tmp9_ != NULL) {
		PangoRectangle _tmp10_;
		gint _tmp11_;
		GdkRectangle* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_ = 0;
		PangoRectangle _tmp16_;
		gint _tmp17_;
		GdkRectangle* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_ = 0;
		GtkWidget* _tmp22_;
		GtkTextDirection _tmp23_ = 0;
		gint _tmp29_;
		gint _tmp30_ = 0;
		_tmp10_ = rect;
		_tmp11_ = _tmp10_.height;
		_tmp12_ = cell_area;
		_tmp13_ = (*_tmp12_).height;
		_tmp14_ = ypad;
		_tmp15_ = MIN (_tmp11_, _tmp13_ - (2 * _tmp14_));
		rect.height = _tmp15_;
		_tmp16_ = rect;
		_tmp17_ = _tmp16_.width;
		_tmp18_ = cell_area;
		_tmp19_ = (*_tmp18_).width;
		_tmp20_ = xpad;
		_tmp21_ = MIN (_tmp17_, _tmp19_ - (2 * _tmp20_));
		rect.width = _tmp21_;
		_tmp22_ = widget;
		_tmp23_ = gtk_widget_get_direction (_tmp22_);
		if (_tmp23_ == GTK_TEXT_DIR_RTL) {
			GdkRectangle* _tmp24_;
			gint _tmp25_;
			PangoRectangle _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp24_ = cell_area;
			_tmp25_ = (*_tmp24_).width;
			_tmp26_ = rect;
			_tmp27_ = _tmp26_.width;
			_tmp28_ = xpad;
			_vala_x_offset = _tmp25_ - (_tmp27_ + (2 * _tmp28_));
		} else {
			_vala_x_offset = 0;
		}
		_tmp29_ = _vala_x_offset;
		_tmp30_ = MAX (_tmp29_, 0);
		_vala_x_offset = _tmp30_;
		_vala_y_offset = 0;
	} else {
		_vala_x_offset = 0;
		_vala_y_offset = 0;
	}
	_tmp31_ = ypad;
	_tmp32_ = rect;
	_tmp33_ = _tmp32_.height;
	_vala_height = (_tmp31_ * 2) + _tmp33_;
	_tmp34_ = xpad;
	_tmp35_ = rect;
	_tmp36_ = _tmp35_.width;
	_vala_width = (_tmp34_ * 2) + _tmp36_;
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void contacts_cell_renderer_shape_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	ContactsCellRendererShape * self;
	GtkStyleContext* context = NULL;
	PangoLayout* layout = NULL;
	gint x_offset;
	gint y_offset;
	gint xpad = 0;
	gint ypad = 0;
	PangoRectangle rect = {0};
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GdkRectangle _tmp3_;
	GtkCellRendererState _tmp4_;
	PangoLayout* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GdkRectangle _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkWidget* _tmp10_;
	GtkStyleContext* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkRectangle _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	PangoRectangle _tmp18_ = {0};
	gint _tmp19_;
	PangoRectangle _tmp20_;
	gint _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	GdkRectangle _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	GdkRectangle _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GdkRectangle _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	cairo_t* _tmp33_;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	x_offset = 0;
	y_offset = 0;
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = *cell_area;
	_tmp4_ = flags;
	_tmp5_ = contacts_cell_renderer_shape_get_layout (self, _tmp2_, &_tmp3_, _tmp4_);
	_g_object_unref0 (layout);
	layout = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = *cell_area;
	contacts_cell_renderer_shape_do_get_size (self, _tmp6_, &_tmp7_, layout, &_tmp8_, &_tmp9_, NULL, NULL);
	x_offset = _tmp8_;
	y_offset = _tmp9_;
	_tmp10_ = widget;
	_tmp11_ = gtk_widget_get_style_context (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (context);
	context = _tmp12_;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp13_, &_tmp14_);
	xpad = _tmp13_;
	ypad = _tmp14_;
	_tmp15_ = *cell_area;
	_tmp16_ = _tmp15_.width;
	_tmp17_ = x_offset;
	pango_layout_set_width (layout, ((_tmp16_ - _tmp17_) - (2 * xpad)) * PANGO_SCALE);
	pango_layout_get_pixel_extents (layout, NULL, &_tmp18_);
	rect = _tmp18_;
	_tmp19_ = x_offset;
	_tmp20_ = rect;
	_tmp21_ = _tmp20_.x;
	x_offset = _tmp19_ - _tmp21_;
	_tmp22_ = cr;
	cairo_save (_tmp22_);
	_tmp23_ = cr;
	_tmp24_ = *cell_area;
	gdk_cairo_rectangle (_tmp23_, &_tmp24_);
	_tmp25_ = cr;
	cairo_clip (_tmp25_);
	_tmp26_ = cr;
	_tmp27_ = *cell_area;
	_tmp28_ = _tmp27_.x;
	_tmp29_ = x_offset;
	_tmp30_ = *cell_area;
	_tmp31_ = _tmp30_.y;
	_tmp32_ = y_offset;
	gtk_render_layout (context, _tmp26_, (gdouble) ((_tmp28_ + _tmp29_) + xpad), (gdouble) ((_tmp31_ + _tmp32_) + ypad), layout);
	_tmp33_ = cr;
	cairo_restore (_tmp33_);
	_g_object_unref0 (layout);
	_g_object_unref0 (context);
}


static void contacts_cell_renderer_shape_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width) {
	ContactsCellRendererShape * self;
	gint _vala_min_width = 0;
	gint _vala_nat_width = 0;
	PangoRectangle rect = {0};
	gint text_width = 0;
	gint xpad = 0;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_;
	PangoLayout* _tmp2_ = NULL;
	PangoLayout* layout;
	PangoRectangle _tmp3_ = {0};
	PangoRectangle _tmp4_;
	gint _tmp5_;
	PangoRectangle _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_;
	gint _tmp11_ = 0;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_tmp1_ = widget;
	_tmp2_ = contacts_cell_renderer_shape_get_layout (self, _tmp1_, NULL, 0);
	layout = _tmp2_;
	pango_layout_set_width (layout, -1);
	pango_layout_get_extents (layout, NULL, &_tmp3_);
	rect = _tmp3_;
	_tmp4_ = rect;
	_tmp5_ = _tmp4_.width;
	text_width = _tmp5_;
	_tmp6_ = rect;
	_tmp7_ = _tmp6_.x;
	_tmp8_ = self->priv->_wrap_width;
	_tmp9_ = MIN (text_width / PANGO_SCALE, _tmp8_);
	_vala_min_width = ((xpad * 2) + _tmp7_) + _tmp9_;
	_vala_nat_width = (xpad * 2) + (text_width / PANGO_SCALE);
	_tmp10_ = _vala_nat_width;
	_tmp11_ = MAX (_tmp10_, _vala_min_width);
	_vala_nat_width = _tmp11_;
	_g_object_unref0 (layout);
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (nat_width) {
		*nat_width = _vala_nat_width;
	}
}


static void contacts_cell_renderer_shape_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height) {
	ContactsCellRendererShape * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	PangoLayout* layout = NULL;
	gint text_height = 0;
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkWidget* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_ = 0;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = contacts_cell_renderer_shape_get_layout (self, _tmp2_, NULL, 0);
	_g_object_unref0 (layout);
	layout = _tmp3_;
	_tmp4_ = width;
	pango_layout_set_width (layout, (_tmp4_ - (xpad * 2)) * PANGO_SCALE);
	pango_layout_get_pixel_size (layout, NULL, &_tmp5_);
	text_height = _tmp5_;
	_vala_minimum_height = text_height + (ypad * 2);
	_vala_natural_height = text_height + (ypad * 2);
	_g_object_unref0 (layout);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void contacts_cell_renderer_shape_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size) {
	ContactsCellRendererShape * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint min_width = 0;
	GtkWidget* _tmp0_;
	gint _tmp1_ = 0;
	GtkWidget* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (ContactsCellRendererShape*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, _tmp0_, &_tmp1_, NULL);
	min_width = _tmp1_;
	_tmp2_ = widget;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, _tmp2_, min_width, &_tmp3_, &_tmp4_);
	_vala_minimum_size = _tmp3_;
	_vala_natural_size = _tmp4_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}


void contacts_cell_renderer_shape_render_shape (ContactsCellRendererShape* self, cairo_t* cr, PangoAttrShape* attr, gboolean do_path) {
	PangoAttrShape* _tmp0_;
	PangoAttrShape* sattr;
	GtkWidget* _tmp1_;
	PangoAttrShape* _tmp2_;
	gconstpointer _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (attr != NULL);
	_tmp0_ = attr;
	sattr = (PangoAttrShape*) _tmp0_;
	_tmp1_ = self->priv->current_widget;
	_tmp2_ = sattr;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = contacts_cell_renderer_shape_create_symbolic_pixbuf (self, _tmp1_, (const gchar*) _tmp3_, CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE);
	pixbuf = _tmp4_;
	_tmp5_ = pixbuf;
	if (_tmp5_ != NULL) {
		gdouble x = 0.0;
		gdouble y = 0.0;
		cairo_t* _tmp6_;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		cairo_t* _tmp9_;
		GdkPixbuf* _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		cairo_t* _tmp13_;
		_tmp6_ = cr;
		cairo_get_current_point (_tmp6_, &_tmp7_, &_tmp8_);
		x = _tmp7_;
		y = _tmp8_;
		_tmp9_ = cr;
		_tmp10_ = pixbuf;
		_tmp11_ = x;
		_tmp12_ = y;
		gdk_cairo_set_source_pixbuf (_tmp9_, _tmp10_, _tmp11_, _tmp12_ - (CONTACTS_CELL_RENDERER_SHAPE_IMAGE_SIZE * 0.9));
		_tmp13_ = cr;
		cairo_paint (_tmp13_);
	}
	_g_object_unref0 (pixbuf);
}


ContactsCellRendererShape* contacts_cell_renderer_shape_construct (GType object_type) {
	ContactsCellRendererShape * self = NULL;
	self = (ContactsCellRendererShape*) g_object_new (object_type, NULL);
	return self;
}


ContactsCellRendererShape* contacts_cell_renderer_shape_new (void) {
	return contacts_cell_renderer_shape_construct (CONTACTS_TYPE_CELL_RENDERER_SHAPE);
}


const gchar* contacts_cell_renderer_shape_get_name (ContactsCellRendererShape* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void contacts_cell_renderer_shape_set_name (ContactsCellRendererShape* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


FolksPresenceType contacts_cell_renderer_shape_get_presence (ContactsCellRendererShape* self) {
	FolksPresenceType result;
	FolksPresenceType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_presence;
	result = _tmp0_;
	return result;
}


void contacts_cell_renderer_shape_set_presence (ContactsCellRendererShape* self, FolksPresenceType value) {
	FolksPresenceType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_presence = _tmp0_;
	g_object_notify ((GObject *) self, "presence");
}


const gchar* contacts_cell_renderer_shape_get_message (ContactsCellRendererShape* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_message;
	result = _tmp0_;
	return result;
}


void contacts_cell_renderer_shape_set_message (ContactsCellRendererShape* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_message);
	self->priv->_message = _tmp1_;
	g_object_notify ((GObject *) self, "message");
}


gboolean contacts_cell_renderer_shape_get_is_phone (ContactsCellRendererShape* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_phone;
	result = _tmp0_;
	return result;
}


void contacts_cell_renderer_shape_set_is_phone (ContactsCellRendererShape* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_phone = _tmp0_;
	g_object_notify ((GObject *) self, "is-phone");
}


gint contacts_cell_renderer_shape_get_wrap_width (ContactsCellRendererShape* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_wrap_width;
	result = _tmp0_;
	return result;
}


void contacts_cell_renderer_shape_set_wrap_width (ContactsCellRendererShape* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_wrap_width = _tmp0_;
	g_object_notify ((GObject *) self, "wrap-width");
}


static void contacts_cell_renderer_shape_class_init (ContactsCellRendererShapeClass * klass) {
	contacts_cell_renderer_shape_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsCellRendererShapePrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = contacts_cell_renderer_shape_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = contacts_cell_renderer_shape_real_render;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_width = contacts_cell_renderer_shape_real_get_preferred_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height_for_width = contacts_cell_renderer_shape_real_get_preferred_height_for_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height = contacts_cell_renderer_shape_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_cell_renderer_shape_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_cell_renderer_shape_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_cell_renderer_shape_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_PRESENCE, g_param_spec_enum ("presence", "presence", "presence", FOLKS_TYPE_PRESENCE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE, g_param_spec_boolean ("is-phone", "is-phone", "is-phone", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH, g_param_spec_int ("wrap-width", "wrap-width", "wrap-width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void contacts_cell_renderer_shape_instance_init (ContactsCellRendererShape * self) {
	self->priv = CONTACTS_CELL_RENDERER_SHAPE_GET_PRIVATE (self);
	self->priv->_wrap_width = -1;
}


static void contacts_cell_renderer_shape_finalize (GObject* obj) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (obj);
	_g_object_unref0 (self->priv->current_widget);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_message);
	G_OBJECT_CLASS (contacts_cell_renderer_shape_parent_class)->finalize (obj);
}


GType contacts_cell_renderer_shape_get_type (void) {
	static volatile gsize contacts_cell_renderer_shape_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_cell_renderer_shape_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsCellRendererShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_cell_renderer_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsCellRendererShape), 0, (GInstanceInitFunc) contacts_cell_renderer_shape_instance_init, NULL };
		GType contacts_cell_renderer_shape_type_id;
		contacts_cell_renderer_shape_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "ContactsCellRendererShape", &g_define_type_info, 0);
		g_once_init_leave (&contacts_cell_renderer_shape_type_id__volatile, contacts_cell_renderer_shape_type_id);
	}
	return contacts_cell_renderer_shape_type_id__volatile;
}


static void _vala_contacts_cell_renderer_shape_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (object);
	switch (property_id) {
		case CONTACTS_CELL_RENDERER_SHAPE_NAME:
		g_value_set_string (value, contacts_cell_renderer_shape_get_name (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_PRESENCE:
		g_value_set_enum (value, contacts_cell_renderer_shape_get_presence (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_MESSAGE:
		g_value_set_string (value, contacts_cell_renderer_shape_get_message (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE:
		g_value_set_boolean (value, contacts_cell_renderer_shape_get_is_phone (self));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH:
		g_value_set_int (value, contacts_cell_renderer_shape_get_wrap_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_cell_renderer_shape_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsCellRendererShape * self;
	self = CONTACTS_CELL_RENDERER_SHAPE (object);
	switch (property_id) {
		case CONTACTS_CELL_RENDERER_SHAPE_NAME:
		contacts_cell_renderer_shape_set_name (self, g_value_get_string (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_PRESENCE:
		contacts_cell_renderer_shape_set_presence (self, g_value_get_enum (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_MESSAGE:
		contacts_cell_renderer_shape_set_message (self, g_value_get_string (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_IS_PHONE:
		contacts_cell_renderer_shape_set_is_phone (self, g_value_get_boolean (value));
		break;
		case CONTACTS_CELL_RENDERER_SHAPE_WRAP_WIDTH:
		contacts_cell_renderer_shape_set_wrap_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	contacts_list_pane_contacts_selection_changed (self, _sender);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void __lambda8_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ContactsContact* contact = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gchar* _tmp2_;
	gchar* letter;
	ContactsStore* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkCellRenderer* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, 0, &contact, -1);
	_tmp2_ = g_strdup ("");
	letter = _tmp2_;
	_tmp3_ = self->priv->contacts_store;
	_tmp4_ = *iter;
	_tmp5_ = contacts_store_is_first (_tmp3_, &_tmp4_);
	if (_tmp5_) {
		ContactsContact* _tmp6_;
		gunichar _tmp7_;
		gunichar _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp6_ = contact;
		_tmp7_ = contacts_contact_get_initial_letter (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_unichar_to_string (_tmp8_);
		_g_free0 (letter);
		letter = _tmp9_;
	}
	_tmp10_ = cell;
	_tmp11_ = letter;
	g_object_set ((GObject*) _tmp10_, "text", _tmp11_, NULL);
	_g_free0 (letter);
	_g_object_unref0 (contact);
}


static void ___lambda8__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda8_ (self, cell_layout, cell, tree_model, iter);
}


static void __lambda9_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ContactsContact* contact = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkCellRenderer* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, 0, &contact, -1);
	_tmp2_ = cell;
	_tmp3_ = contacts_contact_get_avatar (contact);
	_tmp4_ = _tmp3_;
	g_object_set ((GObject*) _tmp2_, "pixbuf", _tmp4_, NULL);
	_g_object_unref0 (contact);
}


static void ___lambda9__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda9_ (self, cell_layout, cell, tree_model, iter);
}


static void _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func (cairo_t* cr, PangoAttrShape* attr, gboolean do_path, gpointer self) {
	contacts_cell_renderer_shape_render_shape (self, cr, attr, do_path);
}


static void __lambda10_ (ContactsListPane* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ContactsContact* contact = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkCellRenderer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPresenceType _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, 0, &contact, -1);
	_tmp2_ = cell;
	_tmp3_ = contacts_contact_get_display_name (contact);
	_tmp4_ = _tmp3_;
	_tmp5_ = contact->presence_type;
	_tmp6_ = contact->presence_message;
	_tmp7_ = contact->is_phone;
	g_object_set ((GObject*) _tmp2_, "wrap_width", 230, "name", _tmp4_, "presence", _tmp5_, "message", _tmp6_, "is_phone", _tmp7_, NULL);
	_g_object_unref0 (contact);
}


static void ___lambda10__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda10_ (self, cell_layout, cell, tree_model, iter);
}


static void contacts_list_pane_setup_contacts_view (ContactsListPane* self, GtkTreeView* tree_view) {
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* selection;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* text;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkCellRendererPixbuf* _tmp10_;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererPixbuf* icon;
	GtkTreeViewColumn* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeViewColumn* _tmp15_;
	GtkTreeViewColumn* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	ContactsCellRendererShape* _tmp18_;
	ContactsCellRendererShape* _tmp19_;
	GtkTreeView* _tmp20_;
	PangoContext* _tmp21_ = NULL;
	ContactsCellRendererShape* _tmp22_;
	GtkTreeViewColumn* _tmp23_;
	ContactsCellRendererShape* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	ContactsCellRendererShape* _tmp26_;
	GtkTreeView* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_view != NULL);
	_tmp0_ = tree_view;
	gtk_tree_view_set_headers_visible (_tmp0_, FALSE);
	_tmp1_ = tree_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selection = _tmp3_;
	gtk_tree_selection_set_mode (selection, GTK_SELECTION_BROWSE);
	g_signal_connect_object (selection, "changed", (GCallback) _contacts_list_pane_contacts_selection_changed_gtk_tree_selection_changed, self, 0);
	_tmp4_ = gtk_tree_view_column_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	column = _tmp5_;
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	text = _tmp7_;
	gtk_cell_renderer_set_alignment ((GtkCellRenderer*) text, (gfloat) 0, (gfloat) 0);
	_tmp8_ = column;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) text, TRUE);
	g_object_set ((GObject*) text, "weight", PANGO_WEIGHT_BOLD, "scale", 1.28, "width", 24, NULL);
	_tmp9_ = column;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) text, ___lambda8__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp10_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp11_ = g_object_ref_sink (_tmp10_);
	icon = _tmp11_;
	_tmp12_ = column;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) icon, FALSE);
	_tmp13_ = column;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) icon, ___lambda9__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp14_ = tree_view;
	_tmp15_ = column;
	gtk_tree_view_append_column (_tmp14_, _tmp15_);
	_tmp16_ = gtk_tree_view_column_new ();
	_tmp17_ = g_object_ref_sink (_tmp16_);
	_g_object_unref0 (column);
	column = _tmp17_;
	_tmp18_ = contacts_cell_renderer_shape_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->shape);
	self->priv->shape = _tmp19_;
	_tmp20_ = tree_view;
	_tmp21_ = gtk_widget_get_pango_context ((GtkWidget*) _tmp20_);
	_tmp22_ = self->priv->shape;
	pango_cairo_context_set_shape_renderer (_tmp21_, _contacts_cell_renderer_shape_render_shape_pango_cairo_shape_renderer_func, g_object_ref (_tmp22_), g_object_unref);
	_tmp23_ = column;
	_tmp24_ = self->priv->shape;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp23_, (GtkCellRenderer*) _tmp24_, FALSE);
	_tmp25_ = column;
	_tmp26_ = self->priv->shape;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp25_, (GtkCellRenderer*) _tmp26_, ___lambda10__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp27_ = tree_view;
	_tmp28_ = column;
	gtk_tree_view_append_column (_tmp27_, _tmp28_);
	_g_object_unref0 (icon);
	_g_object_unref0 (text);
	_g_object_unref0 (column);
	_g_object_unref0 (selection);
}


static void contacts_list_pane_refilter (ContactsListPane* self) {
	gchar** values = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* str;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ContactsStore* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->filter_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	str = _tmp2_;
	_tmp3_ = str;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		values = NULL;
		values_length1 = 0;
		_values_size_ = values_length1;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_ = NULL;
		_tmp6_ = str;
		_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) (-1));
		_g_free0 (str);
		str = _tmp7_;
		_tmp8_ = str;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		values = _tmp10_;
		values_length1 = _vala_array_length (_tmp9_);
		_values_size_ = values_length1;
	}
	_tmp11_ = self->priv->contacts_store;
	_tmp12_ = values;
	_tmp12__length1 = values_length1;
	contacts_store_set_filter_values (_tmp11_, _tmp12_, _tmp12__length1);
	_g_free0 (str);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean contacts_list_pane_filter_entry_changed_timeout (ContactsListPane* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->filter_entry_changed_id = (guint) 0;
	contacts_list_pane_refilter (self);
	result = FALSE;
	return result;
}


static gboolean _contacts_list_pane_filter_entry_changed_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_list_pane_filter_entry_changed_timeout (self);
	return result;
}


static void contacts_list_pane_filter_entry_changed (ContactsListPane* self, GtkEditable* editable) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	GtkEntry* _tmp3_;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = self->priv->filter_entry_changed_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->filter_entry_changed_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, _contacts_list_pane_filter_entry_changed_timeout_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->filter_entry_changed_id = _tmp2_;
	_tmp3_ = self->filter_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GtkEntry* _tmp5_;
		_tmp5_ = self->filter_entry;
		gtk_entry_set_icon_from_icon_name (_tmp5_, GTK_ENTRY_ICON_SECONDARY, "edit-find-symbolic");
	} else {
		GtkEntry* _tmp6_;
		_tmp6_ = self->filter_entry;
		gtk_entry_set_icon_from_icon_name (_tmp6_, GTK_ENTRY_ICON_SECONDARY, "edit-clear-symbolic");
	}
}


static void contacts_list_pane_filter_entry_clear (ContactsListPane* self, GtkEntryIconPosition position) {
	GtkEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->filter_entry;
	gtk_entry_set_text (_tmp0_, "");
}


static void contacts_list_pane_contacts_selection_changed (ContactsListPane* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	ContactsContact* contact;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	ContactsContact* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	contact = NULL;
	_tmp0_ = selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		_tmp5_ = model;
		_tmp6_ = iter;
		gtk_tree_model_get (_tmp5_, &_tmp6_, 0, &contact, -1);
	}
	_tmp7_ = contact;
	g_signal_emit_by_name (self, "selection-changed", _tmp7_);
	_g_object_unref0 (contact);
	_g_object_unref0 (model);
}


static gpointer _contacts_store_ref0 (gpointer self) {
	return self ? contacts_store_ref (self) : NULL;
}


static void _contacts_list_pane_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	contacts_list_pane_filter_entry_changed (self, _sender);
}


static void _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	contacts_list_pane_filter_entry_clear (self, p0);
}


static void __lambda11_ (ContactsListPane* self, GtkToolButton* button) {
	g_return_if_fail (button != NULL);
	g_signal_emit_by_name (self, "create-new");
}


static void ___lambda11__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda11_ (self, _sender);
}


ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store) {
	ContactsListPane * self = NULL;
	ContactsStore* _tmp0_;
	ContactsStore* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolbar* _tmp3_;
	GtkToolbar* toolbar;
	GtkStyleContext* _tmp4_ = NULL;
	GtkSeparatorToolItem* _tmp5_;
	GtkSeparatorToolItem* _tmp6_;
	GtkSeparatorToolItem* separator;
	GtkSeparatorToolItem* _tmp7_;
	GtkSeparatorToolItem* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkToolItem* _tmp14_;
	GtkToolItem* _tmp15_;
	GtkToolItem* search_entry_item;
	GtkEntry* _tmp16_;
	GtkSeparatorToolItem* _tmp17_;
	GtkSeparatorToolItem* _tmp18_;
	GtkSeparatorToolItem* _tmp19_;
	GtkSeparatorToolItem* _tmp20_;
	GtkToolButton* _tmp21_;
	GtkToolButton* _tmp22_;
	GtkToolButton* add_button;
	GtkStyleContext* _tmp23_ = NULL;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* scrolled;
	GtkStyleContext* _tmp26_ = NULL;
	GtkGrid* _tmp27_;
	GtkGrid* _tmp28_;
	GtkGrid* grid;
	ContactsStore* _tmp29_;
	GtkTreeModel* _tmp30_;
	GtkTreeModel* _tmp31_;
	GtkTreeView* _tmp32_;
	GtkTreeView* _tmp33_;
	GtkTreeView* _tmp34_;
	GtkTreeView* _tmp35_;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsListPane*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_store;
	_tmp1_ = _contacts_store_ref0 (_tmp0_);
	_contacts_store_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp1_;
	_tmp2_ = (GtkToolbar*) gtk_toolbar_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	toolbar = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	gtk_style_context_add_class (_tmp4_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_widget_set_vexpand ((GtkWidget*) toolbar, FALSE);
	_tmp5_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_tmp6_ = g_object_ref_sink (_tmp5_);
	separator = _tmp6_;
	_tmp7_ = separator;
	gtk_separator_tool_item_set_draw (_tmp7_, FALSE);
	_tmp8_ = separator;
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkEntry*) gtk_entry_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->filter_entry);
	self->filter_entry = _tmp10_;
	_tmp11_ = self->filter_entry;
	gtk_entry_set_icon_from_icon_name (_tmp11_, GTK_ENTRY_ICON_SECONDARY, "edit-find-symbolic");
	_tmp12_ = self->filter_entry;
	g_signal_connect_object ((GtkEditable*) _tmp12_, "changed", (GCallback) _contacts_list_pane_filter_entry_changed_gtk_editable_changed, self, 0);
	_tmp13_ = self->filter_entry;
	g_signal_connect_object (_tmp13_, "icon-press", (GCallback) _contacts_list_pane_filter_entry_clear_gtk_entry_icon_press, self, 0);
	_tmp14_ = gtk_tool_item_new ();
	_tmp15_ = g_object_ref_sink (_tmp14_);
	search_entry_item = _tmp15_;
	gtk_tool_item_set_is_important (search_entry_item, FALSE);
	gtk_tool_item_set_expand (search_entry_item, TRUE);
	_tmp16_ = self->filter_entry;
	gtk_container_add ((GtkContainer*) search_entry_item, (GtkWidget*) _tmp16_);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) search_entry_item);
	_tmp17_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	_g_object_unref0 (separator);
	separator = _tmp18_;
	_tmp19_ = separator;
	gtk_separator_tool_item_set_draw (_tmp19_, FALSE);
	_tmp20_ = separator;
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	add_button = _tmp22_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp23_, GTK_STYLE_CLASS_RAISED);
	gtk_tool_item_set_is_important ((GtkToolItem*) add_button, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) add_button, 34, -1);
	gtk_container_add ((GtkContainer*) toolbar, (GtkWidget*) add_button);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda11__gtk_tool_button_clicked, self, 0);
	_tmp24_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp25_ = g_object_ref_sink (_tmp24_);
	scrolled = _tmp25_;
	gtk_scrolled_window_set_min_content_width (scrolled, 310);
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_NONE);
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) scrolled);
	gtk_style_context_set_junction_sides (_tmp26_, (GTK_JUNCTION_RIGHT | GTK_JUNCTION_LEFT) | GTK_JUNCTION_TOP);
	_tmp27_ = (GtkGrid*) gtk_grid_new ();
	_tmp28_ = g_object_ref_sink (_tmp27_);
	grid = _tmp28_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	gtk_grid_attach (grid, (GtkWidget*) toolbar, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) scrolled, 0, 1, 1, 1);
	_tmp29_ = contacts_store;
	_tmp30_ = contacts_store_get_model (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = (GtkTreeView*) gtk_tree_view_new_with_model (_tmp31_);
	_tmp33_ = g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->contacts_tree_view);
	self->priv->contacts_tree_view = _tmp33_;
	_tmp34_ = self->priv->contacts_tree_view;
	contacts_list_pane_setup_contacts_view (self, _tmp34_);
	_tmp35_ = self->priv->contacts_tree_view;
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp35_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (add_button);
	_g_object_unref0 (search_entry_item);
	_g_object_unref0 (separator);
	_g_object_unref0 (toolbar);
	return self;
}


ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store) {
	return contacts_list_pane_construct (CONTACTS_TYPE_LIST_PANE, contacts_store);
}


void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact) {
	GtkTreeIter iter = {0};
	ContactsStore* _tmp0_;
	ContactsContact* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = contact;
	_tmp3_ = contacts_store_lookup_iter (_tmp0_, _tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeView* _tmp4_;
		GtkTreeSelection* _tmp5_ = NULL;
		GtkTreeIter _tmp6_;
		GtkTreeView* _tmp7_;
		ContactsStore* _tmp8_;
		GtkTreeModel* _tmp9_;
		GtkTreeModel* _tmp10_;
		GtkTreeIter _tmp11_;
		GtkTreePath* _tmp12_ = NULL;
		GtkTreePath* _tmp13_;
		_tmp4_ = self->priv->contacts_tree_view;
		_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
		_tmp6_ = iter;
		gtk_tree_selection_select_iter (_tmp5_, &_tmp6_);
		_tmp7_ = self->priv->contacts_tree_view;
		_tmp8_ = self->priv->contacts_store;
		_tmp9_ = contacts_store_get_model (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = iter;
		_tmp12_ = gtk_tree_model_get_path (_tmp10_, &_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_tree_view_scroll_to_cell (_tmp7_, _tmp13_, NULL, TRUE, 0.0f, 0.0f);
		_gtk_tree_path_free0 (_tmp13_);
	}
}


static void contacts_list_pane_class_init (ContactsListPaneClass * klass) {
	contacts_list_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsListPanePrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_list_pane_finalize;
	g_signal_new ("selection_changed", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("create_new", CONTACTS_TYPE_LIST_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void contacts_list_pane_instance_init (ContactsListPane * self) {
	self->priv = CONTACTS_LIST_PANE_GET_PRIVATE (self);
}


static void contacts_list_pane_finalize (GObject* obj) {
	ContactsListPane * self;
	self = CONTACTS_LIST_PANE (obj);
	_contacts_store_unref0 (self->priv->contacts_store);
	_g_object_unref0 (self->priv->contacts_tree_view);
	_g_object_unref0 (self->filter_entry);
	_g_object_unref0 (self->priv->shape);
	G_OBJECT_CLASS (contacts_list_pane_parent_class)->finalize (obj);
}


GType contacts_list_pane_get_type (void) {
	static volatile gsize contacts_list_pane_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_list_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsListPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_list_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsListPane), 0, (GInstanceInitFunc) contacts_list_pane_instance_init, NULL };
		GType contacts_list_pane_type_id;
		contacts_list_pane_type_id = g_type_register_static (GTK_TYPE_FRAME, "ContactsListPane", &g_define_type_info, 0);
		g_once_init_leave (&contacts_list_pane_type_id__volatile, contacts_list_pane_type_id);
	}
	return contacts_list_pane_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



