/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol-manager.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol-manager
 * @title: IAnjutaSymbolManager
 * @short_description: Source code symbols manager inteface
 * @see_also: #IAnjutaSymbol
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol-manager.h
 * 
 */

#include "ianjuta-symbol-manager.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_manager_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-manager-quark");
	}
	
	return quark;
}

/**
 * ianjuta_symbol_manager_activate_package:
 * @obj: Self
 	 * @pkg_name: Name of the package to activate. The colon char must be avoided.
 	 * @pkg_version: Version of the package. The colon char must be avoided.
 	 *
 	 * Activates the package for searches in the global symbol database.
 	 *
 	 * Returns: TRUE if the package was loaded (or will be loaded once scanned). 
 	 * FALSE if the version given was newer than the version in the database or the 
 	 * package was not found. In this case, add_package() should be called.
 	 */
gboolean
ianjuta_symbol_manager_activate_package (IAnjutaSymbolManager *obj, const gchar *pkg_name,   const gchar* pkg_version, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), FALSE);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->activate_package (obj, pkg_name, pkg_version, err);
}

/* Default implementation */
static gboolean
ianjuta_symbol_manager_activate_package_default (IAnjutaSymbolManager *obj, const gchar *pkg_name,   const gchar* pkg_version, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_symbol_manager_add_package:
 * @obj: Self
 	 * @pkg_name: Name of the package to scan. Should be the name given by
 * pkg-config. The colon char must be avoided.
 	 * @pkg_version: Version of the package. The colon char must be avoided.
 	 * or by the language implementation (Python, Javascript, etc.)
 	 * @files: A list of GFile's to scan for this package
 	 *
 	 * Reads the package files into the database asynchronously.
 *
 * Returns: TRUE if the package will be loaded into the db, FALSE if the package
 * already exists
 	 */
gboolean
ianjuta_symbol_manager_add_package (IAnjutaSymbolManager *obj, const gchar* pkg_name,   const gchar* pkg_version,   GList* files, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), FALSE);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->add_package (obj, pkg_name, pkg_version, files, err);
}

/* Default implementation */
static gboolean
ianjuta_symbol_manager_add_package_default (IAnjutaSymbolManager *obj, const gchar* pkg_name,   const gchar* pkg_version,   GList* files, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_symbol_manager_create_query:
 * @obj: Self
 * @name: Name of the query. It decides what query type it is.
 * @db: The database to use.
 * @err: Error propagation and reporting.
 *
 * Create a query object. By default only #IANJUTA_SYMBOL_FIELD_ID and
 * and #IANJUTA_SYMBOL_FIELD_NAME are selected, limit is set to infinity,
 * offset is set to 0, no filters are set and mode is set to
 * #IANJUTA_SYMBOL_QUERY_MODE_SYNC.
 *
 * Returns: A #IAnjutaSymbolQuery object
 */
IAnjutaSymbolQuery*
ianjuta_symbol_manager_create_query (IAnjutaSymbolManager *obj, IAnjutaSymbolQueryName name,   IAnjutaSymbolQueryDb db, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj), NULL);
	return IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->create_query (obj, name, db, err);
}

/* Default implementation */
static IAnjutaSymbolQuery*
ianjuta_symbol_manager_create_query_default (IAnjutaSymbolManager *obj, IAnjutaSymbolQueryName name,   IAnjutaSymbolQueryDb db, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_manager_deactivate_all:
 * @obj: Self
 	 * 
 	 * Deactivates all activate packages
 *
 	 */
void
ianjuta_symbol_manager_deactivate_all (IAnjutaSymbolManager *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj));
	IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->deactivate_all (obj, err);
}

/* Default implementation */
static void
ianjuta_symbol_manager_deactivate_all_default (IAnjutaSymbolManager *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_symbol_manager_deactivate_package:
 * @obj: Self
 	 * @pkg_name: name of the package. The colon char must be avoided.
 * @pkg_version: Version of the package. The colon char must be avoided.
 	 * 
 	 * Deactivates the package if it was found. If package is NULL, deactivate all
 	 * packages.
 *
 	 */
void
ianjuta_symbol_manager_deactivate_package (IAnjutaSymbolManager *obj, const gchar* pkg_name,   const gchar* pkg_version, GError **err)
{
	g_return_if_fail (IANJUTA_IS_SYMBOL_MANAGER(obj));
	IANJUTA_SYMBOL_MANAGER_GET_IFACE (obj)->deactivate_package (obj, pkg_name, pkg_version, err);
}

/* Default implementation */
static void
ianjuta_symbol_manager_deactivate_package_default (IAnjutaSymbolManager *obj, const gchar* pkg_name,   const gchar* pkg_version, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_symbol_manager_base_init (IAnjutaSymbolManagerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->activate_package = ianjuta_symbol_manager_activate_package_default;
	klass->add_package = ianjuta_symbol_manager_add_package_default;
	klass->create_query = ianjuta_symbol_manager_create_query_default;
	klass->deactivate_all = ianjuta_symbol_manager_deactivate_all_default;
	klass->deactivate_package = ianjuta_symbol_manager_deactivate_package_default;
	
	if (!initialized) {

		/**
		 * IAnjutaSymbolManager::prj_scan_end:
		 * @obj: Self
		 * 
		 * This signal is emitted when a scanning of one or more files on project db
		 * ends. 
		 */
		g_signal_new ("prj-scan-end",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, prj_scan_end),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		/**
		 * IAnjutaSymbolManager::sys_scan_end:
		 * @obj: Self
		 * 
		 * This signal is emitted when a scanning of one or more packages on system db
		 * ends. This signal doesn't mean that all the scan process for the packages
		 * is ended, but that just one (or more) is (are).
		 */
		g_signal_new ("sys-scan-end",
			IANJUTA_TYPE_SYMBOL_MANAGER,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaSymbolManagerIface, sys_scan_end),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT,
			G_TYPE_NONE,
			1,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_symbol_manager_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolManagerIface),
			(GBaseInitFunc) ianjuta_symbol_manager_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbolManager", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
