untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24KaOanlfUDTKaY1Rcs3iTl4cXh7lcEnmtocPNFNqo7ywohopNasuOoxLekjJt9eIGovqOyBQFJkJ4UbPc1aAFg0=

OpenBSD 6.6 errata 036, July 27, 2020:

In iked, incorrect use of EVP_PKEY_cmp allows an authentication bypass.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 036_iked.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install iked:
    cd /usr/src/sbin/iked
    make obj
    make
    make install

Index: sbin/iked/ca.c
===================================================================
RCS file: /cvs/src/sbin/iked/ca.c,v
diff -u -p -u -r1.48 ca.c
--- sbin/iked/ca.c	3 Jul 2019 03:24:01 -0000	1.48
+++ sbin/iked/ca.c	23 Jul 2020 16:12:44 -0000
@@ -1251,7 +1251,7 @@ ca_validate_pubkey(struct iked *env, str
 	if (localkey == NULL)
 		goto sslerr;
 
-	if (!EVP_PKEY_cmp(peerkey, localkey)) {
+	if (EVP_PKEY_cmp(peerkey, localkey) != 1) {
 		log_debug("%s: public key does not match %s", __func__, file);
 		goto done;
 	}
