untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEsxUC/EYMuNNDh8D6Ux2F1AYhokdhIMokWtB9tfxXgHmCxq3tjP8QTpT1SJpQymq1nDtl6wXbtVbh61usbenTgU=

OpenBSD 6.1 errata 006, May 7, 2017:

Incorrect DTLS cookie handling can result in a NULL pointer dereference.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 006_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
	cd /usr/src/lib/libssl
	make obj
	make depend
	make
	make install

Index: lib/libssl/ssl_srvr.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_srvr.c,v
retrieving revision 1.14
retrieving revision 1.15
diff -u -p -r1.14 -r1.15
--- lib/libssl/ssl_srvr.c	14 Apr 2017 15:32:41 -0000	1.14
+++ lib/libssl/ssl_srvr.c	29 Apr 2017 23:38:49 -0000	1.15
@@ -720,7 +720,7 @@ ssl3_get_client_hello(SSL *s)
 	uint16_t client_version;
 	uint8_t comp_method;
 	int comp_null;
-	int i, j, ok, al, ret = -1;
+	int i, j, ok, al, ret = -1, cookie_valid = 0;
 	long n;
 	unsigned long id;
 	unsigned char *p, *d;
@@ -887,7 +887,7 @@ ssl3_get_client_hello(SSL *s)
 				SSLerror(s, SSL_R_COOKIE_MISMATCH);
 				goto f_err;
 			}
-			ret = 2;
+			cookie_valid = 1;
 		}
 	}
 
@@ -1059,8 +1059,8 @@ ssl3_get_client_hello(SSL *s)
 		goto err;
 	}
 
-	if (ret < 0)
-		ret = 1;
+	ret = cookie_valid ? 2 : 1;
+
 	if (0) {
 truncated:
 		al = SSL_AD_DECODE_ERROR;
