untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwVO3QrZswtKOoDIr2+Ow/iRQBhqoRFWQfdsxmE10GRWCfOaEUWPeEDdt7BjJBDlpO6H0Nl9PM796xFD1F+8g1Qs=

OpenBSD 5.9 errata 11, June 6, 2016:

SECOND REVISION

Correct a problem that prevents the DSA signing algorithm from running
in constant time even if the flag BN_FLG_CONSTTIME is set. This issue
was reported by Cesar Pereida (Aalto University), Billy Brumley
(Tampere University of Technology), and Yuval Yarom (The University of
Adelaide and NICTA). The fix was developed by Cesar Pereida.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 011_crypto.patch.sig \
            -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/crypto/dsa/dsa_ossl.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/crypto/dsa/dsa_ossl.c,v
retrieving revision 1.23
diff -u -p -u -p -r1.23 dsa_ossl.c
--- lib/libssl/src/crypto/dsa/dsa_ossl.c	10 Sep 2015 07:58:28 -0000	1.23
+++ lib/libssl/src/crypto/dsa/dsa_ossl.c	5 Jun 2016 20:17:11 -0000
@@ -247,9 +247,6 @@ dsa_sign_setup(DSA *dsa, BN_CTX *ctx_in,
 		if (!BN_rand_range(&k, dsa->q))
 			goto err;
 	} while (BN_is_zero(&k));
-	if ((dsa->flags & DSA_FLAG_NO_EXP_CONSTTIME) == 0) {
-		BN_set_flags(&k, BN_FLG_CONSTTIME);
-	}
 
 	if (dsa->flags & DSA_FLAG_CACHE_MONT_P) {
 		if (!BN_MONT_CTX_set_locked(&dsa->method_mont_p,
@@ -283,6 +280,11 @@ dsa_sign_setup(DSA *dsa, BN_CTX *ctx_in,
 	} else {
 		K = &k;
 	}
+
+	if ((dsa->flags & DSA_FLAG_NO_EXP_CONSTTIME) == 0) {
+		BN_set_flags(K, BN_FLG_CONSTTIME);
+	}
+
 	DSA_BN_MOD_EXP(goto err, dsa, r, dsa->g, K, dsa->p, ctx,
 	    dsa->method_mont_p);
 	if (!BN_mod(r,r,dsa->q,ctx))
