/* $NetBSD$ */

/*
 * Copyright (c) 2003 Dennis I. Chernoivanov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#ifndef __lint
__COPYRIGHT("@(#) Copyright (c) 2000\n\
	The NetBSD Foundation, inc. All rights reserved.\n");
__RCSID("$NetBSD$");
#endif /* !__lint */

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include "paneld.h"

static void usage(void);
static void daemon_init(void);

struct lcd_globals *globals;

int
main(int argc, char *argv[])
{
	int ch;
	int daemonize = 1;
	char *cf = "/etc/paneld.conf";

	setprogname(argv[0]);
	while ( (ch = getopt(argc, argv, "df:")) != -1) {
		switch (ch) {
		case 'f':
			cf = optarg;
			break;
		case 'd':
			daemonize = 0;
			break;
		case '?':
		default:
			usage();
			/* NOTREACHED */
		}
	}

	util_trace_init(daemonize);

	cf_parse(cf);

	if (daemonize)
		daemon_init();

	dev = device_attach(globals->dev_name, globals->dev_node);
	if (dev == NULL) {
		util_trace(LOG_ERR,
				"cannot attach to device %s, node %s",
				globals->dev_name, globals->dev_node);
		/* NORETURN */
	}

	dev->devcap(&globals->devcap);

	window = window_create();
	if ((window != NULL) && (window->open(dev) == E_OK))
		run_menu();
	window_destroy(window);

	device_detach(dev);
	util_trace_destroy();

	exit(0);
}

static void
daemon_init(void)
{
	pid_t pid;

	if ( (pid = fork()) < 0)
		exit(1);
	else if (pid != 0)
		exit(0);

	setsid();
	chdir("/");
	umask(0);
}

static void
usage(void)
{
	(void)fprintf(stderr, "usage: %s [-f conf_file]\n", getprogname());
	exit(1);
}
