/* $NetBSD$ */

/*
 * Copyright (c) 2003 Dennis I. Chernoivanov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <ctype.h>
#include <string.h>

#include "paneld.h"

#define _Y_OFF	1
#define _N_OFF	8
static char txt[] = "[Y]es / [N]o";

static int	cfrm_next(struct menu *m);
static int	cfrm_prev(struct menu *m);
static int	cfrm_on_yes(struct menu *m);
static int	cfrm_on_no(struct menu *m);
static int	cfrm_select(struct menu *m);

static int
cfrm_next(struct menu *m)
{
	int x;
	if (window->edit()->getpos(&x) == E_OK) {
		if (x == _Y_OFF)
			x = _Y_OFF + _N_OFF;
		else
			x = _Y_OFF;
		return window->edit()->setpos(x);
	}
	return E_IO;
}

static int
cfrm_prev(struct menu *m)
{
	return cfrm_next(m);
}

static int
cfrm_on_yes(struct menu *m)
{
	struct menu *cur = m->child;

	if (exec_write(m) != E_OK)
		return E_IO;
	for (; cur != NULL; cur = cur->next)
		if (!strcmp(cur->id, "true"))
		return cur->ops->select(cur);

	return E_OK;
}

static int
cfrm_on_no(struct menu *m)
{
	struct menu *cur = m->child;

	for (; cur != NULL; cur = cur->next)
		if (!strcmp(cur->id, "false"))
		return cur->ops->select(cur);

	return E_OK;
}

static int
cfrm_select(struct menu *m)
{
	int x, y;
	if (dev->getsize(&x, &y) == E_OK) {
		window->set_title(m->nm);
		window->edit()->setbuf(txt, ALIGN_CENTER);
		window->edit()->setpos(_Y_OFF);

		if (enter_menu(m) == E_SELECT) {
			if (window->edit()->getpos(&x) == E_OK) {
				if (x == _Y_OFF)
					return cfrm_on_yes(m);
				return cfrm_on_no(m);
			}
		}
	}
	return E_IO;
}

struct menu_ops*
get_confirm_ops(void)
{
	static struct menu_ops cfrm_ops = {
		cfrm_next,
		cfrm_prev,
		none_inc,
		none_dec,
		cfrm_select,
		none_allocbuf
	};
	return &cfrm_ops;
}
