#!/bin/sh

AWK=/usr/bin/awk
GREP=/usr/bin/grep
TAIL=/usr/bin/tail
NSLOOKUP=/usr/bin/nslookup

HOSTNAME=/bin/hostname
IFCONFIG=/sbin/ifconfig
ETC_IFCONFIG=/etc/ifconfig.tlp0

HOST=`/bin/hostname`

if [ -f $ETC_IFCONFIG ]; then
	ADDR=`$AWK '{ print $2 }' $ETC_IFCONFIG`
else
	ADDR=`$IFCONFIG tlp0 | $GREP 'inet ' | $AWK '{ print $2 }'`
fi

if [ "$HOST" != "" ]; then
	if [ "$ADDR" = "" ]; then
		ADDR=0.0.0.0
	fi
else
	if [ "$ADDR" != "" ]; then
		HOST=`$NSLOOKUP $ADDR | $GREP ^Name: | $AWK '{ print $2 }' | $TAIL -1`
	fi

	if [ "$HOST" = "" ]; then
		HOST=unknown.host
	fi

	if [ "$ADDR" = "" ]; then
		ADDR=0.0.0.0
	fi
fi

echo "$HOST"
echo "[$ADDR]"

exit 0
