/*	$NetBSD: vnode_if.c,v 1.118.4.1 2023/06/21 16:52:28 martin Exp $	*/

/*
 * Warning: DO NOT EDIT! This file is automatically generated!
 * (Modifications made here may easily be lost!)
 *
 * Created from the file:
 *	NetBSD: vnode_if.src,v 1.84.4.1 2023/06/21 16:50:21 martin Exp
 * by the script:
 *	NetBSD: vnode_if.sh,v 1.77 2022/10/26 23:39:43 riastradh Exp
 */

/*
 * Copyright (c) 1992, 1993, 1994, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: vnode_if.c,v 1.118.4.1 2023/06/21 16:52:28 martin Exp $");

#ifdef _KERNEL_OPT
#include "opt_vnode_lockdebug.h"
#endif /* _KERNEL_OPT */

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/buf.h>
#include <sys/fcntl.h>
#include <sys/vnode.h>
#include <sys/lock.h>
#include <sys/fstrans.h>

#include <miscfs/deadfs/deadfs.h>

enum fst_op { FST_NO, FST_YES, FST_LAZY, FST_TRY };

static inline int
vop_pre(vnode_t *vp, struct mount **mp, bool *mpsafe, enum fst_op op)
{
	int error;

	*mpsafe = (vp->v_vflag & VV_MPSAFE);

	if (!*mpsafe) {
		KERNEL_LOCK(1, curlwp);
	}

	if (op == FST_YES || op == FST_LAZY || op == FST_TRY) {
		for (;;) {
			*mp = vp->v_mount;
			if (op == FST_TRY) {
				error = fstrans_start_nowait(*mp);
				if (error) {
					if (!*mpsafe) {
						KERNEL_UNLOCK_ONE(curlwp);
					}
					return error;
				}
			} else if (op == FST_LAZY) {
				fstrans_start_lazy(*mp);
			} else {
				fstrans_start(*mp);
			}
			if (__predict_true(*mp == vp->v_mount))
				break;
			fstrans_done(*mp);
		}
	} else {
		*mp = vp->v_mount;
	}

	return 0;
}

static inline u_quad_t
vop_pre_get_size(struct vnode *vp)
{
	mutex_enter(vp->v_interlock);
	KASSERT(vp->v_size != VSIZENOTSET);
	u_quad_t rv = (u_quad_t)vp->v_size;
	mutex_exit(vp->v_interlock);

	return rv;
}

/*
 * VOP_RMDIR(), VOP_REMOVE(), and VOP_RENAME() need special handling
 * because they each drop the caller's references on one or more of
 * their arguments.  While there must be an open file descriptor in
 * associated with a vnode in order for knotes to be attached to it,
 * that status could change during the course of the operation.  So,
 * for the vnode arguments that are WILLRELE or WILLPUT, we check
 * pre-op if there are registered knotes, take a hold count if so,
 * and post-op release the hold after activating any knotes still
 * associated with the vnode.
 */

#define	VOP_POST_KNOTE(thisvp, e, n)					\
do {									\
	if (__predict_true((e) == 0)) {					\
		/*							\
		 * VN_KNOTE() does the VN_KEVENT_INTEREST()		\
		 * check for us.					\
		 */							\
		VN_KNOTE((thisvp), (n));				\
	}								\
} while (/*CONSTCOND*/0)

#define	VOP_POST_KNOTE_HELD(thisvp, e, n)				\
do {									\
	/*								\
	 * We don't perform a VN_KEVENT_INTEREST() check here; it	\
	 * was already performed when we did the pre-op work that	\
	 * caused the vnode to be held in the first place.		\
	 */								\
	mutex_enter((thisvp)->v_interlock);				\
	if (__predict_true((e) == 0)) {					\
		knote(&(thisvp)->v_klist->vk_klist, (n));		\
	}								\
	holdrelel((thisvp));						\
	mutex_exit((thisvp)->v_interlock);				\
	/*								\
	 * thisvp might be gone now!  Don't touch!			\
	 */								\
} while (/*CONSTCOND*/0)

#define	vop_create_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_dvp, (e), NOTE_WRITE)

#define	vop_mknod_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_dvp, (e), NOTE_WRITE)

#define	vop_setattr_pre(ap)						\
	u_quad_t osize = 0;						\
	long vp_events =						\
	    VN_KEVENT_INTEREST((ap)->a_vp, NOTE_ATTRIB | NOTE_EXTEND)	\
	    ? NOTE_ATTRIB : 0;						\
	bool check_extend = false;					\
	if (__predict_false(vp_events != 0 &&				\
	    (ap)->a_vap->va_size != VNOVALSIZE)) {			\
		check_extend = true;					\
		osize = vop_pre_get_size((ap)->a_vp);			\
	}

#define	vop_setattr_post(ap, e)						\
do {									\
	if (__predict_false(vp_events != 0)) {				\
		if (__predict_false(check_extend &&			\
		    (ap)->a_vap->va_size > osize)) {			\
			vp_events |= NOTE_EXTEND;			\
		}							\
		VOP_POST_KNOTE((ap)->a_vp, (e), vp_events);		\
	}								\
} while (/*CONSTCOND*/0)

#define	vop_setacl_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_vp, (e), NOTE_ATTRIB)

#define	vop_link_post(ap, e)						\
do {									\
	VOP_POST_KNOTE((ap)->a_dvp, (e), NOTE_WRITE);			\
	VOP_POST_KNOTE((ap)->a_vp, (e), NOTE_LINK);			\
} while (/*CONSTCOND*/0)

#define	vop_mkdir_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_dvp, (e), NOTE_WRITE | NOTE_LINK)

#define	vop_remove_pre_common(ap)					\
	bool post_event_vp =						\
	    VN_KEVENT_INTEREST((ap)->a_vp, NOTE_DELETE | NOTE_LINK);	\
	if (__predict_false(post_event_vp)) {				\
		vhold((ap)->a_vp);					\
	}

#define	vop_remove_post_common(ap, e, dn, lc)				\
do {									\
	VOP_POST_KNOTE((ap)->a_dvp, (e), (dn));				\
	if (__predict_false(post_event_vp)) {				\
		VOP_POST_KNOTE_HELD((ap)->a_vp, (e),			\
		    (lc) ? NOTE_LINK : NOTE_DELETE);			\
	}								\
} while (/*CONSTCOND*/0)

/*
 * One could make the argument that VOP_REMOVE() should send NOTE_LINK
 * on vp if the resulting link count is not zero, but that's not what
 * the documentation says.
 *
 * We could change this easily by passing ap->ctx_vp_new_nlink to
 * vop_remove_post_common().
 */
#define	vop_remove_pre(ap)						\
	vop_remove_pre_common((ap));					\
	/*								\
	 * We will assume that the file being removed is deleted unless	\
	 * the file system tells us otherwise by updating vp_new_nlink.	\
	 */								\
	(ap)->ctx_vp_new_nlink = 0;

#define	vop_remove_post(ap, e)						\
	vop_remove_post_common((ap), (e), NOTE_WRITE, 0)

#define	vop_rmdir_pre(ap)						\
	vop_remove_pre_common(ap)

#define	vop_rmdir_post(ap, e)						\
	vop_remove_post_common((ap), (e), NOTE_WRITE | NOTE_LINK, 0)

#define	vop_symlink_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_dvp, (e), NOTE_WRITE)

#define	vop_open_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_vp, (e), NOTE_OPEN)

#define	vop_close_post(ap, e)						\
do {									\
	/* See the definition of VN_KNOTE() in <sys/vnode.h>. */	\
	if (__predict_false(VN_KEVENT_INTEREST((ap)->a_vp,		\
	    NOTE_CLOSE_WRITE | NOTE_CLOSE) && (e) == 0)) {		\
		struct vnode *thisvp = (ap)->a_vp;			\
		mutex_enter(thisvp->v_interlock);			\
		/*							\
		 * Don't send NOTE_CLOSE when closing a vnode that's	\
		 * been reclaimed or otherwise revoked; a NOTE_REVOKE	\
		 * has already been sent, and this close is effectively	\
		 * meaningless from the watcher's perspective.		\
		 */							\
		if (__predict_true(thisvp->v_op != dead_vnodeop_p)) {	\
			knote(&thisvp->v_klist->vk_klist,		\
			    ((ap)->a_fflag & FWRITE)			\
			    ? NOTE_CLOSE_WRITE : NOTE_CLOSE);		\
		}							\
		mutex_exit(thisvp->v_interlock);			\
	}								\
} while (/*CONSTCOND*/0)

#define	vop_read_post(ap, e)						\
	VOP_POST_KNOTE((ap)->a_vp, (e), NOTE_READ)

#define	vop_write_pre(ap)						\
	off_t ooffset = 0, noffset = 0;					\
	u_quad_t osize = 0;						\
	long vp_events =						\
	    VN_KEVENT_INTEREST((ap)->a_vp, NOTE_WRITE | NOTE_EXTEND)	\
	    ? NOTE_WRITE : 0;						\
	if (__predict_false(vp_events != 0)) {				\
		ooffset = (ap)->a_uio->uio_offset;			\
		osize = vop_pre_get_size((ap)->a_vp);			\
	}

#define	vop_write_post(ap, e)						\
do {									\
	/*								\
	 * If any data was written, we'll post an event, even if	\
	 * there was an error.						\
	 */								\
	noffset = (ap)->a_uio->uio_offset;				\
	if (__predict_false(vp_events != 0 && noffset > ooffset)) {	\
		if (noffset > osize) {					\
			vp_events |= NOTE_EXTEND;			\
		}							\
		VN_KNOTE((ap)->a_vp, vp_events);			\
	}								\
} while (/*CONSTCOND*/0)

static inline void
vop_post(vnode_t *vp, struct mount *mp, bool mpsafe, enum fst_op op)
{

	if (op == FST_YES || op == FST_LAZY) {
		fstrans_done(mp);
	}

	if (!mpsafe) {
		KERNEL_UNLOCK_ONE(curlwp);
	}
}

static inline void
assert_vop_unlocked(vnode_t *vp, const char *str)
{
#if defined(VNODE_LOCKDEBUG)

	if (VOP_ISLOCKED(vp) == LK_EXCLUSIVE)
		panic("%s: %p %d/%d is locked but should not be",
		    str, vp, vp->v_tag, vp->v_type);
#endif
}

static inline void
assert_vop_locked(vnode_t *vp, const char *str)
{
#if defined(VNODE_LOCKDEBUG)

	if (VOP_ISLOCKED(vp) == LK_NONE)
		panic("%s: %p %d/%d is not locked but should be",
		    str, vp, vp->v_tag, vp->v_type);
#endif
}

static inline void
assert_vop_elocked(vnode_t *vp, const char *str)
{
#if defined(VNODE_LOCKDEBUG)

	if (VOP_ISLOCKED(vp) != LK_EXCLUSIVE)
		panic("%s: %p %d/%d is not exclusive locked but should be",
		    str, vp, vp->v_tag, vp->v_type);
#endif
}

const struct vnodeop_desc vop_default_desc = {
	0,
	"default",
	0,
	NULL,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};


const int vop_bwrite_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_bwrite_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_bwrite_desc = {
	VOP_BWRITE_DESCOFFSET,
	"vop_bwrite",
	0,
	vop_bwrite_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_BWRITE(struct vnode *vp,
    struct buf *bp)
{
	int error;
	bool mpsafe;
	struct vop_bwrite_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_bwrite);
	a.a_vp = vp;
	a.a_bp = bp;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_bwrite), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_parsepath_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_parsepath_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_parsepath_desc = {
	VOP_PARSEPATH_DESCOFFSET,
	"vop_parsepath",
	0,
	vop_parsepath_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_PARSEPATH(struct vnode *dvp,
    const char *name,
    size_t *retval)
{
	int error;
	bool mpsafe;
	struct vop_parsepath_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_parsepath);
	a.a_dvp = dvp;
	a.a_name = name;
	a.a_retval = retval;
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_parsepath), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_lookup_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_lookup_v2_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_lookup_desc = {
	VOP_LOOKUP_DESCOFFSET,
	"vop_lookup",
	0,
	vop_lookup_vp_offsets,
	VOPARG_OFFSETOF(struct vop_lookup_v2_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_lookup_v2_args, a_cnp),
};
int
VOP_LOOKUP(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct vop_lookup_v2_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_lookup);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	assert_vop_locked(dvp, "vop_lookup: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_lookup), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int vop_create_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_create_v3_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_create_desc = {
	VOP_CREATE_DESCOFFSET,
	"vop_create",
	0,
	vop_create_vp_offsets,
	VOPARG_OFFSETOF(struct vop_create_v3_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_create_v3_args, a_cnp),
};
int
VOP_CREATE(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct vop_create_v3_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_create);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	assert_vop_elocked(dvp, "vop_create: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_create), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_create_post(&a, error);
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int vop_mknod_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_mknod_v3_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_mknod_desc = {
	VOP_MKNOD_DESCOFFSET,
	"vop_mknod",
	0,
	vop_mknod_vp_offsets,
	VOPARG_OFFSETOF(struct vop_mknod_v3_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_mknod_v3_args, a_cnp),
};
int
VOP_MKNOD(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct vop_mknod_v3_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_mknod);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	assert_vop_elocked(dvp, "vop_mknod: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_mknod), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_mknod_post(&a, error);
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int vop_open_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_open_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_open_desc = {
	VOP_OPEN_DESCOFFSET,
	"vop_open",
	0,
	vop_open_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_open_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_OPEN(struct vnode *vp,
    int mode,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_open_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_open);
	a.a_vp = vp;
	a.a_mode = mode;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_open: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_open), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_open_post(&a, error);
	return error;
}

const int vop_close_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_close_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_close_desc = {
	VOP_CLOSE_DESCOFFSET,
	"vop_close",
	0,
	vop_close_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_close_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_CLOSE(struct vnode *vp,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_close_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_close);
	a.a_vp = vp;
	a.a_fflag = fflag;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_close: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_close), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_close_post(&a, error);
	return error;
}

const int vop_access_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_access_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_access_desc = {
	VOP_ACCESS_DESCOFFSET,
	"vop_access",
	0,
	vop_access_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_access_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_ACCESS(struct vnode *vp,
    accmode_t accmode,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_access_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_access);
	a.a_vp = vp;
	a.a_accmode = accmode;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_access: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_access), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_accessx_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_accessx_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_accessx_desc = {
	VOP_ACCESSX_DESCOFFSET,
	"vop_accessx",
	0,
	vop_accessx_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_accessx_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_ACCESSX(struct vnode *vp,
    accmode_t accmode,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_accessx_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_accessx);
	a.a_vp = vp;
	a.a_accmode = accmode;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_accessx: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_accessx), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_getattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_getattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_getattr_desc = {
	VOP_GETATTR_DESCOFFSET,
	"vop_getattr",
	0,
	vop_getattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_getattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_GETATTR(struct vnode *vp,
    struct vattr *vap,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_getattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_getattr);
	a.a_vp = vp;
	a.a_vap = vap;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_getattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_getattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_setattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_setattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_setattr_desc = {
	VOP_SETATTR_DESCOFFSET,
	"vop_setattr",
	0,
	vop_setattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_setattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_SETATTR(struct vnode *vp,
    struct vattr *vap,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_setattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_setattr);
	a.a_vp = vp;
	a.a_vap = vap;
	a.a_cred = cred;
	assert_vop_elocked(vp, "vop_setattr: vp");
	vop_setattr_pre(&a);
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_setattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_setattr_post(&a, error);
	return error;
}

const int vop_read_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_read_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_read_desc = {
	VOP_READ_DESCOFFSET,
	"vop_read",
	0,
	vop_read_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_read_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_READ(struct vnode *vp,
    struct uio *uio,
    int ioflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_read_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_read);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_ioflag = ioflag;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_read: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_read), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_read_post(&a, error);
	return error;
}

const int vop_write_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_write_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_write_desc = {
	VOP_WRITE_DESCOFFSET,
	"vop_write",
	0,
	vop_write_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_write_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_WRITE(struct vnode *vp,
    struct uio *uio,
    int ioflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_write_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_write);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_ioflag = ioflag;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_write: vp");
	vop_write_pre(&a);
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_write), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_write_post(&a, error);
	return error;
}

const int vop_fallocate_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_fallocate_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_fallocate_desc = {
	VOP_FALLOCATE_DESCOFFSET,
	"vop_fallocate",
	0,
	vop_fallocate_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_FALLOCATE(struct vnode *vp,
    off_t pos,
    off_t len)
{
	int error;
	bool mpsafe;
	struct vop_fallocate_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_fallocate);
	a.a_vp = vp;
	a.a_pos = pos;
	a.a_len = len;
	assert_vop_locked(vp, "vop_fallocate: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_fallocate), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_fdiscard_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_fdiscard_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_fdiscard_desc = {
	VOP_FDISCARD_DESCOFFSET,
	"vop_fdiscard",
	0,
	vop_fdiscard_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_FDISCARD(struct vnode *vp,
    off_t pos,
    off_t len)
{
	int error;
	bool mpsafe;
	struct vop_fdiscard_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_fdiscard);
	a.a_vp = vp;
	a.a_pos = pos;
	a.a_len = len;
	assert_vop_locked(vp, "vop_fdiscard: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_fdiscard), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_ioctl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_ioctl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_ioctl_desc = {
	VOP_IOCTL_DESCOFFSET,
	"vop_ioctl",
	0,
	vop_ioctl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_ioctl_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_IOCTL(struct vnode *vp,
    u_long command,
    void *data,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_ioctl_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_ioctl);
	a.a_vp = vp;
	a.a_command = command;
	a.a_data = data;
	a.a_fflag = fflag;
	a.a_cred = cred;
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_ioctl), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_fcntl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_fcntl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_fcntl_desc = {
	VOP_FCNTL_DESCOFFSET,
	"vop_fcntl",
	0,
	vop_fcntl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_fcntl_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_FCNTL(struct vnode *vp,
    u_int command,
    void *data,
    int fflag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_fcntl_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_fcntl);
	a.a_vp = vp;
	a.a_command = command;
	a.a_data = data;
	a.a_fflag = fflag;
	a.a_cred = cred;
	assert_vop_unlocked(vp, "vop_fcntl: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_fcntl), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_poll_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_poll_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_poll_desc = {
	VOP_POLL_DESCOFFSET,
	"vop_poll",
	0,
	vop_poll_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_POLL(struct vnode *vp,
    int events)
{
	int error;
	bool mpsafe;
	struct vop_poll_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_poll);
	a.a_vp = vp;
	a.a_events = events;
	assert_vop_unlocked(vp, "vop_poll: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_poll), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_kqfilter_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_kqfilter_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_kqfilter_desc = {
	VOP_KQFILTER_DESCOFFSET,
	"vop_kqfilter",
	0,
	vop_kqfilter_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_KQFILTER(struct vnode *vp,
    struct knote *kn)
{
	int error;
	bool mpsafe;
	struct vop_kqfilter_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_kqfilter);
	a.a_vp = vp;
	a.a_kn = kn;
	assert_vop_unlocked(vp, "vop_kqfilter: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_kqfilter), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_revoke_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_revoke_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_revoke_desc = {
	VOP_REVOKE_DESCOFFSET,
	"vop_revoke",
	0,
	vop_revoke_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_REVOKE(struct vnode *vp,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_revoke_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_revoke);
	a.a_vp = vp;
	a.a_flags = flags;
	assert_vop_unlocked(vp, "vop_revoke: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_revoke), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_mmap_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_mmap_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_mmap_desc = {
	VOP_MMAP_DESCOFFSET,
	"vop_mmap",
	0,
	vop_mmap_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_mmap_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_MMAP(struct vnode *vp,
    vm_prot_t prot,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_mmap_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_mmap);
	a.a_vp = vp;
	a.a_prot = prot;
	a.a_cred = cred;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_mmap), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_fsync_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_fsync_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_fsync_desc = {
	VOP_FSYNC_DESCOFFSET,
	"vop_fsync",
	0,
	vop_fsync_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_fsync_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_FSYNC(struct vnode *vp,
    kauth_cred_t cred,
    int flags,
    off_t offlo,
    off_t offhi)
{
	int error;
	bool mpsafe;
	struct vop_fsync_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_fsync);
	a.a_vp = vp;
	a.a_cred = cred;
	a.a_flags = flags;
	a.a_offlo = offlo;
	a.a_offhi = offhi;
	assert_vop_locked(vp, "vop_fsync: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_fsync), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_seek_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_seek_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_seek_desc = {
	VOP_SEEK_DESCOFFSET,
	"vop_seek",
	0,
	vop_seek_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_seek_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_SEEK(struct vnode *vp,
    off_t oldoff,
    off_t newoff,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_seek_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_seek);
	a.a_vp = vp;
	a.a_oldoff = oldoff;
	a.a_newoff = newoff;
	a.a_cred = cred;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_seek), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_remove_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_remove_v3_args,a_dvp),
	VOPARG_OFFSETOF(struct vop_remove_v3_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_remove_desc = {
	VOP_REMOVE_DESCOFFSET,
	"vop_remove",
	0 | VDESC_VP1_WILLPUT,
	vop_remove_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_remove_v3_args, a_cnp),
};
int
VOP_REMOVE(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct vop_remove_v3_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_remove);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	assert_vop_elocked(dvp, "vop_remove: dvp");
	assert_vop_locked(vp, "vop_remove: vp");
	vop_remove_pre(&a);
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_remove), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_remove_post(&a, error);
	return error;
}

const int vop_link_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_link_v2_args,a_dvp),
	VOPARG_OFFSETOF(struct vop_link_v2_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_link_desc = {
	VOP_LINK_DESCOFFSET,
	"vop_link",
	0,
	vop_link_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_link_v2_args, a_cnp),
};
int
VOP_LINK(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct vop_link_v2_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_link);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	assert_vop_elocked(dvp, "vop_link: dvp");
	assert_vop_unlocked(vp, "vop_link: vp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_link), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_link_post(&a, error);
	return error;
}

const int vop_rename_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_rename_args,a_fdvp),
	VOPARG_OFFSETOF(struct vop_rename_args,a_fvp),
	VOPARG_OFFSETOF(struct vop_rename_args,a_tdvp),
	VOPARG_OFFSETOF(struct vop_rename_args,a_tvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_rename_desc = {
	VOP_RENAME_DESCOFFSET,
	"vop_rename",
	0 | VDESC_VP0_WILLRELE | VDESC_VP1_WILLRELE | VDESC_VP2_WILLPUT | VDESC_VP3_WILLPUT,
	vop_rename_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_rename_args, a_fcnp),
};
int
VOP_RENAME(struct vnode *fdvp,
    struct vnode *fvp,
    struct componentname *fcnp,
    struct vnode *tdvp,
    struct vnode *tvp,
    struct componentname *tcnp)
{
	int error;
	bool mpsafe;
	struct vop_rename_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_rename);
	a.a_fdvp = fdvp;
	a.a_fvp = fvp;
	a.a_fcnp = fcnp;
	a.a_tdvp = tdvp;
	a.a_tvp = tvp;
	a.a_tcnp = tcnp;
	assert_vop_locked(tdvp, "vop_rename: tdvp");
	error = vop_pre(fdvp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(fdvp, VOFFSET(vop_rename), &a));
	vop_post(fdvp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_mkdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_mkdir_v3_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_mkdir_desc = {
	VOP_MKDIR_DESCOFFSET,
	"vop_mkdir",
	0,
	vop_mkdir_vp_offsets,
	VOPARG_OFFSETOF(struct vop_mkdir_v3_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_mkdir_v3_args, a_cnp),
};
int
VOP_MKDIR(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap)
{
	int error;
	bool mpsafe;
	struct vop_mkdir_v3_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_mkdir);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	assert_vop_elocked(dvp, "vop_mkdir: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_mkdir), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_mkdir_post(&a, error);
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int vop_rmdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_rmdir_v2_args,a_dvp),
	VOPARG_OFFSETOF(struct vop_rmdir_v2_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_rmdir_desc = {
	VOP_RMDIR_DESCOFFSET,
	"vop_rmdir",
	0 | VDESC_VP1_WILLPUT,
	vop_rmdir_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_rmdir_v2_args, a_cnp),
};
int
VOP_RMDIR(struct vnode *dvp,
    struct vnode *vp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct vop_rmdir_v2_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_rmdir);
	a.a_dvp = dvp;
	a.a_vp = vp;
	a.a_cnp = cnp;
	assert_vop_elocked(dvp, "vop_rmdir: dvp");
	assert_vop_elocked(vp, "vop_rmdir: vp");
	vop_rmdir_pre(&a);
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_rmdir), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_rmdir_post(&a, error);
	return error;
}

const int vop_symlink_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_symlink_v3_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_symlink_desc = {
	VOP_SYMLINK_DESCOFFSET,
	"vop_symlink",
	0,
	vop_symlink_vp_offsets,
	VOPARG_OFFSETOF(struct vop_symlink_v3_args, a_vpp),
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_symlink_v3_args, a_cnp),
};
int
VOP_SYMLINK(struct vnode *dvp,
    struct vnode **vpp,
    struct componentname *cnp,
    struct vattr *vap,
    char *target)
{
	int error;
	bool mpsafe;
	struct vop_symlink_v3_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_symlink);
	a.a_dvp = dvp;
	a.a_vpp = vpp;
	a.a_cnp = cnp;
	a.a_vap = vap;
	a.a_target = target;
	assert_vop_elocked(dvp, "vop_symlink: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_symlink), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	vop_symlink_post(&a, error);
#ifdef DIAGNOSTIC
	if (error == 0)
		KASSERT((*vpp)->v_size != VSIZENOTSET
		    && (*vpp)->v_writesize != VSIZENOTSET);
#endif /* DIAGNOSTIC */
	return error;
}

const int vop_readdir_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_readdir_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_readdir_desc = {
	VOP_READDIR_DESCOFFSET,
	"vop_readdir",
	0,
	vop_readdir_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_readdir_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_READDIR(struct vnode *vp,
    struct uio *uio,
    kauth_cred_t cred,
    int *eofflag,
    off_t **cookies,
    int *ncookies)
{
	int error;
	bool mpsafe;
	struct vop_readdir_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_readdir);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_cred = cred;
	a.a_eofflag = eofflag;
	a.a_cookies = cookies;
	a.a_ncookies = ncookies;
	assert_vop_locked(vp, "vop_readdir: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_readdir), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_readlink_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_readlink_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_readlink_desc = {
	VOP_READLINK_DESCOFFSET,
	"vop_readlink",
	0,
	vop_readlink_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_readlink_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_READLINK(struct vnode *vp,
    struct uio *uio,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_readlink_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_readlink);
	a.a_vp = vp;
	a.a_uio = uio;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_readlink: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_readlink), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_abortop_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_abortop_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_abortop_desc = {
	VOP_ABORTOP_DESCOFFSET,
	"vop_abortop",
	0,
	vop_abortop_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_abortop_args, a_cnp),
};
int
VOP_ABORTOP(struct vnode *dvp,
    struct componentname *cnp)
{
	int error;
	bool mpsafe;
	struct vop_abortop_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_abortop);
	a.a_dvp = dvp;
	a.a_cnp = cnp;
	error = vop_pre(dvp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_abortop), &a));
	vop_post(dvp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_inactive_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_inactive_v2_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_inactive_desc = {
	VOP_INACTIVE_DESCOFFSET,
	"vop_inactive",
	0,
	vop_inactive_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_INACTIVE(struct vnode *vp,
    bool *recycle)
{
	int error;
	bool mpsafe;
	struct vop_inactive_v2_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_inactive);
	a.a_vp = vp;
	a.a_recycle = recycle;
	assert_vop_elocked(vp, "vop_inactive: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_inactive), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_reclaim_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_reclaim_v2_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_reclaim_desc = {
	VOP_RECLAIM_DESCOFFSET,
	"vop_reclaim",
	0,
	vop_reclaim_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_RECLAIM(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct vop_reclaim_v2_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_reclaim);
	a.a_vp = vp;
	assert_vop_elocked(vp, "vop_reclaim: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_reclaim), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_lock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_lock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_lock_desc = {
	VOP_LOCK_DESCOFFSET,
	"vop_lock",
	0,
	vop_lock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_LOCK(struct vnode *vp,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_lock_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_lock);
	a.a_vp = vp;
	a.a_flags = flags;
	error = vop_pre(vp, &mp, &mpsafe, (!(flags & (LK_SHARED|LK_EXCLUSIVE)) ? FST_NO : (flags & LK_NOWAIT ? FST_TRY : FST_YES)));
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_lock), &a));
	vop_post(vp, mp, mpsafe, (flags & (LK_UPGRADE|LK_DOWNGRADE) ? FST_NO : (error ? FST_YES : FST_NO)));
	return error;
}

const int vop_unlock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_unlock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_unlock_desc = {
	VOP_UNLOCK_DESCOFFSET,
	"vop_unlock",
	0,
	vop_unlock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_UNLOCK(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct vop_unlock_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_unlock);
	a.a_vp = vp;
	assert_vop_locked(vp, "vop_unlock: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_unlock), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_bmap_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_bmap_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_bmap_desc = {
	VOP_BMAP_DESCOFFSET,
	"vop_bmap",
	0,
	vop_bmap_vp_offsets,
	VOPARG_OFFSETOF(struct vop_bmap_args, a_vpp),
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_BMAP(struct vnode *vp,
    daddr_t bn,
    struct vnode **vpp,
    daddr_t *bnp,
    int *runp)
{
	int error;
	bool mpsafe;
	struct vop_bmap_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_bmap);
	a.a_vp = vp;
	a.a_bn = bn;
	a.a_vpp = vpp;
	a.a_bnp = bnp;
	a.a_runp = runp;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_bmap), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_strategy_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_strategy_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_strategy_desc = {
	VOP_STRATEGY_DESCOFFSET,
	"vop_strategy",
	0,
	vop_strategy_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_STRATEGY(struct vnode *vp,
    struct buf *bp)
{
	int error;
	bool mpsafe;
	struct vop_strategy_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_strategy);
	a.a_vp = vp;
	a.a_bp = bp;
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_strategy), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_print_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_print_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_print_desc = {
	VOP_PRINT_DESCOFFSET,
	"vop_print",
	0,
	vop_print_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_PRINT(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct vop_print_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_print);
	a.a_vp = vp;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_print), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_islocked_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_islocked_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_islocked_desc = {
	VOP_ISLOCKED_DESCOFFSET,
	"vop_islocked",
	0,
	vop_islocked_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_ISLOCKED(struct vnode *vp)
{
	int error;
	bool mpsafe;
	struct vop_islocked_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_islocked);
	a.a_vp = vp;
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_islocked), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_pathconf_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_pathconf_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_pathconf_desc = {
	VOP_PATHCONF_DESCOFFSET,
	"vop_pathconf",
	0,
	vop_pathconf_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_PATHCONF(struct vnode *vp,
    int name,
    register_t *retval)
{
	int error;
	bool mpsafe;
	struct vop_pathconf_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_pathconf);
	a.a_vp = vp;
	a.a_name = name;
	a.a_retval = retval;
	assert_vop_locked(vp, "vop_pathconf: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_pathconf), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_advlock_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_advlock_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_advlock_desc = {
	VOP_ADVLOCK_DESCOFFSET,
	"vop_advlock",
	0,
	vop_advlock_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_ADVLOCK(struct vnode *vp,
    void *id,
    int op,
    struct flock *fl,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_advlock_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_advlock);
	a.a_vp = vp;
	a.a_id = id;
	a.a_op = op;
	a.a_fl = fl;
	a.a_flags = flags;
	assert_vop_unlocked(vp, "vop_advlock: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_advlock), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_whiteout_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_whiteout_args,a_dvp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_whiteout_desc = {
	VOP_WHITEOUT_DESCOFFSET,
	"vop_whiteout",
	0,
	vop_whiteout_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_whiteout_args, a_cnp),
};
int
VOP_WHITEOUT(struct vnode *dvp,
    struct componentname *cnp,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_whiteout_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_whiteout);
	a.a_dvp = dvp;
	a.a_cnp = cnp;
	a.a_flags = flags;
	assert_vop_elocked(dvp, "vop_whiteout: dvp");
	error = vop_pre(dvp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(dvp, VOFFSET(vop_whiteout), &a));
	vop_post(dvp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_getpages_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_getpages_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_getpages_desc = {
	VOP_GETPAGES_DESCOFFSET,
	"vop_getpages",
	0,
	vop_getpages_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_GETPAGES(struct vnode *vp,
    voff_t offset,
    struct vm_page **m,
    int *count,
    int centeridx,
    vm_prot_t access_type,
    int advice,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_getpages_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_getpages);
	a.a_vp = vp;
	a.a_offset = offset;
	a.a_m = m;
	a.a_count = count;
	a.a_centeridx = centeridx;
	a.a_access_type = access_type;
	a.a_advice = advice;
	a.a_flags = flags;
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_getpages), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_putpages_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_putpages_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_putpages_desc = {
	VOP_PUTPAGES_DESCOFFSET,
	"vop_putpages",
	0,
	vop_putpages_vp_offsets,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
	VDESC_NO_OFFSET,
};
int
VOP_PUTPAGES(struct vnode *vp,
    voff_t offlo,
    voff_t offhi,
    int flags)
{
	int error;
	bool mpsafe;
	struct vop_putpages_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_putpages);
	a.a_vp = vp;
	a.a_offlo = offlo;
	a.a_offhi = offhi;
	a.a_flags = flags;
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_putpages), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_getacl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_getacl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_getacl_desc = {
	VOP_GETACL_DESCOFFSET,
	"vop_getacl",
	0,
	vop_getacl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_getacl_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_GETACL(struct vnode *vp,
    acl_type_t type,
    struct acl *aclp,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_getacl_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_getacl);
	a.a_vp = vp;
	a.a_type = type;
	a.a_aclp = aclp;
	a.a_cred = cred;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_getacl), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_setacl_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_setacl_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_setacl_desc = {
	VOP_SETACL_DESCOFFSET,
	"vop_setacl",
	0,
	vop_setacl_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_setacl_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_SETACL(struct vnode *vp,
    acl_type_t type,
    struct acl *aclp,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_setacl_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_setacl);
	a.a_vp = vp;
	a.a_type = type;
	a.a_aclp = aclp;
	a.a_cred = cred;
	assert_vop_elocked(vp, "vop_setacl: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_setacl), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	vop_setacl_post(&a, error);
	return error;
}

const int vop_aclcheck_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_aclcheck_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_aclcheck_desc = {
	VOP_ACLCHECK_DESCOFFSET,
	"vop_aclcheck",
	0,
	vop_aclcheck_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_aclcheck_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_ACLCHECK(struct vnode *vp,
    acl_type_t type,
    struct acl *aclp,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_aclcheck_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_aclcheck);
	a.a_vp = vp;
	a.a_type = type;
	a.a_aclp = aclp;
	a.a_cred = cred;
	error = vop_pre(vp, &mp, &mpsafe, FST_YES);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_aclcheck), &a));
	vop_post(vp, mp, mpsafe, FST_YES);
	return error;
}

const int vop_closeextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_closeextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_closeextattr_desc = {
	VOP_CLOSEEXTATTR_DESCOFFSET,
	"vop_closeextattr",
	0,
	vop_closeextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_closeextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_CLOSEEXTATTR(struct vnode *vp,
    int commit,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_closeextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_closeextattr);
	a.a_vp = vp;
	a.a_commit = commit;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_closeextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_closeextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_getextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_getextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_getextattr_desc = {
	VOP_GETEXTATTR_DESCOFFSET,
	"vop_getextattr",
	0,
	vop_getextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_getextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_GETEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    struct uio *uio,
    size_t *size,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_getextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_getextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_uio = uio;
	a.a_size = size;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_getextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_getextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_listextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_listextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_listextattr_desc = {
	VOP_LISTEXTATTR_DESCOFFSET,
	"vop_listextattr",
	0,
	vop_listextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_listextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_LISTEXTATTR(struct vnode *vp,
    int attrnamespace,
    struct uio *uio,
    size_t *size,
    int flag,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_listextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_listextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_uio = uio;
	a.a_size = size;
	a.a_flag = flag;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_listextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_listextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_openextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_openextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_openextattr_desc = {
	VOP_OPENEXTATTR_DESCOFFSET,
	"vop_openextattr",
	0,
	vop_openextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_openextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_OPENEXTATTR(struct vnode *vp,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_openextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_openextattr);
	a.a_vp = vp;
	a.a_cred = cred;
	assert_vop_locked(vp, "vop_openextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_openextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_deleteextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_deleteextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_deleteextattr_desc = {
	VOP_DELETEEXTATTR_DESCOFFSET,
	"vop_deleteextattr",
	0,
	vop_deleteextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_deleteextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_DELETEEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_deleteextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_deleteextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_cred = cred;
	assert_vop_elocked(vp, "vop_deleteextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_deleteextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const int vop_setextattr_vp_offsets[] = {
	VOPARG_OFFSETOF(struct vop_setextattr_args,a_vp),
	VDESC_NO_OFFSET
};
const struct vnodeop_desc vop_setextattr_desc = {
	VOP_SETEXTATTR_DESCOFFSET,
	"vop_setextattr",
	0,
	vop_setextattr_vp_offsets,
	VDESC_NO_OFFSET,
	VOPARG_OFFSETOF(struct vop_setextattr_args, a_cred),
	VDESC_NO_OFFSET,
};
int
VOP_SETEXTATTR(struct vnode *vp,
    int attrnamespace,
    const char *name,
    struct uio *uio,
    kauth_cred_t cred)
{
	int error;
	bool mpsafe;
	struct vop_setextattr_args a;
	struct mount *mp;
	a.a_desc = VDESC(vop_setextattr);
	a.a_vp = vp;
	a.a_attrnamespace = attrnamespace;
	a.a_name = name;
	a.a_uio = uio;
	a.a_cred = cred;
	assert_vop_elocked(vp, "vop_setextattr: vp");
	error = vop_pre(vp, &mp, &mpsafe, FST_NO);
	if (error)
		return error;
	error = (VCALL(vp, VOFFSET(vop_setextattr), &a));
	vop_post(vp, mp, mpsafe, FST_NO);
	return error;
}

const struct vnodeop_desc * const vfs_op_descs[] = {
	&vop_default_desc,	/* MUST BE FIRST */

	&vop_bwrite_desc,
	&vop_parsepath_desc,
	&vop_lookup_desc,
	&vop_create_desc,
	&vop_mknod_desc,
	&vop_open_desc,
	&vop_close_desc,
	&vop_access_desc,
	&vop_accessx_desc,
	&vop_getattr_desc,
	&vop_setattr_desc,
	&vop_read_desc,
	&vop_write_desc,
	&vop_fallocate_desc,
	&vop_fdiscard_desc,
	&vop_ioctl_desc,
	&vop_fcntl_desc,
	&vop_poll_desc,
	&vop_kqfilter_desc,
	&vop_revoke_desc,
	&vop_mmap_desc,
	&vop_fsync_desc,
	&vop_seek_desc,
	&vop_remove_desc,
	&vop_link_desc,
	&vop_rename_desc,
	&vop_mkdir_desc,
	&vop_rmdir_desc,
	&vop_symlink_desc,
	&vop_readdir_desc,
	&vop_readlink_desc,
	&vop_abortop_desc,
	&vop_inactive_desc,
	&vop_reclaim_desc,
	&vop_lock_desc,
	&vop_unlock_desc,
	&vop_bmap_desc,
	&vop_strategy_desc,
	&vop_print_desc,
	&vop_islocked_desc,
	&vop_pathconf_desc,
	&vop_advlock_desc,
	&vop_whiteout_desc,
	&vop_getpages_desc,
	&vop_putpages_desc,
	&vop_getacl_desc,
	&vop_setacl_desc,
	&vop_aclcheck_desc,
	&vop_closeextattr_desc,
	&vop_getextattr_desc,
	&vop_listextattr_desc,
	&vop_openextattr_desc,
	&vop_deleteextattr_desc,
	&vop_setextattr_desc,
	NULL
};
