# $NetBSD: directive-for-generating-endif.mk,v 1.1 2020/08/29 18:50:25 rillig Exp $
#
# Test whether a .for loop can be used to generate multiple .endif
# directives to close nested .if directives.  Depending on the exact
# implementation, this might have been possible.
#
# If it were possible, the 3 .if directives would perfectly match the
# 3 .endif directives generated by the .for loop.
#
# After the "included file" from the .for loop, the 3 .if directives
# are still open.
#
# See For_Run and ParseReadLine.  Each .for loop is treated like a separately
# included file, and in each included file the .if/.endif directives must be
# balanced.

.if 1
.  if 2
.    if 3
.for i in 3 2 1
.endif
.endfor

all:
	@:;
