/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { AbsoluteTime } from "@gnu-taler/taler-util";
import { FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "../context/ui-forms.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) =>({
  design: [
    {
      title:
        i18n.str`Declaration of identity of the beneficial owner`,
      fields: [
        {
          type: "textArea",
          properties: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`The contracting partner hereby declares that the person(s) listed below is/are the beneficial owner(s) of the assets involved in the business relationship. If the contracting partner is also the sole beneficial owner of the assets, the contracting partner's detail must be set out below`,
          },
        },
        {
          type: "array",
          properties: {
            label: i18n.str`Persons`,
            labelField: "surname",
            name: "persons",
            fields: [
              {
                type: "text",
                properties: {
                  name: "surname",
                  label: i18n.str`Surname(s)`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "firstName",
                  label: i18n.str`First name(s)`,
                },
              },
              {
                type: "absoluteTime",
                properties: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "text",
                properties: {
                  name: "address",
                  label: i18n.str`Actual address of domicile`,
                },
              },
            ],
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`The contracting partner hereby undertakes to inform automatically of any changes to the information contained herein`,
          },
        },
        {
          type: "text",
          properties: {
            name: "signature",
            label: i18n.str`Signature`,
          },
        },
        {
          type: "caption",
          properties: {
            label:
              i18n.str`It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)`,
          },
        },
      ],
    },
    resolutionSection(i18n),
  ],
  behavior: function formBehavior(
    // v: Partial<Form902_9.Form>,
  ): FormState<Form902_9.Form> {
    return {
    };
  },
});

namespace Form902_9 {
  interface Person {
    surname: string;
    firstName: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
    address: string;
  }
  export interface Form extends BaseForm {
    contractingPartner: string;
    persons: Person;
    signature: string;
  }
}
