# Esperanto (eo) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-a                                                        | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-a                                                           | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-a                                                        | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4-a                                                           | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-a                                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-a                                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-a kvaronjaro                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-a kvaronjaro                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                             | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-a                                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-a                                                           | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                            | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-a kvaronjaro                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-a kvaronjaro                                                | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-a                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-a                                                           | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                           | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | februaro                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julio                                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                             | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-a                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-a                                                           | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb                                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | jul                                                           | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | februaro                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | julio                                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                             | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-a                                                           | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-a                                                          | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-a                                                           | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-a                                                          | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-a                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-a                                                          | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-a                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-a                                                         | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | lundo                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredo                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | L                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lu                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-a                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-a                                                           | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | lundo                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredo                                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | L                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lu                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-a                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-a                                                           | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | lundo                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredo                                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | L                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lu                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-a                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-a                                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun                                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                           | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | lundo                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredo                                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | L                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lu                                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | antaŭtagmeze                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | antaŭtagmeze                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                             | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.t.m.                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.t.m.                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | antaŭtagmeze                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | antaŭtagmeze                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                             | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | matene                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vespere                                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nokte                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | matene                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vespere                                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nokte                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | matene                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vespere                                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nokte                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | matene                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vespere                                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nokte                                                         | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | matene                                                        | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | posttagmeze                                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | vespere                                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | nokte                                                         | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-a                                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-a                                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-a                                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-a                                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-a                                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-a                                                          | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-a                                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-a                                                          | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-a                                                           | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-a                                                          | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-a                                                           | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-a                                                          | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 1987-02-11                                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29                                                    | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 1987-feb-11                                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-maj-29                                                   | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 1987-februaro-11                                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-majo-29                                                  | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | merkredo, 11-a de februaro 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanĉo, 29-a de majo 1453                                    | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                         | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                      | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                                | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12-a horo kaj 13:14 GMT+00:00                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23-a horo kaj 59:59 GMT+00:00                                 | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 1987-02-11 12:13                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29 23:59                                              | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 1987-feb-11 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-maj-29 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 1987-februaro-11 12:13:14 GMT+0                               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-majo-29 23:59:59 GMT+0                                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | merkredo, 11-a de februaro 1987 12-a horo kaj 13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanĉo, 29-a de majo 1453 23-a horo kaj 59:59 GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result              | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | ------------------- | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | proksimume 6 jaroj  | proksimume 6 jaroj     | post proksimume 6 jaroj   |
| 2005-01-01T00:00:00.000Z | proksimume 5 jaroj  | proksimume 5 jaroj     | post proksimume 5 jaroj   |
| 2004-01-01T00:00:00.000Z | proksimume 4 jaroj  | proksimume 4 jaroj     | post proksimume 4 jaroj   |
| 2003-01-01T00:00:00.000Z | proksimume 3 jaroj  | proksimume 3 jaroj     | post proksimume 3 jaroj   |
| 2002-01-01T00:00:00.000Z | proksimume 2 jaroj  | proksimume 2 jaroj     | post proksimume 2 jaroj   |
| 2001-06-01T00:00:00.000Z | pli ol 1 jaro       | pli ol 1 jaro          | post pli ol 1 jaro        |
| 2001-02-01T00:00:00.000Z | proksimume 1 jaro   | proksimume 1 jaro      | post proksimume 1 jaro    |
| 2001-01-01T00:00:00.000Z | proksimume 1 jaro   | proksimume 1 jaro      | post proksimume 1 jaro    |
| 2000-06-01T00:00:00.000Z | 5 monatoj           | 5 monatoj              | post 5 monatoj            |
| 2000-03-01T00:00:00.000Z | 2 monatoj           | 2 monatoj              | post 2 monatoj            |
| 2000-02-01T00:00:00.000Z | proksimume 1 monato | proksimume 1 monato    | post proksimume 1 monato  |
| 2000-01-15T00:00:00.000Z | 14 tagoj            | 14 tagoj               | post 14 tagoj             |
| 2000-01-02T00:00:00.000Z | 1 tago              | 1 tago                 | post 1 tago               |
| 2000-01-01T06:00:00.000Z | proksimume 6 horoj  | proksimume 6 horoj     | post proksimume 6 horoj   |
| 2000-01-01T01:00:00.000Z | proksimume 1 horo   | proksimume 1 horo      | post proksimume 1 horo    |
| 2000-01-01T00:45:00.000Z | proksimume 1 horo   | proksimume 1 horo      | post proksimume 1 horo    |
| 2000-01-01T00:30:00.000Z | 30 minutoj          | 30 minutoj             | post 30 minutoj           |
| 2000-01-01T00:15:00.000Z | 15 minutoj          | 15 minutoj             | post 15 minutoj           |
| 2000-01-01T00:01:00.000Z | 1 minuto            | 1 minuto               | post 1 minuto             |
| 2000-01-01T00:00:25.000Z | malpli ol minuto    | duonminuto             | post malpli ol minuto     |
| 2000-01-01T00:00:15.000Z | malpli ol minuto    | malpli ol 20 sekundoj  | post malpli ol minuto     |
| 2000-01-01T00:00:05.000Z | malpli ol minuto    | malpli ol 10 sekundoj  | post malpli ol minuto     |
| 2000-01-01T00:00:00.000Z | malpli ol minuto    | malpli ol 5 sekundoj   | antaŭ malpli ol minuto    |
| 1999-12-31T23:59:55.000Z | malpli ol minuto    | malpli ol 10 sekundoj  | antaŭ malpli ol minuto    |
| 1999-12-31T23:59:45.000Z | malpli ol minuto    | malpli ol 20 sekundoj  | antaŭ malpli ol minuto    |
| 1999-12-31T23:59:35.000Z | malpli ol minuto    | duonminuto             | antaŭ malpli ol minuto    |
| 1999-12-31T23:59:00.000Z | 1 minuto            | 1 minuto               | antaŭ 1 minuto            |
| 1999-12-31T23:45:00.000Z | 15 minutoj          | 15 minutoj             | antaŭ 15 minutoj          |
| 1999-12-31T23:30:00.000Z | 30 minutoj          | 30 minutoj             | antaŭ 30 minutoj          |
| 1999-12-31T23:15:00.000Z | proksimume 1 horo   | proksimume 1 horo      | antaŭ proksimume 1 horo   |
| 1999-12-31T23:00:00.000Z | proksimume 1 horo   | proksimume 1 horo      | antaŭ proksimume 1 horo   |
| 1999-12-31T18:00:00.000Z | proksimume 6 horoj  | proksimume 6 horoj     | antaŭ proksimume 6 horoj  |
| 1999-12-30T00:00:00.000Z | 2 tagoj             | 2 tagoj                | antaŭ 2 tagoj             |
| 1999-12-15T00:00:00.000Z | 17 tagoj            | 17 tagoj               | antaŭ 17 tagoj            |
| 1999-12-01T00:00:00.000Z | proksimume 1 monato | proksimume 1 monato    | antaŭ proksimume 1 monato |
| 1999-11-01T00:00:00.000Z | 2 monatoj           | 2 monatoj              | antaŭ 2 monatoj           |
| 1999-06-01T00:00:00.000Z | 7 monatoj           | 7 monatoj              | antaŭ 7 monatoj           |
| 1999-01-01T00:00:00.000Z | proksimume 1 jaro   | proksimume 1 jaro      | antaŭ proksimume 1 jaro   |
| 1998-12-01T00:00:00.000Z | proksimume 1 jaro   | proksimume 1 jaro      | antaŭ proksimume 1 jaro   |
| 1998-06-01T00:00:00.000Z | pli ol 1 jaro       | pli ol 1 jaro          | antaŭ pli ol 1 jaro       |
| 1998-01-01T00:00:00.000Z | proksimume 2 jaroj  | proksimume 2 jaroj     | antaŭ proksimume 2 jaroj  |
| 1997-01-01T00:00:00.000Z | proksimume 3 jaroj  | proksimume 3 jaroj     | antaŭ proksimume 3 jaroj  |
| 1996-01-01T00:00:00.000Z | proksimume 4 jaroj  | proksimume 4 jaroj     | antaŭ proksimume 4 jaroj  |
| 1995-01-01T00:00:00.000Z | proksimume 5 jaroj  | proksimume 5 jaroj     | antaŭ proksimume 5 jaroj  |
| 1994-01-01T00:00:00.000Z | proksimume 6 jaroj  | proksimume 6 jaroj     | antaŭ proksimume 6 jaroj  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 jaroj     | post 6 jaroj      | 52608 horoj                    |
| 2005-01-01T00:00:00.000Z | 5 jaroj     | post 5 jaroj      | 43848 horoj                    |
| 2004-01-01T00:00:00.000Z | 4 jaroj     | post 4 jaroj      | 35064 horoj                    |
| 2003-01-01T00:00:00.000Z | 3 jaroj     | post 3 jaroj      | 26304 horoj                    |
| 2002-01-01T00:00:00.000Z | 2 jaroj     | post 2 jaroj      | 17544 horoj                    |
| 2001-06-01T00:00:00.000Z | 1 jaro      | post 1 jaro       | 12408 horoj                    |
| 2001-02-01T00:00:00.000Z | 1 jaro      | post 1 jaro       | 9528 horoj                     |
| 2001-01-01T00:00:00.000Z | 1 jaro      | post 1 jaro       | 8784 horoj                     |
| 2000-06-01T00:00:00.000Z | 5 monatoj   | post 5 monatoj    | 3648 horoj                     |
| 2000-03-01T00:00:00.000Z | 2 monatoj   | post 2 monatoj    | 1440 horoj                     |
| 2000-02-01T00:00:00.000Z | 1 monato    | post 1 monato     | 744 horoj                      |
| 2000-01-15T00:00:00.000Z | 14 tagoj    | post 14 tagoj     | 336 horoj                      |
| 2000-01-02T00:00:00.000Z | 1 tago      | post 1 tago       | 24 horoj                       |
| 2000-01-01T06:00:00.000Z | 6 horoj     | post 6 horoj      | 6 horoj                        |
| 2000-01-01T01:00:00.000Z | 1 horo      | post 1 horo       | 1 horo                         |
| 2000-01-01T00:45:00.000Z | 45 minutoj  | post 45 minutoj   | 1 horo                         |
| 2000-01-01T00:30:00.000Z | 30 minutoj  | post 30 minutoj   | 1 horo                         |
| 2000-01-01T00:15:00.000Z | 15 minutoj  | post 15 minutoj   | 0 horoj                        |
| 2000-01-01T00:01:00.000Z | 1 minuto    | post 1 minuto     | 0 horoj                        |
| 2000-01-01T00:00:25.000Z | 25 sekundoj | post 25 sekundoj  | 0 horoj                        |
| 2000-01-01T00:00:15.000Z | 15 sekundoj | post 15 sekundoj  | 0 horoj                        |
| 2000-01-01T00:00:05.000Z | 5 sekundoj  | post 5 sekundoj   | 0 horoj                        |
| 2000-01-01T00:00:00.000Z | 0 sekundoj  | antaŭ 0 sekundoj  | 0 horoj                        |
| 1999-12-31T23:59:55.000Z | 5 sekundoj  | antaŭ 5 sekundoj  | 0 horoj                        |
| 1999-12-31T23:59:45.000Z | 15 sekundoj | antaŭ 15 sekundoj | 0 horoj                        |
| 1999-12-31T23:59:35.000Z | 25 sekundoj | antaŭ 25 sekundoj | 0 horoj                        |
| 1999-12-31T23:59:00.000Z | 1 minuto    | antaŭ 1 minuto    | 0 horoj                        |
| 1999-12-31T23:45:00.000Z | 15 minutoj  | antaŭ 15 minutoj  | 0 horoj                        |
| 1999-12-31T23:30:00.000Z | 30 minutoj  | antaŭ 30 minutoj  | 1 horo                         |
| 1999-12-31T23:15:00.000Z | 45 minutoj  | antaŭ 45 minutoj  | 1 horo                         |
| 1999-12-31T23:00:00.000Z | 1 horo      | antaŭ 1 horo      | 1 horo                         |
| 1999-12-31T18:00:00.000Z | 6 horoj     | antaŭ 6 horoj     | 6 horoj                        |
| 1999-12-30T00:00:00.000Z | 2 tagoj     | antaŭ 2 tagoj     | 48 horoj                       |
| 1999-12-15T00:00:00.000Z | 17 tagoj    | antaŭ 17 tagoj    | 408 horoj                      |
| 1999-12-01T00:00:00.000Z | 1 monato    | antaŭ 1 monato    | 744 horoj                      |
| 1999-11-01T00:00:00.000Z | 2 monatoj   | antaŭ 2 monatoj   | 1464 horoj                     |
| 1999-06-01T00:00:00.000Z | 7 monatoj   | antaŭ 7 monatoj   | 5136 horoj                     |
| 1999-01-01T00:00:00.000Z | 1 jaro      | antaŭ 1 jaro      | 8760 horoj                     |
| 1998-12-01T00:00:00.000Z | 1 jaro      | antaŭ 1 jaro      | 9504 horoj                     |
| 1998-06-01T00:00:00.000Z | 2 jaroj     | antaŭ 2 jaroj     | 13896 horoj                    |
| 1998-01-01T00:00:00.000Z | 2 jaroj     | antaŭ 2 jaroj     | 17520 horoj                    |
| 1997-01-01T00:00:00.000Z | 3 jaroj     | antaŭ 3 jaroj     | 26280 horoj                    |
| 1996-01-01T00:00:00.000Z | 4 jaroj     | antaŭ 4 jaroj     | 35064 horoj                    |
| 1995-01-01T00:00:00.000Z | 5 jaroj     | antaŭ 5 jaroj     | 43824 horoj                    |
| 1994-01-01T00:00:00.000Z | 6 jaroj     | antaŭ 6 jaroj     | 52584 horoj                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 |
| ------------------------ | ---------------------- |
| 2000-01-10T00:00:00.000Z | 2000-01-10             |
| 2000-01-05T00:00:00.000Z | merkredo je 00:00      |
| 2000-01-02T00:00:00.000Z | morgaŭ je 00:00        |
| 2000-01-01T00:00:00.000Z | hodiaŭ je 00:00        |
| 1999-12-31T00:00:00.000Z | hieraŭ je 00:00        |
| 1999-12-27T00:00:00.000Z | pasinta lundo je 00:00 |
| 1999-12-21T00:00:00.000Z | 1999-12-21             |
