/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_deposit_confirmation_status.c
 * @brief Implementation of the update_deposit_confirmation_status function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_update_deposit_confirmation_status.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_update_deposit_confirmation_status (
  void *cls,
  uint64_t deposit_serial,
  bool retry_needed,
  struct GNUNET_TIME_Timestamp retry_time,
  uint32_t last_http_status,
  enum TALER_ErrorCode last_ec,
  const char *last_detail)
{
  struct PostgresClosure *pg = cls;
  uint32_t ec32 = (uint32_t) last_ec;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&deposit_serial),
    GNUNET_PQ_query_param_bool (retry_needed),
    GNUNET_PQ_query_param_timestamp (&retry_time),
    GNUNET_PQ_query_param_uint32 (&last_http_status),
    GNUNET_PQ_query_param_uint32 (&ec32),
    NULL == last_detail
    ? GNUNET_PQ_query_param_null ()
    : GNUNET_PQ_query_param_string (last_detail),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (pg,
           "update_deposit_confirmation_status",
           "UPDATE merchant_deposits SET"
           " settlement_retry_needed=$2"
           ",settlement_retry_time=$3"
           ",settlement_last_http_status=$4"
           ",settlement_last_ec=$5"
           ",settlement_last_detail=$6"
           " WHERE deposit_serial=$1;");
  return GNUNET_PQ_eval_prepared_non_select (
    pg->conn,
    "update_deposit_confirmation_status",
    params);
}
